(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[  19467537,     498943]*)
(*NotebookOutlinePosition[  19468179,     498965]*)
(*  CellTagsIndexPosition[  19468135,     498961]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(Plot3D[\(-20\)*Exp[\(-0.02\)*Sqrt[0.5*\((x*x + y*y)\)]] - 
        Exp[0.5*\((Cos[2*Pi*x] + Cos[2*Pi*y])\)] + 20 + Exp[1], {x, \(-10\), 
        10}, {y, \(-10\), 10}, PlotPoints\  \[Rule] 500, Mesh -> False, 
      ViewPoint -> {2.319, \ \(-1.888\), \ 1.583}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71645 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0193593 1.01936 -0.0955426 1.01936 [
[.01392 .3154 -18 -6.11414 ]
[.01392 .3154 0 2.88586 ]
[.09992 .24738 -12 -6.23638 ]
[.09992 .24738 0 2.76362 ]
[.19514 .17207 -6 -6.37866 ]
[.19514 .17207 0 2.62134 ]
[.30116 .08822 -6 -6.54635 ]
[.30116 .08822 0 2.45365 ]
[.41992 -0.00569 -12 -6.74689 ]
[.41992 -0.00569 0 2.25311 ]
[.43151 -0.01274 -8.86731 -9 ]
[.43151 -0.01274 9.13269 0 ]
[.5851 .06419 -6.13986 -9 ]
[.5851 .06419 5.86014 0 ]
[.72503 .13429 -3.17024 -9 ]
[.72503 .13429 2.82976 0 ]
[.85306 .19843 -3.25908 -9 ]
[.85306 .19843 2.74092 0 ]
[.97063 .25733 -6.67663 -9 ]
[.97063 .25733 5.32337 0 ]
[.98398 .26968 0 -6.84928 ]
[.98398 .26968 6 2.15072 ]
[.99296 .34829 0 -6.70815 ]
[.99296 .34829 6 2.29185 ]
[1.00226 .42984 0 -6.56275 ]
[1.00226 .42984 6 2.43725 ]
[ 0 0 0 0 ]
[ 1 .71645 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02592 .3197 m
.43132 0 L
s
.02592 .3197 m
.03191 .32185 L
s
[(-10)] .01392 .3154 1 .3587 Mshowa
.1118 .25197 m
.11775 .25426 L
s
[(-5)] .09992 .24738 1 .38586 Mshowa
.2069 .17698 m
.21278 .17943 L
s
[(0)] .19514 .17207 1 .41748 Mshowa
.31276 .0935 m
.31856 .09614 L
s
[(5)] .30116 .08822 1 .45474 Mshowa
.43132 0 m
.43702 .00285 L
s
[(10)] .41992 -0.00569 1 .49931 Mshowa
.125 Mabswid
.04242 .30668 m
.04601 .30799 L
s
.05925 .29341 m
.06284 .29473 L
s
.07642 .27987 m
.08 .28121 L
s
.09394 .26606 m
.09751 .26742 L
s
.13004 .23759 m
.1336 .23898 L
s
.14866 .22291 m
.15221 .22432 L
s
.16766 .20792 m
.17121 .20935 L
s
.18707 .19261 m
.19061 .19406 L
s
.22715 .16101 m
.23067 .1625 L
s
.24785 .14468 m
.25136 .1462 L
s
.26901 .128 m
.27251 .12954 L
s
.29064 .11094 m
.29413 .1125 L
s
.33538 .07566 m
.33885 .07726 L
s
.35854 .0574 m
.36199 .05903 L
s
.38223 .03871 m
.38567 .04037 L
s
.40648 .01959 m
.40992 .02127 L
s
.25 Mabswid
.43132 0 m
.97206 .26999 L
s
.43132 0 m
.43123 .00637 L
s
[(-10)] .43151 -0.01274 -0.01474 1 Mshowa
.5854 .07693 m
.58554 .0833 L
s
[(-5)] .5851 .06419 .02331 1 Mshowa
.72576 .14701 m
.72612 .15337 L
s
[(0)] .72503 .13429 .05675 1 Mshowa
.85415 .21112 m
.8547 .21747 L
s
[(5)] .85306 .19843 .08636 1 Mshowa
.97206 .26999 m
.97277 .27632 L
s
[(10)] .97063 .25733 .11277 1 Mshowa
.125 Mabswid
.46333 .01598 m
.4633 .0198 L
s
.49472 .03166 m
.49473 .03548 L
s
.52552 .04703 m
.52556 .05086 L
s
.55574 .06212 m
.5558 .06595 L
s
.6145 .09146 m
.61462 .09529 L
s
.64308 .10573 m
.64322 .10955 L
s
.67114 .11974 m
.67131 .12356 L
s
.69869 .1335 m
.69888 .13732 L
s
.75234 .16029 m
.75258 .1641 L
s
.77846 .17333 m
.77873 .17714 L
s
.80413 .18615 m
.80442 .18996 L
s
.82936 .19874 m
.82966 .20255 L
s
.87853 .2233 m
.87888 .2271 L
s
.9025 .23526 m
.90287 .23907 L
s
.92607 .24703 m
.92646 .25084 L
s
.94925 .25861 m
.94966 .26241 L
s
.25 Mabswid
.97206 .26999 m
1 .51778 L
s
.97269 .27558 m
.96704 .27853 L
s
[(0)] .98398 .26968 -1 .52206 Mshowa
.98152 .3539 m
.9758 .35671 L
s
[(2)] .99296 .34829 -1 .4907 Mshowa
.99068 .43515 m
.98489 .43781 L
s
[(4)] 1.00226 .42984 -1 .45839 Mshowa
.125 Mabswid
.97486 .29489 m
.97147 .29664 L
s
.97706 .31439 m
.97365 .31611 L
s
.97928 .33405 m
.97586 .33576 L
s
.98378 .37394 m
.98034 .3756 L
s
.98606 .39415 m
.9826 .39579 L
s
.98836 .41456 m
.98489 .41617 L
s
.99303 .45594 m
.98954 .45751 L
s
.99539 .47692 m
.9919 .47847 L
s
.99778 .49811 m
.99427 .49963 L
s
.25 Mabswid
.02592 .3197 m
0 .56085 L
s
0 .56085 m
.53339 .71645 L
s
.53339 .71645 m
.53142 .50102 L
s
.53142 .50102 m
.02592 .3197 L
s
.43132 0 m
.97206 .26999 L
s
.97206 .26999 m
1 .51778 L
s
1 .51778 m
.42718 .28067 L
s
.42718 .28067 m
.43132 0 L
s
.02592 .3197 m
0 .56085 L
s
0 .56085 m
.42718 .28067 L
s
.42718 .28067 m
.43132 0 L
s
.43132 0 m
.02592 .3197 L
s
.53142 .50102 m
.97206 .26999 L
s
.97206 .26999 m
1 .51778 L
s
1 .51778 m
.53339 .71645 L
s
.53339 .71645 m
.53142 .50102 L
s
0 0 m
1 0 L
1 .71645 L
0 .71645 L
closepath
clip
newpath
.637 .322 .422 r
.53172 .63267 .53261 .63168 .53338 .63261 .53249 .63358 Mtetra
.77 .505 .534 r
.53249 .63358 .53338 .63261 .53418 .63635 .53329 .63726 Mtetra
.796 .542 .554 r
.53329 .63726 .53418 .63635 .535 .64228 .53411 .64309 Mtetra
.806 .556 .561 r
.53411 .64309 .535 .64228 .53583 .64957 .53494 .65027 Mtetra
.811 .562 .561 r
.53494 .65027 .53583 .64957 .53668 .65734 .53578 .65791 Mtetra
.814 .563 .559 r
.53578 .65791 .53668 .65734 .53752 .66484 .53662 .66528 Mtetra
.815 .56 .553 r
.53662 .66528 .53752 .66484 .53836 .67153 .53746 .67186 Mtetra
.815 .553 .542 r
.53746 .67186 .53836 .67153 .53919 .67709 .53829 .67733 Mtetra
.812 .539 .524 r
.53829 .67733 .53919 .67709 .54001 .68139 .5391 .68155 Mtetra
.805 .511 .492 r
.5391 .68155 .54001 .68139 .54082 .6844 .53991 .68451 Mtetra
.783 .445 .416 r
.53991 .68451 .54082 .6844 .54161 .68617 .5407 .68624 Mtetra
.631 .149 .091 r
.5407 .68624 .54161 .68617 .5424 .68673 .54149 .68679 Mtetra
.739 .906 .952 r
.54149 .68679 .5424 .68673 .54317 .68613 .54226 .68618 Mtetra
.847 .759 .765 r
.54226 .68618 .54317 .68613 .54392 .68435 .54301 .68443 Mtetra
.851 .706 .701 r
.54301 .68443 .54392 .68435 .54467 .68138 .54376 .68148 Mtetra
.852 .681 .67 r
.54376 .68148 .54467 .68138 .5454 .67714 .54449 .67731 Mtetra
.852 .668 .653 r
.54449 .67731 .5454 .67714 .54611 .67162 .5452 .67186 Mtetra
.853 .66 .641 r
.5452 .67186 .54611 .67162 .54681 .66483 .5459 .66516 Mtetra
.854 .656 .634 r
.5459 .66516 .54681 .66483 .54749 .65693 .54659 .65737 Mtetra
.856 .655 .63 r
.54659 .65737 .54749 .65693 .54815 .64822 .54726 .64878 Mtetra
.859 .657 .628 r
.54726 .64878 .54815 .64822 .54882 .63927 .54793 .63996 Mtetra
.864 .664 .629 r
.54793 .63996 .54882 .63927 .54949 .63084 .5486 .63165 Mtetra
.874 .679 .635 r
.5486 .63165 .54949 .63084 .55017 .62381 .54928 .62471 Mtetra
.895 .718 .654 r
.54928 .62471 .55017 .62381 .55088 .61901 .55 .61997 Mtetra
.956 .899 .728 r
.55 .61997 .55088 .61901 .55163 .61705 .55074 .61804 Mtetra
.656 .344 .432 r
.55074 .61804 .55163 .61705 .55242 .61814 .55153 .6191 Mtetra
.774 .508 .533 r
.55153 .6191 .55242 .61814 .55325 .62203 .55236 .62292 Mtetra
.798 .543 .552 r
.55236 .62292 .55325 .62203 .55411 .62809 .55322 .62888 Mtetra
.808 .557 .558 r
.55322 .62888 .55411 .62809 .55499 .63546 .5541 .63613 Mtetra
.814 .562 .558 r
.5541 .63613 .55499 .63546 .55588 .64327 .55498 .64381 Mtetra
.816 .563 .555 r
.55498 .64381 .55588 .64327 .55677 .65077 .55587 .65119 Mtetra
.817 .559 .549 r
.55587 .65119 .55677 .65077 .55765 .65745 .55675 .65775 Mtetra
.817 .552 .538 r
.55675 .65775 .55765 .65745 .55852 .66298 .55761 .66319 Mtetra
.814 .537 .519 r
.55761 .66319 .55852 .66298 .55937 .66723 .55846 .66737 Mtetra
.807 .508 .484 r
.55846 .66737 .55937 .66723 .5602 .6702 .55929 .67029 Mtetra
.783 .437 .402 r
.55929 .67029 .5602 .6702 .56102 .67192 .56011 .67197 Mtetra
.605 .102 .03 r
.56011 .67197 .56102 .67192 .56181 .67244 .5609 .67247 Mtetra
.754 .893 .941 r
.5609 .67247 .56181 .67244 .5626 .67178 .56169 .67181 Mtetra
.847 .755 .761 r
.56169 .67181 .5626 .67178 .56336 .66994 .56245 .66999 Mtetra
.852 .704 .699 r
.56245 .66999 .56336 .66994 .5641 .6669 .5632 .66698 Mtetra
.853 .681 .668 r
.5632 .66698 .5641 .6669 .56483 .66259 .56392 .66273 Mtetra
.853 .668 .651 r
.56392 .66273 .56483 .66259 .56553 .65698 .56463 .6572 Mtetra
.854 .661 .64 r
.56463 .6572 .56553 .65698 .56621 .65011 .56531 .65042 Mtetra
.856 .657 .633 r
.56531 .65042 .56621 .65011 .56687 .64212 .56597 .64255 Mtetra
.858 .656 .628 r
.56597 .64255 .56687 .64212 .56752 .63336 .56662 .63391 Mtetra
.861 .658 .626 r
.56662 .63391 .56752 .63336 .56816 .62438 .56727 .62506 Mtetra
.867 .665 .628 r
.56727 .62506 .56816 .62438 .5688 .61597 .56792 .61676 Mtetra
.876 .681 .634 r
.56792 .61676 .5688 .61597 .56947 .609 .56859 .60989 Mtetra
.899 .722 .654 r
.56859 .60989 .56947 .609 .57018 .60432 .5693 .60527 Mtetra
.955 .924 .733 r
.5693 .60527 .57018 .60432 .57094 .60252 .57006 .60348 Mtetra
.672 .362 .441 r
.57006 .60348 .57094 .60252 .57175 .60377 .57087 .60471 Mtetra
.777 .51 .531 r
.57087 .60471 .57175 .60377 .57261 .60781 .57173 .60868 Mtetra
.801 .544 .549 r
.57173 .60868 .57261 .60781 .57351 .61399 .57262 .61475 Mtetra
.811 .557 .555 r
.57262 .61475 .57351 .61399 .57444 .62144 .57355 .62208 Mtetra
.816 .562 .555 r
.57355 .62208 .57444 .62144 .57538 .62929 .57448 .62981 Mtetra
.818 .562 .552 r
.57448 .62981 .57538 .62929 .57631 .63681 .57542 .6372 Mtetra
.819 .559 .545 r
.57542 .6372 .57631 .63681 .57724 .64346 .57634 .64375 Mtetra
.819 .551 .533 r
.57634 .64375 .57724 .64346 .57814 .64897 .57724 .64916 Mtetra
.816 .536 .514 r
.57724 .64916 .57814 .64897 .57903 .65319 .57812 .6533 Mtetra
.809 .505 .476 r
.57812 .6533 .57903 .65319 .57989 .65611 .57898 .65618 Mtetra
.783 .429 .387 r
.57898 .65618 .57989 .65611 .58072 .65779 .57981 .65782 Mtetra
.573 .048 0 r
.57981 .65782 .58072 .65779 .58154 .65826 .58063 .65827 Mtetra
.765 .881 .93 r
.58063 .65827 .58154 .65826 .58233 .65754 .58142 .65756 Mtetra
.847 .751 .758 r
.58142 .65756 .58233 .65754 .5831 .65565 .58219 .65568 Mtetra
.853 .703 .697 r
.58219 .65568 .5831 .65565 .58384 .65253 .58294 .6526 Mtetra
.854 .681 .667 r
.58294 .6526 .58384 .65253 .58456 .64815 .58366 .64828 Mtetra
.855 .668 .649 r
.58366 .64828 .58456 .64815 .58525 .64246 .58435 .64267 Mtetra
.856 .661 .638 r
.58435 .64267 .58525 .64246 .58592 .6355 .58502 .63581 Mtetra
.857 .657 .631 r
.58502 .63581 .58592 .6355 .58656 .62744 .58566 .62785 Mtetra
.86 .656 .626 r
.58566 .62785 .58656 .62744 .58718 .61862 .58629 .61916 Mtetra
.863 .659 .625 r
.58629 .61916 .58718 .61862 .58779 .60962 .58691 .61029 Mtetra
.869 .666 .626 r
.58691 .61029 .58779 .60962 .58842 .60123 .58754 .60201 Mtetra
.879 .683 .633 r
.58754 .60201 .58842 .60123 .58907 .59434 .58819 .59521 Mtetra
.902 .728 .655 r
.58819 .59521 .58907 .59434 .58978 .58978 .5889 .59071 Mtetra
.948 .95 .736 r
.5889 .59071 .58978 .58978 .59055 .58813 .58967 .58908 Mtetra
.686 .378 .447 r
.58967 .58908 .59055 .58813 .59138 .58954 .5905 .59046 Mtetra
.781 .512 .529 r
.5905 .59046 .59138 .58954 .59228 .59374 .5914 .59458 Mtetra
.803 .544 .547 r
.5914 .59458 .59228 .59374 .59322 .60004 .59234 .60078 Mtetra
.813 .557 .552 r
.59234 .60078 .59322 .60004 .5942 .60758 .59331 .6082 Mtetra
.818 .562 .552 r
.59331 .6082 .5942 .60758 .59519 .61547 .5943 .61597 Mtetra
.82 .562 .548 r
.5943 .61597 .59519 .61547 .59618 .623 .59528 .62337 Mtetra
.822 .558 .541 r
.59528 .62337 .59618 .623 .59714 .62965 .59624 .62991 Mtetra
.821 .55 .529 r
.59624 .62991 .59714 .62965 .59809 .63513 .59718 .63529 Mtetra
.819 .534 .508 r
.59718 .63529 .59809 .63513 .599 .63931 .59809 .63941 Mtetra
.811 .502 .468 r
.59809 .63941 .599 .63931 .59989 .6422 .59898 .64224 Mtetra
.782 .42 .371 r
.59898 .64224 .59989 .6422 .60075 .64383 .59984 .64384 Mtetra
.535 0 0 r
.59984 .64384 .60075 .64383 .60158 .64426 .60067 .64425 Mtetra
.773 .87 .919 r
.60067 .64425 .60158 .64426 .60238 .64349 .60147 .64349 Mtetra
.847 .748 .754 r
.60147 .64349 .60238 .64349 .60316 .64154 .60225 .64155 Mtetra
.853 .703 .695 r
.60225 .64155 .60316 .64154 .6039 .63836 .60299 .63841 Mtetra
.855 .681 .665 r
.60299 .63841 .6039 .63836 .60461 .6339 .60371 .63401 Mtetra
.856 .668 .648 r
.60371 .63401 .60461 .6339 .60529 .62813 .60439 .62832 Mtetra
.857 .661 .636 r
.60439 .62832 .60529 .62813 .60594 .62109 .60504 .62138 Mtetra
.859 .658 .629 r
.60504 .62138 .60594 .62109 .60656 .61296 .60566 .61336 Mtetra
.862 .657 .625 r
.60566 .61336 .60656 .61296 .60715 .60408 .60626 .60461 Mtetra
.865 .66 .623 r
.60626 .60461 .60715 .60408 .60774 .59506 .60686 .59572 Mtetra
.871 .667 .625 r
.60686 .59572 .60774 .59506 .60835 .5867 .60747 .58747 Mtetra
.882 .685 .632 r
.60747 .58747 .60835 .5867 .60899 .57988 .60811 .58075 Mtetra
.906 .733 .656 r
.60811 .58075 .60899 .57988 .60969 .57545 .60882 .57637 Mtetra
.928 .973 .733 r
.60882 .57637 .60969 .57545 .61047 .57396 .6096 .57489 Mtetra
.699 .392 .453 r
.6096 .57489 .61047 .57396 .61133 .57555 .61046 .57645 Mtetra
.785 .514 .527 r
.61046 .57645 .61133 .57555 .61227 .5799 .61139 .58072 Mtetra
.806 .545 .544 r
.61139 .58072 .61227 .5799 .61326 .58632 .61238 .58705 Mtetra
.815 .557 .549 r
.61238 .58705 .61326 .58632 .61429 .59395 .6134 .59455 Mtetra
.82 .562 .549 r
.6134 .59455 .61429 .59395 .61533 .6019 .61444 .60237 Mtetra
.823 .562 .545 r
.61444 .60237 .61533 .6019 .61636 .60944 .61547 .60979 Mtetra
.824 .558 .537 r
.61547 .60979 .61636 .60944 .61738 .61608 .61648 .61632 Mtetra
.823 .549 .524 r
.61648 .61632 .61738 .61608 .61836 .62154 .61745 .62168 Mtetra
.821 .533 .502 r
.61745 .62168 .61836 .62154 .61931 .6257 .6184 .62577 Mtetra
.813 .499 .459 r
.6184 .62577 .61931 .6257 .62022 .62855 .61931 .62857 Mtetra
.782 .411 .354 r
.61931 .62857 .62022 .62855 .6211 .63014 .62019 .63013 Mtetra
.491 0 0 r
.62019 .63013 .6211 .63014 .62195 .63052 .62104 .63049 Mtetra
.779 .859 .91 r
.62104 .63049 .62195 .63052 .62276 .62971 .62185 .62968 Mtetra
.847 .746 .752 r
.62185 .62968 .62276 .62971 .62354 .6277 .62263 .6277 Mtetra
.854 .702 .693 r
.62263 .6277 .62354 .6277 .62429 .62446 .62338 .62449 Mtetra
.856 .681 .663 r
.62338 .62449 .62429 .62446 .625 .61993 .62409 .62002 Mtetra
.858 .669 .646 r
.62409 .62002 .625 .61993 .62566 .61408 .62476 .61426 Mtetra
.859 .662 .634 r
.62476 .61426 .62566 .61408 .62629 .60696 .62539 .60724 Mtetra
.861 .658 .627 r
.62539 .60724 .62629 .60696 .62689 .59875 .62599 .59914 Mtetra
.864 .658 .623 r
.62599 .59914 .62689 .59875 .62746 .58982 .62657 .59034 Mtetra
.867 .661 .621 r
.62657 .59034 .62746 .58982 .62802 .58079 .62714 .58143 Mtetra
.873 .669 .623 r
.62714 .58143 .62802 .58079 .6286 .57245 .62773 .57321 Mtetra
.884 .687 .631 r
.62773 .57321 .6286 .57245 .62923 .56573 .62836 .56658 Mtetra
.911 .739 .657 r
.62836 .56658 .62923 .56573 .62994 .56142 .62907 .56233 Mtetra
.883 .986 .716 r
.62907 .56233 .62994 .56142 .63073 .5601 .62986 .56101 Mtetra
.711 .405 .457 r
.62986 .56101 .63073 .5601 .63162 .56186 .63075 .56274 Mtetra
.788 .516 .525 r
.63075 .56274 .63162 .56186 .63259 .56637 .63172 .56718 Mtetra
.808 .545 .541 r
.63172 .56718 .63259 .56637 .63364 .57293 .63276 .57363 Mtetra
.817 .557 .545 r
.63276 .57363 .63364 .57293 .63472 .58065 .63383 .58122 Mtetra
.822 .562 .545 r
.63383 .58122 .63472 .58065 .63581 .58865 .63492 .58909 Mtetra
.825 .561 .541 r
.63492 .58909 .63581 .58865 .6369 .59621 .636 .59654 Mtetra
.826 .557 .533 r
.636 .59654 .6369 .59621 .63796 .60285 .63706 .60306 Mtetra
.826 .548 .519 r
.63706 .60306 .63796 .60285 .63898 .60829 .63807 .60841 Mtetra
.823 .531 .495 r
.63807 .60841 .63898 .60829 .63996 .61242 .63905 .61247 Mtetra
.814 .496 .45 r
.63905 .61247 .63996 .61242 .6409 .61524 .64 .61524 Mtetra
.782 .402 .336 r
.64 .61524 .6409 .61524 .64181 .6168 .6409 .61677 Mtetra
.442 0 0 r
.6409 .61677 .64181 .6168 .64267 .61714 .64176 .61709 Mtetra
.783 .851 .902 r
.64176 .61709 .64267 .61714 .6435 .61629 .64259 .61624 Mtetra
.847 .744 .749 r
.64259 .61624 .6435 .61629 .64428 .61423 .64337 .6142 Mtetra
.855 .702 .691 r
.64337 .6142 .64428 .61423 .64503 .61092 .64412 .61094 Mtetra
.857 .681 .662 r
.64412 .61094 .64503 .61092 .64573 .60632 .64482 .6064 Mtetra
.859 .669 .644 r
.64482 .6064 .64573 .60632 .64638 .60039 .64548 .60056 Mtetra
.861 .662 .633 r
.64548 .60056 .64638 .60039 .64699 .5932 .64609 .59346 Mtetra
.863 .659 .625 r
.64609 .59346 .64699 .5932 .64756 .58492 .64667 .58529 Mtetra
.866 .659 .621 r
.64667 .58529 .64756 .58492 .6481 .57594 .64722 .57644 Mtetra
.87 .662 .619 r
.64722 .57644 .6481 .57594 .64864 .56689 .64776 .56752 Mtetra
.876 .67 .622 r
.64776 .56752 .64864 .56689 .64921 .55859 .64833 .55934 Mtetra
.887 .69 .63 r
.64833 .55934 .64921 .55859 .64982 .55195 .64895 .55279 Mtetra
.915 .746 .658 r
.64895 .55279 .64982 .55195 .65053 .54779 .64966 .54868 Mtetra
.797 .971 .673 r
.64966 .54868 .65053 .54779 .65134 .54663 .65047 .54753 Mtetra
.721 .416 .461 r
.65047 .54753 .65134 .54663 .65226 .54857 .65139 .54943 Mtetra
.792 .518 .523 r
.65139 .54943 .65226 .54857 .65327 .55325 .6524 .55403 Mtetra
.811 .546 .538 r
.6524 .55403 .65327 .55325 .65437 .55994 .65349 .56062 Mtetra
.82 .557 .542 r
.65349 .56062 .65437 .55994 .65551 .56776 .65463 .56831 Mtetra
.824 .561 .541 r
.65463 .56831 .65551 .56776 .65666 .57582 .65577 .57624 Mtetra
.827 .561 .537 r
.65577 .57624 .65666 .57582 .6578 .58341 .6569 .58371 Mtetra
.828 .557 .528 r
.6569 .58371 .6578 .58341 .6589 .59005 .658 .59024 Mtetra
.828 .547 .514 r
.658 .59024 .6589 .59005 .65997 .59547 .65906 .59557 Mtetra
.825 .529 .489 r
.65906 .59557 .65997 .59547 .66098 .59958 .66008 .59961 Mtetra
.816 .492 .441 r
.66008 .59961 .66098 .59958 .66196 .60238 .66105 .60236 Mtetra
.781 .392 .318 r
.66105 .60236 .66196 .60238 .66288 .60391 .66197 .60385 Mtetra
.39 0 0 r
.66197 .60385 .66288 .60391 .66376 .60421 .66285 .60414 Mtetra
.786 .843 .895 r
.66285 .60414 .66376 .60421 .6646 .60331 .66369 .60325 Mtetra
.848 .742 .747 r
.66369 .60325 .6646 .60331 .66539 .6012 .66448 .60116 Mtetra
.856 .701 .69 r
.66448 .60116 .66539 .6012 .66613 .59784 .66523 .59784 Mtetra
.859 .681 .66 r
.66523 .59784 .66613 .59784 .66683 .59317 .66592 .59323 Mtetra
.861 .669 .642 r
.66592 .59323 .66683 .59317 .66747 .58717 .66657 .58732 Mtetra
.863 .663 .631 r
.66657 .58732 .66747 .58717 .66806 .57989 .66716 .58014 Mtetra
.865 .66 .623 r
.66716 .58014 .66806 .57989 .6686 .57154 .66771 .57191 Mtetra
.868 .66 .619 r
.66771 .57191 .6686 .57154 .66912 .56252 .66824 .56302 Mtetra
.872 .663 .617 r
.66824 .56302 .66912 .56252 .66963 .55346 .66876 .55409 Mtetra
.878 .672 .62 r
.66876 .55409 .66963 .55346 .67017 .5452 .6693 .54594 Mtetra
.89 .693 .629 r
.6693 .54594 .67017 .5452 .67078 .53865 .66992 .53948 Mtetra
.92 .754 .66 r
.66992 .53948 .67078 .53865 .67149 .53463 .67063 .53551 Mtetra
.646 .903 .585 r
.67063 .53551 .67149 .53463 .67231 .53365 .67145 .53454 Mtetra
.731 .426 .463 r
.67145 .53454 .67231 .53365 .67327 .53577 .6724 .53662 Mtetra
.795 .519 .52 r
.6724 .53662 .67327 .53577 .67433 .54062 .67347 .54139 Mtetra
.814 .546 .535 r
.67347 .54139 .67433 .54062 .67548 .54746 .67461 .54812 Mtetra
.822 .557 .538 r
.67461 .54812 .67548 .54746 .67668 .55537 .6758 .5559 Mtetra
.827 .561 .537 r
.6758 .5559 .67668 .55537 .67789 .5635 .677 .5639 Mtetra
.829 .561 .533 r
.677 .5639 .67789 .5635 .67908 .57112 .67819 .5714 Mtetra
.83 .556 .524 r
.67819 .5714 .67908 .57112 .68023 .57777 .67934 .57794 Mtetra
.83 .546 .508 r
.67934 .57794 .68023 .57777 .68134 .58319 .68044 .58326 Mtetra
.827 .527 .482 r
.68044 .58326 .68134 .58319 .6824 .58728 .68149 .58729 Mtetra
.818 .489 .432 r
.68149 .58729 .6824 .58728 .6834 .59005 .68249 .59001 Mtetra
.78 .381 .299 r
.68249 .59001 .6834 .59005 .68435 .59155 .68344 .59148 Mtetra
.335 0 0 r
.68344 .59148 .68435 .59155 .68525 .59182 .68433 .59174 Mtetra
.789 .838 .889 r
.68433 .59174 .68525 .59182 .6861 .59089 .68518 .59081 Mtetra
.849 .741 .745 r
.68518 .59081 .6861 .59089 .68689 .58873 .68598 .58867 Mtetra
.857 .702 .688 r
.68598 .58867 .68689 .58873 .68763 .58531 .68673 .5853 Mtetra
.861 .681 .658 r
.68673 .5853 .68763 .58531 .68832 .58057 .68741 .58062 Mtetra
.863 .67 .64 r
.68741 .58062 .68832 .58057 .68895 .57449 .68805 .57463 Mtetra
.865 .664 .629 r
.68805 .57463 .68895 .57449 .68951 .56714 .68862 .56738 Mtetra
.867 .661 .621 r
.68862 .56738 .68951 .56714 .69003 .55872 .68915 .55908 Mtetra
.87 .661 .617 r
.68915 .55908 .69003 .55872 .69052 .54965 .68964 .55014 Mtetra
.874 .664 .615 r
.68964 .55014 .69052 .54965 .69101 .54059 .69014 .54121 Mtetra
.881 .674 .618 r
.69014 .54121 .69101 .54059 .69153 .53237 .69066 .5331 Mtetra
.894 .696 .628 r
.69066 .5331 .69153 .53237 .69213 .52592 .69127 .52674 Mtetra
.925 .763 .662 r
.69127 .52674 .69213 .52592 .69284 .52204 .69198 .52292 Mtetra
0 0 0 r
.69198 .52292 .69284 .52204 .69369 .52124 .69283 .52212 Mtetra
.739 .435 .466 r
.69283 .52212 .69369 .52124 .69468 .52356 .69382 .52439 Mtetra
.798 .521 .518 r
.69382 .52439 .69468 .52356 .69579 .52858 .69493 .52934 Mtetra
.816 .547 .531 r
.69493 .52934 .69579 .52858 .697 .53556 .69613 .5362 Mtetra
.824 .557 .535 r
.69613 .5362 .697 .53556 .69826 .54358 .69738 .5441 Mtetra
.829 .561 .534 r
.69738 .5441 .69826 .54358 .69952 .55177 .69864 .55216 Mtetra
.831 .56 .528 r
.69864 .55216 .69952 .55177 .70077 .55943 .69988 .55969 Mtetra
.833 .555 .519 r
.69988 .55969 .70077 .55943 .70198 .56609 .70108 .56624 Mtetra
.832 .545 .503 r
.70108 .56624 .70198 .56609 .70313 .57151 .70223 .57157 Mtetra
.829 .525 .476 r
.70223 .57157 .70313 .57151 .70422 .57559 .70332 .57558 Mtetra
.819 .485 .422 r
.70332 .57558 .70422 .57559 .70526 .57835 .70435 .57829 Mtetra
.778 .371 .28 r
.70435 .57829 .70526 .57835 .70623 .57982 .70532 .57973 Mtetra
.282 0 0 r
.70532 .57973 .70623 .57982 .70715 .58006 .70623 .57996 Mtetra
.791 .834 .885 r
.70623 .57996 .70715 .58006 .70801 .57909 .7071 .579 Mtetra
.85 .741 .743 r
.7071 .579 .70801 .57909 .70881 .57689 .7079 .57682 Mtetra
.859 .702 .686 r
.7079 .57682 .70881 .57689 .70955 .57341 .70864 .57339 Mtetra
.863 .682 .657 r
.70864 .57339 .70955 .57341 .71023 .5686 .70932 .56865 Mtetra
.865 .671 .638 r
.70932 .56865 .71023 .5686 .71084 .56245 .70994 .56258 Mtetra
.867 .665 .626 r
.70994 .56258 .71084 .56245 .71139 .55502 .71049 .55526 Mtetra
.87 .662 .619 r
.71049 .55526 .71139 .55502 .71188 .54653 .71099 .54689 Mtetra
.873 .662 .614 r
.71099 .54689 .71188 .54653 .71234 .53742 .71146 .53791 Mtetra
.877 .666 .613 r
.71146 .53791 .71234 .53742 .7128 .52835 .71193 .52896 Mtetra
.884 .676 .616 r
.71193 .52896 .7128 .52835 .7133 .52017 .71244 .52091 Mtetra
.898 .7 .627 r
.71244 .52091 .7133 .52017 .71389 .51382 .71303 .51465 Mtetra
.931 .774 .664 r
.71303 .51465 .71389 .51382 .71461 .5101 .71375 .51097 Mtetra
0 0 0 r
.71375 .51097 .71461 .5101 .71548 .50948 .71463 .51035 Mtetra
.747 .442 .467 r
.71463 .51035 .71548 .50948 .71651 .51199 .71565 .51282 Mtetra
.801 .522 .515 r
.71565 .51282 .71651 .51199 .71768 .5172 .71681 .51794 Mtetra
.818 .547 .528 r
.71681 .51794 .71768 .5172 .71894 .52433 .71807 .52496 Mtetra
.827 .557 .531 r
.71807 .52496 .71894 .52433 .72026 .53246 .71939 .53296 Mtetra
.831 .56 .529 r
.71939 .53296 .72026 .53246 .7216 .54072 .72071 .54109 Mtetra
.834 .559 .524 r
.72071 .54109 .7216 .54072 .7229 .54842 .72201 .54867 Mtetra
.835 .554 .514 r
.72201 .54867 .7229 .54842 .72416 .5551 .72326 .55524 Mtetra
.834 .544 .497 r
.72326 .55524 .72416 .5551 .72536 .56052 .72446 .56056 Mtetra
.831 .523 .469 r
.72446 .56056 .72536 .56052 .72649 .56459 .72558 .56457 Mtetra
.821 .481 .413 r
.72558 .56457 .72649 .56459 .72756 .56733 .72664 .56726 Mtetra
.776 .36 .262 r
.72664 .56726 .72756 .56733 .72856 .56878 .72764 .56869 Mtetra
.232 0 0 r
.72764 .56869 .72856 .56878 .72949 .569 .72858 .56889 Mtetra
.794 .832 .881 r
.72858 .56889 .72949 .569 .73037 .56799 .72945 .56789 Mtetra
.852 .742 .742 r
.72945 .56789 .73037 .56799 .73117 .56574 .73026 .56567 Mtetra
.861 .703 .685 r
.73026 .56567 .73117 .56574 .73191 .5622 .731 .56218 Mtetra
.865 .683 .655 r
.731 .56218 .73191 .5622 .73258 .55733 .73168 .55737 Mtetra
.867 .672 .636 r
.73168 .55737 .73258 .55733 .73318 .5511 .73228 .55123 Mtetra
.87 .666 .624 r
.73228 .55123 .73318 .5511 .7337 .54359 .73281 .54383 Mtetra
.872 .663 .616 r
.73281 .54383 .7337 .54359 .73417 .53504 .73328 .5354 Mtetra
.875 .663 .612 r
.73328 .5354 .73417 .53504 .7346 .52588 .73372 .52637 Mtetra
.88 .668 .611 r
.73372 .52637 .7346 .52588 .73503 .5168 .73416 .51742 Mtetra
.887 .678 .614 r
.73416 .51742 .73503 .5168 .73551 .50867 .73465 .50941 Mtetra
.902 .704 .626 r
.73465 .50941 .73551 .50867 .73609 .50243 .73524 .50325 Mtetra
.938 .786 .667 r
.73524 .50325 .73609 .50243 .73682 .49886 .73597 .49973 Mtetra
.047 0 0 r
.73597 .49973 .73682 .49886 .73772 .49843 .73687 .4993 Mtetra
.754 .449 .468 r
.73687 .4993 .73772 .49843 .73879 .50114 .73794 .50196 Mtetra
.804 .523 .512 r
.73794 .50196 .73879 .50114 .74001 .50653 .73915 .50726 Mtetra
.821 .547 .524 r
.73915 .50726 .74001 .50653 .74134 .51381 .74048 .51443 Mtetra
.829 .557 .527 r
.74048 .51443 .74134 .51381 .74273 .52206 .74186 .52255 Mtetra
.833 .56 .525 r
.74186 .52255 .74273 .52206 .74413 .5304 .74325 .53076 Mtetra
.836 .559 .519 r
.74325 .53076 .74413 .5304 .7455 .53814 .74461 .53838 Mtetra
.837 .553 .509 r
.74461 .53838 .7455 .53814 .74681 .54484 .74591 .54497 Mtetra
.836 .542 .491 r
.74591 .54497 .74681 .54484 .74806 .55026 .74715 .5503 Mtetra
.833 .521 .462 r
.74715 .5503 .74806 .55026 .74923 .55433 .74832 .5543 Mtetra
.821 .476 .403 r
.74832 .5543 .74923 .55433 .75033 .55705 .74941 .55698 Mtetra
.772 .349 .244 r
.74941 .55698 .75033 .55705 .75135 .55849 .75044 .55838 Mtetra
.184 0 0 r
.75044 .55838 .75135 .55849 .75231 .55868 .75139 .55856 Mtetra
.797 .832 .878 r
.75139 .55856 .75231 .55868 .75319 .55763 .75228 .55753 Mtetra
.854 .743 .74 r
.75228 .55753 .75319 .55763 .75401 .55533 .75309 .55526 Mtetra
.864 .705 .683 r
.75309 .55526 .75401 .55533 .75474 .55174 .75384 .55171 Mtetra
.867 .685 .653 r
.75384 .55171 .75474 .55174 .7554 .54679 .7545 .54684 Mtetra
.87 .673 .634 r
.7545 .54684 .7554 .54679 .75598 .54049 .75508 .54062 Mtetra
.872 .667 .622 r
.75508 .54062 .75598 .54049 .75648 .5329 .75559 .53314 Mtetra
.875 .664 .614 r
.75559 .53314 .75648 .5329 .75692 .52427 .75604 .52463 Mtetra
.878 .665 .61 r
.75604 .52463 .75692 .52427 .75732 .51506 .75645 .51556 Mtetra
.883 .669 .609 r
.75645 .51556 .75732 .51506 .75773 .50597 .75686 .50661 Mtetra
.891 .681 .612 r
.75686 .50661 .75773 .50597 .75819 .49789 .75733 .49864 Mtetra
.906 .709 .625 r
.75733 .49864 .75819 .49789 .75876 .49176 .75792 .49259 Mtetra
.945 .8 .669 r
.75792 .49259 .75876 .49176 .7595 .48834 .75866 .48922 Mtetra
.22 0 .026 r
.75866 .48922 .7595 .48834 .76043 .4881 .75958 .48898 Mtetra
.76 .455 .469 r
.75958 .48898 .76043 .4881 .76155 .49101 .7607 .49184 Mtetra
.807 .524 .509 r
.7607 .49184 .76155 .49101 .76283 .49659 .76197 .49733 Mtetra
.823 .547 .521 r
.76197 .49733 .76283 .49659 .76423 .50403 .76336 .50465 Mtetra
.831 .556 .523 r
.76336 .50465 .76423 .50403 .76568 .5124 .76481 .51289 Mtetra
.835 .559 .521 r
.76481 .51289 .76568 .5124 .76715 .52081 .76627 .52117 Mtetra
.837 .558 .515 r
.76627 .52117 .76715 .52081 .76858 .5286 .76769 .52884 Mtetra
.838 .552 .504 r
.76769 .52884 .76858 .5286 .76995 .53533 .76906 .53545 Mtetra
.838 .54 .486 r
.76906 .53545 .76995 .53533 .77125 .54075 .77035 .54079 Mtetra
.834 .518 .455 r
.77035 .54079 .77125 .54075 .77246 .54482 .77155 .54478 Mtetra
.821 .471 .393 r
.77155 .54478 .77246 .54482 .77359 .54753 .77268 .54745 Mtetra
.768 .337 .226 r
.77268 .54745 .77359 .54753 .77465 .54895 .77373 .54884 Mtetra
.139 0 0 r
.77373 .54884 .77465 .54895 .77562 .54911 .77471 .54899 Mtetra
.801 .833 .876 r
.77471 .54899 .77562 .54911 .77652 .54802 .77561 .54792 Mtetra
.857 .745 .739 r
.77561 .54792 .77652 .54802 .77734 .54568 .77643 .54561 Mtetra
.867 .706 .681 r
.77643 .54561 .77734 .54568 .77808 .54202 .77717 .542 Mtetra
.87 .686 .651 r
.77717 .542 .77808 .54202 .77872 .537 .77782 .53705 Mtetra
.873 .675 .632 r
.77782 .53705 .77872 .537 .77928 .53061 .77839 .53075 Mtetra
.875 .668 .619 r
.77839 .53075 .77928 .53061 .77976 .52294 .77887 .52319 Mtetra
.878 .666 .611 r
.77887 .52319 .77976 .52294 .78017 .51423 .77929 .51461 Mtetra
.882 .666 .607 r
.77929 .51461 .78017 .51423 .78054 .50497 .77967 .50549 Mtetra
.887 .671 .606 r
.77967 .50549 .78054 .50497 .78091 .49588 .78006 .49652 Mtetra
.895 .684 .61 r
.78006 .49652 .78091 .49588 .78136 .48784 .78051 .4886 Mtetra
.911 .714 .623 r
.78051 .4886 .78136 .48784 .78193 .48181 .78109 .48265 Mtetra
.952 .816 .672 r
.78109 .48265 .78193 .48181 .78268 .47856 .78184 .47944 Mtetra
.345 0 .123 r
.78184 .47944 .78268 .47856 .78364 .47851 .7828 .47939 Mtetra
.765 .46 .469 r
.7828 .47939 .78364 .47851 .7848 .48162 .78396 .48245 Mtetra
.809 .525 .507 r
.78396 .48245 .7848 .48162 .78615 .48739 .7853 .48813 Mtetra
.825 .546 .517 r
.7853 .48813 .78615 .48739 .78762 .49499 .78676 .49561 Mtetra
.833 .555 .519 r
.78676 .49561 .78762 .49499 .78915 .50347 .78828 .50396 Mtetra
.837 .558 .517 r
.78828 .50396 .78915 .50347 .79069 .51197 .78981 .51233 Mtetra
.839 .556 .51 r
.78981 .51233 .79069 .51197 .79219 .51981 .7913 .52004 Mtetra
.84 .55 .499 r
.7913 .52004 .79219 .51981 .79362 .52656 .79272 .52668 Mtetra
.839 .538 .48 r
.79272 .52668 .79362 .52656 .79496 .53199 .79406 .53203 Mtetra
.835 .515 .447 r
.79406 .53203 .79496 .53199 .79622 .53605 .79531 .53602 Mtetra
.821 .466 .384 r
.79531 .53602 .79622 .53605 .79739 .53875 .79647 .53868 Mtetra
.763 .324 .209 r
.79647 .53868 .79739 .53875 .79847 .54015 .79755 .54005 Mtetra
.096 0 0 r
.79755 .54005 .79847 .54015 .79946 .54028 .79855 .54017 Mtetra
.806 .835 .873 r
.79855 .54017 .79946 .54028 .80038 .53916 .79946 .53906 Mtetra
.86 .748 .737 r
.79946 .53906 .80038 .53916 .8012 .53676 .80029 .53669 Mtetra
.87 .709 .68 r
.80029 .53669 .8012 .53676 .80193 .53304 .80103 .53302 Mtetra
.874 .688 .648 r
.80103 .53302 .80193 .53304 .80257 .52794 .80167 .528 Mtetra
.876 .677 .629 r
.80167 .528 .80257 .52794 .80311 .52146 .80222 .52161 Mtetra
.879 .67 .616 r
.80222 .52161 .80311 .52146 .80356 .51369 .80268 .51396 Mtetra
.881 .667 .608 r
.80268 .51396 .80356 .51369 .80394 .5049 .80307 .5053 Mtetra
.885 .668 .604 r
.80307 .5053 .80394 .5049 .80428 .49559 .80341 .49612 Mtetra
.89 .674 .603 r
.80341 .49612 .80428 .49559 .80462 .48648 .80377 .48714 Mtetra
.899 .687 .607 r
.80377 .48714 .80462 .48648 .80505 .47849 .80421 .47927 Mtetra
.916 .72 .622 r
.80421 .47927 .80505 .47849 .80561 .47256 .80478 .47342 Mtetra
.96 .834 .675 r
.80478 .47342 .80561 .47256 .80638 .46947 .80555 .47037 Mtetra
.433 .041 .193 r
.80555 .47037 .80638 .46947 .80737 .46962 .80654 .47051 Mtetra
.77 .464 .469 r
.80654 .47051 .80737 .46962 .80859 .47293 .80776 .47377 Mtetra
.812 .525 .503 r
.80776 .47377 .80859 .47293 .81001 .47889 .80916 .47964 Mtetra
.827 .546 .513 r
.80916 .47964 .81001 .47889 .81155 .48665 .8107 .48728 Mtetra
.834 .555 .515 r
.8107 .48728 .81155 .48665 .81316 .49525 .8123 .49575 Mtetra
.839 .557 .512 r
.8123 .49575 .81316 .49525 .81477 .50383 .8139 .50419 Mtetra
.841 .555 .505 r
.8139 .50419 .81477 .50383 .81634 .51172 .81545 .51196 Mtetra
.841 .548 .493 r
.81545 .51196 .81634 .51172 .81783 .51849 .81694 .51862 Mtetra
.84 .536 .474 r
.81694 .51862 .81783 .51849 .81923 .52393 .81833 .52398 Mtetra
.835 .511 .44 r
.81833 .52398 .81923 .52393 .82053 .52799 .81962 .52796 Mtetra
.82 .46 .374 r
.81962 .52796 .82053 .52799 .82173 .53068 .82082 .53061 Mtetra
.756 .31 .191 r
.82082 .53061 .82173 .53068 .82284 .53205 .82193 .53195 Mtetra
0 .531 .72 r
.82193 .53195 .82284 .53205 .82386 .53215 .82294 .53205 Mtetra
.811 .839 .871 r
.82294 .53205 .82386 .53215 .82478 .53098 .82387 .53089 Mtetra
.865 .751 .736 r
.82387 .53089 .82478 .53098 .82561 .52853 .8247 .52847 Mtetra
.874 .711 .677 r
.8247 .52847 .82561 .52853 .82634 .52473 .82544 .52473 Mtetra
.877 .69 .646 r
.82544 .52473 .82634 .52473 .82697 .51955 .82607 .51962 Mtetra
.88 .678 .626 r
.82607 .51962 .82697 .51955 .82749 .51297 .8266 .51314 Mtetra
.882 .672 .613 r
.8266 .51314 .82749 .51297 .82791 .50511 .82703 .50539 Mtetra
.885 .669 .605 r
.82703 .50539 .82791 .50511 .82826 .49624 .82739 .49665 Mtetra
.889 .67 .601 r
.82739 .49665 .82826 .49624 .82856 .48686 .8277 .48741 Mtetra
.894 .676 .6 r
.8277 .48741 .82856 .48686 .82888 .47774 .82803 .47842 Mtetra
.903 .69 .604 r
.82803 .47842 .82888 .47774 .82928 .46979 .82845 .47059 Mtetra
.922 .726 .62 r
.82845 .47059 .82928 .46979 .82985 .46396 .82902 .46484 Mtetra
.968 .855 .676 r
.82902 .46484 .82985 .46396 .83063 .46103 .82981 .46195 Mtetra
.497 .114 .244 r
.82981 .46195 .83063 .46103 .83166 .46137 .83084 .46228 Mtetra
.774 .468 .469 r
.83084 .46228 .83166 .46137 .83294 .46489 .83211 .46574 Mtetra
.814 .525 .5 r
.83211 .46574 .83294 .46489 .83442 .47104 .83358 .4718 Mtetra
.829 .545 .509 r
.83358 .4718 .83442 .47104 .83604 .47896 .8352 .47959 Mtetra
.836 .554 .511 r
.8352 .47959 .83604 .47896 .83773 .48768 .83687 .48818 Mtetra
.84 .556 .507 r
.83687 .48818 .83773 .48768 .83942 .49634 .83855 .49671 Mtetra
.842 .554 .5 r
.83855 .49671 .83942 .49634 .84106 .50428 .84018 .50452 Mtetra
.843 .547 .488 r
.84018 .50452 .84106 .50428 .84262 .51107 .84172 .51121 Mtetra
.841 .533 .467 r
.84172 .51121 .84262 .51107 .84407 .51652 .84317 .51657 Mtetra
.836 .507 .432 r
.84317 .51657 .84407 .51652 .84541 .52057 .84451 .52055 Mtetra
.819 .453 .364 r
.84451 .52055 .84541 .52057 .84666 .52324 .84574 .52318 Mtetra
.749 .295 .173 r
.84574 .52318 .84666 .52324 .84779 .52459 .84688 .5245 Mtetra
0 .567 .748 r
.84688 .5245 .84779 .52459 .84883 .52465 .84792 .52456 Mtetra
.818 .843 .868 r
.84792 .52456 .84883 .52465 .84977 .52344 .84886 .52336 Mtetra
.869 .754 .733 r
.84886 .52336 .84977 .52344 .8506 .52092 .84969 .52088 Mtetra
.878 .714 .675 r
.84969 .52088 .8506 .52092 .85133 .51705 .85043 .51706 Mtetra
.881 .693 .643 r
.85043 .51706 .85133 .51705 .85194 .51177 .85105 .51186 Mtetra
.884 .681 .623 r
.85105 .51186 .85194 .51177 .85244 .5051 .85155 .50528 Mtetra
.886 .674 .61 r
.85155 .50528 .85244 .5051 .85283 .49713 .85196 .49743 Mtetra
.889 .671 .602 r
.85196 .49743 .85283 .49713 .85314 .48816 .85228 .48859 Mtetra
.892 .672 .597 r
.85228 .48859 .85314 .48816 .85341 .47872 .85256 .47929 Mtetra
.898 .679 .597 r
.85256 .47929 .85341 .47872 .8537 .46957 .85286 .47028 Mtetra
.908 .694 .601 r
.85286 .47028 .8537 .46957 .85409 .46166 .85326 .46248 Mtetra
.928 .733 .618 r
.85326 .46248 .85409 .46166 .85465 .45594 .85383 .45684 Mtetra
.974 .877 .677 r
.85383 .45684 .85465 .45594 .85545 .45316 .85463 .4541 Mtetra
.543 .169 .281 r
.85463 .4541 .85545 .45316 .85652 .4537 .85571 .45462 Mtetra
.778 .471 .468 r
.85571 .45462 .85652 .4537 .85786 .45742 .85704 .45829 Mtetra
.816 .525 .497 r
.85704 .45829 .85786 .45742 .85942 .46376 .85859 .46453 Mtetra
.831 .545 .505 r
.85859 .46453 .85942 .46376 .86113 .47184 .86028 .47249 Mtetra
.838 .553 .506 r
.86028 .47249 .86113 .47184 .8629 .48068 .86204 .48119 Mtetra
.842 .555 .503 r
.86204 .48119 .8629 .48068 .86467 .48942 .8638 .4898 Mtetra
.844 .552 .495 r
.8638 .4898 .86467 .48942 .86638 .49741 .8655 .49766 Mtetra
.844 .544 .482 r
.8655 .49766 .86638 .49741 .868 .50422 .86711 .50437 Mtetra
.842 .53 .461 r
.86711 .50437 .868 .50422 .86951 .50968 .86861 .50974 Mtetra
.836 .503 .425 r
.86861 .50974 .86951 .50968 .8709 .51372 .87 .51371 Mtetra
.817 .446 .353 r
.87 .51371 .8709 .51372 .87218 .51637 .87127 .51632 Mtetra
.74 .279 .154 r
.87127 .51632 .87218 .51637 .87335 .51769 .87244 .51761 Mtetra
.037 .604 .775 r
.87244 .51761 .87335 .51769 .87441 .51771 .8735 .51763 Mtetra
.825 .847 .864 r
.8735 .51763 .87441 .51771 .87536 .51644 .87445 .51638 Mtetra
.874 .758 .731 r
.87445 .51638 .87536 .51644 .8762 .51386 .87529 .51383 Mtetra
.882 .717 .672 r
.87529 .51383 .8762 .51386 .87692 .5099 .87602 .50993 Mtetra
.885 .695 .64 r
.87602 .50993 .87692 .5099 .87752 .50453 .87662 .50464 Mtetra
.888 .683 .62 r
.87662 .50464 .87752 .50453 .87799 .49774 .87711 .49795 Mtetra
.89 .676 .607 r
.87711 .49795 .87799 .49774 .87835 .48966 .87748 .48999 Mtetra
.893 .673 .598 r
.87748 .48999 .87835 .48966 .87863 .48059 .87777 .48105 Mtetra
.897 .674 .594 r
.87777 .48105 .87863 .48059 .87886 .47108 .87801 .47168 Mtetra
.903 .681 .593 r
.87801 .47168 .87886 .47108 .87911 .46191 .87828 .46264 Mtetra
.913 .698 .598 r
.87828 .46264 .87911 .46191 .87948 .45404 .87866 .45488 Mtetra
.935 .74 .616 r
.87866 .45488 .87948 .45404 .88004 .44841 .87923 .44934 Mtetra
.977 .9 .675 r
.87923 .44934 .88004 .44841 .88087 .44579 .88006 .44676 Mtetra
.579 .212 .309 r
.88006 .44676 .88087 .44579 .88199 .44652 .88118 .44747 Mtetra
.781 .473 .466 r
.88118 .44747 .88199 .44652 .88339 .45045 .88257 .45134 Mtetra
.818 .525 .493 r
.88257 .45134 .88339 .45045 .88503 .45698 .8842 .45777 Mtetra
.832 .544 .501 r
.8842 .45777 .88503 .45698 .88682 .46522 .88598 .46588 Mtetra
.84 .551 .501 r
.88598 .46588 .88682 .46522 .88868 .47418 .88783 .4747 Mtetra
.843 .553 .497 r
.88783 .4747 .88868 .47418 .89053 .483 .88967 .48339 Mtetra
.845 .55 .489 r
.88967 .48339 .89053 .483 .89232 .49103 .89144 .49129 Mtetra
.845 .542 .476 r
.89144 .49129 .89232 .49103 .89401 .49787 .89312 .49802 Mtetra
.843 .527 .454 r
.89312 .49802 .89401 .49787 .89557 .50332 .89468 .50339 Mtetra
.836 .498 .416 r
.89468 .50339 .89557 .50332 .89701 .50735 .89611 .50735 Mtetra
.815 .438 .342 r
.89611 .50735 .89701 .50735 .89833 .50998 .89742 .50994 Mtetra
.73 .261 .134 r
.89742 .50994 .89833 .50998 .89953 .51126 .89862 .5112 Mtetra
.085 .641 .801 r
.89862 .5112 .89953 .51126 .90061 .51124 .8997 .51118 Mtetra
.833 .852 .86 r
.8997 .51118 .90061 .51124 .90157 .50992 .90067 .50987 Mtetra
.879 .762 .728 r
.90067 .50987 .90157 .50992 .90242 .50726 .90151 .50725 Mtetra
.887 .72 .669 r
.90151 .50725 .90242 .50726 .90313 .50321 .90223 .50326 Mtetra
.89 .698 .636 r
.90223 .50326 .90313 .50321 .90371 .49774 .90282 .49786 Mtetra
.892 .685 .616 r
.90282 .49786 .90371 .49774 .90416 .49083 .90328 .49106 Mtetra
.894 .678 .603 r
.90328 .49106 .90416 .49083 .90449 .48263 .90362 .48298 Mtetra
.897 .675 .594 r
.90362 .48298 .90449 .48263 .90472 .47345 .90387 .47394 Mtetra
.901 .677 .59 r
.90387 .47394 .90472 .47345 .90492 .46386 .90408 .46449 Mtetra
.907 .684 .589 r
.90408 .46449 .90492 .46386 .90514 .45467 .90432 .45543 Mtetra
.918 .702 .594 r
.90432 .45543 .90514 .45467 .90549 .44683 .90468 .4477 Mtetra
.942 .748 .613 r
.90468 .4477 .90549 .44683 .90605 .4413 .90525 .44226 Mtetra
.974 .923 .668 r
.90525 .44226 .90605 .4413 .9069 .43884 .9061 .43983 Mtetra
.607 .245 .33 r
.9061 .43983 .9069 .43884 .90807 .43976 .90727 .44073 Mtetra
.784 .475 .464 r
.90727 .44073 .90807 .43976 .90954 .4439 .90873 .4448 Mtetra
.82 .524 .489 r
.90873 .4448 .90954 .4439 .91126 .45062 .91044 .45142 Mtetra
.834 .543 .496 r
.91044 .45142 .91126 .45062 .91314 .45901 .91231 .45968 Mtetra
.841 .55 .496 r
.91231 .45968 .91314 .45901 .91509 .46809 .91425 .46862 Mtetra
.845 .552 .492 r
.91425 .46862 .91509 .46809 .91703 .47699 .91617 .47739 Mtetra
.847 .548 .483 r
.91617 .47739 .91703 .47699 .9189 .48506 .91803 .48533 Mtetra
.846 .54 .469 r
.91803 .48533 .9189 .48506 .92066 .49192 .91977 .49208 Mtetra
.843 .523 .447 r
.91977 .49208 .92066 .49192 .92228 .49737 .92139 .49745 Mtetra
.835 .493 .408 r
.92139 .49745 .92228 .49737 .92377 .50138 .92287 .5014 Mtetra
.813 .43 .33 r
.92287 .5014 .92377 .50138 .92513 .50399 .92423 .50396 Mtetra
.719 .241 .112 r
.92423 .50396 .92513 .50399 .92636 .50524 .92545 .50519 Mtetra
.135 .678 .825 r
.92545 .50519 .92636 .50524 .92746 .50517 .92655 .50512 Mtetra
.841 .856 .856 r
.92655 .50512 .92746 .50517 .92844 .50378 .92753 .50375 Mtetra
.885 .765 .725 r
.92753 .50375 .92844 .50378 .92928 .50104 .92838 .50105 Mtetra
.892 .723 .666 r
.92838 .50105 .92928 .50104 .92999 .4969 .9291 .49697 Mtetra
.894 .7 .633 r
.9291 .49697 .92999 .4969 .93056 .49131 .92967 .49146 Mtetra
.896 .687 .612 r
.92967 .49146 .93056 .49131 .93098 .48428 .9301 .48453 Mtetra
.898 .68 .599 r
.9301 .48453 .93098 .48428 .93127 .47595 .93041 .47633 Mtetra
.901 .677 .59 r
.93041 .47633 .93127 .47595 .93146 .46666 .93062 .46718 Mtetra
.905 .679 .585 r
.93062 .46718 .93146 .46666 .93162 .45699 .93079 .45765 Mtetra
.912 .687 .585 r
.93079 .45765 .93162 .45699 .93181 .44776 .93099 .44855 Mtetra
.924 .706 .59 r
.93099 .44855 .93181 .44776 .93214 .43995 .93134 .44085 Mtetra
.949 .756 .61 r
.93134 .44085 .93214 .43995 .9327 .43453 .93191 .43551 Mtetra
.961 .943 .655 r
.93191 .43551 .9327 .43453 .93358 .43222 .93279 .43323 Mtetra
.629 .271 .346 r
.93279 .43323 .93358 .43222 .9348 .43334 .93401 .43433 Mtetra
.788 .476 .462 r
.93401 .43433 .9348 .43334 .93634 .43768 .93554 .4386 Mtetra
.822 .523 .485 r
.93554 .4386 .93634 .43768 .93815 .44459 .93734 .44541 Mtetra
.836 .542 .491 r
.93734 .44541 .93815 .44459 .94012 .45314 .9393 .45382 Mtetra
.843 .549 .491 r
.9393 .45382 .94012 .45314 .94217 .46233 .94133 .46288 Mtetra
.846 .55 .486 r
.94133 .46288 .94217 .46233 .9442 .47131 .94335 .47172 Mtetra
.848 .546 .477 r
.94335 .47172 .9442 .47131 .94615 .47942 .94528 .47971 Mtetra
.847 .537 .463 r
.94528 .47971 .94615 .47942 .94798 .48629 .9471 .48647 Mtetra
.844 .52 .439 r
.9471 .48647 .94798 .48629 .94966 .49175 .94877 .49184 Mtetra
.835 .488 .399 r
.94877 .49184 .94966 .49175 .95121 .49574 .95031 .49577 Mtetra
.81 .421 .318 r
.95031 .49577 .95121 .49574 .9526 .49832 .9517 .49831 Mtetra
.706 .22 .089 r
.9517 .49831 .9526 .49832 .95386 .49953 .95296 .49949 Mtetra
.187 .715 .848 r
.95296 .49949 .95386 .49953 .95499 .4994 .95408 .49937 Mtetra
.849 .86 .85 r
.95408 .49937 .95499 .4994 .95598 .49795 .95507 .49793 Mtetra
.891 .769 .721 r
.95507 .49793 .95598 .49795 .95682 .49512 .95592 .49515 Mtetra
.897 .726 .662 r
.95592 .49515 .95682 .49512 .95752 .49088 .95663 .49097 Mtetra
.899 .703 .629 r
.95663 .49097 .95752 .49088 .95807 .48517 .95719 .48534 Mtetra
.9 .689 .608 r
.95719 .48534 .95807 .48517 .95846 .47801 .95759 .47829 Mtetra
.902 .682 .594 r
.95759 .47829 .95846 .47801 .95871 .46955 .95786 .46996 Mtetra
.905 .679 .585 r
.95786 .46996 .95871 .46955 .95886 .46014 .95802 .46068 Mtetra
.909 .681 .581 r
.95802 .46068 .95886 .46014 .95897 .45039 .95815 .45107 Mtetra
.916 .69 .58 r
.95815 .45107 .95897 .45039 .95913 .44112 .95833 .44194 Mtetra
.929 .71 .586 r
.95833 .44194 .95913 .44112 .95944 .43334 .95865 .43427 Mtetra
.956 .765 .606 r
.95865 .43427 .95944 .43334 .96001 .42802 .95923 .42902 Mtetra
.932 .954 .631 r
.95923 .42902 .96001 .42802 .96092 .42587 .96014 .4269 Mtetra
.647 .293 .358 r
.96014 .4269 .96092 .42587 .96219 .42718 .96141 .42819 Mtetra
.79 .478 .459 r
.96141 .42819 .96219 .42718 .96381 .43172 .96302 .43266 Mtetra
.824 .523 .48 r
.96302 .43266 .96381 .43172 .96571 .43882 .96491 .43965 Mtetra
.837 .54 .486 r
.96491 .43965 .96571 .43882 .96778 .44752 .96697 .44823 Mtetra
.844 .547 .486 r
.96697 .44823 .96778 .44752 .96993 .45683 .9691 .4574 Mtetra
.848 .548 .481 r
.9691 .4574 .96993 .45683 .97205 .46588 .9712 .46631 Mtetra
.849 .544 .471 r
.9712 .46631 .97205 .46588 .97409 .47404 .97322 .47434 Mtetra
.848 .534 .456 r
.97322 .47434 .97409 .47404 .97599 .48093 .97511 .48112 Mtetra
.844 .516 .431 r
.97511 .48112 .97599 .48093 .97774 .48638 .97685 .48648 Mtetra
.834 .482 .389 r
.97685 .48648 .97774 .48638 .97933 .49035 .97844 .4904 Mtetra
.806 .411 .305 r
.97844 .4904 .97933 .49035 .98077 .4929 .97987 .4929 Mtetra
.691 .196 .065 r
.97987 .4929 .98077 .4929 .98207 .49406 .98116 .49404 Mtetra
.24 .75 .869 r
.98116 .49404 .98207 .49406 .98321 .49388 .98231 .49386 Mtetra
.857 .864 .845 r
.98231 .49386 .98321 .49388 .98421 .49235 .98331 .49235 Mtetra
.896 .773 .717 r
.98331 .49235 .98421 .49235 .98506 .48944 .98416 .48948 Mtetra
.902 .729 .658 r
.98416 .48948 .98506 .48944 .98575 .48509 .98486 .48519 Mtetra
.903 .705 .624 r
.98486 .48519 .98575 .48509 .98627 .47925 .98539 .47944 Mtetra
.905 .691 .603 r
.98539 .47944 .98627 .47925 .98663 .47196 .98577 .47226 Mtetra
.907 .684 .589 r
.98577 .47226 .98663 .47196 .98684 .46336 .98599 .46379 Mtetra
.909 .681 .581 r
.98599 .46379 .98684 .46336 .98695 .45383 .98612 .45439 Mtetra
.914 .684 .576 r
.98612 .45439 .98695 .45383 .98701 .44397 .9862 .44469 Mtetra
.921 .693 .575 r
.9862 .44469 .98701 .44397 .98713 .43467 .98634 .43552 Mtetra
.935 .715 .581 r
.98634 .43552 .98713 .43467 .98743 .42692 .98665 .42788 Mtetra
.963 .775 .602 r
.98665 .42788 .98743 .42692 .988 .4217 .98723 .42273 Mtetra
.878 .948 .592 r
.98723 .42273 .988 .4217 .98894 .4197 .98817 .42077 Mtetra
.533 .309 .522 r
.53086 .63648 .53172 .63267 .53249 .63358 .53163 .63732 Mtetra
.668 .438 .563 r
.53163 .63732 .53249 .63358 .53329 .63726 .53242 .64081 Mtetra
.718 .486 .574 r
.53242 .64081 .53329 .63726 .53411 .64309 .53324 .64637 Mtetra
.741 .508 .576 r
.53324 .64637 .53411 .64309 .53494 .65027 .53406 .6532 Mtetra
.753 .518 .576 r
.53406 .6532 .53494 .65027 .53578 .65791 .5349 .66048 Mtetra
.759 .521 .573 r
.5349 .66048 .53578 .65791 .53662 .66528 .53574 .66751 Mtetra
.76 .519 .568 r
.53574 .66751 .53662 .66528 .53746 .67186 .53657 .67377 Mtetra
.757 .51 .56 r
.53657 .67377 .53746 .67186 .53829 .67733 .53739 .67897 Mtetra
.747 .494 .547 r
.53739 .67897 .53829 .67733 .5391 .68155 .53821 .68298 Mtetra
.728 .463 .527 r
.53821 .68298 .5391 .68155 .53991 .68451 .53901 .68578 Mtetra
.684 .4 .486 r
.53901 .68578 .53991 .68451 .5407 .68624 .53981 .68741 Mtetra
.556 .236 .381 r
.53981 .68741 .5407 .68624 .54149 .68679 .54059 .68791 Mtetra
0 0 0 r
.54059 .68791 .54149 .68679 .54226 .68618 .54136 .6873 Mtetra
.952 .953 .708 r
.54136 .6873 .54226 .68618 .54301 .68443 .54212 .6856 Mtetra
.951 .828 .686 r
.54212 .6856 .54301 .68443 .54376 .68148 .54286 .68276 Mtetra
.929 .766 .658 r
.54286 .68276 .54376 .68148 .54449 .67731 .5436 .67874 Mtetra
.917 .736 .641 r
.5436 .67874 .54449 .67731 .5452 .67186 .54432 .67351 Mtetra
.912 .72 .629 r
.54432 .67351 .5452 .67186 .5459 .66516 .54502 .66708 Mtetra
.912 .713 .621 r
.54502 .66708 .5459 .66516 .54659 .65737 .54571 .6596 Mtetra
.916 .713 .614 r
.54571 .6596 .54659 .65737 .54726 .64878 .54639 .65137 Mtetra
.925 .721 .608 r
.54639 .65137 .54726 .64878 .54793 .63996 .54706 .64291 Mtetra
.943 .742 .601 r
.54706 .64291 .54793 .63996 .5486 .63165 .54774 .63493 Mtetra
.976 .785 .582 r
.54774 .63493 .5486 .63165 .54928 .62471 .54843 .62827 Mtetra
.985 .852 .475 r
.54843 .62827 .54928 .62471 .55 .61997 .54914 .62372 Mtetra
0 0 .26 r
.54914 .62372 .55 .61997 .55074 .61804 .54989 .62184 Mtetra
.544 .319 .524 r
.54989 .62184 .55074 .61804 .55153 .6191 .55068 .62283 Mtetra
.672 .441 .562 r
.55068 .62283 .55153 .6191 .55236 .62292 .55151 .62646 Mtetra
.72 .486 .572 r
.55151 .62646 .55236 .62292 .55322 .62888 .55236 .63213 Mtetra
.742 .508 .574 r
.55236 .63213 .55322 .62888 .5541 .63613 .55323 .63904 Mtetra
.754 .518 .574 r
.55323 .63904 .5541 .63613 .55498 .64381 .55411 .64636 Mtetra
.76 .521 .571 r
.55411 .64636 .55498 .64381 .55587 .65119 .55499 .65339 Mtetra
.761 .518 .565 r
.55499 .65339 .55587 .65119 .55675 .65775 .55587 .65964 Mtetra
.757 .509 .557 r
.55587 .65964 .55675 .65775 .55761 .66319 .55673 .66481 Mtetra
.748 .492 .544 r
.55673 .66481 .55761 .66319 .55846 .66737 .55757 .66878 Mtetra
.727 .46 .522 r
.55757 .66878 .55846 .66737 .55929 .67029 .5584 .67154 Mtetra
.681 .394 .48 r
.5584 .67154 .55929 .67029 .56011 .67197 .55921 .67312 Mtetra
.545 .219 .367 r
.55921 .67312 .56011 .67197 .5609 .67247 .56001 .67357 Mtetra
0 0 0 r
.56001 .67357 .5609 .67247 .56169 .67181 .56079 .67292 Mtetra
.956 .948 .709 r
.56079 .67292 .56169 .67181 .56245 .66999 .56156 .67116 Mtetra
.952 .826 .683 r
.56156 .67116 .56245 .66999 .5632 .66698 .56231 .66825 Mtetra
.931 .766 .656 r
.56231 .66825 .5632 .66698 .56392 .66273 .56303 .66416 Mtetra
.919 .736 .638 r
.56303 .66416 .56392 .66273 .56463 .6572 .56374 .65885 Mtetra
.914 .721 .627 r
.56374 .65885 .56463 .6572 .56531 .65042 .56443 .65235 Mtetra
.914 .714 .618 r
.56443 .65235 .56531 .65042 .56597 .64255 .5651 .64479 Mtetra
.919 .715 .611 r
.5651 .64479 .56597 .64255 .56662 .63391 .56576 .63651 Mtetra
.929 .724 .605 r
.56576 .63651 .56662 .63391 .56727 .62506 .56641 .62802 Mtetra
.947 .745 .597 r
.56641 .62802 .56727 .62506 .56792 .61676 .56707 .62006 Mtetra
.98 .79 .576 r
.56707 .62006 .56792 .61676 .56859 .60989 .56775 .61346 Mtetra
.973 .85 .448 r
.56775 .61346 .56859 .60989 .5693 .60527 .56846 .60902 Mtetra
.025 0 .297 r
.56846 .60902 .5693 .60527 .57006 .60348 .56922 .60728 Mtetra
.555 .329 .527 r
.56922 .60728 .57006 .60348 .57087 .60471 .57003 .60843 Mtetra
.676 .443 .561 r
.57003 .60843 .57087 .60471 .57173 .60868 .57089 .6122 Mtetra
.722 .487 .57 r
.57089 .6122 .57173 .60868 .57262 .61475 .57178 .61798 Mtetra
.744 .508 .572 r
.57178 .61798 .57262 .61475 .57355 .62208 .5727 .62497 Mtetra
.756 .517 .572 r
.5727 .62497 .57355 .62208 .57448 .62981 .57363 .63233 Mtetra
.761 .52 .568 r
.57363 .63233 .57448 .62981 .57542 .6372 .57455 .63937 Mtetra
.762 .517 .563 r
.57455 .63937 .57542 .6372 .57634 .64375 .57546 .64561 Mtetra
.758 .508 .554 r
.57546 .64561 .57634 .64375 .57724 .64916 .57636 .65075 Mtetra
.748 .49 .54 r
.57636 .65075 .57724 .64916 .57812 .6533 .57723 .65469 Mtetra
.727 .456 .518 r
.57723 .65469 .57812 .6533 .57898 .65618 .57809 .65741 Mtetra
.679 .388 .473 r
.57809 .65741 .57898 .65618 .57981 .65782 .57892 .65895 Mtetra
.533 .202 .353 r
.57892 .65895 .57981 .65782 .58063 .65827 .57974 .65935 Mtetra
0 0 0 r
.57974 .65935 .58063 .65827 .58142 .65756 .58053 .65865 Mtetra
.958 .943 .709 r
.58053 .65865 .58142 .65756 .58219 .65568 .5813 .65683 Mtetra
.952 .824 .68 r
.5813 .65683 .58219 .65568 .58294 .6526 .58205 .65386 Mtetra
.932 .766 .653 r
.58205 .65386 .58294 .6526 .58366 .64828 .58278 .6497 Mtetra
.921 .737 .636 r
.58278 .6497 .58366 .64828 .58435 .64267 .58348 .64431 Mtetra
.917 .722 .624 r
.58348 .64431 .58435 .64267 .58502 .63581 .58415 .63773 Mtetra
.917 .715 .615 r
.58415 .63773 .58502 .63581 .58566 .62785 .5848 .63011 Mtetra
.922 .716 .608 r
.5848 .63011 .58566 .62785 .58629 .61916 .58544 .62177 Mtetra
.932 .726 .601 r
.58544 .62177 .58629 .61916 .58691 .61029 .58607 .61326 Mtetra
.952 .748 .592 r
.58607 .61326 .58691 .61029 .58754 .60201 .5867 .60532 Mtetra
.984 .795 .568 r
.5867 .60532 .58754 .60201 .58819 .59521 .58737 .59879 Mtetra
.955 .843 .417 r
.58737 .59879 .58819 .59521 .5889 .59071 .58808 .59446 Mtetra
.087 0 .329 r
.58808 .59446 .5889 .59071 .58967 .58908 .58885 .59287 Mtetra
.565 .337 .529 r
.58885 .59287 .58967 .58908 .5905 .59046 .58968 .59417 Mtetra
.679 .445 .56 r
.58968 .59417 .5905 .59046 .5914 .59458 .59057 .59809 Mtetra
.724 .488 .569 r
.59057 .59809 .5914 .59458 .59234 .60078 .59151 .60399 Mtetra
.746 .508 .57 r
.59151 .60399 .59234 .60078 .59331 .6082 .59247 .61106 Mtetra
.757 .517 .569 r
.59247 .61106 .59331 .6082 .5943 .61597 .59345 .61846 Mtetra
.763 .519 .566 r
.59345 .61846 .5943 .61597 .59528 .62337 .59442 .62552 Mtetra
.763 .516 .56 r
.59442 .62552 .59528 .62337 .59624 .62991 .59538 .63174 Mtetra
.759 .506 .551 r
.59538 .63174 .59624 .62991 .59718 .63529 .59631 .63686 Mtetra
.749 .488 .537 r
.59631 .63686 .59718 .63529 .59809 .63941 .59722 .64077 Mtetra
.727 .453 .513 r
.59722 .64077 .59809 .63941 .59898 .64224 .5981 .64345 Mtetra
.676 .381 .466 r
.5981 .64345 .59898 .64224 .59984 .64384 .59895 .64495 Mtetra
.522 .185 .338 r
.59895 .64495 .59984 .64384 .60067 .64425 .59978 .64532 Mtetra
0 0 0 r
.59978 .64532 .60067 .64425 .60147 .64349 .60059 .64456 Mtetra
.96 .938 .708 r
.60059 .64456 .60147 .64349 .60225 .64155 .60136 .64269 Mtetra
.953 .823 .678 r
.60136 .64269 .60225 .64155 .60299 .63841 .60211 .63966 Mtetra
.934 .766 .651 r
.60211 .63966 .60299 .63841 .60371 .63401 .60283 .63543 Mtetra
.923 .737 .633 r
.60283 .63543 .60371 .63401 .60439 .62832 .60352 .62997 Mtetra
.919 .723 .621 r
.60352 .62997 .60439 .62832 .60504 .62138 .60418 .62331 Mtetra
.919 .717 .612 r
.60418 .62331 .60504 .62138 .60566 .61336 .60481 .61562 Mtetra
.925 .718 .605 r
.60481 .61562 .60566 .61336 .60626 .60461 .60542 .60723 Mtetra
.936 .728 .598 r
.60542 .60723 .60626 .60461 .60686 .59572 .60603 .5987 Mtetra
.956 .752 .588 r
.60603 .5987 .60686 .59572 .60747 .58747 .60665 .59078 Mtetra
.989 .8 .56 r
.60665 .59078 .60747 .58747 .60811 .58075 .60731 .58433 Mtetra
.93 .831 .379 r
.60731 .58433 .60811 .58075 .60882 .57637 .60802 .58012 Mtetra
.144 0 .357 r
.60802 .58012 .60882 .57637 .6096 .57489 .6088 .57868 Mtetra
.575 .346 .53 r
.6088 .57868 .6096 .57489 .61046 .57645 .60965 .58014 Mtetra
.683 .448 .559 r
.60965 .58014 .61046 .57645 .61139 .58072 .61058 .58421 Mtetra
.726 .488 .567 r
.61058 .58421 .61139 .58072 .61238 .58705 .61156 .59023 Mtetra
.747 .508 .568 r
.61156 .59023 .61238 .58705 .6134 .59455 .61258 .59738 Mtetra
.759 .517 .567 r
.61258 .59738 .6134 .59455 .61444 .60237 .6136 .60484 Mtetra
.764 .519 .563 r
.6136 .60484 .61444 .60237 .61547 .60979 .61462 .61191 Mtetra
.764 .515 .557 r
.61462 .61191 .61547 .60979 .61648 .61632 .61562 .61812 Mtetra
.76 .505 .548 r
.61562 .61812 .61648 .61632 .61745 .62168 .61659 .62323 Mtetra
.75 .486 .533 r
.61659 .62323 .61745 .62168 .6184 .62577 .61753 .6271 Mtetra
.727 .45 .508 r
.61753 .6271 .6184 .62577 .61931 .62857 .61844 .62976 Mtetra
.674 .375 .459 r
.61844 .62976 .61931 .62857 .62019 .63013 .61931 .63122 Mtetra
.51 .167 .322 r
.61931 .63122 .62019 .63013 .62104 .63049 .62016 .63154 Mtetra
0 0 0 r
.62016 .63154 .62104 .63049 .62185 .62968 .62097 .63075 Mtetra
.962 .935 .707 r
.62097 .63075 .62185 .62968 .62263 .6277 .62176 .62882 Mtetra
.954 .822 .675 r
.62176 .62882 .62263 .6277 .62338 .62449 .62251 .62574 Mtetra
.935 .766 .648 r
.62251 .62574 .62338 .62449 .62409 .62002 .62322 .62144 Mtetra
.925 .738 .63 r
.62322 .62144 .62409 .62002 .62476 .61426 .6239 .6159 Mtetra
.922 .724 .618 r
.6239 .6159 .62476 .61426 .62539 .60724 .62454 .60917 Mtetra
.922 .718 .609 r
.62454 .60917 .62539 .60724 .62599 .59914 .62515 .60141 Mtetra
.928 .72 .602 r
.62515 .60141 .62599 .59914 .62657 .59034 .62574 .59297 Mtetra
.939 .731 .594 r
.62574 .59297 .62657 .59034 .62714 .58143 .62633 .58443 Mtetra
.96 .755 .583 r
.62633 .58443 .62714 .58143 .62773 .57321 .62693 .57654 Mtetra
.992 .805 .551 r
.62693 .57654 .62773 .57321 .62836 .56658 .62757 .57017 Mtetra
.896 .812 .336 r
.62757 .57017 .62836 .56658 .62907 .56233 .62828 .56608 Mtetra
.195 .005 .381 r
.62828 .56608 .62907 .56233 .62986 .56101 .62908 .5648 Mtetra
.585 .353 .532 r
.62908 .5648 .62986 .56101 .63075 .56274 .62996 .56643 Mtetra
.687 .45 .558 r
.62996 .56643 .63075 .56274 .63172 .56718 .63093 .57065 Mtetra
.728 .489 .565 r
.63093 .57065 .63172 .56718 .63276 .57363 .63195 .57679 Mtetra
.749 .508 .566 r
.63195 .57679 .63276 .57363 .63383 .58122 .63302 .58403 Mtetra
.76 .516 .564 r
.63302 .58403 .63383 .58122 .63492 .58909 .6341 .59154 Mtetra
.765 .518 .56 r
.6341 .59154 .63492 .58909 .636 .59654 .63516 .59863 Mtetra
.766 .514 .554 r
.63516 .59863 .636 .59654 .63706 .60306 .63621 .60484 Mtetra
.761 .504 .544 r
.63621 .60484 .63706 .60306 .63807 .60841 .63721 .60993 Mtetra
.75 .484 .529 r
.63721 .60993 .63807 .60841 .63905 .61247 .63819 .61378 Mtetra
.727 .447 .503 r
.63819 .61378 .63905 .61247 .64 .61524 .63912 .61641 Mtetra
.672 .369 .452 r
.63912 .61641 .64 .61524 .6409 .61677 .64002 .61784 Mtetra
.498 .15 .307 r
.64002 .61784 .6409 .61677 .64176 .61709 .64088 .61813 Mtetra
0 0 0 r
.64088 .61813 .64176 .61709 .64259 .61624 .64171 .61729 Mtetra
.963 .932 .706 r
.64171 .61729 .64259 .61624 .64337 .6142 .6425 .61532 Mtetra
.955 .821 .672 r
.6425 .61532 .64337 .6142 .64412 .61094 .64325 .61218 Mtetra
.937 .767 .645 r
.64325 .61218 .64412 .61094 .64482 .6064 .64396 .60781 Mtetra
.928 .739 .628 r
.64396 .60781 .64482 .6064 .64548 .60056 .64463 .60221 Mtetra
.924 .725 .615 r
.64463 .60221 .64548 .60056 .64609 .59346 .64525 .5954 Mtetra
.925 .72 .606 r
.64525 .5954 .64609 .59346 .64667 .58529 .64584 .58757 Mtetra
.931 .722 .598 r
.64584 .58757 .64667 .58529 .64722 .57644 .64641 .57909 Mtetra
.943 .733 .59 r
.64641 .57909 .64722 .57644 .64776 .56752 .64697 .57053 Mtetra
.964 .759 .577 r
.64697 .57053 .64776 .56752 .64833 .55934 .64755 .56268 Mtetra
.996 .81 .54 r
.64755 .56268 .64833 .55934 .64895 .55279 .64818 .55639 Mtetra
.852 .786 .286 r
.64818 .55639 .64895 .55279 .64966 .54868 .64889 .55244 Mtetra
.24 .045 .402 r
.64889 .55244 .64966 .54868 .65047 .54753 .64971 .55132 Mtetra
.593 .361 .533 r
.64971 .55132 .65047 .54753 .65139 .54943 .65062 .55311 Mtetra
.69 .452 .557 r
.65062 .55311 .65139 .54943 .6524 .55403 .65163 .55749 Mtetra
.731 .49 .563 r
.65163 .55749 .6524 .55403 .65349 .56062 .6527 .56377 Mtetra
.751 .508 .564 r
.6527 .56377 .65349 .56062 .65463 .56831 .65382 .5711 Mtetra
.762 .516 .562 r
.65382 .5711 .65463 .56831 .65577 .57624 .65495 .57866 Mtetra
.767 .518 .558 r
.65495 .57866 .65577 .57624 .6569 .58371 .65607 .58577 Mtetra
.767 .513 .551 r
.65607 .58577 .6569 .58371 .658 .59024 .65716 .59199 Mtetra
.762 .503 .541 r
.65716 .59199 .658 .59024 .65906 .59557 .65821 .59707 Mtetra
.751 .482 .525 r
.65821 .59707 .65906 .59557 .66008 .59961 .65922 .60091 Mtetra
.727 .444 .498 r
.65922 .60091 .66008 .59961 .66105 .60236 .66018 .60351 Mtetra
.67 .363 .445 r
.66018 .60351 .66105 .60236 .66197 .60385 .6611 .60491 Mtetra
.487 .134 .293 r
.6611 .60491 .66197 .60385 .66285 .60414 .66198 .60517 Mtetra
0 0 0 r
.66198 .60517 .66285 .60414 .66369 .60325 .66282 .60429 Mtetra
.965 .929 .704 r
.66282 .60429 .66369 .60325 .66448 .60116 .66361 .60227 Mtetra
.956 .821 .67 r
.66361 .60227 .66448 .60116 .66523 .59784 .66436 .59908 Mtetra
.939 .768 .642 r
.66436 .59908 .66523 .59784 .66592 .59323 .66507 .59465 Mtetra
.93 .741 .624 r
.66507 .59465 .66592 .59323 .66657 .58732 .66572 .58897 Mtetra
.927 .727 .612 r
.66572 .58897 .66657 .58732 .66716 .58014 .66633 .58209 Mtetra
.928 .721 .602 r
.66633 .58209 .66716 .58014 .66771 .57191 .6669 .5742 Mtetra
.935 .724 .594 r
.6669 .5742 .66771 .57191 .66824 .56302 .66744 .56567 Mtetra
.947 .736 .585 r
.66744 .56567 .66824 .56302 .66876 .55409 .66797 .55711 Mtetra
.969 .763 .571 r
.66797 .55711 .66876 .55409 .6693 .54594 .66854 .5493 Mtetra
.998 .814 .527 r
.66854 .5493 .6693 .54594 .66992 .53948 .66916 .5431 Mtetra
.795 .749 .229 r
.66916 .5431 .66992 .53948 .67063 .53551 .66988 .53928 Mtetra
.282 .081 .42 r
.66988 .53928 .67063 .53551 .67145 .53454 .67071 .53832 Mtetra
.602 .368 .534 r
.67071 .53832 .67145 .53454 .6724 .53662 .67165 .5403 Mtetra
.694 .454 .555 r
.67165 .5403 .6724 .53662 .67347 .54139 .67271 .54484 Mtetra
.733 .49 .561 r
.67271 .54484 .67347 .54139 .67461 .54812 .67383 .55125 Mtetra
.753 .508 .561 r
.67383 .55125 .67461 .54812 .6758 .5559 .67501 .55867 Mtetra
.763 .516 .559 r
.67501 .55867 .6758 .5559 .677 .5639 .67619 .56629 Mtetra
.768 .517 .555 r
.67619 .56629 .677 .5639 .67819 .5714 .67736 .57344 Mtetra
.768 .512 .548 r
.67736 .57344 .67819 .5714 .67934 .57794 .6785 .57967 Mtetra
.763 .501 .537 r
.6785 .57967 .67934 .57794 .68044 .58326 .67959 .58474 Mtetra
.752 .48 .521 r
.67959 .58474 .68044 .58326 .68149 .58729 .68063 .58856 Mtetra
.727 .44 .493 r
.68063 .58856 .68149 .58729 .68249 .59001 .68163 .59114 Mtetra
.667 .357 .438 r
.68163 .59114 .68249 .59001 .68344 .59148 .68257 .59253 Mtetra
.476 .118 .279 r
.68257 .59253 .68344 .59148 .68433 .59174 .68347 .59275 Mtetra
0 0 0 r
.68347 .59275 .68433 .59174 .68518 .59081 .68432 .59184 Mtetra
.966 .928 .701 r
.68432 .59184 .68518 .59081 .68598 .58867 .68512 .58978 Mtetra
.958 .822 .667 r
.68512 .58978 .68598 .58867 .68673 .5853 .68587 .58653 Mtetra
.942 .769 .639 r
.68587 .58653 .68673 .5853 .68741 .58062 .68657 .58204 Mtetra
.933 .742 .621 r
.68657 .58204 .68741 .58062 .68805 .57463 .68721 .57629 Mtetra
.93 .728 .608 r
.68721 .57629 .68805 .57463 .68862 .56738 .6878 .56935 Mtetra
.932 .723 .599 r
.6878 .56935 .68862 .56738 .68915 .55908 .68834 .56139 Mtetra
.938 .726 .59 r
.68834 .56139 .68915 .55908 .68964 .55014 .68886 .55282 Mtetra
.951 .739 .58 r
.68886 .55282 .68964 .55014 .69014 .54121 .68937 .54425 Mtetra
.974 .767 .564 r
.68937 .54425 .69014 .54121 .69066 .5331 .68991 .53648 Mtetra
1 .819 .513 r
.68991 .53648 .69066 .5331 .69127 .52674 .69053 .53038 Mtetra
.726 .702 .166 r
.69053 .53038 .69127 .52674 .69198 .52292 .69125 .5267 Mtetra
.319 .113 .435 r
.69125 .5267 .69198 .52292 .69283 .52212 .6921 .52591 Mtetra
.61 .374 .534 r
.6921 .52591 .69283 .52212 .69382 .52439 .69308 .52807 Mtetra
.697 .455 .554 r
.69308 .52807 .69382 .52439 .69493 .52934 .69418 .53278 Mtetra
.735 .491 .559 r
.69418 .53278 .69493 .52934 .69613 .5362 .69537 .53932 Mtetra
.754 .508 .559 r
.69537 .53932 .69613 .5362 .69738 .5441 .6966 .54685 Mtetra
.765 .515 .556 r
.6966 .54685 .69738 .5441 .69864 .55216 .69784 .55454 Mtetra
.769 .516 .552 r
.69784 .55454 .69864 .55216 .69988 .55969 .69907 .56172 Mtetra
.769 .511 .544 r
.69907 .56172 .69988 .55969 .70108 .56624 .70025 .56796 Mtetra
.764 .5 .534 r
.70025 .56796 .70108 .56624 .70223 .57157 .70139 .57303 Mtetra
.752 .478 .517 r
.70139 .57303 .70223 .57157 .70332 .57558 .70247 .57685 Mtetra
.726 .437 .488 r
.70247 .57685 .70332 .57558 .70435 .57829 .70349 .57941 Mtetra
.665 .351 .431 r
.70349 .57941 .70435 .57829 .70532 .57973 .70446 .58077 Mtetra
.466 .104 .266 r
.70446 .58077 .70532 .57973 .70623 .57996 .70537 .58097 Mtetra
0 0 0 r
.70537 .58097 .70623 .57996 .7071 .579 .70623 .58003 Mtetra
.967 .927 .698 r
.70623 .58003 .7071 .579 .7079 .57682 .70704 .57793 Mtetra
.96 .823 .663 r
.70704 .57793 .7079 .57682 .70864 .57339 .70779 .57462 Mtetra
.945 .771 .636 r
.70779 .57462 .70864 .57339 .70932 .56865 .70848 .57007 Mtetra
.936 .744 .618 r
.70848 .57007 .70932 .56865 .70994 .56258 .70911 .56426 Mtetra
.934 .73 .605 r
.70911 .56426 .70994 .56258 .71049 .55526 .70968 .55724 Mtetra
.935 .726 .594 r
.70968 .55724 .71049 .55526 .71099 .54689 .7102 .54922 Mtetra
.942 .729 .585 r
.7102 .54922 .71099 .54689 .71146 .53791 .71069 .54061 Mtetra
.956 .742 .575 r
.71069 .54061 .71146 .53791 .71193 .52896 .71118 .53204 Mtetra
.978 .771 .556 r
.71118 .53204 .71193 .52896 .71244 .52091 .71171 .52431 Mtetra
1 .822 .496 r
.71171 .52431 .71244 .52091 .71303 .51465 .71232 .5183 Mtetra
0 0 0 r
.71232 .5183 .71303 .51465 .71375 .51097 .71304 .51477 Mtetra
.353 .142 .448 r
.71304 .51477 .71375 .51097 .71463 .51035 .71392 .51416 Mtetra
.618 .38 .535 r
.71392 .51416 .71463 .51035 .71565 .51282 .71494 .5165 Mtetra
.7 .457 .552 r
.71494 .5165 .71565 .51282 .71681 .51794 .71609 .52138 Mtetra
.737 .491 .557 r
.71609 .52138 .71681 .51794 .71807 .52496 .71733 .52807 Mtetra
.756 .507 .556 r
.71733 .52807 .71807 .52496 .71939 .53296 .71862 .53571 Mtetra
.766 .515 .554 r
.71862 .53571 .71939 .53296 .72071 .54109 .71993 .54346 Mtetra
.771 .515 .549 r
.71993 .54346 .72071 .54109 .72201 .54867 .72121 .55068 Mtetra
.771 .51 .541 r
.72121 .55068 .72201 .54867 .72326 .55524 .72244 .55694 Mtetra
.765 .498 .53 r
.72244 .55694 .72326 .55524 .72446 .56056 .72362 .56202 Mtetra
.753 .476 .512 r
.72362 .56202 .72446 .56056 .72558 .56457 .72474 .56582 Mtetra
.726 .434 .483 r
.72474 .56582 .72558 .56457 .72664 .56726 .72579 .56838 Mtetra
.663 .345 .424 r
.72579 .56838 .72664 .56726 .72764 .56869 .72679 .56972 Mtetra
.456 .09 .254 r
.72679 .56972 .72764 .56869 .72858 .56889 .72772 .5699 Mtetra
0 0 0 r
.72772 .5699 .72858 .56889 .72945 .56789 .7286 .56892 Mtetra
.968 .927 .693 r
.7286 .56892 .72945 .56789 .73026 .56567 .72941 .56678 Mtetra
.963 .825 .659 r
.72941 .56678 .73026 .56567 .731 .56218 .73016 .56342 Mtetra
.948 .773 .632 r
.73016 .56342 .731 .56218 .73168 .55737 .73084 .55881 Mtetra
.94 .746 .614 r
.73084 .55881 .73168 .55737 .73228 .55123 .73146 .55293 Mtetra
.937 .732 .6 r
.73146 .55293 .73228 .55123 .73281 .54383 .73201 .54583 Mtetra
.939 .728 .59 r
.73201 .54583 .73281 .54383 .73328 .5354 .73251 .53775 Mtetra
.947 .732 .58 r
.73251 .53775 .73328 .5354 .73372 .52637 .73297 .5291 Mtetra
.96 .746 .569 r
.73297 .5291 .73372 .52637 .73416 .51742 .73343 .52053 Mtetra
.983 .776 .548 r
.73343 .52053 .73416 .51742 .73465 .50941 .73394 .51284 Mtetra
.997 .825 .475 r
.73394 .51284 .73465 .50941 .73524 .50325 .73454 .50694 Mtetra
0 0 0 r
.73454 .50694 .73524 .50325 .73597 .49973 .73528 .50355 Mtetra
.382 .168 .46 r
.73528 .50355 .73597 .49973 .73687 .4993 .73618 .50312 Mtetra
.625 .385 .535 r
.73618 .50312 .73687 .4993 .73794 .50196 .73724 .50565 Mtetra
.704 .459 .551 r
.73724 .50565 .73794 .50196 .73915 .50726 .73845 .5107 Mtetra
.739 .491 .554 r
.73845 .5107 .73915 .50726 .74048 .51443 .73975 .51754 Mtetra
.758 .507 .554 r
.73975 .51754 .74048 .51443 .74186 .52255 .74111 .52529 Mtetra
.768 .514 .551 r
.74111 .52529 .74186 .52255 .74325 .53076 .74248 .53312 Mtetra
.772 .514 .546 r
.74248 .53312 .74325 .53076 .74461 .53838 .74381 .54038 Mtetra
.772 .509 .538 r
.74381 .54038 .74461 .53838 .74591 .54497 .7451 .54667 Mtetra
.766 .496 .526 r
.7451 .54667 .74591 .54497 .74715 .5503 .74633 .55174 Mtetra
.753 .473 .508 r
.74633 .55174 .74715 .5503 .74832 .5543 .74748 .55555 Mtetra
.725 .43 .478 r
.74748 .55555 .74832 .5543 .74941 .55698 .74857 .55809 Mtetra
.66 .339 .418 r
.74857 .55809 .74941 .55698 .75044 .55838 .74959 .55942 Mtetra
.446 .078 .244 r
.74959 .55942 .75044 .55838 .75139 .55856 .75054 .55957 Mtetra
0 0 0 r
.75054 .55957 .75139 .55856 .75228 .55753 .75143 .55856 Mtetra
.969 .928 .688 r
.75143 .55856 .75228 .55753 .75309 .55526 .75225 .55638 Mtetra
.966 .827 .655 r
.75225 .55638 .75309 .55526 .75384 .55171 .753 .55297 Mtetra
.951 .775 .628 r
.753 .55297 .75384 .55171 .7545 .54684 .75368 .5483 Mtetra
.943 .748 .609 r
.75368 .5483 .7545 .54684 .75508 .54062 .75428 .54234 Mtetra
.941 .735 .596 r
.75428 .54234 .75508 .54062 .75559 .53314 .75481 .53517 Mtetra
.943 .73 .585 r
.75481 .53517 .75559 .53314 .75604 .52463 .75528 .52702 Mtetra
.951 .735 .575 r
.75528 .52702 .75604 .52463 .75645 .51556 .75571 .51833 Mtetra
.965 .749 .562 r
.75571 .51833 .75645 .51556 .75686 .50661 .75615 .50975 Mtetra
.987 .78 .538 r
.75615 .50975 .75686 .50661 .75733 .49864 .75664 .50211 Mtetra
.992 .825 .451 r
.75664 .50211 .75733 .49864 .75792 .49259 .75724 .49631 Mtetra
0 0 .041 r
.75724 .49631 .75792 .49259 .75866 .48922 .75799 .49307 Mtetra
.409 .191 .469 r
.75799 .49307 .75866 .48922 .75958 .48898 .75892 .49282 Mtetra
.631 .39 .535 r
.75892 .49282 .75958 .48898 .7607 .49184 .76002 .49554 Mtetra
.707 .46 .549 r
.76002 .49554 .7607 .49184 .76197 .49733 .76128 .50078 Mtetra
.741 .491 .552 r
.76128 .50078 .76197 .49733 .76336 .50465 .76265 .50777 Mtetra
.759 .507 .551 r
.76265 .50777 .76336 .50465 .76481 .51289 .76408 .51562 Mtetra
.769 .513 .548 r
.76408 .51562 .76481 .51289 .76627 .52117 .76551 .52353 Mtetra
.773 .513 .542 r
.76551 .52353 .76627 .52117 .76769 .52884 .76691 .53084 Mtetra
.773 .507 .534 r
.76691 .53084 .76769 .52884 .76906 .53545 .76826 .53715 Mtetra
.767 .495 .522 r
.76826 .53715 .76906 .53545 .77035 .54079 .76953 .54224 Mtetra
.753 .471 .504 r
.76953 .54224 .77035 .54079 .77155 .54478 .77072 .54604 Mtetra
.724 .426 .473 r
.77072 .54604 .77155 .54478 .77268 .54745 .77184 .54857 Mtetra
.657 .332 .412 r
.77184 .54857 .77268 .54745 .77373 .54884 .77289 .54988 Mtetra
.436 .066 .235 r
.77289 .54988 .77373 .54884 .77471 .54899 .77386 .55001 Mtetra
0 0 0 r
.77386 .55001 .77471 .54899 .77561 .54792 .77476 .54897 Mtetra
.97 .929 .681 r
.77476 .54897 .77561 .54792 .77643 .54561 .77559 .54674 Mtetra
.969 .83 .65 r
.77559 .54674 .77643 .54561 .77717 .542 .77634 .54328 Mtetra
.955 .778 .623 r
.77634 .54328 .77717 .542 .77782 .53705 .77701 .53854 Mtetra
.948 .751 .605 r
.77701 .53854 .77782 .53705 .77839 .53075 .77759 .5325 Mtetra
.945 .737 .591 r
.77759 .5325 .77839 .53075 .77887 .52319 .7781 .52525 Mtetra
.948 .733 .58 r
.7781 .52525 .77887 .52319 .77929 .51461 .77854 .51704 Mtetra
.956 .738 .569 r
.77854 .51704 .77929 .51461 .77967 .50549 .77895 .5083 Mtetra
.97 .753 .554 r
.77895 .5083 .77967 .50549 .78006 .49652 .77936 .49971 Mtetra
.992 .785 .526 r
.77936 .49971 .78006 .49652 .78051 .4886 .77984 .49212 Mtetra
.982 .822 .422 r
.77984 .49212 .78051 .4886 .78109 .48265 .78043 .48641 Mtetra
0 0 .106 r
.78043 .48641 .78109 .48265 .78184 .47944 .7812 .48333 Mtetra
.432 .212 .477 r
.7812 .48333 .78184 .47944 .7828 .47939 .78216 .48326 Mtetra
.637 .395 .535 r
.78216 .48326 .7828 .47939 .78396 .48245 .78331 .48618 Mtetra
.709 .461 .547 r
.78331 .48618 .78396 .48245 .7853 .48813 .78463 .49159 Mtetra
.743 .491 .55 r
.78463 .49159 .7853 .48813 .78676 .49561 .78607 .49873 Mtetra
.761 .506 .548 r
.78607 .49873 .78676 .49561 .78828 .50396 .78756 .50671 Mtetra
.77 .512 .545 r
.78756 .50671 .78828 .50396 .78981 .51233 .78907 .51469 Mtetra
.774 .512 .539 r
.78907 .51469 .78981 .51233 .7913 .52004 .79053 .52205 Mtetra
.773 .506 .531 r
.79053 .52205 .7913 .52004 .79272 .52668 .79193 .52838 Mtetra
.767 .492 .519 r
.79193 .52838 .79272 .52668 .79406 .53203 .79325 .53348 Mtetra
.753 .468 .5 r
.79325 .53348 .79406 .53203 .79531 .53602 .79449 .53728 Mtetra
.723 .422 .469 r
.79449 .53728 .79531 .53602 .79647 .53868 .79564 .5398 Mtetra
.653 .326 .406 r
.79564 .5398 .79647 .53868 .79755 .54005 .79672 .5411 Mtetra
.426 .054 .227 r
.79672 .5411 .79755 .54005 .79855 .54017 .79771 .5412 Mtetra
0 0 0 r
.79771 .5412 .79855 .54017 .79946 .53906 .79863 .54013 Mtetra
.97 .93 .672 r
.79863 .54013 .79946 .53906 .80029 .53669 .79946 .53785 Mtetra
.973 .833 .644 r
.79946 .53785 .80029 .53669 .80103 .53302 .80021 .53433 Mtetra
.959 .781 .618 r
.80021 .53433 .80103 .53302 .80167 .528 .80087 .52951 Mtetra
.952 .754 .599 r
.80087 .52951 .80167 .528 .80222 .52161 .80144 .52339 Mtetra
.95 .74 .585 r
.80144 .52339 .80222 .52161 .80268 .51396 .80192 .51606 Mtetra
.952 .736 .574 r
.80192 .51606 .80268 .51396 .80307 .5053 .80233 .50777 Mtetra
.96 .741 .562 r
.80233 .50777 .80307 .5053 .80341 .49612 .80271 .49898 Mtetra
.975 .757 .546 r
.80271 .49898 .80341 .49612 .80377 .48714 .8031 .49038 Mtetra
.995 .789 .513 r
.8031 .49038 .80377 .48714 .80421 .47927 .80356 .48284 Mtetra
.966 .815 .389 r
.80356 .48284 .80421 .47927 .80478 .47342 .80415 .47723 Mtetra
0 0 .166 r
.80415 .47723 .80478 .47342 .80555 .47037 .80493 .4743 Mtetra
.453 .23 .484 r
.80493 .4743 .80555 .47037 .80654 .47051 .80592 .47442 Mtetra
.643 .399 .534 r
.80592 .47442 .80654 .47051 .80776 .47377 .80713 .47752 Mtetra
.712 .462 .545 r
.80713 .47752 .80776 .47377 .80916 .47964 .80851 .48312 Mtetra
.745 .491 .547 r
.80851 .48312 .80916 .47964 .8107 .48728 .81002 .49041 Mtetra
.762 .505 .546 r
.81002 .49041 .8107 .48728 .8123 .49575 .81159 .4985 Mtetra
.771 .511 .542 r
.81159 .4985 .8123 .49575 .8139 .50419 .81316 .50656 Mtetra
.775 .511 .536 r
.81316 .50656 .8139 .50419 .81545 .51196 .8147 .51397 Mtetra
.774 .504 .527 r
.8147 .51397 .81545 .51196 .81694 .51862 .81615 .52033 Mtetra
.767 .49 .515 r
.81615 .52033 .81694 .51862 .81833 .52398 .81753 .52544 Mtetra
.753 .465 .496 r
.81753 .52544 .81833 .52398 .81962 .52796 .81881 .52923 Mtetra
.721 .418 .464 r
.81881 .52923 .81962 .52796 .82082 .53061 .82 .53175 Mtetra
.649 .319 .4 r
.82 .53175 .82082 .53061 .82193 .53195 .8211 .53302 Mtetra
.415 .042 .22 r
.8211 .53302 .82193 .53195 .82294 .53205 .82211 .5331 Mtetra
0 0 0 r
.82211 .5331 .82294 .53205 .82387 .53089 .82304 .53198 Mtetra
.971 .931 .662 r
.82304 .53198 .82387 .53089 .8247 .52847 .82388 .52965 Mtetra
.977 .836 .638 r
.82388 .52965 .8247 .52847 .82544 .52473 .82463 .52607 Mtetra
.964 .784 .612 r
.82463 .52607 .82544 .52473 .82607 .51962 .82528 .52117 Mtetra
.956 .757 .593 r
.82528 .52117 .82607 .51962 .8266 .51314 .82583 .51497 Mtetra
.954 .743 .579 r
.82583 .51497 .8266 .51314 .82703 .50539 .82629 .50754 Mtetra
.957 .739 .567 r
.82629 .50754 .82703 .50539 .82739 .49665 .82667 .49917 Mtetra
.965 .744 .554 r
.82667 .49917 .82739 .49665 .8277 .48741 .82702 .49033 Mtetra
.98 .761 .537 r
.82702 .49033 .8277 .48741 .82803 .47842 .82738 .48171 Mtetra
.998 .793 .498 r
.82738 .48171 .82803 .47842 .82845 .47059 .82782 .47421 Mtetra
.944 .804 .35 r
.82782 .47421 .82845 .47059 .82902 .46484 .82842 .4687 Mtetra
0 0 .218 r
.82842 .4687 .82902 .46484 .82981 .46195 .82921 .46592 Mtetra
.471 .246 .489 r
.82921 .46592 .82981 .46195 .83084 .46228 .83024 .46622 Mtetra
.648 .402 .534 r
.83024 .46622 .83084 .46228 .83211 .46574 .8315 .46952 Mtetra
.714 .462 .543 r
.8315 .46952 .83211 .46574 .83358 .4718 .83296 .4753 Mtetra
.746 .491 .545 r
.83296 .4753 .83358 .4718 .8352 .47959 .83454 .48275 Mtetra
.763 .505 .543 r
.83454 .48275 .8352 .47959 .83687 .48818 .83619 .49095 Mtetra
.772 .51 .539 r
.83619 .49095 .83687 .48818 .83855 .49671 .83783 .49909 Mtetra
.776 .509 .532 r
.83783 .49909 .83855 .49671 .84018 .50452 .83943 .50655 Mtetra
.774 .502 .524 r
.83943 .50655 .84018 .50452 .84172 .51121 .84095 .51293 Mtetra
.767 .488 .511 r
.84095 .51293 .84172 .51121 .84317 .51657 .84238 .51804 Mtetra
.752 .461 .491 r
.84238 .51804 .84317 .51657 .84451 .52055 .8437 .52184 Mtetra
.719 .413 .459 r
.8437 .52184 .84451 .52055 .84574 .52318 .84493 .52433 Mtetra
.643 .311 .394 r
.84493 .52433 .84574 .52318 .84688 .5245 .84606 .52559 Mtetra
.403 .03 .213 r
.84606 .52559 .84688 .5245 .84792 .52456 .84709 .52563 Mtetra
0 0 0 r
.84709 .52563 .84792 .52456 .84886 .52336 .84804 .52447 Mtetra
.971 .931 .651 r
.84804 .52447 .84886 .52336 .84969 .52088 .84888 .52209 Mtetra
.981 .839 .63 r
.84888 .52209 .84969 .52088 .85043 .51706 .84963 .51843 Mtetra
.968 .787 .605 r
.84963 .51843 .85043 .51706 .85105 .51186 .85027 .51345 Mtetra
.961 .76 .587 r
.85027 .51345 .85105 .51186 .85155 .50528 .8508 .50715 Mtetra
.959 .746 .572 r
.8508 .50715 .85155 .50528 .85196 .49743 .85123 .49963 Mtetra
.962 .742 .56 r
.85123 .49963 .85196 .49743 .85228 .48859 .85159 .49117 Mtetra
.97 .748 .546 r
.85159 .49117 .85228 .48859 .85256 .47929 .8519 .48226 Mtetra
.984 .764 .526 r
.8519 .48226 .85256 .47929 .85286 .47028 .85224 .47363 Mtetra
.999 .795 .481 r
.85224 .47363 .85286 .47028 .85326 .46248 .85266 .46616 Mtetra
.913 .786 .305 r
.85266 .46616 .85326 .46248 .85383 .45684 .85325 .46075 Mtetra
0 0 .263 r
.85325 .46075 .85383 .45684 .85463 .4541 .85407 .45812 Mtetra
.488 .26 .494 r
.85407 .45812 .85463 .4541 .85571 .45462 .85514 .45861 Mtetra
.652 .405 .533 r
.85514 .45861 .85571 .45462 .85704 .45829 .85646 .46211 Mtetra
.716 .463 .541 r
.85646 .46211 .85704 .45829 .85859 .46453 .85798 .46807 Mtetra
.748 .49 .542 r
.85798 .46807 .85859 .46453 .86028 .47249 .85965 .47567 Mtetra
.764 .504 .54 r
.85965 .47567 .86028 .47249 .86204 .48119 .86137 .48398 Mtetra
.773 .509 .535 r
.86137 .48398 .86204 .48119 .8638 .4898 .8631 .4922 Mtetra
.776 .507 .529 r
.8631 .4922 .8638 .4898 .8655 .49766 .86477 .4997 Mtetra
.775 .5 .52 r
.86477 .4997 .8655 .49766 .86711 .50437 .86635 .50611 Mtetra
.767 .485 .507 r
.86635 .50611 .86711 .50437 .86861 .50974 .86783 .51123 Mtetra
.751 .458 .487 r
.86783 .51123 .86861 .50974 .87 .51371 .8692 .51501 Mtetra
.717 .408 .454 r
.8692 .51501 .87 .51371 .87127 .51632 .87046 .51749 Mtetra
.638 .303 .388 r
.87046 .51749 .87127 .51632 .87244 .51761 .87162 .51872 Mtetra
.39 .018 .207 r
.87162 .51872 .87244 .51761 .8735 .51763 .87268 .51873 Mtetra
0 0 0 r
.87268 .51873 .8735 .51763 .87445 .51638 .87364 .51752 Mtetra
.97 .931 .639 r
.87364 .51752 .87445 .51638 .87529 .51383 .87449 .51507 Mtetra
.984 .842 .622 r
.87449 .51507 .87529 .51383 .87602 .50993 .87523 .51134 Mtetra
.973 .79 .598 r
.87523 .51134 .87602 .50993 .87662 .50464 .87586 .50627 Mtetra
.965 .762 .58 r
.87586 .50627 .87662 .50464 .87711 .49795 .87637 .49986 Mtetra
.963 .749 .565 r
.87637 .49986 .87711 .49795 .87748 .48999 .87677 .49224 Mtetra
.966 .745 .552 r
.87677 .49224 .87748 .48999 .87777 .48105 .87709 .48369 Mtetra
.975 .751 .537 r
.87709 .48369 .87777 .48105 .87801 .47168 .87738 .47471 Mtetra
.988 .768 .514 r
.87738 .47471 .87801 .47168 .87828 .46264 .87768 .46606 Mtetra
.999 .797 .462 r
.87768 .46606 .87828 .46264 .87866 .45488 .87809 .45862 Mtetra
.874 .761 .256 r
.87809 .45862 .87866 .45488 .87923 .44934 .87869 .45331 Mtetra
0 0 .3 r
.87869 .45331 .87923 .44934 .88006 .44676 .87952 .45083 Mtetra
.502 .272 .498 r
.87952 .45083 .88006 .44676 .88118 .44747 .88064 .4515 Mtetra
.656 .408 .532 r
.88064 .4515 .88118 .44747 .88257 .45134 .88202 .45519 Mtetra
.718 .463 .539 r
.88202 .45519 .88257 .45134 .8842 .45777 .88362 .46133 Mtetra
.749 .489 .539 r
.88362 .46133 .8842 .45777 .88598 .46588 .88537 .46908 Mtetra
.765 .502 .537 r
.88537 .46908 .88598 .46588 .88783 .4747 .88718 .47751 Mtetra
.774 .507 .532 r
.88718 .47751 .88783 .4747 .88967 .48339 .88898 .48581 Mtetra
.777 .506 .525 r
.88898 .48581 .88967 .48339 .89144 .49129 .89072 .49335 Mtetra
.775 .498 .516 r
.89072 .49335 .89144 .49129 .89312 .49802 .89237 .49978 Mtetra
.767 .482 .502 r
.89237 .49978 .89312 .49802 .89468 .50339 .89391 .5049 Mtetra
.75 .454 .482 r
.89391 .5049 .89468 .50339 .89611 .50735 .89532 .50868 Mtetra
.714 .402 .449 r
.89532 .50868 .89611 .50735 .89742 .50994 .89663 .51114 Mtetra
.631 .294 .382 r
.89663 .51114 .89742 .50994 .89862 .5112 .89782 .51233 Mtetra
.375 .004 .2 r
.89782 .51233 .89862 .5112 .8997 .51118 .8989 .5123 Mtetra
0 0 0 r
.8989 .5123 .8997 .51118 .90067 .50987 .89987 .51104 Mtetra
.969 .929 .625 r
.89987 .51104 .90067 .50987 .90151 .50725 .90072 .50853 Mtetra
.987 .845 .612 r
.90072 .50853 .90151 .50725 .90223 .50326 .90146 .50471 Mtetra
.977 .793 .59 r
.90146 .50471 .90223 .50326 .90282 .49786 .90207 .49954 Mtetra
.97 .765 .572 r
.90207 .49954 .90282 .49786 .90328 .49106 .90256 .49302 Mtetra
.968 .751 .557 r
.90256 .49302 .90328 .49106 .90362 .48298 .90294 .48529 Mtetra
.971 .748 .543 r
.90294 .48529 .90362 .48298 .90387 .47394 .90322 .47663 Mtetra
.979 .754 .527 r
.90322 .47663 .90387 .47394 .90408 .46449 .90347 .46759 Mtetra
.992 .771 .501 r
.90347 .46759 .90408 .46449 .90432 .45543 .90375 .45891 Mtetra
.997 .797 .44 r
.90375 .45891 .90432 .45543 .90468 .4477 .90414 .45151 Mtetra
.826 .729 .202 r
.90414 .45151 .90468 .4477 .90525 .44226 .90474 .44629 Mtetra
.042 0 .332 r
.90474 .44629 .90525 .44226 .9061 .43983 .9056 .44395 Mtetra
.515 .283 .501 r
.9056 .44395 .9061 .43983 .90727 .44073 .90676 .44481 Mtetra
.66 .41 .53 r
.90676 .44481 .90727 .44073 .90873 .4448 .90821 .44869 Mtetra
.72 .463 .536 r
.90821 .44869 .90873 .4448 .91044 .45142 .90989 .45502 Mtetra
.75 .489 .536 r
.90989 .45502 .91044 .45142 .91231 .45968 .91172 .46291 Mtetra
.766 .501 .533 r
.91172 .46291 .91231 .45968 .91425 .46862 .91362 .47145 Mtetra
.775 .506 .528 r
.91362 .47145 .91425 .46862 .91617 .47739 .91551 .47982 Mtetra
.777 .504 .521 r
.91551 .47982 .91617 .47739 .91803 .48533 .91732 .48741 Mtetra
.775 .495 .512 r
.91732 .48741 .91803 .48533 .91977 .49208 .91904 .49386 Mtetra
.766 .479 .498 r
.91904 .49386 .91977 .49208 .92139 .49745 .92063 .49898 Mtetra
.748 .45 .477 r
.92063 .49898 .92139 .49745 .92287 .5014 .9221 .50275 Mtetra
.711 .396 .443 r
.9221 .50275 .92287 .5014 .92423 .50396 .92344 .50518 Mtetra
.624 .285 .376 r
.92344 .50518 .92423 .50396 .92545 .50519 .92466 .50635 Mtetra
.359 0 .193 r
.92466 .50635 .92545 .50519 .92655 .50512 .92576 .50627 Mtetra
0 0 0 r
.92576 .50627 .92655 .50512 .92753 .50375 .92674 .50495 Mtetra
.968 .927 .61 r
.92674 .50495 .92753 .50375 .92838 .50105 .92761 .50236 Mtetra
.991 .847 .602 r
.92761 .50236 .92838 .50105 .9291 .49697 .92834 .49845 Mtetra
.981 .796 .581 r
.92834 .49845 .9291 .49697 .92967 .49146 .92894 .49318 Mtetra
.974 .768 .563 r
.92894 .49318 .92967 .49146 .9301 .48453 .9294 .48655 Mtetra
.972 .754 .548 r
.9294 .48655 .9301 .48453 .93041 .47633 .92974 .4787 Mtetra
.975 .75 .534 r
.92974 .4787 .93041 .47633 .93062 .46718 .92999 .46993 Mtetra
.983 .756 .516 r
.92999 .46993 .93062 .46718 .93079 .45765 .9302 .46081 Mtetra
.995 .773 .487 r
.9302 .46081 .93079 .45765 .93099 .44855 .93045 .4521 Mtetra
.992 .795 .415 r
.93045 .4521 .93099 .44855 .93134 .44085 .93083 .44473 Mtetra
.769 .69 .145 r
.93083 .44473 .93134 .44085 .93191 .43551 .93143 .4396 Mtetra
.096 0 .359 r
.93143 .4396 .93191 .43551 .93279 .43323 .93232 .43742 Mtetra
.526 .292 .503 r
.93232 .43742 .93279 .43323 .93401 .43433 .93353 .43846 Mtetra
.664 .412 .529 r
.93353 .43846 .93401 .43433 .93554 .4386 .93505 .44254 Mtetra
.722 .463 .534 r
.93505 .44254 .93554 .4386 .93734 .44541 .93681 .44904 Mtetra
.751 .488 .533 r
.93681 .44904 .93734 .44541 .9393 .45382 .93873 .45708 Mtetra
.767 .5 .53 r
.93873 .45708 .9393 .45382 .94133 .46288 .94072 .46573 Mtetra
.775 .504 .525 r
.94072 .46573 .94133 .46288 .94335 .47172 .9427 .47418 Mtetra
.778 .502 .518 r
.9427 .47418 .94335 .47172 .94528 .47971 .94459 .48181 Mtetra
.775 .493 .508 r
.94459 .48181 .94528 .47971 .9471 .48647 .94638 .48827 Mtetra
.766 .475 .494 r
.94638 .48827 .9471 .48647 .94877 .49184 .94803 .49339 Mtetra
.746 .445 .473 r
.94803 .49339 .94877 .49184 .95031 .49577 .94954 .49714 Mtetra
.707 .39 .438 r
.94954 .49714 .95031 .49577 .9517 .49831 .95092 .49955 Mtetra
.616 .275 .37 r
.95092 .49955 .9517 .49831 .95296 .49949 .95218 .50068 Mtetra
.343 0 .185 r
.95218 .50068 .95296 .49949 .95408 .49937 .9533 .50055 Mtetra
0 0 0 r
.9533 .50055 .95408 .49937 .95507 .49793 .9543 .49917 Mtetra
.966 .924 .594 r
.9543 .49917 .95507 .49793 .95592 .49515 .95516 .4965 Mtetra
.993 .848 .591 r
.95516 .4965 .95592 .49515 .95663 .49097 .95589 .49249 Mtetra
.985 .798 .571 r
.95589 .49249 .95663 .49097 .95719 .48534 .95647 .48711 Mtetra
.979 .77 .554 r
.95647 .48711 .95719 .48534 .95759 .47829 .95691 .48036 Mtetra
.977 .756 .539 r
.95691 .48036 .95759 .47829 .95786 .46996 .95721 .47238 Mtetra
.98 .752 .523 r
.95721 .47238 .95786 .46996 .95802 .46068 .95742 .4635 Mtetra
.987 .758 .504 r
.95742 .4635 .95802 .46068 .95815 .45107 .9576 .4543 Mtetra
.997 .775 .471 r
.9576 .4543 .95815 .45107 .95833 .44194 .95781 .44556 Mtetra
.984 .791 .387 r
.95781 .44556 .95833 .44194 .95865 .43427 .95818 .43821 Mtetra
.704 .644 .086 r
.95818 .43821 .95865 .43427 .95923 .42902 .95878 .43318 Mtetra
.144 0 .381 r
.95878 .43318 .95923 .42902 .96014 .4269 .9597 .43114 Mtetra
.536 .3 .505 r
.9597 .43114 .96014 .4269 .96141 .42819 .96096 .43237 Mtetra
.667 .413 .527 r
.96096 .43237 .96141 .42819 .96302 .43266 .96256 .43664 Mtetra
.724 .463 .531 r
.96256 .43664 .96302 .43266 .96491 .43965 .96441 .44332 Mtetra
.753 .487 .53 r
.96441 .44332 .96491 .43965 .96697 .44823 .96643 .45151 Mtetra
.768 .499 .526 r
.96643 .45151 .96697 .44823 .9691 .4574 .96851 .46028 Mtetra
.776 .502 .521 r
.96851 .46028 .9691 .4574 .9712 .46631 .97057 .46879 Mtetra
.778 .499 .513 r
.97057 .46879 .9712 .46631 .97322 .47434 .97255 .47646 Mtetra
.775 .49 .503 r
.97255 .47646 .97322 .47434 .97511 .48112 .97441 .48293 Mtetra
.765 .472 .489 r
.97441 .48293 .97511 .48112 .97685 .48648 .97612 .48805 Mtetra
.745 .44 .467 r
.97612 .48805 .97685 .48648 .97844 .4904 .97769 .49178 Mtetra
.703 .383 .432 r
.97769 .49178 .97844 .4904 .97987 .4929 .97911 .49417 Mtetra
.608 .265 .363 r
.97911 .49417 .97987 .4929 .98116 .49404 .98039 .49525 Mtetra
.325 0 .178 r
.98039 .49525 .98116 .49404 .98231 .49386 .98154 .49507 Mtetra
0 0 0 r
.98154 .49507 .98231 .49386 .98331 .49235 .98255 .49362 Mtetra
.963 .92 .578 r
.98255 .49362 .98331 .49235 .98416 .48948 .98341 .49087 Mtetra
.995 .849 .579 r
.98341 .49087 .98416 .48948 .98486 .48519 .98413 .48676 Mtetra
.989 .8 .561 r
.98413 .48676 .98486 .48519 .98539 .47944 .98469 .48126 Mtetra
.983 .772 .544 r
.98469 .48126 .98539 .47944 .98577 .47226 .9851 .47438 Mtetra
.981 .758 .528 r
.9851 .47438 .98577 .47226 .98599 .46379 .98537 .46627 Mtetra
.984 .754 .512 r
.98537 .46627 .98599 .46379 .98612 .45439 .98554 .45728 Mtetra
.99 .76 .491 r
.98554 .45728 .98612 .45439 .9862 .44469 .98568 .44799 Mtetra
.998 .775 .453 r
.98568 .44799 .9862 .44469 .98634 .43552 .98586 .43921 Mtetra
.972 .784 .356 r
.98586 .43921 .98634 .43552 .98665 .42788 .98621 .43189 Mtetra
0 0 0 r
.98621 .43189 .98665 .42788 .98723 .42273 .98682 .42695 Mtetra
.186 .013 .399 r
.98682 .42695 .98723 .42273 .98817 .42077 .98777 .42507 Mtetra
.501 .301 .541 r
.53001 .64248 .53086 .63648 .53163 .63732 .53078 .64322 Mtetra
.616 .403 .57 r
.53078 .64322 .53163 .63732 .53242 .64081 .53157 .64644 Mtetra
.668 .45 .579 r
.53157 .64644 .53242 .64081 .53324 .64637 .53238 .65157 Mtetra
.696 .474 .582 r
.53238 .65157 .53324 .64637 .53406 .6532 .5332 .65789 Mtetra
.711 .486 .581 r
.5332 .65789 .53406 .6532 .5349 .66048 .53403 .66463 Mtetra
.719 .49 .579 r
.53403 .66463 .5349 .66048 .53574 .66751 .53487 .67113 Mtetra
.72 .488 .574 r
.53487 .67113 .53574 .66751 .53657 .67377 .53569 .67691 Mtetra
.715 .479 .567 r
.53569 .67691 .53657 .67377 .53739 .67897 .53651 .68171 Mtetra
.702 .461 .556 r
.53651 .68171 .53739 .67897 .53821 .68298 .53732 .6854 Mtetra
.677 .429 .539 r
.53732 .6854 .53821 .68298 .53901 .68578 .53812 .68796 Mtetra
.627 .37 .509 r
.53812 .68796 .53901 .68578 .53981 .68741 .53891 .68943 Mtetra
.516 .246 .445 r
.53891 .68943 .53981 .68741 .54059 .68791 .5397 .68985 Mtetra
.197 0 .259 r
.5397 .68985 .54059 .68791 .54136 .6873 .54047 .68925 Mtetra
0 0 0 r
.54047 .68925 .54136 .6873 .54212 .6856 .54123 .68763 Mtetra
.976 .908 .573 r
.54123 .68763 .54212 .6856 .54286 .68276 .54198 .68495 Mtetra
.989 .848 .61 r
.54198 .68495 .54286 .68276 .5436 .67874 .54271 .68117 Mtetra
.975 .805 .608 r
.54271 .68117 .5436 .67874 .54432 .67351 .54344 .67626 Mtetra
.967 .781 .601 r
.54344 .67626 .54432 .67351 .54502 .66708 .54415 .67025 Mtetra
.965 .771 .592 r
.54415 .67025 .54502 .66708 .54571 .6596 .54484 .66324 Mtetra
.97 .772 .58 r
.54484 .66324 .54571 .6596 .54639 .65137 .54553 .65555 Mtetra
.982 .784 .562 r
.54553 .65555 .54639 .65137 .54706 .64291 .54621 .64763 Mtetra
.998 .809 .523 r
.54621 .64763 .54706 .64291 .54774 .63493 .5469 .64016 Mtetra
.97 .821 .403 r
.5469 .64016 .54774 .63493 .54843 .62827 .5476 .63392 Mtetra
0 0 .027 r
.5476 .63392 .54843 .62827 .54914 .62372 .54832 .62963 Mtetra
.22 .06 .44 r
.54832 .62963 .54914 .62372 .54989 .62184 .54907 .62785 Mtetra
.51 .308 .543 r
.54907 .62785 .54989 .62184 .55068 .62283 .54986 .62873 Mtetra
.619 .405 .569 r
.54986 .62873 .55068 .62283 .55151 .62646 .55068 .63207 Mtetra
.67 .45 .578 r
.55068 .63207 .55151 .62646 .55236 .63213 .55153 .63731 Mtetra
.697 .474 .58 r
.55153 .63731 .55236 .63213 .55323 .63904 .55239 .6437 Mtetra
.712 .485 .579 r
.55239 .6437 .55323 .63904 .55411 .64636 .55326 .65048 Mtetra
.719 .489 .577 r
.55326 .65048 .55411 .64636 .55499 .65339 .55414 .65698 Mtetra
.72 .487 .572 r
.55414 .65698 .55499 .65339 .55587 .65964 .555 .66275 Mtetra
.715 .477 .565 r
.555 .66275 .55587 .65964 .55673 .66481 .55585 .66752 Mtetra
.701 .459 .553 r
.55585 .66752 .55673 .66481 .55757 .66878 .55669 .67117 Mtetra
.676 .426 .536 r
.55669 .67117 .55757 .66878 .5584 .67154 .55752 .6737 Mtetra
.624 .364 .504 r
.55752 .6737 .5584 .67154 .55921 .67312 .55833 .67513 Mtetra
.507 .236 .438 r
.55833 .67513 .55921 .67312 .56001 .67357 .55913 .67551 Mtetra
.173 0 .243 r
.55913 .67551 .56001 .67357 .56079 .67292 .55991 .67486 Mtetra
0 0 0 r
.55991 .67486 .56079 .67292 .56156 .67116 .56068 .67318 Mtetra
.977 .906 .571 r
.56068 .67318 .56156 .67116 .56231 .66825 .56143 .67044 Mtetra
.99 .847 .606 r
.56143 .67044 .56231 .66825 .56303 .66416 .56216 .66659 Mtetra
.977 .805 .604 r
.56216 .66659 .56303 .66416 .56374 .65885 .56288 .66162 Mtetra
.969 .782 .596 r
.56288 .66162 .56374 .65885 .56443 .65235 .56358 .65552 Mtetra
.968 .772 .587 r
.56358 .65552 .56443 .65235 .5651 .64479 .56426 .64846 Mtetra
.973 .774 .575 r
.56426 .64846 .5651 .64479 .56576 .63651 .56492 .6407 Mtetra
.985 .787 .555 r
.56492 .6407 .56576 .63651 .56641 .62802 .56559 .63276 Mtetra
.999 .811 .512 r
.56559 .63276 .56641 .62802 .56707 .62006 .56625 .62531 Mtetra
.957 .814 .376 r
.56625 .62531 .56707 .62006 .56775 .61346 .56694 .61913 Mtetra
0 0 .073 r
.56694 .61913 .56775 .61346 .56846 .60902 .56766 .61495 Mtetra
.247 .083 .451 r
.56766 .61495 .56846 .60902 .56922 .60728 .56842 .61329 Mtetra
.518 .315 .544 r
.56842 .61329 .56922 .60728 .57003 .60843 .56923 .61432 Mtetra
.622 .407 .569 r
.56923 .61432 .57003 .60843 .57089 .6122 .57008 .61779 Mtetra
.672 .451 .577 r
.57008 .61779 .57089 .6122 .57178 .61798 .57097 .62314 Mtetra
.699 .474 .579 r
.57097 .62314 .57178 .61798 .5727 .62497 .57188 .62961 Mtetra
.713 .485 .578 r
.57188 .62961 .5727 .62497 .57363 .63233 .57279 .63642 Mtetra
.72 .489 .575 r
.57279 .63642 .57363 .63233 .57455 .63937 .57371 .64293 Mtetra
.72 .486 .57 r
.57371 .64293 .57455 .63937 .57546 .64561 .57461 .64869 Mtetra
.715 .476 .562 r
.57461 .64869 .57546 .64561 .57636 .65075 .5755 .65344 Mtetra
.701 .457 .551 r
.5755 .65344 .57636 .65075 .57723 .65469 .57637 .65706 Mtetra
.674 .422 .532 r
.57637 .65706 .57723 .65469 .57809 .65741 .57722 .65955 Mtetra
.621 .359 .5 r
.57722 .65955 .57809 .65741 .57892 .65895 .57805 .66094 Mtetra
.499 .226 .431 r
.57805 .66094 .57892 .65895 .57974 .65935 .57886 .66127 Mtetra
.15 0 .227 r
.57886 .66127 .57974 .65935 .58053 .65865 .57966 .66058 Mtetra
.66 .775 .303 r
.57966 .66058 .58053 .65865 .5813 .65683 .58043 .65885 Mtetra
.978 .904 .568 r
.58043 .65885 .5813 .65683 .58205 .65386 .58118 .65605 Mtetra
.991 .847 .601 r
.58118 .65605 .58205 .65386 .58278 .6497 .58191 .65214 Mtetra
.979 .806 .6 r
.58191 .65214 .58278 .6497 .58348 .64431 .58262 .64709 Mtetra
.971 .783 .592 r
.58262 .64709 .58348 .64431 .58415 .63773 .58331 .64093 Mtetra
.971 .774 .582 r
.58331 .64093 .58415 .63773 .5848 .63011 .58397 .63379 Mtetra
.976 .776 .569 r
.58397 .63379 .5848 .63011 .58544 .62177 .58462 .62599 Mtetra
.988 .789 .547 r
.58462 .62599 .58544 .62177 .58607 .61326 .58526 .61803 Mtetra
1 .813 .499 r
.58526 .61803 .58607 .61326 .5867 .60532 .58591 .6106 Mtetra
.94 .804 .347 r
.58591 .6106 .5867 .60532 .58737 .59879 .58659 .60448 Mtetra
0 0 .118 r
.58659 .60448 .58737 .59879 .58808 .59446 .58731 .60041 Mtetra
.272 .104 .462 r
.58731 .60041 .58808 .59446 .58885 .59287 .58808 .59889 Mtetra
.525 .321 .545 r
.58808 .59889 .58885 .59287 .58968 .59417 .58891 .60006 Mtetra
.626 .409 .568 r
.58891 .60006 .58968 .59417 .59057 .59809 .58979 .60367 Mtetra
.674 .451 .575 r
.58979 .60367 .59057 .59809 .59151 .60399 .59072 .60913 Mtetra
.7 .474 .577 r
.59072 .60913 .59151 .60399 .59247 .61106 .59167 .61567 Mtetra
.714 .485 .576 r
.59167 .61567 .59247 .61106 .59345 .61846 .59263 .62252 Mtetra
.721 .488 .573 r
.59263 .62252 .59345 .61846 .59442 .62552 .59359 .62905 Mtetra
.721 .485 .567 r
.59359 .62905 .59442 .62552 .59538 .63174 .59454 .6348 Mtetra
.715 .474 .56 r
.59454 .6348 .59538 .63174 .59631 .63686 .59546 .63952 Mtetra
.701 .454 .548 r
.59546 .63952 .59631 .63686 .59722 .64077 .59636 .64311 Mtetra
.673 .419 .529 r
.59636 .64311 .59722 .64077 .5981 .64345 .59723 .64557 Mtetra
.618 .354 .495 r
.59723 .64557 .5981 .64345 .59895 .64495 .59809 .64693 Mtetra
.491 .216 .423 r
.59809 .64693 .59895 .64495 .59978 .64532 .59891 .64722 Mtetra
.128 0 .212 r
.59891 .64722 .59978 .64532 .60059 .64456 .59972 .64649 Mtetra
.677 .785 .315 r
.59972 .64649 .60059 .64456 .60136 .64269 .6005 .6447 Mtetra
.979 .902 .565 r
.6005 .6447 .60136 .64269 .60211 .63966 .60125 .64185 Mtetra
.992 .846 .597 r
.60125 .64185 .60211 .63966 .60283 .63543 .60198 .63788 Mtetra
.981 .806 .595 r
.60198 .63788 .60283 .63543 .60352 .62997 .60268 .63276 Mtetra
.974 .784 .587 r
.60268 .63276 .60352 .62997 .60418 .62331 .60335 .62652 Mtetra
.973 .776 .577 r
.60335 .62652 .60418 .62331 .60481 .61562 .604 .61932 Mtetra
.979 .778 .563 r
.604 .61932 .60481 .61562 .60542 .60723 .60463 .61148 Mtetra
.991 .791 .539 r
.60463 .61148 .60542 .60723 .60603 .5987 .60525 .6035 Mtetra
1 .814 .485 r
.60525 .6035 .60603 .5987 .60665 .59078 .60588 .59609 Mtetra
.919 .79 .314 r
.60588 .59609 .60665 .59078 .60731 .58433 .60655 .59004 Mtetra
0 0 .16 r
.60655 .59004 .60731 .58433 .60802 .58012 .60727 .58608 Mtetra
.296 .124 .471 r
.60727 .58608 .60802 .58012 .6088 .57868 .60805 .5847 Mtetra
.533 .327 .547 r
.60805 .5847 .6088 .57868 .60965 .58014 .60891 .58603 Mtetra
.629 .411 .567 r
.60891 .58603 .60965 .58014 .61058 .58421 .60983 .58978 Mtetra
.676 .452 .574 r
.60983 .58978 .61058 .58421 .61156 .59023 .61079 .59535 Mtetra
.701 .474 .575 r
.61079 .59535 .61156 .59023 .61258 .59738 .61179 .60197 Mtetra
.715 .484 .574 r
.61179 .60197 .61258 .59738 .6136 .60484 .6128 .60886 Mtetra
.721 .487 .571 r
.6128 .60886 .6136 .60484 .61462 .61191 .61381 .61541 Mtetra
.722 .483 .565 r
.61381 .61541 .61462 .61191 .61562 .61812 .61479 .62115 Mtetra
.715 .473 .557 r
.61479 .62115 .61562 .61812 .61659 .62323 .61575 .62586 Mtetra
.701 .452 .545 r
.61575 .62586 .61659 .62323 .61753 .6271 .61668 .62943 Mtetra
.672 .416 .525 r
.61668 .62943 .61753 .6271 .61844 .62976 .61758 .63185 Mtetra
.615 .349 .491 r
.61758 .63185 .61844 .62976 .61931 .63122 .61845 .63318 Mtetra
.484 .206 .416 r
.61845 .63318 .61931 .63122 .62016 .63154 .6193 .63344 Mtetra
.108 0 .198 r
.6193 .63344 .62016 .63154 .62097 .63075 .62012 .63266 Mtetra
.691 .793 .323 r
.62012 .63266 .62097 .63075 .62176 .62882 .6209 .63083 Mtetra
.979 .9 .561 r
.6209 .63083 .62176 .62882 .62251 .62574 .62166 .62793 Mtetra
.993 .846 .592 r
.62166 .62793 .62251 .62574 .62322 .62144 .62238 .62389 Mtetra
.983 .807 .59 r
.62238 .62389 .62322 .62144 .6239 .6159 .62307 .6187 Mtetra
.976 .786 .582 r
.62307 .6187 .6239 .6159 .62454 .60917 .62373 .6124 Mtetra
.976 .777 .571 r
.62373 .6124 .62454 .60917 .62515 .60141 .62436 .60514 Mtetra
.982 .78 .556 r
.62436 .60514 .62515 .60141 .62574 .59297 .62496 .59725 Mtetra
.994 .794 .53 r
.62496 .59725 .62574 .59297 .62633 .58443 .62556 .58926 Mtetra
.998 .814 .469 r
.62556 .58926 .62633 .58443 .62693 .57654 .62618 .58188 Mtetra
.893 .773 .278 r
.62618 .58188 .62693 .57654 .62757 .57017 .62684 .57591 Mtetra
0 0 .2 r
.62684 .57591 .62757 .57017 .62828 .56608 .62756 .57206 Mtetra
.318 .143 .479 r
.62756 .57206 .62828 .56608 .62908 .5648 .62836 .57083 Mtetra
.54 .333 .548 r
.62836 .57083 .62908 .5648 .62996 .56643 .62924 .57231 Mtetra
.632 .413 .567 r
.62924 .57231 .62996 .56643 .63093 .57065 .6302 .5762 Mtetra
.678 .453 .573 r
.6302 .5762 .63093 .57065 .63195 .57679 .63121 .58189 Mtetra
.703 .473 .574 r
.63121 .58189 .63195 .57679 .63302 .58403 .63226 .58859 Mtetra
.716 .484 .572 r
.63226 .58859 .63302 .58403 .6341 .59154 .63331 .59554 Mtetra
.722 .486 .568 r
.63331 .59554 .6341 .59154 .63516 .59863 .63436 .6021 Mtetra
.722 .482 .563 r
.63436 .6021 .63516 .59863 .63621 .60484 .63539 .60785 Mtetra
.716 .471 .554 r
.63539 .60785 .63621 .60484 .63721 .60993 .63639 .61254 Mtetra
.701 .45 .542 r
.63639 .61254 .63721 .60993 .63819 .61378 .63735 .61609 Mtetra
.671 .413 .522 r
.63735 .61609 .63819 .61378 .63912 .61641 .63828 .61849 Mtetra
.612 .344 .487 r
.63828 .61849 .63912 .61641 .64002 .61784 .63917 .61978 Mtetra
.477 .197 .41 r
.63917 .61978 .64002 .61784 .64088 .61813 .64003 .62001 Mtetra
.09 0 .185 r
.64003 .62001 .64088 .61813 .64171 .61729 .64086 .6192 Mtetra
.701 .797 .328 r
.64086 .6192 .64171 .61729 .6425 .61532 .64165 .61733 Mtetra
.979 .899 .556 r
.64165 .61733 .6425 .61532 .64325 .61218 .64241 .61437 Mtetra
.994 .846 .586 r
.64241 .61437 .64325 .61218 .64396 .60781 .64313 .61027 Mtetra
.985 .808 .584 r
.64313 .61027 .64396 .60781 .64463 .60221 .64381 .60502 Mtetra
.979 .787 .576 r
.64381 .60502 .64463 .60221 .64525 .5954 .64445 .59865 Mtetra
.979 .779 .565 r
.64445 .59865 .64525 .5954 .64584 .58757 .64506 .59133 Mtetra
.985 .782 .548 r
.64506 .59133 .64584 .58757 .64641 .57909 .64565 .5834 Mtetra
.996 .796 .519 r
.64565 .5834 .64641 .57909 .64697 .57053 .64623 .5754 Mtetra
.996 .813 .452 r
.64623 .5754 .64697 .57053 .64755 .56268 .64683 .56805 Mtetra
.861 .751 .239 r
.64683 .56805 .64755 .56268 .64818 .55639 .64748 .56216 Mtetra
0 0 .238 r
.64748 .56216 .64818 .55639 .64889 .55244 .6482 .55844 Mtetra
.339 .161 .487 r
.6482 .55844 .64889 .55244 .64971 .55132 .64902 .55736 Mtetra
.547 .338 .548 r
.64902 .55736 .64971 .55132 .65062 .55311 .64993 .559 Mtetra
.635 .415 .566 r
.64993 .559 .65062 .55311 .65163 .55749 .65092 .56304 Mtetra
.68 .453 .571 r
.65092 .56304 .65163 .55749 .6527 .56377 .65198 .56885 Mtetra
.704 .473 .572 r
.65198 .56885 .6527 .56377 .65382 .5711 .65308 .57563 Mtetra
.717 .483 .57 r
.65308 .57563 .65382 .5711 .65495 .57866 .65419 .58263 Mtetra
.723 .485 .566 r
.65419 .58263 .65495 .57866 .65607 .58577 .65529 .58922 Mtetra
.723 .481 .56 r
.65529 .58922 .65607 .58577 .65716 .59199 .65636 .59497 Mtetra
.716 .47 .552 r
.65636 .59497 .65716 .59199 .65821 .59707 .65739 .59966 Mtetra
.701 .448 .539 r
.65739 .59966 .65821 .59707 .65922 .60091 .65839 .60319 Mtetra
.67 .41 .518 r
.65839 .60319 .65922 .60091 .66018 .60351 .65934 .60557 Mtetra
.61 .339 .482 r
.65934 .60557 .66018 .60351 .6611 .60491 .66026 .60684 Mtetra
.47 .188 .403 r
.66026 .60684 .6611 .60491 .66198 .60517 .66114 .60704 Mtetra
.074 0 .175 r
.66114 .60704 .66198 .60517 .66282 .60429 .66198 .60619 Mtetra
.706 .799 .329 r
.66198 .60619 .66282 .60429 .66361 .60227 .66278 .60428 Mtetra
.978 .897 .55 r
.66278 .60428 .66361 .60227 .66436 .59908 .66354 .60127 Mtetra
.995 .847 .58 r
.66354 .60127 .66436 .59908 .66507 .59465 .66425 .59712 Mtetra
.987 .809 .579 r
.66425 .59712 .66507 .59465 .66572 .58897 .66492 .5918 Mtetra
.982 .789 .57 r
.66492 .5918 .66572 .58897 .66633 .58209 .66555 .58537 Mtetra
.982 .781 .558 r
.66555 .58537 .66633 .58209 .6669 .5742 .66614 .57799 Mtetra
.988 .785 .54 r
.66614 .57799 .6669 .5742 .66744 .56567 .6667 .57002 Mtetra
.998 .798 .508 r
.6667 .57002 .66744 .56567 .66797 .55711 .66726 .56201 Mtetra
.991 .812 .432 r
.66726 .56201 .66797 .55711 .66854 .5493 .66785 .5547 Mtetra
.823 .725 .196 r
.66785 .5547 .66854 .5493 .66916 .5431 .66849 .5489 Mtetra
0 0 .272 r
.66849 .5489 .66916 .5431 .66988 .53928 .66921 .5453 Mtetra
.359 .177 .494 r
.66921 .5453 .66988 .53928 .67071 .53832 .67005 .54438 Mtetra
.554 .343 .549 r
.67005 .54438 .67071 .53832 .67165 .5403 .67099 .54618 Mtetra
.638 .417 .565 r
.67099 .54618 .67165 .5403 .67271 .54484 .67203 .55038 Mtetra
.682 .454 .57 r
.67203 .55038 .67271 .54484 .67383 .55125 .67314 .55631 Mtetra
.705 .473 .57 r
.67314 .55631 .67383 .55125 .67501 .55867 .67429 .56319 Mtetra
.718 .483 .568 r
.67429 .56319 .67501 .55867 .67619 .56629 .67545 .57025 Mtetra
.724 .485 .564 r
.67545 .57025 .67619 .56629 .67736 .57344 .6766 .57687 Mtetra
.724 .48 .558 r
.6766 .57687 .67736 .57344 .6785 .57967 .67771 .58263 Mtetra
.717 .468 .549 r
.67771 .58263 .6785 .57967 .67959 .58474 .67879 .58731 Mtetra
.701 .446 .536 r
.67879 .58731 .67959 .58474 .68063 .58856 .67982 .59083 Mtetra
.67 .407 .515 r
.67982 .59083 .68063 .58856 .68163 .59114 .6808 .5932 Mtetra
.607 .334 .478 r
.6808 .5932 .68163 .59114 .68257 .59253 .68174 .59445 Mtetra
.464 .181 .398 r
.68174 .59445 .68257 .59253 .68347 .59275 .68263 .59462 Mtetra
.062 0 .167 r
.68263 .59462 .68347 .59275 .68432 .59184 .68349 .59374 Mtetra
.707 .798 .326 r
.68349 .59374 .68432 .59184 .68512 .58978 .68429 .59179 Mtetra
.977 .895 .543 r
.68429 .59179 .68512 .58978 .68587 .58653 .68505 .58874 Mtetra
.996 .847 .574 r
.68505 .58874 .68587 .58653 .68657 .58204 .68576 .58453 Mtetra
.989 .811 .572 r
.68576 .58453 .68657 .58204 .68721 .57629 .68642 .57915 Mtetra
.985 .791 .563 r
.68642 .57915 .68721 .57629 .6878 .56935 .68703 .57265 Mtetra
.985 .783 .55 r
.68703 .57265 .6878 .56935 .68834 .56139 .6876 .56521 Mtetra
.991 .787 .531 r
.6876 .56521 .68834 .56139 .68886 .55282 .68814 .5572 Mtetra
.999 .799 .495 r
.68814 .5572 .68886 .55282 .68937 .54425 .68868 .5492 Mtetra
.984 .808 .409 r
.68868 .5492 .68937 .54425 .68991 .53648 .68925 .54193 Mtetra
.778 .693 .15 r
.68925 .54193 .68991 .53648 .69053 .53038 .68989 .53621 Mtetra
0 0 .303 r
.68989 .53621 .69053 .53038 .69125 .5267 .69062 .53275 Mtetra
.377 .193 .5 r
.69062 .53275 .69125 .5267 .6921 .52591 .69147 .53198 Mtetra
.56 .348 .55 r
.69147 .53198 .6921 .52591 .69308 .52807 .69245 .53396 Mtetra
.642 .418 .564 r
.69245 .53396 .69308 .52807 .69418 .53278 .69353 .53831 Mtetra
.684 .454 .568 r
.69353 .53831 .69418 .53278 .69537 .53932 .69469 .54438 Mtetra
.707 .473 .568 r
.69469 .54438 .69537 .53932 .6966 .54685 .6959 .55135 Mtetra
.719 .482 .566 r
.6959 .55135 .6966 .54685 .69784 .55454 .69712 .55848 Mtetra
.725 .484 .562 r
.69712 .55848 .69784 .55454 .69907 .56172 .69832 .56513 Mtetra
.724 .479 .555 r
.69832 .56513 .69907 .56172 .70025 .56796 .69948 .5709 Mtetra
.717 .467 .546 r
.69948 .5709 .70025 .56796 .70139 .57303 .7006 .57559 Mtetra
.7 .444 .533 r
.7006 .57559 .70139 .57303 .70247 .57685 .70166 .5791 Mtetra
.669 .404 .511 r
.70166 .5791 .70247 .57685 .70349 .57941 .70267 .58145 Mtetra
.605 .33 .474 r
.70267 .58145 .70349 .57941 .70446 .58077 .70364 .58269 Mtetra
.459 .174 .392 r
.70364 .58269 .70446 .58077 .70537 .58097 .70455 .58284 Mtetra
.053 0 .162 r
.70455 .58284 .70537 .58097 .70623 .58003 .70541 .58193 Mtetra
.704 .793 .319 r
.70541 .58193 .70623 .58003 .70704 .57793 .70623 .57994 Mtetra
.975 .893 .533 r
.70623 .57994 .70704 .57793 .70779 .57462 .70699 .57684 Mtetra
.997 .848 .566 r
.70699 .57684 .70779 .57462 .70848 .57007 .70769 .57258 Mtetra
.991 .812 .565 r
.70769 .57258 .70848 .57007 .70911 .56426 .70834 .56714 Mtetra
.987 .793 .556 r
.70834 .56714 .70911 .56426 .70968 .55724 .70894 .56057 Mtetra
.988 .785 .542 r
.70894 .56057 .70968 .55724 .7102 .54922 .70948 .55308 Mtetra
.994 .789 .521 r
.70948 .55308 .7102 .54922 .71069 .54061 .71 .54504 Mtetra
1 .8 .481 r
.71 .54504 .71069 .54061 .71118 .53204 .71052 .53703 Mtetra
.975 .803 .384 r
.71052 .53703 .71118 .53204 .71171 .52431 .71107 .5298 Mtetra
.727 .656 .101 r
.71107 .5298 .71171 .52431 .71232 .5183 .7117 .52418 Mtetra
0 0 .331 r
.7117 .52418 .71232 .5183 .71304 .51477 .71244 .52085 Mtetra
.394 .207 .505 r
.71244 .52085 .71304 .51477 .71392 .51416 .71332 .52025 Mtetra
.566 .353 .55 r
.71332 .52025 .71392 .51416 .71494 .5165 .71433 .5224 Mtetra
.645 .42 .563 r
.71433 .5224 .71494 .5165 .71609 .52138 .71546 .52692 Mtetra
.685 .454 .566 r
.71546 .52692 .71609 .52138 .71733 .52807 .71668 .53312 Mtetra
.708 .473 .566 r
.71668 .53312 .71733 .52807 .71862 .53571 .71795 .5402 Mtetra
.721 .481 .564 r
.71795 .5402 .71862 .53571 .71993 .54346 .71922 .54739 Mtetra
.726 .483 .559 r
.71922 .54739 .71993 .54346 .72121 .55068 .72047 .55408 Mtetra
.725 .478 .553 r
.72047 .55408 .72121 .55068 .72244 .55694 .72169 .55987 Mtetra
.717 .465 .543 r
.72169 .55987 .72244 .55694 .72362 .56202 .72284 .56456 Mtetra
.7 .442 .529 r
.72284 .56456 .72362 .56202 .72474 .56582 .72395 .56807 Mtetra
.668 .401 .508 r
.72395 .56807 .72474 .56582 .72579 .56838 .72499 .57042 Mtetra
.603 .326 .47 r
.72499 .57042 .72579 .56838 .72679 .56972 .72598 .57164 Mtetra
.454 .167 .388 r
.72598 .57164 .72679 .56972 .72772 .5699 .72691 .57177 Mtetra
.047 0 .159 r
.72691 .57177 .72772 .5699 .7286 .56892 .72779 .57083 Mtetra
.696 .786 .308 r
.72779 .57083 .7286 .56892 .72941 .56678 .72861 .56881 Mtetra
.971 .891 .522 r
.72861 .56881 .72941 .56678 .73016 .56342 .72937 .56566 Mtetra
.998 .849 .557 r
.72937 .56566 .73016 .56342 .73084 .55881 .73007 .56134 Mtetra
.994 .814 .556 r
.73007 .56134 .73084 .55881 .73146 .55293 .73071 .55584 Mtetra
.99 .795 .547 r
.73071 .55584 .73146 .55293 .73201 .54583 .73128 .54921 Mtetra
.991 .788 .533 r
.73128 .54921 .73201 .54583 .73251 .53775 .73181 .54166 Mtetra
.996 .791 .509 r
.73181 .54166 .73251 .53775 .73297 .5291 .7323 .53358 Mtetra
.999 .801 .465 r
.7323 .53358 .73297 .5291 .73343 .52053 .7328 .52557 Mtetra
.961 .795 .355 r
.7328 .52557 .73343 .52053 .73394 .51284 .73334 .51839 Mtetra
0 0 0 r
.73334 .51839 .73394 .51284 .73454 .50694 .73396 .51286 Mtetra
.009 0 .357 r
.73396 .51286 .73454 .50694 .73528 .50355 .73472 .50967 Mtetra
.41 .22 .51 r
.73472 .50967 .73528 .50355 .73618 .50312 .73562 .50924 Mtetra
.572 .357 .55 r
.73562 .50924 .73618 .50312 .73724 .50565 .73667 .51157 Mtetra
.647 .421 .562 r
.73667 .51157 .73724 .50565 .73845 .5107 .73785 .51625 Mtetra
.687 .455 .565 r
.73785 .51625 .73845 .5107 .73975 .51754 .73913 .52259 Mtetra
.709 .473 .564 r
.73913 .52259 .73975 .51754 .74111 .52529 .74045 .52978 Mtetra
.721 .481 .561 r
.74045 .52978 .74111 .52529 .74248 .53312 .74179 .53704 Mtetra
.726 .482 .557 r
.74179 .53704 .74248 .53312 .74381 .54038 .7431 .54377 Mtetra
.725 .476 .55 r
.7431 .54377 .74381 .54038 .7451 .54667 .74436 .54959 Mtetra
.717 .463 .54 r
.74436 .54959 .7451 .54667 .74633 .55174 .74556 .55429 Mtetra
.7 .439 .526 r
.74556 .55429 .74633 .55174 .74748 .55555 .7467 .5578 Mtetra
.667 .398 .505 r
.7467 .5578 .74748 .55555 .74857 .55809 .74777 .56013 Mtetra
.6 .321 .466 r
.74777 .56013 .74857 .55809 .74959 .55942 .74879 .56134 Mtetra
.449 .162 .384 r
.74879 .56134 .74959 .55942 .75054 .55957 .74974 .56145 Mtetra
.043 0 .158 r
.74974 .56145 .75054 .55957 .75143 .55856 .75063 .56049 Mtetra
.685 .775 .294 r
.75063 .56049 .75143 .55856 .75225 .55638 .75146 .55843 Mtetra
.967 .888 .509 r
.75146 .55843 .75225 .55638 .753 .55297 .75222 .55524 Mtetra
.998 .849 .546 r
.75222 .55524 .753 .55297 .75368 .5483 .75292 .55086 Mtetra
.996 .816 .547 r
.75292 .55086 .75368 .5483 .75428 .54234 .75354 .54529 Mtetra
.993 .797 .538 r
.75354 .54529 .75428 .54234 .75481 .53517 .7541 .53859 Mtetra
.994 .79 .522 r
.7541 .53859 .75481 .53517 .75528 .52702 .7546 .53099 Mtetra
.998 .792 .496 r
.7546 .53099 .75528 .52702 .75571 .51833 .75507 .52287 Mtetra
.997 .8 .446 r
.75507 .52287 .75571 .51833 .75615 .50975 .75555 .51485 Mtetra
.944 .784 .323 r
.75555 .51485 .75615 .50975 .75664 .50211 .75607 .50772 Mtetra
0 0 .002 r
.75607 .50772 .75664 .50211 .75724 .49631 .7567 .50228 Mtetra
.055 0 .379 r
.7567 .50228 .75724 .49631 .75799 .49307 .75746 .49924 Mtetra
.425 .233 .514 r
.75746 .49924 .75799 .49307 .75892 .49282 .75839 .49898 Mtetra
.578 .361 .55 r
.75839 .49898 .75892 .49282 .76002 .49554 .75948 .50149 Mtetra
.65 .423 .561 r
.75948 .50149 .76002 .49554 .76128 .50078 .76072 .50634 Mtetra
.689 .455 .563 r
.76072 .50634 .76128 .50078 .76265 .50777 .76206 .51283 Mtetra
.711 .472 .562 r
.76206 .51283 .76265 .50777 .76408 .51562 .76345 .52012 Mtetra
.722 .48 .559 r
.76345 .52012 .76408 .51562 .76551 .52353 .76485 .52745 Mtetra
.727 .481 .554 r
.76485 .52745 .76551 .52353 .76691 .53084 .76621 .53423 Mtetra
.726 .475 .547 r
.76621 .53423 .76691 .53084 .76826 .53715 .76753 .54007 Mtetra
.717 .461 .538 r
.76753 .54007 .76826 .53715 .76953 .54224 .76878 .54478 Mtetra
.699 .437 .523 r
.76878 .54478 .76953 .54224 .77072 .54604 .76995 .54829 Mtetra
.665 .395 .501 r
.76995 .54829 .77072 .54604 .77184 .54857 .77106 .55062 Mtetra
.597 .317 .463 r
.77106 .55062 .77184 .54857 .77289 .54988 .7721 .55181 Mtetra
.444 .156 .381 r
.7721 .55181 .77289 .54988 .77386 .55001 .77307 .55191 Mtetra
.041 0 .16 r
.77307 .55191 .77386 .55001 .77476 .54897 .77398 .55092 Mtetra
.671 .762 .276 r
.77398 .55092 .77476 .54897 .77559 .54674 .77481 .54882 Mtetra
.961 .884 .494 r
.77481 .54882 .77559 .54674 .77634 .54328 .77558 .54558 Mtetra
.998 .85 .535 r
.77558 .54558 .77634 .54328 .77701 .53854 .77627 .54114 Mtetra
.998 .817 .536 r
.77627 .54114 .77701 .53854 .77759 .5325 .77688 .5355 Mtetra
.995 .798 .527 r
.77688 .5355 .77759 .5325 .7781 .52525 .77742 .52873 Mtetra
.996 .791 .51 r
.77742 .52873 .7781 .52525 .77854 .51704 .7779 .52106 Mtetra
.999 .793 .482 r
.7779 .52106 .77854 .51704 .77895 .5083 .77834 .5129 Mtetra
.994 .799 .426 r
.77834 .5129 .77895 .5083 .77936 .49971 .7788 .50488 Mtetra
.921 .769 .287 r
.7788 .50488 .77936 .49971 .77984 .49212 .77931 .49779 Mtetra
0 0 .053 r
.77931 .49779 .77984 .49212 .78043 .48641 .77993 .49245 Mtetra
.097 0 .399 r
.77993 .49245 .78043 .48641 .7812 .48333 .7807 .48955 Mtetra
.438 .244 .518 r
.7807 .48955 .7812 .48333 .78216 .48326 .78166 .48947 Mtetra
.583 .365 .55 r
.78166 .48947 .78216 .48326 .78331 .48618 .7828 .49216 Mtetra
.653 .424 .559 r
.7828 .49216 .78331 .48618 .78463 .49159 .7841 .49718 Mtetra
.69 .455 .561 r
.7841 .49718 .78463 .49159 .78607 .49873 .7855 .50381 Mtetra
.712 .472 .56 r
.7855 .50381 .78607 .49873 .78756 .50671 .78696 .51121 Mtetra
.723 .479 .557 r
.78696 .51121 .78756 .50671 .78907 .51469 .78842 .51862 Mtetra
.728 .479 .552 r
.78842 .51862 .78907 .51469 .79053 .52205 .78985 .52545 Mtetra
.726 .473 .545 r
.78985 .52545 .79053 .52205 .79193 .52838 .79122 .53131 Mtetra
.717 .459 .535 r
.79122 .53131 .79193 .52838 .79325 .53348 .79251 .53603 Mtetra
.699 .434 .52 r
.79251 .53603 .79325 .53348 .79449 .53728 .79373 .53954 Mtetra
.663 .391 .498 r
.79373 .53954 .79449 .53728 .79564 .5398 .79487 .54187 Mtetra
.594 .313 .459 r
.79487 .54187 .79564 .5398 .79672 .5411 .79594 .54305 Mtetra
.439 .151 .378 r
.79594 .54305 .79672 .5411 .79771 .5412 .79693 .54312 Mtetra
.04 0 .163 r
.79693 .54312 .79771 .5412 .79863 .54013 .79785 .5421 Mtetra
0 0 0 r
.79785 .5421 .79863 .54013 .79946 .53785 .79869 .53996 Mtetra
.954 .878 .476 r
.79869 .53996 .79946 .53785 .80021 .53433 .79946 .53666 Mtetra
.997 .849 .521 r
.79946 .53666 .80021 .53433 .80087 .52951 .80014 .53216 Mtetra
.999 .818 .525 r
.80014 .53216 .80087 .52951 .80144 .52339 .80074 .52644 Mtetra
.997 .8 .515 r
.80074 .52644 .80144 .52339 .80192 .51606 .80126 .5196 Mtetra
.998 .793 .497 r
.80126 .5196 .80192 .51606 .80233 .50777 .80171 .51186 Mtetra
.999 .794 .466 r
.80171 .51186 .80233 .50777 .80271 .49898 .80213 .50366 Mtetra
.988 .795 .403 r
.80213 .50366 .80271 .49898 .8031 .49038 .80256 .49563 Mtetra
.893 .75 .247 r
.80256 .49563 .8031 .49038 .80356 .48284 .80306 .48858 Mtetra
0 0 .103 r
.80306 .48858 .80356 .48284 .80415 .47723 .80368 .48334 Mtetra
.136 0 .417 r
.80368 .48334 .80415 .47723 .80493 .4743 .80447 .48058 Mtetra
.451 .254 .521 r
.80447 .48058 .80493 .4743 .80592 .47442 .80547 .48067 Mtetra
.588 .368 .55 r
.80547 .48067 .80592 .47442 .80713 .47752 .80666 .48355 Mtetra
.655 .425 .558 r
.80666 .48355 .80713 .47752 .80851 .48312 .80801 .48874 Mtetra
.692 .455 .559 r
.80801 .48874 .80851 .48312 .81002 .49041 .80948 .49551 Mtetra
.713 .471 .558 r
.80948 .49551 .81002 .49041 .81159 .4985 .81101 .50302 Mtetra
.724 .478 .554 r
.81101 .50302 .81159 .4985 .81316 .50656 .81254 .51051 Mtetra
.728 .478 .549 r
.81254 .51051 .81316 .50656 .8147 .51397 .81403 .51738 Mtetra
.726 .471 .542 r
.81403 .51738 .8147 .51397 .81615 .52033 .81546 .52327 Mtetra
.717 .457 .532 r
.81546 .52327 .81615 .52033 .81753 .52544 .8168 .528 Mtetra
.698 .431 .517 r
.8168 .528 .81753 .52544 .81881 .52923 .81806 .53151 Mtetra
.661 .387 .495 r
.81806 .53151 .81881 .52923 .82 .53175 .81924 .53383 Mtetra
.59 .308 .456 r
.81924 .53383 .82 .53175 .8211 .53302 .82033 .53499 Mtetra
.433 .146 .375 r
.82033 .53499 .8211 .53302 .82211 .5331 .82135 .53504 Mtetra
.039 0 .166 r
.82135 .53504 .82211 .5331 .82304 .53198 .82228 .53398 Mtetra
0 0 0 r
.82228 .53398 .82304 .53198 .82388 .52965 .82313 .5318 Mtetra
.945 .872 .457 r
.82313 .5318 .82388 .52965 .82463 .52607 .8239 .52844 Mtetra
.996 .848 .507 r
.8239 .52844 .82463 .52607 .82528 .52117 .82457 .52387 Mtetra
1 .819 .511 r
.82457 .52387 .82528 .52117 .82583 .51497 .82515 .51808 Mtetra
.999 .801 .502 r
.82515 .51808 .82583 .51497 .82629 .50754 .82565 .51115 Mtetra
.999 .793 .483 r
.82565 .51115 .82629 .50754 .82667 .49917 .82608 .50334 Mtetra
.998 .793 .448 r
.82608 .50334 .82667 .49917 .82702 .49033 .82648 .49508 Mtetra
.979 .79 .377 r
.82648 .49508 .82702 .49033 .82738 .48171 .82688 .48704 Mtetra
.86 .726 .205 r
.82688 .48704 .82738 .48171 .82782 .47421 .82737 .48003 Mtetra
0 0 .149 r
.82737 .48003 .82782 .47421 .82842 .4687 .82799 .47488 Mtetra
.17 .027 .432 r
.82799 .47488 .82842 .4687 .82921 .46592 .8288 .47227 Mtetra
.462 .263 .524 r
.8288 .47227 .82921 .46592 .83024 .46622 .82983 .47254 Mtetra
.592 .371 .55 r
.82983 .47254 .83024 .46622 .8315 .46952 .83107 .47559 Mtetra
.657 .425 .557 r
.83107 .47559 .8315 .46952 .83296 .4753 .83249 .48096 Mtetra
.693 .455 .558 r
.83249 .48096 .83296 .4753 .83454 .48275 .83403 .48787 Mtetra
.713 .47 .556 r
.83403 .48787 .83454 .48275 .83619 .49095 .83563 .49549 Mtetra
.724 .477 .552 r
.83563 .49549 .83619 .49095 .83783 .49909 .83724 .50305 Mtetra
.728 .476 .546 r
.83724 .50305 .83783 .49909 .83943 .50655 .83879 .50997 Mtetra
.726 .469 .539 r
.83879 .50997 .83943 .50655 .84095 .51293 .84028 .51589 Mtetra
.716 .455 .529 r
.84028 .51589 .84095 .51293 .84238 .51804 .84167 .52063 Mtetra
.696 .428 .514 r
.84167 .52063 .84238 .51804 .8437 .52184 .84297 .52413 Mtetra
.659 .383 .491 r
.84297 .52413 .8437 .52184 .84493 .52433 .84418 .52644 Mtetra
.586 .303 .453 r
.84418 .52644 .84493 .52433 .84606 .52559 .84531 .52758 Mtetra
.427 .14 .373 r
.84531 .52758 .84606 .52559 .84709 .52563 .84634 .52761 Mtetra
.037 0 .17 r
.84634 .52761 .84709 .52563 .84804 .52447 .84729 .52651 Mtetra
0 0 0 r
.84729 .52651 .84804 .52447 .84888 .52209 .84815 .52427 Mtetra
.935 .864 .436 r
.84815 .52427 .84888 .52209 .84963 .51843 .84891 .52085 Mtetra
.993 .847 .49 r
.84891 .52085 .84963 .51843 .85027 .51345 .84958 .5162 Mtetra
1 .819 .497 r
.84958 .5162 .85027 .51345 .8508 .50715 .85015 .51032 Mtetra
1 .801 .488 r
.85015 .51032 .8508 .50715 .85123 .49963 .85062 .50331 Mtetra
.999 .794 .467 r
.85062 .50331 .85123 .49963 .85159 .49117 .85102 .49542 Mtetra
.996 .792 .428 r
.85102 .49542 .85159 .49117 .8519 .48226 .85139 .4871 Mtetra
.968 .782 .349 r
.85139 .4871 .8519 .48226 .85224 .47363 .85177 .47905 Mtetra
.821 .698 .16 r
.85177 .47905 .85224 .47363 .85266 .46616 .85224 .47207 Mtetra
0 0 .192 r
.85224 .47207 .85266 .46616 .85325 .46075 .85287 .46702 Mtetra
.201 .053 .445 r
.85287 .46702 .85325 .46075 .85407 .45812 .8537 .46455 Mtetra
.472 .272 .526 r
.8537 .46455 .85407 .45812 .85514 .45861 .85477 .46499 Mtetra
.596 .374 .549 r
.85477 .46499 .85514 .45861 .85646 .46211 .85606 .46823 Mtetra
.659 .426 .555 r
.85606 .46823 .85646 .46211 .85798 .46807 .85755 .47376 Mtetra
.694 .454 .556 r
.85755 .47376 .85798 .46807 .85965 .47567 .85917 .48082 Mtetra
.714 .469 .553 r
.85917 .48082 .85965 .47567 .86137 .48398 .86085 .48855 Mtetra
.725 .475 .549 r
.86085 .48855 .86137 .48398 .8631 .4922 .86253 .49618 Mtetra
.728 .475 .544 r
.86253 .49618 .8631 .4922 .86477 .4997 .86415 .50314 Mtetra
.726 .467 .536 r
.86415 .50314 .86477 .4997 .86635 .50611 .86569 .50908 Mtetra
.715 .452 .526 r
.86569 .50908 .86635 .50611 .86783 .51123 .86714 .51383 Mtetra
.695 .425 .511 r
.86714 .51383 .86783 .51123 .8692 .51501 .86849 .51733 Mtetra
.656 .379 .488 r
.86849 .51733 .8692 .51501 .87046 .51749 .86973 .51962 Mtetra
.582 .297 .449 r
.86973 .51962 .87046 .51749 .87162 .51872 .87089 .52075 Mtetra
.42 .134 .37 r
.87089 .52075 .87162 .51872 .87268 .51873 .87194 .52074 Mtetra
.035 0 .174 r
.87194 .52074 .87268 .51873 .87364 .51752 .87291 .5196 Mtetra
0 0 0 r
.87291 .5196 .87364 .51752 .87449 .51507 .87377 .5173 Mtetra
.923 .854 .413 r
.87377 .5173 .87449 .51507 .87523 .51134 .87454 .51381 Mtetra
.989 .844 .472 r
.87454 .51381 .87523 .51134 .87586 .50627 .87519 .50908 Mtetra
.999 .818 .481 r
.87519 .50908 .87586 .50627 .87637 .49986 .87574 .5031 Mtetra
.999 .801 .472 r
.87574 .5031 .87637 .49986 .87677 .49224 .87619 .49599 Mtetra
.998 .793 .449 r
.87619 .49599 .87677 .49224 .87709 .48369 .87657 .48801 Mtetra
.991 .789 .407 r
.87657 .48801 .87709 .48369 .87738 .47471 .8769 .47964 Mtetra
.953 .772 .318 r
.8769 .47964 .87738 .47471 .87768 .46606 .87726 .47157 Mtetra
.777 .666 .114 r
.87726 .47157 .87768 .46606 .87809 .45862 .87772 .46463 Mtetra
0 0 .231 r
.87772 .46463 .87809 .45862 .87869 .45331 .87834 .45966 Mtetra
.229 .076 .456 r
.87834 .45966 .87869 .45331 .87952 .45083 .8792 .45733 Mtetra
.482 .279 .528 r
.8792 .45733 .87952 .45083 .88064 .4515 .88031 .45794 Mtetra
.6 .376 .548 r
.88031 .45794 .88064 .4515 .88202 .45519 .88167 .46136 Mtetra
.661 .426 .554 r
.88167 .46136 .88202 .45519 .88362 .46133 .88323 .46707 Mtetra
.695 .454 .554 r
.88323 .46707 .88362 .46133 .88537 .46908 .88493 .47427 Mtetra
.715 .468 .551 r
.88493 .47427 .88537 .46908 .88718 .47751 .88668 .4821 Mtetra
.725 .474 .547 r
.88668 .4821 .88718 .47751 .88898 .48581 .88843 .48981 Mtetra
.728 .473 .541 r
.88843 .48981 .88898 .48581 .89072 .49335 .89013 .49682 Mtetra
.725 .465 .533 r
.89013 .49682 .89072 .49335 .89237 .49978 .89173 .50278 Mtetra
.715 .449 .523 r
.89173 .50278 .89237 .49978 .89391 .5049 .89324 .50753 Mtetra
.693 .421 .508 r
.89324 .50753 .89391 .5049 .89532 .50868 .89463 .51102 Mtetra
.653 .375 .485 r
.89463 .51102 .89532 .50868 .89663 .51114 .89591 .5133 Mtetra
.577 .291 .446 r
.89591 .5133 .89663 .51114 .89782 .51233 .89709 .51439 Mtetra
.413 .128 .368 r
.89709 .51439 .89782 .51233 .8989 .5123 .89817 .51434 Mtetra
.032 0 .178 r
.89817 .51434 .8989 .5123 .89987 .51104 .89915 .51316 Mtetra
0 0 0 r
.89915 .51316 .89987 .51104 .90072 .50853 .90002 .5108 Mtetra
.91 .843 .39 r
.90002 .5108 .90072 .50853 .90146 .50471 .90078 .50723 Mtetra
.984 .84 .453 r
.90078 .50723 .90146 .50471 .90207 .49954 .90143 .50241 Mtetra
.997 .816 .464 r
.90143 .50241 .90207 .49954 .90256 .49302 .90196 .49634 Mtetra
.998 .8 .454 r
.90196 .49634 .90256 .49302 .90294 .48529 .90239 .48912 Mtetra
.996 .791 .43 r
.90239 .48912 .90294 .48529 .90322 .47663 .90273 .48105 Mtetra
.985 .784 .383 r
.90273 .48105 .90322 .47663 .90347 .46759 .90304 .47261 Mtetra
.935 .759 .284 r
.90304 .47261 .90347 .46759 .90375 .45891 .90337 .46451 Mtetra
.729 .63 .066 r
.90337 .46451 .90375 .45891 .90414 .45151 .90381 .4576 Mtetra
0 0 .265 r
.90381 .4576 .90414 .45151 .90474 .44629 .90444 .45273 Mtetra
.253 .096 .466 r
.90444 .45273 .90474 .44629 .9056 .44395 .90532 .45053 Mtetra
.49 .286 .529 r
.90532 .45053 .9056 .44395 .90676 .44481 .90648 .45132 Mtetra
.603 .378 .548 r
.90648 .45132 .90676 .44481 .90821 .44869 .9079 .45492 Mtetra
.663 .426 .552 r
.9079 .45492 .90821 .44869 .90989 .45502 .90954 .4608 Mtetra
.696 .453 .551 r
.90954 .4608 .90989 .45502 .91172 .46291 .91132 .46814 Mtetra
.715 .467 .549 r
.91132 .46814 .91172 .46291 .91362 .47145 .91316 .47608 Mtetra
.725 .472 .544 r
.91316 .47608 .91362 .47145 .91551 .47982 .91499 .48385 Mtetra
.728 .471 .538 r
.91499 .48385 .91551 .47982 .91732 .48741 .91675 .4909 Mtetra
.725 .463 .53 r
.91675 .4909 .91732 .48741 .91904 .49386 .91842 .49688 Mtetra
.713 .446 .519 r
.91842 .49688 .91904 .49386 .92063 .49898 .91998 .50163 Mtetra
.691 .418 .504 r
.91998 .50163 .92063 .49898 .9221 .50275 .92142 .50512 Mtetra
.65 .37 .481 r
.92142 .50512 .9221 .50275 .92344 .50518 .92274 .50737 Mtetra
.571 .285 .443 r
.92274 .50737 .92344 .50518 .92466 .50635 .92395 .50844 Mtetra
.405 .121 .365 r
.92395 .50844 .92466 .50635 .92576 .50627 .92506 .50835 Mtetra
.029 0 .181 r
.92506 .50835 .92576 .50627 .92674 .50495 .92605 .50711 Mtetra
0 0 0 r
.92605 .50711 .92674 .50495 .92761 .50236 .92693 .50469 Mtetra
.896 .831 .365 r
.92693 .50469 .92761 .50236 .92834 .49845 .92768 .50104 Mtetra
.978 .834 .433 r
.92768 .50104 .92834 .49845 .92894 .49318 .92832 .49611 Mtetra
.994 .814 .445 r
.92832 .49611 .92894 .49318 .9294 .48655 .92883 .48993 Mtetra
.996 .798 .436 r
.92883 .48993 .9294 .48655 .92974 .4787 .92922 .48261 Mtetra
.992 .788 .409 r
.92922 .48261 .92974 .4787 .92999 .46993 .92954 .47444 Mtetra
.976 .777 .357 r
.92954 .47444 .92999 .46993 .9302 .46081 .92981 .46593 Mtetra
.912 .742 .248 r
.92981 .46593 .9302 .46081 .93045 .4521 .93012 .4578 Mtetra
0 0 0 r
.93012 .4578 .93045 .4521 .93083 .44473 .93055 .45092 Mtetra
0 0 .296 r
.93055 .45092 .93083 .44473 .93143 .4396 .93118 .44613 Mtetra
.276 .115 .474 r
.93118 .44613 .93143 .4396 .93232 .43742 .93209 .44408 Mtetra
.498 .292 .531 r
.93209 .44408 .93232 .43742 .93353 .43846 .93329 .44504 Mtetra
.606 .38 .547 r
.93329 .44504 .93353 .43846 .93505 .44254 .93478 .44882 Mtetra
.664 .426 .55 r
.93478 .44882 .93505 .44254 .93681 .44904 .9365 .45487 Mtetra
.697 .452 .549 r
.9365 .45487 .93681 .44904 .93873 .45708 .93837 .46235 Mtetra
.716 .466 .546 r
.93837 .46235 .93873 .45708 .94072 .46573 .94029 .47039 Mtetra
.726 .471 .541 r
.94029 .47039 .94072 .46573 .9427 .47418 .94221 .47823 Mtetra
.728 .469 .535 r
.94221 .47823 .9427 .47418 .94459 .48181 .94405 .48532 Mtetra
.724 .46 .527 r
.94405 .48532 .94459 .48181 .94638 .48827 .94578 .49132 Mtetra
.712 .443 .516 r
.94578 .49132 .94638 .48827 .94803 .49339 .9474 .49607 Mtetra
.689 .414 .501 r
.9474 .49607 .94803 .49339 .94954 .49714 .94888 .49954 Mtetra
.646 .365 .478 r
.94888 .49954 .94954 .49714 .95092 .49955 .95025 .50177 Mtetra
.565 .279 .439 r
.95025 .50177 .95092 .49955 .95218 .50068 .95149 .5028 Mtetra
.396 .114 .362 r
.95149 .5028 .95218 .50068 .9533 .50055 .95261 .50267 Mtetra
.024 0 .185 r
.95261 .50267 .9533 .50055 .9543 .49917 .95362 .50137 Mtetra
0 0 0 r
.95362 .50137 .9543 .49917 .95516 .4965 .9545 .49888 Mtetra
.881 .818 .34 r
.9545 .49888 .95516 .4965 .95589 .49249 .95526 .49514 Mtetra
.97 .828 .411 r
.95526 .49514 .95589 .49249 .95647 .48711 .95588 .49011 Mtetra
.99 .81 .425 r
.95588 .49011 .95647 .48711 .95691 .48036 .95637 .48382 Mtetra
.992 .794 .415 r
.95637 .48382 .95691 .48036 .95721 .47238 .95673 .47638 Mtetra
.987 .783 .387 r
.95673 .47638 .95721 .47238 .95742 .4635 .95701 .4681 Mtetra
.965 .769 .329 r
.95701 .4681 .95742 .4635 .9576 .4543 .95725 .45952 Mtetra
.886 .723 .211 r
.95725 .45952 .9576 .4543 .95781 .44556 .95753 .45136 Mtetra
0 0 .027 r
.95753 .45136 .95781 .44556 .95818 .43821 .95795 .44451 Mtetra
0 0 .324 r
.95795 .44451 .95818 .43821 .95878 .43318 .95859 .4398 Mtetra
.296 .132 .481 r
.95859 .4398 .95878 .43318 .9597 .43114 .95952 .43789 Mtetra
.505 .297 .532 r
.95952 .43789 .9597 .43114 .96096 .43237 .96078 .43902 Mtetra
.609 .381 .546 r
.96078 .43902 .96096 .43237 .96256 .43664 .96234 .44299 Mtetra
.666 .426 .548 r
.96234 .44299 .96256 .43664 .96441 .44332 .96414 .4492 Mtetra
.698 .451 .547 r
.96414 .4492 .96441 .44332 .96643 .45151 .9661 .45682 Mtetra
.716 .464 .543 r
.9661 .45682 .96643 .45151 .96851 .46028 .96812 .46496 Mtetra
.726 .469 .538 r
.96812 .46496 .96851 .46028 .97057 .46879 .97012 .47287 Mtetra
.728 .467 .532 r
.97012 .47287 .97057 .46879 .97255 .47646 .97203 .48 Mtetra
.723 .457 .524 r
.97203 .48 .97255 .47646 .97441 .48293 .97384 .48601 Mtetra
.711 .44 .513 r
.97384 .48601 .97441 .48293 .97612 .48805 .97551 .49076 Mtetra
.687 .409 .497 r
.97551 .49076 .97612 .48805 .97769 .49178 .97705 .49422 Mtetra
.642 .359 .474 r
.97705 .49422 .97769 .49178 .97911 .49417 .97845 .49642 Mtetra
.559 .272 .436 r
.97845 .49642 .97911 .49417 .98039 .49525 .97972 .49741 Mtetra
.387 .106 .36 r
.97972 .49741 .98039 .49525 .98154 .49507 .98087 .49723 Mtetra
.019 0 .188 r
.98087 .49723 .98154 .49507 .98255 .49362 .98189 .49587 Mtetra
0 0 0 r
.98189 .49587 .98255 .49362 .98341 .49087 .98278 .4933 Mtetra
.865 .803 .315 r
.98278 .4933 .98341 .49087 .98413 .48676 .98353 .48946 Mtetra
.961 .82 .388 r
.98353 .48946 .98413 .48676 .98469 .48126 .98413 .48433 Mtetra
.984 .804 .404 r
.98413 .48433 .98469 .48126 .9851 .47438 .9846 .47791 Mtetra
.987 .789 .394 r
.9846 .47791 .9851 .47438 .98537 .46627 .98493 .47036 Mtetra
.979 .777 .363 r
.98493 .47036 .98537 .46627 .98554 .45728 .98517 .46197 Mtetra
.951 .758 .3 r
.98517 .46197 .98554 .45728 .98568 .44799 .98537 .45331 Mtetra
.856 .7 .171 r
.98537 .45331 .98568 .44799 .98586 .43921 .98563 .44512 Mtetra
0 0 .072 r
.98563 .44512 .98586 .43921 .98621 .43189 .98603 .43829 Mtetra
0 0 .348 r
.98603 .43829 .98621 .43189 .98682 .42695 .98668 .43367 Mtetra
.314 .147 .488 r
.98668 .43367 .98682 .42695 .98777 .42507 .98765 .4319 Mtetra
.486 .295 .546 r
.52917 .64983 .53001 .64248 .53078 .64322 .52994 .65046 Mtetra
.586 .381 .571 r
.52994 .65046 .53078 .64322 .53157 .64644 .53073 .65333 Mtetra
.638 .426 .579 r
.53073 .65333 .53157 .64644 .53238 .65157 .53153 .65796 Mtetra
.667 .451 .582 r
.53153 .65796 .53238 .65157 .5332 .65789 .53235 .66366 Mtetra
.683 .463 .582 r
.53235 .66366 .5332 .65789 .53403 .66463 .53317 .66974 Mtetra
.691 .468 .58 r
.53317 .66974 .53403 .66463 .53487 .67113 .534 .67559 Mtetra
.691 .465 .575 r
.534 .67559 .53487 .67113 .53569 .67691 .53482 .6808 Mtetra
.686 .456 .568 r
.53482 .6808 .53569 .67691 .53651 .68171 .53563 .68511 Mtetra
.671 .437 .558 r
.53563 .68511 .53651 .68171 .53732 .6854 .53644 .68841 Mtetra
.644 .405 .542 r
.53644 .68841 .53732 .6854 .53812 .68796 .53724 .69069 Mtetra
.593 .348 .515 r
.53724 .69069 .53812 .68796 .53891 .68943 .53803 .69198 Mtetra
.492 .243 .464 r
.53803 .69198 .53891 .68943 .5397 .68985 .53881 .69231 Mtetra
.264 .021 .345 r
.53881 .69231 .5397 .68985 .54047 .68925 .53958 .69171 Mtetra
0 0 .041 r
.53958 .69171 .54047 .68925 .54123 .68763 .54034 .69018 Mtetra
.821 .83 .356 r
.54034 .69018 .54123 .68763 .54198 .68495 .5411 .68769 Mtetra
.979 .879 .512 r
.5411 .68769 .54198 .68495 .54271 .68117 .54184 .6842 Mtetra
.998 .85 .549 r
.54184 .6842 .54271 .68117 .54344 .67626 .54256 .67969 Mtetra
.997 .826 .554 r
.54256 .67969 .54344 .67626 .54415 .67025 .54328 .67417 Mtetra
.996 .814 .545 r
.54328 .67417 .54415 .67025 .54484 .66324 .54399 .66775 Mtetra
.998 .813 .526 r
.54399 .66775 .54484 .66324 .54553 .65555 .54468 .66069 Mtetra
.999 .82 .485 r
.54468 .66069 .54553 .65555 .54621 .64763 .54538 .65343 Mtetra
.967 .814 .388 r
.54538 .65343 .54621 .64763 .5469 .64016 .54607 .64658 Mtetra
.752 .681 .133 r
.54607 .64658 .5469 .64016 .5476 .63392 .54678 .64084 Mtetra
0 0 .27 r
.54678 .64084 .5476 .63392 .54832 .62963 .54751 .63689 Mtetra
.289 .127 .481 r
.54751 .63689 .54832 .62963 .54907 .62785 .54826 .63521 Mtetra
.493 .301 .548 r
.54826 .63521 .54907 .62785 .54986 .62873 .54905 .63596 Mtetra
.589 .383 .57 r
.54905 .63596 .54986 .62873 .55068 .63207 .54986 .63896 Mtetra
.639 .427 .579 r
.54986 .63896 .55068 .63207 .55153 .63731 .5507 .64368 Mtetra
.668 .45 .581 r
.5507 .64368 .55153 .63731 .55239 .6437 .55156 .64944 Mtetra
.683 .463 .581 r
.55156 .64944 .55239 .6437 .55326 .65048 .55242 .65555 Mtetra
.691 .467 .578 r
.55242 .65555 .55326 .65048 .55414 .65698 .55329 .66142 Mtetra
.692 .464 .573 r
.55329 .66142 .55414 .65698 .555 .66275 .55414 .66662 Mtetra
.685 .454 .566 r
.55414 .66662 .555 .66275 .55585 .66752 .55499 .6709 Mtetra
.67 .435 .555 r
.55499 .6709 .55585 .66752 .55669 .67117 .55582 .67417 Mtetra
.642 .401 .539 r
.55582 .67417 .55669 .67117 .55752 .6737 .55665 .67641 Mtetra
.59 .343 .511 r
.55665 .67641 .55752 .6737 .55833 .67513 .55745 .67766 Mtetra
.485 .234 .458 r
.55745 .67766 .55833 .67513 .55913 .67551 .55825 .67795 Mtetra
.25 .007 .336 r
.55825 .67795 .55913 .67551 .55991 .67486 .55903 .67731 Mtetra
0 0 .029 r
.55903 .67731 .55991 .67486 .56068 .67318 .5598 .67573 Mtetra
.825 .83 .356 r
.5598 .67573 .56068 .67318 .56143 .67044 .56056 .67319 Mtetra
.979 .877 .507 r
.56056 .67319 .56143 .67044 .56216 .66659 .5613 .66964 Mtetra
.998 .85 .543 r
.5613 .66964 .56216 .66659 .56288 .66162 .56202 .66506 Mtetra
.998 .827 .547 r
.56202 .66506 .56288 .66162 .56358 .65552 .56273 .65947 Mtetra
.997 .815 .538 r
.56273 .65947 .56358 .65552 .56426 .64846 .56342 .65299 Mtetra
.999 .814 .516 r
.56342 .65299 .56426 .64846 .56492 .6407 .5641 .64588 Mtetra
.998 .819 .471 r
.5641 .64588 .56492 .6407 .56559 .63276 .56477 .6386 Mtetra
.956 .806 .365 r
.56477 .6386 .56559 .63276 .56625 .62531 .56545 .63177 Mtetra
.71 .65 .094 r
.56545 .63177 .56625 .62531 .56694 .61913 .56615 .62609 Mtetra
0 0 .296 r
.56615 .62609 .56694 .61913 .56766 .61495 .56688 .62223 Mtetra
.306 .142 .488 r
.56688 .62223 .56766 .61495 .56842 .61329 .56764 .62067 Mtetra
.499 .306 .549 r
.56764 .62067 .56842 .61329 .56923 .61432 .56845 .62155 Mtetra
.592 .385 .57 r
.56845 .62155 .56923 .61432 .57008 .61779 .5693 .62467 Mtetra
.641 .427 .578 r
.5693 .62467 .57008 .61779 .57097 .62314 .57017 .62948 Mtetra
.669 .45 .58 r
.57017 .62948 .57097 .62314 .57188 .62961 .57107 .63532 Mtetra
.684 .462 .579 r
.57107 .63532 .57188 .62961 .57279 .63642 .57197 .64146 Mtetra
.691 .466 .576 r
.57197 .64146 .57279 .63642 .57371 .64293 .57288 .64734 Mtetra
.692 .463 .571 r
.57288 .64734 .57371 .64293 .57461 .64869 .57377 .65253 Mtetra
.685 .452 .564 r
.57377 .65253 .57461 .64869 .5755 .65344 .57465 .65679 Mtetra
.67 .433 .553 r
.57465 .65679 .5755 .65344 .57637 .65706 .57551 .66003 Mtetra
.641 .398 .536 r
.57551 .66003 .57637 .65706 .57722 .65955 .57636 .66224 Mtetra
.587 .338 .508 r
.57636 .66224 .57722 .65955 .57805 .66094 .57718 .66345 Mtetra
.479 .227 .453 r
.57718 .66345 .57805 .66094 .57886 .66127 .578 .66371 Mtetra
.236 0 .328 r
.578 .66371 .57886 .66127 .57966 .66058 .57879 .66302 Mtetra
0 0 .019 r
.57879 .66302 .57966 .66058 .58043 .65885 .57957 .6614 Mtetra
.828 .829 .355 r
.57957 .6614 .58043 .65885 .58118 .65605 .58032 .6588 Mtetra
.977 .874 .5 r
.58032 .6588 .58118 .65605 .58191 .65214 .58106 .6552 Mtetra
.998 .849 .536 r
.58106 .6552 .58191 .65214 .58262 .64709 .58178 .65055 Mtetra
.998 .827 .539 r
.58178 .65055 .58262 .64709 .58331 .64093 .58248 .64489 Mtetra
.998 .816 .529 r
.58248 .64489 .58331 .64093 .58397 .63379 .58315 .63835 Mtetra
1 .815 .506 r
.58315 .63835 .58397 .63379 .58462 .62599 .58382 .6312 Mtetra
.995 .818 .456 r
.58382 .6312 .58462 .62599 .58526 .61803 .58447 .62391 Mtetra
.942 .797 .339 r
.58447 .62391 .58526 .61803 .58591 .6106 .58514 .61709 Mtetra
0 0 0 r
.58514 .61709 .58591 .6106 .58659 .60448 .58583 .61147 Mtetra
0 0 .319 r
.58583 .61147 .58659 .60448 .58731 .60041 .58656 .60771 Mtetra
.322 .156 .494 r
.58656 .60771 .58731 .60041 .58808 .59889 .58733 .60627 Mtetra
.506 .311 .55 r
.58733 .60627 .58808 .59889 .58891 .60006 .58816 .60729 Mtetra
.595 .387 .569 r
.58816 .60729 .58891 .60006 .58979 .60367 .58904 .61053 Mtetra
.642 .428 .577 r
.58904 .61053 .58979 .60367 .59072 .60913 .58995 .61545 Mtetra
.67 .45 .578 r
.58995 .61545 .59072 .60913 .59167 .61567 .59089 .62135 Mtetra
.685 .462 .577 r
.59089 .62135 .59167 .61567 .59263 .62252 .59184 .62754 Mtetra
.692 .465 .574 r
.59184 .62754 .59263 .62252 .59359 .62905 .59278 .63342 Mtetra
.692 .462 .569 r
.59278 .63342 .59359 .62905 .59454 .6348 .59371 .6386 Mtetra
.685 .451 .562 r
.59371 .6386 .59454 .6348 .59546 .63952 .59462 .64285 Mtetra
.669 .43 .55 r
.59462 .64285 .59546 .63952 .59636 .64311 .59551 .64606 Mtetra
.639 .395 .533 r
.59551 .64606 .59636 .64311 .59723 .64557 .59638 .64824 Mtetra
.584 .334 .504 r
.59638 .64824 .59723 .64557 .59809 .64693 .59723 .64943 Mtetra
.473 .219 .448 r
.59723 .64943 .59809 .64693 .59891 .64722 .59806 .64965 Mtetra
.224 0 .32 r
.59806 .64965 .59891 .64722 .59972 .64649 .59886 .64892 Mtetra
0 0 .01 r
.59886 .64892 .59972 .64649 .6005 .6447 .59965 .64725 Mtetra
.828 .827 .352 r
.59965 .64725 .6005 .6447 .60125 .64185 .60041 .64461 Mtetra
.976 .872 .493 r
.60041 .64461 .60125 .64185 .60198 .63788 .60114 .64094 Mtetra
.998 .848 .528 r
.60114 .64094 .60198 .63788 .60268 .63276 .60185 .63624 Mtetra
.999 .827 .531 r
.60185 .63624 .60268 .63276 .60335 .62652 .60254 .63052 Mtetra
.999 .816 .52 r
.60254 .63052 .60335 .62652 .604 .61932 .6032 .62392 Mtetra
1 .815 .494 r
.6032 .62392 .604 .61932 .60463 .61148 .60385 .61673 Mtetra
.992 .816 .44 r
.60385 .61673 .60463 .61148 .60525 .6035 .60449 .60942 Mtetra
.925 .786 .312 r
.60449 .60942 .60525 .6035 .60588 .59609 .60514 .60262 Mtetra
0 0 0 r
.60514 .60262 .60588 .59609 .60655 .59004 .60582 .59707 Mtetra
0 0 .341 r
.60582 .59707 .60655 .59004 .60727 .58608 .60655 .59341 Mtetra
.338 .169 .5 r
.60655 .59341 .60727 .58608 .60805 .5847 .60734 .5921 Mtetra
.512 .316 .551 r
.60734 .5921 .60805 .5847 .60891 .58603 .60819 .59326 Mtetra
.598 .389 .569 r
.60819 .59326 .60891 .58603 .60983 .58978 .6091 .59663 Mtetra
.644 .428 .575 r
.6091 .59663 .60983 .58978 .61079 .59535 .61005 .60165 Mtetra
.671 .45 .577 r
.61005 .60165 .61079 .59535 .61179 .60197 .61104 .60762 Mtetra
.686 .461 .576 r
.61104 .60762 .61179 .60197 .6128 .60886 .61203 .61385 Mtetra
.692 .464 .573 r
.61203 .61385 .6128 .60886 .61381 .61541 .61301 .61975 Mtetra
.692 .461 .567 r
.61301 .61975 .61381 .61541 .61479 .62115 .61398 .62493 Mtetra
.685 .449 .559 r
.61398 .62493 .61479 .62115 .61575 .62586 .61493 .62916 Mtetra
.668 .428 .548 r
.61493 .62916 .61575 .62586 .61668 .62943 .61585 .63235 Mtetra
.638 .392 .53 r
.61585 .63235 .61668 .62943 .61758 .63185 .61674 .63451 Mtetra
.581 .329 .5 r
.61674 .63451 .61758 .63185 .61845 .63318 .61761 .63566 Mtetra
.467 .212 .444 r
.61761 .63566 .61845 .63318 .6193 .63344 .61845 .63585 Mtetra
.212 0 .313 r
.61845 .63585 .6193 .63344 .62012 .63266 .61927 .63509 Mtetra
0 0 .005 r
.61927 .63509 .62012 .63266 .6209 .63083 .62006 .63338 Mtetra
.827 .824 .346 r
.62006 .63338 .6209 .63083 .62166 .62793 .62082 .63069 Mtetra
.974 .87 .484 r
.62082 .63069 .62166 .62793 .62238 .62389 .62156 .62697 Mtetra
.998 .847 .519 r
.62156 .62697 .62238 .62389 .62307 .6187 .62226 .6222 Mtetra
1 .827 .522 r
.62226 .6222 .62307 .6187 .62373 .6124 .62294 .61642 Mtetra
1 .817 .51 r
.62294 .61642 .62373 .6124 .62436 .60514 .62358 .60977 Mtetra
.999 .815 .482 r
.62358 .60977 .62436 .60514 .62496 .59725 .62421 .60254 Mtetra
.987 .813 .422 r
.62421 .60254 .62496 .59725 .62556 .58926 .62483 .59522 Mtetra
.905 .772 .282 r
.62483 .59522 .62556 .58926 .62618 .58188 .62547 .58845 Mtetra
0 0 .028 r
.62547 .58845 .62618 .58188 .62684 .57591 .62615 .58296 Mtetra
0 0 .361 r
.62615 .58296 .62684 .57591 .62756 .57206 .62688 .57941 Mtetra
.353 .182 .505 r
.62688 .57941 .62756 .57206 .62836 .57083 .62768 .57824 Mtetra
.518 .321 .552 r
.62768 .57824 .62836 .57083 .62924 .57231 .62856 .57954 Mtetra
.601 .391 .568 r
.62856 .57954 .62924 .57231 .6302 .5762 .6295 .58304 Mtetra
.646 .429 .574 r
.6295 .58304 .6302 .5762 .63121 .58189 .6305 .58817 Mtetra
.672 .45 .575 r
.6305 .58817 .63121 .58189 .63226 .58859 .63152 .59422 Mtetra
.686 .461 .574 r
.63152 .59422 .63226 .58859 .63331 .59554 .63256 .6005 Mtetra
.693 .463 .571 r
.63256 .6005 .63331 .59554 .63436 .6021 .63359 .60642 Mtetra
.692 .459 .565 r
.63359 .60642 .63436 .6021 .63539 .60785 .6346 .6116 Mtetra
.685 .448 .557 r
.6346 .6116 .63539 .60785 .63639 .61254 .63558 .61581 Mtetra
.668 .426 .545 r
.63558 .61581 .63639 .61254 .63735 .61609 .63653 .61899 Mtetra
.636 .389 .527 r
.63653 .61899 .63735 .61609 .63828 .61849 .63745 .62113 Mtetra
.578 .325 .497 r
.63745 .62113 .63828 .61849 .63917 .61978 .63834 .62226 Mtetra
.461 .206 .439 r
.63834 .62226 .63917 .61978 .64003 .62001 .6392 .62242 Mtetra
.203 0 .307 r
.6392 .62242 .64003 .62001 .64086 .6192 .64003 .62163 Mtetra
0 0 .002 r
.64003 .62163 .64086 .6192 .64165 .61733 .64083 .61988 Mtetra
.824 .82 .339 r
.64083 .61988 .64165 .61733 .64241 .61437 .64159 .61714 Mtetra
.971 .867 .475 r
.64159 .61714 .64241 .61437 .64313 .61027 .64232 .61337 Mtetra
.997 .846 .51 r
.64232 .61337 .64313 .61027 .64381 .60502 .64302 .60854 Mtetra
1 .827 .513 r
.64302 .60854 .64381 .60502 .64445 .59865 .64368 .6027 Mtetra
1 .817 .499 r
.64368 .6027 .64445 .59865 .64506 .59133 .64431 .596 Mtetra
.998 .814 .468 r
.64431 .596 .64506 .59133 .64565 .5834 .64492 .58873 Mtetra
.98 .809 .402 r
.64492 .58873 .64565 .5834 .64623 .5754 .64553 .5814 Mtetra
.881 .755 .249 r
.64553 .5814 .64623 .5754 .64683 .56805 .64615 .57467 Mtetra
0 0 .069 r
.64615 .57467 .64683 .56805 .64748 .56216 .64682 .56925 Mtetra
.035 0 .38 r
.64682 .56925 .64748 .56216 .6482 .55844 .64755 .56582 Mtetra
.367 .194 .509 r
.64755 .56582 .6482 .55844 .64902 .55736 .64837 .56479 Mtetra
.524 .325 .553 r
.64837 .56479 .64902 .55736 .64993 .559 .64928 .56623 Mtetra
.604 .392 .568 r
.64928 .56623 .64993 .559 .65092 .56304 .65026 .56987 Mtetra
.648 .429 .573 r
.65026 .56987 .65092 .56304 .65198 .56885 .6513 .57511 Mtetra
.673 .45 .574 r
.6513 .57511 .65198 .56885 .65308 .57563 .65237 .58124 Mtetra
.687 .46 .572 r
.65237 .58124 .65308 .57563 .65419 .58263 .65346 .58757 Mtetra
.693 .463 .569 r
.65346 .58757 .65419 .58263 .65529 .58922 .65453 .59351 Mtetra
.693 .458 .563 r
.65453 .59351 .65529 .58922 .65636 .59497 .65558 .5987 Mtetra
.685 .446 .555 r
.65558 .5987 .65636 .59497 .65739 .59966 .6566 .60291 Mtetra
.668 .424 .543 r
.6566 .60291 .65739 .59966 .65839 .60319 .65758 .60608 Mtetra
.635 .386 .524 r
.65758 .60608 .65839 .60319 .65934 .60557 .65853 .60819 Mtetra
.576 .321 .493 r
.65853 .60819 .65934 .60557 .66026 .60684 .65944 .6093 Mtetra
.457 .2 .435 r
.65944 .6093 .66026 .60684 .66114 .60704 .66031 .60944 Mtetra
.195 0 .302 r
.66031 .60944 .66114 .60704 .66198 .60619 .66116 .60862 Mtetra
0 0 .001 r
.66116 .60862 .66198 .60619 .66278 .60428 .66196 .60684 Mtetra
.818 .814 .33 r
.66196 .60684 .66278 .60428 .66354 .60127 .66273 .60405 Mtetra
.967 .863 .464 r
.66273 .60405 .66354 .60127 .66425 .59712 .66346 .60023 Mtetra
.996 .845 .5 r
.66346 .60023 .66425 .59712 .66492 .5918 .66415 .59535 Mtetra
1 .827 .502 r
.66415 .59535 .66492 .5918 .66555 .58537 .6648 .58946 Mtetra
1 .817 .487 r
.6648 .58946 .66555 .58537 .66614 .57799 .66541 .5827 Mtetra
.996 .813 .453 r
.66541 .5827 .66614 .57799 .6667 .57002 .666 .5754 Mtetra
.972 .803 .38 r
.666 .5754 .6667 .57002 .66726 .56201 .66659 .56806 Mtetra
.853 .734 .214 r
.66659 .56806 .66726 .56201 .66785 .5547 .6672 .56137 Mtetra
0 0 .109 r
.6672 .56137 .66785 .5547 .66849 .5489 .66786 .55603 Mtetra
.07 0 .397 r
.66786 .55603 .66849 .5489 .66921 .5453 .6686 .55271 Mtetra
.381 .205 .514 r
.6686 .55271 .66921 .5453 .67005 .54438 .66944 .55183 Mtetra
.53 .33 .553 r
.66944 .55183 .67005 .54438 .67099 .54618 .67037 .55343 Mtetra
.607 .394 .567 r
.67037 .55343 .67099 .54618 .67203 .55038 .67139 .5572 Mtetra
.649 .43 .572 r
.67139 .5572 .67203 .55038 .67314 .55631 .67248 .56256 Mtetra
.674 .45 .572 r
.67248 .56256 .67314 .55631 .67429 .56319 .67361 .56878 Mtetra
.688 .46 .571 r
.67361 .56878 .67429 .56319 .67545 .57025 .67474 .57516 Mtetra
.694 .462 .567 r
.67474 .57516 .67545 .57025 .6766 .57687 .67586 .58114 Mtetra
.693 .457 .561 r
.67586 .58114 .6766 .57687 .67771 .58263 .67695 .58633 Mtetra
.685 .445 .552 r
.67695 .58633 .67771 .58263 .67879 .58731 .67801 .59054 Mtetra
.667 .422 .54 r
.67801 .59054 .67879 .58731 .67982 .59083 .67902 .5937 Mtetra
.634 .384 .521 r
.67902 .5937 .67982 .59083 .6808 .5932 .68 .59581 Mtetra
.573 .317 .49 r
.68 .59581 .6808 .5932 .68174 .59445 .68093 .5969 Mtetra
.453 .194 .431 r
.68093 .5969 .68174 .59445 .68263 .59462 .68182 .59702 Mtetra
.189 0 .298 r
.68182 .59702 .68263 .59462 .68349 .59374 .68268 .59617 Mtetra
0 0 .005 r
.68268 .59617 .68349 .59374 .68429 .59179 .68349 .59435 Mtetra
.809 .806 .317 r
.68349 .59435 .68429 .59179 .68505 .58874 .68426 .59153 Mtetra
.962 .859 .451 r
.68426 .59153 .68505 .58874 .68576 .58453 .68499 .58766 Mtetra
.994 .844 .488 r
.68499 .58766 .68576 .58453 .68642 .57915 .68567 .58273 Mtetra
.999 .826 .49 r
.68567 .58273 .68642 .57915 .68703 .57265 .6863 .57677 Mtetra
.999 .816 .474 r
.6863 .57677 .68703 .57265 .6876 .56521 .6869 .56997 Mtetra
.993 .811 .436 r
.6869 .56997 .6876 .56521 .68814 .5572 .68747 .56264 Mtetra
.96 .796 .356 r
.68747 .56264 .68814 .5572 .68868 .5492 .68804 .5553 Mtetra
.819 .71 .176 r
.68804 .5553 .68868 .5492 .68925 .54193 .68864 .54864 Mtetra
0 0 .148 r
.68864 .54864 .68925 .54193 .68989 .53621 .6893 .54339 Mtetra
.103 0 .412 r
.6893 .54339 .68989 .53621 .69062 .53275 .69005 .5402 Mtetra
.394 .216 .518 r
.69005 .5402 .69062 .53275 .69147 .53198 .6909 .53946 Mtetra
.536 .334 .554 r
.6909 .53946 .69147 .53198 .69245 .53396 .69187 .54122 Mtetra
.609 .396 .566 r
.69187 .54122 .69245 .53396 .69353 .53831 .69293 .54514 Mtetra
.651 .43 .571 r
.69293 .54514 .69353 .53831 .69469 .54438 .69407 .55062 Mtetra
.675 .45 .571 r
.69407 .55062 .69469 .54438 .6959 .55135 .69525 .55693 Mtetra
.689 .459 .569 r
.69525 .55693 .6959 .55135 .69712 .55848 .69643 .56337 Mtetra
.695 .461 .565 r
.69643 .56337 .69712 .55848 .69832 .56513 .6976 .56938 Mtetra
.694 .456 .559 r
.6976 .56938 .69832 .56513 .69948 .5709 .69874 .57459 Mtetra
.685 .443 .55 r
.69874 .57459 .69948 .5709 .7006 .57559 .69983 .57881 Mtetra
.667 .42 .537 r
.69983 .57881 .7006 .57559 .70166 .5791 .70088 .58196 Mtetra
.633 .381 .518 r
.70088 .58196 .70166 .5791 .70267 .58145 .70188 .58406 Mtetra
.571 .314 .487 r
.70188 .58406 .70267 .58145 .70364 .58269 .70284 .58514 Mtetra
.449 .19 .428 r
.70284 .58514 .70364 .58269 .70455 .58284 .70375 .58524 Mtetra
.185 0 .296 r
.70375 .58524 .70455 .58284 .70541 .58193 .70462 .58437 Mtetra
0 0 .011 r
.70462 .58437 .70541 .58193 .70623 .57994 .70544 .58252 Mtetra
.797 .796 .302 r
.70544 .58252 .70623 .57994 .70699 .57684 .70621 .57966 Mtetra
.956 .855 .437 r
.70621 .57966 .70699 .57684 .70769 .57258 .70693 .57574 Mtetra
.991 .842 .474 r
.70693 .57574 .70769 .57258 .70834 .56714 .70761 .57075 Mtetra
.997 .825 .476 r
.70761 .57075 .70834 .56714 .70894 .56057 .70823 .56474 Mtetra
.997 .815 .459 r
.70823 .56474 .70894 .56057 .70948 .55308 .70881 .55789 Mtetra
.988 .808 .417 r
.70881 .55789 .70948 .55308 .71 .54504 .70936 .55053 Mtetra
.946 .786 .329 r
.70936 .55053 .71 .54504 .71052 .53703 .70991 .54319 Mtetra
.781 .682 .135 r
.70991 .54319 .71052 .53703 .71107 .5298 .7105 .53658 Mtetra
0 0 .185 r
.7105 .53658 .71107 .5298 .7117 .52418 .71116 .53141 Mtetra
.135 .005 .427 r
.71116 .53141 .7117 .52418 .71244 .52085 .71191 .52835 Mtetra
.406 .226 .521 r
.71191 .52835 .71244 .52085 .71332 .52025 .71279 .52776 Mtetra
.541 .338 .554 r
.71279 .52776 .71332 .52025 .71433 .5224 .71379 .52968 Mtetra
.612 .397 .566 r
.71379 .52968 .71433 .5224 .71546 .52692 .7149 .53375 Mtetra
.653 .431 .569 r
.7149 .53375 .71546 .52692 .71668 .53312 .71609 .53936 Mtetra
.677 .449 .569 r
.71609 .53936 .71668 .53312 .71795 .5402 .71732 .54577 Mtetra
.69 .458 .567 r
.71732 .54577 .71795 .5402 .71922 .54739 .71856 .55227 Mtetra
.695 .46 .563 r
.71856 .55227 .71922 .54739 .72047 .55408 .71978 .55832 Mtetra
.694 .454 .556 r
.71978 .55832 .72047 .55408 .72169 .55987 .72096 .56355 Mtetra
.685 .441 .548 r
.72096 .56355 .72169 .55987 .72284 .56456 .7221 .56777 Mtetra
.666 .418 .535 r
.7221 .56777 .72284 .56456 .72395 .56807 .72318 .57093 Mtetra
.632 .378 .516 r
.72318 .57093 .72395 .56807 .72499 .57042 .72421 .57302 Mtetra
.569 .31 .484 r
.72421 .57302 .72499 .57042 .72598 .57164 .72519 .57409 Mtetra
.446 .186 .425 r
.72519 .57409 .72598 .57164 .72691 .57177 .72612 .57417 Mtetra
.183 0 .296 r
.72612 .57417 .72691 .57177 .72779 .57083 .727 .57328 Mtetra
0 0 .02 r
.727 .57328 .72779 .57083 .72861 .56881 .72783 .57141 Mtetra
.783 .784 .283 r
.72783 .57141 .72861 .56881 .72937 .56566 .72861 .56851 Mtetra
.948 .849 .42 r
.72861 .56851 .72937 .56566 .73007 .56134 .72933 .56454 Mtetra
.987 .839 .459 r
.72933 .56454 .73007 .56134 .73071 .55584 .72999 .5595 Mtetra
.995 .824 .461 r
.72999 .5595 .73071 .55584 .73128 .54921 .7306 .55343 Mtetra
.993 .813 .442 r
.7306 .55343 .73128 .54921 .73181 .54166 .73116 .54653 Mtetra
.981 .803 .396 r
.73116 .54653 .73181 .54166 .7323 .53358 .73169 .53914 Mtetra
.929 .774 .299 r
.73169 .53914 .7323 .53358 .7328 .52557 .73223 .5318 Mtetra
.739 .651 .093 r
.73223 .5318 .7328 .52557 .73334 .51839 .7328 .52523 Mtetra
0 0 .221 r
.7328 .52523 .73334 .51839 .73396 .51286 .73346 .52015 Mtetra
.164 .03 .439 r
.73346 .52015 .73396 .51286 .73472 .50967 .73422 .51722 Mtetra
.418 .236 .525 r
.73422 .51722 .73472 .50967 .73562 .50924 .73512 .51679 Mtetra
.546 .342 .554 r
.73512 .51679 .73562 .50924 .73667 .51157 .73616 .51887 Mtetra
.615 .399 .565 r
.73616 .51887 .73667 .51157 .73785 .51625 .73732 .5231 Mtetra
.655 .431 .568 r
.73732 .5231 .73785 .51625 .73913 .52259 .73857 .52884 Mtetra
.678 .449 .568 r
.73857 .52884 .73913 .52259 .74045 .52978 .73986 .53534 Mtetra
.691 .458 .565 r
.73986 .53534 .74045 .52978 .74179 .53704 .74115 .54191 Mtetra
.696 .459 .561 r
.74115 .54191 .74179 .53704 .7431 .54377 .74242 .54801 Mtetra
.694 .453 .554 r
.74242 .54801 .7431 .54377 .74436 .54959 .74366 .55326 Mtetra
.685 .44 .545 r
.74366 .55326 .74436 .54959 .74556 .55429 .74483 .5575 Mtetra
.666 .416 .532 r
.74483 .5575 .74556 .55429 .7467 .5578 .74595 .56065 Mtetra
.631 .375 .513 r
.74595 .56065 .7467 .5578 .74777 .56013 .74701 .56274 Mtetra
.567 .307 .481 r
.74701 .56274 .74777 .56013 .74879 .56134 .74801 .5638 Mtetra
.443 .183 .423 r
.74801 .5638 .74879 .56134 .74974 .56145 .74896 .56387 Mtetra
.182 0 .296 r
.74896 .56387 .74974 .56145 .75063 .56049 .74986 .56296 Mtetra
0 0 .032 r
.74986 .56296 .75063 .56049 .75146 .55843 .7507 .56105 Mtetra
.765 .769 .262 r
.7507 .56105 .75146 .55843 .75222 .55524 .75148 .55811 Mtetra
.938 .841 .401 r
.75148 .55811 .75222 .55524 .75292 .55086 .75219 .5541 Mtetra
.982 .836 .442 r
.75219 .5541 .75292 .55086 .75354 .54529 .75285 .549 Mtetra
.991 .821 .444 r
.75285 .549 .75354 .54529 .7541 .53859 .75344 .54287 Mtetra
.989 .81 .423 r
.75344 .54287 .7541 .53859 .7546 .53099 .75398 .53592 Mtetra
.972 .797 .372 r
.75398 .53592 .7546 .53099 .75507 .52287 .7545 .52849 Mtetra
.907 .759 .266 r
.7545 .52849 .75507 .52287 .75555 .51485 .75502 .52116 Mtetra
0 0 0 r
.75502 .52116 .75555 .51485 .75607 .50772 .75558 .51463 Mtetra
0 0 .254 r
.75558 .51463 .75607 .50772 .7567 .50228 .75623 .50965 Mtetra
.191 .052 .451 r
.75623 .50965 .7567 .50228 .75746 .49924 .75701 .50684 Mtetra
.429 .245 .528 r
.75701 .50684 .75746 .49924 .75839 .49898 .75794 .50658 Mtetra
.551 .345 .555 r
.75794 .50658 .75839 .49898 .75948 .50149 .75902 .50883 Mtetra
.618 .4 .564 r
.75902 .50883 .75948 .50149 .76072 .50634 .76023 .51321 Mtetra
.656 .431 .567 r
.76023 .51321 .76072 .50634 .76206 .51283 .76153 .51908 Mtetra
.679 .449 .566 r
.76153 .51908 .76206 .51283 .76345 .52012 .76288 .52569 Mtetra
.691 .457 .563 r
.76288 .52569 .76345 .52012 .76485 .52745 .76423 .53233 Mtetra
.696 .458 .558 r
.76423 .53233 .76485 .52745 .76621 .53423 .76556 .53847 Mtetra
.694 .452 .552 r
.76556 .53847 .76621 .53423 .76753 .54007 .76684 .54375 Mtetra
.685 .438 .543 r
.76684 .54375 .76753 .54007 .76878 .54478 .76806 .54799 Mtetra
.665 .413 .53 r
.76806 .54799 .76878 .54478 .76995 .54829 .76922 .55115 Mtetra
.63 .373 .51 r
.76922 .55115 .76995 .54829 .77106 .55062 .77031 .55324 Mtetra
.565 .304 .479 r
.77031 .55324 .77106 .55062 .7721 .55181 .77134 .55429 Mtetra
.44 .18 .421 r
.77134 .55429 .7721 .55181 .77307 .55191 .77231 .55435 Mtetra
.182 0 .298 r
.77231 .55435 .77307 .55191 .77398 .55092 .77322 .55341 Mtetra
0 0 .046 r
.77322 .55341 .77398 .55092 .77481 .54882 .77407 .55147 Mtetra
.744 .752 .239 r
.77407 .55147 .77481 .54882 .77558 .54558 .77485 .54849 Mtetra
.926 .832 .379 r
.77485 .54849 .77558 .54558 .77627 .54114 .77556 .54443 Mtetra
.975 .831 .423 r
.77556 .54443 .77627 .54114 .77688 .5355 .77621 .53926 Mtetra
.986 .818 .425 r
.77621 .53926 .77688 .5355 .77742 .52873 .77678 .53308 Mtetra
.982 .805 .402 r
.77678 .53308 .77742 .52873 .7779 .52106 .77731 .52607 Mtetra
.96 .789 .346 r
.77731 .52607 .7779 .52106 .77834 .5129 .7778 .51861 Mtetra
.881 .74 .23 r
.7778 .51861 .77834 .5129 .7788 .50488 .7783 .51128 Mtetra
0 0 0 r
.7783 .51128 .7788 .50488 .77931 .49779 .77885 .50479 Mtetra
0 0 .284 r
.77885 .50479 .77931 .49779 .77993 .49245 .7795 .49989 Mtetra
.216 .073 .461 r
.7795 .49989 .77993 .49245 .7807 .48955 .7803 .49722 Mtetra
.439 .253 .53 r
.7803 .49722 .7807 .48955 .78166 .48947 .78126 .49712 Mtetra
.556 .348 .555 r
.78126 .49712 .78166 .48947 .7828 .49216 .78238 .49954 Mtetra
.62 .401 .563 r
.78238 .49954 .7828 .49216 .7841 .49718 .78365 .50408 Mtetra
.657 .431 .565 r
.78365 .50408 .7841 .49718 .7855 .50381 .78501 .51009 Mtetra
.68 .448 .564 r
.78501 .51009 .7855 .50381 .78696 .51121 .78642 .51679 Mtetra
.692 .456 .561 r
.78642 .51679 .78696 .51121 .78842 .51862 .78784 .52351 Mtetra
.696 .456 .556 r
.78784 .52351 .78842 .51862 .78985 .52545 .78922 .52969 Mtetra
.694 .45 .55 r
.78922 .52969 .78985 .52545 .79122 .53131 .79055 .535 Mtetra
.684 .436 .54 r
.79055 .535 .79122 .53131 .79251 .53603 .79182 .53926 Mtetra
.664 .411 .527 r
.79182 .53926 .79251 .53603 .79373 .53954 .79301 .54242 Mtetra
.628 .37 .508 r
.79301 .54242 .79373 .53954 .79487 .54187 .79414 .5445 Mtetra
.562 .3 .476 r
.79414 .5445 .79487 .54187 .79594 .54305 .7952 .54554 Mtetra
.437 .176 .419 r
.7952 .54554 .79594 .54305 .79693 .54312 .79619 .54558 Mtetra
.182 0 .3 r
.79619 .54558 .79693 .54312 .79785 .5421 .79711 .54462 Mtetra
0 0 .06 r
.79711 .54462 .79785 .5421 .79869 .53996 .79797 .54265 Mtetra
.722 .733 .214 r
.79797 .54265 .79869 .53996 .79946 .53666 .79875 .53962 Mtetra
.911 .821 .355 r
.79875 .53962 .79946 .53666 .80014 .53216 .79946 .5355 Mtetra
.966 .824 .401 r
.79946 .5355 .80014 .53216 .80074 .52644 .80009 .53027 Mtetra
.979 .813 .404 r
.80009 .53027 .80074 .52644 .80126 .5196 .80066 .52402 Mtetra
.974 .799 .378 r
.80066 .52402 .80126 .5196 .80171 .51186 .80116 .51695 Mtetra
.945 .778 .318 r
.80116 .51695 .80171 .51186 .80213 .50366 .80163 .50945 Mtetra
.851 .718 .192 r
.80163 .50945 .80213 .50366 .80256 .49563 .80211 .50212 Mtetra
0 0 .04 r
.80211 .50212 .80256 .49563 .80306 .48858 .80265 .49567 Mtetra
0 0 .312 r
.80265 .49567 .80306 .48858 .80368 .48334 .80331 .49086 Mtetra
.239 .092 .471 r
.80331 .49086 .80368 .48334 .80447 .48058 .80412 .48833 Mtetra
.449 .261 .532 r
.80412 .48833 .80447 .48058 .80547 .48067 .80511 .48838 Mtetra
.56 .351 .554 r
.80511 .48838 .80547 .48067 .80666 .48355 .80628 .49097 Mtetra
.622 .402 .562 r
.80628 .49097 .80666 .48355 .80801 .48874 .8076 .49568 Mtetra
.659 .431 .564 r
.8076 .49568 .80801 .48874 .80948 .49551 .80903 .50182 Mtetra
.68 .447 .562 r
.80903 .50182 .80948 .49551 .81101 .50302 .81051 .50862 Mtetra
.692 .455 .559 r
.81051 .50862 .81101 .50302 .81254 .51051 .81199 .51541 Mtetra
.696 .455 .554 r
.81199 .51541 .81254 .51051 .81403 .51738 .81343 .52164 Mtetra
.694 .448 .547 r
.81343 .52164 .81403 .51738 .81546 .52327 .81482 .52697 Mtetra
.684 .434 .538 r
.81482 .52697 .81546 .52327 .8168 .528 .81613 .53124 Mtetra
.663 .408 .524 r
.81613 .53124 .8168 .528 .81806 .53151 .81736 .53441 Mtetra
.626 .366 .505 r
.81736 .53441 .81806 .53151 .81924 .53383 .81852 .53648 Mtetra
.559 .297 .474 r
.81852 .53648 .81924 .53383 .82033 .53499 .81961 .53752 Mtetra
.433 .173 .418 r
.81961 .53752 .82033 .53499 .82135 .53504 .82062 .53753 Mtetra
.182 0 .302 r
.82062 .53753 .82135 .53504 .82228 .53398 .82156 .53655 Mtetra
0 0 .075 r
.82156 .53655 .82228 .53398 .82313 .5318 .82242 .53453 Mtetra
.698 .712 .187 r
.82242 .53453 .82313 .5318 .8239 .52844 .82321 .53145 Mtetra
.895 .808 .33 r
.82321 .53145 .8239 .52844 .82457 .52387 .82391 .52727 Mtetra
.956 .816 .378 r
.82391 .52727 .82457 .52387 .82515 .51808 .82454 .52197 Mtetra
.97 .806 .381 r
.82454 .52197 .82515 .51808 .82565 .51115 .82508 .51565 Mtetra
.963 .791 .353 r
.82508 .51565 .82565 .51115 .82608 .50334 .82556 .50851 Mtetra
.927 .765 .287 r
.82556 .50851 .82608 .50334 .82648 .49508 .82601 .50097 Mtetra
.817 .692 .152 r
.82601 .50097 .82648 .49508 .82688 .48704 .82648 .49363 Mtetra
0 0 .083 r
.82648 .49363 .82688 .48704 .82737 .48003 .82701 .48722 Mtetra
0 0 .337 r
.82701 .48722 .82737 .48003 .82799 .47488 .82766 .4825 Mtetra
.26 .11 .479 r
.82766 .4825 .82799 .47488 .8288 .47227 .82849 .4801 Mtetra
.457 .268 .534 r
.82849 .4801 .8288 .47227 .82983 .47254 .82952 .48031 Mtetra
.564 .354 .554 r
.82952 .48031 .82983 .47254 .83107 .47559 .83074 .48307 Mtetra
.624 .403 .561 r
.83074 .48307 .83107 .47559 .83249 .48096 .83212 .48794 Mtetra
.66 .431 .562 r
.83212 .48794 .83249 .48096 .83403 .48787 .83362 .49421 Mtetra
.681 .447 .56 r
.83362 .49421 .83403 .48787 .83563 .49549 .83516 .50112 Mtetra
.692 .454 .557 r
.83516 .50112 .83563 .49549 .83724 .50305 .83671 .50797 Mtetra
.696 .453 .552 r
.83671 .50797 .83724 .50305 .83879 .50997 .83822 .51425 Mtetra
.694 .446 .545 r
.83822 .51425 .83879 .50997 .84028 .51589 .83966 .5196 Mtetra
.683 .431 .535 r
.83966 .5196 .84028 .51589 .84167 .52063 .84102 .52389 Mtetra
.662 .405 .522 r
.84102 .52389 .84167 .52063 .84297 .52413 .84229 .52705 Mtetra
.624 .363 .502 r
.84229 .52705 .84297 .52413 .84418 .52644 .84348 .52912 Mtetra
.556 .293 .472 r
.84348 .52912 .84418 .52644 .84531 .52758 .8446 .53014 Mtetra
.429 .17 .416 r
.8446 .53014 .84531 .52758 .84634 .52761 .84563 .53013 Mtetra
.182 0 .305 r
.84563 .53013 .84634 .52761 .84729 .52651 .84659 .52911 Mtetra
0 0 .09 r
.84659 .52911 .84729 .52651 .84815 .52427 .84746 .52706 Mtetra
0 0 0 r
.84746 .52706 .84815 .52427 .84891 .52085 .84825 .52392 Mtetra
.876 .794 .303 r
.84825 .52392 .84891 .52085 .84958 .5162 .84895 .51967 Mtetra
.943 .807 .353 r
.84895 .51967 .84958 .5162 .85015 .51032 .84956 .5143 Mtetra
.959 .798 .356 r
.84956 .5143 .85015 .51032 .85062 .50331 .85008 .50789 Mtetra
.95 .781 .326 r
.85008 .50789 .85062 .50331 .85102 .49542 .85054 .50069 Mtetra
.906 .749 .254 r
.85054 .50069 .85102 .49542 .85139 .4871 .85097 .4931 Mtetra
.779 .664 .111 r
.85097 .4931 .85139 .4871 .85177 .47905 .85141 .48574 Mtetra
0 0 .124 r
.85141 .48574 .85177 .47905 .85224 .47207 .85193 .47936 Mtetra
0 0 .359 r
.85193 .47936 .85224 .47207 .85287 .46702 .85259 .47473 Mtetra
.28 .126 .486 r
.85259 .47473 .85287 .46702 .8537 .46455 .85344 .47246 Mtetra
.465 .274 .536 r
.85344 .47246 .8537 .46455 .85477 .46499 .85451 .47284 Mtetra
.567 .356 .554 r
.85451 .47284 .85477 .46499 .85606 .46823 .85578 .47577 Mtetra
.626 .403 .56 r
.85578 .47577 .85606 .46823 .85755 .47376 .85723 .48079 Mtetra
.661 .431 .56 r
.85723 .48079 .85755 .47376 .85917 .48082 .85879 .48719 Mtetra
.681 .446 .558 r
.85879 .48719 .85917 .48082 .86085 .48855 .86041 .4942 Mtetra
.693 .452 .555 r
.86041 .4942 .86085 .48855 .86253 .49618 .86203 .50113 Mtetra
.696 .452 .549 r
.86203 .50113 .86253 .49618 .86415 .50314 .8636 .50744 Mtetra
.693 .444 .542 r
.8636 .50744 .86415 .50314 .86569 .50908 .8651 .51282 Mtetra
.682 .429 .533 r
.8651 .51282 .86569 .50908 .86714 .51383 .86651 .51711 Mtetra
.66 .402 .519 r
.86651 .51711 .86714 .51383 .86849 .51733 .86782 .52028 Mtetra
.621 .359 .5 r
.86782 .52028 .86849 .51733 .86973 .51962 .86905 .52234 Mtetra
.552 .288 .469 r
.86905 .52234 .86973 .51962 .87089 .52075 .87019 .52334 Mtetra
.425 .166 .415 r
.87019 .52334 .87089 .52075 .87194 .52074 .87125 .5233 Mtetra
.18 0 .307 r
.87125 .5233 .87194 .52074 .87291 .5196 .87222 .52225 Mtetra
0 0 .105 r
.87222 .52225 .87291 .5196 .87377 .5173 .8731 .52014 Mtetra
0 0 0 r
.8731 .52014 .87377 .5173 .87454 .51381 .87389 .51694 Mtetra
.856 .777 .275 r
.87389 .51694 .87454 .51381 .87519 .50908 .87459 .51261 Mtetra
.928 .795 .327 r
.87459 .51261 .87519 .50908 .87574 .5031 .87518 .50716 Mtetra
.946 .787 .329 r
.87518 .50716 .87574 .5031 .87619 .49599 .87569 .50067 Mtetra
.934 .769 .296 r
.87569 .50067 .87619 .49599 .87657 .48801 .87613 .49339 Mtetra
.882 .731 .219 r
.87613 .49339 .87657 .48801 .8769 .47964 .87653 .48574 Mtetra
.737 .632 .069 r
.87653 .48574 .8769 .47964 .87726 .47157 .87695 .47837 Mtetra
0 0 .162 r
.87695 .47837 .87726 .47157 .87772 .46463 .87746 .47202 Mtetra
0 0 .378 r
.87746 .47202 .87772 .46463 .87834 .45966 .87812 .46748 Mtetra
.297 .14 .492 r
.87812 .46748 .87834 .45966 .8792 .45733 .879 .46533 Mtetra
.473 .28 .537 r
.879 .46533 .8792 .45733 .88031 .45794 .8801 .46587 Mtetra
.571 .358 .553 r
.8801 .46587 .88031 .45794 .88167 .46136 .88143 .46897 Mtetra
.627 .404 .558 r
.88143 .46897 .88167 .46136 .88323 .46707 .88295 .47414 Mtetra
.662 .43 .559 r
.88295 .47414 .88323 .46707 .88493 .47427 .88459 .48068 Mtetra
.682 .445 .556 r
.88459 .48068 .88493 .47427 .88668 .4821 .88628 .48779 Mtetra
.693 .451 .553 r
.88628 .48779 .88668 .4821 .88843 .48981 .88797 .49478 Mtetra
.696 .45 .547 r
.88797 .49478 .88843 .48981 .89013 .49682 .88961 .50114 Mtetra
.692 .442 .54 r
.88961 .50114 .89013 .49682 .89173 .50278 .89116 .50654 Mtetra
.681 .426 .53 r
.89116 .50654 .89173 .50278 .89324 .50753 .89262 .51084 Mtetra
.658 .399 .517 r
.89262 .51084 .89324 .50753 .89463 .51102 .89399 .514 Mtetra
.618 .355 .497 r
.89399 .514 .89463 .51102 .89591 .5133 .89525 .51604 Mtetra
.548 .284 .467 r
.89525 .51604 .89591 .5133 .89709 .51439 .89642 .51702 Mtetra
.42 .162 .413 r
.89642 .51702 .89709 .51439 .89817 .51434 .8975 .51695 Mtetra
.179 0 .31 r
.8975 .51695 .89817 .51434 .89915 .51316 .89849 .51585 Mtetra
0 0 .118 r
.89849 .51585 .89915 .51316 .90002 .5108 .89938 .51369 Mtetra
0 0 0 r
.89938 .51369 .90002 .5108 .90078 .50723 .90017 .51043 Mtetra
.834 .759 .246 r
.90017 .51043 .90078 .50723 .90143 .50241 .90085 .50602 Mtetra
.911 .782 .299 r
.90085 .50602 .90143 .50241 .90196 .49634 .90144 .50047 Mtetra
.93 .775 .301 r
.90144 .50047 .90196 .49634 .90239 .48912 .90192 .49389 Mtetra
.915 .755 .265 r
.90192 .49389 .90239 .48912 .90273 .48105 .90233 .48653 Mtetra
.854 .71 .182 r
.90233 .48653 .90273 .48105 .90304 .47261 .90271 .47882 Mtetra
0 0 0 r
.90271 .47882 .90304 .47261 .90337 .46451 .90311 .47143 Mtetra
0 0 .198 r
.90311 .47143 .90337 .46451 .90381 .4576 .90361 .46511 Mtetra
.025 0 .396 r
.90361 .46511 .90381 .4576 .90444 .45273 .90428 .46065 Mtetra
.313 .153 .498 r
.90428 .46065 .90444 .45273 .90532 .45053 .90518 .45863 Mtetra
.479 .285 .538 r
.90518 .45863 .90532 .45053 .90648 .45132 .90633 .45933 Mtetra
.574 .36 .553 r
.90633 .45933 .90648 .45132 .9079 .45492 .90772 .46259 Mtetra
.629 .404 .557 r
.90772 .46259 .9079 .45492 .90954 .4608 .90931 .46793 Mtetra
.662 .43 .557 r
.90931 .46793 .90954 .4608 .91132 .46814 .91102 .47459 Mtetra
.682 .444 .554 r
.91102 .47459 .91132 .46814 .91316 .47608 .9128 .4818 Mtetra
.693 .449 .55 r
.9128 .4818 .91316 .47608 .91499 .48385 .91456 .48886 Mtetra
.696 .448 .545 r
.91456 .48886 .91499 .48385 .91675 .4909 .91626 .49525 Mtetra
.692 .44 .537 r
.91626 .49525 .91675 .4909 .91842 .49688 .91788 .50067 Mtetra
.679 .423 .527 r
.91788 .50067 .91842 .49688 .91998 .50163 .91939 .50497 Mtetra
.656 .395 .514 r
.91939 .50497 .91998 .50163 .92142 .50512 .9208 .50813 Mtetra
.615 .351 .494 r
.9208 .50813 .92142 .50512 .92274 .50737 .9221 .51015 Mtetra
.544 .279 .464 r
.9221 .51015 .92274 .50737 .92395 .50844 .9233 .5111 Mtetra
.415 .157 .412 r
.9233 .5111 .92395 .50844 .92506 .50835 .9244 .511 Mtetra
.176 0 .312 r
.9244 .511 .92506 .50835 .92605 .50711 .92541 .50986 Mtetra
0 0 .132 r
.92541 .50986 .92605 .50711 .92693 .50469 .9263 .50764 Mtetra
0 0 0 r
.9263 .50764 .92693 .50469 .92768 .50104 .9271 .5043 Mtetra
.811 .74 .216 r
.9271 .5043 .92768 .50104 .92832 .49611 .92777 .4998 Mtetra
.892 .767 .27 r
.92777 .4998 .92832 .49611 .92883 .48993 .92834 .49416 Mtetra
.912 .761 .271 r
.92834 .49416 .92883 .48993 .92922 .48261 .9288 .48748 Mtetra
.893 .738 .233 r
.9288 .48748 .92922 .48261 .92954 .47444 .92918 .48002 Mtetra
.823 .686 .145 r
.92918 .48002 .92954 .47444 .92981 .46593 .92953 .47226 Mtetra
0 0 .014 r
.92953 .47226 .92981 .46593 .93012 .4578 .92991 .46484 Mtetra
0 0 .231 r
.92991 .46484 .93012 .4578 .93055 .45092 .9304 .45855 Mtetra
.057 0 .411 r
.9304 .45855 .93055 .45092 .93118 .44613 .93108 .45417 Mtetra
.327 .165 .503 r
.93108 .45417 .93118 .44613 .93209 .44408 .93201 .45228 Mtetra
.486 .29 .539 r
.93201 .45228 .93209 .44408 .93329 .44504 .9332 .45313 Mtetra
.576 .362 .552 r
.9332 .45313 .93329 .44504 .93478 .44882 .93466 .45656 Mtetra
.63 .404 .556 r
.93466 .45656 .93478 .44882 .9365 .45487 .93632 .46205 Mtetra
.663 .429 .555 r
.93632 .46205 .9365 .45487 .93837 .46235 .93812 .46884 Mtetra
.682 .442 .552 r
.93812 .46884 .93837 .46235 .94029 .47039 .93997 .47615 Mtetra
.693 .448 .548 r
.93997 .47615 .94029 .47039 .94221 .47823 .94181 .48327 Mtetra
.695 .446 .542 r
.94181 .48327 .94221 .47823 .94405 .48532 .94359 .4897 Mtetra
.691 .437 .535 r
.94359 .4897 .94405 .48532 .94578 .49132 .94527 .49514 Mtetra
.678 .42 .525 r
.94527 .49514 .94578 .49132 .9474 .49607 .94684 .49944 Mtetra
.654 .392 .511 r
.94684 .49944 .9474 .49607 .94888 .49954 .94829 .50258 Mtetra
.612 .347 .492 r
.94829 .50258 .94888 .49954 .95025 .50177 .94963 .50459 Mtetra
.539 .274 .462 r
.94963 .50459 .95025 .50177 .95149 .5028 .95086 .50551 Mtetra
.409 .152 .411 r
.95086 .50551 .95149 .5028 .95261 .50267 .95199 .50537 Mtetra
.173 0 .314 r
.95199 .50537 .95261 .50267 .95362 .50137 .953 .50417 Mtetra
0 0 .144 r
.953 .50417 .95362 .50137 .9545 .49888 .95391 .50188 Mtetra
0 0 0 r
.95391 .50188 .9545 .49888 .95526 .49514 .9547 .49846 Mtetra
.787 .72 .187 r
.9547 .49846 .95526 .49514 .95588 .49011 .95536 .49388 Mtetra
.872 .75 .24 r
.95536 .49388 .95588 .49011 .95637 .48382 .95591 .48813 Mtetra
.892 .745 .241 r
.95591 .48813 .95637 .48382 .95673 .47638 .95635 .48135 Mtetra
.869 .719 .199 r
.95635 .48135 .95673 .47638 .95701 .4681 .9567 .4738 Mtetra
.789 .66 .107 r
.9567 .4738 .95701 .4681 .95725 .45952 .95702 .46596 Mtetra
0 0 .054 r
.95702 .46596 .95725 .45952 .95753 .45136 .95738 .45852 Mtetra
0 0 .261 r
.95738 .45852 .95753 .45136 .95795 .44451 .95787 .45225 Mtetra
.086 0 .425 r
.95787 .45225 .95795 .44451 .95859 .4398 .95855 .44795 Mtetra
.341 .176 .507 r
.95855 .44795 .95859 .4398 .95952 .43789 .9595 .44619 Mtetra
.491 .294 .54 r
.9595 .44619 .95952 .43789 .96078 .43902 .96075 .4472 Mtetra
.579 .363 .551 r
.96075 .4472 .96078 .43902 .96234 .44299 .96227 .4508 Mtetra
.631 .404 .554 r
.96227 .4508 .96234 .44299 .96414 .4492 .96402 .45644 Mtetra
.664 .428 .553 r
.96402 .45644 .96414 .4492 .9661 .45682 .9659 .46336 Mtetra
.683 .441 .55 r
.9659 .46336 .9661 .45682 .96812 .46496 .96784 .47076 Mtetra
.692 .446 .546 r
.96784 .47076 .96812 .46496 .97012 .47287 .96976 .47794 Mtetra
.695 .444 .54 r
.96976 .47794 .97012 .47287 .97203 .48 .97161 .48441 Mtetra
.69 .434 .532 r
.97161 .48441 .97203 .48 .97384 .48601 .97335 .48986 Mtetra
.676 .417 .522 r
.97335 .48986 .97384 .48601 .97551 .49076 .97498 .49416 Mtetra
.651 .388 .508 r
.97498 .49416 .97551 .49076 .97705 .49422 .97648 .49729 Mtetra
.608 .342 .489 r
.97648 .49729 .97705 .49422 .97845 .49642 .97786 .49928 Mtetra
.534 .268 .459 r
.97786 .49928 .97845 .49642 .97972 .49741 .97912 .50016 Mtetra
.402 .147 .409 r
.97912 .50016 .97972 .49741 .98087 .49723 .98027 .49998 Mtetra
.169 0 .316 r
.98027 .49998 .98087 .49723 .98189 .49587 .9813 .49872 Mtetra
0 0 .156 r
.9813 .49872 .98189 .49587 .98278 .4933 .98221 .49637 Mtetra
0 0 0 r
.98221 .49637 .98278 .4933 .98353 .48946 .983 .49286 Mtetra
.762 .698 .157 r
.983 .49286 .98353 .48946 .98413 .48433 .98365 .48818 Mtetra
.849 .731 .209 r
.98365 .48818 .98413 .48433 .9846 .47791 .98418 .48232 Mtetra
.869 .727 .209 r
.98418 .48232 .9846 .47791 .98493 .47036 .98459 .47543 Mtetra
.842 .698 .164 r
.98459 .47543 .98493 .47036 .98517 .46197 .98491 .46778 Mtetra
.752 .631 .068 r
.98491 .46778 .98517 .46197 .98537 .45331 .98521 .45987 Mtetra
0 0 .093 r
.98521 .45987 .98537 .45331 .98563 .44512 .98554 .45239 Mtetra
0 0 .289 r
.98554 .45239 .98563 .44512 .98603 .43829 .98602 .44616 Mtetra
.113 .002 .437 r
.98602 .44616 .98603 .43829 .98668 .43367 .98671 .44193 Mtetra
.353 .186 .511 r
.98671 .44193 .98668 .43367 .98765 .4319 .9877 .4403 Mtetra
.477 .289 .546 r
.52833 .65766 .52917 .64983 .52994 .65046 .5291 .65816 Mtetra
.568 .367 .569 r
.5291 .65816 .52994 .65046 .53073 .65333 .52988 .66068 Mtetra
.619 .41 .578 r
.52988 .66068 .53073 .65333 .53153 .65796 .53069 .66476 Mtetra
.648 .435 .581 r
.53069 .66476 .53153 .65796 .53235 .66366 .5315 .6698 Mtetra
.664 .448 .581 r
.5315 .6698 .53235 .66366 .53317 .66974 .53232 .67518 Mtetra
.672 .452 .578 r
.53232 .67518 .53317 .66974 .534 .67559 .53313 .68036 Mtetra
.673 .449 .573 r
.53313 .68036 .534 .67559 .53482 .6808 .53395 .68496 Mtetra
.666 .439 .566 r
.53395 .68496 .53482 .6808 .53563 .68511 .53476 .68875 Mtetra
.651 .42 .555 r
.53476 .68875 .53563 .68511 .53644 .68841 .53556 .69164 Mtetra
.622 .386 .539 r
.53556 .69164 .53644 .68841 .53724 .69069 .53635 .69362 Mtetra
.571 .33 .512 r
.53635 .69362 .53724 .69069 .53803 .69198 .53714 .6947 Mtetra
.475 .231 .464 r
.53714 .6947 .53803 .69198 .53881 .69231 .53792 .69494 Mtetra
.28 .043 .365 r
.53792 .69494 .53881 .69231 .53958 .69171 .53869 .69434 Mtetra
0 0 .143 r
.53869 .69434 .53958 .69171 .54034 .69018 .53946 .69291 Mtetra
0 0 0 r
.53946 .69291 .54034 .69018 .5411 .68769 .54021 .69062 Mtetra
.914 .857 .415 r
.54021 .69062 .5411 .68769 .54184 .6842 .54096 .68745 Mtetra
.982 .863 .488 r
.54096 .68745 .54184 .6842 .54256 .67969 .54169 .68335 Mtetra
.996 .847 .505 r
.54169 .68335 .54256 .67969 .54328 .67417 .54242 .67835 Mtetra
.998 .835 .497 r
.54242 .67835 .54328 .67417 .54399 .66775 .54313 .67254 Mtetra
.994 .829 .468 r
.54313 .67254 .54399 .66775 .54468 .66069 .54384 .66617 Mtetra
.972 .819 .402 r
.54384 .66617 .54468 .66069 .54538 .65343 .54454 .65961 Mtetra
.871 .76 .254 r
.54454 .65961 .54538 .65343 .54607 .64658 .54525 .65342 Mtetra
0 0 .042 r
.54525 .65342 .54607 .64658 .54678 .64084 .54596 .64822 Mtetra
0 0 .348 r
.54596 .64822 .54678 .64084 .54751 .63689 .5467 .64462 Mtetra
.313 .151 .494 r
.5467 .64462 .54751 .63689 .54826 .63521 .54745 .64305 Mtetra
.483 .294 .548 r
.54745 .64305 .54826 .63521 .54905 .63596 .54824 .64367 Mtetra
.571 .369 .568 r
.54824 .64367 .54905 .63596 .54986 .63896 .54905 .64629 Mtetra
.62 .411 .577 r
.54905 .64629 .54986 .63896 .5507 .64368 .54989 .65045 Mtetra
.649 .435 .58 r
.54989 .65045 .5507 .64368 .55156 .64944 .55073 .65556 Mtetra
.665 .447 .579 r
.55073 .65556 .55156 .64944 .55242 .65555 .55159 .66097 Mtetra
.673 .451 .576 r
.55159 .66097 .55242 .65555 .55329 .66142 .55244 .66615 Mtetra
.673 .448 .572 r
.55244 .66615 .55329 .66142 .55414 .66662 .55329 .67074 Mtetra
.666 .437 .564 r
.55329 .67074 .55414 .66662 .55499 .6709 .55413 .67451 Mtetra
.65 .417 .553 r
.55413 .67451 .55499 .6709 .55582 .67417 .55496 .67737 Mtetra
.621 .383 .536 r
.55496 .67737 .55582 .67417 .55665 .67641 .55577 .67932 Mtetra
.568 .326 .509 r
.55577 .67932 .55665 .67641 .55745 .67766 .55658 .68037 Mtetra
.469 .224 .459 r
.55658 .68037 .55745 .67766 .55825 .67795 .55737 .68057 Mtetra
.269 .032 .358 r
.55737 .68057 .55825 .67795 .55903 .67731 .55816 .67993 Mtetra
0 0 .135 r
.55816 .67993 .55903 .67731 .5598 .67573 .55893 .67846 Mtetra
0 0 0 r
.55893 .67846 .5598 .67573 .56056 .67319 .55969 .67613 Mtetra
.912 .854 .408 r
.55969 .67613 .56056 .67319 .5613 .66964 .56043 .6729 Mtetra
.98 .861 .479 r
.56043 .6729 .5613 .66964 .56202 .66506 .56116 .66874 Mtetra
.995 .846 .495 r
.56116 .66874 .56202 .66506 .56273 .65947 .56188 .66368 Mtetra
.997 .834 .486 r
.56188 .66368 .56273 .65947 .56342 .65299 .56258 .65782 Mtetra
.991 .827 .454 r
.56258 .65782 .56342 .65299 .5641 .64588 .56328 .6514 Mtetra
.963 .813 .383 r
.56328 .6514 .5641 .64588 .56477 .6386 .56397 .64483 Mtetra
.846 .742 .223 r
.56397 .64483 .56477 .6386 .56545 .63177 .56466 .63865 Mtetra
0 0 .077 r
.56466 .63865 .56545 .63177 .56615 .62609 .56537 .6335 Mtetra
.007 0 .365 r
.56537 .6335 .56615 .62609 .56688 .62223 .5661 .62998 Mtetra
.327 .162 .499 r
.5661 .62998 .56688 .62223 .56764 .62067 .56687 .62853 Mtetra
.489 .299 .549 r
.56687 .62853 .56764 .62067 .56845 .62155 .56768 .62926 Mtetra
.574 .371 .568 r
.56768 .62926 .56845 .62155 .5693 .62467 .56852 .63199 Mtetra
.622 .412 .576 r
.56852 .63199 .5693 .62467 .57017 .62948 .56938 .63624 Mtetra
.65 .435 .578 r
.56938 .63624 .57017 .62948 .57107 .63532 .57027 .6414 Mtetra
.665 .446 .578 r
.57027 .6414 .57107 .63532 .57197 .64146 .57116 .64685 Mtetra
.673 .45 .575 r
.57116 .64685 .57197 .64146 .57288 .64734 .57205 .65204 Mtetra
.673 .447 .57 r
.57205 .65204 .57288 .64734 .57377 .65253 .57293 .65662 Mtetra
.666 .436 .562 r
.57293 .65662 .57377 .65253 .57465 .65679 .5738 .66037 Mtetra
.649 .415 .551 r
.5738 .66037 .57465 .65679 .57551 .66003 .57466 .66321 Mtetra
.619 .38 .533 r
.57466 .66321 .57551 .66003 .57636 .66224 .5755 .66512 Mtetra
.565 .321 .505 r
.5755 .66512 .57636 .66224 .57718 .66345 .57632 .66615 Mtetra
.463 .217 .455 r
.57632 .66615 .57718 .66345 .578 .66371 .57713 .66631 Mtetra
.259 .022 .352 r
.57713 .66631 .578 .66371 .57879 .66302 .57793 .66564 Mtetra
0 0 .128 r
.57793 .66564 .57879 .66302 .57957 .6614 .5787 .66413 Mtetra
0 0 0 r
.5787 .66413 .57957 .6614 .58032 .6588 .57947 .66175 Mtetra
.909 .85 .4 r
.57947 .66175 .58032 .6588 .58106 .6552 .58021 .65846 Mtetra
.977 .858 .469 r
.58021 .65846 .58106 .6552 .58178 .65055 .58094 .65425 Mtetra
.993 .844 .485 r
.58094 .65425 .58178 .65055 .58248 .64489 .58165 .64913 Mtetra
.995 .833 .474 r
.58165 .64913 .58248 .64489 .58315 .63835 .58234 .64322 Mtetra
.987 .825 .439 r
.58234 .64322 .58315 .63835 .58382 .6312 .58302 .63676 Mtetra
.953 .806 .361 r
.58302 .63676 .58382 .6312 .58447 .62391 .58369 .63017 Mtetra
.818 .722 .191 r
.58369 .63017 .58447 .62391 .58514 .61709 .58438 .62401 Mtetra
0 0 .111 r
.58438 .62401 .58514 .61709 .58583 .61147 .58508 .61892 Mtetra
.038 0 .381 r
.58508 .61892 .58583 .61147 .58656 .60771 .58581 .61549 Mtetra
.34 .173 .504 r
.58581 .61549 .58656 .60771 .58733 .60627 .58659 .61414 Mtetra
.495 .303 .55 r
.58659 .61414 .58733 .60627 .58816 .60729 .58742 .615 Mtetra
.577 .373 .568 r
.58742 .615 .58816 .60729 .58904 .61053 .58829 .61784 Mtetra
.623 .412 .575 r
.58829 .61784 .58904 .61053 .58995 .61545 .58919 .62218 Mtetra
.651 .434 .577 r
.58919 .62218 .58995 .61545 .59089 .62135 .59011 .62741 Mtetra
.666 .446 .576 r
.59011 .62741 .59089 .62135 .59184 .62754 .59104 .63289 Mtetra
.673 .449 .573 r
.59104 .63289 .59184 .62754 .59278 .63342 .59197 .63809 Mtetra
.673 .446 .568 r
.59197 .63809 .59278 .63342 .59371 .6386 .59289 .64267 Mtetra
.665 .434 .56 r
.59289 .64267 .59371 .6386 .59462 .64285 .59379 .6464 Mtetra
.648 .413 .548 r
.59379 .6464 .59462 .64285 .59551 .64606 .59467 .64922 Mtetra
.617 .377 .53 r
.59467 .64922 .59551 .64606 .59638 .64824 .59554 .65111 Mtetra
.562 .317 .502 r
.59554 .65111 .59638 .64824 .59723 .64943 .59638 .65211 Mtetra
.458 .211 .451 r
.59638 .65211 .59723 .64943 .59806 .64965 .5972 .65224 Mtetra
.249 .013 .346 r
.5972 .65224 .59806 .64965 .59886 .64892 .59801 .65154 Mtetra
0 0 .122 r
.59801 .65154 .59886 .64892 .59965 .64725 .5988 .64998 Mtetra
0 0 0 r
.5988 .64998 .59965 .64725 .60041 .64461 .59956 .64756 Mtetra
.904 .845 .39 r
.59956 .64756 .60041 .64461 .60114 .64094 .60031 .64423 Mtetra
.974 .855 .459 r
.60031 .64423 .60114 .64094 .60185 .63624 .60103 .63996 Mtetra
.991 .842 .474 r
.60103 .63996 .60185 .63624 .60254 .63052 .60173 .63478 Mtetra
.992 .831 .462 r
.60173 .63478 .60254 .63052 .6032 .62392 .60241 .62882 Mtetra
.982 .821 .423 r
.60241 .62882 .6032 .62392 .60385 .61673 .60308 .62233 Mtetra
.94 .797 .338 r
.60308 .62233 .60385 .61673 .60449 .60942 .60374 .61573 Mtetra
.787 .698 .157 r
.60374 .61573 .60449 .60942 .60514 .60262 .60441 .60958 Mtetra
0 0 .144 r
.60441 .60958 .60514 .60262 .60582 .59707 .6051 .60455 Mtetra
.067 0 .396 r
.6051 .60455 .60582 .59707 .60655 .59341 .60584 .60122 Mtetra
.353 .184 .508 r
.60584 .60122 .60655 .59341 .60734 .5921 .60663 .59999 Mtetra
.5 .308 .551 r
.60663 .59999 .60734 .5921 .60819 .59326 .60748 .60097 Mtetra
.579 .375 .568 r
.60748 .60097 .60819 .59326 .6091 .59663 .60838 .60392 Mtetra
.625 .413 .574 r
.60838 .60392 .6091 .59663 .61005 .60165 .60932 .60836 Mtetra
.652 .434 .576 r
.60932 .60836 .61005 .60165 .61104 .60762 .61029 .61365 Mtetra
.667 .445 .575 r
.61029 .61365 .61104 .60762 .61203 .61385 .61126 .61917 Mtetra
.674 .448 .571 r
.61126 .61917 .61203 .61385 .61301 .61975 .61223 .62439 Mtetra
.673 .444 .566 r
.61223 .62439 .61301 .61975 .61398 .62493 .61318 .62896 Mtetra
.665 .432 .558 r
.61318 .62896 .61398 .62493 .61493 .62916 .61411 .63269 Mtetra
.648 .41 .546 r
.61411 .63269 .61493 .62916 .61585 .63235 .61502 .63549 Mtetra
.616 .374 .528 r
.61502 .63549 .61585 .63235 .61674 .63451 .61591 .63736 Mtetra
.559 .312 .498 r
.61591 .63736 .61674 .63451 .61761 .63566 .61677 .63833 Mtetra
.453 .205 .447 r
.61677 .63833 .61761 .63566 .61845 .63585 .61761 .63844 Mtetra
.241 .005 .341 r
.61761 .63844 .61845 .63585 .61927 .63509 .61843 .6377 Mtetra
0 0 .119 r
.61843 .6377 .61927 .63509 .62006 .63338 .61922 .63612 Mtetra
0 0 0 r
.61922 .63612 .62006 .63338 .62082 .63069 .61999 .63365 Mtetra
.899 .84 .38 r
.61999 .63365 .62082 .63069 .62156 .62697 .62074 .63027 Mtetra
.97 .851 .447 r
.62074 .63027 .62156 .62697 .62226 .6222 .62146 .62595 Mtetra
.988 .84 .462 r
.62146 .62595 .62226 .6222 .62294 .61642 .62215 .62072 Mtetra
.989 .828 .447 r
.62215 .62072 .62294 .61642 .62358 .60977 .62281 .61471 Mtetra
.976 .817 .405 r
.62281 .61471 .62358 .60977 .62421 .60254 .62347 .60818 Mtetra
.925 .787 .313 r
.62347 .60818 .62421 .60254 .62483 .59522 .62411 .60157 Mtetra
.752 .672 .122 r
.62411 .60157 .62483 .59522 .62547 .58845 .62477 .59546 Mtetra
0 0 .177 r
.62477 .59546 .62547 .58845 .62615 .58296 .62546 .59048 Mtetra
.096 0 .409 r
.62546 .59048 .62615 .58296 .62688 .57941 .62621 .58725 Mtetra
.365 .194 .512 r
.62621 .58725 .62688 .57941 .62768 .57824 .62701 .58614 Mtetra
.506 .312 .551 r
.62701 .58614 .62768 .57824 .62856 .57954 .62788 .58725 Mtetra
.582 .376 .567 r
.62788 .58725 .62856 .57954 .6295 .58304 .62882 .59033 Mtetra
.626 .413 .573 r
.62882 .59033 .6295 .58304 .6305 .58817 .62979 .59487 Mtetra
.653 .434 .574 r
.62979 .59487 .6305 .58817 .63152 .59422 .6308 .60023 Mtetra
.667 .445 .573 r
.6308 .60023 .63152 .59422 .63256 .6005 .63182 .60579 Mtetra
.674 .448 .57 r
.63182 .60579 .63256 .6005 .63359 .60642 .63282 .61103 Mtetra
.673 .443 .564 r
.63282 .61103 .63359 .60642 .6346 .6116 .63381 .6156 Mtetra
.665 .431 .556 r
.63381 .6156 .6346 .6116 .63558 .61581 .63478 .61932 Mtetra
.647 .408 .543 r
.63478 .61932 .63558 .61581 .63653 .61899 .63572 .6221 Mtetra
.615 .371 .525 r
.63572 .6221 .63653 .61899 .63745 .62113 .63663 .62396 Mtetra
.557 .309 .495 r
.63663 .62396 .63745 .62113 .63834 .62226 .63751 .62491 Mtetra
.449 .199 .443 r
.63751 .62491 .63834 .62226 .6392 .62242 .63837 .625 Mtetra
.234 0 .337 r
.63837 .625 .6392 .62242 .64003 .62163 .6392 .62423 Mtetra
0 0 .117 r
.6392 .62423 .64003 .62163 .64083 .61988 .64 .62261 Mtetra
0 0 0 r
.64 .62261 .64083 .61988 .64159 .61714 .64078 .62011 Mtetra
.891 .833 .367 r
.64078 .62011 .64159 .61714 .64232 .61337 .64152 .61668 Mtetra
.965 .847 .434 r
.64152 .61668 .64232 .61337 .64302 .60854 .64223 .61231 Mtetra
.984 .837 .448 r
.64223 .61231 .64302 .60854 .64368 .6027 .64291 .60703 Mtetra
.984 .825 .432 r
.64291 .60703 .64368 .6027 .64431 .596 .64357 .60098 Mtetra
.968 .811 .386 r
.64357 .60098 .64431 .596 .64492 .58873 .6442 .59442 Mtetra
.907 .774 .286 r
.6442 .59442 .64492 .58873 .64553 .5814 .64484 .5878 Mtetra
.714 .643 .085 r
.64484 .5878 .64553 .5814 .64615 .57467 .64549 .58172 Mtetra
0 0 .208 r
.64549 .58172 .64615 .57467 .64682 .56925 .64617 .57682 Mtetra
.123 0 .422 r
.64617 .57682 .64682 .56925 .64755 .56582 .64692 .57368 Mtetra
.377 .204 .516 r
.64692 .57368 .64755 .56582 .64837 .56479 .64774 .5727 Mtetra
.511 .316 .552 r
.64774 .5727 .64837 .56479 .64928 .56623 .64864 .57395 Mtetra
.585 .378 .567 r
.64864 .57395 .64928 .56623 .65026 .56987 .64961 .57715 Mtetra
.628 .414 .572 r
.64961 .57715 .65026 .56987 .6513 .57511 .65063 .58179 Mtetra
.654 .434 .573 r
.65063 .58179 .6513 .57511 .65237 .58124 .65168 .58723 Mtetra
.668 .444 .572 r
.65168 .58723 .65237 .58124 .65346 .58757 .65274 .59283 Mtetra
.674 .447 .568 r
.65274 .59283 .65346 .58757 .65453 .59351 .65379 .5981 Mtetra
.673 .442 .562 r
.65379 .5981 .65453 .59351 .65558 .5987 .65481 .60268 Mtetra
.665 .429 .553 r
.65481 .60268 .65558 .5987 .6566 .60291 .65581 .60639 Mtetra
.647 .406 .541 r
.65581 .60639 .6566 .60291 .65758 .60608 .65678 .60917 Mtetra
.613 .368 .522 r
.65678 .60917 .65758 .60608 .65853 .60819 .65772 .61101 Mtetra
.554 .305 .492 r
.65772 .61101 .65853 .60819 .65944 .6093 .65862 .61195 Mtetra
.445 .195 .439 r
.65862 .61195 .65944 .6093 .66031 .60944 .6595 .61201 Mtetra
.229 0 .333 r
.6595 .61201 .66031 .60944 .66116 .60862 .66034 .61123 Mtetra
0 0 .118 r
.66034 .61123 .66116 .60862 .66196 .60684 .66115 .60958 Mtetra
0 0 0 r
.66115 .60958 .66196 .60684 .66273 .60405 .66193 .60704 Mtetra
.882 .826 .353 r
.66193 .60704 .66273 .60405 .66346 .60023 .66267 .60357 Mtetra
.959 .842 .42 r
.66267 .60357 .66346 .60023 .66415 .59535 .66338 .59915 Mtetra
.979 .833 .433 r
.66338 .59915 .66415 .59535 .6648 .58946 .66405 .59382 Mtetra
.978 .821 .415 r
.66405 .59382 .6648 .58946 .66541 .5827 .66469 .58772 Mtetra
.958 .804 .364 r
.66469 .58772 .66541 .5827 .666 .5754 .66531 .58114 Mtetra
.886 .759 .256 r
.66531 .58114 .666 .5754 .66659 .56806 .66593 .57452 Mtetra
0 0 0 r
.66593 .57452 .66659 .56806 .6672 .56137 .66657 .56847 Mtetra
0 0 .237 r
.66657 .56847 .6672 .56137 .66786 .55603 .66725 .56364 Mtetra
.149 .018 .434 r
.66725 .56364 .66786 .55603 .6686 .55271 .66801 .56062 Mtetra
.388 .214 .519 r
.66801 .56062 .6686 .55271 .66944 .55183 .66885 .55977 Mtetra
.516 .32 .553 r
.66885 .55977 .66944 .55183 .67037 .55343 .66977 .56115 Mtetra
.588 .38 .566 r
.66977 .56115 .67037 .55343 .67139 .5572 .67078 .56448 Mtetra
.63 .414 .571 r
.67078 .56448 .67139 .5572 .67248 .56256 .67184 .56923 Mtetra
.655 .434 .572 r
.67184 .56923 .67248 .56256 .67361 .56878 .67294 .57475 Mtetra
.669 .444 .57 r
.67294 .57475 .67361 .56878 .67474 .57516 .67404 .5804 Mtetra
.675 .446 .566 r
.67404 .5804 .67474 .57516 .67586 .58114 .67514 .5857 Mtetra
.674 .441 .56 r
.67514 .5857 .67586 .58114 .67695 .58633 .6762 .59029 Mtetra
.665 .428 .551 r
.6762 .59029 .67695 .58633 .67801 .59054 .67724 .59401 Mtetra
.646 .404 .538 r
.67724 .59401 .67801 .59054 .67902 .5937 .67824 .59678 Mtetra
.612 .366 .519 r
.67824 .59678 .67902 .5937 .68 .59581 .6792 .59861 Mtetra
.553 .302 .489 r
.6792 .59861 .68 .59581 .68093 .5969 .68013 .59954 Mtetra
.442 .191 .436 r
.68013 .59954 .68093 .5969 .68182 .59702 .68102 .59959 Mtetra
.226 0 .331 r
.68102 .59959 .68182 .59702 .68268 .59617 .68187 .59878 Mtetra
0 0 .122 r
.68187 .59878 .68268 .59617 .68349 .59435 .68269 .59711 Mtetra
0 0 0 r
.68269 .59711 .68349 .59435 .68426 .59153 .68347 .59453 Mtetra
.871 .816 .336 r
.68347 .59453 .68426 .59153 .68499 .58766 .68422 .59102 Mtetra
.951 .837 .403 r
.68422 .59102 .68499 .58766 .68567 .58273 .68492 .58656 Mtetra
.972 .829 .416 r
.68492 .58656 .68567 .58273 .6863 .57677 .68558 .58118 Mtetra
.971 .816 .396 r
.68558 .58118 .6863 .57677 .6869 .56997 .68621 .57504 Mtetra
.946 .796 .34 r
.68621 .57504 .6869 .56997 .68747 .56264 .68682 .56843 Mtetra
.861 .74 .224 r
.68682 .56843 .68747 .56264 .68804 .5553 .68742 .56182 Mtetra
0 0 0 r
.68742 .56182 .68804 .5553 .68864 .54864 .68805 .5558 Mtetra
0 0 .265 r
.68805 .5558 .68864 .54864 .6893 .54339 .68873 .55105 Mtetra
.174 .039 .445 r
.68873 .55105 .6893 .54339 .69005 .5402 .68949 .54814 Mtetra
.399 .223 .523 r
.68949 .54814 .69005 .5402 .6909 .53946 .69035 .54743 Mtetra
.522 .324 .553 r
.69035 .54743 .6909 .53946 .69187 .54122 .69131 .54895 Mtetra
.591 .381 .566 r
.69131 .54895 .69187 .54122 .69293 .54514 .69235 .55242 Mtetra
.632 .415 .57 r
.69235 .55242 .69293 .54514 .69407 .55062 .69346 .55728 Mtetra
.656 .434 .57 r
.69346 .55728 .69407 .55062 .69525 .55693 .69461 .56288 Mtetra
.67 .443 .568 r
.69461 .56288 .69525 .55693 .69643 .56337 .69576 .56859 Mtetra
.675 .445 .564 r
.69576 .56859 .69643 .56337 .6976 .56938 .6969 .57392 Mtetra
.674 .439 .558 r
.6969 .57392 .6976 .56938 .69874 .57459 .69801 .57854 Mtetra
.665 .426 .549 r
.69801 .57854 .69874 .57459 .69983 .57881 .69908 .58226 Mtetra
.646 .402 .536 r
.69908 .58226 .69983 .57881 .70088 .58196 .70011 .58503 Mtetra
.611 .363 .517 r
.70011 .58503 .70088 .58196 .70188 .58406 .7011 .58686 Mtetra
.551 .299 .487 r
.7011 .58686 .70188 .58406 .70284 .58514 .70205 .58777 Mtetra
.439 .188 .434 r
.70205 .58777 .70284 .58514 .70375 .58524 .70296 .58781 Mtetra
.224 0 .33 r
.70296 .58781 .70375 .58524 .70462 .58437 .70382 .58699 Mtetra
0 0 .127 r
.70382 .58699 .70462 .58437 .70544 .58252 .70465 .58529 Mtetra
0 0 0 r
.70465 .58529 .70544 .58252 .70621 .57966 .70544 .58268 Mtetra
.857 .805 .317 r
.70544 .58268 .70621 .57966 .70693 .57574 .70618 .57913 Mtetra
.941 .829 .385 r
.70618 .57913 .70693 .57574 .70761 .57075 .70688 .57462 Mtetra
.964 .823 .397 r
.70688 .57462 .70761 .57075 .70823 .56474 .70753 .5692 Mtetra
.962 .809 .375 r
.70753 .5692 .70823 .56474 .70881 .55789 .70815 .56302 Mtetra
.931 .785 .314 r
.70815 .56302 .70881 .55789 .70936 .55053 .70874 .55639 Mtetra
.832 .719 .19 r
.70874 .55639 .70936 .55053 .70991 .54319 .70933 .54977 Mtetra
0 0 .032 r
.70933 .54977 .70991 .54319 .7105 .53658 .70995 .5438 Mtetra
0 0 .292 r
.70995 .5438 .7105 .53658 .71116 .53141 .71063 .53913 Mtetra
.198 .059 .455 r
.71063 .53913 .71116 .53141 .71191 .52835 .7114 .53634 Mtetra
.41 .231 .526 r
.7114 .53634 .71191 .52835 .71279 .52776 .71228 .53577 Mtetra
.527 .328 .554 r
.71228 .53577 .71279 .52776 .71379 .52968 .71327 .53744 Mtetra
.593 .383 .565 r
.71327 .53744 .71379 .52968 .7149 .53375 .71436 .54104 Mtetra
.633 .415 .569 r
.71436 .54104 .7149 .53375 .71609 .53936 .71551 .54602 Mtetra
.657 .434 .569 r
.71551 .54602 .71609 .53936 .71732 .54577 .71671 .55171 Mtetra
.67 .443 .566 r
.71671 .55171 .71732 .54577 .71856 .55227 .71791 .55748 Mtetra
.676 .444 .562 r
.71791 .55748 .71856 .55227 .71978 .55832 .7191 .56285 Mtetra
.674 .438 .556 r
.7191 .56285 .71978 .55832 .72096 .56355 .72025 .56749 Mtetra
.665 .424 .547 r
.72025 .56749 .72096 .56355 .7221 .56777 .72136 .57122 Mtetra
.645 .4 .534 r
.72136 .57122 .7221 .56777 .72318 .57093 .72242 .57399 Mtetra
.611 .361 .514 r
.72242 .57399 .72318 .57093 .72421 .57302 .72344 .57582 Mtetra
.549 .296 .484 r
.72344 .57582 .72421 .57302 .72519 .57409 .72441 .57673 Mtetra
.437 .185 .432 r
.72441 .57673 .72519 .57409 .72612 .57417 .72534 .57676 Mtetra
.224 0 .331 r
.72534 .57676 .72612 .57417 .727 .57328 .72622 .57592 Mtetra
0 0 .136 r
.72622 .57592 .727 .57328 .72783 .57141 .72706 .57419 Mtetra
0 0 0 r
.72706 .57419 .72783 .57141 .72861 .56851 .72785 .57156 Mtetra
.84 .792 .295 r
.72785 .57156 .72861 .56851 .72933 .56454 .7286 .56797 Mtetra
.929 .821 .364 r
.7286 .56797 .72933 .56454 .72999 .5595 .72929 .56341 Mtetra
.954 .816 .376 r
.72929 .56341 .72999 .5595 .7306 .55343 .72993 .55794 Mtetra
.95 .801 .351 r
.72993 .55794 .7306 .55343 .73116 .54653 .73053 .55172 Mtetra
.912 .772 .285 r
.73053 .55172 .73116 .54653 .73169 .53914 .7311 .54506 Mtetra
.799 .694 .153 r
.7311 .54506 .73169 .53914 .73223 .5318 .73168 .53846 Mtetra
0 0 .072 r
.73168 .53846 .73223 .5318 .7328 .52523 .73229 .53252 Mtetra
0 0 .316 r
.73229 .53252 .7328 .52523 .73346 .52015 .73297 .52794 Mtetra
.22 .077 .464 r
.73297 .52794 .73346 .52015 .73422 .51722 .73375 .52526 Mtetra
.42 .24 .528 r
.73375 .52526 .73422 .51722 .73512 .51679 .73466 .52484 Mtetra
.532 .331 .554 r
.73466 .52484 .73512 .51679 .73616 .51887 .73568 .52666 Mtetra
.596 .384 .564 r
.73568 .52666 .73616 .51887 .73732 .5231 .73682 .53041 Mtetra
.635 .416 .567 r
.73682 .53041 .73732 .5231 .73857 .52884 .73803 .53551 Mtetra
.658 .433 .567 r
.73803 .53551 .73857 .52884 .73986 .53534 .73928 .54129 Mtetra
.671 .442 .565 r
.73928 .54129 .73986 .53534 .74115 .54191 .74053 .54713 Mtetra
.676 .443 .56 r
.74053 .54713 .74115 .54191 .74242 .54801 .74177 .55253 Mtetra
.674 .437 .554 r
.74177 .55253 .74242 .54801 .74366 .55326 .74296 .55719 Mtetra
.665 .423 .544 r
.74296 .55719 .74366 .55326 .74483 .5575 .74411 .56094 Mtetra
.645 .398 .531 r
.74411 .56094 .74483 .5575 .74595 .56065 .74521 .56372 Mtetra
.609 .358 .512 r
.74521 .56372 .74595 .56065 .74701 .56274 .74626 .56554 Mtetra
.548 .293 .482 r
.74626 .56554 .74701 .56274 .74801 .5638 .74725 .56645 Mtetra
.436 .183 .43 r
.74725 .56645 .74801 .5638 .74896 .56387 .7482 .56647 Mtetra
.225 0 .332 r
.7482 .56647 .74896 .56387 .74986 .56296 .7491 .56561 Mtetra
0 0 .145 r
.7491 .56561 .74986 .56296 .7507 .56105 .74995 .56387 Mtetra
0 0 0 r
.74995 .56387 .7507 .56105 .75148 .55811 .75074 .5612 Mtetra
.82 .777 .27 r
.75074 .5612 .75148 .55811 .75219 .5541 .75148 .55757 Mtetra
.915 .81 .34 r
.75148 .55757 .75219 .5541 .75285 .549 .75217 .55297 Mtetra
.942 .807 .352 r
.75217 .55297 .75285 .549 .75344 .54287 .7528 .54745 Mtetra
.935 .79 .325 r
.7528 .54745 .75344 .54287 .75398 .53592 .75338 .54118 Mtetra
.89 .755 .254 r
.75338 .54118 .75398 .53592 .7545 .52849 .75394 .5345 Mtetra
.762 .666 .114 r
.75394 .5345 .7545 .52849 .75502 .52116 .7545 .5279 Mtetra
0 0 .111 r
.7545 .5279 .75502 .52116 .75558 .51463 .75511 .52201 Mtetra
0 0 .339 r
.75511 .52201 .75558 .51463 .75623 .50965 .75579 .5175 Mtetra
.241 .095 .473 r
.75579 .5175 .75623 .50965 .75701 .50684 .75659 .51495 Mtetra
.43 .247 .531 r
.75659 .51495 .75701 .50684 .75794 .50658 .75752 .51467 Mtetra
.536 .335 .554 r
.75752 .51467 .75794 .50658 .75902 .50883 .75858 .51665 Mtetra
.599 .386 .563 r
.75858 .51665 .75902 .50883 .76023 .51321 .75976 .52054 Mtetra
.636 .416 .566 r
.75976 .52054 .76023 .51321 .76153 .51908 .76103 .52576 Mtetra
.659 .433 .566 r
.76103 .52576 .76153 .51908 .76288 .52569 .76233 .53164 Mtetra
.672 .441 .563 r
.76233 .53164 .76288 .52569 .76423 .53233 .76364 .53754 Mtetra
.677 .442 .558 r
.76364 .53754 .76423 .53233 .76556 .53847 .76493 .54299 Mtetra
.674 .435 .552 r
.76493 .54299 .76556 .53847 .76684 .54375 .76617 .54768 Mtetra
.664 .421 .542 r
.76617 .54768 .76684 .54375 .76806 .54799 .76736 .55144 Mtetra
.644 .396 .529 r
.76736 .55144 .76806 .54799 .76922 .55115 .76849 .55423 Mtetra
.608 .356 .509 r
.76849 .55423 .76922 .55115 .77031 .55324 .76957 .55605 Mtetra
.546 .29 .48 r
.76957 .55605 .77031 .55324 .77134 .55429 .77059 .55696 Mtetra
.434 .181 .429 r
.77059 .55696 .77134 .55429 .77231 .55435 .77156 .55697 Mtetra
.226 0 .334 r
.77156 .55697 .77231 .55435 .77322 .55341 .77247 .55609 Mtetra
0 0 .156 r
.77247 .55609 .77322 .55341 .77407 .55147 .77333 .55432 Mtetra
0 0 0 r
.77333 .55432 .77407 .55147 .77485 .54849 .77413 .55162 Mtetra
.798 .759 .243 r
.77413 .55162 .77485 .54849 .77556 .54443 .77487 .54795 Mtetra
.898 .797 .314 r
.77487 .54795 .77556 .54443 .77621 .53926 .77555 .5433 Mtetra
.927 .795 .326 r
.77555 .5433 .77621 .53926 .77678 .53308 .77617 .53772 Mtetra
.918 .778 .296 r
.77617 .53772 .77678 .53308 .77731 .52607 .77674 .53141 Mtetra
.865 .736 .22 r
.77674 .53141 .77731 .52607 .7778 .51861 .77728 .5247 Mtetra
.721 .635 .073 r
.77728 .5247 .7778 .51861 .7783 .51128 .77783 .5181 Mtetra
0 0 .148 r
.77783 .5181 .7783 .51128 .77885 .50479 .77843 .51225 Mtetra
0 0 .36 r
.77843 .51225 .77885 .50479 .7795 .49989 .77911 .50783 Mtetra
.26 .111 .48 r
.77911 .50783 .7795 .49989 .7803 .49722 .77992 .5054 Mtetra
.438 .255 .533 r
.77992 .5054 .7803 .49722 .78126 .49712 .78088 .50527 Mtetra
.541 .338 .554 r
.78088 .50527 .78126 .49712 .78238 .49954 .78199 .50741 Mtetra
.601 .387 .563 r
.78199 .50741 .78238 .49954 .78365 .50408 .78322 .51144 Mtetra
.638 .416 .565 r
.78322 .51144 .78365 .50408 .78501 .51009 .78454 .51679 Mtetra
.66 .433 .564 r
.78454 .51679 .78501 .51009 .78642 .51679 .78591 .52276 Mtetra
.672 .44 .561 r
.78591 .52276 .78642 .51679 .78784 .52351 .78727 .52873 Mtetra
.677 .441 .556 r
.78727 .52873 .78784 .52351 .78922 .52969 .78861 .53423 Mtetra
.674 .434 .549 r
.78861 .53423 .78922 .52969 .79055 .535 .78991 .53894 Mtetra
.664 .419 .54 r
.78991 .53894 .79055 .535 .79182 .53926 .79114 .54271 Mtetra
.643 .394 .526 r
.79114 .54271 .79182 .53926 .79301 .54242 .79231 .54551 Mtetra
.607 .353 .507 r
.79231 .54551 .79301 .54242 .79414 .5445 .79342 .54733 Mtetra
.544 .288 .478 r
.79342 .54733 .79414 .5445 .7952 .54554 .79446 .54823 Mtetra
.432 .179 .428 r
.79446 .54823 .7952 .54554 .79619 .54558 .79545 .54823 Mtetra
.227 0 .336 r
.79545 .54823 .79619 .54558 .79711 .54462 .79638 .54734 Mtetra
0 0 .168 r
.79638 .54734 .79711 .54462 .79797 .54265 .79725 .54554 Mtetra
0 0 0 r
.79725 .54554 .79797 .54265 .79875 .53962 .79806 .5428 Mtetra
.773 .739 .215 r
.79806 .5428 .79875 .53962 .79946 .5355 .79879 .53908 Mtetra
.878 .782 .286 r
.79879 .53908 .79946 .5355 .80009 .53027 .79946 .53437 Mtetra
.909 .782 .298 r
.79946 .53437 .80009 .53027 .80066 .52402 .80007 .52874 Mtetra
.897 .762 .266 r
.80007 .52874 .80066 .52402 .80116 .51695 .80063 .52238 Mtetra
.835 .715 .184 r
.80063 .52238 .80116 .51695 .80163 .50945 .80115 .51564 Mtetra
0 0 0 r
.80115 .51564 .80163 .50945 .80211 .50212 .80169 .50904 Mtetra
0 0 .184 r
.80169 .50904 .80211 .50212 .80265 .49567 .80227 .50323 Mtetra
0 0 .379 r
.80227 .50323 .80265 .49567 .80331 .49086 .80296 .49889 Mtetra
.278 .126 .487 r
.80296 .49889 .80331 .49086 .80412 .48833 .80379 .49659 Mtetra
.447 .261 .535 r
.80379 .49659 .80412 .48833 .80511 .48838 .80478 .4966 Mtetra
.545 .341 .554 r
.80478 .4966 .80511 .48838 .80628 .49097 .80593 .49889 Mtetra
.603 .388 .562 r
.80593 .49889 .80628 .49097 .8076 .49568 .80722 .50308 Mtetra
.639 .416 .564 r
.80722 .50308 .8076 .49568 .80903 .50182 .8086 .50854 Mtetra
.66 .432 .562 r
.8086 .50854 .80903 .50182 .81051 .50862 .81003 .51461 Mtetra
.672 .439 .559 r
.81003 .51461 .81051 .50862 .81199 .51541 .81145 .52065 Mtetra
.677 .439 .554 r
.81145 .52065 .81199 .51541 .81343 .52164 .81285 .52619 Mtetra
.674 .432 .547 r
.81285 .52619 .81343 .52164 .81482 .52697 .81419 .53093 Mtetra
.663 .417 .537 r
.81419 .53093 .81482 .52697 .81613 .53124 .81547 .53471 Mtetra
.642 .391 .524 r
.81547 .53471 .81613 .53124 .81736 .53441 .81668 .53751 Mtetra
.605 .35 .505 r
.81668 .53751 .81736 .53441 .81852 .53648 .81782 .53934 Mtetra
.541 .285 .476 r
.81782 .53934 .81852 .53648 .81961 .53752 .81889 .54023 Mtetra
.429 .176 .427 r
.81889 .54023 .81961 .53752 .82062 .53753 .8199 .54021 Mtetra
.228 0 .338 r
.8199 .54021 .82062 .53753 .82156 .53655 .82085 .5393 Mtetra
0 0 .18 r
.82085 .5393 .82156 .53655 .82242 .53453 .82173 .53747 Mtetra
0 0 0 r
.82173 .53747 .82242 .53453 .82321 .53145 .82254 .53469 Mtetra
.746 .717 .185 r
.82254 .53469 .82321 .53145 .82391 .52727 .82327 .53091 Mtetra
.856 .765 .257 r
.82327 .53091 .82391 .52727 .82454 .52197 .82394 .52615 Mtetra
.888 .766 .268 r
.82394 .52615 .82454 .52197 .82508 .51565 .82453 .52046 Mtetra
.874 .744 .233 r
.82453 .52046 .82508 .51565 .82556 .50851 .82507 .51404 Mtetra
.803 .69 .147 r
.82507 .51404 .82556 .50851 .82601 .50097 .82558 .50726 Mtetra
0 0 .008 r
.82558 .50726 .82601 .50097 .82648 .49363 .8261 .50065 Mtetra
0 0 .217 r
.8261 .50065 .82648 .49363 .82701 .48722 .82668 .49488 Mtetra
.032 0 .395 r
.82668 .49488 .82701 .48722 .82766 .4825 .82737 .49063 Mtetra
.295 .14 .493 r
.82737 .49063 .82766 .4825 .82849 .4801 .82822 .48844 Mtetra
.454 .267 .537 r
.82822 .48844 .82849 .4801 .82952 .48031 .82924 .48861 Mtetra
.548 .343 .554 r
.82924 .48861 .82952 .48031 .83074 .48307 .83044 .49105 Mtetra
.605 .388 .561 r
.83044 .49105 .83074 .48307 .83212 .48794 .83178 .49538 Mtetra
.64 .416 .562 r
.83178 .49538 .83212 .48794 .83362 .49421 .83323 .50097 Mtetra
.661 .431 .561 r
.83323 .50097 .83362 .49421 .83516 .50112 .83472 .50713 Mtetra
.673 .438 .557 r
.83472 .50713 .83516 .50112 .83671 .50797 .83621 .51323 Mtetra
.677 .438 .552 r
.83621 .51323 .83671 .50797 .83822 .51425 .83766 .51882 Mtetra
.673 .43 .545 r
.83766 .51882 .83822 .51425 .83966 .5196 .83905 .52358 Mtetra
.662 .415 .535 r
.83905 .52358 .83966 .5196 .84102 .52389 .84038 .52738 Mtetra
.64 .389 .522 r
.84038 .52738 .84102 .52389 .84229 .52705 .84162 .53018 Mtetra
.603 .347 .503 r
.84162 .53018 .84229 .52705 .84348 .52912 .8428 .53201 Mtetra
.539 .281 .474 r
.8428 .53201 .84348 .52912 .8446 .53014 .8439 .53289 Mtetra
.427 .174 .426 r
.8439 .53289 .8446 .53014 .84563 .53013 .84493 .53285 Mtetra
.229 0 .341 r
.84493 .53285 .84563 .53013 .84659 .52911 .84589 .53191 Mtetra
0 0 .192 r
.84589 .53191 .84659 .52911 .84746 .52706 .84678 .53004 Mtetra
0 0 0 r
.84678 .53004 .84746 .52706 .84825 .52392 .8476 .52721 Mtetra
.717 .693 .155 r
.8476 .52721 .84825 .52392 .84895 .51967 .84833 .52338 Mtetra
.832 .746 .226 r
.84833 .52338 .84895 .51967 .84956 .5143 .84899 .51855 Mtetra
.865 .749 .236 r
.84899 .51855 .84956 .5143 .85008 .50789 .84957 .51279 Mtetra
.847 .724 .199 r
.84957 .51279 .85008 .50789 .85054 .50069 .85009 .50632 Mtetra
.767 .662 .108 r
.85009 .50632 .85054 .50069 .85097 .4931 .85058 .49949 Mtetra
0 0 .048 r
.85058 .49949 .85097 .4931 .85141 .48574 .85108 .49288 Mtetra
0 0 .248 r
.85108 .49288 .85141 .48574 .85193 .47936 .85166 .48714 Mtetra
.063 0 .41 r
.85166 .48714 .85193 .47936 .85259 .47473 .85236 .48296 Mtetra
.31 .152 .499 r
.85236 .48296 .85259 .47473 .85344 .47246 .85323 .4809 Mtetra
.461 .273 .538 r
.85323 .4809 .85344 .47246 .85451 .47284 .85429 .48121 Mtetra
.552 .345 .554 r
.85429 .48121 .85451 .47284 .85578 .47577 .85554 .48381 Mtetra
.607 .389 .56 r
.85554 .48381 .85578 .47577 .85723 .48079 .85694 .48828 Mtetra
.641 .415 .561 r
.85694 .48828 .85723 .48079 .85879 .48719 .85845 .49399 Mtetra
.661 .43 .559 r
.85845 .49399 .85879 .48719 .86041 .4942 .86001 .50024 Mtetra
.673 .437 .555 r
.86001 .50024 .86041 .4942 .86203 .50113 .86156 .50641 Mtetra
.676 .436 .55 r
.86156 .50641 .86203 .50113 .8636 .50744 .86307 .51204 Mtetra
.673 .428 .543 r
.86307 .51204 .8636 .50744 .8651 .51282 .86452 .51682 Mtetra
.661 .412 .533 r
.86452 .51682 .8651 .51282 .86651 .51711 .86589 .52063 Mtetra
.639 .386 .519 r
.86589 .52063 .86651 .51711 .86782 .52028 .86718 .52344 Mtetra
.6 .344 .5 r
.86718 .52344 .86782 .52028 .86905 .52234 .86839 .52525 Mtetra
.535 .278 .472 r
.86839 .52525 .86905 .52234 .87019 .52334 .86952 .52612 Mtetra
.423 .171 .425 r
.86952 .52612 .87019 .52334 .87125 .5233 .87057 .52606 Mtetra
.229 0 .343 r
.87057 .52606 .87125 .5233 .87222 .52225 .87155 .52509 Mtetra
0 0 .203 r
.87155 .52509 .87222 .52225 .8731 .52014 .87245 .52318 Mtetra
0 0 .02 r
.87245 .52318 .8731 .52014 .87389 .51694 .87327 .5203 Mtetra
0 0 0 r
.87327 .5203 .87389 .51694 .87459 .51261 .874 .5164 Mtetra
.805 .724 .194 r
.874 .5164 .87459 .51261 .87518 .50716 .87465 .5115 Mtetra
.839 .728 .203 r
.87465 .5115 .87518 .50716 .87569 .50067 .87521 .50566 Mtetra
.817 .701 .163 r
.87521 .50566 .87569 .50067 .87613 .49339 .87571 .49912 Mtetra
.729 .633 .07 r
.87571 .49912 .87613 .49339 .87653 .48574 .87618 .49225 Mtetra
0 0 .087 r
.87618 .49225 .87653 .48574 .87695 .47837 .87667 .48562 Mtetra
0 0 .275 r
.87667 .48562 .87695 .47837 .87746 .47202 .87724 .47991 Mtetra
.091 0 .424 r
.87724 .47991 .87746 .47202 .87812 .46748 .87795 .47582 Mtetra
.324 .164 .504 r
.87795 .47582 .87812 .46748 .879 .46533 .87884 .47387 Mtetra
.468 .278 .539 r
.87884 .47387 .879 .46533 .8801 .46587 .87994 .47432 Mtetra
.555 .347 .554 r
.87994 .47432 .8801 .46587 .88143 .46897 .88124 .47708 Mtetra
.608 .389 .559 r
.88124 .47708 .88143 .46897 .88295 .47414 .88271 .48169 Mtetra
.641 .415 .559 r
.88271 .48169 .88295 .47414 .88459 .48068 .88429 .48752 Mtetra
.662 .429 .557 r
.88429 .48752 .88459 .48068 .88628 .48779 .88591 .49386 Mtetra
.673 .435 .553 r
.88591 .49386 .88628 .48779 .88797 .49478 .88754 .5001 Mtetra
.676 .434 .548 r
.88754 .5001 .88797 .49478 .88961 .50114 .88911 .50576 Mtetra
.672 .426 .54 r
.88911 .50576 .88961 .50114 .89116 .50654 .89061 .51057 Mtetra
.66 .41 .53 r
.89061 .51057 .89116 .50654 .89262 .51084 .89203 .51439 Mtetra
.637 .383 .517 r
.89203 .51439 .89262 .51084 .89399 .514 .89336 .51719 Mtetra
.598 .34 .498 r
.89336 .51719 .89399 .514 .89525 .51604 .89461 .51899 Mtetra
.532 .274 .47 r
.89461 .51899 .89525 .51604 .89642 .51702 .89577 .51984 Mtetra
.42 .168 .424 r
.89577 .51984 .89642 .51702 .8975 .51695 .89684 .51976 Mtetra
.228 0 .345 r
.89684 .51976 .8975 .51695 .89849 .51585 .89784 .51875 Mtetra
0 0 .213 r
.89784 .51875 .89849 .51585 .89938 .51369 .89875 .51679 Mtetra
0 0 .043 r
.89875 .51679 .89938 .51369 .90017 .51043 .89957 .51385 Mtetra
0 0 0 r
.89957 .51385 .90017 .51043 .90085 .50602 .9003 .50989 Mtetra
.777 .702 .162 r
.9003 .50989 .90085 .50602 .90144 .50047 .90093 .5049 Mtetra
.812 .706 .17 r
.90093 .5049 .90144 .50047 .90192 .49389 .90148 .49899 Mtetra
.786 .676 .127 r
.90148 .49899 .90192 .49389 .90233 .48653 .90196 .49237 Mtetra
0 0 0 r
.90196 .49237 .90233 .48653 .90271 .47882 .90241 .48545 Mtetra
0 0 .123 r
.90241 .48545 .90271 .47882 .90311 .47143 .90289 .4788 Mtetra
0 0 .301 r
.90289 .4788 .90311 .47143 .90361 .46511 .90345 .47312 Mtetra
.117 .004 .436 r
.90345 .47312 .90361 .46511 .90428 .46065 .90416 .4691 Mtetra
.336 .174 .508 r
.90416 .4691 .90428 .46065 .90518 .45863 .90508 .46727 Mtetra
.473 .282 .54 r
.90508 .46727 .90518 .45863 .90633 .45933 .90622 .46787 Mtetra
.557 .349 .553 r
.90622 .46787 .90633 .45933 .90772 .46259 .90758 .47077 Mtetra
.61 .39 .558 r
.90758 .47077 .90772 .46259 .90931 .46793 .90912 .47553 Mtetra
.642 .414 .558 r
.90912 .47553 .90931 .46793 .91102 .47459 .91077 .48148 Mtetra
.662 .428 .555 r
.91077 .48148 .91102 .47459 .9128 .4818 .91247 .48791 Mtetra
.672 .434 .551 r
.91247 .48791 .9128 .4818 .91456 .48886 .91416 .4942 Mtetra
.675 .432 .546 r
.91416 .4942 .91456 .48886 .91626 .49525 .9158 .4999 Mtetra
.671 .424 .538 r
.9158 .4999 .91626 .49525 .91788 .50067 .91736 .50473 Mtetra
.658 .407 .528 r
.91736 .50473 .91788 .50067 .91939 .50497 .91883 .50855 Mtetra
.635 .379 .514 r
.91883 .50855 .91939 .50497 .9208 .50813 .9202 .51135 Mtetra
.595 .336 .495 r
.9202 .51135 .9208 .50813 .9221 .51015 .92148 .51314 Mtetra
.528 .27 .468 r
.92148 .51314 .9221 .51015 .9233 .5111 .92267 .51397 Mtetra
.415 .165 .423 r
.92267 .51397 .9233 .5111 .9244 .511 .92377 .51385 Mtetra
.226 0 .347 r
.92377 .51385 .9244 .511 .92541 .50986 .92478 .51281 Mtetra
0 0 .223 r
.92478 .51281 .92541 .50986 .9263 .50764 .9257 .5108 Mtetra
0 0 .065 r
.9257 .5108 .9263 .50764 .9271 .5043 .92653 .50779 Mtetra
0 0 0 r
.92653 .50779 .9271 .5043 .92777 .4998 .92725 .50375 Mtetra
.748 .678 .129 r
.92725 .50375 .92777 .4998 .92834 .49416 .92787 .49868 Mtetra
.782 .682 .136 r
.92787 .49868 .92834 .49416 .9288 .48748 .9284 .49268 Mtetra
.752 .649 .091 r
.9284 .49268 .9288 .48748 .92918 .48002 .92886 .48598 Mtetra
0 0 .007 r
.92886 .48598 .92918 .48002 .92953 .47226 .92929 .47901 Mtetra
0 0 .158 r
.92929 .47901 .92953 .47226 .92991 .46484 .92975 .47234 Mtetra
0 0 .324 r
.92975 .47234 .92991 .46484 .9304 .45855 .93031 .46668 Mtetra
.141 .023 .446 r
.93031 .46668 .9304 .45855 .93108 .45417 .93103 .46273 Mtetra
.348 .184 .512 r
.93103 .46273 .93108 .45417 .93201 .45228 .93197 .46102 Mtetra
.479 .287 .541 r
.93197 .46102 .93201 .45228 .9332 .45313 .93316 .46176 Mtetra
.56 .35 .553 r
.93316 .46176 .9332 .45313 .93466 .45656 .93458 .46482 Mtetra
.611 .39 .556 r
.93458 .46482 .93466 .45656 .93632 .46205 .93619 .46971 Mtetra
.643 .414 .556 r
.93619 .46971 .93632 .46205 .93812 .46884 .93791 .47578 Mtetra
.662 .427 .553 r
.93791 .47578 .93812 .46884 .93997 .47615 .93969 .4823 Mtetra
.672 .432 .549 r
.93969 .4823 .93997 .47615 .94181 .48327 .94145 .48865 Mtetra
.675 .43 .543 r
.94145 .48865 .94181 .48327 .94359 .4897 .94316 .49438 Mtetra
.67 .421 .535 r
.94316 .49438 .94359 .4897 .94527 .49514 .94478 .49923 Mtetra
.657 .404 .525 r
.94478 .49923 .94527 .49514 .94684 .49944 .9463 .50305 Mtetra
.632 .376 .512 r
.9463 .50305 .94684 .49944 .94829 .50258 .94771 .50584 Mtetra
.591 .332 .493 r
.94771 .50584 .94829 .50258 .94963 .50459 .94903 .50761 Mtetra
.524 .265 .465 r
.94903 .50761 .94963 .50459 .95086 .50551 .95025 .50841 Mtetra
.411 .161 .422 r
.95025 .50841 .95086 .50551 .95199 .50537 .95137 .50827 Mtetra
.224 0 .349 r
.95137 .50827 .95199 .50537 .953 .50417 .9524 .50717 Mtetra
0 0 .232 r
.9524 .50717 .953 .50417 .95391 .50188 .95333 .50511 Mtetra
0 0 .085 r
.95333 .50511 .95391 .50188 .9547 .49846 .95416 .50203 Mtetra
0 0 0 r
.95416 .50203 .9547 .49846 .95536 .49388 .95488 .49791 Mtetra
.718 .653 .097 r
.95488 .49791 .95536 .49388 .95591 .48813 .95549 .49275 Mtetra
.75 .657 .101 r
.95549 .49275 .95591 .48813 .95635 .48135 .956 .48665 Mtetra
.716 .621 .055 r
.956 .48665 .95635 .48135 .9567 .4738 .95643 .47987 Mtetra
0 0 .044 r
.95643 .47987 .9567 .4738 .95702 .46596 .95684 .47284 Mtetra
0 0 .19 r
.95684 .47284 .95702 .46596 .95738 .45852 .95728 .46615 Mtetra
0 0 .345 r
.95728 .46615 .95738 .45852 .95787 .45225 .95784 .46051 Mtetra
.163 .041 .456 r
.95784 .46051 .95787 .45225 .95855 .44795 .95857 .45664 Mtetra
.358 .192 .515 r
.95857 .45664 .95855 .44795 .9595 .44619 .95954 .45504 Mtetra
.484 .29 .542 r
.95954 .45504 .9595 .44619 .96075 .4472 .96078 .45592 Mtetra
.562 .351 .552 r
.96078 .45592 .96075 .4472 .96227 .4508 .96226 .45913 Mtetra
.612 .39 .555 r
.96226 .45913 .96227 .4508 .96402 .45644 .96394 .46416 Mtetra
.643 .413 .554 r
.96394 .46416 .96402 .45644 .9659 .46336 .96574 .47034 Mtetra
.662 .426 .551 r
.96574 .47034 .9659 .46336 .96784 .47076 .9676 .47695 Mtetra
.672 .43 .547 r
.9676 .47695 .96784 .47076 .96976 .47794 .96944 .48336 Mtetra
.674 .428 .541 r
.96944 .48336 .96976 .47794 .97161 .48441 .97121 .48913 Mtetra
.669 .418 .533 r
.97121 .48913 .97161 .48441 .97335 .48986 .97289 .49398 Mtetra
.655 .401 .523 r
.97289 .49398 .97335 .48986 .97498 .49416 .97446 .49781 Mtetra
.63 .372 .509 r
.97446 .49781 .97498 .49416 .97648 .49729 .97593 .50058 Mtetra
.588 .328 .49 r
.97593 .50058 .97648 .49729 .97786 .49928 .97728 .50234 Mtetra
.519 .261 .463 r
.97728 .50234 .97786 .49928 .97912 .50016 .97853 .50311 Mtetra
.406 .157 .421 r
.97853 .50311 .97912 .50016 .98027 .49998 .97968 .50293 Mtetra
.222 0 .351 r
.97968 .50293 .98027 .49998 .9813 .49872 .98073 .50178 Mtetra
0 0 .241 r
.98073 .50178 .9813 .49872 .98221 .49637 .98167 .49966 Mtetra
0 0 .105 r
.98167 .49966 .98221 .49637 .983 .49286 .98249 .4965 Mtetra
0 0 0 r
.98249 .4965 .983 .49286 .98365 .48818 .9832 .49229 Mtetra
.9832 .49229 .98365 .48818 .98418 .48232 .9838 .48703 Mtetra
.718 .631 .067 r
.9838 .48703 .98418 .48232 .98459 .47543 .98429 .48084 Mtetra
0 0 0 r
.98429 .48084 .98459 .47543 .98491 .46778 .9847 .47398 Mtetra
0 0 .08 r
.9847 .47398 .98491 .46778 .98521 .45987 .98509 .46688 Mtetra
0 0 .22 r
.98509 .46688 .98521 .45987 .98554 .45239 .98551 .46016 Mtetra
0 0 .363 r
.98551 .46016 .98554 .45239 .98602 .44616 .98606 .45455 Mtetra
.183 .058 .465 r
.98606 .45455 .98602 .44616 .98671 .44193 .9868 .45074 Mtetra
.368 .2 .518 r
.9868 .45074 .98671 .44193 .9877 .4403 .98781 .44926 Mtetra
.47 .282 .543 r
.52748 .66522 .52833 .65766 .5291 .65816 .52825 .6656 Mtetra
.558 .358 .565 r
.52825 .6656 .5291 .65816 .52988 .66068 .52904 .66776 Mtetra
.608 .4 .574 r
.52904 .66776 .52988 .66068 .53069 .66476 .52983 .67132 Mtetra
.637 .425 .578 r
.52983 .67132 .53069 .66476 .5315 .6698 .53064 .67572 Mtetra
.654 .437 .577 r
.53064 .67572 .5315 .6698 .53232 .67518 .53145 .68042 Mtetra
.662 .442 .575 r
.53145 .68042 .53232 .67518 .53313 .68036 .53226 .68495 Mtetra
.663 .438 .569 r
.53226 .68495 .53313 .68036 .53395 .68496 .53307 .68895 Mtetra
.656 .427 .561 r
.53307 .68895 .53395 .68496 .53476 .68875 .53388 .69225 Mtetra
.639 .406 .549 r
.53388 .69225 .53476 .68875 .53556 .69164 .53468 .69474 Mtetra
.609 .371 .531 r
.53468 .69474 .53556 .69164 .53635 .69362 .53547 .69642 Mtetra
.557 .313 .502 r
.53547 .69642 .53635 .69362 .53714 .6947 .53625 .69732 Mtetra
.46 .213 .452 r
.53625 .69732 .53714 .6947 .53792 .69494 .53703 .69746 Mtetra
.271 .03 .352 r
.53703 .69746 .53792 .69494 .53869 .69434 .53781 .69686 Mtetra
0 0 .148 r
.53781 .69686 .53869 .69434 .53946 .69291 .53857 .69553 Mtetra
0 0 0 r
.53857 .69553 .53946 .69291 .54021 .69062 .53933 .69344 Mtetra
.871 .843 .38 r
.53933 .69344 .54021 .69062 .54096 .68745 .54008 .69056 Mtetra
.962 .866 .463 r
.54008 .69056 .54096 .68745 .54169 .68335 .54082 .68687 Mtetra
.986 .855 .483 r
.54082 .68687 .54169 .68335 .54242 .67835 .54155 .68237 Mtetra
.99 .844 .474 r
.54155 .68237 .54242 .67835 .54313 .67254 .54227 .67716 Mtetra
.981 .834 .438 r
.54227 .67716 .54313 .67254 .54384 .66617 .54299 .67145 Mtetra
.942 .811 .358 r
.54299 .67145 .54384 .66617 .54454 .65961 .5437 .66557 Mtetra
.802 .72 .188 r
.5437 .66557 .54454 .65961 .54525 .65342 .54441 .66001 Mtetra
0 0 .103 r
.54441 .66001 .54525 .65342 .54596 .64822 .54514 .65534 Mtetra
.02 0 .367 r
.54514 .65534 .54596 .64822 .5467 .64462 .54588 .65208 Mtetra
.319 .154 .493 r
.54588 .65208 .5467 .64462 .54745 .64305 .54664 .65063 Mtetra
.476 .287 .544 r
.54664 .65063 .54745 .64305 .54824 .64367 .54742 .65111 Mtetra
.561 .359 .565 r
.54742 .65111 .54824 .64367 .54905 .64629 .54823 .65336 Mtetra
.61 .401 .573 r
.54823 .65336 .54905 .64629 .54989 .65045 .54906 .65699 Mtetra
.638 .424 .576 r
.54906 .65699 .54989 .65045 .55073 .65556 .5499 .66145 Mtetra
.655 .437 .576 r
.5499 .66145 .55073 .65556 .55159 .66097 .55074 .66618 Mtetra
.662 .441 .573 r
.55074 .66618 .55159 .66097 .55244 .66615 .55159 .67071 Mtetra
.662 .437 .568 r
.55159 .67071 .55244 .66615 .55329 .67074 .55243 .67471 Mtetra
.655 .425 .559 r
.55243 .67471 .55329 .67074 .55413 .67451 .55326 .67798 Mtetra
.638 .404 .547 r
.55326 .67798 .55413 .67451 .55496 .67737 .55408 .68045 Mtetra
.608 .368 .528 r
.55408 .68045 .55496 .67737 .55577 .67932 .5549 .6821 Mtetra
.553 .308 .498 r
.5549 .6821 .55577 .67932 .55658 .68037 .5557 .68297 Mtetra
.454 .206 .447 r
.5557 .68297 .55658 .68037 .55737 .68057 .55649 .68308 Mtetra
.261 .019 .346 r
.55649 .68308 .55737 .68057 .55816 .67993 .55728 .68245 Mtetra
0 0 .14 r
.55728 .68245 .55816 .67993 .55893 .67846 .55805 .68108 Mtetra
0 0 0 r
.55805 .68108 .55893 .67846 .55969 .67613 .55881 .67895 Mtetra
.868 .839 .372 r
.55881 .67895 .55969 .67613 .56043 .6729 .55957 .67602 Mtetra
.959 .863 .453 r
.55957 .67602 .56043 .6729 .56116 .66874 .5603 .67227 Mtetra
.983 .853 .473 r
.5603 .67227 .56116 .66874 .56188 .66368 .56103 .66773 Mtetra
.987 .841 .462 r
.56103 .66773 .56188 .66368 .56258 .65782 .56174 .66247 Mtetra
.976 .83 .422 r
.56174 .66247 .56258 .65782 .56328 .6514 .56245 .65672 Mtetra
.929 .802 .336 r
.56245 .65672 .56328 .6514 .56397 .64483 .56315 .65082 Mtetra
.772 .698 .156 r
.56315 .65082 .56397 .64483 .56466 .63865 .56386 .64528 Mtetra
0 0 .135 r
.56386 .64528 .56466 .63865 .56537 .6335 .56458 .64065 Mtetra
.049 0 .381 r
.56458 .64065 .56537 .6335 .5661 .62998 .56532 .63747 Mtetra
.331 .164 .498 r
.56532 .63747 .5661 .62998 .56687 .62853 .56609 .63611 Mtetra
.482 .291 .545 r
.56609 .63611 .56687 .62853 .56768 .62926 .56689 .63669 Mtetra
.564 .361 .565 r
.56689 .63669 .56768 .62926 .56852 .63199 .56773 .63905 Mtetra
.611 .401 .573 r
.56773 .63905 .56852 .63199 .56938 .63624 .56858 .64276 Mtetra
.639 .424 .575 r
.56858 .64276 .56938 .63624 .57027 .6414 .56946 .64727 Mtetra
.655 .436 .575 r
.56946 .64727 .57027 .6414 .57116 .64685 .57034 .65203 Mtetra
.663 .44 .571 r
.57034 .65203 .57116 .64685 .57205 .65204 .57122 .65656 Mtetra
.662 .436 .566 r
.57122 .65656 .57205 .65204 .57293 .65662 .57209 .66056 Mtetra
.655 .424 .557 r
.57209 .66056 .57293 .65662 .5738 .66037 .57295 .66381 Mtetra
.637 .402 .544 r
.57295 .66381 .5738 .66037 .57466 .66321 .5738 .66626 Mtetra
.606 .365 .525 r
.5738 .66626 .57466 .66321 .5755 .66512 .57463 .66789 Mtetra
.55 .304 .495 r
.57463 .66789 .5755 .66512 .57632 .66615 .57545 .66873 Mtetra
.448 .199 .442 r
.57545 .66873 .57632 .66615 .57713 .66631 .57626 .66881 Mtetra
.251 .01 .34 r
.57626 .66881 .57713 .66631 .57793 .66564 .57706 .66815 Mtetra
0 0 .134 r
.57706 .66815 .57793 .66564 .5787 .66413 .57784 .66675 Mtetra
0 0 0 r
.57784 .66675 .5787 .66413 .57947 .66175 .57861 .66457 Mtetra
.864 .834 .364 r
.57861 .66457 .57947 .66175 .58021 .65846 .57936 .6616 Mtetra
.955 .859 .443 r
.57936 .6616 .58021 .65846 .58094 .65425 .58009 .6578 Mtetra
.98 .85 .461 r
.58009 .6578 .58094 .65425 .58165 .64913 .58081 .65321 Mtetra
.983 .838 .448 r
.58081 .65321 .58165 .64913 .58234 .64322 .58152 .6479 Mtetra
.969 .825 .405 r
.58152 .6479 .58234 .64322 .58302 .63676 .58221 .64212 Mtetra
.914 .791 .312 r
.58221 .64212 .58302 .63676 .58369 .63017 .58291 .63621 Mtetra
.739 .673 .123 r
.58291 .63621 .58369 .63017 .58438 .62401 .5836 .63068 Mtetra
0 0 .165 r
.5836 .63068 .58438 .62401 .58508 .61892 .58432 .6261 Mtetra
.076 0 .395 r
.58432 .6261 .58508 .61892 .58581 .61549 .58506 .623 Mtetra
.344 .175 .502 r
.58506 .623 .58581 .61549 .58659 .61414 .58584 .62174 Mtetra
.487 .296 .546 r
.58584 .62174 .58659 .61414 .58742 .615 .58667 .62243 Mtetra
.566 .363 .564 r
.58667 .62243 .58742 .615 .58829 .61784 .58753 .62489 Mtetra
.613 .402 .572 r
.58753 .62489 .58829 .61784 .58919 .62218 .58842 .62868 Mtetra
.64 .424 .574 r
.58842 .62868 .58919 .62218 .59011 .62741 .58933 .63325 Mtetra
.656 .436 .573 r
.58933 .63325 .59011 .62741 .59104 .63289 .59025 .63804 Mtetra
.663 .439 .57 r
.59025 .63804 .59104 .63289 .59197 .63809 .59116 .64259 Mtetra
.662 .434 .564 r
.59116 .64259 .59197 .63809 .59289 .64267 .59206 .64657 Mtetra
.654 .422 .555 r
.59206 .64657 .59289 .64267 .59379 .6464 .59295 .64982 Mtetra
.637 .399 .542 r
.59295 .64982 .59379 .6464 .59467 .64922 .59383 .65225 Mtetra
.604 .362 .522 r
.59383 .65225 .59467 .64922 .59554 .65111 .59468 .65385 Mtetra
.547 .299 .491 r
.59468 .65385 .59554 .65111 .59638 .65211 .59552 .65467 Mtetra
.443 .193 .438 r
.59552 .65467 .59638 .65211 .5972 .65224 .59635 .65473 Mtetra
.243 .001 .334 r
.59635 .65473 .5972 .65224 .59801 .65154 .59715 .65404 Mtetra
0 0 .129 r
.59715 .65404 .59801 .65154 .5988 .64998 .59794 .6526 Mtetra
0 0 0 r
.59794 .6526 .5988 .64998 .59956 .64756 .59872 .65039 Mtetra
.858 .829 .355 r
.59872 .65039 .59956 .64756 .60031 .64423 .59947 .64737 Mtetra
.95 .855 .431 r
.59947 .64737 .60031 .64423 .60103 .63996 .6002 .64353 Mtetra
.976 .847 .449 r
.6002 .64353 .60103 .63996 .60173 .63478 .60092 .63888 Mtetra
.978 .835 .434 r
.60092 .63888 .60173 .63478 .60241 .62882 .60161 .63354 Mtetra
.96 .819 .387 r
.60161 .63354 .60241 .62882 .60308 .62233 .6023 .62772 Mtetra
.896 .778 .286 r
.6023 .62772 .60308 .62233 .60374 .61573 .60298 .62181 Mtetra
.703 .645 .088 r
.60298 .62181 .60374 .61573 .60441 .60958 .60367 .6163 Mtetra
0 0 .194 r
.60367 .6163 .60441 .60958 .6051 .60455 .60438 .61177 Mtetra
.102 0 .408 r
.60438 .61177 .6051 .60455 .60584 .60122 .60512 .60875 Mtetra
.355 .184 .507 r
.60512 .60875 .60584 .60122 .60663 .59999 .60592 .6076 Mtetra
.493 .3 .547 r
.60592 .6076 .60663 .59999 .60748 .60097 .60676 .6084 Mtetra
.569 .365 .564 r
.60676 .6084 .60748 .60097 .60838 .60392 .60765 .61096 Mtetra
.614 .402 .571 r
.60765 .61096 .60838 .60392 .60932 .60836 .60858 .61484 Mtetra
.641 .424 .573 r
.60858 .61484 .60932 .60836 .61029 .61365 .60953 .61946 Mtetra
.656 .435 .571 r
.60953 .61946 .61029 .61365 .61126 .61917 .61048 .62429 Mtetra
.663 .438 .568 r
.61048 .62429 .61126 .61917 .61223 .62439 .61143 .62885 Mtetra
.663 .433 .562 r
.61143 .62885 .61223 .62439 .61318 .62896 .61237 .63284 Mtetra
.654 .42 .553 r
.61237 .63284 .61318 .62896 .61411 .63269 .61329 .63608 Mtetra
.636 .397 .539 r
.61329 .63608 .61411 .63269 .61502 .63549 .61419 .63849 Mtetra
.603 .359 .52 r
.61419 .63849 .61502 .63549 .61591 .63736 .61507 .64008 Mtetra
.545 .295 .488 r
.61507 .64008 .61591 .63736 .61677 .63833 .61592 .64088 Mtetra
.439 .187 .434 r
.61592 .64088 .61677 .63833 .61761 .63844 .61676 .64091 Mtetra
.236 0 .33 r
.61676 .64091 .61761 .63844 .61843 .6377 .61758 .6402 Mtetra
0 0 .126 r
.61758 .6402 .61843 .6377 .61922 .63612 .61838 .63873 Mtetra
0 0 0 r
.61838 .63873 .61922 .63612 .61999 .63365 .61916 .63649 Mtetra
.851 .822 .343 r
.61916 .63649 .61999 .63365 .62074 .63027 .61991 .63343 Mtetra
.944 .85 .418 r
.61991 .63343 .62074 .63027 .62146 .62595 .62064 .62954 Mtetra
.97 .843 .435 r
.62064 .62954 .62146 .62595 .62215 .62072 .62135 .62485 Mtetra
.972 .831 .418 r
.62135 .62485 .62215 .62072 .62281 .61471 .62204 .61946 Mtetra
.95 .812 .366 r
.62204 .61946 .62281 .61471 .62347 .60818 .62271 .61362 Mtetra
.875 .763 .258 r
.62271 .61362 .62347 .60818 .62411 .60157 .62338 .60769 Mtetra
0 0 0 r
.62338 .60769 .62411 .60157 .62477 .59546 .62406 .60221 Mtetra
0 0 .222 r
.62406 .60221 .62477 .59546 .62546 .59048 .62477 .59774 Mtetra
.127 0 .42 r
.62477 .59774 .62546 .59048 .62621 .58725 .62552 .59481 Mtetra
.367 .194 .51 r
.62552 .59481 .62621 .58725 .62701 .58614 .62633 .59377 Mtetra
.498 .304 .548 r
.62633 .59377 .62701 .58614 .62788 .58725 .6272 .59469 Mtetra
.572 .367 .564 r
.6272 .59469 .62788 .58725 .62882 .59033 .62812 .59736 Mtetra
.616 .403 .57 r
.62812 .59736 .62882 .59033 .62979 .59487 .62908 .60132 Mtetra
.642 .424 .571 r
.62908 .60132 .62979 .59487 .6308 .60023 .63007 .60601 Mtetra
.657 .434 .57 r
.63007 .60601 .6308 .60023 .63182 .60579 .63106 .61088 Mtetra
.664 .437 .566 r
.63106 .61088 .63182 .60579 .63282 .61103 .63205 .61546 Mtetra
.663 .432 .56 r
.63205 .61546 .63282 .61103 .63381 .6156 .63302 .61945 Mtetra
.654 .419 .551 r
.63302 .61945 .63381 .6156 .63478 .61932 .63397 .62268 Mtetra
.635 .395 .537 r
.63397 .62268 .63478 .61932 .63572 .6221 .6349 .62509 Mtetra
.602 .356 .517 r
.6349 .62509 .63572 .6221 .63663 .62396 .6358 .62667 Mtetra
.542 .292 .485 r
.6358 .62667 .63663 .62396 .63751 .62491 .63668 .62745 Mtetra
.435 .182 .43 r
.63668 .62745 .63751 .62491 .63837 .625 .63753 .62746 Mtetra
.231 0 .326 r
.63753 .62746 .63837 .625 .6392 .62423 .63836 .62673 Mtetra
0 0 .126 r
.63836 .62673 .6392 .62423 .64 .62261 .63917 .62523 Mtetra
0 0 0 r
.63917 .62523 .64 .62261 .64078 .62011 .63995 .62295 Mtetra
.842 .814 .33 r
.63995 .62295 .64078 .62011 .64152 .61668 .64071 .61986 Mtetra
.937 .844 .404 r
.64071 .61986 .64152 .61668 .64223 .61231 .64144 .61593 Mtetra
.964 .838 .419 r
.64144 .61593 .64223 .61231 .64291 .60703 .64214 .61119 Mtetra
.964 .825 .4 r
.64214 .61119 .64291 .60703 .64357 .60098 .64282 .60577 Mtetra
.938 .803 .344 r
.64282 .60577 .64357 .60098 .6442 .59442 .64348 .5999 Mtetra
.852 .745 .229 r
.64348 .5999 .6442 .59442 .64484 .5878 .64414 .59397 Mtetra
0 0 0 r
.64414 .59397 .64484 .5878 .64549 .58172 .64481 .58852 Mtetra
0 0 .249 r
.64481 .58852 .64549 .58172 .64617 .57682 .64551 .58411 Mtetra
.151 .017 .431 r
.64551 .58411 .64617 .57682 .64692 .57368 .64627 .58127 Mtetra
.378 .203 .514 r
.64627 .58127 .64692 .57368 .64774 .5727 .6471 .58035 Mtetra
.503 .308 .549 r
.6471 .58035 .64774 .5727 .64864 .57395 .64799 .58139 Mtetra
.575 .368 .563 r
.64799 .58139 .64864 .57395 .64961 .57715 .64894 .58417 Mtetra
.618 .404 .569 r
.64894 .58417 .64961 .57715 .65063 .58179 .64994 .58823 Mtetra
.643 .424 .57 r
.64994 .58823 .65063 .58179 .65168 .58723 .65097 .59299 Mtetra
.658 .434 .568 r
.65097 .59299 .65168 .58723 .65274 .59283 .652 .5979 Mtetra
.664 .436 .564 r
.652 .5979 .65274 .59283 .65379 .5981 .65303 .6025 Mtetra
.663 .431 .558 r
.65303 .6025 .65379 .5981 .65481 .60268 .65404 .6065 Mtetra
.654 .417 .548 r
.65404 .6065 .65481 .60268 .65581 .60639 .65502 .60973 Mtetra
.635 .393 .534 r
.65502 .60973 .65581 .60639 .65678 .60917 .65597 .61213 Mtetra
.601 .353 .514 r
.65597 .61213 .65678 .60917 .65772 .61101 .6569 .6137 Mtetra
.54 .288 .482 r
.6569 .6137 .65772 .61101 .65862 .61195 .6578 .61447 Mtetra
.432 .178 .427 r
.6578 .61447 .65862 .61195 .6595 .61201 .65867 .61447 Mtetra
.227 0 .323 r
.65867 .61447 .6595 .61201 .66034 .61123 .65951 .61372 Mtetra
0 0 .127 r
.65951 .61372 .66034 .61123 .66115 .60958 .66033 .6122 Mtetra
0 0 0 r
.66033 .6122 .66115 .60958 .66193 .60704 .66112 .6099 Mtetra
.83 .805 .314 r
.66112 .6099 .66193 .60704 .66267 .60357 .66188 .60676 Mtetra
.928 .837 .388 r
.66188 .60676 .66267 .60357 .66338 .59915 .6626 .6028 Mtetra
.956 .833 .402 r
.6626 .6028 .66338 .59915 .66405 .59382 .6633 .59802 Mtetra
.955 .819 .381 r
.6633 .59802 .66405 .59382 .66469 .58772 .66396 .59256 Mtetra
.923 .793 .32 r
.66396 .59256 .66469 .58772 .66531 .58114 .66461 .58666 Mtetra
.824 .725 .196 r
.66461 .58666 .66531 .58114 .66593 .57452 .66526 .58074 Mtetra
0 0 .02 r
.66526 .58074 .66593 .57452 .66657 .56847 .66593 .57532 Mtetra
0 0 .274 r
.66593 .57532 .66657 .56847 .66725 .56364 .66663 .57098 Mtetra
.174 .036 .441 r
.66663 .57098 .66725 .56364 .66801 .56062 .6674 .56824 Mtetra
.389 .212 .517 r
.6674 .56824 .66801 .56062 .66885 .55977 .66824 .56743 Mtetra
.509 .312 .549 r
.66824 .56743 .66885 .55977 .66977 .56115 .66916 .5686 Mtetra
.578 .37 .563 r
.66916 .5686 .66977 .56115 .67078 .56448 .67015 .5715 Mtetra
.619 .404 .568 r
.67015 .5715 .67078 .56448 .67184 .56923 .67119 .57565 Mtetra
.644 .424 .569 r
.67119 .57565 .67184 .56923 .67294 .57475 .67226 .58049 Mtetra
.659 .433 .567 r
.67226 .58049 .67294 .57475 .67404 .5804 .67333 .58545 Mtetra
.665 .435 .562 r
.67333 .58545 .67404 .5804 .67514 .5857 .6744 .59008 Mtetra
.663 .429 .556 r
.6744 .59008 .67514 .5857 .6762 .59029 .67545 .5941 Mtetra
.654 .415 .546 r
.67545 .5941 .6762 .59029 .67724 .59401 .67646 .59733 Mtetra
.634 .391 .532 r
.67646 .59733 .67724 .59401 .67824 .59678 .67744 .59973 Mtetra
.6 .351 .511 r
.67744 .59973 .67824 .59678 .6792 .59861 .67839 .60129 Mtetra
.539 .285 .479 r
.67839 .60129 .6792 .59861 .68013 .59954 .67931 .60206 Mtetra
.429 .175 .424 r
.67931 .60206 .68013 .59954 .68102 .59959 .6802 .60205 Mtetra
.225 0 .322 r
.6802 .60205 .68102 .59959 .68187 .59878 .68106 .60128 Mtetra
0 0 .132 r
.68106 .60128 .68187 .59878 .68269 .59711 .68189 .59974 Mtetra
0 0 0 r
.68189 .59974 .68269 .59711 .68347 .59453 .68268 .59741 Mtetra
.816 .793 .296 r
.68268 .59741 .68347 .59453 .68422 .59102 .68344 .59424 Mtetra
.916 .829 .369 r
.68344 .59424 .68422 .59102 .68492 .58656 .68416 .59024 Mtetra
.946 .826 .383 r
.68416 .59024 .68492 .58656 .68558 .58118 .68485 .58542 Mtetra
.943 .811 .359 r
.68485 .58542 .68558 .58118 .68621 .57504 .68551 .57992 Mtetra
.905 .78 .293 r
.68551 .57992 .68621 .57504 .68682 .56843 .68615 .57401 Mtetra
.793 .702 .162 r
.68615 .57401 .68682 .56843 .68742 .56182 .68678 .56809 Mtetra
0 0 .057 r
.68678 .56809 .68742 .56182 .68805 .5558 .68744 .56271 Mtetra
0 0 .298 r
.68744 .56271 .68805 .5558 .68873 .55105 .68815 .55844 Mtetra
.197 .055 .451 r
.68815 .55844 .68873 .55105 .68949 .54814 .68892 .5558 Mtetra
.399 .221 .52 r
.68892 .5558 .68949 .54814 .69035 .54743 .68978 .55512 Mtetra
.514 .316 .55 r
.68978 .55512 .69035 .54743 .69131 .54895 .69073 .55642 Mtetra
.581 .372 .562 r
.69073 .55642 .69131 .54895 .69235 .55242 .69176 .55944 Mtetra
.621 .405 .567 r
.69176 .55944 .69235 .55242 .69346 .55728 .69284 .5637 Mtetra
.646 .424 .567 r
.69284 .5637 .69346 .55728 .69461 .56288 .69395 .56861 Mtetra
.659 .433 .565 r
.69395 .56861 .69461 .56288 .69576 .56859 .69507 .57362 Mtetra
.665 .434 .561 r
.69507 .57362 .69576 .56859 .6969 .57392 .69618 .57829 Mtetra
.663 .428 .554 r
.69618 .57829 .6969 .57392 .69801 .57854 .69727 .58232 Mtetra
.654 .414 .544 r
.69727 .58232 .69801 .57854 .69908 .58226 .69832 .58557 Mtetra
.634 .389 .53 r
.69832 .58557 .69908 .58226 .70011 .58503 .69933 .58797 Mtetra
.599 .348 .509 r
.69933 .58797 .70011 .58503 .7011 .58686 .70031 .58953 Mtetra
.538 .282 .476 r
.70031 .58953 .7011 .58686 .70205 .58777 .70125 .59029 Mtetra
.428 .172 .422 r
.70125 .59029 .70205 .58777 .70296 .58781 .70215 .59027 Mtetra
.225 0 .321 r
.70215 .59027 .70296 .58781 .70382 .58699 .70303 .58949 Mtetra
0 0 .138 r
.70303 .58949 .70382 .58699 .70465 .58529 .70386 .58794 Mtetra
0 0 0 r
.70386 .58794 .70465 .58529 .70544 .58268 .70466 .58558 Mtetra
.799 .779 .275 r
.70466 .58558 .70544 .58268 .70618 .57913 .70542 .58238 Mtetra
.903 .819 .348 r
.70542 .58238 .70618 .57913 .70688 .57462 .70614 .57834 Mtetra
.934 .817 .361 r
.70614 .57834 .70688 .57462 .70753 .5692 .70682 .57348 Mtetra
.929 .801 .335 r
.70682 .57348 .70753 .5692 .70815 .56302 .70747 .56796 Mtetra
.884 .765 .264 r
.70747 .56796 .70815 .56302 .70874 .55639 .7081 .56202 Mtetra
.758 .675 .126 r
.7081 .56202 .70874 .55639 .70933 .54977 .70872 .55611 Mtetra
0 0 .094 r
.70872 .55611 .70933 .54977 .70995 .5438 .70937 .55076 Mtetra
0 0 .321 r
.70937 .55076 .70995 .5438 .71063 .53913 .71008 .54657 Mtetra
.218 .073 .46 r
.71008 .54657 .71063 .53913 .7114 .53634 .71087 .54404 Mtetra
.409 .229 .523 r
.71087 .54404 .7114 .53634 .71228 .53577 .71175 .54349 Mtetra
.519 .32 .55 r
.71175 .54349 .71228 .53577 .71327 .53744 .71273 .54492 Mtetra
.584 .373 .562 r
.71273 .54492 .71327 .53744 .71436 .54104 .7138 .54807 Mtetra
.623 .405 .566 r
.7138 .54807 .71436 .54104 .71551 .54602 .71492 .55244 Mtetra
.647 .424 .566 r
.71492 .55244 .71551 .54602 .71671 .55171 .71608 .55743 Mtetra
.66 .432 .563 r
.71608 .55743 .71671 .55171 .71791 .55748 .71725 .5625 Mtetra
.666 .433 .559 r
.71725 .5625 .71791 .55748 .7191 .56285 .71841 .56721 Mtetra
.664 .427 .552 r
.71841 .56721 .7191 .56285 .72025 .56749 .71953 .57126 Mtetra
.654 .412 .542 r
.71953 .57126 .72025 .56749 .72136 .57122 .72061 .57452 Mtetra
.634 .387 .527 r
.72061 .57452 .72136 .57122 .72242 .57399 .72166 .57692 Mtetra
.598 .346 .506 r
.72166 .57692 .72242 .57399 .72344 .57582 .72266 .57849 Mtetra
.536 .28 .474 r
.72266 .57849 .72344 .57582 .72441 .57673 .72363 .57925 Mtetra
.427 .17 .42 r
.72363 .57925 .72441 .57673 .72534 .57676 .72455 .57923 Mtetra
.226 0 .322 r
.72455 .57923 .72534 .57676 .72622 .57592 .72544 .57843 Mtetra
0 0 .147 r
.72544 .57843 .72622 .57592 .72706 .57419 .72629 .57686 Mtetra
0 0 0 r
.72629 .57686 .72706 .57419 .72785 .57156 .72709 .57448 Mtetra
.778 .763 .252 r
.72709 .57448 .72785 .57156 .7286 .56797 .72785 .57125 Mtetra
.887 .807 .325 r
.72785 .57125 .7286 .56797 .72929 .56341 .72857 .56717 Mtetra
.92 .806 .337 r
.72857 .56717 .72929 .56341 .72993 .55794 .72924 .56228 Mtetra
.912 .788 .308 r
.72924 .56228 .72993 .55794 .73053 .55172 .72988 .55672 Mtetra
.86 .746 .232 r
.72988 .55672 .73053 .55172 .7311 .54506 .7305 .55077 Mtetra
.719 .645 .087 r
.7305 .55077 .7311 .54506 .73168 .53846 .73111 .54487 Mtetra
0 0 .13 r
.73111 .54487 .73168 .53846 .73229 .53252 .73176 .53956 Mtetra
0 0 .342 r
.73176 .53956 .73229 .53252 .73297 .52794 .73247 .53544 Mtetra
.238 .09 .468 r
.73247 .53544 .73297 .52794 .73375 .52526 .73326 .53302 Mtetra
.419 .237 .526 r
.73326 .53302 .73375 .52526 .73466 .52484 .73417 .5326 Mtetra
.524 .324 .551 r
.73417 .5326 .73466 .52484 .73568 .52666 .73518 .53417 Mtetra
.586 .375 .561 r
.73518 .53417 .73568 .52666 .73682 .53041 .73629 .53745 Mtetra
.624 .406 .565 r
.73629 .53745 .73682 .53041 .73803 .53551 .73747 .54193 Mtetra
.648 .423 .564 r
.73747 .54193 .73803 .53551 .73928 .54129 .73868 .54701 Mtetra
.661 .432 .562 r
.73868 .54701 .73928 .54129 .74053 .54713 .7399 .55214 Mtetra
.666 .432 .557 r
.7399 .55214 .74053 .54713 .74177 .55253 .7411 .55688 Mtetra
.664 .426 .55 r
.7411 .55688 .74177 .55253 .74296 .55719 .74226 .56096 Mtetra
.654 .411 .539 r
.74226 .56096 .74296 .55719 .74411 .56094 .74338 .56424 Mtetra
.633 .385 .525 r
.74338 .56424 .74411 .56094 .74521 .56372 .74446 .56665 Mtetra
.597 .344 .504 r
.74446 .56665 .74521 .56372 .74626 .56554 .74549 .56822 Mtetra
.535 .278 .472 r
.74549 .56822 .74626 .56554 .74725 .56645 .74648 .56898 Mtetra
.426 .169 .419 r
.74648 .56898 .74725 .56645 .7482 .56647 .74743 .56895 Mtetra
.228 0 .324 r
.74743 .56895 .7482 .56647 .7491 .56561 .74833 .56815 Mtetra
0 0 .157 r
.74833 .56815 .7491 .56561 .74995 .56387 .74919 .56656 Mtetra
0 0 0 r
.74919 .56656 .74995 .56387 .75074 .5612 .75 .56415 Mtetra
.754 .744 .225 r
.75 .56415 .75074 .5612 .75148 .55757 .75076 .5609 Mtetra
.867 .792 .299 r
.75076 .5609 .75148 .55757 .75217 .55297 .75147 .55678 Mtetra
.902 .794 .311 r
.75147 .55678 .75217 .55297 .7528 .54745 .75214 .55184 Mtetra
.892 .773 .278 r
.75214 .55184 .7528 .54745 .75338 .54118 .75277 .54625 Mtetra
.831 .725 .197 r
.75277 .54625 .75338 .54118 .75394 .5345 .75337 .54028 Mtetra
0 0 0 r
.75337 .54028 .75394 .5345 .7545 .5279 .75398 .53439 Mtetra
0 0 .165 r
.75398 .53439 .7545 .5279 .75511 .52201 .75462 .52912 Mtetra
0 0 .361 r
.75462 .52912 .75511 .52201 .75579 .5175 .75533 .52508 Mtetra
.257 .106 .476 r
.75533 .52508 .75579 .5175 .75659 .51495 .75614 .52278 Mtetra
.428 .245 .528 r
.75614 .52278 .75659 .51495 .75752 .51467 .75707 .52249 Mtetra
.528 .327 .551 r
.75707 .52249 .75752 .51467 .75858 .51665 .75812 .5242 Mtetra
.589 .376 .56 r
.75812 .5242 .75858 .51665 .75976 .52054 .75928 .52761 Mtetra
.626 .406 .563 r
.75928 .52761 .75976 .52054 .76103 .52576 .7605 .5322 Mtetra
.649 .423 .563 r
.7605 .5322 .76103 .52576 .76233 .53164 .76177 .53736 Mtetra
.661 .431 .56 r
.76177 .53736 .76233 .53164 .76364 .53754 .76303 .54256 Mtetra
.666 .431 .555 r
.76303 .54256 .76364 .53754 .76493 .54299 .76428 .54734 Mtetra
.664 .424 .547 r
.76428 .54734 .76493 .54299 .76617 .54768 .76549 .55145 Mtetra
.653 .409 .537 r
.76549 .55145 .76617 .54768 .76736 .55144 .76665 .55474 Mtetra
.633 .383 .522 r
.76665 .55474 .76736 .55144 .76849 .55423 .76776 .55717 Mtetra
.596 .342 .502 r
.76776 .55717 .76849 .55423 .76957 .55605 .76882 .55874 Mtetra
.534 .276 .47 r
.76882 .55874 .76957 .55605 .77059 .55696 .76984 .5595 Mtetra
.425 .168 .418 r
.76984 .5595 .77059 .55696 .77156 .55697 .7708 .55947 Mtetra
.231 0 .327 r
.7708 .55947 .77156 .55697 .77247 .55609 .77172 .55866 Mtetra
0 0 .169 r
.77172 .55866 .77247 .55609 .77333 .55432 .77259 .55705 Mtetra
0 0 0 r
.77259 .55705 .77333 .55432 .77413 .55162 .77341 .55462 Mtetra
.727 .722 .197 r
.77341 .55462 .77413 .55162 .77487 .54795 .77417 .55132 Mtetra
.845 .775 .27 r
.77417 .55132 .77487 .54795 .77555 .5433 .77488 .54716 Mtetra
.881 .778 .281 r
.77488 .54716 .77555 .5433 .77617 .53772 .77554 .54219 Mtetra
.868 .756 .247 r
.77554 .54219 .77617 .53772 .77674 .53141 .77616 .53656 Mtetra
.798 .701 .161 r
.77616 .53656 .77674 .53141 .77728 .5247 .77675 .53057 Mtetra
0 0 0 r
.77675 .53057 .77728 .5247 .77783 .5181 .77734 .52468 Mtetra
0 0 .199 r
.77734 .52468 .77783 .5181 .77843 .51225 .77798 .51945 Mtetra
.014 0 .379 r
.77798 .51945 .77843 .51225 .77911 .50783 .7787 .51549 Mtetra
.275 .121 .483 r
.7787 .51549 .77911 .50783 .77992 .5054 .77952 .5133 Mtetra
.436 .251 .53 r
.77952 .5133 .77992 .5054 .78088 .50527 .78048 .51314 Mtetra
.533 .33 .551 r
.78048 .51314 .78088 .50527 .78199 .50741 .78157 .515 Mtetra
.591 .377 .56 r
.78157 .515 .78199 .50741 .78322 .51144 .78278 .51854 Mtetra
.627 .406 .562 r
.78278 .51854 .78322 .51144 .78454 .51679 .78405 .52324 Mtetra
.65 .423 .561 r
.78405 .52324 .78454 .51679 .78591 .52276 .78537 .5285 Mtetra
.662 .43 .558 r
.78537 .5285 .78591 .52276 .78727 .52873 .78669 .53375 Mtetra
.666 .43 .553 r
.78669 .53375 .78727 .52873 .78861 .53423 .78799 .53858 Mtetra
.664 .423 .545 r
.78799 .53858 .78861 .53423 .78991 .53894 .78924 .54272 Mtetra
.653 .407 .535 r
.78924 .54272 .78991 .53894 .79114 .54271 .79044 .54603 Mtetra
.632 .381 .52 r
.79044 .54603 .79114 .54271 .79231 .54551 .79159 .54846 Mtetra
.595 .339 .499 r
.79159 .54846 .79231 .54551 .79342 .54733 .79268 .55004 Mtetra
.532 .273 .468 r
.79268 .55004 .79342 .54733 .79446 .54823 .79372 .5508 Mtetra
.424 .167 .417 r
.79372 .5508 .79446 .54823 .79545 .54823 .79471 .55076 Mtetra
.234 0 .33 r
.79471 .55076 .79545 .54823 .79638 .54734 .79564 .54993 Mtetra
0 0 .18 r
.79564 .54993 .79638 .54734 .79725 .54554 .79652 .5483 Mtetra
0 0 0 r
.79652 .5483 .79725 .54554 .79806 .5428 .79735 .54584 Mtetra
.697 .699 .166 r
.79735 .54584 .79806 .5428 .79879 .53908 .79812 .54251 Mtetra
.82 .756 .239 r
.79812 .54251 .79879 .53908 .79946 .53437 .79882 .5383 Mtetra
.857 .76 .25 r
.79882 .5383 .79946 .53437 .80007 .52874 .79947 .53328 Mtetra
.841 .735 .213 r
.79947 .53328 .80007 .52874 .80063 .52238 .80008 .52761 Mtetra
.762 .673 .123 r
.80008 .52761 .80063 .52238 .80115 .51564 .80065 .5216 Mtetra
0 0 .032 r
.80065 .5216 .80115 .51564 .80169 .50904 .80124 .51571 Mtetra
0 0 .23 r
.80124 .51571 .80169 .50904 .80227 .50323 .80187 .51052 Mtetra
.046 0 .395 r
.80187 .51052 .80227 .50323 .80296 .49889 .8026 .50664 Mtetra
.291 .134 .489 r
.8026 .50664 .80296 .49889 .80379 .49659 .80344 .50456 Mtetra
.444 .258 .532 r
.80344 .50456 .80379 .49659 .80478 .4966 .80443 .50454 Mtetra
.537 .333 .551 r
.80443 .50454 .80478 .4966 .80593 .49889 .80556 .50653 Mtetra
.593 .378 .559 r
.80556 .50653 .80593 .49889 .80722 .50308 .80682 .51021 Mtetra
.629 .406 .561 r
.80682 .51021 .80722 .50308 .8086 .50854 .80815 .51502 Mtetra
.65 .422 .56 r
.80815 .51502 .8086 .50854 .81003 .51461 .80953 .52037 Mtetra
.662 .429 .556 r
.80953 .52037 .81003 .51461 .81145 .52065 .8109 .52568 Mtetra
.666 .429 .551 r
.8109 .52568 .81145 .52065 .81285 .52619 .81225 .53056 Mtetra
.663 .421 .543 r
.81225 .53056 .81285 .52619 .81419 .53093 .81355 .53472 Mtetra
.652 .405 .533 r
.81355 .53472 .81419 .53093 .81547 .53471 .81479 .53804 Mtetra
.631 .379 .518 r
.81479 .53804 .81547 .53471 .81668 .53751 .81598 .54049 Mtetra
.593 .337 .497 r
.81598 .54049 .81668 .53751 .81782 .53934 .8171 .54207 Mtetra
.53 .271 .466 r
.8171 .54207 .81782 .53934 .81889 .54023 .81817 .54282 Mtetra
.422 .165 .417 r
.81817 .54282 .81889 .54023 .8199 .54021 .81917 .54278 Mtetra
.236 0 .333 r
.81917 .54278 .8199 .54021 .82085 .5393 .82013 .54193 Mtetra
0 0 .192 r
.82013 .54193 .82085 .5393 .82173 .53747 .82102 .54028 Mtetra
0 0 .011 r
.82102 .54028 .82173 .53747 .82254 .53469 .82185 .53778 Mtetra
0 0 0 r
.82185 .53778 .82254 .53469 .82327 .53091 .82262 .53441 Mtetra
.792 .734 .207 r
.82262 .53441 .82327 .53091 .82394 .52615 .82332 .53015 Mtetra
.831 .74 .217 r
.82332 .53015 .82394 .52615 .82453 .52046 .82396 .52508 Mtetra
.811 .712 .177 r
.82396 .52508 .82453 .52046 .82507 .51404 .82455 .51936 Mtetra
.724 .643 .084 r
.82455 .51936 .82507 .51404 .82558 .50726 .82512 .51332 Mtetra
0 0 .071 r
.82512 .51332 .82558 .50726 .8261 .50065 .8257 .50743 Mtetra
0 0 .259 r
.8257 .50743 .8261 .50065 .82668 .49488 .82632 .50227 Mtetra
.076 0 .41 r
.82632 .50227 .82668 .49488 .82737 .49063 .82705 .49847 Mtetra
.306 .147 .494 r
.82705 .49847 .82737 .49063 .82822 .48844 .82792 .4965 Mtetra
.451 .264 .534 r
.82792 .4965 .82822 .48844 .82924 .48861 .82894 .49661 Mtetra
.54 .335 .551 r
.82894 .49661 .82924 .48861 .83044 .49105 .83012 .49875 Mtetra
.595 .379 .558 r
.83012 .49875 .83044 .49105 .83178 .49538 .83142 .50256 Mtetra
.63 .406 .56 r
.83142 .50256 .83178 .49538 .83323 .50097 .83282 .50748 Mtetra
.651 .421 .558 r
.83282 .50748 .83323 .50097 .83472 .50713 .83425 .51291 Mtetra
.662 .428 .554 r
.83425 .51291 .83472 .50713 .83621 .51323 .83569 .51829 Mtetra
.666 .427 .549 r
.83569 .51829 .83621 .51323 .83766 .51882 .83709 .52321 Mtetra
.663 .419 .541 r
.83709 .52321 .83766 .51882 .83905 .52358 .83844 .5274 Mtetra
.651 .403 .53 r
.83844 .5274 .83905 .52358 .84038 .52738 .83972 .53073 Mtetra
.629 .376 .515 r
.83972 .53073 .84038 .52738 .84162 .53018 .84094 .53318 Mtetra
.591 .334 .495 r
.84094 .53318 .84162 .53018 .8428 .53201 .8421 .53476 Mtetra
.528 .268 .464 r
.8421 .53476 .8428 .53201 .8439 .53289 .84319 .53551 Mtetra
.42 .164 .416 r
.84319 .53551 .8439 .53289 .84493 .53285 .84422 .53545 Mtetra
.238 0 .336 r
.84422 .53545 .84493 .53285 .84589 .53191 .84519 .53459 Mtetra
0 0 .204 r
.84519 .53459 .84589 .53191 .84678 .53004 .8461 .5329 Mtetra
0 0 .035 r
.8461 .5329 .84678 .53004 .8476 .52721 .84694 .53037 Mtetra
0 0 0 r
.84694 .53037 .8476 .52721 .84833 .52338 .8477 .52694 Mtetra
.762 .71 .174 r
.8477 .52694 .84833 .52338 .84899 .51855 .8484 .52263 Mtetra
.801 .717 .183 r
.8484 .52263 .84899 .51855 .84957 .51279 .84903 .5175 Mtetra
.778 .687 .141 r
.84903 .5175 .84957 .51279 .85009 .50632 .84961 .51173 Mtetra
0 0 0 r
.84961 .51173 .85009 .50632 .85058 .49949 .85017 .50566 Mtetra
0 0 .108 r
.85017 .50566 .85058 .49949 .85108 .49288 .85073 .49976 Mtetra
0 0 .285 r
.85073 .49976 .85108 .49288 .85166 .48714 .85136 .49464 Mtetra
.103 0 .423 r
.85136 .49464 .85166 .48714 .85236 .48296 .85209 .4909 Mtetra
.32 .158 .499 r
.85209 .4909 .85236 .48296 .85323 .4809 .85298 .48904 Mtetra
.458 .269 .535 r
.85298 .48904 .85323 .4809 .85429 .48121 .85404 .48929 Mtetra
.543 .337 .551 r
.85404 .48929 .85429 .48121 .85554 .48381 .85526 .49157 Mtetra
.597 .38 .557 r
.85526 .49157 .85554 .48381 .85694 .48828 .85663 .4955 Mtetra
.63 .406 .558 r
.85663 .4955 .85694 .48828 .85845 .49399 .85808 .50054 Mtetra
.651 .42 .556 r
.85808 .50054 .85845 .49399 .86001 .50024 .85958 .50605 Mtetra
.662 .427 .553 r
.85958 .50605 .86001 .50024 .86156 .50641 .86107 .5115 Mtetra
.666 .426 .547 r
.86107 .5115 .86156 .50641 .86307 .51204 .86253 .51645 Mtetra
.662 .417 .539 r
.86253 .51645 .86307 .51204 .86452 .51682 .86393 .52066 Mtetra
.65 .4 .528 r
.86393 .52066 .86452 .51682 .86589 .52063 .86526 .52401 Mtetra
.628 .373 .513 r
.86526 .52401 .86589 .52063 .86718 .52344 .86652 .52646 Mtetra
.589 .33 .493 r
.86652 .52646 .86718 .52344 .86839 .52525 .86771 .52804 Mtetra
.525 .265 .463 r
.86771 .52804 .86839 .52525 .86952 .52612 .86883 .52878 Mtetra
.418 .162 .416 r
.86883 .52878 .86952 .52612 .87057 .52606 .86988 .5287 Mtetra
.239 .002 .339 r
.86988 .5287 .87057 .52606 .87155 .52509 .87087 .52781 Mtetra
0 0 .215 r
.87087 .52781 .87155 .52509 .87245 .52318 .87179 .52609 Mtetra
0 0 .058 r
.87179 .52609 .87245 .52318 .87327 .5203 .87263 .52351 Mtetra
0 0 0 r
.87263 .52351 .87327 .5203 .874 .5164 .8734 .52004 Mtetra
.731 .685 .141 r
.8734 .52004 .874 .5164 .87465 .5115 .87409 .51566 Mtetra
.77 .692 .148 r
.87409 .51566 .87465 .5115 .87521 .50566 .87471 .51047 Mtetra
.743 .659 .104 r
.87471 .51047 .87521 .50566 .87571 .49912 .87528 .50464 Mtetra
0 0 0 r
.87528 .50464 .87571 .49912 .87618 .49225 .87582 .49852 Mtetra
0 0 .143 r
.87582 .49852 .87618 .49225 .87667 .48562 .87637 .49262 Mtetra
0 0 .309 r
.87637 .49262 .87667 .48562 .87724 .47991 .877 .48753 Mtetra
.128 .008 .434 r
.877 .48753 .87724 .47991 .87795 .47582 .87774 .48386 Mtetra
.333 .169 .504 r
.87774 .48386 .87795 .47582 .87884 .47387 .87865 .48211 Mtetra
.464 .274 .537 r
.87865 .48211 .87884 .47387 .87994 .47432 .87975 .48248 Mtetra
.546 .339 .551 r
.87975 .48248 .87994 .47432 .88124 .47708 .88102 .4849 Mtetra
.598 .38 .556 r
.88102 .4849 .88124 .47708 .88271 .48169 .88244 .48897 Mtetra
.631 .405 .557 r
.88244 .48897 .88271 .48169 .88429 .48752 .88396 .49411 Mtetra
.651 .419 .555 r
.88396 .49411 .88429 .48752 .88591 .49386 .88552 .49971 Mtetra
.662 .425 .551 r
.88552 .49971 .88591 .49386 .88754 .5001 .88708 .50521 Mtetra
.666 .424 .545 r
.88708 .50521 .88754 .5001 .88911 .50576 .8886 .5102 Mtetra
.661 .415 .536 r
.8886 .5102 .88911 .50576 .89061 .51057 .89005 .51443 Mtetra
.649 .398 .525 r
.89005 .51443 .89061 .51057 .89203 .51439 .89142 .51779 Mtetra
.626 .37 .511 r
.89142 .51779 .89203 .51439 .89336 .51719 .89272 .52024 Mtetra
.587 .327 .49 r
.89272 .52024 .89336 .51719 .89461 .51899 .89395 .52181 Mtetra
.522 .261 .461 r
.89395 .52181 .89461 .51899 .89577 .51984 .8951 .52254 Mtetra
.415 .159 .415 r
.8951 .52254 .89577 .51984 .89684 .51976 .89617 .52244 Mtetra
.239 .004 .341 r
.89617 .52244 .89684 .51976 .89784 .51875 .89718 .52152 Mtetra
0 0 .225 r
.89718 .52152 .89784 .51875 .89875 .51679 .89811 .51976 Mtetra
0 0 .079 r
.89811 .51976 .89875 .51679 .89957 .51385 .89896 .51713 Mtetra
0 0 0 r
.89896 .51713 .89957 .51385 .9003 .50989 .89973 .51359 Mtetra
.89973 .51359 .9003 .50989 .90093 .5049 .90041 .50915 Mtetra
.737 .666 .113 r
.90041 .50915 .90093 .5049 .90148 .49899 .90102 .50389 Mtetra
.706 .63 .067 r
.90102 .50389 .90148 .49899 .90196 .49237 .90157 .498 Mtetra
0 0 .031 r
.90157 .498 .90196 .49237 .90241 .48545 .9021 .49184 Mtetra
0 0 .176 r
.9021 .49184 .90241 .48545 .90289 .4788 .90264 .48592 Mtetra
0 0 .331 r
.90264 .48592 .90289 .4788 .90345 .47312 .90326 .48085 Mtetra
.151 .027 .445 r
.90326 .48085 .90345 .47312 .90416 .4691 .90402 .47726 Mtetra
.344 .179 .508 r
.90402 .47726 .90416 .4691 .90508 .46727 .90495 .47561 Mtetra
.47 .278 .538 r
.90495 .47561 .90508 .46727 .90622 .46787 .90609 .47611 Mtetra
.549 .341 .55 r
.90609 .47611 .90622 .46787 .90758 .47077 .90742 .47867 Mtetra
.6 .381 .555 r
.90742 .47867 .90758 .47077 .90912 .47553 .9089 .48286 Mtetra
.632 .405 .555 r
.9089 .48286 .90912 .47553 .91077 .48148 .91049 .48811 Mtetra
.652 .418 .553 r
.91049 .48811 .91077 .48148 .91247 .48791 .91212 .49379 Mtetra
.662 .424 .549 r
.91212 .49379 .91247 .48791 .91416 .4942 .91374 .49935 Mtetra
.665 .422 .542 r
.91374 .49935 .91416 .4942 .9158 .4999 .91531 .50437 Mtetra
.66 .413 .534 r
.91531 .50437 .9158 .4999 .91736 .50473 .91682 .50862 Mtetra
.648 .395 .523 r
.91682 .50862 .91736 .50473 .91883 .50855 .91824 .51199 Mtetra
.624 .367 .508 r
.91824 .51199 .91883 .50855 .9202 .51135 .91958 .51444 Mtetra
.584 .323 .488 r
.91958 .51444 .9202 .51135 .92148 .51314 .92084 .516 Mtetra
.518 .257 .459 r
.92084 .516 .92148 .51314 .92267 .51397 .92202 .51671 Mtetra
.411 .157 .414 r
.92202 .51671 .92267 .51397 .92377 .51385 .92312 .51658 Mtetra
.238 .005 .344 r
.92312 .51658 .92377 .51385 .92478 .51281 .92414 .51563 Mtetra
0 0 .235 r
.92414 .51563 .92478 .51281 .9257 .5108 .92509 .51383 Mtetra
0 0 .1 r
.92509 .51383 .9257 .5108 .92653 .50779 .92594 .51114 Mtetra
0 0 0 r
.92594 .51114 .92653 .50779 .92725 .50375 .92671 .50753 Mtetra
.92671 .50753 .92725 .50375 .92787 .49868 .92739 .50302 Mtetra
.703 .638 .079 r
.92739 .50302 .92787 .49868 .9284 .49268 .92798 .49768 Mtetra
0 0 0 r
.92798 .49768 .9284 .49268 .92886 .48598 .92852 .49172 Mtetra
0 0 .067 r
.92852 .49172 .92886 .48598 .92929 .47901 .92903 .48551 Mtetra
0 0 .207 r
.92903 .48551 .92929 .47901 .92975 .47234 .92956 .47957 Mtetra
0 0 .35 r
.92956 .47957 .92975 .47234 .93031 .46668 .93018 .47453 Mtetra
.172 .044 .454 r
.93018 .47453 .93031 .46668 .93103 .46273 .93095 .471 Mtetra
.355 .187 .511 r
.93095 .471 .93103 .46273 .93197 .46102 .93191 .46946 Mtetra
.475 .282 .538 r
.93191 .46946 .93197 .46102 .93316 .46176 .93309 .47009 Mtetra
.552 .342 .55 r
.93309 .47009 .93316 .46176 .93458 .46482 .93447 .47278 Mtetra
.601 .381 .554 r
.93447 .47278 .93458 .46482 .93619 .46971 .93602 .4771 Mtetra
.632 .404 .554 r
.93602 .4771 .93619 .46971 .93791 .47578 .93768 .48246 Mtetra
.652 .417 .551 r
.93768 .48246 .93791 .47578 .93969 .4823 .93938 .48822 Mtetra
.662 .422 .546 r
.93938 .48822 .93969 .4823 .94145 .48865 .94107 .49383 Mtetra
.664 .42 .54 r
.94107 .49383 .94145 .48865 .94316 .49438 .9427 .49888 Mtetra
.659 .41 .532 r
.9427 .49888 .94316 .49438 .94478 .49923 .94426 .50315 Mtetra
.646 .392 .521 r
.94426 .50315 .94478 .49923 .9463 .50305 .94574 .50652 Mtetra
.621 .363 .506 r
.94574 .50652 .9463 .50305 .94771 .50584 .94712 .50896 Mtetra
.581 .319 .485 r
.94712 .50896 .94771 .50584 .94903 .50761 .94842 .51051 Mtetra
.514 .253 .457 r
.94842 .51051 .94903 .50761 .95025 .50841 .94962 .5112 Mtetra
.407 .153 .414 r
.94962 .5112 .95025 .50841 .95137 .50827 .95075 .51104 Mtetra
.237 .006 .346 r
.95075 .51104 .95137 .50827 .9524 .50717 .95179 .51005 Mtetra
0 0 .244 r
.95179 .51005 .9524 .50717 .95333 .50511 .95274 .5082 Mtetra
0 0 .119 r
.95274 .5082 .95333 .50511 .95416 .50203 .9536 .50545 Mtetra
0 0 .013 r
.9536 .50545 .95416 .50203 .95488 .49791 .95437 .50177 Mtetra
0 0 0 r
.95437 .50177 .95488 .49791 .95549 .49275 .95504 .49718 Mtetra
.95504 .49718 .95549 .49275 .956 .48665 .95562 .49176 Mtetra
0 0 .005 r
.95562 .49176 .956 .48665 .95643 .47987 .95614 .48573 Mtetra
0 0 .102 r
.95614 .48573 .95643 .47987 .95684 .47284 .95663 .47947 Mtetra
0 0 .236 r
.95663 .47947 .95684 .47284 .95728 .46615 .95715 .47351 Mtetra
0 0 .368 r
.95715 .47351 .95728 .46615 .95784 .46051 .95777 .46849 Mtetra
.191 .06 .462 r
.95777 .46849 .95784 .46051 .95857 .45664 .95855 .46502 Mtetra
.364 .195 .514 r
.95855 .46502 .95857 .45664 .95954 .45504 .95954 .46358 Mtetra
.48 .286 .539 r
.95954 .46358 .95954 .45504 .96078 .45592 .96077 .46435 Mtetra
.554 .344 .549 r
.96077 .46435 .96078 .45592 .96226 .45913 .96221 .46717 Mtetra
.602 .381 .553 r
.96221 .46717 .96226 .45913 .96394 .46416 .96383 .47161 Mtetra
.633 .403 .552 r
.96383 .47161 .96394 .46416 .96574 .47034 .96556 .47707 Mtetra
.652 .416 .549 r
.96556 .47707 .96574 .47034 .9676 .47695 .96733 .48291 Mtetra
.661 .42 .544 r
.96733 .48291 .9676 .47695 .96944 .48336 .96909 .48857 Mtetra
.663 .417 .538 r
.96909 .48857 .96944 .48336 .97121 .48913 .97079 .49366 Mtetra
.658 .407 .529 r
.97079 .49366 .97121 .48913 .97289 .49398 .97241 .49794 Mtetra
.644 .389 .518 r
.97241 .49794 .97289 .49398 .97446 .49781 .97393 .50131 Mtetra
.619 .36 .503 r
.97393 .50131 .97446 .49781 .97593 .50058 .97536 .50374 Mtetra
.577 .315 .483 r
.97536 .50374 .97593 .50058 .97728 .50234 .97669 .50527 Mtetra
.51 .249 .455 r
.97669 .50527 .97728 .50234 .97853 .50311 .97793 .50594 Mtetra
.403 .15 .413 r
.97793 .50594 .97853 .50311 .97968 .50293 .97908 .50575 Mtetra
.235 .006 .348 r
.97908 .50575 .97968 .50293 .98073 .50178 .98014 .50471 Mtetra
0 0 .252 r
.98014 .50471 .98073 .50178 .98167 .49966 .9811 .50281 Mtetra
0 0 .137 r
.9811 .50281 .98167 .49966 .98249 .4965 .98197 .49999 Mtetra
0 0 .039 r
.98197 .49999 .98249 .4965 .9832 .49229 .98273 .49624 Mtetra
0 0 0 r
.98273 .49624 .9832 .49229 .9838 .48703 .98339 .49156 Mtetra
.98339 .49156 .9838 .48703 .98429 .48084 .98396 .48606 Mtetra
0 0 .039 r
.98396 .48606 .98429 .48084 .9847 .47398 .98446 .47995 Mtetra
0 0 .135 r
.98446 .47995 .9847 .47398 .98509 .46688 .98493 .47363 Mtetra
0 0 .262 r
.98493 .47363 .98509 .46688 .98551 .46016 .98544 .46765 Mtetra
0 0 .384 r
.98544 .46765 .98551 .46016 .98606 .45455 .98606 .46265 Mtetra
.208 .075 .47 r
.98606 .46265 .98606 .45455 .9868 .45074 .98685 .45925 Mtetra
.373 .203 .517 r
.98685 .45925 .9868 .45074 .98781 .44926 .98788 .45791 Mtetra
.465 .273 .535 r
.52663 .67197 .52748 .66522 .52825 .6656 .5274 .67224 Mtetra
.554 .35 .559 r
.5274 .67224 .52825 .6656 .52904 .66776 .52818 .67409 Mtetra
.604 .394 .569 r
.52818 .67409 .52904 .66776 .52983 .67132 .52897 .67716 Mtetra
.634 .419 .573 r
.52897 .67716 .52983 .67132 .53064 .67572 .52977 .68099 Mtetra
.651 .432 .572 r
.52977 .68099 .53064 .67572 .53145 .68042 .53058 .68508 Mtetra
.659 .436 .569 r
.53058 .68508 .53145 .68042 .53226 .68495 .53139 .68902 Mtetra
.659 .432 .563 r
.53139 .68902 .53226 .68495 .53307 .68895 .53219 .69249 Mtetra
.652 .419 .554 r
.53219 .69249 .53307 .68895 .53388 .69225 .53299 .69533 Mtetra
.635 .396 .54 r
.53299 .69533 .53388 .69225 .53468 .69474 .53379 .69747 Mtetra
.603 .358 .518 r
.53379 .69747 .53468 .69474 .53547 .69642 .53458 .69889 Mtetra
.547 .294 .484 r
.53458 .69889 .53547 .69642 .53625 .69732 .53536 .69961 Mtetra
.443 .184 .425 r
.53536 .69961 .53625 .69732 .53703 .69746 .53614 .69967 Mtetra
.238 0 .309 r
.53614 .69967 .53703 .69746 .53781 .69686 .53691 .69907 Mtetra
0 0 .078 r
.53691 .69907 .53781 .69686 .53857 .69553 .53768 .69783 Mtetra
0 0 0 r
.53768 .69783 .53857 .69553 .53933 .69344 .53844 .69591 Mtetra
.888 .869 .427 r
.53844 .69591 .53933 .69344 .54008 .69056 .53919 .6933 Mtetra
.967 .88 .493 r
.53919 .6933 .54008 .69056 .54082 .68687 .53994 .68997 Mtetra
.987 .866 .506 r
.53994 .68997 .54082 .68687 .54155 .68237 .54067 .68593 Mtetra
.991 .853 .493 r
.54067 .68593 .54155 .68237 .54227 .67716 .5414 .68126 Mtetra
.983 .843 .456 r
.5414 .68126 .54227 .67716 .54299 .67145 .54213 .67614 Mtetra
.945 .822 .376 r
.54213 .67614 .54299 .67145 .5437 .66557 .54285 .67087 Mtetra
.809 .735 .209 r
.54285 .67087 .5437 .66557 .54441 .66001 .54357 .66589 Mtetra
0 0 .082 r
.54357 .66589 .54441 .66001 .54514 .65534 .5443 .66169 Mtetra
.009 0 .351 r
.5443 .66169 .54514 .65534 .54588 .65208 .54505 .65874 Mtetra
.311 .142 .483 r
.54505 .65874 .54588 .65208 .54664 .65063 .54581 .65738 Mtetra
.47 .278 .537 r
.54581 .65738 .54664 .65063 .54742 .65111 .5466 .65774 Mtetra
.557 .352 .559 r
.5466 .65774 .54742 .65111 .54823 .65336 .5474 .65967 Mtetra
.606 .395 .568 r
.5474 .65967 .54823 .65336 .54906 .65699 .54822 .66282 Mtetra
.635 .419 .572 r
.54822 .66282 .54906 .65699 .5499 .66145 .54905 .66669 Mtetra
.652 .431 .571 r
.54905 .66669 .5499 .66145 .55074 .66618 .54989 .67081 Mtetra
.659 .435 .568 r
.54989 .67081 .55074 .66618 .55159 .67071 .55073 .67475 Mtetra
.659 .43 .561 r
.55073 .67475 .55159 .67071 .55243 .67471 .55156 .67821 Mtetra
.651 .417 .552 r
.55156 .67821 .55243 .67471 .55326 .67798 .55239 .68104 Mtetra
.634 .394 .537 r
.55239 .68104 .55326 .67798 .55408 .68045 .55321 .68315 Mtetra
.601 .354 .515 r
.55321 .68315 .55408 .68045 .5549 .6821 .55401 .68455 Mtetra
.543 .289 .48 r
.55401 .68455 .5549 .6821 .5557 .68297 .55482 .68525 Mtetra
.436 .176 .419 r
.55482 .68525 .5557 .68297 .55649 .68308 .55561 .68528 Mtetra
.227 0 .301 r
.55561 .68528 .55649 .68308 .55728 .68245 .55639 .68465 Mtetra
0 0 .07 r
.55639 .68465 .55728 .68245 .55805 .68108 .55717 .68338 Mtetra
0 0 0 r
.55717 .68338 .55805 .68108 .55881 .67895 .55794 .68142 Mtetra
.886 .866 .421 r
.55794 .68142 .55881 .67895 .55957 .67602 .55869 .67877 Mtetra
.964 .877 .485 r
.55869 .67877 .55957 .67602 .5603 .67227 .55944 .67539 Mtetra
.985 .864 .496 r
.55944 .67539 .5603 .67227 .56103 .66773 .56017 .67131 Mtetra
.988 .851 .481 r
.56017 .67131 .56103 .66773 .56174 .66247 .56089 .66659 Mtetra
.978 .84 .441 r
.56089 .66659 .56174 .66247 .56245 .65672 .56161 .66144 Mtetra
.933 .813 .355 r
.56161 .66144 .56245 .65672 .56315 .65082 .56232 .65616 Mtetra
.779 .713 .177 r
.56232 .65616 .56315 .65082 .56386 .64528 .56304 .65119 Mtetra
0 0 .113 r
.56304 .65119 .56386 .64528 .56458 .64065 .56377 .64703 Mtetra
.037 0 .366 r
.56377 .64703 .56458 .64065 .56532 .63747 .56452 .64414 Mtetra
.324 .153 .488 r
.56452 .64414 .56532 .63747 .56609 .63611 .56529 .64288 Mtetra
.476 .283 .538 r
.56529 .64288 .56609 .63611 .56689 .63669 .56609 .64333 Mtetra
.56 .354 .559 r
.56609 .64333 .56689 .63669 .56773 .63905 .56692 .64535 Mtetra
.608 .395 .568 r
.56692 .64535 .56773 .63905 .56858 .64276 .56777 .64856 Mtetra
.636 .419 .57 r
.56777 .64856 .56858 .64276 .56946 .64727 .56863 .65249 Mtetra
.652 .43 .569 r
.56863 .65249 .56946 .64727 .57034 .65203 .5695 .65663 Mtetra
.66 .434 .566 r
.5695 .65663 .57034 .65203 .57122 .65656 .57037 .66057 Mtetra
.659 .429 .559 r
.57037 .66057 .57122 .65656 .57209 .66056 .57123 .66403 Mtetra
.651 .415 .549 r
.57123 .66403 .57209 .66056 .57295 .66381 .57209 .66685 Mtetra
.633 .391 .534 r
.57209 .66685 .57295 .66381 .5738 .66626 .57293 .66894 Mtetra
.599 .351 .512 r
.57293 .66894 .5738 .66626 .57463 .66789 .57376 .67031 Mtetra
.54 .284 .476 r
.57376 .67031 .57463 .66789 .57545 .66873 .57458 .67099 Mtetra
.43 .169 .414 r
.57458 .67099 .57545 .66873 .57626 .66881 .57539 .671 Mtetra
.217 0 .294 r
.57539 .671 .57626 .66881 .57706 .66815 .57618 .67035 Mtetra
0 0 .063 r
.57618 .67035 .57706 .66815 .57784 .66675 .57697 .66904 Mtetra
0 0 0 r
.57697 .66904 .57784 .66675 .57861 .66457 .57774 .66705 Mtetra
.882 .862 .413 r
.57774 .66705 .57861 .66457 .57936 .6616 .5785 .66436 Mtetra
.961 .874 .475 r
.5785 .66436 .57936 .6616 .58009 .6578 .57924 .66094 Mtetra
.982 .862 .486 r
.57924 .66094 .58009 .6578 .58081 .65321 .57997 .65681 Mtetra
.984 .849 .469 r
.57997 .65681 .58081 .65321 .58152 .6479 .58069 .65205 Mtetra
.971 .836 .424 r
.58069 .65205 .58152 .6479 .58221 .64212 .5814 .64687 Mtetra
.918 .803 .332 r
.5814 .64687 .58221 .64212 .58291 .63621 .5821 .64158 Mtetra
.747 .689 .145 r
.5821 .64158 .58291 .63621 .5836 .63068 .58281 .63663 Mtetra
0 0 .144 r
.58281 .63663 .5836 .63068 .58432 .6261 .58354 .63251 Mtetra
.065 0 .38 r
.58354 .63251 .58432 .6261 .58506 .623 .58429 .62969 Mtetra
.336 .163 .493 r
.58429 .62969 .58506 .623 .58584 .62174 .58507 .62852 Mtetra
.482 .287 .539 r
.58507 .62852 .58584 .62174 .58667 .62243 .5859 .62906 Mtetra
.562 .356 .559 r
.5859 .62906 .58667 .62243 .58753 .62489 .58675 .63117 Mtetra
.609 .396 .567 r
.58675 .63117 .58753 .62489 .58842 .62868 .58763 .63446 Mtetra
.637 .418 .569 r
.58763 .63446 .58842 .62868 .58933 .63325 .58853 .63844 Mtetra
.653 .43 .568 r
.58853 .63844 .58933 .63325 .59025 .63804 .58943 .64261 Mtetra
.66 .433 .564 r
.58943 .64261 .59025 .63804 .59116 .64259 .59033 .64656 Mtetra
.659 .427 .557 r
.59033 .64656 .59116 .64259 .59206 .64657 .59122 .65002 Mtetra
.651 .414 .547 r
.59122 .65002 .59206 .64657 .59295 .64982 .5921 .65282 Mtetra
.632 .389 .532 r
.5921 .65282 .59295 .64982 .59383 .65225 .59297 .6549 Mtetra
.598 .348 .509 r
.59297 .6549 .59383 .65225 .59468 .65385 .59382 .65626 Mtetra
.537 .279 .472 r
.59382 .65626 .59468 .65385 .59552 .65467 .59466 .65692 Mtetra
.425 .162 .409 r
.59466 .65692 .59552 .65467 .59635 .65473 .59548 .6569 Mtetra
.208 0 .288 r
.59548 .6569 .59635 .65473 .59715 .65404 .59629 .65623 Mtetra
0 0 .058 r
.59629 .65623 .59715 .65404 .59794 .6526 .59708 .65489 Mtetra
0 0 0 r
.59708 .65489 .59794 .6526 .59872 .65039 .59786 .65287 Mtetra
.877 .857 .404 r
.59786 .65287 .59872 .65039 .59947 .64737 .59862 .65014 Mtetra
.956 .871 .465 r
.59862 .65014 .59947 .64737 .6002 .64353 .59936 .64668 Mtetra
.978 .859 .474 r
.59936 .64668 .6002 .64353 .60092 .63888 .60009 .64251 Mtetra
.98 .846 .455 r
.60009 .64251 .60092 .63888 .60161 .63354 .6008 .63772 Mtetra
.963 .83 .407 r
.6008 .63772 .60161 .63354 .6023 .62772 .6015 .63251 Mtetra
.901 .791 .307 r
.6015 .63251 .6023 .62772 .60298 .62181 .6022 .62721 Mtetra
.712 .662 .111 r
.6022 .62721 .60298 .62181 .60367 .6163 .6029 .62227 Mtetra
0 0 .173 r
.6029 .62227 .60367 .6163 .60438 .61177 .60363 .6182 Mtetra
.092 0 .393 r
.60363 .6182 .60438 .61177 .60512 .60875 .60438 .61547 Mtetra
.349 .174 .497 r
.60438 .61547 .60512 .60875 .60592 .6076 .60518 .61438 Mtetra
.488 .292 .54 r
.60518 .61438 .60592 .6076 .60676 .6084 .60602 .61503 Mtetra
.565 .358 .558 r
.60602 .61503 .60676 .6084 .60765 .61096 .6069 .61723 Mtetra
.611 .396 .566 r
.6069 .61723 .60765 .61096 .60858 .61484 .60782 .6206 Mtetra
.638 .418 .568 r
.60782 .6206 .60858 .61484 .60953 .61946 .60875 .62463 Mtetra
.654 .429 .566 r
.60875 .62463 .60953 .61946 .61048 .62429 .60969 .62883 Mtetra
.66 .432 .562 r
.60969 .62883 .61048 .62429 .61143 .62885 .61062 .6328 Mtetra
.66 .426 .555 r
.61062 .6328 .61143 .62885 .61237 .63284 .61154 .63626 Mtetra
.651 .412 .544 r
.61154 .63626 .61237 .63284 .61329 .63608 .61245 .63906 Mtetra
.631 .386 .529 r
.61245 .63906 .61329 .63608 .61419 .63849 .61334 .64113 Mtetra
.596 .344 .505 r
.61334 .64113 .61419 .63849 .61507 .64008 .61421 .64247 Mtetra
.535 .275 .468 r
.61421 .64247 .61507 .64008 .61592 .64088 .61507 .64311 Mtetra
.421 .156 .404 r
.61507 .64311 .61592 .64088 .61676 .64091 .61591 .64307 Mtetra
.201 0 .282 r
.61591 .64307 .61676 .64091 .61758 .6402 .61673 .64238 Mtetra
0 0 .055 r
.61673 .64238 .61758 .6402 .61838 .63873 .61753 .64102 Mtetra
0 0 0 r
.61753 .64102 .61838 .63873 .61916 .63649 .61831 .63897 Mtetra
.871 .851 .393 r
.61831 .63897 .61916 .63649 .61991 .63343 .61908 .63621 Mtetra
.951 .867 .453 r
.61908 .63621 .61991 .63343 .62064 .62954 .61982 .63271 Mtetra
.974 .856 .461 r
.61982 .63271 .62064 .62954 .62135 .62485 .62054 .6285 Mtetra
.975 .842 .44 r
.62054 .6285 .62135 .62485 .62204 .61946 .62125 .62367 Mtetra
.954 .824 .387 r
.62125 .62367 .62204 .61946 .62271 .61362 .62194 .61844 Mtetra
.881 .777 .28 r
.62194 .61844 .62271 .61362 .62338 .60769 .62263 .61314 Mtetra
0 0 0 r
.62263 .61314 .62338 .60769 .62406 .60221 .62333 .60822 Mtetra
0 0 .202 r
.62333 .60822 .62406 .60221 .62477 .59774 .62405 .6042 Mtetra
.118 0 .406 r
.62405 .6042 .62477 .59774 .62552 .59481 .62481 .60155 Mtetra
.36 .184 .501 r
.62481 .60155 .62552 .59481 .62633 .59377 .62562 .60056 Mtetra
.493 .296 .541 r
.62562 .60056 .62633 .59377 .6272 .59469 .62649 .60132 Mtetra
.568 .36 .558 r
.62649 .60132 .6272 .59469 .62812 .59736 .6274 .60362 Mtetra
.613 .397 .565 r
.6274 .60362 .62812 .59736 .62908 .60132 .62834 .60706 Mtetra
.639 .418 .566 r
.62834 .60706 .62908 .60132 .63007 .60601 .62931 .61115 Mtetra
.654 .429 .565 r
.62931 .61115 .63007 .60601 .63106 .61088 .63029 .61539 Mtetra
.661 .431 .56 r
.63029 .61539 .63106 .61088 .63205 .61546 .63125 .61938 Mtetra
.66 .425 .553 r
.63125 .61938 .63205 .61546 .63302 .61945 .63221 .62285 Mtetra
.651 .41 .542 r
.63221 .62285 .63302 .61945 .63397 .62268 .63315 .62564 Mtetra
.631 .384 .526 r
.63315 .62564 .63397 .62268 .6349 .62509 .63406 .6277 Mtetra
.595 .342 .502 r
.63406 .6277 .6349 .62509 .6358 .62667 .63496 .62903 Mtetra
.532 .271 .465 r
.63496 .62903 .6358 .62667 .63668 .62745 .63583 .62966 Mtetra
.417 .151 .4 r
.63583 .62966 .63668 .62745 .63753 .62746 .63668 .62961 Mtetra
.196 0 .278 r
.63668 .62961 .63753 .62746 .63836 .62673 .63752 .6289 Mtetra
0 0 .055 r
.63752 .6289 .63836 .62673 .63917 .62523 .63833 .62752 Mtetra
0 0 0 r
.63833 .62752 .63917 .62523 .63995 .62295 .63912 .62544 Mtetra
.862 .844 .381 r
.63912 .62544 .63995 .62295 .64071 .61986 .63989 .62265 Mtetra
.945 .862 .439 r
.63989 .62265 .64071 .61986 .64144 .61593 .64063 .61911 Mtetra
.968 .852 .447 r
.64063 .61911 .64144 .61593 .64214 .61119 .64135 .61487 Mtetra
.968 .838 .423 r
.64135 .61487 .64214 .61119 .64282 .60577 .64204 .61001 Mtetra
.942 .816 .366 r
.64204 .61001 .64282 .60577 .64348 .5999 .64273 .60476 Mtetra
.858 .76 .251 r
.64273 .60476 .64348 .5999 .64414 .59397 .64341 .59946 Mtetra
0 0 0 r
.64341 .59946 .64414 .59397 .64481 .58852 .6441 .59457 Mtetra
0 0 .229 r
.6441 .59457 .64481 .58852 .64551 .58411 .64482 .59061 Mtetra
.142 .003 .418 r
.64482 .59061 .64551 .58411 .64627 .58127 .64559 .58804 Mtetra
.372 .193 .505 r
.64559 .58804 .64627 .58127 .6471 .58035 .64642 .58715 Mtetra
.499 .3 .542 r
.64642 .58715 .6471 .58035 .64799 .58139 .64731 .58802 Mtetra
.572 .362 .558 r
.64731 .58802 .64799 .58139 .64894 .58417 .64825 .59042 Mtetra
.615 .398 .564 r
.64825 .59042 .64894 .58417 .64994 .58823 .64923 .59395 Mtetra
.641 .418 .565 r
.64923 .59395 .64994 .58823 .65097 .59299 .65024 .5981 Mtetra
.655 .428 .563 r
.65024 .5981 .65097 .59299 .652 .5979 .65125 .60238 Mtetra
.661 .43 .558 r
.65125 .60238 .652 .5979 .65303 .6025 .65225 .6064 Mtetra
.66 .424 .551 r
.65225 .6064 .65303 .6025 .65404 .6065 .65324 .60987 Mtetra
.651 .409 .54 r
.65324 .60987 .65404 .6065 .65502 .60973 .65421 .61267 Mtetra
.631 .382 .523 r
.65421 .61267 .65502 .60973 .65597 .61213 .65515 .61473 Mtetra
.595 .339 .499 r
.65515 .61473 .65597 .61213 .6569 .6137 .65607 .61605 Mtetra
.531 .268 .461 r
.65607 .61605 .6569 .6137 .6578 .61447 .65696 .61667 Mtetra
.414 .147 .396 r
.65696 .61667 .6578 .61447 .65867 .61447 .65783 .61662 Mtetra
.194 0 .275 r
.65783 .61662 .65867 .61447 .65951 .61372 .65868 .61589 Mtetra
0 0 .057 r
.65868 .61589 .65951 .61372 .66033 .6122 .6595 .61449 Mtetra
0 0 0 r
.6595 .61449 .66033 .6122 .66112 .6099 .6603 .61239 Mtetra
.851 .836 .366 r
.6603 .61239 .66112 .6099 .66188 .60676 .66107 .60957 Mtetra
.937 .856 .424 r
.66107 .60957 .66188 .60676 .6626 .6028 .66181 .606 Mtetra
.961 .847 .43 r
.66181 .606 .6626 .6028 .6633 .59802 .66252 .60172 Mtetra
.959 .832 .404 r
.66252 .60172 .6633 .59802 .66396 .59256 .66321 .59683 Mtetra
.928 .806 .342 r
.66321 .59683 .66396 .59256 .66461 .58666 .66389 .59156 Mtetra
.832 .741 .219 r
.66389 .59156 .66461 .58666 .66526 .58074 .66456 .58627 Mtetra
0 0 0 r
.66456 .58627 .66526 .58074 .66593 .57532 .66525 .58141 Mtetra
0 0 .256 r
.66525 .58141 .66593 .57532 .66663 .57098 .66597 .57751 Mtetra
.166 .023 .429 r
.66597 .57751 .66663 .57098 .6674 .56824 .66675 .57503 Mtetra
.383 .203 .509 r
.66675 .57503 .6674 .56824 .66824 .56743 .6676 .57426 Mtetra
.504 .305 .543 r
.6676 .57426 .66824 .56743 .66916 .5686 .66851 .57524 Mtetra
.575 .364 .557 r
.66851 .57524 .66916 .5686 .67015 .5715 .66948 .57774 Mtetra
.617 .398 .563 r
.66948 .57774 .67015 .5715 .67119 .57565 .6705 .58136 Mtetra
.642 .418 .564 r
.6705 .58136 .67119 .57565 .67226 .58049 .67155 .58558 Mtetra
.656 .428 .561 r
.67155 .58558 .67226 .58049 .67333 .58545 .6726 .58991 Mtetra
.662 .429 .556 r
.6726 .58991 .67333 .58545 .6744 .59008 .67364 .59395 Mtetra
.661 .422 .549 r
.67364 .59395 .6744 .59008 .67545 .5941 .67467 .59744 Mtetra
.651 .407 .537 r
.67467 .59744 .67545 .5941 .67646 .59733 .67566 .60025 Mtetra
.63 .38 .521 r
.67566 .60025 .67646 .59733 .67744 .59973 .67663 .60231 Mtetra
.594 .336 .496 r
.67663 .60231 .67744 .59973 .67839 .60129 .67757 .60363 Mtetra
.53 .265 .458 r
.67757 .60363 .67839 .60129 .67931 .60206 .67849 .60425 Mtetra
.413 .144 .393 r
.67849 .60425 .67931 .60206 .6802 .60205 .67938 .60419 Mtetra
.193 0 .274 r
.67938 .60419 .6802 .60205 .68106 .60128 .68024 .60345 Mtetra
0 0 .063 r
.68024 .60345 .68106 .60128 .68189 .59974 .68107 .60203 Mtetra
0 0 0 r
.68107 .60203 .68189 .59974 .68268 .59741 .68187 .59992 Mtetra
.838 .826 .348 r
.68187 .59992 .68268 .59741 .68344 .59424 .68264 .59706 Mtetra
.926 .849 .407 r
.68264 .59706 .68344 .59424 .68416 .59024 .68338 .59347 Mtetra
.952 .841 .412 r
.68338 .59347 .68416 .59024 .68485 .58542 .68409 .58915 Mtetra
.948 .825 .383 r
.68409 .58915 .68485 .58542 .68551 .57992 .68478 .58424 Mtetra
.911 .794 .316 r
.68478 .58424 .68551 .57992 .68615 .57401 .68545 .57896 Mtetra
.801 .718 .185 r
.68545 .57896 .68615 .57401 .68678 .56809 .68611 .57367 Mtetra
0 0 .035 r
.68611 .57367 .68678 .56809 .68744 .56271 .6868 .56885 Mtetra
0 0 .281 r
.6868 .56885 .68744 .56271 .68815 .55844 .68752 .56501 Mtetra
.189 .043 .439 r
.68752 .56501 .68815 .55844 .68892 .5558 .68831 .56263 Mtetra
.394 .212 .512 r
.68831 .56263 .68892 .5558 .68978 .55512 .68917 .56197 Mtetra
.51 .309 .543 r
.68917 .56197 .68978 .55512 .69073 .55642 .69011 .56306 Mtetra
.578 .366 .557 r
.69011 .56306 .69073 .55642 .69176 .55944 .69112 .56568 Mtetra
.618 .399 .562 r
.69112 .56568 .69176 .55944 .69284 .5637 .69218 .5694 Mtetra
.643 .418 .562 r
.69218 .5694 .69284 .5637 .69395 .56861 .69327 .57369 Mtetra
.657 .427 .56 r
.69327 .57369 .69395 .56861 .69507 .57362 .69436 .57807 Mtetra
.663 .428 .554 r
.69436 .57807 .69507 .57362 .69618 .57829 .69544 .58214 Mtetra
.661 .421 .546 r
.69544 .58214 .69618 .57829 .69727 .58232 .6965 .58565 Mtetra
.651 .406 .535 r
.6965 .58565 .69727 .58232 .69832 .58557 .69753 .58847 Mtetra
.63 .378 .518 r
.69753 .58847 .69832 .58557 .69933 .58797 .69853 .59053 Mtetra
.593 .334 .494 r
.69853 .59053 .69933 .58797 .70031 .58953 .6995 .59186 Mtetra
.529 .262 .455 r
.6995 .59186 .70031 .58953 .70125 .59029 .70043 .59248 Mtetra
.412 .142 .391 r
.70043 .59248 .70125 .59029 .70215 .59027 .70134 .59241 Mtetra
.194 0 .275 r
.70134 .59241 .70215 .59027 .70303 .58949 .70221 .59167 Mtetra
0 0 .071 r
.70221 .59167 .70303 .58949 .70386 .58794 .70306 .59024 Mtetra
0 0 0 r
.70306 .59024 .70386 .58794 .70466 .58558 .70387 .5881 Mtetra
.821 .813 .328 r
.70387 .5881 .70466 .58558 .70542 .58238 .70464 .58523 Mtetra
.914 .84 .386 r
.70464 .58523 .70542 .58238 .70614 .57834 .70538 .5816 Mtetra
.941 .834 .391 r
.70538 .5816 .70614 .57834 .70682 .57348 .70609 .57726 Mtetra
.935 .816 .36 r
.70609 .57726 .70682 .57348 .70747 .56796 .70677 .57232 Mtetra
.891 .78 .287 r
.70677 .57232 .70747 .56796 .7081 .56202 .70742 .56702 Mtetra
.766 .692 .148 r
.70742 .56702 .7081 .56202 .70872 .55611 .70808 .56174 Mtetra
0 0 .073 r
.70808 .56174 .70872 .55611 .70937 .55076 .70876 .55696 Mtetra
0 0 .304 r
.70876 .55696 .70937 .55076 .71008 .54657 .70949 .5532 Mtetra
.212 .061 .448 r
.70949 .5532 .71008 .54657 .71087 .54404 .71029 .55091 Mtetra
.404 .22 .515 r
.71029 .55091 .71087 .54404 .71175 .54349 .71118 .55037 Mtetra
.515 .313 .544 r
.71118 .55037 .71175 .54349 .71273 .54492 .71215 .55159 Mtetra
.581 .367 .556 r
.71215 .55159 .71273 .54492 .7138 .54807 .71319 .55432 Mtetra
.62 .4 .561 r
.71319 .55432 .7138 .54807 .71492 .55244 .71429 .55813 Mtetra
.644 .418 .561 r
.71429 .55813 .71492 .55244 .71608 .55743 .71542 .5625 Mtetra
.658 .427 .558 r
.71542 .5625 .71608 .55743 .71725 .5625 .71656 .56693 Mtetra
.663 .427 .552 r
.71656 .56693 .71725 .5625 .71841 .56721 .71768 .57104 Mtetra
.661 .42 .544 r
.71768 .57104 .71841 .56721 .71953 .57126 .71878 .57458 Mtetra
.651 .404 .532 r
.71878 .57458 .71953 .57126 .72061 .57452 .71985 .57741 Mtetra
.63 .377 .516 r
.71985 .57741 .72061 .57452 .72166 .57692 .72087 .57948 Mtetra
.593 .332 .491 r
.72087 .57948 .72166 .57692 .72266 .57849 .72187 .58082 Mtetra
.528 .26 .453 r
.72187 .58082 .72266 .57849 .72363 .57925 .72282 .58144 Mtetra
.411 .141 .39 r
.72282 .58144 .72363 .57925 .72455 .57923 .72375 .58137 Mtetra
.198 0 .277 r
.72375 .58137 .72455 .57923 .72544 .57843 .72464 .58062 Mtetra
0 0 .082 r
.72464 .58062 .72544 .57843 .72629 .57686 .72549 .57918 Mtetra
0 0 0 r
.72549 .57918 .72629 .57686 .72709 .57448 .72631 .57703 Mtetra
.8 .797 .304 r
.72631 .57703 .72709 .57448 .72785 .57125 .72709 .57413 Mtetra
.898 .829 .363 r
.72709 .57413 .72785 .57125 .72857 .56717 .72783 .57047 Mtetra
.927 .824 .367 r
.72783 .57047 .72857 .56717 .72924 .56228 .72853 .5661 Mtetra
.918 .804 .333 r
.72853 .5661 .72924 .56228 .72988 .55672 .7292 .56114 Mtetra
.866 .762 .255 r
.7292 .56114 .72988 .55672 .7305 .55077 .72985 .55583 Mtetra
.726 .662 .109 r
.72985 .55583 .7305 .55077 .73111 .54487 .7305 .55056 Mtetra
0 0 .11 r
.7305 .55056 .73111 .54487 .73176 .53956 .73118 .54581 Mtetra
0 0 .327 r
.73118 .54581 .73176 .53956 .73247 .53544 .73191 .54212 Mtetra
.233 .079 .457 r
.73191 .54212 .73247 .53544 .73326 .53302 .73273 .53994 Mtetra
.415 .229 .518 r
.73273 .53994 .73326 .53302 .73417 .5326 .73363 .53951 Mtetra
.52 .317 .544 r
.73363 .53951 .73417 .5326 .73518 .53417 .73464 .54086 Mtetra
.583 .369 .556 r
.73464 .54086 .73518 .53417 .73629 .53745 .73572 .54371 Mtetra
.622 .4 .559 r
.73572 .54371 .73629 .53745 .73747 .54193 .73687 .54763 Mtetra
.646 .418 .559 r
.73687 .54763 .73747 .54193 .73868 .54701 .73805 .55208 Mtetra
.659 .426 .556 r
.73805 .55208 .73868 .54701 .7399 .55214 .73923 .55657 Mtetra
.664 .426 .55 r
.73923 .55657 .7399 .55214 .7411 .55688 .74039 .56072 Mtetra
.662 .419 .542 r
.74039 .56072 .7411 .55688 .74226 .56096 .74153 .56428 Mtetra
.651 .402 .53 r
.74153 .56428 .74226 .56096 .74338 .56424 .74263 .56712 Mtetra
.63 .375 .513 r
.74263 .56712 .74338 .56424 .74446 .56665 .74369 .56921 Mtetra
.592 .33 .488 r
.74369 .56921 .74446 .56665 .74549 .56822 .74471 .57055 Mtetra
.527 .258 .451 r
.74471 .57055 .74549 .56822 .74648 .56898 .74569 .57118 Mtetra
.411 .14 .389 r
.74569 .57118 .74648 .56898 .74743 .56895 .74663 .57111 Mtetra
.202 0 .28 r
.74663 .57111 .74743 .56895 .74833 .56815 .74754 .57035 Mtetra
0 0 .095 r
.74754 .57035 .74833 .56815 .74919 .56656 .7484 .5689 Mtetra
0 0 0 r
.7484 .5689 .74919 .56656 .75 .56415 .74923 .56673 Mtetra
.776 .779 .277 r
.74923 .56673 .75 .56415 .75076 .5609 .75001 .56381 Mtetra
.879 .816 .337 r
.75001 .56381 .75076 .5609 .75147 .55678 .75075 .56012 Mtetra
.91 .812 .341 r
.75075 .56012 .75147 .55678 .75214 .55184 .75145 .55572 Mtetra
.898 .79 .304 r
.75145 .55572 .75214 .55184 .75277 .54625 .75211 .55073 Mtetra
.837 .741 .22 r
.75211 .55073 .75277 .54625 .75337 .54028 .75276 .54541 Mtetra
0 0 0 r
.75276 .54541 .75337 .54028 .75398 .53439 .7534 .54015 Mtetra
0 0 .147 r
.7534 .54015 .75398 .53439 .75462 .52912 .75408 .53544 Mtetra
0 0 .347 r
.75408 .53544 .75462 .52912 .75533 .52508 .75482 .53183 Mtetra
.252 .096 .465 r
.75482 .53183 .75533 .52508 .75614 .52278 .75564 .52974 Mtetra
.424 .237 .521 r
.75564 .52974 .75614 .52278 .75707 .52249 .75658 .52944 Mtetra
.525 .32 .545 r
.75658 .52944 .75707 .52249 .75812 .5242 .75761 .53092 Mtetra
.586 .371 .555 r
.75761 .53092 .75812 .5242 .75928 .52761 .75874 .53389 Mtetra
.624 .401 .558 r
.75874 .53389 .75928 .52761 .7605 .5322 .75993 .53791 Mtetra
.647 .418 .558 r
.75993 .53791 .7605 .5322 .76177 .53736 .76116 .54244 Mtetra
.659 .425 .554 r
.76116 .54244 .76177 .53736 .76303 .54256 .76239 .54699 Mtetra
.664 .425 .548 r
.76239 .54699 .76303 .54256 .76428 .54734 .7636 .55118 Mtetra
.662 .417 .54 r
.7636 .55118 .76428 .54734 .76549 .55145 .76478 .55477 Mtetra
.651 .401 .528 r
.76478 .55477 .76549 .55145 .76665 .55474 .76591 .55763 Mtetra
.629 .373 .511 r
.76591 .55763 .76665 .55474 .76776 .55717 .767 .55973 Mtetra
.592 .328 .486 r
.767 .55973 .76776 .55717 .76882 .55874 .76805 .56109 Mtetra
.526 .256 .449 r
.76805 .56109 .76882 .55874 .76984 .5595 .76906 .56171 Mtetra
.412 .14 .388 r
.76906 .56171 .76984 .5595 .7708 .55947 .77002 .56164 Mtetra
.207 0 .284 r
.77002 .56164 .7708 .55947 .77172 .55866 .77094 .56088 Mtetra
0 0 .11 r
.77094 .56088 .77172 .55866 .77259 .55705 .77182 .55942 Mtetra
0 0 0 r
.77182 .55942 .77259 .55705 .77341 .55462 .77266 .55723 Mtetra
.749 .758 .247 r
.77266 .55723 .77341 .55462 .77417 .55132 .77344 .55428 Mtetra
.857 .8 .308 r
.77344 .55428 .77417 .55132 .77488 .54716 .77418 .55056 Mtetra
.889 .797 .312 r
.77418 .55056 .77488 .54716 .77554 .54219 .77487 .54612 Mtetra
.875 .773 .272 r
.77487 .54612 .77554 .54219 .77616 .53656 .77553 .5411 Mtetra
.805 .717 .183 r
.77553 .5411 .77616 .53656 .77675 .53057 .77617 .53577 Mtetra
0 0 0 r
.77617 .53577 .77675 .53057 .77734 .52468 .7768 .53051 Mtetra
0 0 .181 r
.7768 .53051 .77734 .52468 .77798 .51945 .77748 .52585 Mtetra
.009 0 .366 r
.77748 .52585 .77798 .51945 .7787 .51549 .77822 .52231 Mtetra
.271 .111 .473 r
.77822 .52231 .7787 .51549 .77952 .5133 .77907 .52033 Mtetra
.433 .244 .523 r
.77907 .52033 .77952 .5133 .78048 .51314 .78003 .52015 Mtetra
.53 .324 .545 r
.78003 .52015 .78048 .51314 .78157 .515 .7811 .52175 Mtetra
.589 .372 .554 r
.7811 .52175 .78157 .515 .78278 .51854 .78228 .52485 Mtetra
.625 .401 .557 r
.78228 .52485 .78278 .51854 .78405 .52324 .78352 .52897 Mtetra
.647 .417 .556 r
.78352 .52897 .78405 .52324 .78537 .5285 .78479 .53358 Mtetra
.66 .425 .552 r
.78479 .53358 .78537 .5285 .78669 .53375 .78607 .53819 Mtetra
.664 .424 .546 r
.78607 .53819 .78669 .53375 .78799 .53858 .78733 .54242 Mtetra
.662 .416 .538 r
.78733 .54242 .78799 .53858 .78924 .54272 .78855 .54604 Mtetra
.651 .399 .525 r
.78855 .54604 .78924 .54272 .79044 .54603 .78972 .54893 Mtetra
.629 .371 .508 r
.78972 .54893 .79044 .54603 .79159 .54846 .79085 .55104 Mtetra
.59 .326 .484 r
.79085 .55104 .79159 .54846 .79268 .55004 .79193 .5524 Mtetra
.525 .254 .447 r
.79193 .5524 .79268 .55004 .79372 .5508 .79296 .55303 Mtetra
.411 .14 .388 r
.79296 .55303 .79372 .5508 .79471 .55076 .79394 .55296 Mtetra
.212 0 .288 r
.79394 .55296 .79471 .55076 .79564 .54993 .79488 .55219 Mtetra
0 0 .125 r
.79488 .55219 .79564 .54993 .79652 .5483 .79577 .55071 Mtetra
0 0 0 r
.79577 .55071 .79652 .5483 .79735 .54584 .79661 .5485 Mtetra
.719 .734 .216 r
.79661 .5485 .79735 .54584 .79812 .54251 .79741 .54552 Mtetra
.832 .781 .277 r
.79741 .54552 .79812 .54251 .79882 .5383 .79814 .54176 Mtetra
.866 .78 .28 r
.79814 .54176 .79882 .5383 .79947 .53328 .79883 .53729 Mtetra
.848 .753 .238 r
.79883 .53729 .79947 .53328 .80008 .52761 .79948 .53224 Mtetra
.768 .689 .145 r
.79948 .53224 .80008 .52761 .80065 .5216 .80011 .52688 Mtetra
0 0 .013 r
.80011 .52688 .80065 .5216 .80124 .51571 .80074 .52163 Mtetra
0 0 .214 r
.80074 .52163 .80124 .51571 .80187 .51052 .80141 .51701 Mtetra
.042 0 .383 r
.80141 .51701 .80187 .51052 .8026 .50664 .80217 .51353 Mtetra
.288 .126 .479 r
.80217 .51353 .8026 .50664 .80344 .50456 .80303 .51165 Mtetra
.441 .251 .525 r
.80303 .51165 .80344 .50456 .80443 .50454 .80402 .5116 Mtetra
.534 .327 .545 r
.80402 .5116 .80443 .50454 .80556 .50653 .80513 .51334 Mtetra
.591 .373 .553 r
.80513 .51334 .80556 .50653 .80682 .51021 .80635 .51655 Mtetra
.626 .401 .556 r
.80635 .51655 .80682 .51021 .80815 .51502 .80765 .52078 Mtetra
.648 .417 .554 r
.80765 .52078 .80815 .51502 .80953 .52037 .80898 .52547 Mtetra
.66 .424 .551 r
.80898 .52547 .80953 .52037 .8109 .52568 .81031 .53014 Mtetra
.665 .423 .544 r
.81031 .53014 .8109 .52568 .81225 .53056 .81161 .53441 Mtetra
.661 .414 .535 r
.81161 .53441 .81225 .53056 .81355 .53472 .81288 .53806 Mtetra
.65 .397 .523 r
.81288 .53806 .81355 .53472 .81479 .53804 .81409 .54096 Mtetra
.628 .368 .506 r
.81409 .54096 .81479 .53804 .81598 .54049 .81525 .54308 Mtetra
.589 .323 .481 r
.81525 .54308 .81598 .54049 .8171 .54207 .81636 .54445 Mtetra
.524 .252 .445 r
.81636 .54445 .8171 .54207 .81817 .54282 .81741 .54508 Mtetra
.411 .139 .388 r
.81741 .54508 .81817 .54282 .81917 .54278 .81842 .545 Mtetra
.216 0 .293 r
.81842 .545 .81917 .54278 .82013 .54193 .81938 .54422 Mtetra
0 0 .14 r
.81938 .54422 .82013 .54193 .82102 .54028 .82028 .54273 Mtetra
0 0 0 r
.82028 .54273 .82102 .54028 .82185 .53778 .82113 .54049 Mtetra
.687 .708 .183 r
.82113 .54049 .82185 .53778 .82262 .53441 .82193 .53747 Mtetra
.804 .759 .244 r
.82193 .53747 .82262 .53441 .82332 .53015 .82267 .53368 Mtetra
.839 .76 .247 r
.82267 .53368 .82332 .53015 .82396 .52508 .82335 .52916 Mtetra
.817 .73 .202 r
.82335 .52916 .82396 .52508 .82455 .51936 .82399 .52407 Mtetra
.729 .659 .105 r
.82399 .52407 .82455 .51936 .82512 .51332 .82461 .51869 Mtetra
0 0 .053 r
.82461 .51869 .82512 .51332 .8257 .50743 .82523 .51344 Mtetra
0 0 .244 r
.82523 .51344 .8257 .50743 .82632 .50227 .82591 .50885 Mtetra
.072 0 .398 r
.82591 .50885 .82632 .50227 .82705 .49847 .82667 .50545 Mtetra
.303 .139 .485 r
.82667 .50545 .82705 .49847 .82792 .4965 .82755 .50367 Mtetra
.449 .257 .527 r
.82755 .50367 .82792 .4965 .82894 .49661 .82857 .50374 Mtetra
.538 .329 .545 r
.82857 .50374 .82894 .49661 .83012 .49875 .82973 .5056 Mtetra
.593 .374 .553 r
.82973 .5056 .83012 .49875 .83142 .50256 .831 .50894 Mtetra
.627 .401 .554 r
.831 .50894 .83142 .50256 .83282 .50748 .83235 .51327 Mtetra
.649 .416 .553 r
.83235 .51327 .83282 .50748 .83425 .51291 .83373 .51804 Mtetra
.66 .422 .549 r
.83373 .51804 .83425 .51291 .83569 .51829 .83512 .52277 Mtetra
.664 .421 .542 r
.83512 .52277 .83569 .51829 .83709 .52321 .83647 .52708 Mtetra
.661 .412 .533 r
.83647 .52708 .83709 .52321 .83844 .5274 .83778 .53075 Mtetra
.649 .395 .521 r
.83778 .53075 .83844 .5274 .83972 .53073 .83904 .53367 Mtetra
.626 .366 .503 r
.83904 .53367 .83972 .53073 .84094 .53318 .84023 .5358 Mtetra
.587 .32 .479 r
.84023 .5358 .84094 .53318 .8421 .53476 .84137 .53717 Mtetra
.522 .25 .443 r
.84137 .53717 .8421 .53476 .84319 .53551 .84246 .5378 Mtetra
.41 .138 .388 r
.84246 .5378 .84319 .53551 .84422 .53545 .84349 .53771 Mtetra
.22 0 .297 r
.84349 .53771 .84422 .53545 .84519 .53459 .84446 .53692 Mtetra
0 0 .154 r
.84446 .53692 .84519 .53459 .8461 .5329 .84538 .5354 Mtetra
0 0 0 r
.84538 .5354 .8461 .5329 .84694 .53037 .84624 .53313 Mtetra
.84624 .53313 .84694 .53037 .8477 .52694 .84704 .53007 Mtetra
.774 .736 .21 r
.84704 .53007 .8477 .52694 .8484 .52263 .84777 .52623 Mtetra
.809 .737 .212 r
.84777 .52623 .8484 .52263 .84903 .5175 .84845 .52166 Mtetra
.784 .704 .165 r
.84845 .52166 .84903 .5175 .84961 .51173 .84908 .51653 Mtetra
0 0 0 r
.84908 .51653 .84961 .51173 .85017 .50566 .84969 .51112 Mtetra
0 0 .091 r
.84969 .51112 .85017 .50566 .85073 .49976 .85031 .50587 Mtetra
0 0 .271 r
.85031 .50587 .85073 .49976 .85136 .49464 .85099 .50131 Mtetra
.1 0 .411 r
.85099 .50131 .85136 .49464 .85209 .4909 .85176 .49798 Mtetra
.317 .151 .491 r
.85176 .49798 .85209 .4909 .85298 .48904 .85266 .4963 Mtetra
.455 .262 .528 r
.85266 .4963 .85298 .48904 .85404 .48929 .85372 .49649 Mtetra
.541 .332 .545 r
.85372 .49649 .85404 .48929 .85526 .49157 .85492 .49848 Mtetra
.595 .374 .552 r
.85492 .49848 .85526 .49157 .85663 .4955 .85624 .50193 Mtetra
.628 .401 .553 r
.85624 .50193 .85663 .4955 .85808 .50054 .85765 .50636 Mtetra
.649 .415 .551 r
.85765 .50636 .85808 .50054 .85958 .50605 .85909 .51121 Mtetra
.661 .421 .547 r
.85909 .51121 .85958 .50605 .86107 .5115 .86053 .51599 Mtetra
.664 .419 .54 r
.86053 .51599 .86107 .5115 .86253 .51645 .86194 .52034 Mtetra
.66 .41 .531 r
.86194 .52034 .86253 .51645 .86393 .52066 .8633 .52404 Mtetra
.648 .392 .518 r
.8633 .52404 .86393 .52066 .86526 .52401 .86459 .52697 Mtetra
.625 .363 .501 r
.86459 .52697 .86526 .52401 .86652 .52646 .86583 .52911 Mtetra
.585 .317 .477 r
.86583 .52911 .86652 .52646 .86771 .52804 .867 .53047 Mtetra
.519 .247 .442 r
.867 .53047 .86771 .52804 .86883 .52878 .86811 .5311 Mtetra
.408 .137 .388 r
.86811 .5311 .86883 .52878 .86988 .5287 .86916 .531 Mtetra
.222 0 .301 r
.86916 .531 .86988 .5287 .87087 .52781 .87016 .53019 Mtetra
0 0 .168 r
.87016 .53019 .87087 .52781 .87179 .52609 .87109 .52864 Mtetra
0 0 .007 r
.87109 .52864 .87179 .52609 .87263 .52351 .87196 .52633 Mtetra
0 0 0 r
.87196 .52633 .87263 .52351 .8734 .52004 .87276 .52323 Mtetra
.742 .71 .176 r
.87276 .52323 .8734 .52004 .87409 .51566 .87349 .51933 Mtetra
.778 .712 .176 r
.87349 .51933 .87409 .51566 .87471 .51047 .87416 .51471 Mtetra
.748 .676 .127 r
.87416 .51471 .87471 .51047 .87528 .50464 .87479 .50953 Mtetra
0 0 0 r
.87479 .50953 .87528 .50464 .87582 .49852 .87539 .50409 Mtetra
0 0 .127 r
.87539 .50409 .87582 .49852 .87637 .49262 .876 .49884 Mtetra
0 0 .296 r
.876 .49884 .87637 .49262 .877 .48753 .87667 .4943 Mtetra
.126 0 .424 r
.87667 .4943 .877 .48753 .87774 .48386 .87746 .49103 Mtetra
.33 .162 .495 r
.87746 .49103 .87774 .48386 .87865 .48211 .87838 .48945 Mtetra
.462 .267 .53 r
.87838 .48945 .87865 .48211 .87975 .48248 .87947 .48976 Mtetra
.544 .334 .545 r
.87947 .48976 .87975 .48248 .88102 .4849 .88072 .49187 Mtetra
.596 .375 .551 r
.88072 .49187 .88102 .4849 .88244 .48897 .8821 .49544 Mtetra
.629 .4 .552 r
.8821 .49544 .88244 .48897 .88396 .49411 .88357 .49997 Mtetra
.649 .414 .549 r
.88357 .49997 .88396 .49411 .88552 .49971 .88507 .5049 Mtetra
.66 .42 .545 r
.88507 .5049 .88552 .49971 .88708 .50521 .88657 .50973 Mtetra
.664 .418 .538 r
.88657 .50973 .88708 .50521 .8886 .5102 .88803 .51412 Mtetra
.659 .408 .528 r
.88803 .51412 .8886 .5102 .89005 .51443 .88944 .51783 Mtetra
.647 .389 .516 r
.88944 .51783 .89005 .51443 .89142 .51779 .89078 .52077 Mtetra
.623 .36 .498 r
.89078 .52077 .89142 .51779 .89272 .52024 .89205 .52292 Mtetra
.583 .314 .474 r
.89205 .52292 .89272 .52024 .89395 .52181 .89326 .52428 Mtetra
.516 .244 .44 r
.89326 .52428 .89395 .52181 .8951 .52254 .8944 .52489 Mtetra
.405 .135 .388 r
.8944 .52489 .8951 .52254 .89617 .52244 .89547 .52478 Mtetra
.224 0 .305 r
.89547 .52478 .89617 .52244 .89718 .52152 .89648 .52394 Mtetra
0 0 .18 r
.89648 .52394 .89718 .52152 .89811 .51976 .89743 .52236 Mtetra
0 0 .032 r
.89743 .52236 .89811 .51976 .89896 .51713 .89831 .52001 Mtetra
0 0 0 r
.89831 .52001 .89896 .51713 .89973 .51359 .89911 .51685 Mtetra
.709 .683 .142 r
.89911 .51685 .89973 .51359 .90041 .50915 .89984 .5129 Mtetra
.744 .686 .141 r
.89984 .5129 .90041 .50915 .90102 .50389 .90051 .50822 Mtetra
.71 .647 .09 r
.90051 .50822 .90102 .50389 .90157 .498 .90112 .50299 Mtetra
0 0 .013 r
.90112 .50299 .90157 .498 .9021 .49184 .90171 .49751 Mtetra
0 0 .161 r
.90171 .49751 .9021 .49184 .90264 .48592 .90232 .49225 Mtetra
0 0 .318 r
.90232 .49225 .90264 .48592 .90326 .48085 .90299 .48774 Mtetra
.149 .019 .434 r
.90299 .48774 .90326 .48085 .90402 .47726 .90379 .48453 Mtetra
.342 .171 .5 r
.90379 .48453 .90402 .47726 .90495 .47561 .90474 .48304 Mtetra
.467 .272 .531 r
.90474 .48304 .90495 .47561 .90609 .47611 .90587 .48347 Mtetra
.547 .335 .545 r
.90587 .48347 .90609 .47611 .90742 .47867 .90717 .4857 Mtetra
.598 .375 .55 r
.90717 .4857 .90742 .47867 .9089 .48286 .9086 .48939 Mtetra
.63 .4 .55 r
.9086 .48939 .9089 .48286 .91049 .48811 .91013 .49401 Mtetra
.65 .413 .547 r
.91013 .49401 .91049 .48811 .91212 .49379 .9117 .49901 Mtetra
.66 .418 .543 r
.9117 .49901 .91212 .49379 .91374 .49935 .91326 .5039 Mtetra
.663 .416 .536 r
.91326 .5039 .91374 .49935 .91531 .50437 .91478 .50832 Mtetra
.658 .405 .526 r
.91478 .50832 .91531 .50437 .91682 .50862 .91623 .51205 Mtetra
.645 .387 .513 r
.91623 .51205 .91682 .50862 .91824 .51199 .91762 .515 Mtetra
.621 .356 .496 r
.91762 .515 .91824 .51199 .91958 .51444 .91893 .51714 Mtetra
.58 .31 .472 r
.91893 .51714 .91958 .51444 .92084 .516 .92017 .51849 Mtetra
.513 .24 .438 r
.92017 .51849 .92084 .516 .92202 .51671 .92134 .51909 Mtetra
.402 .133 .387 r
.92134 .51909 .92202 .51671 .92312 .51658 .92244 .51896 Mtetra
.224 0 .309 r
.92244 .51896 .92312 .51658 .92414 .51563 .92347 .51809 Mtetra
0 0 .192 r
.92347 .51809 .92414 .51563 .92509 .51383 .92443 .51648 Mtetra
0 0 .054 r
.92443 .51648 .92509 .51383 .92594 .51114 .92531 .51408 Mtetra
0 0 0 r
.92531 .51408 .92594 .51114 .92671 .50753 .92612 .51087 Mtetra
.92612 .51087 .92671 .50753 .92739 .50302 .92685 .50685 Mtetra
.709 .658 .105 r
.92685 .50685 .92739 .50302 .92798 .49768 .92751 .5021 Mtetra
0 0 0 r
.92751 .5021 .92798 .49768 .92852 .49172 .92811 .49681 Mtetra
0 0 .05 r
.92811 .49681 .92852 .49172 .92903 .48551 .92869 .49129 Mtetra
0 0 .193 r
.92869 .49129 .92903 .48551 .92956 .47957 .92929 .48601 Mtetra
0 0 .338 r
.92929 .48601 .92956 .47957 .93018 .47453 .92996 .48153 Mtetra
.17 .036 .444 r
.92996 .48153 .93018 .47453 .93095 .471 .93077 .47838 Mtetra
.353 .18 .503 r
.93077 .47838 .93095 .471 .93191 .46946 .93175 .47699 Mtetra
.473 .276 .532 r
.93175 .47699 .93191 .46946 .93309 .47009 .93292 .47753 Mtetra
.549 .337 .544 r
.93292 .47753 .93309 .47009 .93447 .47278 .93427 .47988 Mtetra
.599 .375 .549 r
.93427 .47988 .93447 .47278 .93602 .4771 .93577 .48368 Mtetra
.63 .399 .548 r
.93577 .48368 .93602 .4771 .93768 .48246 .93736 .4884 Mtetra
.65 .412 .545 r
.93736 .4884 .93768 .48246 .93938 .48822 .939 .49347 Mtetra
.66 .416 .54 r
.939 .49347 .93938 .48822 .94107 .49383 .94062 .49841 Mtetra
.662 .413 .533 r
.94062 .49841 .94107 .49383 .9427 .49888 .94219 .50286 Mtetra
.657 .403 .523 r
.94219 .50286 .9427 .49888 .94426 .50315 .9437 .50661 Mtetra
.643 .383 .51 r
.9437 .50661 .94426 .50315 .94574 .50652 .94514 .50956 Mtetra
.618 .353 .493 r
.94514 .50956 .94574 .50652 .94712 .50896 .94649 .5117 Mtetra
.577 .306 .469 r
.94649 .5117 .94712 .50896 .94842 .51051 .94776 .51304 Mtetra
.509 .236 .436 r
.94776 .51304 .94842 .51051 .94962 .5112 .94896 .51362 Mtetra
.399 .131 .387 r
.94896 .51362 .94962 .5112 .95075 .51104 .95009 .51346 Mtetra
.224 0 .312 r
.95009 .51346 .95075 .51104 .95179 .51005 .95114 .51257 Mtetra
0 0 .203 r
.95114 .51257 .95179 .51005 .95274 .5082 .95211 .51091 Mtetra
0 0 .076 r
.95211 .51091 .95274 .5082 .9536 .50545 .953 .50845 Mtetra
0 0 0 r
.953 .50845 .9536 .50545 .95437 .50177 .95381 .50518 Mtetra
.95381 .50518 .95437 .50177 .95504 .49718 .95454 .5011 Mtetra
.95454 .5011 .95504 .49718 .95562 .49176 .95518 .49628 Mtetra
.95518 .49628 .95562 .49176 .95614 .48573 .95577 .49092 Mtetra
0 0 .085 r
.95577 .49092 .95614 .48573 .95663 .47947 .95634 .48536 Mtetra
0 0 .222 r
.95634 .48536 .95663 .47947 .95715 .47351 .95693 .48006 Mtetra
0 0 .357 r
.95693 .48006 .95715 .47351 .95777 .46849 .95761 .47559 Mtetra
.19 .053 .453 r
.95761 .47559 .95777 .46849 .95855 .46502 .95843 .47251 Mtetra
.363 .189 .507 r
.95843 .47251 .95855 .46502 .95954 .46358 .95944 .47121 Mtetra
.477 .28 .533 r
.95944 .47121 .95954 .46358 .96077 .46435 .96066 .47186 Mtetra
.552 .338 .544 r
.96066 .47186 .96077 .46435 .96221 .46717 .96206 .47434 Mtetra
.6 .375 .547 r
.96206 .47434 .96221 .46717 .96383 .47161 .96363 .47825 Mtetra
.631 .398 .547 r
.96363 .47825 .96383 .47161 .96556 .47707 .96529 .48306 Mtetra
.65 .41 .544 r
.96529 .48306 .96556 .47707 .96733 .48291 .96699 .4882 Mtetra
.659 .414 .538 r
.96699 .4882 .96733 .48291 .96909 .48857 .96867 .49319 Mtetra
.661 .411 .531 r
.96867 .49319 .96909 .48857 .97079 .49366 .97031 .49766 Mtetra
.656 .4 .521 r
.97031 .49766 .97079 .49366 .97241 .49794 .97187 .50142 Mtetra
.642 .38 .508 r
.97187 .50142 .97241 .49794 .97393 .50131 .97335 .50438 Mtetra
.616 .349 .49 r
.97335 .50438 .97393 .50131 .97536 .50374 .97475 .50651 Mtetra
.573 .302 .467 r
.97475 .50651 .97536 .50374 .97669 .50527 .97606 .50784 Mtetra
.505 .232 .434 r
.97606 .50784 .97669 .50527 .97793 .50594 .97729 .5084 Mtetra
.395 .128 .386 r
.97729 .5084 .97793 .50594 .97908 .50575 .97844 .50822 Mtetra
.223 0 .315 r
.97844 .50822 .97908 .50575 .98014 .50471 .97951 .50728 Mtetra
0 0 .213 r
.97951 .50728 .98014 .50471 .9811 .50281 .9805 .50557 Mtetra
0 0 .096 r
.9805 .50557 .9811 .50281 .98197 .49999 .9814 .50306 Mtetra
0 0 .002 r
.9814 .50306 .98197 .49999 .98273 .49624 .98221 .49972 Mtetra
0 0 0 r
.98221 .49972 .98273 .49624 .98339 .49156 .98292 .49557 Mtetra
.98292 .49557 .98339 .49156 .98396 .48606 .98356 .49067 Mtetra
0 0 .02 r
.98356 .49067 .98396 .48606 .98446 .47995 .98414 .48525 Mtetra
0 0 .119 r
.98414 .48525 .98446 .47995 .98493 .47363 .98469 .47963 Mtetra
0 0 .249 r
.98469 .47963 .98493 .47363 .98544 .46765 .98528 .47432 Mtetra
0 0 .373 r
.98528 .47432 .98544 .46765 .98606 .46265 .98596 .46987 Mtetra
.207 .068 .461 r
.98596 .46987 .98606 .46265 .98685 .45925 .9868 .46684 Mtetra
.372 .196 .509 r
.9868 .46684 .98685 .45925 .98788 .45791 .98784 .46563 Mtetra
.459 .261 .523 r
.52576 .67759 .52663 .67197 .5274 .67224 .52653 .67777 Mtetra
.555 .345 .551 r
.52653 .67777 .5274 .67224 .52818 .67409 .52731 .67935 Mtetra
.608 .391 .562 r
.52731 .67935 .52818 .67409 .52897 .67716 .5281 .68202 Mtetra
.638 .417 .566 r
.5281 .68202 .52897 .67716 .52977 .68099 .5289 .68536 Mtetra
.655 .43 .566 r
.5289 .68536 .52977 .68099 .53058 .68508 .5297 .68894 Mtetra
.663 .434 .562 r
.5297 .68894 .53058 .68508 .53139 .68902 .5305 .69237 Mtetra
.663 .429 .554 r
.5305 .69237 .53139 .68902 .53219 .69249 .5313 .6954 Mtetra
.655 .415 .543 r
.5313 .6954 .53219 .69249 .53299 .69533 .5321 .69786 Mtetra
.637 .389 .526 r
.5321 .69786 .53299 .69533 .53379 .69747 .53289 .69969 Mtetra
.603 .345 .499 r
.53289 .69969 .53379 .69747 .53458 .69889 .53368 .70089 Mtetra
.54 .27 .455 r
.53368 .70089 .53458 .69889 .53536 .69961 .53446 .70146 Mtetra
.419 .137 .376 r
.53446 .70146 .53536 .69961 .53614 .69967 .53524 .70145 Mtetra
.167 0 .216 r
.53524 .70145 .53614 .69967 .53691 .69907 .53601 .70086 Mtetra
0 0 0 r
.53601 .70086 .53691 .69907 .53768 .69783 .53678 .69969 Mtetra
.767 .853 .407 r
.53678 .69969 .53768 .69783 .53844 .69591 .53754 .69792 Mtetra
.942 .914 .537 r
.53754 .69792 .53844 .69591 .53919 .6933 .5383 .69553 Mtetra
.985 .895 .567 r
.5383 .69553 .53919 .6933 .53994 .68997 .53905 .69251 Mtetra
.994 .872 .564 r
.53905 .69251 .53994 .68997 .54067 .68593 .53979 .68885 Mtetra
.997 .859 .547 r
.53979 .68885 .54067 .68593 .5414 .68126 .54053 .68464 Mtetra
.995 .854 .514 r
.54053 .68464 .5414 .68126 .54213 .67614 .54126 .68002 Mtetra
.976 .847 .451 r
.54126 .68002 .54213 .67614 .54285 .67087 .54198 .67527 Mtetra
.885 .798 .311 r
.54198 .67527 .54285 .67087 .54357 .66589 .54271 .67077 Mtetra
0 0 0 r
.54271 .67077 .54357 .66589 .5443 .66169 .54345 .66697 Mtetra
0 0 .295 r
.54345 .66697 .5443 .66169 .54505 .65874 .5442 .66428 Mtetra
.288 .112 .46 r
.5442 .66428 .54505 .65874 .54581 .65738 .54497 .66301 Mtetra
.466 .266 .525 r
.54497 .66301 .54581 .65738 .5466 .65774 .54575 .66327 Mtetra
.558 .347 .551 r
.54575 .66327 .5466 .65774 .5474 .65967 .54655 .66492 Mtetra
.609 .392 .561 r
.54655 .66492 .5474 .65967 .54822 .66282 .54737 .66765 Mtetra
.639 .417 .565 r
.54737 .66765 .54822 .66282 .54905 .66669 .5482 .67104 Mtetra
.656 .429 .564 r
.5482 .67104 .54905 .66669 .54989 .67081 .54903 .67464 Mtetra
.664 .433 .56 r
.54903 .67464 .54989 .67081 .55073 .67475 .54986 .67807 Mtetra
.663 .427 .552 r
.54986 .67807 .55073 .67475 .55156 .67821 .55068 .68109 Mtetra
.655 .413 .54 r
.55068 .68109 .55156 .67821 .55239 .68104 .5515 .68354 Mtetra
.636 .386 .522 r
.5515 .68354 .55239 .68104 .55321 .68315 .55232 .68535 Mtetra
.601 .341 .495 r
.55232 .68535 .55321 .68315 .55401 .68455 .55312 .68653 Mtetra
.536 .264 .45 r
.55312 .68653 .55401 .68455 .55482 .68525 .55392 .68708 Mtetra
.411 .127 .369 r
.55392 .68708 .55482 .68525 .55561 .68528 .55472 .68704 Mtetra
.153 0 .205 r
.55472 .68704 .55561 .68528 .55639 .68465 .5555 .68643 Mtetra
0 0 0 r
.5555 .68643 .55639 .68465 .55717 .68338 .55628 .68523 Mtetra
.771 .854 .408 r
.55628 .68523 .55717 .68338 .55794 .68142 .55705 .68343 Mtetra
.941 .912 .532 r
.55705 .68343 .55794 .68142 .55869 .67877 .55781 .68101 Mtetra
.984 .894 .56 r
.55781 .68101 .55869 .67877 .55944 .67539 .55856 .67794 Mtetra
.994 .872 .557 r
.55856 .67794 .55944 .67539 .56017 .67131 .5593 .67424 Mtetra
.996 .859 .538 r
.5593 .67424 .56017 .67131 .56089 .66659 .56003 .66999 Mtetra
.993 .853 .502 r
.56003 .66999 .56089 .66659 .56161 .66144 .56076 .66534 Mtetra
.969 .843 .433 r
.56076 .66534 .56161 .66144 .56232 .65616 .56148 .66058 Mtetra
.862 .782 .283 r
.56148 .66058 .56232 .65616 .56304 .65119 .5622 .6561 Mtetra
0 0 .01 r
.5622 .6561 .56304 .65119 .56377 .64703 .56294 .65233 Mtetra
0 0 .314 r
.56294 .65233 .56377 .64703 .56452 .64414 .56369 .6497 Mtetra
.302 .125 .466 r
.56369 .6497 .56452 .64414 .56529 .64288 .56447 .64851 Mtetra
.472 .271 .526 r
.56447 .64851 .56529 .64288 .56609 .64333 .56527 .64885 Mtetra
.561 .349 .55 r
.56527 .64885 .56609 .64333 .56692 .64535 .56609 .65058 Mtetra
.611 .393 .56 r
.56609 .65058 .56692 .64535 .56777 .64856 .56694 .65338 Mtetra
.64 .417 .563 r
.56694 .65338 .56777 .64856 .56863 .65249 .56779 .6568 Mtetra
.657 .429 .562 r
.56779 .6568 .56863 .65249 .5695 .65663 .56865 .66042 Mtetra
.664 .431 .558 r
.56865 .66042 .5695 .65663 .57037 .66057 .56951 .66387 Mtetra
.664 .426 .55 r
.56951 .66387 .57037 .66057 .57123 .66403 .57037 .66688 Mtetra
.655 .41 .538 r
.57037 .66688 .57123 .66403 .57209 .66685 .57121 .66932 Mtetra
.635 .383 .519 r
.57121 .66932 .57209 .66685 .57293 .66894 .57205 .67112 Mtetra
.599 .337 .491 r
.57205 .67112 .57293 .66894 .57376 .67031 .57288 .67227 Mtetra
.533 .259 .445 r
.57288 .67227 .57376 .67031 .57458 .67099 .57369 .67281 Mtetra
.405 .118 .361 r
.57369 .67281 .57458 .67099 .57539 .671 .5745 .67275 Mtetra
.14 0 .195 r
.5745 .67275 .57539 .671 .57618 .67035 .5753 .67211 Mtetra
0 0 0 r
.5753 .67211 .57618 .67035 .57697 .66904 .57608 .67088 Mtetra
.773 .853 .407 r
.57608 .67088 .57697 .66904 .57774 .66705 .57686 .66905 Mtetra
.94 .91 .526 r
.57686 .66905 .57774 .66705 .5785 .66436 .57762 .6666 Mtetra
.983 .893 .553 r
.57762 .6666 .5785 .66436 .57924 .66094 .57837 .66349 Mtetra
.993 .872 .549 r
.57837 .66349 .57924 .66094 .57997 .65681 .57911 .65976 Mtetra
.996 .859 .528 r
.57911 .65976 .57997 .65681 .58069 .65205 .57984 .65547 Mtetra
.99 .852 .49 r
.57984 .65547 .58069 .65205 .5814 .64687 .58056 .6508 Mtetra
.961 .838 .415 r
.58056 .6508 .5814 .64687 .5821 .64158 .58128 .64603 Mtetra
.837 .765 .253 r
.58128 .64603 .5821 .64158 .58281 .63663 .582 .64156 Mtetra
0 0 .044 r
.582 .64156 .58281 .63663 .58354 .63251 .58273 .63783 Mtetra
.003 0 .331 r
.58273 .63783 .58354 .63251 .58429 .62969 .58349 .63526 Mtetra
.317 .137 .472 r
.58349 .63526 .58429 .62969 .58507 .62852 .58428 .63415 Mtetra
.478 .277 .527 r
.58428 .63415 .58507 .62852 .5859 .62906 .5851 .63458 Mtetra
.564 .351 .55 r
.5851 .63458 .5859 .62906 .58675 .63117 .58595 .63639 Mtetra
.613 .393 .559 r
.58595 .63639 .58675 .63117 .58763 .63446 .58682 .63925 Mtetra
.642 .417 .562 r
.58682 .63925 .58763 .63446 .58853 .63844 .58771 .64273 Mtetra
.658 .428 .561 r
.58771 .64273 .58853 .63844 .58943 .64261 .5886 .64637 Mtetra
.665 .43 .556 r
.5886 .64637 .58943 .64261 .59033 .64656 .58949 .64983 Mtetra
.664 .424 .547 r
.58949 .64983 .59033 .64656 .59122 .65002 .59037 .65284 Mtetra
.655 .409 .535 r
.59037 .65284 .59122 .65002 .5921 .65282 .59124 .65527 Mtetra
.635 .38 .516 r
.59124 .65527 .5921 .65282 .59297 .6549 .5921 .65705 Mtetra
.598 .333 .487 r
.5921 .65705 .59297 .6549 .59382 .65626 .59295 .6582 Mtetra
.53 .253 .44 r
.59295 .6582 .59382 .65626 .59466 .65692 .59378 .65872 Mtetra
.399 .11 .355 r
.59378 .65872 .59466 .65692 .59548 .6569 .5946 .65864 Mtetra
.13 0 .186 r
.5946 .65864 .59548 .6569 .59629 .65623 .59541 .65798 Mtetra
0 0 0 r
.59541 .65798 .59629 .65623 .59708 .65489 .5962 .65673 Mtetra
.772 .852 .404 r
.5962 .65673 .59708 .65489 .59786 .65287 .59699 .65487 Mtetra
.937 .908 .52 r
.59699 .65487 .59786 .65287 .59862 .65014 .59775 .65238 Mtetra
.981 .892 .545 r
.59775 .65238 .59862 .65014 .59936 .64668 .59851 .64924 Mtetra
.992 .871 .54 r
.59851 .64924 .59936 .64668 .60009 .64251 .59924 .64547 Mtetra
.994 .858 .518 r
.59924 .64547 .60009 .64251 .6008 .63772 .59997 .64115 Mtetra
.987 .85 .476 r
.59997 .64115 .6008 .63772 .6015 .63251 .60068 .63646 Mtetra
.95 .831 .394 r
.60068 .63646 .6015 .63251 .6022 .62721 .60139 .63168 Mtetra
.809 .744 .222 r
.60139 .63168 .6022 .62721 .6029 .62227 .60211 .62723 Mtetra
0 0 .078 r
.60211 .62723 .6029 .62227 .60363 .6182 .60285 .62354 Mtetra
.034 0 .348 r
.60285 .62354 .60363 .6182 .60438 .61547 .60361 .62105 Mtetra
.331 .149 .477 r
.60361 .62105 .60438 .61547 .60518 .61438 .60441 .62002 Mtetra
.485 .282 .529 r
.60441 .62002 .60518 .61438 .60602 .61503 .60525 .62054 Mtetra
.568 .354 .55 r
.60525 .62054 .60602 .61503 .6069 .61723 .60612 .62243 Mtetra
.615 .394 .558 r
.60612 .62243 .6069 .61723 .60782 .6206 .60702 .62537 Mtetra
.643 .417 .561 r
.60702 .62537 .60782 .6206 .60875 .62463 .60794 .62889 Mtetra
.658 .428 .559 r
.60794 .62889 .60875 .62463 .60969 .62883 .60887 .63257 Mtetra
.665 .43 .554 r
.60887 .63257 .60969 .62883 .61062 .6328 .60979 .63604 Mtetra
.664 .423 .545 r
.60979 .63604 .61062 .6328 .61154 .63626 .6107 .63905 Mtetra
.655 .407 .532 r
.6107 .63905 .61154 .63626 .61245 .63906 .6116 .64148 Mtetra
.634 .378 .513 r
.6116 .64148 .61245 .63906 .61334 .64113 .61248 .64325 Mtetra
.596 .33 .483 r
.61248 .64325 .61334 .64113 .61421 .64247 .61335 .64438 Mtetra
.527 .248 .435 r
.61335 .64438 .61421 .64247 .61507 .64311 .6142 .64489 Mtetra
.393 .103 .348 r
.6142 .64489 .61507 .64311 .61591 .64307 .61504 .6448 Mtetra
.122 0 .178 r
.61504 .6448 .61591 .64307 .61673 .64238 .61586 .64412 Mtetra
0 0 0 r
.61586 .64412 .61673 .64238 .61753 .64102 .61666 .64285 Mtetra
.769 .849 .399 r
.61666 .64285 .61753 .64102 .61831 .63897 .61745 .64097 Mtetra
.934 .905 .512 r
.61745 .64097 .61831 .63897 .61908 .63621 .61822 .63845 Mtetra
.979 .891 .537 r
.61822 .63845 .61908 .63621 .61982 .63271 .61898 .63528 Mtetra
.991 .871 .53 r
.61898 .63528 .61982 .63271 .62054 .6285 .61971 .63148 Mtetra
.992 .858 .506 r
.61971 .63148 .62054 .6285 .62125 .62367 .62043 .62712 Mtetra
.982 .847 .461 r
.62043 .62712 .62125 .62367 .62194 .61844 .62114 .62241 Mtetra
.937 .823 .372 r
.62114 .62241 .62194 .61844 .62263 .61314 .62184 .61764 Mtetra
.776 .72 .188 r
.62184 .61764 .62263 .61314 .62333 .60822 .62256 .6132 Mtetra
0 0 .112 r
.62256 .6132 .62333 .60822 .62405 .6042 .62329 .60957 Mtetra
.065 0 .364 r
.62329 .60957 .62405 .6042 .62481 .60155 .62406 .60714 Mtetra
.344 .16 .482 r
.62406 .60714 .62481 .60155 .62562 .60056 .62488 .60621 Mtetra
.491 .287 .53 r
.62488 .60621 .62562 .60056 .62649 .60132 .62574 .60682 Mtetra
.571 .356 .549 r
.62574 .60682 .62649 .60132 .6274 .60362 .62664 .6088 Mtetra
.617 .395 .557 r
.62664 .6088 .6274 .60362 .62834 .60706 .62757 .61181 Mtetra
.644 .417 .559 r
.62757 .61181 .62834 .60706 .62931 .61115 .62853 .61539 Mtetra
.659 .427 .557 r
.62853 .61539 .62931 .61115 .63029 .61539 .62948 .6191 Mtetra
.666 .429 .552 r
.62948 .6191 .63029 .61539 .63125 .61938 .63044 .62259 Mtetra
.665 .422 .543 r
.63044 .62259 .63125 .61938 .63221 .62285 .63138 .62561 Mtetra
.655 .405 .529 r
.63138 .62561 .63221 .62285 .63315 .62564 .6323 .62803 Mtetra
.634 .376 .509 r
.6323 .62803 .63315 .62564 .63406 .6277 .63321 .6298 Mtetra
.596 .327 .479 r
.63321 .6298 .63406 .6277 .63496 .62903 .6341 .63093 Mtetra
.525 .244 .43 r
.6341 .63093 .63496 .62903 .63583 .62966 .63497 .63143 Mtetra
.39 .097 .343 r
.63497 .63143 .63583 .62966 .63668 .62961 .63582 .63133 Mtetra
.116 0 .172 r
.63582 .63133 .63668 .62961 .63752 .6289 .63665 .63063 Mtetra
0 0 0 r
.63665 .63063 .63752 .6289 .63833 .62752 .63747 .62935 Mtetra
.764 .844 .392 r
.63747 .62935 .63833 .62752 .63912 .62544 .63827 .62744 Mtetra
.929 .902 .502 r
.63827 .62744 .63912 .62544 .63989 .62265 .63904 .6249 Mtetra
.976 .889 .527 r
.63904 .6249 .63989 .62265 .64063 .61911 .6398 .6217 Mtetra
.989 .87 .519 r
.6398 .6217 .64063 .61911 .64135 .61487 .64053 .61786 Mtetra
.989 .856 .493 r
.64053 .61786 .64135 .61487 .64204 .61001 .64124 .61349 Mtetra
.975 .844 .444 r
.64124 .61349 .64204 .61001 .64273 .60476 .64195 .60876 Mtetra
.921 .812 .347 r
.64195 .60876 .64273 .60476 .64341 .59946 .64265 .60398 Mtetra
.74 .693 .152 r
.64265 .60398 .64341 .59946 .6441 .59457 .64336 .59958 Mtetra
0 0 .145 r
.64336 .59958 .6441 .59457 .64482 .59061 .64409 .59599 Mtetra
.094 0 .379 r
.64409 .59599 .64482 .59061 .64559 .58804 .64487 .59365 Mtetra
.357 .172 .487 r
.64487 .59365 .64559 .58804 .64642 .58715 .6457 .59281 Mtetra
.497 .291 .531 r
.6457 .59281 .64642 .58715 .64731 .58802 .64659 .59352 Mtetra
.574 .358 .549 r
.64659 .59352 .64731 .58802 .64825 .59042 .64752 .5956 Mtetra
.619 .396 .556 r
.64752 .5956 .64825 .59042 .64923 .59395 .64848 .59868 Mtetra
.646 .417 .558 r
.64848 .59868 .64923 .59395 .65024 .5981 .64947 .60232 Mtetra
.66 .427 .555 r
.64947 .60232 .65024 .5981 .65125 .60238 .65046 .60607 Mtetra
.667 .428 .549 r
.65046 .60607 .65125 .60238 .65225 .6064 .65145 .60958 Mtetra
.665 .42 .54 r
.65145 .60958 .65225 .6064 .65324 .60987 .65242 .61261 Mtetra
.655 .403 .527 r
.65242 .61261 .65324 .60987 .65421 .61267 .65338 .61504 Mtetra
.634 .373 .506 r
.65338 .61504 .65421 .61267 .65515 .61473 .65431 .61681 Mtetra
.595 .324 .476 r
.65431 .61681 .65515 .61473 .65607 .61605 .65522 .61793 Mtetra
.524 .24 .426 r
.65522 .61793 .65607 .61605 .65696 .61667 .65611 .61843 Mtetra
.387 .092 .338 r
.65611 .61843 .65696 .61667 .65783 .61662 .65698 .61832 Mtetra
.114 0 .169 r
.65698 .61832 .65783 .61662 .65868 .61589 .65782 .61762 Mtetra
0 0 0 r
.65782 .61762 .65868 .61589 .6595 .61449 .65865 .61632 Mtetra
.754 .837 .381 r
.65865 .61632 .6595 .61449 .6603 .61239 .65945 .61439 Mtetra
.922 .897 .49 r
.65945 .61439 .6603 .61239 .66107 .60957 .66023 .61183 Mtetra
.972 .887 .515 r
.66023 .61183 .66107 .60957 .66181 .606 .66099 .6086 Mtetra
.985 .869 .507 r
.66099 .6086 .66181 .606 .66252 .60172 .66172 .60474 Mtetra
.985 .854 .479 r
.66172 .60474 .66252 .60172 .66321 .59683 .66243 .60034 Mtetra
.967 .839 .425 r
.66243 .60034 .66321 .59683 .66389 .59156 .66313 .5956 Mtetra
.901 .799 .319 r
.66313 .5956 .66389 .59156 .66456 .58627 .66382 .59083 Mtetra
.699 .663 .114 r
.66382 .59083 .66456 .58627 .66525 .58141 .66453 .58645 Mtetra
0 0 .177 r
.66453 .58645 .66525 .58141 .66597 .57751 .66527 .58293 Mtetra
.123 0 .393 r
.66527 .58293 .66597 .57751 .66675 .57503 .66606 .58066 Mtetra
.37 .183 .491 r
.66606 .58066 .66675 .57503 .6676 .57426 .66691 .57992 Mtetra
.503 .296 .532 r
.66691 .57992 .6676 .57426 .66851 .57524 .66781 .58074 Mtetra
.578 .36 .549 r
.66781 .58074 .66851 .57524 .66948 .57774 .66877 .58291 Mtetra
.621 .397 .555 r
.66877 .58291 .66948 .57774 .6705 .58136 .66978 .58608 Mtetra
.647 .417 .556 r
.66978 .58608 .6705 .58136 .67155 .58558 .6708 .58978 Mtetra
.661 .426 .553 r
.6708 .58978 .67155 .58558 .6726 .58991 .67183 .59357 Mtetra
.667 .427 .547 r
.67183 .59357 .6726 .58991 .67364 .59395 .67285 .59711 Mtetra
.666 .419 .538 r
.67285 .59711 .67364 .59395 .67467 .59744 .67386 .60016 Mtetra
.656 .402 .524 r
.67386 .60016 .67467 .59744 .67566 .60025 .67484 .6026 Mtetra
.634 .371 .503 r
.67484 .6026 .67566 .60025 .67663 .60231 .6758 .60437 Mtetra
.595 .321 .472 r
.6758 .60437 .67663 .60231 .67757 .60363 .67673 .6055 Mtetra
.523 .237 .422 r
.67673 .6055 .67757 .60363 .67849 .60425 .67764 .60599 Mtetra
.386 .089 .334 r
.67764 .60599 .67849 .60425 .67938 .60419 .67853 .60588 Mtetra
.115 0 .168 r
.67853 .60588 .67938 .60419 .68024 .60345 .67939 .60517 Mtetra
0 0 0 r
.67939 .60517 .68024 .60345 .68107 .60203 .68023 .60386 Mtetra
.741 .827 .367 r
.68023 .60386 .68107 .60203 .68187 .59992 .68104 .60192 Mtetra
.913 .892 .476 r
.68104 .60192 .68187 .59992 .68264 .59706 .68182 .59934 Mtetra
.967 .884 .502 r
.68182 .59934 .68264 .59706 .68338 .59347 .68258 .59609 Mtetra
.981 .867 .493 r
.68258 .59609 .68338 .59347 .68409 .58915 .68331 .5922 Mtetra
.979 .852 .462 r
.68331 .5922 .68409 .58915 .68478 .58424 .68401 .58778 Mtetra
.956 .833 .403 r
.68401 .58778 .68478 .58424 .68545 .57896 .68471 .58302 Mtetra
.878 .783 .288 r
.68471 .58302 .68545 .57896 .68611 .57367 .6854 .57827 Mtetra
0 0 0 r
.6854 .57827 .68611 .57367 .6868 .56885 .6861 .57392 Mtetra
0 0 .208 r
.6861 .57392 .6868 .56885 .68752 .56501 .68685 .57046 Mtetra
.15 0 .406 r
.68685 .57046 .68752 .56501 .68831 .56263 .68764 .56828 Mtetra
.383 .193 .495 r
.68764 .56828 .68831 .56263 .68917 .56197 .68851 .56765 Mtetra
.509 .301 .533 r
.68851 .56765 .68917 .56197 .69011 .56306 .68944 .56857 Mtetra
.581 .362 .548 r
.68944 .56857 .69011 .56306 .69112 .56568 .69044 .57085 Mtetra
.623 .397 .554 r
.69044 .57085 .69112 .56568 .69218 .5694 .69148 .5741 Mtetra
.648 .417 .554 r
.69148 .5741 .69218 .5694 .69327 .57369 .69254 .57787 Mtetra
.663 .426 .551 r
.69254 .57787 .69327 .57369 .69436 .57807 .69361 .58171 Mtetra
.668 .426 .545 r
.69361 .58171 .69436 .57807 .69544 .58214 .69467 .58528 Mtetra
.666 .418 .535 r
.69467 .58528 .69544 .58214 .6965 .58565 .69571 .58835 Mtetra
.656 .4 .521 r
.69571 .58835 .6965 .58565 .69753 .58847 .69672 .5908 Mtetra
.634 .369 .5 r
.69672 .5908 .69753 .58847 .69853 .59053 .69771 .59259 Mtetra
.594 .319 .469 r
.69771 .59259 .69853 .59053 .6995 .59186 .69867 .59372 Mtetra
.522 .234 .419 r
.69867 .59372 .6995 .59186 .70043 .59248 .6996 .59422 Mtetra
.386 .088 .332 r
.6996 .59422 .70043 .59248 .70134 .59241 .7005 .5941 Mtetra
.119 0 .17 r
.7005 .5941 .70134 .59241 .70221 .59167 .70138 .59339 Mtetra
0 0 0 r
.70138 .59339 .70221 .59167 .70306 .59024 .70222 .59207 Mtetra
.723 .813 .348 r
.70222 .59207 .70306 .59024 .70387 .5881 .70304 .59012 Mtetra
.902 .885 .459 r
.70304 .59012 .70387 .5881 .70464 .58523 .70383 .58752 Mtetra
.959 .881 .486 r
.70383 .58752 .70464 .58523 .70538 .5816 .70459 .58424 Mtetra
.975 .864 .476 r
.70459 .58424 .70538 .5816 .70609 .57726 .70532 .58033 Mtetra
.971 .847 .443 r
.70532 .58033 .70609 .57726 .70677 .57232 .70602 .57589 Mtetra
.943 .824 .378 r
.70602 .57589 .70677 .57232 .70742 .56702 .70671 .57113 Mtetra
.85 .764 .254 r
.70671 .57113 .70742 .56702 .70808 .56174 .70739 .56639 Mtetra
0 0 0 r
.70739 .56639 .70808 .56174 .70876 .55696 .7081 .56208 Mtetra
0 0 .238 r
.7081 .56208 .70876 .55696 .70949 .5532 .70885 .55868 Mtetra
.177 .021 .418 r
.70885 .55868 .70949 .5532 .71029 .55091 .70966 .5566 Mtetra
.395 .203 .499 r
.70966 .5566 .71029 .55091 .71118 .55037 .71054 .55607 Mtetra
.515 .306 .533 r
.71054 .55607 .71118 .55037 .71215 .55159 .71151 .5571 Mtetra
.584 .364 .548 r
.71151 .5571 .71215 .55159 .71319 .55432 .71254 .55949 Mtetra
.625 .398 .553 r
.71254 .55949 .71319 .55432 .71429 .55813 .71361 .56283 Mtetra
.65 .417 .553 r
.71361 .56283 .71429 .55813 .71542 .5625 .71472 .56667 Mtetra
.664 .425 .549 r
.71472 .56667 .71542 .5625 .71656 .56693 .71583 .57057 Mtetra
.669 .425 .543 r
.71583 .57057 .71656 .56693 .71768 .57104 .71693 .57417 Mtetra
.667 .417 .533 r
.71693 .57417 .71768 .57104 .71878 .57458 .718 .57727 Mtetra
.656 .399 .518 r
.718 .57727 .71878 .57458 .71985 .57741 .71905 .57973 Mtetra
.634 .368 .497 r
.71905 .57973 .71985 .57741 .72087 .57948 .72006 .58153 Mtetra
.594 .317 .466 r
.72006 .58153 .72087 .57948 .72187 .58082 .72104 .58267 Mtetra
.522 .233 .416 r
.72104 .58267 .72187 .58082 .72282 .58144 .722 .58317 Mtetra
.386 .087 .331 r
.722 .58317 .72282 .58144 .72375 .58137 .72292 .58307 Mtetra
.125 0 .174 r
.72292 .58307 .72375 .58137 .72464 .58062 .72381 .58235 Mtetra
0 0 0 r
.72381 .58235 .72464 .58062 .72549 .57918 .72467 .58103 Mtetra
.7 .796 .326 r
.72467 .58103 .72549 .57918 .72631 .57703 .7255 .57907 Mtetra
.887 .876 .439 r
.7255 .57907 .72631 .57703 .72709 .57413 .72629 .57644 Mtetra
.95 .876 .467 r
.72629 .57644 .72709 .57413 .72783 .57047 .72705 .57315 Mtetra
.967 .86 .457 r
.72705 .57315 .72783 .57047 .72853 .5661 .72778 .56921 Mtetra
.961 .841 .421 r
.72778 .56921 .72853 .5661 .7292 .56114 .72848 .56475 Mtetra
.926 .813 .35 r
.72848 .56475 .7292 .56114 .72985 .55583 .72916 .55999 Mtetra
.818 .741 .217 r
.72916 .55999 .72985 .55583 .7305 .55056 .72984 .55525 Mtetra
0 0 .01 r
.72984 .55525 .7305 .55056 .73118 .54581 .73054 .55098 Mtetra
0 0 .266 r
.73054 .55098 .73118 .54581 .73191 .54212 .7313 .54765 Mtetra
.201 .042 .429 r
.7313 .54765 .73191 .54212 .73273 .53994 .73212 .54566 Mtetra
.406 .213 .503 r
.73212 .54566 .73273 .53994 .73363 .53951 .73303 .54524 Mtetra
.521 .31 .534 r
.73303 .54524 .73363 .53951 .73464 .54086 .73403 .5464 Mtetra
.587 .366 .547 r
.73403 .5464 .73464 .54086 .73572 .54371 .73509 .54889 Mtetra
.627 .399 .552 r
.73509 .54889 .73572 .54371 .73687 .54763 .73621 .55233 Mtetra
.651 .417 .551 r
.73621 .55233 .73687 .54763 .73805 .55208 .73736 .55624 Mtetra
.665 .425 .548 r
.73736 .55624 .73805 .55208 .73923 .55657 .73851 .56019 Mtetra
.67 .424 .541 r
.73851 .56019 .73923 .55657 .74039 .56072 .73965 .56384 Mtetra
.667 .416 .53 r
.73965 .56384 .74039 .56072 .74153 .56428 .74076 .56696 Mtetra
.656 .397 .516 r
.74076 .56696 .74153 .56428 .74263 .56712 .74184 .56945 Mtetra
.634 .366 .494 r
.74184 .56945 .74263 .56712 .74369 .56921 .74289 .57126 Mtetra
.594 .315 .463 r
.74289 .57126 .74369 .56921 .74471 .57055 .74389 .57241 Mtetra
.522 .231 .414 r
.74389 .57241 .74471 .57055 .74569 .57118 .74487 .57292 Mtetra
.388 .088 .33 r
.74487 .57292 .74569 .57118 .74663 .57111 .74581 .57281 Mtetra
.133 0 .179 r
.74581 .57281 .74663 .57111 .74754 .57035 .74672 .5721 Mtetra
0 0 0 r
.74672 .5721 .74754 .57035 .7484 .5689 .74759 .57077 Mtetra
.674 .776 .3 r
.74759 .57077 .7484 .5689 .74923 .56673 .74843 .56879 Mtetra
.869 .864 .415 r
.74843 .56879 .74923 .56673 .75001 .56381 .74923 .56615 Mtetra
.937 .868 .445 r
.74923 .56615 .75001 .56381 .75075 .56012 .74999 .56283 Mtetra
.956 .854 .435 r
.74999 .56283 .75075 .56012 .75145 .55572 .75072 .55888 Mtetra
.948 .833 .396 r
.75072 .55888 .75145 .55572 .75211 .55073 .75141 .5544 Mtetra
.904 .799 .319 r
.75141 .5544 .75211 .55073 .75276 .54541 .75209 .54962 Mtetra
.78 .713 .177 r
.75209 .54962 .75276 .54541 .7534 .54015 .75276 .5449 Mtetra
0 0 .051 r
.75276 .5449 .7534 .54015 .75408 .53544 .75347 .54067 Mtetra
0 0 .292 r
.75347 .54067 .75408 .53544 .75482 .53183 .75423 .53741 Mtetra
.225 .062 .439 r
.75423 .53741 .75482 .53183 .75564 .52974 .75507 .53551 Mtetra
.417 .222 .506 r
.75507 .53551 .75564 .52974 .75658 .52944 .756 .53521 Mtetra
.526 .314 .535 r
.756 .53521 .75658 .52944 .75761 .53092 .75703 .53648 Mtetra
.59 .368 .546 r
.75703 .53648 .75761 .53092 .75874 .53389 .75814 .53909 Mtetra
.629 .399 .55 r
.75814 .53909 .75874 .53389 .75993 .53791 .7593 .54262 Mtetra
.652 .417 .55 r
.7593 .54262 .75993 .53791 .76116 .54244 .7605 .54661 Mtetra
.665 .424 .546 r
.7605 .54661 .76116 .54244 .76239 .54699 .76169 .55061 Mtetra
.67 .423 .539 r
.76169 .55061 .76239 .54699 .7636 .55118 .76287 .5543 Mtetra
.668 .414 .528 r
.76287 .5543 .7636 .55118 .76478 .55477 .76402 .55745 Mtetra
.657 .395 .513 r
.76402 .55745 .76478 .55477 .76591 .55763 .76514 .55996 Mtetra
.634 .364 .492 r
.76514 .55996 .76591 .55763 .767 .55973 .76621 .56179 Mtetra
.594 .313 .46 r
.76621 .56179 .767 .55973 .76805 .56109 .76725 .56295 Mtetra
.522 .229 .412 r
.76725 .56295 .76805 .56109 .76906 .56171 .76825 .56346 Mtetra
.389 .089 .33 r
.76825 .56346 .76906 .56171 .77002 .56164 .76921 .56336 Mtetra
.142 0 .186 r
.76921 .56336 .77002 .56164 .77094 .56088 .77013 .56265 Mtetra
0 0 0 r
.77013 .56265 .77094 .56088 .77182 .55942 .77102 .56131 Mtetra
.77102 .56131 .77182 .55942 .77266 .55723 .77187 .55932 Mtetra
.847 .849 .388 r
.77187 .55932 .77266 .55723 .77344 .55428 .77268 .55666 Mtetra
.922 .859 .421 r
.77268 .55666 .77344 .55428 .77418 .55056 .77344 .55332 Mtetra
.942 .845 .41 r
.77344 .55332 .77418 .55056 .77487 .54612 .77416 .54933 Mtetra
.931 .823 .368 r
.77416 .54933 .77487 .54612 .77553 .5411 .77485 .54483 Mtetra
.879 .781 .285 r
.77485 .54483 .77553 .5411 .77617 .53577 .77552 .54005 Mtetra
.738 .682 .135 r
.77552 .54005 .77617 .53577 .7768 .53051 .7762 .53533 Mtetra
0 0 .092 r
.7762 .53533 .7768 .53051 .77748 .52585 .7769 .53114 Mtetra
0 0 .316 r
.7769 .53114 .77748 .52585 .77822 .52231 .77767 .52795 Mtetra
.247 .08 .448 r
.77767 .52795 .77822 .52231 .77907 .52033 .77853 .52615 Mtetra
.427 .231 .509 r
.77853 .52615 .77907 .52033 .78003 .52015 .77949 .52596 Mtetra
.531 .318 .535 r
.77949 .52596 .78003 .52015 .7811 .52175 .78055 .52735 Mtetra
.593 .369 .546 r
.78055 .52735 .7811 .52175 .78228 .52485 .7817 .53007 Mtetra
.631 .4 .549 r
.7817 .53007 .78228 .52485 .78352 .52897 .78291 .5337 Mtetra
.653 .416 .548 r
.78291 .5337 .78352 .52897 .78479 .53358 .78415 .53776 Mtetra
.666 .423 .544 r
.78415 .53776 .78479 .53358 .78607 .53819 .7854 .54182 Mtetra
.671 .422 .536 r
.7854 .54182 .78607 .53819 .78733 .54242 .78662 .54555 Mtetra
.668 .413 .526 r
.78662 .54555 .78733 .54242 .78855 .54604 .78781 .54873 Mtetra
.656 .394 .51 r
.78781 .54873 .78855 .54604 .78972 .54893 .78896 .55126 Mtetra
.633 .362 .489 r
.78896 .55126 .78972 .54893 .79085 .55104 .79007 .5531 Mtetra
.593 .311 .458 r
.79007 .5531 .79085 .55104 .79193 .5524 .79113 .55427 Mtetra
.521 .228 .41 r
.79113 .55427 .79193 .5524 .79296 .55303 .79216 .5548 Mtetra
.39 .09 .331 r
.79216 .5548 .79296 .55303 .79394 .55296 .79314 .5547 Mtetra
.151 0 .194 r
.79314 .5547 .79394 .55296 .79488 .55219 .79408 .55398 Mtetra
0 0 0 r
.79408 .55398 .79488 .55219 .79577 .55071 .79499 .55263 Mtetra
.79499 .55263 .79577 .55071 .79661 .5485 .79584 .55063 Mtetra
.822 .831 .358 r
.79584 .55063 .79661 .5485 .79741 .54552 .79665 .54794 Mtetra
.904 .847 .393 r
.79665 .54794 .79741 .54552 .79814 .54176 .79742 .54457 Mtetra
.926 .834 .382 r
.79742 .54457 .79814 .54176 .79883 .53729 .79814 .54055 Mtetra
.911 .809 .337 r
.79814 .54055 .79883 .53729 .79948 .53224 .79883 .53603 Mtetra
.849 .76 .249 r
.79883 .53603 .79948 .53224 .80011 .52688 .79949 .53123 Mtetra
0 0 0 r
.79949 .53123 .80011 .52688 .80074 .52163 .80017 .52652 Mtetra
0 0 .131 r
.80017 .52652 .80074 .52163 .80141 .51701 .80087 .52237 Mtetra
0 0 .337 r
.80087 .52237 .80141 .51701 .80217 .51353 .80165 .51925 Mtetra
.266 .097 .457 r
.80165 .51925 .80217 .51353 .80303 .51165 .80253 .51754 Mtetra
.437 .238 .512 r
.80253 .51754 .80303 .51165 .80402 .5116 .80352 .51746 Mtetra
.536 .321 .535 r
.80352 .51746 .80402 .5116 .80513 .51334 .80462 .51897 Mtetra
.596 .37 .545 r
.80462 .51897 .80513 .51334 .80635 .51655 .80581 .5218 Mtetra
.632 .4 .548 r
.80581 .5218 .80635 .51655 .80765 .52078 .80707 .52552 Mtetra
.654 .416 .546 r
.80707 .52552 .80765 .52078 .80898 .52547 .80836 .52967 Mtetra
.667 .422 .542 r
.80836 .52967 .80898 .52547 .81031 .53014 .80965 .53378 Mtetra
.671 .421 .534 r
.80965 .53378 .81031 .53014 .81161 .53441 .81092 .53755 Mtetra
.668 .411 .523 r
.81092 .53755 .81161 .53441 .81288 .53806 .81215 .54076 Mtetra
.656 .391 .508 r
.81215 .54076 .81288 .53806 .81409 .54096 .81334 .54331 Mtetra
.633 .359 .486 r
.81334 .54331 .81409 .54096 .81525 .54308 .81448 .54516 Mtetra
.591 .308 .455 r
.81448 .54516 .81525 .54308 .81636 .54445 .81558 .54634 Mtetra
.52 .226 .408 r
.81558 .54634 .81636 .54445 .81741 .54508 .81663 .54687 Mtetra
.391 .091 .332 r
.81663 .54687 .81741 .54508 .81842 .545 .81763 .54677 Mtetra
.159 0 .202 r
.81763 .54677 .81842 .545 .81938 .54422 .81859 .54604 Mtetra
0 0 .001 r
.81859 .54604 .81938 .54422 .82028 .54273 .81951 .54468 Mtetra
0 0 0 r
.81951 .54468 .82028 .54273 .82113 .54049 .82038 .54266 Mtetra
.795 .81 .325 r
.82038 .54266 .82113 .54049 .82193 .53747 .8212 .53994 Mtetra
.882 .832 .363 r
.8212 .53994 .82193 .53747 .82267 .53368 .82196 .53654 Mtetra
.906 .82 .352 r
.82196 .53654 .82267 .53368 .82335 .52916 .82268 .53249 Mtetra
.888 .792 .304 r
.82268 .53249 .82335 .52916 .82399 .52407 .82336 .52793 Mtetra
.816 .735 .21 r
.82336 .52793 .82399 .52407 .82461 .51869 .82402 .52311 Mtetra
0 0 0 r
.82402 .52311 .82461 .51869 .82523 .51344 .82469 .51842 Mtetra
0 0 .168 r
.82469 .51842 .82523 .51344 .82591 .50885 .8254 .5143 Mtetra
.021 0 .357 r
.8254 .5143 .82591 .50885 .82667 .50545 .82619 .51124 Mtetra
.284 .113 .464 r
.82619 .51124 .82667 .50545 .82755 .50367 .82709 .50962 Mtetra
.445 .245 .514 r
.82709 .50962 .82755 .50367 .82857 .50374 .82811 .50965 Mtetra
.54 .324 .536 r
.82811 .50965 .82857 .50374 .82973 .5056 .82925 .51128 Mtetra
.598 .372 .544 r
.82925 .51128 .82973 .5056 .831 .50894 .83049 .51422 Mtetra
.633 .4 .546 r
.83049 .51422 .831 .50894 .83235 .51327 .8318 .51804 Mtetra
.655 .415 .544 r
.8318 .51804 .83235 .51327 .83373 .51804 .83314 .52225 Mtetra
.667 .421 .539 r
.83314 .52225 .83373 .51804 .83512 .52277 .83448 .52643 Mtetra
.671 .419 .532 r
.83448 .52643 .83512 .52277 .83647 .52708 .8358 .53024 Mtetra
.667 .409 .521 r
.8358 .53024 .83647 .52708 .83778 .53075 .83708 .53347 Mtetra
.655 .389 .505 r
.83708 .53347 .83778 .53075 .83904 .53367 .83831 .53603 Mtetra
.631 .357 .483 r
.83831 .53603 .83904 .53367 .84023 .5358 .83948 .5379 Mtetra
.59 .305 .453 r
.83948 .5379 .84023 .5358 .84137 .53717 .84061 .53908 Mtetra
.518 .224 .406 r
.84061 .53908 .84137 .53717 .84246 .5378 .84168 .53961 Mtetra
.391 .092 .333 r
.84168 .53961 .84246 .5378 .84349 .53771 .84271 .5395 Mtetra
.166 0 .21 r
.84271 .5395 .84349 .53771 .84446 .53692 .84369 .53877 Mtetra
0 0 .023 r
.84369 .53877 .84446 .53692 .84538 .5354 .84462 .53739 Mtetra
0 0 0 r
.84462 .53739 .84538 .5354 .84624 .53313 .8455 .53534 Mtetra
.765 .787 .292 r
.8455 .53534 .84624 .53313 .84704 .53007 .84632 .53259 Mtetra
.858 .814 .331 r
.84632 .53259 .84704 .53007 .84777 .52623 .84709 .52915 Mtetra
.883 .804 .32 r
.84709 .52915 .84777 .52623 .84845 .52166 .84781 .52506 Mtetra
.861 .773 .269 r
.84781 .52506 .84845 .52166 .84908 .51653 .84849 .52047 Mtetra
.778 .707 .169 r
.84849 .52047 .84908 .51653 .84969 .51112 .84914 .51563 Mtetra
0 0 0 r
.84914 .51563 .84969 .51112 .85031 .50587 .84981 .51093 Mtetra
0 0 .202 r
.84981 .51093 .85031 .50587 .85099 .50131 .85052 .50684 Mtetra
.055 0 .374 r
.85052 .50684 .85099 .50131 .85176 .49798 .85132 .50384 Mtetra
.301 .127 .471 r
.85132 .50384 .85176 .49798 .85266 .4963 .85224 .50232 Mtetra
.453 .252 .516 r
.85224 .50232 .85266 .4963 .85372 .49649 .85329 .50246 Mtetra
.544 .327 .536 r
.85329 .50246 .85372 .49649 .85492 .49848 .85447 .5042 Mtetra
.6 .372 .543 r
.85447 .5042 .85492 .49848 .85624 .50193 .85577 .50725 Mtetra
.634 .399 .545 r
.85577 .50725 .85624 .50193 .85765 .50636 .85713 .51116 Mtetra
.655 .414 .542 r
.85713 .51116 .85765 .50636 .85909 .51121 .85853 .51545 Mtetra
.667 .42 .537 r
.85853 .51545 .85909 .51121 .86053 .51599 .85992 .51968 Mtetra
.671 .417 .529 r
.85992 .51968 .86053 .51599 .86194 .52034 .86129 .52352 Mtetra
.667 .407 .518 r
.86129 .52352 .86194 .52034 .8633 .52404 .86261 .52678 Mtetra
.654 .386 .502 r
.86261 .52678 .8633 .52404 .86459 .52697 .86388 .52935 Mtetra
.63 .354 .481 r
.86388 .52935 .86459 .52697 .86583 .52911 .86509 .53123 Mtetra
.588 .302 .45 r
.86509 .53123 .86583 .52911 .867 .53047 .86625 .53241 Mtetra
.515 .221 .405 r
.86625 .53241 .867 .53047 .86811 .5311 .86735 .53294 Mtetra
.39 .091 .333 r
.86735 .53294 .86811 .5311 .86916 .531 .8684 .53282 Mtetra
.171 0 .217 r
.8684 .53282 .86916 .531 .87016 .53019 .8694 .53207 Mtetra
0 0 .043 r
.8694 .53207 .87016 .53019 .87109 .52864 .87035 .53067 Mtetra
0 0 0 r
.87035 .53067 .87109 .52864 .87196 .52633 .87123 .52859 Mtetra
.733 .762 .257 r
.87123 .52859 .87196 .52633 .87276 .52323 .87206 .52581 Mtetra
.831 .794 .297 r
.87206 .52581 .87276 .52323 .87349 .51933 .87283 .52232 Mtetra
.857 .785 .285 r
.87283 .52232 .87349 .51933 .87416 .51471 .87355 .51818 Mtetra
.83 .75 .232 r
.87355 .51818 .87416 .51471 .87479 .50953 .87422 .51355 Mtetra
.738 .676 .128 r
.87422 .51355 .87479 .50953 .87539 .50409 .87487 .50868 Mtetra
0 0 .036 r
.87487 .50868 .87539 .50409 .876 .49884 .87553 .50398 Mtetra
0 0 .232 r
.87553 .50398 .876 .49884 .87667 .4943 .87625 .49992 Mtetra
.085 0 .389 r
.87625 .49992 .87667 .4943 .87746 .49103 .87706 .49698 Mtetra
.316 .14 .477 r
.87706 .49698 .87746 .49103 .87838 .48945 .878 .49555 Mtetra
.46 .257 .518 r
.878 .49555 .87838 .48945 .87947 .48976 .87909 .4958 Mtetra
.547 .329 .535 r
.87909 .4958 .87947 .48976 .88072 .49187 .88032 .49765 Mtetra
.601 .373 .542 r
.88032 .49765 .88072 .49187 .8821 .49544 .88166 .50081 Mtetra
.635 .399 .543 r
.88166 .50081 .8821 .49544 .88357 .49997 .88308 .50481 Mtetra
.656 .413 .54 r
.88308 .50481 .88357 .49997 .88507 .5049 .88453 .50917 Mtetra
.667 .418 .535 r
.88453 .50917 .88507 .5049 .88657 .50973 .88598 .51344 Mtetra
.67 .415 .527 r
.88598 .51344 .88657 .50973 .88803 .51412 .8874 .51732 Mtetra
.666 .404 .515 r
.8874 .51732 .88803 .51412 .88944 .51783 .88877 .5206 Mtetra
.653 .384 .5 r
.88877 .5206 .88944 .51783 .89078 .52077 .89008 .52318 Mtetra
.628 .35 .478 r
.89008 .52318 .89078 .52077 .89205 .52292 .89133 .52506 Mtetra
.585 .298 .447 r
.89133 .52506 .89205 .52292 .89326 .52428 .89252 .52625 Mtetra
.513 .218 .403 r
.89252 .52625 .89326 .52428 .8944 .52489 .89365 .52677 Mtetra
.388 .09 .334 r
.89365 .52677 .8944 .52489 .89547 .52478 .89472 .52664 Mtetra
.175 0 .224 r
.89472 .52664 .89547 .52478 .89648 .52394 .89574 .52587 Mtetra
0 0 .062 r
.89574 .52587 .89648 .52394 .89743 .52236 .8967 .52444 Mtetra
0 0 0 r
.8967 .52444 .89743 .52236 .89831 .52001 .8976 .52232 Mtetra
.701 .735 .223 r
.8976 .52232 .89831 .52001 .89911 .51685 .89844 .5195 Mtetra
.802 .771 .262 r
.89844 .5195 .89911 .51685 .89984 .5129 .89921 .51596 Mtetra
.828 .763 .25 r
.89921 .51596 .89984 .5129 .90051 .50822 .89992 .51177 Mtetra
.797 .725 .194 r
.89992 .51177 .90051 .50822 .90112 .50299 .90058 .50709 Mtetra
0 0 0 r
.90058 .50709 .90112 .50299 .90171 .49751 .90123 .50219 Mtetra
0 0 .075 r
.90123 .50219 .90171 .49751 .90232 .49225 .90189 .49748 Mtetra
0 0 .26 r
.90189 .49748 .90232 .49225 .90299 .48774 .90261 .49345 Mtetra
.112 0 .403 r
.90261 .49345 .90299 .48774 .90379 .48453 .90344 .49057 Mtetra
.329 .151 .482 r
.90344 .49057 .90379 .48453 .90474 .48304 .9044 .48922 Mtetra
.466 .262 .519 r
.9044 .48922 .90474 .48304 .90587 .48347 .90553 .48957 Mtetra
.55 .331 .535 r
.90553 .48957 .90587 .48347 .90717 .4857 .9068 .49154 Mtetra
.603 .373 .541 r
.9068 .49154 .90717 .4857 .9086 .48939 .9082 .4948 Mtetra
.636 .398 .541 r
.9082 .4948 .9086 .48939 .91013 .49401 .90968 .49889 Mtetra
.656 .412 .538 r
.90968 .49889 .91013 .49401 .9117 .49901 .91119 .50331 Mtetra
.667 .417 .533 r
.91119 .50331 .9117 .49901 .91326 .5039 .9127 .50764 Mtetra
.669 .413 .524 r
.9127 .50764 .91326 .5039 .91478 .50832 .91417 .51154 Mtetra
.665 .402 .513 r
.91417 .51154 .91478 .50832 .91623 .51205 .91558 .51484 Mtetra
.651 .381 .497 r
.91558 .51484 .91623 .51205 .91762 .515 .91694 .51743 Mtetra
.626 .347 .475 r
.91694 .51743 .91762 .515 .91893 .51714 .91822 .51931 Mtetra
.582 .294 .445 r
.91822 .51931 .91893 .51714 .92017 .51849 .91945 .52049 Mtetra
.509 .214 .401 r
.91945 .52049 .92017 .51849 .92134 .51909 .92061 .521 Mtetra
.385 .089 .334 r
.92061 .521 .92134 .51909 .92244 .51896 .92171 .52086 Mtetra
.178 0 .23 r
.92171 .52086 .92244 .51896 .92347 .51809 .92275 .52006 Mtetra
0 0 .079 r
.92275 .52006 .92347 .51809 .92443 .51648 .92372 .5186 Mtetra
0 0 0 r
.92372 .5186 .92443 .51648 .92531 .51408 .92463 .51645 Mtetra
.92463 .51645 .92531 .51408 .92612 .51087 .92547 .51357 Mtetra
.772 .747 .227 r
.92547 .51357 .92612 .51087 .92685 .50685 .92624 .50998 Mtetra
.797 .739 .214 r
.92624 .50998 .92685 .50685 .92751 .5021 .92695 .50573 Mtetra
.762 .697 .155 r
.92695 .50573 .92751 .5021 .92811 .49681 .92761 .501 Mtetra
0 0 0 r
.92761 .501 .92811 .49681 .92869 .49129 .92824 .49607 Mtetra
0 0 .112 r
.92824 .49607 .92869 .49129 .92929 .48601 .9289 .49135 Mtetra
0 0 .285 r
.9289 .49135 .92929 .48601 .92996 .48153 .92963 .48733 Mtetra
.137 0 .415 r
.92963 .48733 .92996 .48153 .93077 .47838 .93047 .48451 Mtetra
.341 .162 .486 r
.93047 .48451 .93077 .47838 .93175 .47699 .93146 .48324 Mtetra
.472 .267 .52 r
.93146 .48324 .93175 .47699 .93292 .47753 .93263 .4837 Mtetra
.553 .333 .535 r
.93263 .4837 .93292 .47753 .93427 .47988 .93395 .48578 Mtetra
.604 .373 .54 r
.93395 .48578 .93427 .47988 .93577 .48368 .93541 .48914 Mtetra
.636 .398 .54 r
.93541 .48914 .93577 .48368 .93736 .4884 .93695 .49331 Mtetra
.656 .411 .536 r
.93695 .49331 .93736 .4884 .939 .49347 .93852 .4978 Mtetra
.666 .415 .53 r
.93852 .4978 .939 .49347 .94062 .49841 .94009 .50217 Mtetra
.669 .411 .522 r
.94009 .50217 .94062 .49841 .94219 .50286 .94161 .50611 Mtetra
.664 .399 .51 r
.94161 .50611 .94219 .50286 .9437 .50661 .94308 .50942 Mtetra
.649 .377 .494 r
.94308 .50942 .9437 .50661 .94514 .50956 .94447 .51202 Mtetra
.623 .343 .472 r
.94447 .51202 .94514 .50956 .94649 .5117 .9458 .5139 Mtetra
.579 .29 .442 r
.9458 .5139 .94649 .5117 .94776 .51304 .94706 .51507 Mtetra
.505 .21 .399 r
.94706 .51507 .94776 .51304 .94896 .51362 .94825 .51556 Mtetra
.381 .086 .334 r
.94825 .51556 .94896 .51362 .95009 .51346 .94937 .5154 Mtetra
.179 0 .235 r
.94937 .5154 .95009 .51346 .95114 .51257 .95043 .51458 Mtetra
0 0 .094 r
.95043 .51458 .95114 .51257 .95211 .51091 .95142 .51308 Mtetra
0 0 0 r
.95142 .51308 .95211 .51091 .953 .50845 .95234 .51088 Mtetra
.95234 .51088 .953 .50845 .95381 .50518 .95319 .50795 Mtetra
.74 .721 .192 r
.95319 .50795 .95381 .50518 .95454 .5011 .95396 .50429 Mtetra
.764 .713 .177 r
.95396 .50429 .95454 .5011 .95518 .49628 .95466 .49999 Mtetra
.724 .668 .117 r
.95466 .49999 .95518 .49628 .95577 .49092 .95531 .4952 Mtetra
0 0 0 r
.95531 .4952 .95577 .49092 .95634 .48536 .95594 .49023 Mtetra
0 0 .147 r
.95594 .49023 .95634 .48536 .95693 .48006 .95659 .48549 Mtetra
0 0 .308 r
.95659 .48549 .95693 .48006 .95761 .47559 .95732 .4815 Mtetra
.159 .017 .425 r
.95732 .4815 .95761 .47559 .95843 .47251 .95818 .47872 Mtetra
.352 .171 .49 r
.95818 .47872 .95843 .47251 .95944 .47121 .9592 .47755 Mtetra
.477 .271 .521 r
.9592 .47755 .95944 .47121 .96066 .47186 .96041 .47811 Mtetra
.555 .334 .534 r
.96041 .47811 .96066 .47186 .96206 .47434 .96179 .48029 Mtetra
.605 .373 .538 r
.96179 .48029 .96206 .47434 .96363 .47825 .9633 .48375 Mtetra
.637 .397 .538 r
.9633 .48375 .96363 .47825 .96529 .48306 .96491 .48801 Mtetra
.656 .409 .534 r
.96491 .48801 .96529 .48306 .96699 .4882 .96654 .49257 Mtetra
.666 .413 .528 r
.96654 .49257 .96699 .4882 .96867 .49319 .96817 .49698 Mtetra
.668 .408 .519 r
.96817 .49698 .96867 .49319 .97031 .49766 .96975 .50094 Mtetra
.662 .396 .507 r
.96975 .50094 .97031 .49766 .97187 .50142 .97127 .50426 Mtetra
.647 .374 .491 r
.97127 .50426 .97187 .50142 .97335 .50438 .97271 .50686 Mtetra
.62 .339 .469 r
.97271 .50686 .97335 .50438 .97475 .50651 .97408 .50874 Mtetra
.575 .286 .439 r
.97408 .50874 .97475 .50651 .97606 .50784 .97537 .5099 Mtetra
.501 .205 .397 r
.97537 .5099 .97606 .50784 .97729 .5084 .97659 .51038 Mtetra
.377 .084 .334 r
.97659 .51038 .97729 .5084 .97844 .50822 .97774 .51019 Mtetra
.179 0 .24 r
.97774 .51019 .97844 .50822 .97951 .50728 .97882 .50934 Mtetra
0 0 .109 r
.97882 .50934 .97951 .50728 .9805 .50557 .97983 .5078 Mtetra
0 0 0 r
.97983 .5078 .9805 .50557 .9814 .50306 .98076 .50555 Mtetra
.98076 .50555 .9814 .50306 .98221 .49972 .98161 .50256 Mtetra
.708 .694 .157 r
.98161 .50256 .98221 .49972 .98292 .49557 .98237 .49884 Mtetra
.73 .685 .141 r
.98237 .49884 .98292 .49557 .98356 .49067 .98307 .49447 Mtetra
0 0 0 r
.98307 .49447 .98356 .49067 .98414 .48525 .98371 .48962 Mtetra
0 0 .03 r
.98371 .48962 .98414 .48525 .98469 .47963 .98434 .4846 Mtetra
0 0 .179 r
.98434 .4846 .98469 .47963 .98528 .47432 .98499 .47985 Mtetra
0 0 .328 r
.98499 .47985 .98528 .47432 .98596 .46987 .98572 .47587 Mtetra
.18 .035 .435 r
.98572 .47587 .98596 .46987 .9868 .46684 .9866 .47315 Mtetra
.363 .18 .494 r
.9866 .47315 .9868 .46684 .98784 .46563 .98765 .47206 Mtetra
.453 .242 .502 r
.52488 .68195 .52576 .67759 .52653 .67777 .52565 .68205 Mtetra
.562 .341 .538 r
.52565 .68205 .52653 .67777 .52731 .67935 .52643 .68342 Mtetra
.619 .393 .552 r
.52643 .68342 .52731 .67935 .5281 .68202 .52722 .68577 Mtetra
.65 .42 .557 r
.52722 .68577 .5281 .68202 .5289 .68536 .52801 .68873 Mtetra
.668 .433 .556 r
.52801 .68873 .5289 .68536 .5297 .68894 .52881 .69189 Mtetra
.676 .436 .551 r
.52881 .69189 .5297 .68894 .5305 .69237 .52961 .69493 Mtetra
.676 .43 .542 r
.52961 .69493 .5305 .69237 .5313 .6954 .5304 .69759 Mtetra
.667 .413 .527 r
.5304 .69759 .5313 .6954 .5321 .69786 .5312 .69975 Mtetra
.648 .383 .505 r
.5312 .69975 .5321 .69786 .53289 .69969 .53199 .70135 Mtetra
.61 .331 .469 r
.53199 .70135 .53289 .69969 .53368 .70089 .53277 .70236 Mtetra
.536 .237 .407 r
.53277 .70236 .53368 .70089 .53446 .70146 .53356 .70283 Mtetra
.38 .056 .286 r
.53356 .70283 .53446 .70146 .53524 .70145 .53433 .70276 Mtetra
.017 0 .02 r
.53433 .70276 .53524 .70145 .53601 .70086 .53511 .70216 Mtetra
.584 .806 .405 r
.53511 .70216 .53601 .70086 .53678 .69969 .53588 .70105 Mtetra
.907 .957 .622 r
.53588 .70105 .53678 .69969 .53754 .69792 .53664 .6994 Mtetra
.974 .925 .655 r
.53664 .6994 .53754 .69792 .5383 .69553 .5374 .6972 Mtetra
.984 .884 .646 r
.5374 .6972 .5383 .69553 .53905 .69251 .53815 .69441 Mtetra
.985 .857 .629 r
.53815 .69441 .53905 .69251 .53979 .68885 .5389 .69106 Mtetra
.988 .845 .61 r
.5389 .69106 .53979 .68885 .54053 .68464 .53964 .6872 Mtetra
.994 .845 .586 r
.53964 .6872 .54053 .68464 .54126 .68002 .54037 .68299 Mtetra
.997 .855 .547 r
.54037 .68299 .54126 .68002 .54198 .67527 .54111 .67865 Mtetra
.972 .859 .463 r
.54111 .67865 .54198 .67527 .54271 .67077 .54184 .67454 Mtetra
.785 .756 .24 r
.54184 .67454 .54271 .67077 .54345 .66697 .54259 .67105 Mtetra
0 0 .161 r
.54259 .67105 .54345 .66697 .5442 .66428 .54334 .66857 Mtetra
.237 .051 .414 r
.54334 .66857 .5442 .66428 .54497 .66301 .54411 .66737 Mtetra
.46 .249 .504 r
.54411 .66737 .54497 .66301 .54575 .66327 .54489 .66754 Mtetra
.566 .344 .538 r
.54489 .66754 .54575 .66327 .54655 .66492 .54569 .66898 Mtetra
.621 .393 .551 r
.54569 .66898 .54655 .66492 .54737 .66765 .5465 .67138 Mtetra
.652 .42 .555 r
.5465 .67138 .54737 .66765 .5482 .67104 .54732 .67438 Mtetra
.669 .433 .554 r
.54732 .67438 .5482 .67104 .54903 .67464 .54815 .67756 Mtetra
.676 .435 .549 r
.54815 .67756 .54903 .67464 .54986 .67807 .54897 .6806 Mtetra
.676 .428 .539 r
.54897 .6806 .54986 .67807 .55068 .68109 .54979 .68326 Mtetra
.667 .411 .524 r
.54979 .68326 .55068 .68109 .5515 .68354 .55061 .68541 Mtetra
.647 .38 .501 r
.55061 .68541 .5515 .68354 .55232 .68535 .55142 .68698 Mtetra
.608 .326 .464 r
.55142 .68698 .55232 .68535 .55312 .68653 .55223 .68798 Mtetra
.532 .229 .399 r
.55223 .68798 .55312 .68653 .55392 .68708 .55302 .68843 Mtetra
.369 .042 .274 r
.55302 .68843 .55392 .68708 .55472 .68704 .55382 .68833 Mtetra
0 0 0 r
.55382 .68833 .55472 .68704 .5555 .68643 .5546 .68772 Mtetra
.601 .817 .419 r
.5546 .68772 .5555 .68643 .55628 .68523 .55538 .68658 Mtetra
.91 .956 .622 r
.55538 .68658 .55628 .68523 .55705 .68343 .55615 .6849 Mtetra
.975 .924 .652 r
.55615 .6849 .55705 .68343 .55781 .68101 .55691 .68266 Mtetra
.985 .884 .642 r
.55691 .68266 .55781 .68101 .55856 .67794 .55767 .67985 Mtetra
.987 .859 .625 r
.55767 .67985 .55856 .67794 .5593 .67424 .55841 .67646 Mtetra
.99 .847 .605 r
.55841 .67646 .5593 .67424 .56003 .66999 .55915 .67257 Mtetra
.995 .847 .579 r
.55915 .67257 .56003 .66999 .56076 .66534 .55988 .66832 Mtetra
.997 .857 .537 r
.55988 .66832 .56076 .66534 .56148 .66058 .56061 .66398 Mtetra
.963 .855 .445 r
.56061 .66398 .56148 .66058 .5622 .6561 .56135 .65988 Mtetra
.75 .73 .205 r
.56135 .65988 .5622 .6561 .56294 .65233 .56209 .65642 Mtetra
0 0 .189 r
.56209 .65642 .56294 .65233 .56369 .6497 .56285 .654 Mtetra
.257 .068 .422 r
.56285 .654 .56369 .6497 .56447 .64851 .56363 .65286 Mtetra
.468 .255 .506 r
.56363 .65286 .56447 .64851 .56527 .64885 .56443 .65311 Mtetra
.569 .346 .538 r
.56443 .65311 .56527 .64885 .56609 .65058 .56525 .65462 Mtetra
.623 .394 .55 r
.56525 .65462 .56609 .65058 .56694 .65338 .56609 .65708 Mtetra
.653 .42 .554 r
.56609 .65708 .56694 .65338 .56779 .6568 .56693 .66011 Mtetra
.67 .432 .552 r
.56693 .66011 .56779 .6568 .56865 .66042 .56779 .66332 Mtetra
.677 .434 .546 r
.56779 .66332 .56865 .66042 .56951 .66387 .56864 .66637 Mtetra
.676 .427 .536 r
.56864 .66637 .56951 .66387 .57037 .66688 .56949 .66902 Mtetra
.667 .409 .521 r
.56949 .66902 .57037 .66688 .57121 .66932 .57033 .67116 Mtetra
.646 .377 .497 r
.57033 .67116 .57121 .66932 .57205 .67112 .57116 .67272 Mtetra
.606 .321 .458 r
.57116 .67272 .57205 .67112 .57288 .67227 .57198 .67371 Mtetra
.528 .222 .392 r
.57198 .67371 .57288 .67227 .57369 .67281 .5728 .67413 Mtetra
.36 .029 .262 r
.5728 .67413 .57369 .67281 .5745 .67275 .5736 .67402 Mtetra
0 0 0 r
.5736 .67402 .5745 .67275 .5753 .67211 .5744 .67339 Mtetra
.614 .827 .43 r
.5744 .67339 .5753 .67211 .57608 .67088 .57519 .67223 Mtetra
.911 .956 .622 r
.57519 .67223 .57608 .67088 .57686 .66905 .57597 .67052 Mtetra
.975 .924 .648 r
.57597 .67052 .57686 .66905 .57762 .6666 .57673 .66825 Mtetra
.986 .885 .638 r
.57673 .66825 .57762 .6666 .57837 .66349 .57749 .6654 Mtetra
.988 .86 .62 r
.57749 .6654 .57837 .66349 .57911 .65976 .57824 .66198 Mtetra
.992 .849 .599 r
.57824 .66198 .57911 .65976 .57984 .65547 .57897 .65806 Mtetra
.996 .849 .571 r
.57897 .65806 .57984 .65547 .58056 .6508 .5797 .65379 Mtetra
.996 .857 .526 r
.5797 .65379 .58056 .6508 .58128 .64603 .58043 .64944 Mtetra
.952 .849 .424 r
.58043 .64944 .58128 .64603 .582 .64156 .58116 .64535 Mtetra
.71 .702 .168 r
.58116 .64535 .582 .64156 .58273 .63783 .5819 .64193 Mtetra
0 0 .216 r
.5819 .64193 .58273 .63783 .58349 .63526 .58266 .63956 Mtetra
.275 .084 .431 r
.58266 .63956 .58349 .63526 .58428 .63415 .58345 .6385 Mtetra
.476 .261 .508 r
.58345 .6385 .58428 .63415 .5851 .63458 .58427 .63883 Mtetra
.573 .349 .537 r
.58427 .63883 .5851 .63458 .58595 .63639 .58512 .64041 Mtetra
.625 .395 .549 r
.58512 .64041 .58595 .63639 .58682 .63925 .58598 .64294 Mtetra
.654 .42 .552 r
.58598 .64294 .58682 .63925 .58771 .64273 .58686 .64601 Mtetra
.671 .431 .55 r
.58686 .64601 .58771 .64273 .5886 .64637 .58774 .64924 Mtetra
.678 .433 .544 r
.58774 .64924 .5886 .64637 .58949 .64983 .58862 .6523 Mtetra
.677 .425 .534 r
.58862 .6523 .58949 .64983 .59037 .65284 .5895 .65496 Mtetra
.667 .407 .517 r
.5895 .65496 .59037 .65284 .59124 .65527 .59036 .65709 Mtetra
.646 .374 .492 r
.59036 .65709 .59124 .65527 .5921 .65705 .59122 .65864 Mtetra
.605 .317 .453 r
.59122 .65864 .5921 .65705 .59295 .6582 .59206 .65961 Mtetra
.524 .215 .384 r
.59206 .65961 .59295 .6582 .59378 .65872 .59289 .66002 Mtetra
.351 .017 .25 r
.59289 .66002 .59378 .65872 .5946 .65864 .59371 .6599 Mtetra
0 0 0 r
.59371 .6599 .5946 .65864 .59541 .65798 .59452 .65924 Mtetra
.624 .834 .438 r
.59452 .65924 .59541 .65798 .5962 .65673 .59532 .65806 Mtetra
.912 .955 .62 r
.59532 .65806 .5962 .65673 .59699 .65487 .5961 .65633 Mtetra
.975 .924 .645 r
.5961 .65633 .59699 .65487 .59775 .65238 .59688 .65404 Mtetra
.987 .886 .634 r
.59688 .65404 .59775 .65238 .59851 .64924 .59763 .65115 Mtetra
.99 .861 .615 r
.59763 .65115 .59851 .64924 .59924 .64547 .59838 .6477 Mtetra
.993 .851 .593 r
.59838 .6477 .59924 .64547 .59997 .64115 .59911 .64375 Mtetra
.997 .851 .563 r
.59911 .64375 .59997 .64115 .60068 .63646 .59984 .63946 Mtetra
.993 .858 .513 r
.59984 .63946 .60068 .63646 .60139 .63168 .60056 .63511 Mtetra
.938 .841 .401 r
.60056 .63511 .60139 .63168 .60211 .62723 .60129 .63104 Mtetra
0 0 0 r
.60129 .63104 .60211 .62723 .60285 .62354 .60203 .62766 Mtetra
0 0 .242 r
.60203 .62766 .60285 .62354 .60361 .62105 .6028 .62535 Mtetra
.294 .1 .438 r
.6028 .62535 .60361 .62105 .60441 .62002 .6036 .62437 Mtetra
.483 .268 .51 r
.6036 .62437 .60441 .62002 .60525 .62054 .60444 .62478 Mtetra
.577 .351 .537 r
.60444 .62478 .60525 .62054 .60612 .62243 .60531 .62644 Mtetra
.627 .396 .548 r
.60531 .62644 .60612 .62243 .60702 .62537 .6062 .62903 Mtetra
.656 .42 .55 r
.6062 .62903 .60702 .62537 .60794 .62889 .60711 .63215 Mtetra
.672 .431 .548 r
.60711 .63215 .60794 .62889 .60887 .63257 .60802 .63541 Mtetra
.678 .432 .542 r
.60802 .63541 .60887 .63257 .60979 .63604 .60894 .63848 Mtetra
.677 .424 .531 r
.60894 .63848 .60979 .63604 .6107 .63905 .60984 .64114 Mtetra
.668 .405 .514 r
.60984 .64114 .6107 .63905 .6116 .64148 .61073 .64327 Mtetra
.646 .371 .488 r
.61073 .64327 .6116 .64148 .61248 .64325 .6116 .64481 Mtetra
.604 .312 .448 r
.6116 .64481 .61248 .64325 .61335 .64438 .61247 .64578 Mtetra
.521 .208 .377 r
.61247 .64578 .61335 .64438 .6142 .64489 .61332 .64618 Mtetra
.344 .006 .24 r
.61332 .64618 .6142 .64489 .61504 .6448 .61415 .64604 Mtetra
0 0 0 r
.61415 .64604 .61504 .6448 .61586 .64412 .61497 .64537 Mtetra
.629 .838 .443 r
.61497 .64537 .61586 .64412 .61666 .64285 .61578 .64417 Mtetra
.911 .955 .618 r
.61578 .64417 .61666 .64285 .61745 .64097 .61657 .64243 Mtetra
.975 .924 .641 r
.61657 .64243 .61745 .64097 .61822 .63845 .61735 .6401 Mtetra
.988 .887 .629 r
.61735 .6401 .61822 .63845 .61898 .63528 .61811 .63719 Mtetra
.991 .863 .609 r
.61811 .63719 .61898 .63528 .61971 .63148 .61886 .63371 Mtetra
.994 .853 .586 r
.61886 .63371 .61971 .63148 .62043 .62712 .61959 .62974 Mtetra
.998 .853 .554 r
.61959 .62974 .62043 .62712 .62114 .62241 .62031 .62543 Mtetra
.99 .857 .499 r
.62031 .62543 .62114 .62241 .62184 .61764 .62103 .62108 Mtetra
.922 .832 .376 r
.62103 .62108 .62184 .61764 .62256 .6132 .62175 .61703 Mtetra
0 0 0 r
.62175 .61703 .62256 .6132 .62329 .60957 .6225 .6137 Mtetra
0 0 .266 r
.6225 .6137 .62329 .60957 .62406 .60714 .62328 .61146 Mtetra
.311 .116 .445 r
.62328 .61146 .62406 .60714 .62488 .60621 .62409 .61056 Mtetra
.491 .274 .511 r
.62409 .61056 .62488 .60621 .62574 .60682 .62495 .61106 Mtetra
.58 .354 .537 r
.62495 .61106 .62574 .60682 .62664 .6088 .62584 .61279 Mtetra
.629 .397 .546 r
.62584 .61279 .62664 .6088 .62757 .61181 .62677 .61545 Mtetra
.658 .42 .548 r
.62677 .61545 .62757 .61181 .62853 .61539 .62771 .61862 Mtetra
.673 .43 .546 r
.62771 .61862 .62853 .61539 .62948 .6191 .62865 .62191 Mtetra
.679 .431 .539 r
.62865 .62191 .62948 .6191 .63044 .62259 .62959 .625 Mtetra
.678 .422 .528 r
.62959 .625 .63044 .62259 .63138 .62561 .63053 .62767 Mtetra
.668 .403 .511 r
.63053 .62767 .63138 .62561 .6323 .62803 .63144 .6298 Mtetra
.646 .368 .484 r
.63144 .6298 .6323 .62803 .63321 .6298 .63234 .63134 Mtetra
.603 .309 .442 r
.63234 .63134 .63321 .6298 .6341 .63093 .63322 .6323 Mtetra
.519 .202 .37 r
.63322 .6323 .6341 .63093 .63497 .63143 .63409 .6327 Mtetra
.339 0 .231 r
.63409 .6327 .63497 .63143 .63582 .63133 .63494 .63255 Mtetra
0 0 0 r
.63494 .63255 .63582 .63133 .63665 .63063 .63578 .63187 Mtetra
.63 .839 .445 r
.63578 .63187 .63665 .63063 .63747 .62935 .63659 .63066 Mtetra
.909 .954 .614 r
.63659 .63066 .63747 .62935 .63827 .62744 .63739 .6289 Mtetra
.974 .925 .636 r
.63739 .6289 .63827 .62744 .63904 .6249 .63818 .62655 Mtetra
.988 .889 .624 r
.63818 .62655 .63904 .6249 .6398 .6217 .63894 .62362 Mtetra
.992 .865 .603 r
.63894 .62362 .6398 .6217 .64053 .61786 .63969 .62011 Mtetra
.996 .855 .578 r
.63969 .62011 .64053 .61786 .64124 .61349 .64041 .61611 Mtetra
.998 .854 .544 r
.64041 .61611 .64124 .61349 .64195 .60876 .64113 .6118 Mtetra
.985 .856 .483 r
.64113 .6118 .64195 .60876 .64265 .60398 .64185 .60744 Mtetra
.901 .819 .348 r
.64185 .60744 .64265 .60398 .64336 .59958 .64257 .60342 Mtetra
0 0 0 r
.64257 .60342 .64336 .59958 .64409 .59599 .64332 .60014 Mtetra
0 0 .289 r
.64332 .60014 .64409 .59599 .64487 .59365 .64411 .59797 Mtetra
.329 .13 .452 r
.64411 .59797 .64487 .59365 .6457 .59281 .64494 .59716 Mtetra
.498 .28 .513 r
.64494 .59716 .6457 .59281 .64659 .59352 .64582 .59775 Mtetra
.584 .356 .536 r
.64582 .59775 .64659 .59352 .64752 .5956 .64674 .59957 Mtetra
.632 .398 .545 r
.64674 .59957 .64752 .5956 .64848 .59868 .64769 .6023 Mtetra
.659 .42 .547 r
.64769 .6023 .64848 .59868 .64947 .60232 .64867 .60553 Mtetra
.674 .43 .544 r
.64867 .60553 .64947 .60232 .65046 .60607 .64965 .60885 Mtetra
.681 .43 .536 r
.64965 .60885 .65046 .60607 .65145 .60958 .65062 .61197 Mtetra
.679 .421 .525 r
.65062 .61197 .65145 .60958 .65242 .61261 .65158 .61465 Mtetra
.669 .401 .507 r
.65158 .61465 .65242 .61261 .65338 .61504 .65252 .61678 Mtetra
.646 .366 .48 r
.65252 .61678 .65338 .61504 .65431 .61681 .65345 .61833 Mtetra
.603 .305 .437 r
.65345 .61833 .65431 .61681 .65522 .61793 .65435 .61929 Mtetra
.517 .198 .364 r
.65435 .61929 .65522 .61793 .65611 .61843 .65524 .61968 Mtetra
.336 0 .224 r
.65524 .61968 .65611 .61843 .65698 .61832 .6561 .61953 Mtetra
0 0 0 r
.6561 .61953 .65698 .61832 .65782 .61762 .65695 .61885 Mtetra
.625 .836 .442 r
.65695 .61885 .65782 .61762 .65865 .61632 .65778 .61763 Mtetra
.904 .952 .608 r
.65778 .61763 .65865 .61632 .65945 .61439 .65859 .61584 Mtetra
.973 .926 .63 r
.65859 .61584 .65945 .61439 .66023 .61183 .65938 .61348 Mtetra
.989 .891 .617 r
.65938 .61348 .66023 .61183 .66099 .6086 .66014 .61052 Mtetra
.993 .867 .596 r
.66014 .61052 .66099 .6086 .66172 .60474 .66089 .607 Mtetra
.997 .857 .57 r
.66089 .607 .66172 .60474 .66243 .60034 .66161 .60298 Mtetra
.997 .856 .532 r
.66161 .60298 .66243 .60034 .66313 .5956 .66233 .59866 Mtetra
.979 .854 .465 r
.66233 .59866 .66313 .5956 .66382 .59083 .66304 .59431 Mtetra
.876 .803 .316 r
.66304 .59431 .66382 .59083 .66453 .58645 .66376 .59031 Mtetra
0 0 0 r
.66376 .59031 .66453 .58645 .66527 .58293 .66452 .58709 Mtetra
.016 0 .31 r
.66452 .58709 .66527 .58293 .66606 .58066 .66531 .585 Mtetra
.345 .145 .459 r
.66531 .585 .66606 .58066 .66691 .57992 .66616 .58428 Mtetra
.506 .286 .514 r
.66616 .58428 .66691 .57992 .66781 .58074 .66706 .58496 Mtetra
.588 .359 .536 r
.66706 .58496 .66781 .58074 .66877 .58291 .66802 .58688 Mtetra
.634 .399 .544 r
.66802 .58688 .66877 .58291 .66978 .58608 .669 .58968 Mtetra
.661 .42 .545 r
.669 .58968 .66978 .58608 .6708 .58978 .67001 .59297 Mtetra
.676 .43 .541 r
.67001 .59297 .6708 .58978 .67183 .59357 .67103 .59634 Mtetra
.682 .429 .534 r
.67103 .59634 .67183 .59357 .67285 .59711 .67203 .59948 Mtetra
.68 .42 .522 r
.67203 .59948 .67285 .59711 .67386 .60016 .67302 .60218 Mtetra
.669 .4 .504 r
.67302 .60218 .67386 .60016 .67484 .6026 .674 .60432 Mtetra
.646 .364 .476 r
.674 .60432 .67484 .6026 .6758 .60437 .67494 .60587 Mtetra
.603 .302 .433 r
.67494 .60587 .6758 .60437 .67673 .6055 .67587 .60684 Mtetra
.517 .194 .359 r
.67587 .60684 .67673 .6055 .67764 .60599 .67678 .60723 Mtetra
.335 0 .218 r
.67678 .60723 .67764 .60599 .67853 .60588 .67766 .60708 Mtetra
0 0 0 r
.67766 .60708 .67853 .60588 .67939 .60517 .67852 .6064 Mtetra
.615 .829 .434 r
.67852 .6064 .67939 .60517 .68023 .60386 .67936 .60517 Mtetra
.898 .95 .6 r
.67936 .60517 .68023 .60386 .68104 .60192 .68018 .60338 Mtetra
.971 .927 .623 r
.68018 .60338 .68104 .60192 .68182 .59934 .68097 .601 Mtetra
.989 .893 .61 r
.68097 .601 .68182 .59934 .68258 .59609 .68174 .59802 Mtetra
.994 .87 .588 r
.68174 .59802 .68258 .59609 .68331 .5922 .68249 .59447 Mtetra
.997 .859 .56 r
.68249 .59447 .68331 .5922 .68401 .58778 .68321 .59044 Mtetra
.995 .856 .519 r
.68321 .59044 .68401 .58778 .68471 .58302 .68392 .58611 Mtetra
.97 .85 .444 r
.68392 .58611 .68471 .58302 .6854 .57827 .68463 .58177 Mtetra
.845 .782 .281 r
.68463 .58177 .6854 .57827 .6861 .57392 .68536 .57781 Mtetra
0 0 .036 r
.68536 .57781 .6861 .57392 .68685 .57046 .68611 .57464 Mtetra
.055 0 .331 r
.68611 .57464 .68685 .57046 .68764 .56828 .68692 .57264 Mtetra
.362 .159 .465 r
.68692 .57264 .68764 .56828 .68851 .56765 .68779 .57201 Mtetra
.513 .291 .515 r
.68779 .57201 .68851 .56765 .68944 .56857 .68872 .5728 Mtetra
.592 .361 .535 r
.68872 .5728 .68944 .56857 .69044 .57085 .6897 .57481 Mtetra
.637 .4 .542 r
.6897 .57481 .69044 .57085 .69148 .5741 .69072 .5777 Mtetra
.663 .42 .543 r
.69072 .5777 .69148 .5741 .69254 .57787 .69177 .58104 Mtetra
.677 .429 .539 r
.69177 .58104 .69254 .57787 .69361 .58171 .69282 .58446 Mtetra
.683 .429 .531 r
.69282 .58446 .69361 .58171 .69467 .58528 .69386 .58763 Mtetra
.681 .419 .519 r
.69386 .58763 .69467 .58528 .69571 .58835 .69488 .59035 Mtetra
.67 .398 .5 r
.69488 .59035 .69571 .58835 .69672 .5908 .69588 .59251 Mtetra
.647 .362 .472 r
.69588 .59251 .69672 .5908 .69771 .59259 .69686 .59407 Mtetra
.603 .3 .429 r
.69686 .59407 .69771 .59259 .69867 .59372 .69781 .59505 Mtetra
.517 .191 .355 r
.69781 .59505 .69867 .59372 .6996 .59422 .69873 .59545 Mtetra
.336 0 .215 r
.69873 .59545 .6996 .59422 .7005 .5941 .69964 .5953 Mtetra
0 0 0 r
.69964 .5953 .7005 .5941 .70138 .59339 .70051 .59461 Mtetra
.598 .818 .421 r
.70051 .59461 .70138 .59339 .70222 .59207 .70137 .59338 Mtetra
.889 .947 .589 r
.70137 .59338 .70222 .59207 .70304 .59012 .70219 .59158 Mtetra
.968 .928 .614 r
.70219 .59158 .70304 .59012 .70383 .58752 .70299 .58919 Mtetra
.988 .895 .601 r
.70299 .58919 .70383 .58752 .70459 .58424 .70377 .5862 Mtetra
.994 .872 .579 r
.70377 .5862 .70459 .58424 .70532 .58033 .70451 .58263 Mtetra
.997 .861 .548 r
.70451 .58263 .70532 .58033 .70602 .57589 .70523 .57858 Mtetra
.992 .857 .503 r
.70523 .57858 .70602 .57589 .70671 .57113 .70594 .57425 Mtetra
.957 .844 .42 r
.70594 .57425 .70671 .57113 .70739 .56639 .70665 .56992 Mtetra
.808 .757 .241 r
.70665 .56992 .70739 .56639 .7081 .56208 .70737 .566 Mtetra
0 0 .078 r
.70737 .566 .7081 .56208 .70885 .55868 .70814 .56289 Mtetra
.092 0 .35 r
.70814 .56289 .70885 .55868 .70966 .5566 .70896 .56097 Mtetra
.377 .172 .47 r
.70896 .56097 .70966 .5566 .71054 .55607 .70984 .56045 Mtetra
.52 .297 .516 r
.70984 .56045 .71054 .55607 .71151 .5571 .7108 .56134 Mtetra
.596 .364 .535 r
.7108 .56134 .71151 .5571 .71254 .55949 .71182 .56345 Mtetra
.639 .401 .541 r
.71182 .56345 .71254 .55949 .71361 .56283 .71288 .56642 Mtetra
.664 .42 .541 r
.71288 .56642 .71361 .56283 .71472 .56667 .71396 .56983 Mtetra
.678 .429 .537 r
.71396 .56983 .71472 .56667 .71583 .57057 .71505 .5733 Mtetra
.684 .428 .529 r
.71505 .5733 .71583 .57057 .71693 .57417 .71613 .57651 Mtetra
.682 .418 .516 r
.71613 .57651 .71693 .57417 .718 .57727 .71718 .57925 Mtetra
.671 .396 .497 r
.71718 .57925 .718 .57727 .71905 .57973 .71822 .58143 Mtetra
.647 .36 .469 r
.71822 .58143 .71905 .57973 .72006 .58153 .71922 .58301 Mtetra
.603 .298 .425 r
.71922 .58301 .72006 .58153 .72104 .58267 .72019 .58399 Mtetra
.517 .19 .351 r
.72019 .58399 .72104 .58267 .722 .58317 .72114 .5844 Mtetra
.339 0 .214 r
.72114 .5844 .722 .58317 .72292 .58307 .72206 .58426 Mtetra
0 0 0 r
.72206 .58426 .72292 .58307 .72381 .58235 .72295 .58358 Mtetra
.72295 .58358 .72381 .58235 .72467 .58103 .72382 .58234 Mtetra
.877 .941 .574 r
.72382 .58234 .72467 .58103 .7255 .57907 .72466 .58053 Mtetra
.964 .928 .603 r
.72466 .58053 .7255 .57907 .72629 .57644 .72546 .57813 Mtetra
.987 .897 .591 r
.72546 .57813 .72629 .57644 .72705 .57315 .72624 .57512 Mtetra
.994 .874 .567 r
.72624 .57512 .72705 .57315 .72778 .56921 .72698 .57153 Mtetra
.995 .862 .535 r
.72698 .57153 .72778 .56921 .72848 .56475 .7277 .56747 Mtetra
.987 .855 .485 r
.7277 .56747 .72848 .56475 .72916 .55999 .72841 .56314 Mtetra
.941 .835 .393 r
.72841 .56314 .72916 .55999 .72984 .55525 .72911 .55883 Mtetra
.766 .727 .198 r
.72911 .55883 .72984 .55525 .73054 .55098 .72984 .55494 Mtetra
0 0 .119 r
.72984 .55494 .73054 .55098 .7313 .54765 .73061 .5519 Mtetra
.127 0 .367 r
.73061 .5519 .7313 .54765 .73212 .54566 .73145 .55006 Mtetra
.392 .185 .475 r
.73145 .55006 .73212 .54566 .73303 .54524 .73236 .54964 Mtetra
.527 .302 .517 r
.73236 .54964 .73303 .54524 .73403 .5464 .73334 .55064 Mtetra
.599 .366 .534 r
.73334 .55064 .73403 .5464 .73509 .54889 .73439 .55286 Mtetra
.641 .401 .54 r
.73439 .55286 .73509 .54889 .73621 .55233 .73549 .55591 Mtetra
.666 .42 .539 r
.73549 .55591 .73621 .55233 .73736 .55624 .73662 .5594 Mtetra
.68 .428 .535 r
.73662 .5594 .73736 .55624 .73851 .56019 .73775 .56292 Mtetra
.685 .427 .526 r
.73775 .56292 .73851 .56019 .73965 .56384 .73886 .56617 Mtetra
.682 .416 .513 r
.73886 .56617 .73965 .56384 .74076 .56696 .73996 .56894 Mtetra
.671 .395 .494 r
.73996 .56894 .74076 .56696 .74184 .56945 .74102 .57114 Mtetra
.648 .358 .465 r
.74102 .57114 .74184 .56945 .74289 .57126 .74205 .57273 Mtetra
.603 .296 .421 r
.74205 .57273 .74289 .57126 .74389 .57241 .74305 .57373 Mtetra
.518 .188 .348 r
.74305 .57373 .74389 .57241 .74487 .57292 .74402 .57415 Mtetra
.342 0 .215 r
.74402 .57415 .74487 .57292 .74581 .57281 .74496 .57401 Mtetra
0 0 0 r
.74496 .57401 .74581 .57281 .74672 .5721 .74587 .57333 Mtetra
.74587 .57333 .74672 .5721 .74759 .57077 .74675 .57209 Mtetra
.861 .934 .555 r
.74675 .57209 .74759 .57077 .74843 .56879 .7476 .57028 Mtetra
.958 .928 .589 r
.7476 .57028 .74843 .56879 .74923 .56615 .74841 .56786 Mtetra
.985 .898 .578 r
.74841 .56786 .74923 .56615 .74999 .56283 .74919 .56483 Mtetra
.992 .876 .554 r
.74919 .56483 .74999 .56283 .75072 .55888 .74994 .56123 Mtetra
.992 .863 .519 r
.74994 .56123 .75072 .55888 .75141 .5544 .75066 .55716 Mtetra
.979 .853 .464 r
.75066 .55716 .75141 .5544 .75209 .54962 .75136 .55282 Mtetra
.921 .822 .361 r
.75136 .55282 .75209 .54962 .75276 .5449 .75206 .54852 Mtetra
.717 .691 .152 r
.75206 .54852 .75276 .5449 .75347 .54067 .75279 .54467 Mtetra
0 0 .159 r
.75279 .54467 .75347 .54067 .75423 .53741 .75357 .5417 Mtetra
.159 0 .383 r
.75357 .5417 .75423 .53741 .75507 .53551 .75442 .53995 Mtetra
.405 .197 .48 r
.75442 .53995 .75507 .53551 .756 .53521 .75535 .53964 Mtetra
.533 .307 .518 r
.75535 .53964 .756 .53521 .75703 .53648 .75637 .54075 Mtetra
.603 .368 .533 r
.75637 .54075 .75703 .53648 .75814 .53909 .75746 .54306 Mtetra
.643 .402 .538 r
.75746 .54306 .75814 .53909 .7593 .54262 .7586 .54621 Mtetra
.667 .42 .537 r
.7586 .54621 .7593 .54262 .7605 .54661 .75977 .54977 Mtetra
.681 .428 .532 r
.75977 .54977 .7605 .54661 .76169 .55061 .76094 .55334 Mtetra
.686 .426 .524 r
.76094 .55334 .76169 .55061 .76287 .5543 .7621 .55663 Mtetra
.683 .415 .51 r
.7621 .55663 .76287 .5543 .76402 .55745 .76323 .55943 Mtetra
.672 .393 .491 r
.76323 .55943 .76402 .55745 .76514 .55996 .76432 .56165 Mtetra
.648 .356 .462 r
.76432 .56165 .76514 .55996 .76621 .56179 .76539 .56326 Mtetra
.603 .294 .418 r
.76539 .56326 .76621 .56179 .76725 .56295 .76641 .56427 Mtetra
.518 .187 .346 r
.76641 .56427 .76725 .56295 .76825 .56346 .76741 .5647 Mtetra
.346 0 .217 r
.76741 .5647 .76825 .56346 .76921 .56336 .76837 .56457 Mtetra
0 0 0 r
.76837 .56457 .76921 .56336 .77013 .56265 .76929 .56389 Mtetra
.76929 .56389 .77013 .56265 .77102 .56131 .77019 .56265 Mtetra
.842 .923 .533 r
.77019 .56265 .77102 .56131 .77187 .55932 .77105 .56083 Mtetra
.95 .926 .572 r
.77105 .56083 .77187 .55932 .77268 .55666 .77187 .5584 Mtetra
.981 .899 .563 r
.77187 .5584 .77268 .55666 .77344 .55332 .77265 .55535 Mtetra
.989 .877 .538 r
.77265 .55535 .77344 .55332 .77416 .54933 .7734 .55173 Mtetra
.988 .862 .5 r
.7734 .55173 .77416 .54933 .77485 .54483 .77411 .54764 Mtetra
.968 .848 .44 r
.77411 .54764 .77485 .54483 .77552 .54005 .77481 .54329 Mtetra
.895 .806 .326 r
.77481 .54329 .77552 .54005 .7762 .53533 .77552 .53901 Mtetra
0 0 0 r
.77552 .53901 .7762 .53533 .7769 .53114 .77625 .5352 Mtetra
0 0 .195 r
.77625 .5352 .7769 .53114 .77767 .52795 .77704 .53229 Mtetra
.189 .013 .397 r
.77704 .53229 .77767 .52795 .77853 .52615 .7779 .53063 Mtetra
.418 .208 .484 r
.7779 .53063 .77853 .52615 .77949 .52596 .77886 .53042 Mtetra
.539 .312 .519 r
.77886 .53042 .77949 .52596 .78055 .52735 .77992 .53164 Mtetra
.606 .37 .533 r
.77992 .53164 .78055 .52735 .7817 .53007 .78105 .53406 Mtetra
.645 .402 .537 r
.78105 .53406 .7817 .53007 .78291 .5337 .78223 .5373 Mtetra
.669 .42 .535 r
.78223 .5373 .78291 .5337 .78415 .53776 .78344 .54093 Mtetra
.681 .427 .53 r
.78344 .54093 .78415 .53776 .7854 .54182 .78466 .54456 Mtetra
.686 .424 .521 r
.78466 .54456 .7854 .54182 .78662 .54555 .78586 .54788 Mtetra
.683 .413 .507 r
.78586 .54788 .78662 .54555 .78781 .54873 .78703 .55072 Mtetra
.672 .391 .488 r
.78703 .55072 .78781 .54873 .78896 .55126 .78816 .55296 Mtetra
.647 .353 .459 r
.78816 .55296 .78896 .55126 .79007 .5531 .78925 .55458 Mtetra
.602 .291 .415 r
.78925 .55458 .79007 .5531 .79113 .55427 .79031 .55561 Mtetra
.518 .186 .344 r
.79031 .55561 .79113 .55427 .79216 .5548 .79132 .55605 Mtetra
.35 0 .219 r
.79132 .55605 .79216 .5548 .79314 .5547 .79231 .55592 Mtetra
.012 0 0 r
.79231 .55592 .79314 .5547 .79408 .55398 .79325 .55524 Mtetra
0 0 0 r
.79325 .55524 .79408 .55398 .79499 .55263 .79416 .554 Mtetra
.819 .909 .506 r
.79416 .554 .79499 .55263 .79584 .55063 .79503 .55216 Mtetra
.939 .922 .552 r
.79503 .55216 .79584 .55063 .79665 .54794 .79586 .54971 Mtetra
.975 .898 .545 r
.79586 .54971 .79665 .54794 .79742 .54457 .79665 .54664 Mtetra
.985 .876 .52 r
.79665 .54664 .79742 .54457 .79814 .54055 .79739 .54299 Mtetra
.981 .86 .479 r
.79739 .54299 .79814 .54055 .79883 .53603 .79811 .53888 Mtetra
.954 .84 .412 r
.79811 .53888 .79883 .53603 .79949 .53123 .79881 .53453 Mtetra
.864 .785 .287 r
.79881 .53453 .79949 .53123 .80017 .52652 .79951 .53026 Mtetra
0 0 0 r
.79951 .53026 .80017 .52652 .80087 .52237 .80024 .52648 Mtetra
0 0 .229 r
.80024 .52648 .80087 .52237 .80165 .51925 .80104 .52363 Mtetra
.216 .037 .41 r
.80104 .52363 .80165 .51925 .80253 .51754 .80193 .52207 Mtetra
.43 .217 .488 r
.80193 .52207 .80253 .51754 .80352 .51746 .80292 .52196 Mtetra
.544 .316 .52 r
.80292 .52196 .80352 .51746 .80462 .51897 .80401 .52329 Mtetra
.609 .371 .532 r
.80401 .52329 .80462 .51897 .80581 .5218 .80518 .52581 Mtetra
.647 .403 .535 r
.80518 .52581 .80581 .5218 .80707 .52552 .80641 .52914 Mtetra
.67 .419 .533 r
.80641 .52914 .80707 .52552 .80836 .52967 .80767 .53284 Mtetra
.682 .426 .528 r
.80767 .53284 .80836 .52967 .80965 .53378 .80893 .53653 Mtetra
.686 .423 .518 r
.80893 .53653 .80965 .53378 .81092 .53755 .81017 .53989 Mtetra
.683 .411 .504 r
.81017 .53989 .81092 .53755 .81215 .54076 .81138 .54275 Mtetra
.671 .389 .484 r
.81138 .54275 .81215 .54076 .81334 .54331 .81255 .54502 Mtetra
.647 .351 .455 r
.81255 .54502 .81334 .54331 .81448 .54516 .81367 .54666 Mtetra
.601 .289 .412 r
.81367 .54666 .81448 .54516 .81558 .54634 .81476 .54769 Mtetra
.517 .185 .343 r
.81476 .54769 .81558 .54634 .81663 .54687 .8158 .54814 Mtetra
.352 .001 .222 r
.8158 .54814 .81663 .54687 .81763 .54677 .81681 .54802 Mtetra
.028 0 .007 r
.81681 .54802 .81763 .54677 .81859 .54604 .81777 .54733 Mtetra
0 0 0 r
.81777 .54733 .81859 .54604 .81951 .54468 .8187 .54608 Mtetra
.793 .891 .476 r
.8187 .54608 .81951 .54468 .82038 .54266 .81958 .54423 Mtetra
.925 .915 .529 r
.81958 .54423 .82038 .54266 .8212 .53994 .82041 .54175 Mtetra
.967 .896 .525 r
.82041 .54175 .8212 .53994 .82196 .53654 .8212 .53866 Mtetra
.978 .874 .499 r
.8212 .53866 .82196 .53654 .82268 .53249 .82195 .53498 Mtetra
.971 .855 .455 r
.82195 .53498 .82268 .53249 .82336 .52793 .82266 .53084 Mtetra
.937 .829 .381 r
.82266 .53084 .82336 .52793 .82402 .52311 .82336 .52648 Mtetra
.827 .759 .245 r
.82336 .52648 .82402 .52311 .82469 .51842 .82406 .52221 Mtetra
0 0 0 r
.82406 .52221 .82469 .51842 .8254 .5143 .8248 .51847 Mtetra
0 0 .259 r
.8248 .51847 .8254 .5143 .82619 .51124 .82561 .51568 Mtetra
.241 .058 .421 r
.82561 .51568 .82619 .51124 .82709 .50962 .82652 .5142 Mtetra
.44 .226 .491 r
.82652 .5142 .82709 .50962 .82811 .50965 .82754 .5142 Mtetra
.549 .32 .52 r
.82754 .5142 .82811 .50965 .82925 .51128 .82867 .51564 Mtetra
.611 .372 .531 r
.82867 .51564 .82925 .51128 .83049 .51422 .82988 .51826 Mtetra
.648 .403 .534 r
.82988 .51826 .83049 .51422 .8318 .51804 .83116 .52168 Mtetra
.67 .419 .531 r
.83116 .52168 .8318 .51804 .83314 .52225 .83247 .52545 Mtetra
.682 .424 .525 r
.83247 .52545 .83314 .52225 .83448 .52643 .83378 .52919 Mtetra
.686 .421 .516 r
.83378 .52919 .83448 .52643 .8358 .53024 .83507 .53259 Mtetra
.683 .409 .502 r
.83507 .53259 .8358 .53024 .83708 .53347 .83632 .53547 Mtetra
.67 .386 .481 r
.83632 .53547 .83708 .53347 .83831 .53603 .83752 .53776 Mtetra
.645 .348 .452 r
.83752 .53776 .83831 .53603 .83948 .5379 .83868 .53941 Mtetra
.6 .286 .409 r
.83868 .53941 .83948 .5379 .84061 .53908 .8398 .54045 Mtetra
.516 .183 .341 r
.8398 .54045 .84061 .53908 .84168 .53961 .84087 .5409 Mtetra
.354 .004 .226 r
.84087 .5409 .84168 .53961 .84271 .5395 .84189 .54078 Mtetra
.042 0 .023 r
.84189 .54078 .84271 .5395 .84369 .53877 .84288 .54009 Mtetra
0 0 0 r
.84288 .54009 .84369 .53877 .84462 .53739 .84382 .53882 Mtetra
.765 .871 .444 r
.84382 .53882 .84462 .53739 .8455 .53534 .84471 .53695 Mtetra
.909 .906 .503 r
.84471 .53695 .8455 .53534 .84632 .53259 .84555 .53445 Mtetra
.956 .891 .502 r
.84555 .53445 .84632 .53259 .84709 .52915 .84635 .53132 Mtetra
.968 .869 .475 r
.84635 .53132 .84709 .52915 .84781 .52506 .8471 .52761 Mtetra
.958 .848 .428 r
.8471 .52761 .84781 .52506 .84849 .52047 .84781 .52344 Mtetra
.915 .815 .348 r
.84781 .52344 .84849 .52047 .84914 .51563 .8485 .51906 Mtetra
.786 .73 .201 r
.8485 .51906 .84914 .51563 .84981 .51093 .8492 .5148 Mtetra
0 0 .038 r
.8492 .5148 .84981 .51093 .85052 .50684 .84995 .51108 Mtetra
0 0 .286 r
.84995 .51108 .85052 .50684 .85132 .50384 .85077 .50836 Mtetra
.263 .077 .431 r
.85077 .50836 .85132 .50384 .85224 .50232 .8517 .50696 Mtetra
.449 .234 .494 r
.8517 .50696 .85224 .50232 .85329 .50246 .85275 .50706 Mtetra
.553 .323 .52 r
.85275 .50706 .85329 .50246 .85447 .5042 .85392 .5086 Mtetra
.613 .373 .53 r
.85392 .5086 .85447 .5042 .85577 .50725 .85519 .51133 Mtetra
.649 .402 .532 r
.85519 .51133 .85577 .50725 .85713 .51116 .85652 .51483 Mtetra
.671 .418 .529 r
.85652 .51483 .85713 .51116 .85853 .51545 .85788 .51867 Mtetra
.683 .423 .523 r
.85788 .51867 .85853 .51545 .85992 .51968 .85924 .52245 Mtetra
.686 .419 .513 r
.85924 .52245 .85992 .51968 .86129 .52352 .86057 .52589 Mtetra
.682 .407 .499 r
.86057 .52589 .86129 .52352 .86261 .52678 .86186 .5288 Mtetra
.669 .383 .478 r
.86186 .5288 .86261 .52678 .86388 .52935 .86311 .5311 Mtetra
.644 .344 .449 r
.86311 .5311 .86388 .52935 .86509 .53123 .8643 .53276 Mtetra
.597 .282 .406 r
.8643 .53276 .86509 .53123 .86625 .53241 .86545 .5338 Mtetra
.513 .18 .34 r
.86545 .5338 .86625 .53241 .86735 .53294 .86654 .53425 Mtetra
.354 .006 .228 r
.86654 .53425 .86735 .53294 .8684 .53282 .86759 .53412 Mtetra
.054 0 .038 r
.86759 .53412 .8684 .53282 .8694 .53207 .8686 .53342 Mtetra
0 0 0 r
.8686 .53342 .8694 .53207 .87035 .53067 .86955 .53214 Mtetra
.736 .849 .41 r
.86955 .53214 .87035 .53067 .87123 .52859 .87046 .53024 Mtetra
.89 .894 .474 r
.87046 .53024 .87123 .52859 .87206 .52581 .87131 .52771 Mtetra
.943 .883 .476 r
.87131 .52771 .87206 .52581 .87283 .52232 .87211 .52454 Mtetra
.956 .862 .45 r
.87211 .52454 .87283 .52232 .87355 .51818 .87286 .52079 Mtetra
.943 .838 .399 r
.87286 .52079 .87355 .51818 .87422 .51355 .87357 .51659 Mtetra
.889 .797 .312 r
.87357 .51659 .87422 .51355 .87487 .50868 .87426 .51218 Mtetra
.741 .696 .156 r
.87426 .51218 .87487 .50868 .87553 .50398 .87496 .50792 Mtetra
0 0 .082 r
.87496 .50792 .87553 .50398 .87625 .49992 .87571 .50424 Mtetra
0 0 .31 r
.87571 .50424 .87625 .49992 .87706 .49698 .87655 .50156 Mtetra
.282 .094 .44 r
.87655 .50156 .87706 .49698 .878 .49555 .8775 .50025 Mtetra
.458 .242 .497 r
.8775 .50025 .878 .49555 .87909 .4958 .87858 .50045 Mtetra
.557 .325 .52 r
.87858 .50045 .87909 .4958 .88032 .49765 .87979 .5021 Mtetra
.615 .374 .529 r
.87979 .5021 .88032 .49765 .88166 .50081 .88111 .50492 Mtetra
.65 .402 .53 r
.88111 .50492 .88166 .50081 .88308 .50481 .88249 .5085 Mtetra
.671 .417 .527 r
.88249 .5085 .88308 .50481 .88453 .50917 .88391 .51241 Mtetra
.683 .421 .52 r
.88391 .51241 .88453 .50917 .88598 .51344 .88532 .51624 Mtetra
.686 .417 .51 r
.88532 .51624 .88598 .51344 .8874 .51732 .8867 .51971 Mtetra
.682 .404 .495 r
.8867 .51971 .8874 .51732 .88877 .5206 .88804 .52264 Mtetra
.668 .38 .475 r
.88804 .52264 .88877 .5206 .89008 .52318 .88932 .52495 Mtetra
.642 .341 .446 r
.88932 .52495 .89008 .52318 .89133 .52506 .89055 .52661 Mtetra
.595 .278 .403 r
.89055 .52661 .89133 .52506 .89252 .52625 .89173 .52766 Mtetra
.51 .177 .338 r
.89173 .52766 .89252 .52625 .89365 .52677 .89285 .5281 Mtetra
.353 .006 .23 r
.89285 .5281 .89365 .52677 .89472 .52664 .89393 .52797 Mtetra
.063 0 .051 r
.89393 .52797 .89472 .52664 .89574 .52587 .89495 .52725 Mtetra
0 0 0 r
.89495 .52725 .89574 .52587 .8967 .52444 .89593 .52594 Mtetra
.706 .825 .376 r
.89593 .52594 .8967 .52444 .8976 .52232 .89684 .52402 Mtetra
.869 .88 .444 r
.89684 .52402 .8976 .52232 .89844 .5195 .8977 .52145 Mtetra
.928 .873 .449 r
.8977 .52145 .89844 .5195 .89921 .51596 .8985 .51824 Mtetra
.941 .853 .421 r
.8985 .51824 .89921 .51596 .89992 .51177 .89925 .51444 Mtetra
.923 .825 .368 r
.89925 .51444 .89992 .51177 .90058 .50709 .89996 .5102 Mtetra
.859 .776 .273 r
.89996 .5102 .90058 .50709 .90123 .50219 .90064 .50577 Mtetra
0 0 0 r
.90064 .50577 .90123 .50219 .90189 .49748 .90135 .5015 Mtetra
0 0 .122 r
.90135 .5015 .90189 .49748 .90261 .49345 .9021 .49784 Mtetra
.018 0 .331 r
.9021 .49784 .90261 .49345 .90344 .49057 .90296 .49522 Mtetra
.3 .11 .447 r
.90296 .49522 .90344 .49057 .9044 .48922 .90393 .49398 Mtetra
.465 .248 .499 r
.90393 .49398 .9044 .48922 .90553 .48957 .90505 .49428 Mtetra
.56 .328 .52 r
.90505 .49428 .90553 .48957 .9068 .49154 .90631 .49603 Mtetra
.617 .374 .527 r
.90631 .49603 .9068 .49154 .9082 .4948 .90768 .49895 Mtetra
.651 .401 .528 r
.90768 .49895 .9082 .4948 .90968 .49889 .90912 .50261 Mtetra
.672 .415 .525 r
.90912 .50261 .90968 .49889 .91119 .50331 .91059 .50658 Mtetra
.682 .419 .518 r
.91059 .50658 .91119 .50331 .9127 .50764 .91205 .51046 Mtetra
.685 .415 .507 r
.91205 .51046 .9127 .50764 .91417 .51154 .91348 .51395 Mtetra
.681 .401 .492 r
.91348 .51395 .91417 .51154 .91558 .51484 .91487 .5169 Mtetra
.666 .377 .471 r
.91487 .5169 .91558 .51484 .91694 .51743 .91619 .51922 Mtetra
.639 .337 .442 r
.91619 .51922 .91694 .51743 .91822 .51931 .91746 .52089 Mtetra
.591 .274 .4 r
.91746 .52089 .91822 .51931 .91945 .52049 .91867 .52193 Mtetra
.506 .173 .336 r
.91867 .52193 .91945 .52049 .92061 .521 .91982 .52237 Mtetra
.35 .006 .232 r
.91982 .52237 .92061 .521 .92171 .52086 .92092 .52222 Mtetra
.07 0 .063 r
.92092 .52222 .92171 .52086 .92275 .52006 .92197 .52148 Mtetra
0 0 0 r
.92197 .52148 .92275 .52006 .92372 .5186 .92296 .52015 Mtetra
.676 .799 .341 r
.92296 .52015 .92372 .5186 .92463 .51645 .92389 .51818 Mtetra
.847 .863 .413 r
.92389 .51818 .92463 .51645 .92547 .51357 .92475 .51557 Mtetra
.91 .861 .419 r
.92475 .51557 .92547 .51357 .92624 .50998 .92556 .51231 Mtetra
.923 .841 .391 r
.92556 .51231 .92624 .50998 .92695 .50573 .9263 .50847 Mtetra
.901 .81 .334 r
.9263 .50847 .92695 .50573 .92761 .501 .92701 .50418 Mtetra
.826 .752 .234 r
.92701 .50418 .92761 .501 .92824 .49607 .92769 .49972 Mtetra
0 0 0 r
.92769 .49972 .92824 .49607 .9289 .49135 .92839 .49544 Mtetra
0 0 .158 r
.92839 .49544 .9289 .49135 .92963 .48733 .92916 .4918 Mtetra
.052 0 .349 r
.92916 .4918 .92963 .48733 .93047 .48451 .93002 .48923 Mtetra
.315 .123 .454 r
.93002 .48923 .93047 .48451 .93146 .48324 .93103 .48807 Mtetra
.472 .253 .5 r
.93103 .48807 .93146 .48324 .93263 .4837 .93219 .48846 Mtetra
.563 .33 .519 r
.93219 .48846 .93263 .4837 .93395 .48578 .93349 .49032 Mtetra
.618 .374 .526 r
.93349 .49032 .93395 .48578 .93541 .48914 .93491 .49333 Mtetra
.652 .4 .526 r
.93491 .49333 .93541 .48914 .93695 .49331 .93641 .49707 Mtetra
.672 .414 .522 r
.93641 .49707 .93695 .49331 .93852 .4978 .93794 .5011 Mtetra
.682 .417 .515 r
.93794 .5011 .93852 .4978 .94009 .50217 .93946 .50502 Mtetra
.685 .412 .504 r
.93946 .50502 .94009 .50217 .94161 .50611 .94094 .50854 Mtetra
.679 .398 .489 r
.94094 .50854 .94161 .50611 .94308 .50942 .94237 .5115 Mtetra
.665 .373 .468 r
.94237 .5115 .94308 .50942 .94447 .51202 .94374 .51383 Mtetra
.637 .332 .438 r
.94374 .51383 .94447 .51202 .9458 .5139 .94505 .5155 Mtetra
.588 .269 .396 r
.94505 .5155 .9458 .5139 .94706 .51507 .94629 .51653 Mtetra
.502 .168 .333 r
.94629 .51653 .94706 .51507 .94825 .51556 .94748 .51696 Mtetra
.347 .004 .233 r
.94748 .51696 .94825 .51556 .94937 .5154 .9486 .51679 Mtetra
.075 0 .073 r
.9486 .51679 .94937 .5154 .95043 .51458 .94967 .51603 Mtetra
0 0 0 r
.94967 .51603 .95043 .51458 .95142 .51308 .95067 .51467 Mtetra
.647 .774 .308 r
.95067 .51467 .95142 .51308 .95234 .51088 .95161 .51266 Mtetra
.822 .844 .38 r
.95161 .51266 .95234 .51088 .95319 .50795 .95249 .51 Mtetra
.89 .846 .388 r
.95249 .51 .95319 .50795 .95396 .50429 .95329 .50669 Mtetra
.903 .826 .36 r
.95329 .50669 .95396 .50429 .95466 .49999 .95404 .50279 Mtetra
.876 .791 .299 r
.95404 .50279 .95466 .49999 .95531 .4952 .95474 .49846 Mtetra
.789 .724 .193 r
.95474 .49846 .95531 .4952 .95594 .49023 .95542 .49396 Mtetra
0 0 0 r
.95542 .49396 .95594 .49023 .95659 .48549 .95612 .48967 Mtetra
0 0 .192 r
.95612 .48967 .95659 .48549 .95732 .4815 .95689 .48604 Mtetra
.082 0 .365 r
.95689 .48604 .95732 .4815 .95818 .47872 .95778 .48352 Mtetra
.329 .136 .459 r
.95778 .48352 .95818 .47872 .9592 .47755 .95881 .48244 Mtetra
.478 .258 .502 r
.95881 .48244 .9592 .47755 .96041 .47811 .96001 .48293 Mtetra
.566 .331 .519 r
.96001 .48293 .96041 .47811 .96179 .48029 .96137 .48488 Mtetra
.619 .374 .525 r
.96137 .48488 .96179 .48029 .9633 .48375 .96284 .48798 Mtetra
.652 .399 .524 r
.96284 .48798 .9633 .48375 .96491 .48801 .9644 .4918 Mtetra
.672 .412 .52 r
.9644 .4918 .96491 .48801 .96654 .49257 .96599 .49589 Mtetra
.682 .415 .512 r
.96599 .49589 .96654 .49257 .96817 .49698 .96757 .49985 Mtetra
.684 .409 .501 r
.96757 .49985 .96817 .49698 .96975 .50094 .96911 .5034 Mtetra
.678 .395 .485 r
.96911 .5034 .96975 .50094 .97127 .50426 .97058 .50637 Mtetra
.663 .369 .464 r
.97058 .50637 .97127 .50426 .97271 .50686 .972 .5087 Mtetra
.634 .328 .435 r
.972 .5087 .97271 .50686 .97408 .50874 .97334 .51036 Mtetra
.584 .264 .393 r
.97334 .51036 .97408 .50874 .97537 .5099 .97462 .51139 Mtetra
.497 .163 .331 r
.97462 .51139 .97537 .5099 .97659 .51038 .97584 .5118 Mtetra
.343 .002 .234 r
.97584 .5118 .97659 .51038 .97774 .51019 .97699 .51162 Mtetra
.078 0 .083 r
.97699 .51162 .97774 .51019 .97882 .50934 .97807 .51083 Mtetra
0 0 0 r
.97807 .51083 .97882 .50934 .97983 .5078 .9791 .50942 Mtetra
.9791 .50942 .97983 .5078 .98076 .50555 .98005 .50738 Mtetra
.796 .823 .347 r
.98005 .50738 .98076 .50555 .98161 .50256 .98093 .50466 Mtetra
.867 .829 .356 r
.98093 .50466 .98161 .50256 .98237 .49884 .98173 .50129 Mtetra
.88 .809 .327 r
.98173 .50129 .98237 .49884 .98307 .49447 .98248 .49734 Mtetra
.847 .77 .263 r
.98248 .49734 .98307 .49447 .98371 .48962 .98317 .49295 Mtetra
.75 .694 .152 r
.98317 .49295 .98371 .48962 .98434 .4846 .98385 .48841 Mtetra
0 0 .019 r
.98385 .48841 .98434 .4846 .98499 .47985 .98455 .48411 Mtetra
0 0 .222 r
.98455 .48411 .98499 .47985 .98572 .47587 .98533 .4805 Mtetra
.11 0 .38 r
.98533 .4805 .98572 .47587 .9866 .47315 .98623 .47803 Mtetra
.342 .147 .464 r
.98623 .47803 .9866 .47315 .98765 .47206 .9873 .47702 Mtetra
.443 .21 .464 r
.52399 .68503 .52488 .68195 .52565 .68205 .52476 .68507 Mtetra
.579 .34 .518 r
.52476 .68507 .52565 .68205 .52643 .68342 .52554 .68628 Mtetra
.641 .399 .537 r
.52554 .68628 .52643 .68342 .52722 .68577 .52632 .6884 Mtetra
.673 .429 .543 r
.52632 .6884 .52722 .68577 .52801 .68873 .52711 .69107 Mtetra
.691 .442 .542 r
.52711 .69107 .52801 .68873 .52881 .69189 .52791 .69393 Mtetra
.698 .444 .536 r
.52791 .69393 .52881 .69189 .52961 .69493 .5287 .69667 Mtetra
.698 .436 .524 r
.5287 .69667 .52961 .69493 .5304 .69759 .5295 .69907 Mtetra
.69 .417 .505 r
.5295 .69907 .5304 .69759 .5312 .69975 .53029 .70101 Mtetra
.669 .38 .474 r
.53029 .70101 .5312 .69975 .53199 .70135 .53108 .70243 Mtetra
.627 .314 .421 r
.53108 .70243 .53199 .70135 .53277 .70236 .53186 .70331 Mtetra
.534 .184 .321 r
.53186 .70331 .53277 .70236 .53356 .70283 .53264 .70369 Mtetra
.297 0 .094 r
.53264 .70369 .53356 .70283 .53433 .70276 .53342 .70358 Mtetra
0 0 0 r
.53342 .70358 .53433 .70276 .53511 .70216 .5342 .70299 Mtetra
.839 .994 .748 r
.5342 .70299 .53511 .70216 .53588 .70105 .53496 .70192 Mtetra
.941 .942 .76 r
.53496 .70192 .53588 .70105 .53664 .6994 .53573 .70036 Mtetra
.951 .879 .727 r
.53573 .70036 .53664 .6994 .5374 .6972 .53649 .69828 Mtetra
.95 .839 .698 r
.53649 .69828 .5374 .6972 .53815 .69441 .53724 .69568 Mtetra
.951 .816 .675 r
.53724 .69568 .53815 .69441 .5389 .69106 .53799 .69255 Mtetra
.955 .806 .657 r
.53799 .69255 .5389 .69106 .53964 .6872 .53874 .68896 Mtetra
.963 .809 .642 r
.53874 .68896 .53964 .6872 .54037 .68299 .53948 .68503 Mtetra
.977 .824 .624 r
.53948 .68503 .54037 .68299 .54111 .67865 .54022 .681 Mtetra
.993 .855 .595 r
.54022 .681 .54111 .67865 .54184 .67454 .54096 .67717 Mtetra
.97 .884 .506 r
.54096 .67717 .54184 .67454 .54259 .67105 .5417 .67392 Mtetra
0 0 0 r
.5417 .67392 .54259 .67105 .54334 .66857 .54246 .67159 Mtetra
.12 0 .306 r
.54246 .67159 .54334 .66857 .54411 .66737 .54323 .67044 Mtetra
.454 .219 .468 r
.54323 .67044 .54411 .66737 .54489 .66754 .54401 .67055 Mtetra
.583 .343 .518 r
.54401 .67055 .54489 .66754 .54569 .66898 .54481 .67182 Mtetra
.643 .4 .536 r
.54481 .67182 .54569 .66898 .5465 .67138 .54562 .67399 Mtetra
.675 .429 .541 r
.54562 .67399 .5465 .67138 .54732 .67438 .54643 .67669 Mtetra
.692 .442 .54 r
.54643 .67669 .54732 .67438 .54815 .67756 .54726 .67957 Mtetra
.699 .443 .533 r
.54726 .67957 .54815 .67756 .54897 .6806 .54808 .68232 Mtetra
.699 .435 .521 r
.54808 .68232 .54897 .6806 .54979 .68326 .5489 .68472 Mtetra
.69 .414 .5 r
.5489 .68472 .54979 .68326 .55061 .68541 .54971 .68664 Mtetra
.669 .376 .468 r
.54971 .68664 .55061 .68541 .55142 .68698 .55052 .68804 Mtetra
.625 .307 .413 r
.55052 .68804 .55142 .68698 .55223 .68798 .55132 .68891 Mtetra
.528 .172 .308 r
.55132 .68891 .55223 .68798 .55302 .68843 .55212 .68927 Mtetra
.278 0 .069 r
.55212 .68927 .55302 .68843 .55382 .68833 .55291 .68914 Mtetra
0 0 0 r
.55291 .68914 .55382 .68833 .5546 .68772 .55369 .68853 Mtetra
.846 .995 .754 r
.55369 .68853 .5546 .68772 .55538 .68658 .55447 .68743 Mtetra
.942 .94 .759 r
.55447 .68743 .55538 .68658 .55615 .6849 .55524 .68585 Mtetra
.952 .879 .726 r
.55524 .68585 .55615 .6849 .55691 .68266 .55601 .68374 Mtetra
.952 .839 .696 r
.55601 .68374 .55691 .68266 .55767 .67985 .55677 .6811 Mtetra
.952 .817 .673 r
.55677 .6811 .55767 .67985 .55841 .67646 .55752 .67794 Mtetra
.957 .808 .655 r
.55752 .67794 .55841 .67646 .55915 .67257 .55826 .67432 Mtetra
.966 .811 .638 r
.55826 .67432 .55915 .67257 .55988 .66832 .559 .67037 Mtetra
.98 .827 .62 r
.559 .67037 .55988 .66832 .56061 .66398 .55973 .66633 Mtetra
.995 .859 .587 r
.55973 .66633 .56061 .66398 .56135 .65988 .56047 .66251 Mtetra
.96 .881 .487 r
.56047 .66251 .56135 .65988 .56209 .65642 .56122 .65929 Mtetra
0 0 0 r
.56122 .65929 .56209 .65642 .56285 .654 .56198 .65701 Mtetra
.151 0 .322 r
.56198 .65701 .56285 .654 .56363 .65286 .56276 .65592 Mtetra
.464 .228 .471 r
.56276 .65592 .56363 .65286 .56443 .65311 .56356 .65611 Mtetra
.587 .346 .517 r
.56356 .65611 .56443 .65311 .56525 .65462 .56438 .65744 Mtetra
.646 .401 .534 r
.56438 .65744 .56525 .65462 .56609 .65708 .56521 .65966 Mtetra
.677 .429 .539 r
.56521 .65966 .56609 .65708 .56693 .66011 .56606 .6624 Mtetra
.693 .441 .537 r
.56606 .6624 .56693 .66011 .56779 .66332 .5669 .6653 Mtetra
.7 .442 .53 r
.5669 .6653 .56779 .66332 .56864 .66637 .56775 .66806 Mtetra
.699 .433 .517 r
.56775 .66806 .56864 .66637 .56949 .66902 .56859 .67045 Mtetra
.69 .412 .496 r
.56859 .67045 .56949 .66902 .57033 .67116 .56943 .67237 Mtetra
.668 .372 .462 r
.56943 .67237 .57033 .67116 .57116 .67272 .57026 .67376 Mtetra
.623 .301 .405 r
.57026 .67376 .57116 .67272 .57198 .67371 .57108 .67461 Mtetra
.522 .161 .295 r
.57108 .67461 .57198 .67371 .5728 .67413 .57189 .67496 Mtetra
.26 0 .045 r
.57189 .67496 .5728 .67413 .5736 .67402 .5727 .67481 Mtetra
0 0 0 r
.5727 .67481 .5736 .67402 .5744 .67339 .5735 .67418 Mtetra
.852 .995 .76 r
.5735 .67418 .5744 .67339 .57519 .67223 .57428 .67306 Mtetra
.942 .939 .759 r
.57428 .67306 .57519 .67223 .57597 .67052 .57507 .67145 Mtetra
.953 .879 .724 r
.57507 .67145 .57597 .67052 .57673 .66825 .57584 .66932 Mtetra
.953 .84 .694 r
.57584 .66932 .57673 .66825 .57749 .6654 .5766 .66665 Mtetra
.954 .819 .671 r
.5766 .66665 .57749 .6654 .57824 .66198 .57735 .66346 Mtetra
.959 .81 .652 r
.57735 .66346 .57824 .66198 .57897 .65806 .57809 .65981 Mtetra
.969 .814 .635 r
.57809 .65981 .57897 .65806 .5797 .65379 .57882 .65584 Mtetra
.983 .831 .615 r
.57882 .65584 .5797 .65379 .58043 .64944 .57956 .6518 Mtetra
.995 .862 .579 r
.57956 .6518 .58043 .64944 .58116 .64535 .58029 .64799 Mtetra
.947 .876 .466 r
.58029 .64799 .58116 .64535 .5819 .64193 .58104 .6448 Mtetra
0 0 0 r
.58104 .6448 .5819 .64193 .58266 .63956 .58181 .64258 Mtetra
.181 0 .338 r
.58181 .64258 .58266 .63956 .58345 .6385 .5826 .64156 Mtetra
.474 .237 .473 r
.5826 .64156 .58345 .6385 .58427 .63883 .58342 .64181 Mtetra
.592 .349 .517 r
.58342 .64181 .58427 .63883 .58512 .64041 .58426 .64322 Mtetra
.648 .402 .533 r
.58426 .64322 .58512 .64041 .58598 .64294 .58512 .64549 Mtetra
.678 .429 .537 r
.58512 .64549 .58598 .64294 .58686 .64601 .58599 .64827 Mtetra
.694 .44 .535 r
.58599 .64827 .58686 .64601 .58774 .64924 .58687 .6512 Mtetra
.701 .441 .527 r
.58687 .6512 .58774 .64924 .58862 .6523 .58774 .65396 Mtetra
.7 .431 .513 r
.58774 .65396 .58862 .6523 .5895 .65496 .58861 .65636 Mtetra
.691 .409 .491 r
.58861 .65636 .5895 .65496 .59036 .65709 .58947 .65827 Mtetra
.668 .369 .456 r
.58947 .65827 .59036 .65709 .59122 .65864 .59032 .65965 Mtetra
.621 .295 .396 r
.59032 .65965 .59122 .65864 .59206 .65961 .59116 .66049 Mtetra
.517 .149 .282 r
.59116 .66049 .59206 .65961 .59289 .66002 .59199 .66083 Mtetra
.245 0 .021 r
.59199 .66083 .59289 .66002 .59371 .6599 .59281 .66066 Mtetra
0 0 0 r
.59281 .66066 .59371 .6599 .59452 .65924 .59362 .66002 Mtetra
.855 .996 .764 r
.59362 .66002 .59452 .65924 .59532 .65806 .59442 .65889 Mtetra
.943 .938 .759 r
.59442 .65889 .59532 .65806 .5961 .65633 .5952 .65725 Mtetra
.954 .879 .723 r
.5952 .65725 .5961 .65633 .59688 .65404 .59598 .6551 Mtetra
.955 .842 .692 r
.59598 .6551 .59688 .65404 .59763 .65115 .59674 .6524 Mtetra
.957 .821 .669 r
.59674 .6524 .59763 .65115 .59838 .6477 .5975 .64918 Mtetra
.962 .813 .649 r
.5975 .64918 .59838 .6477 .59911 .64375 .59824 .64551 Mtetra
.972 .817 .631 r
.59824 .64551 .59911 .64375 .59984 .63946 .59897 .64152 Mtetra
.986 .835 .61 r
.59897 .64152 .59984 .63946 .60056 .63511 .5997 .63747 Mtetra
.996 .866 .57 r
.5997 .63747 .60056 .63511 .60129 .63104 .60044 .63368 Mtetra
.93 .869 .442 r
.60044 .63368 .60129 .63104 .60203 .62766 .60119 .63053 Mtetra
0 0 0 r
.60119 .63053 .60203 .62766 .6028 .62535 .60196 .62837 Mtetra
.211 0 .352 r
.60196 .62837 .6028 .62535 .6036 .62437 .60276 .62742 Mtetra
.484 .245 .476 r
.60276 .62742 .6036 .62437 .60444 .62478 .6036 .62775 Mtetra
.596 .352 .517 r
.6036 .62775 .60444 .62478 .60531 .62644 .60446 .62923 Mtetra
.651 .403 .531 r
.60446 .62923 .60531 .62644 .6062 .62903 .60535 .63156 Mtetra
.68 .429 .535 r
.60535 .63156 .6062 .62903 .60711 .63215 .60625 .63439 Mtetra
.696 .44 .532 r
.60625 .63439 .60711 .63215 .60802 .63541 .60716 .63734 Mtetra
.703 .44 .524 r
.60716 .63734 .60802 .63541 .60894 .63848 .60806 .64011 Mtetra
.701 .43 .51 r
.60806 .64011 .60894 .63848 .60984 .64114 .60896 .64251 Mtetra
.691 .407 .487 r
.60896 .64251 .60984 .64114 .61073 .64327 .60984 .64442 Mtetra
.668 .365 .45 r
.60984 .64442 .61073 .64327 .6116 .64481 .61071 .6458 Mtetra
.62 .289 .388 r
.61071 .6458 .6116 .64481 .61247 .64578 .61157 .64664 Mtetra
.513 .139 .269 r
.61157 .64664 .61247 .64578 .61332 .64618 .61242 .64696 Mtetra
.231 0 0 r
.61242 .64696 .61332 .64618 .61415 .64604 .61325 .64679 Mtetra
0 0 0 r
.61325 .64679 .61415 .64604 .61497 .64537 .61407 .64613 Mtetra
.857 .996 .768 r
.61407 .64613 .61497 .64537 .61578 .64417 .61488 .64498 Mtetra
.943 .939 .758 r
.61488 .64498 .61578 .64417 .61657 .64243 .61568 .64333 Mtetra
.955 .88 .722 r
.61568 .64333 .61657 .64243 .61735 .6401 .61646 .64115 Mtetra
.956 .843 .691 r
.61646 .64115 .61735 .6401 .61811 .63719 .61723 .63844 Mtetra
.959 .823 .666 r
.61723 .63844 .61811 .63719 .61886 .63371 .61798 .63519 Mtetra
.965 .816 .646 r
.61798 .63519 .61886 .63371 .61959 .62974 .61872 .63149 Mtetra
.975 .82 .627 r
.61872 .63149 .61959 .62974 .62031 .62543 .61945 .6275 Mtetra
.988 .838 .604 r
.61945 .6275 .62031 .62543 .62103 .62108 .62018 .62345 Mtetra
.995 .869 .559 r
.62018 .62345 .62103 .62108 .62175 .61703 .62091 .61968 Mtetra
.909 .859 .415 r
.62091 .61968 .62175 .61703 .6225 .6137 .62167 .61657 Mtetra
0 0 .013 r
.62167 .61657 .6225 .6137 .62328 .61146 .62245 .61447 Mtetra
.239 .019 .365 r
.62245 .61447 .62328 .61146 .62409 .61056 .62327 .6136 Mtetra
.494 .254 .479 r
.62327 .6136 .62409 .61056 .62495 .61106 .62412 .61401 Mtetra
.601 .355 .516 r
.62412 .61401 .62495 .61106 .62584 .61279 .62501 .61556 Mtetra
.654 .404 .53 r
.62501 .61556 .62584 .61279 .62677 .61545 .62593 .61796 Mtetra
.682 .429 .533 r
.62593 .61796 .62677 .61545 .62771 .61862 .62686 .62083 Mtetra
.698 .439 .529 r
.62686 .62083 .62771 .61862 .62865 .62191 .62779 .62381 Mtetra
.704 .439 .521 r
.62779 .62381 .62865 .62191 .62959 .625 .62873 .62661 Mtetra
.703 .428 .506 r
.62873 .62661 .62959 .625 .63053 .62767 .62965 .62902 Mtetra
.692 .405 .482 r
.62965 .62902 .63053 .62767 .63144 .6298 .63056 .63093 Mtetra
.669 .362 .444 r
.63056 .63093 .63144 .6298 .63234 .63134 .63145 .6323 Mtetra
.62 .284 .38 r
.63145 .6323 .63234 .63134 .63322 .6323 .63233 .63314 Mtetra
.51 .131 .257 r
.63233 .63314 .63322 .6323 .63409 .6327 .6332 .63346 Mtetra
.221 0 0 r
.6332 .63346 .63409 .6327 .63494 .63255 .63404 .63328 Mtetra
0 0 0 r
.63404 .63328 .63494 .63255 .63578 .63187 .63488 .63262 Mtetra
.857 .996 .77 r
.63488 .63262 .63578 .63187 .63659 .63066 .6357 .63146 Mtetra
.943 .939 .758 r
.6357 .63146 .63659 .63066 .63739 .6289 .6365 .62979 Mtetra
.956 .882 .72 r
.6365 .62979 .63739 .6289 .63818 .62655 .63729 .6276 Mtetra
.958 .846 .689 r
.63729 .6276 .63818 .62655 .63894 .62362 .63806 .62486 Mtetra
.961 .826 .664 r
.63806 .62486 .63894 .62362 .63969 .62011 .63882 .62159 Mtetra
.967 .819 .643 r
.63882 .62159 .63969 .62011 .64041 .61611 .63955 .61787 Mtetra
.978 .824 .623 r
.63955 .61787 .64041 .61611 .64113 .6118 .64028 .61386 Mtetra
.991 .843 .598 r
.64028 .61386 .64113 .6118 .64185 .60744 .64101 .60982 Mtetra
.993 .871 .547 r
.64101 .60982 .64185 .60744 .64257 .60342 .64174 .60608 Mtetra
.883 .844 .384 r
.64174 .60608 .64257 .60342 .64332 .60014 .6425 .60302 Mtetra
0 0 .056 r
.6425 .60302 .64332 .60014 .64411 .59797 .64329 .60098 Mtetra
.266 .043 .378 r
.64329 .60098 .64411 .59797 .64494 .59716 .64413 .60019 Mtetra
.504 .262 .481 r
.64413 .60019 .64494 .59716 .64582 .59775 .645 .60069 Mtetra
.605 .358 .516 r
.645 .60069 .64582 .59775 .64674 .59957 .64592 .60233 Mtetra
.657 .405 .528 r
.64592 .60233 .64674 .59957 .64769 .6023 .64686 .60479 Mtetra
.684 .429 .53 r
.64686 .60479 .64769 .6023 .64867 .60553 .64783 .60772 Mtetra
.699 .439 .527 r
.64783 .60772 .64867 .60553 .64965 .60885 .64879 .61073 Mtetra
.705 .438 .517 r
.64879 .61073 .64965 .60885 .65062 .61197 .64976 .61355 Mtetra
.704 .427 .502 r
.64976 .61355 .65062 .61197 .65158 .61465 .65071 .61597 Mtetra
.694 .403 .478 r
.65071 .61597 .65158 .61465 .65252 .61678 .65164 .61789 Mtetra
.67 .359 .439 r
.65164 .61789 .65252 .61678 .65345 .61833 .65256 .61927 Mtetra
.62 .28 .373 r
.65256 .61927 .65345 .61833 .65435 .61929 .65346 .62011 Mtetra
.508 .123 .247 r
.65346 .62011 .65435 .61929 .65524 .61968 .65434 .62043 Mtetra
.216 0 0 r
.65434 .62043 .65524 .61968 .6561 .61953 .65521 .62025 Mtetra
0 0 0 r
.65521 .62025 .6561 .61953 .65695 .61885 .65606 .61958 Mtetra
.855 .996 .771 r
.65606 .61958 .65695 .61885 .65778 .61763 .65689 .61841 Mtetra
.943 .941 .758 r
.65689 .61841 .65778 .61763 .65859 .61584 .6577 .61673 Mtetra
.957 .885 .719 r
.6577 .61673 .65859 .61584 .65938 .61348 .6585 .61452 Mtetra
.96 .849 .687 r
.6585 .61452 .65938 .61348 .66014 .61052 .65927 .61176 Mtetra
.964 .829 .661 r
.65927 .61176 .66014 .61052 .66089 .607 .66003 .60848 Mtetra
.971 .822 .639 r
.66003 .60848 .66089 .607 .66161 .60298 .66076 .60475 Mtetra
.981 .828 .618 r
.66076 .60475 .66161 .60298 .66233 .59866 .66149 .60073 Mtetra
.993 .847 .591 r
.66149 .60073 .66233 .59866 .66304 .59431 .66221 .5967 Mtetra
.99 .873 .533 r
.66221 .5967 .66304 .59431 .66376 .59031 .66295 .59298 Mtetra
.85 .825 .348 r
.66295 .59298 .66376 .59031 .66452 .58709 .66371 .58997 Mtetra
0 0 .097 r
.66371 .58997 .66452 .58709 .66531 .585 .66451 .58801 Mtetra
.292 .066 .39 r
.66451 .58801 .66531 .585 .66616 .58428 .66536 .58731 Mtetra
.513 .27 .483 r
.66536 .58731 .66616 .58428 .66706 .58496 .66626 .5879 Mtetra
.61 .361 .515 r
.66626 .5879 .66706 .58496 .66802 .58688 .66721 .58962 Mtetra
.659 .406 .526 r
.66721 .58962 .66802 .58688 .669 .58968 .66819 .59216 Mtetra
.686 .429 .528 r
.66819 .59216 .669 .58968 .67001 .59297 .66918 .59514 Mtetra
.701 .439 .524 r
.66918 .59514 .67001 .59297 .67103 .59634 .67018 .59819 Mtetra
.707 .437 .514 r
.67018 .59819 .67103 .59634 .67203 .59948 .67118 .60104 Mtetra
.705 .425 .498 r
.67118 .60104 .67203 .59948 .67302 .60218 .67216 .60348 Mtetra
.695 .401 .473 r
.67216 .60348 .67302 .60218 .674 .60432 .67312 .60541 Mtetra
.671 .356 .433 r
.67312 .60541 .674 .60432 .67494 .60587 .67406 .60679 Mtetra
.62 .276 .366 r
.67406 .60679 .67494 .60587 .67587 .60684 .67498 .60764 Mtetra
.507 .118 .238 r
.67498 .60764 .67587 .60684 .67678 .60723 .67589 .60796 Mtetra
.214 0 0 r
.67589 .60796 .67678 .60723 .67766 .60708 .67677 .60779 Mtetra
0 0 0 r
.67677 .60779 .67766 .60708 .67852 .6064 .67763 .60712 Mtetra
.851 .997 .77 r
.67763 .60712 .67852 .6064 .67936 .60517 .67848 .60595 Mtetra
.942 .944 .757 r
.67848 .60595 .67936 .60517 .68018 .60338 .6793 .60426 Mtetra
.959 .888 .718 r
.6793 .60426 .68018 .60338 .68097 .601 .6801 .60204 Mtetra
.963 .852 .685 r
.6801 .60204 .68097 .601 .68174 .59802 .68088 .59926 Mtetra
.967 .833 .658 r
.68088 .59926 .68174 .59802 .68249 .59447 .68163 .59596 Mtetra
.974 .826 .635 r
.68163 .59596 .68249 .59447 .68321 .59044 .68237 .59222 Mtetra
.984 .832 .613 r
.68237 .59222 .68321 .59044 .68392 .58611 .6831 .5882 Mtetra
.995 .851 .582 r
.6831 .5882 .68392 .58611 .68463 .58177 .68382 .58417 Mtetra
.985 .874 .516 r
.68382 .58417 .68463 .58177 .68536 .57781 .68456 .58049 Mtetra
.81 .8 .307 r
.68456 .58049 .68536 .57781 .68611 .57464 .68532 .57754 Mtetra
0 0 .138 r
.68532 .57754 .68611 .57464 .68692 .57264 .68614 .57566 Mtetra
.316 .088 .401 r
.68614 .57566 .68692 .57264 .68779 .57201 .68701 .57504 Mtetra
.523 .278 .485 r
.68701 .57504 .68779 .57201 .68872 .5728 .68793 .57573 Mtetra
.615 .364 .514 r
.68793 .57573 .68872 .5728 .6897 .57481 .6889 .57754 Mtetra
.662 .408 .525 r
.6889 .57754 .6897 .57481 .69072 .5777 .68992 .58016 Mtetra
.689 .43 .526 r
.68992 .58016 .69072 .5777 .69177 .58104 .69095 .5832 Mtetra
.703 .438 .521 r
.69095 .5832 .69177 .58104 .69282 .58446 .69198 .5863 Mtetra
.709 .436 .511 r
.69198 .5863 .69282 .58446 .69386 .58763 .69301 .58917 Mtetra
.707 .424 .494 r
.69301 .58917 .69386 .58763 .69488 .59035 .69402 .59164 Mtetra
.696 .399 .469 r
.69402 .59164 .69488 .59035 .69588 .59251 .69501 .59358 Mtetra
.672 .354 .428 r
.69501 .59358 .69588 .59251 .69686 .59407 .69598 .59498 Mtetra
.621 .273 .359 r
.69598 .59498 .69686 .59407 .69781 .59505 .69693 .59584 Mtetra
.507 .114 .23 r
.69693 .59584 .69781 .59505 .69873 .59545 .69785 .59617 Mtetra
.217 0 0 r
.69785 .59617 .69873 .59545 .69964 .5953 .69875 .596 Mtetra
0 0 0 r
.69875 .596 .69964 .5953 .70051 .59461 .69963 .59533 Mtetra
.844 .997 .767 r
.69963 .59533 .70051 .59461 .70137 .59338 .70048 .59416 Mtetra
.942 .948 .755 r
.70048 .59416 .70137 .59338 .70219 .59158 .70132 .59247 Mtetra
.96 .893 .716 r
.70132 .59247 .70219 .59158 .70299 .58919 .70212 .59023 Mtetra
.966 .857 .682 r
.70212 .59023 .70299 .58919 .70377 .5862 .70291 .58744 Mtetra
.97 .837 .654 r
.70291 .58744 .70377 .5862 .70451 .58263 .70366 .58413 Mtetra
.978 .831 .631 r
.70366 .58413 .70451 .58263 .70523 .57858 .7044 .58037 Mtetra
.987 .837 .606 r
.7044 .58037 .70523 .57858 .70594 .57425 .70512 .57635 Mtetra
.996 .856 .572 r
.70512 .57635 .70594 .57425 .70665 .56992 .70585 .57234 Mtetra
.976 .873 .495 r
.70585 .57234 .70665 .56992 .70737 .566 .70659 .5687 Mtetra
.761 .767 .261 r
.70659 .5687 .70737 .566 .70814 .56289 .70736 .56581 Mtetra
0 0 .176 r
.70736 .56581 .70814 .56289 .70896 .56097 .70819 .564 Mtetra
.34 .109 .411 r
.70819 .564 .70896 .56097 .70984 .56045 .70908 .56349 Mtetra
.532 .285 .487 r
.70908 .56349 .70984 .56045 .7108 .56134 .71003 .56427 Mtetra
.619 .367 .514 r
.71003 .56427 .7108 .56134 .71182 .56345 .71103 .56617 Mtetra
.665 .409 .523 r
.71103 .56617 .71182 .56345 .71288 .56642 .71208 .56887 Mtetra
.691 .43 .523 r
.71208 .56887 .71288 .56642 .71396 .56983 .71315 .57197 Mtetra
.704 .438 .518 r
.71315 .57197 .71396 .56983 .71505 .5733 .71422 .57513 Mtetra
.71 .436 .508 r
.71422 .57513 .71505 .5733 .71613 .57651 .71529 .57804 Mtetra
.708 .423 .491 r
.71529 .57804 .71613 .57651 .71718 .57925 .71633 .58053 Mtetra
.697 .397 .464 r
.71633 .58053 .71718 .57925 .71822 .58143 .71735 .58249 Mtetra
.672 .352 .423 r
.71735 .58249 .71822 .58143 .71922 .58301 .71835 .58391 Mtetra
.621 .27 .354 r
.71835 .58391 .71922 .58301 .72019 .58399 .71931 .58477 Mtetra
.508 .112 .225 r
.71931 .58477 .72019 .58399 .72114 .5844 .72026 .58512 Mtetra
.223 0 0 r
.72026 .58512 .72114 .5844 .72206 .58426 .72118 .58495 Mtetra
0 0 0 r
.72118 .58495 .72206 .58426 .72295 .58358 .72207 .58429 Mtetra
.834 .996 .761 r
.72207 .58429 .72295 .58358 .72382 .58234 .72294 .58312 Mtetra
.941 .953 .753 r
.72294 .58312 .72382 .58234 .72466 .58053 .72378 .58142 Mtetra
.963 .898 .713 r
.72378 .58142 .72466 .58053 .72546 .57813 .7246 .57918 Mtetra
.969 .862 .678 r
.7246 .57918 .72546 .57813 .72624 .57512 .72539 .57638 Mtetra
.974 .842 .65 r
.72539 .57638 .72624 .57512 .72698 .57153 .72615 .57305 Mtetra
.981 .836 .625 r
.72615 .57305 .72698 .57153 .7277 .56747 .72688 .56929 Mtetra
.991 .842 .598 r
.72688 .56929 .7277 .56747 .72841 .56314 .72761 .56527 Mtetra
.997 .86 .56 r
.72761 .56527 .72841 .56314 .72911 .55883 .72833 .56127 Mtetra
.964 .87 .471 r
.72833 .56127 .72911 .55883 .72984 .55494 .72907 .55766 Mtetra
.703 .727 .209 r
.72907 .55766 .72984 .55494 .73061 .5519 .72985 .55483 Mtetra
0 0 .212 r
.72985 .55483 .73061 .5519 .73145 .55006 .73069 .55311 Mtetra
.362 .129 .42 r
.73069 .55311 .73145 .55006 .73236 .54964 .7316 .55269 Mtetra
.54 .292 .489 r
.7316 .55269 .73236 .54964 .73334 .55064 .73258 .55358 Mtetra
.624 .37 .513 r
.73258 .55358 .73334 .55064 .73439 .55286 .73363 .55558 Mtetra
.668 .41 .521 r
.73363 .55558 .73439 .55286 .73549 .55591 .73471 .55836 Mtetra
.693 .43 .521 r
.73471 .55836 .73549 .55591 .73662 .5594 .73582 .56153 Mtetra
.706 .437 .515 r
.73582 .56153 .73662 .5594 .73775 .56292 .73693 .56474 Mtetra
.711 .435 .504 r
.73693 .56474 .73775 .56292 .73886 .56617 .73803 .56769 Mtetra
.709 .422 .487 r
.73803 .56769 .73886 .56617 .73996 .56894 .73911 .5702 Mtetra
.698 .395 .46 r
.73911 .5702 .73996 .56894 .74102 .57114 .74016 .57219 Mtetra
.673 .35 .418 r
.74016 .57219 .74102 .57114 .74205 .57273 .74118 .57362 Mtetra
.622 .268 .349 r
.74118 .57362 .74205 .57273 .74305 .57373 .74218 .5745 Mtetra
.51 .112 .222 r
.74218 .5745 .74305 .57373 .74402 .57415 .74314 .57486 Mtetra
.231 0 0 r
.74314 .57486 .74402 .57415 .74496 .57401 .74408 .5747 Mtetra
0 0 0 r
.74408 .5747 .74496 .57401 .74587 .57333 .74499 .57405 Mtetra
.821 .994 .751 r
.74499 .57405 .74587 .57333 .74675 .57209 .74588 .57288 Mtetra
.939 .958 .749 r
.74588 .57288 .74675 .57209 .7476 .57028 .74673 .57118 Mtetra
.965 .904 .71 r
.74673 .57118 .7476 .57028 .74841 .56786 .74755 .56893 Mtetra
.972 .868 .674 r
.74755 .56893 .74841 .56786 .74919 .56483 .74835 .56611 Mtetra
.978 .848 .645 r
.74835 .56611 .74919 .56483 .74994 .56123 .74911 .56277 Mtetra
.985 .841 .618 r
.74911 .56277 .74994 .56123 .75066 .55716 .74984 .559 Mtetra
.993 .848 .589 r
.74984 .559 .75066 .55716 .75136 .55282 .75057 .55497 Mtetra
.996 .863 .545 r
.75057 .55497 .75136 .55282 .75206 .54852 .75129 .551 Mtetra
.947 .863 .442 r
.75129 .551 .75206 .54852 .75279 .54467 .75204 .54743 Mtetra
0 0 0 r
.75204 .54743 .75279 .54467 .75357 .5417 .75283 .54466 Mtetra
0 0 .245 r
.75283 .54466 .75357 .5417 .75442 .53995 .75369 .54302 Mtetra
.382 .147 .429 r
.75369 .54302 .75442 .53995 .75535 .53964 .75462 .5427 Mtetra
.548 .299 .49 r
.75462 .5427 .75535 .53964 .75637 .54075 .75563 .5437 Mtetra
.627 .372 .512 r
.75563 .5437 .75637 .54075 .75746 .54306 .75671 .54579 Mtetra
.67 .41 .519 r
.75671 .54579 .75746 .54306 .7586 .54621 .75783 .54866 Mtetra
.694 .43 .519 r
.75783 .54866 .7586 .54621 .75977 .54977 .75898 .5519 Mtetra
.707 .437 .513 r
.75898 .5519 .75977 .54977 .76094 .55334 .76013 .55516 Mtetra
.712 .433 .501 r
.76013 .55516 .76094 .55334 .7621 .55663 .76127 .55815 Mtetra
.71 .42 .483 r
.76127 .55815 .7621 .55663 .76323 .55943 .76239 .56069 Mtetra
.699 .393 .456 r
.76239 .56069 .76323 .55943 .76432 .56165 .76347 .5627 Mtetra
.673 .347 .414 r
.76347 .5627 .76432 .56165 .76539 .56326 .76452 .56415 Mtetra
.622 .266 .345 r
.76452 .56415 .76539 .56326 .76641 .56427 .76554 .56505 Mtetra
.511 .111 .219 r
.76554 .56505 .76641 .56427 .76741 .5647 .76653 .56542 Mtetra
.241 0 0 r
.76653 .56542 .76741 .5647 .76837 .56457 .76749 .56527 Mtetra
0 0 0 r
.76749 .56527 .76837 .56457 .76929 .56389 .76842 .56462 Mtetra
.805 .99 .737 r
.76842 .56462 .76929 .56389 .77019 .56265 .76932 .56345 Mtetra
.937 .964 .742 r
.76932 .56345 .77019 .56265 .77105 .56083 .77019 .56174 Mtetra
.967 .911 .705 r
.77019 .56174 .77105 .56083 .77187 .5584 .77102 .55948 Mtetra
.976 .874 .669 r
.77102 .55948 .77187 .5584 .77265 .55535 .77181 .55665 Mtetra
.982 .854 .638 r
.77181 .55665 .77265 .55535 .7734 .55173 .77258 .5533 Mtetra
.989 .847 .61 r
.77258 .5533 .7734 .55173 .77411 .54764 .77332 .54951 Mtetra
.996 .853 .578 r
.77332 .54951 .77411 .54764 .77481 .54329 .77404 .54548 Mtetra
.993 .866 .528 r
.77404 .54548 .77481 .54329 .77552 .53901 .77476 .54152 Mtetra
.924 .851 .408 r
.77476 .54152 .77552 .53901 .77625 .5352 .77551 .53799 Mtetra
0 0 0 r
.77551 .53799 .77625 .5352 .77704 .53229 .77631 .53528 Mtetra
.048 0 .274 r
.77631 .53528 .77704 .53229 .7779 .53063 .77719 .53373 Mtetra
.4 .164 .436 r
.77719 .53373 .7779 .53063 .77886 .53042 .77815 .53351 Mtetra
.555 .305 .491 r
.77815 .53351 .77886 .53042 .77992 .53164 .77919 .53461 Mtetra
.631 .375 .512 r
.77919 .53461 .77992 .53164 .78105 .53406 .78031 .5368 Mtetra
.672 .411 .518 r
.78031 .5368 .78105 .53406 .78223 .5373 .78148 .53976 Mtetra
.696 .429 .516 r
.78148 .53976 .78223 .5373 .78344 .54093 .78267 .54307 Mtetra
.708 .436 .51 r
.78267 .54307 .78344 .54093 .78466 .54456 .78386 .54637 Mtetra
.713 .432 .498 r
.78386 .54637 .78466 .54456 .78586 .54788 .78504 .5494 Mtetra
.71 .418 .48 r
.78504 .5494 .78586 .54788 .78703 .55072 .78619 .55198 Mtetra
.699 .391 .452 r
.78619 .55198 .78703 .55072 .78816 .55296 .78731 .55401 Mtetra
.673 .345 .41 r
.78731 .55401 .78816 .55296 .78925 .55458 .78839 .55548 Mtetra
.622 .263 .341 r
.78839 .55548 .78925 .55458 .79031 .55561 .78944 .55639 Mtetra
.511 .111 .218 r
.78944 .55639 .79031 .55561 .79132 .55605 .79045 .55677 Mtetra
.25 0 0 r
.79045 .55677 .79132 .55605 .79231 .55592 .79144 .55663 Mtetra
0 0 0 r
.79144 .55663 .79231 .55592 .79325 .55524 .79238 .55598 Mtetra
.786 .983 .719 r
.79238 .55598 .79325 .55524 .79416 .554 .7933 .55481 Mtetra
.934 .969 .734 r
.7933 .55481 .79416 .554 .79503 .55216 .79418 .5531 Mtetra
.969 .917 .698 r
.79418 .5531 .79503 .55216 .79586 .54971 .79502 .55082 Mtetra
.979 .881 .662 r
.79502 .55082 .79586 .54971 .79665 .54664 .79582 .54798 Mtetra
.985 .86 .63 r
.79582 .54798 .79665 .54664 .79739 .54299 .79659 .5446 Mtetra
.992 .853 .6 r
.79659 .5446 .79739 .54299 .79811 .53888 .79732 .54079 Mtetra
.997 .857 .565 r
.79732 .54079 .79811 .53888 .79881 .53453 .79804 .53676 Mtetra
.987 .866 .507 r
.79804 .53676 .79881 .53453 .79951 .53026 .79877 .53281 Mtetra
.894 .834 .369 r
.79877 .53281 .79951 .53026 .80024 .52648 .79953 .52932 Mtetra
0 0 0 r
.79953 .52932 .80024 .52648 .80104 .52363 .80034 .52667 Mtetra
.094 0 .3 r
.80034 .52667 .80104 .52363 .80193 .52207 .80123 .5252 Mtetra
.417 .178 .443 r
.80123 .5252 .80193 .52207 .80292 .52196 .80222 .52508 Mtetra
.562 .31 .492 r
.80222 .52508 .80292 .52196 .80401 .52329 .8033 .52628 Mtetra
.634 .376 .511 r
.8033 .52628 .80401 .52329 .80518 .52581 .80446 .52858 Mtetra
.674 .411 .516 r
.80446 .52858 .80518 .52581 .80641 .52914 .80567 .53161 Mtetra
.697 .429 .514 r
.80567 .53161 .80641 .52914 .80767 .53284 .80691 .53499 Mtetra
.709 .434 .507 r
.80691 .53499 .80767 .53284 .80893 .53653 .80814 .53835 Mtetra
.714 .43 .495 r
.80814 .53835 .80893 .53653 .81017 .53989 .80936 .54142 Mtetra
.71 .416 .476 r
.80936 .54142 .81017 .53989 .81138 .54275 .81055 .54403 Mtetra
.698 .389 .448 r
.81055 .54403 .81138 .54275 .81255 .54502 .81171 .54608 Mtetra
.672 .342 .406 r
.81171 .54608 .81255 .54502 .81367 .54666 .81282 .54756 Mtetra
.62 .26 .338 r
.81282 .54756 .81367 .54666 .81476 .54769 .8139 .54849 Mtetra
.511 .11 .217 r
.8139 .54849 .81476 .54769 .8158 .54814 .81494 .54887 Mtetra
.258 0 0 r
.81494 .54887 .8158 .54814 .81681 .54802 .81594 .54874 Mtetra
0 0 0 r
.81594 .54874 .81681 .54802 .81777 .54733 .81691 .54809 Mtetra
.765 .973 .697 r
.81691 .54809 .81777 .54733 .8187 .54608 .81784 .54691 Mtetra
.929 .972 .723 r
.81784 .54691 .8187 .54608 .81958 .54423 .81873 .54519 Mtetra
.97 .924 .69 r
.81873 .54519 .81958 .54423 .82041 .54175 .81958 .54289 Mtetra
.982 .887 .654 r
.81958 .54289 .82041 .54175 .8212 .53866 .82039 .54002 Mtetra
.989 .865 .621 r
.82039 .54002 .8212 .53866 .82195 .53498 .82116 .53662 Mtetra
.994 .858 .589 r
.82116 .53662 .82195 .53498 .82266 .53084 .82189 .5328 Mtetra
.997 .861 .55 r
.82189 .5328 .82266 .53084 .82336 .52648 .82262 .52876 Mtetra
.978 .864 .483 r
.82262 .52876 .82336 .52648 .82406 .52221 .82334 .52482 Mtetra
.856 .811 .326 r
.82334 .52482 .82406 .52221 .8248 .51847 .8241 .52135 Mtetra
0 0 .013 r
.8241 .52135 .8248 .51847 .82561 .51568 .82493 .51877 Mtetra
.136 0 .322 r
.82493 .51877 .82561 .51568 .82652 .5142 .82585 .51738 Mtetra
.431 .192 .448 r
.82585 .51738 .82652 .5142 .82754 .5142 .82686 .51736 Mtetra
.567 .315 .493 r
.82686 .51736 .82754 .5142 .82867 .51564 .82798 .51866 Mtetra
.637 .378 .51 r
.82798 .51866 .82867 .51564 .82988 .51826 .82918 .52105 Mtetra
.676 .411 .514 r
.82918 .52105 .82988 .51826 .83116 .52168 .83044 .52417 Mtetra
.698 .428 .511 r
.83044 .52417 .83116 .52168 .83247 .52545 .83172 .52761 Mtetra
.71 .433 .504 r
.83172 .52761 .83247 .52545 .83378 .52919 .83301 .53103 Mtetra
.714 .428 .491 r
.83301 .53103 .83378 .52919 .83507 .53259 .83427 .53413 Mtetra
.71 .414 .472 r
.83427 .53413 .83507 .53259 .83632 .53547 .8355 .53676 Mtetra
.698 .386 .444 r
.8355 .53676 .83632 .53547 .83752 .53776 .83669 .53883 Mtetra
.671 .338 .402 r
.83669 .53883 .83752 .53776 .83868 .53941 .83784 .54033 Mtetra
.619 .257 .334 r
.83784 .54033 .83868 .53941 .8398 .54045 .83894 .54126 Mtetra
.51 .109 .217 r
.83894 .54126 .8398 .54045 .84087 .5409 .84001 .54166 Mtetra
.264 0 0 r
.84001 .54166 .84087 .5409 .84189 .54078 .84104 .54152 Mtetra
0 0 0 r
.84104 .54152 .84189 .54078 .84288 .54009 .84202 .54087 Mtetra
.742 .961 .671 r
.84202 .54087 .84288 .54009 .84382 .53882 .84297 .53968 Mtetra
.922 .975 .709 r
.84297 .53968 .84382 .53882 .84471 .53695 .84387 .53794 Mtetra
.97 .929 .679 r
.84387 .53794 .84471 .53695 .84555 .53445 .84473 .53562 Mtetra
.984 .893 .644 r
.84473 .53562 .84555 .53445 .84635 .53132 .84554 .53273 Mtetra
.991 .871 .61 r
.84554 .53273 .84635 .53132 .8471 .52761 .84632 .52929 Mtetra
.996 .862 .576 r
.84632 .52929 .8471 .52761 .84781 .52344 .84705 .52544 Mtetra
.995 .863 .532 r
.84705 .52544 .84781 .52344 .8485 .51906 .84777 .52139 Mtetra
.966 .86 .456 r
.84777 .52139 .8485 .51906 .8492 .5148 .8485 .51745 Mtetra
.813 .782 .279 r
.8485 .51745 .8492 .5148 .84995 .51108 .84927 .51402 Mtetra
0 0 .063 r
.84927 .51402 .84995 .51108 .85077 .50836 .85011 .51149 Mtetra
.172 0 .341 r
.85011 .51149 .85077 .50836 .8517 .50696 .85105 .51018 Mtetra
.444 .203 .453 r
.85105 .51018 .8517 .50696 .85275 .50706 .8521 .51025 Mtetra
.572 .319 .494 r
.8521 .51025 .85275 .50706 .85392 .5086 .85326 .51166 Mtetra
.639 .379 .508 r
.85326 .51166 .85392 .5086 .85519 .51133 .8545 .51414 Mtetra
.677 .411 .512 r
.8545 .51414 .85519 .51133 .85652 .51483 .85581 .51734 Mtetra
.699 .427 .509 r
.85581 .51734 .85652 .51483 .85788 .51867 .85714 .52085 Mtetra
.71 .431 .501 r
.85714 .52085 .85788 .51867 .85924 .52245 .85847 .52431 Mtetra
.714 .426 .488 r
.85847 .52431 .85924 .52245 .86057 .52589 .85978 .52745 Mtetra
.71 .411 .469 r
.85978 .52745 .86057 .52589 .86186 .5288 .86105 .5301 Mtetra
.697 .382 .44 r
.86105 .5301 .86186 .5288 .86311 .5311 .86228 .53219 Mtetra
.669 .334 .397 r
.86228 .53219 .86311 .5311 .8643 .53276 .86346 .5337 Mtetra
.616 .253 .33 r
.86346 .5337 .8643 .53276 .86545 .5338 .8646 .53464 Mtetra
.507 .107 .215 r
.8646 .53464 .86545 .5338 .86654 .53425 .86569 .53503 Mtetra
.267 0 .001 r
.86569 .53503 .86654 .53425 .86759 .53412 .86674 .53489 Mtetra
0 0 0 r
.86674 .53489 .86759 .53412 .8686 .53342 .86775 .53423 Mtetra
.718 .946 .643 r
.86775 .53423 .8686 .53342 .86955 .53214 .86871 .53303 Mtetra
.914 .975 .693 r
.86871 .53303 .86955 .53214 .87046 .53024 .86963 .53126 Mtetra
.969 .934 .667 r
.86963 .53126 .87046 .53024 .87131 .52771 .8705 .52892 Mtetra
.986 .897 .632 r
.8705 .52892 .87131 .52771 .87211 .52454 .87132 .52599 Mtetra
.993 .875 .597 r
.87132 .52599 .87211 .52454 .87286 .52079 .87209 .52252 Mtetra
.996 .865 .561 r
.87209 .52252 .87286 .52079 .87357 .51659 .87283 .51864 Mtetra
.991 .863 .512 r
.87283 .51864 .87357 .51659 .87426 .51218 .87355 .51457 Mtetra
.949 .851 .425 r
.87355 .51457 .87426 .51218 .87496 .50792 .87428 .51063 Mtetra
.763 .747 .229 r
.87428 .51063 .87496 .50792 .87571 .50424 .87505 .50723 Mtetra
0 0 .109 r
.87505 .50723 .87571 .50424 .87655 .50156 .87591 .50475 Mtetra
.204 0 .358 r
.87591 .50475 .87655 .50156 .8775 .50025 .87687 .50352 Mtetra
.455 .213 .457 r
.87687 .50352 .8775 .50025 .87858 .50045 .87795 .50368 Mtetra
.577 .322 .494 r
.87795 .50368 .87858 .50045 .87979 .5021 .87915 .50518 Mtetra
.641 .38 .507 r
.87915 .50518 .87979 .5021 .88111 .50492 .88044 .50776 Mtetra
.678 .41 .51 r
.88044 .50776 .88111 .50492 .88249 .5085 .8818 .51104 Mtetra
.699 .425 .506 r
.8818 .51104 .88249 .5085 .88391 .51241 .88319 .51461 Mtetra
.71 .429 .498 r
.88319 .51461 .88391 .51241 .88532 .51624 .88457 .51811 Mtetra
.713 .424 .485 r
.88457 .51811 .88532 .51624 .8867 .51971 .88592 .52128 Mtetra
.709 .408 .465 r
.88592 .52128 .8867 .51971 .88804 .52264 .88724 .52396 Mtetra
.695 .378 .436 r
.88724 .52396 .88804 .52264 .88932 .52495 .8885 .52606 Mtetra
.667 .33 .393 r
.8885 .52606 .88932 .52495 .89055 .52661 .88972 .52757 Mtetra
.613 .248 .326 r
.88972 .52757 .89055 .52661 .89173 .52766 .89089 .52851 Mtetra
.504 .103 .214 r
.89089 .52851 .89173 .52766 .89285 .5281 .89201 .5289 Mtetra
.268 0 .008 r
.89201 .5289 .89285 .5281 .89393 .52797 .89308 .52876 Mtetra
0 0 0 r
.89308 .52876 .89393 .52797 .89495 .52725 .89411 .52808 Mtetra
.694 .929 .614 r
.89411 .52808 .89495 .52725 .89593 .52594 .89509 .52686 Mtetra
.905 .973 .674 r
.89509 .52686 .89593 .52594 .89684 .52402 .89602 .52507 Mtetra
.967 .937 .653 r
.89602 .52507 .89684 .52402 .8977 .52145 .8969 .52269 Mtetra
.986 .901 .618 r
.8969 .52269 .8977 .52145 .8985 .51824 .89772 .51973 Mtetra
.993 .878 .583 r
.89772 .51973 .8985 .51824 .89925 .51444 .8985 .51622 Mtetra
.995 .867 .544 r
.8985 .51622 .89925 .51444 .89996 .5102 .89924 .51231 Mtetra
.984 .862 .49 r
.89924 .51231 .89996 .5102 .90064 .50577 .89996 .50821 Mtetra
.927 .839 .391 r
.89996 .50821 .90064 .50577 .90135 .5015 .90069 .50427 Mtetra
.708 .708 .178 r
.90069 .50427 .90135 .5015 .9021 .49784 .90147 .50088 Mtetra
0 0 .15 r
.90147 .50088 .9021 .49784 .90296 .49522 .90234 .49846 Mtetra
.232 .02 .372 r
.90234 .49846 .90296 .49522 .90393 .49398 .90333 .4973 Mtetra
.465 .222 .461 r
.90333 .4973 .90393 .49398 .90505 .49428 .90445 .49756 Mtetra
.581 .325 .494 r
.90445 .49756 .90505 .49428 .90631 .49603 .90569 .49915 Mtetra
.643 .38 .505 r
.90569 .49915 .90631 .49603 .90768 .49895 .90703 .50182 Mtetra
.679 .409 .507 r
.90703 .50182 .90768 .49895 .90912 .50261 .90844 .50517 Mtetra
.699 .424 .503 r
.90844 .50517 .90912 .50261 .91059 .50658 .90988 .5088 Mtetra
.71 .427 .495 r
.90988 .5088 .91059 .50658 .91205 .51046 .91132 .51235 Mtetra
.713 .421 .481 r
.91132 .51235 .91205 .51046 .91348 .51395 .91272 .51555 Mtetra
.708 .404 .461 r
.91272 .51555 .91348 .51395 .91487 .5169 .91408 .51824 Mtetra
.693 .374 .431 r
.91408 .51824 .91487 .5169 .91619 .51922 .91538 .52035 Mtetra
.664 .325 .388 r
.91538 .52035 .91619 .51922 .91746 .52089 .91664 .52187 Mtetra
.609 .242 .322 r
.91664 .52187 .91746 .52089 .91867 .52193 .91784 .52281 Mtetra
.499 .098 .212 r
.91784 .52281 .91867 .52193 .91982 .52237 .91899 .52319 Mtetra
.267 0 .014 r
.91899 .52319 .91982 .52237 .92092 .52222 .92009 .52304 Mtetra
0 0 0 r
.92009 .52304 .92092 .52222 .92197 .52148 .92114 .52234 Mtetra
.67 .911 .583 r
.92114 .52234 .92197 .52148 .92296 .52015 .92213 .5211 Mtetra
.894 .969 .653 r
.92213 .5211 .92296 .52015 .92389 .51818 .92308 .51928 Mtetra
.963 .938 .636 r
.92308 .51928 .92389 .51818 .92475 .51557 .92396 .51686 Mtetra
.985 .904 .603 r
.92396 .51686 .92475 .51557 .92556 .51231 .92479 .51385 Mtetra
.992 .88 .567 r
.92479 .51385 .92556 .51231 .9263 .50847 .92557 .5103 Mtetra
.991 .868 .525 r
.92557 .5103 .9263 .50847 .92701 .50418 .9263 .50634 Mtetra
.974 .858 .464 r
.9263 .50634 .92701 .50418 .92769 .49972 .92702 .50222 Mtetra
.901 .823 .354 r
.92702 .50222 .92769 .49972 .92839 .49544 .92776 .49827 Mtetra
0 0 0 r
.92776 .49827 .92839 .49544 .92916 .4918 .92855 .4949 Mtetra
0 0 .186 r
.92855 .4949 .92916 .4918 .93002 .48923 .92944 .49253 Mtetra
.256 .042 .384 r
.92944 .49253 .93002 .48923 .93103 .48807 .93045 .49144 Mtetra
.474 .23 .464 r
.93045 .49144 .93103 .48807 .93219 .48846 .93161 .49179 Mtetra
.584 .328 .494 r
.93161 .49179 .93219 .48846 .93349 .49032 .9329 .49348 Mtetra
.645 .38 .504 r
.9329 .49348 .93349 .49032 .93491 .49333 .93429 .49623 Mtetra
.679 .408 .505 r
.93429 .49623 .93491 .49333 .93641 .49707 .93576 .49966 Mtetra
.699 .422 .5 r
.93576 .49966 .93641 .49707 .93794 .5011 .93725 .50334 Mtetra
.71 .425 .491 r
.93725 .50334 .93794 .5011 .93946 .50502 .93874 .50693 Mtetra
.712 .418 .477 r
.93874 .50693 .93946 .50502 .94094 .50854 .94019 .51015 Mtetra
.707 .401 .456 r
.94019 .51015 .94094 .50854 .94237 .5115 .9416 .51286 Mtetra
.691 .37 .427 r
.9416 .51286 .94237 .5115 .94374 .51383 .94295 .51498 Mtetra
.661 .32 .384 r
.94295 .51498 .94374 .51383 .94505 .5155 .94424 .5165 Mtetra
.604 .236 .317 r
.94424 .5165 .94505 .5155 .94629 .51653 .94547 .51743 Mtetra
.494 .093 .209 r
.94547 .51743 .94629 .51653 .94748 .51696 .94665 .51781 Mtetra
.265 0 .019 r
.94665 .51781 .94748 .51696 .9486 .51679 .94777 .51764 Mtetra
0 0 0 r
.94777 .51764 .9486 .51679 .94967 .51603 .94885 .51692 Mtetra
.648 .892 .553 r
.94885 .51692 .94967 .51603 .95067 .51467 .94986 .51565 Mtetra
.882 .962 .63 r
.94986 .51565 .95067 .51467 .95161 .51266 .95082 .51379 Mtetra
.958 .937 .618 r
.95082 .51379 .95161 .51266 .95249 .51 .95171 .51133 Mtetra
.982 .905 .586 r
.95171 .51133 .95249 .51 .95329 .50669 .95254 .50827 Mtetra
.989 .881 .549 r
.95254 .50827 .95329 .50669 .95404 .50279 .95332 .50467 Mtetra
.986 .866 .504 r
.95332 .50467 .95404 .50279 .95474 .49846 .95406 .50067 Mtetra
.962 .851 .437 r
.95406 .50067 .95474 .49846 .95542 .49396 .95477 .49652 Mtetra
.871 .802 .314 r
.95477 .49652 .95542 .49396 .95612 .48967 .95551 .49256 Mtetra
0 0 0 r
.95551 .49256 .95612 .48967 .95689 .48604 .95631 .48921 Mtetra
0 0 .218 r
.95631 .48921 .95689 .48604 .95778 .48352 .95722 .48688 Mtetra
.278 .062 .395 r
.95722 .48688 .95778 .48352 .95881 .48244 .95826 .48587 Mtetra
.482 .237 .466 r
.95826 .48587 .95881 .48244 .96001 .48293 .95946 .4863 Mtetra
.587 .329 .493 r
.95946 .4863 .96001 .48293 .96137 .48488 .96079 .48808 Mtetra
.646 .38 .502 r
.96079 .48808 .96137 .48488 .96284 .48798 .96224 .49092 Mtetra
.68 .407 .502 r
.96224 .49092 .96284 .48798 .9644 .4918 .96377 .49441 Mtetra
.699 .42 .497 r
.96377 .49441 .9644 .4918 .96599 .49589 .96532 .49815 Mtetra
.709 .422 .488 r
.96532 .49815 .96599 .49589 .96757 .49985 .96686 .50178 Mtetra
.711 .415 .473 r
.96686 .50178 .96757 .49985 .96911 .5034 .96837 .50502 Mtetra
.705 .397 .452 r
.96837 .50502 .96911 .5034 .97058 .50637 .96982 .50774 Mtetra
.689 .365 .422 r
.96982 .50774 .97058 .50637 .972 .5087 .97121 .50987 Mtetra
.658 .314 .378 r
.97121 .50987 .972 .5087 .97334 .51036 .97254 .51138 Mtetra
.599 .23 .312 r
.97254 .51138 .97334 .51036 .97462 .51139 .97381 .51231 Mtetra
.487 .086 .206 r
.97381 .51231 .97462 .51139 .97584 .5118 .97502 .51267 Mtetra
.261 0 .022 r
.97502 .51267 .97584 .5118 .97699 .51162 .97617 .51248 Mtetra
0 0 0 r
.97617 .51248 .97699 .51162 .97807 .51083 .97726 .51175 Mtetra
.626 .873 .523 r
.97726 .51175 .97807 .51083 .9791 .50942 .97829 .51044 Mtetra
.868 .954 .606 r
.97829 .51044 .9791 .50942 .98005 .50738 .97926 .50854 Mtetra
.951 .935 .598 r
.97926 .50854 .98005 .50738 .98093 .50466 .98017 .50604 Mtetra
.978 .904 .567 r
.98017 .50604 .98093 .50466 .98173 .50129 .981 .50292 Mtetra
.985 .88 .529 r
.981 .50292 .98173 .50129 .98248 .49734 .98178 .49927 Mtetra
.978 .863 .48 r
.98178 .49927 .98248 .49734 .98317 .49295 .98251 .49522 Mtetra
.946 .841 .407 r
.98251 .49522 .98317 .49295 .98385 .48841 .98323 .49103 Mtetra
.835 .777 .272 r
.98323 .49103 .98385 .48841 .98455 .48411 .98397 .48706 Mtetra
0 0 0 r
.98397 .48706 .98455 .48411 .98533 .4805 .98478 .48373 Mtetra
0 0 .246 r
.98478 .48373 .98533 .4805 .98623 .47803 .98571 .48144 Mtetra
.297 .079 .404 r
.98571 .48144 .98623 .47803 .9873 .47702 .98678 .4805 Mtetra
.425 .142 .378 r
.52309 .68686 .52399 .68503 .52476 .68507 .52386 .68687 Mtetra
.613 .341 .481 r
.52386 .68687 .52476 .68507 .52554 .68628 .52463 .68797 Mtetra
.68 .414 .512 r
.52463 .68797 .52554 .68628 .52632 .6884 .52542 .68993 Mtetra
.711 .446 .522 r
.52542 .68993 .52632 .6884 .52711 .69107 .52621 .69242 Mtetra
.727 .459 .522 r
.52621 .69242 .52711 .69107 .52791 .69393 .527 .69508 Mtetra
.734 .46 .514 r
.527 .69508 .52791 .69393 .5287 .69667 .52779 .69763 Mtetra
.734 .45 .498 r
.52779 .69763 .5287 .69667 .5295 .69907 .52859 .69986 Mtetra
.726 .426 .471 r
.52859 .69986 .5295 .69907 .53029 .70101 .52938 .70165 Mtetra
.705 .38 .424 r
.52938 .70165 .53029 .70101 .53108 .70243 .53016 .70295 Mtetra
.657 .29 .337 r
.53016 .70295 .53108 .70243 .53186 .70331 .53095 .70375 Mtetra
.525 .084 .143 r
.53095 .70375 .53186 .70331 .53264 .70369 .53173 .70408 Mtetra
.063 0 0 r
.53173 .70408 .53264 .70369 .53342 .70358 .53251 .70393 Mtetra
.684 .977 .893 r
.53251 .70393 .53342 .70358 .5342 .70299 .53328 .70334 Mtetra
.865 .926 .865 r
.53328 .70334 .5342 .70299 .53496 .70192 .53405 .7023 Mtetra
.891 .851 .797 r
.53405 .7023 .53496 .70192 .53573 .70036 .53481 .7008 Mtetra
.895 .804 .751 r
.53481 .7008 .53573 .70036 .53649 .69828 .53558 .69881 Mtetra
.897 .776 .72 r
.53558 .69881 .53649 .69828 .53724 .69568 .53633 .69632 Mtetra
.9 .76 .697 r
.53633 .69632 .53724 .69568 .53799 .69255 .53708 .69334 Mtetra
.905 .753 .682 r
.53708 .69334 .53799 .69255 .53874 .68896 .53783 .68992 Mtetra
.913 .754 .671 r
.53783 .68992 .53874 .68896 .53948 .68503 .53857 .68618 Mtetra
.925 .765 .665 r
.53857 .68618 .53948 .68503 .54022 .681 .53931 .68235 Mtetra
.944 .792 .662 r
.53931 .68235 .54022 .681 .54096 .67717 .54006 .67871 Mtetra
.972 .845 .659 r
.54006 .67871 .54096 .67717 .5417 .67392 .54081 .6756 Mtetra
.963 .93 .606 r
.54081 .6756 .5417 .67392 .54246 .67159 .54156 .67337 Mtetra
0 0 0 r
.54156 .67337 .54246 .67159 .54323 .67044 .54233 .67225 Mtetra
.441 .157 .385 r
.54233 .67225 .54323 .67044 .54401 .67055 .54312 .67233 Mtetra
.618 .345 .481 r
.54312 .67233 .54401 .67055 .54481 .67182 .54391 .67349 Mtetra
.683 .415 .51 r
.54391 .67349 .54481 .67182 .54562 .67399 .54472 .6755 Mtetra
.713 .446 .519 r
.54472 .6755 .54562 .67399 .54643 .67669 .54553 .67802 Mtetra
.729 .458 .518 r
.54553 .67802 .54643 .67669 .54726 .67957 .54635 .6807 Mtetra
.735 .459 .51 r
.54635 .6807 .54726 .67957 .54808 .68232 .54717 .68325 Mtetra
.735 .448 .493 r
.54717 .68325 .54808 .68232 .5489 .68472 .54799 .68548 Mtetra
.727 .423 .464 r
.54799 .68548 .5489 .68472 .54971 .68664 .5488 .68726 Mtetra
.705 .375 .415 r
.5488 .68726 .54971 .68664 .55052 .68804 .5496 .68854 Mtetra
.655 .28 .323 r
.5496 .68854 .55052 .68804 .55132 .68891 .55041 .68933 Mtetra
.513 .061 .115 r
.55041 .68933 .55132 .68891 .55212 .68927 .5512 .68963 Mtetra
.021 0 0 r
.5512 .68963 .55212 .68927 .55291 .68914 .55199 .68948 Mtetra
.699 .979 .903 r
.55199 .68948 .55291 .68914 .55369 .68853 .55278 .68886 Mtetra
.865 .921 .864 r
.55278 .68886 .55369 .68853 .55447 .68743 .55356 .6878 Mtetra
.89 .849 .796 r
.55356 .6878 .55447 .68743 .55524 .68585 .55433 .68627 Mtetra
.896 .804 .75 r
.55433 .68627 .55524 .68585 .55601 .68374 .5551 .68425 Mtetra
.898 .777 .719 r
.5551 .68425 .55601 .68374 .55677 .6811 .55586 .68173 Mtetra
.902 .761 .696 r
.55586 .68173 .55677 .6811 .55752 .67794 .55661 .67872 Mtetra
.907 .754 .681 r
.55661 .67872 .55752 .67794 .55826 .67432 .55736 .67527 Mtetra
.915 .756 .67 r
.55736 .67527 .55826 .67432 .559 .67037 .5581 .67152 Mtetra
.928 .768 .664 r
.5581 .67152 .559 .67037 .55973 .66633 .55884 .66767 Mtetra
.947 .796 .661 r
.55884 .66767 .55973 .66633 .56047 .66251 .55958 .66404 Mtetra
.975 .851 .656 r
.55958 .66404 .56047 .66251 .56122 .65929 .56033 .66097 Mtetra
.953 .932 .592 r
.56033 .66097 .56122 .65929 .56198 .65701 .56109 .65879 Mtetra
0 0 0 r
.56109 .65879 .56198 .65701 .56276 .65592 .56187 .65773 Mtetra
.457 .172 .391 r
.56187 .65773 .56276 .65592 .56356 .65611 .56267 .65787 Mtetra
.624 .349 .48 r
.56267 .65787 .56356 .65611 .56438 .65744 .56349 .65909 Mtetra
.686 .416 .508 r
.56349 .65909 .56438 .65744 .56521 .65966 .56432 .66115 Mtetra
.716 .446 .516 r
.56432 .66115 .56521 .65966 .56606 .6624 .56516 .6637 Mtetra
.731 .458 .515 r
.56516 .6637 .56606 .6624 .5669 .6653 .56601 .6664 Mtetra
.737 .457 .506 r
.56601 .6664 .5669 .6653 .56775 .66806 .56685 .66896 Mtetra
.737 .446 .488 r
.56685 .66896 .56775 .66806 .56859 .67045 .56769 .67119 Mtetra
.728 .42 .458 r
.56769 .67119 .56859 .67045 .56943 .67237 .56852 .67296 Mtetra
.706 .37 .406 r
.56852 .67296 .56943 .67237 .57026 .67376 .56935 .67423 Mtetra
.653 .27 .308 r
.56935 .67423 .57026 .67376 .57108 .67461 .57017 .67501 Mtetra
.502 .039 .086 r
.57017 .67501 .57108 .67461 .57189 .67496 .57098 .6753 Mtetra
0 0 0 r
.57098 .6753 .57189 .67496 .5727 .67481 .57178 .67512 Mtetra
.71 .979 .911 r
.57178 .67512 .5727 .67481 .5735 .67418 .57258 .6745 Mtetra
.865 .917 .863 r
.57258 .6745 .5735 .67418 .57428 .67306 .57337 .67341 Mtetra
.89 .847 .796 r
.57337 .67341 .57428 .67306 .57507 .67145 .57415 .67186 Mtetra
.896 .803 .749 r
.57415 .67186 .57507 .67145 .57584 .66932 .57493 .66982 Mtetra
.899 .777 .718 r
.57493 .66982 .57584 .66932 .5766 .66665 .57569 .66727 Mtetra
.903 .762 .695 r
.57569 .66727 .5766 .66665 .57735 .66346 .57644 .66423 Mtetra
.909 .756 .679 r
.57644 .66423 .57735 .66346 .57809 .65981 .57719 .66076 Mtetra
.917 .758 .669 r
.57719 .66076 .57809 .65981 .57882 .65584 .57793 .65698 Mtetra
.93 .771 .662 r
.57793 .65698 .57882 .65584 .57956 .6518 .57867 .65313 Mtetra
.95 .8 .659 r
.57867 .65313 .57956 .6518 .58029 .64799 .57941 .64951 Mtetra
.978 .858 .653 r
.57941 .64951 .58029 .64799 .58104 .6448 .58016 .64647 Mtetra
.939 .931 .575 r
.58016 .64647 .58104 .6448 .58181 .64258 .58093 .64434 Mtetra
0 0 .035 r
.58093 .64434 .58181 .64258 .5826 .64156 .58172 .64335 Mtetra
.473 .187 .397 r
.58172 .64335 .5826 .64156 .58342 .64181 .58254 .64355 Mtetra
.629 .353 .48 r
.58254 .64355 .58342 .64181 .58426 .64322 .58338 .64485 Mtetra
.689 .417 .506 r
.58338 .64485 .58426 .64322 .58512 .64549 .58423 .64696 Mtetra
.718 .446 .513 r
.58423 .64696 .58512 .64549 .58599 .64827 .5851 .64955 Mtetra
.733 .457 .511 r
.5851 .64955 .58599 .64827 .58687 .6512 .58597 .65227 Mtetra
.739 .456 .501 r
.58597 .65227 .58687 .6512 .58774 .65396 .58684 .65484 Mtetra
.738 .444 .483 r
.58684 .65484 .58774 .65396 .58861 .65636 .58771 .65707 Mtetra
.729 .417 .451 r
.58771 .65707 .58861 .65636 .58947 .65827 .58856 .65883 Mtetra
.706 .365 .397 r
.58856 .65883 .58947 .65827 .59032 .65965 .58941 .6601 Mtetra
.651 .261 .293 r
.58941 .6601 .59032 .65965 .59116 .66049 .59025 .66086 Mtetra
.491 .017 .057 r
.59025 .66086 .59116 .66049 .59199 .66083 .59108 .66114 Mtetra
0 0 0 r
.59108 .66114 .59199 .66083 .59281 .66066 .59189 .66096 Mtetra
.718 .977 .918 r
.59189 .66096 .59281 .66066 .59362 .66002 .5927 .66032 Mtetra
.864 .914 .863 r
.5927 .66032 .59362 .66002 .59442 .65889 .5935 .65922 Mtetra
.889 .846 .795 r
.5935 .65922 .59442 .65889 .5952 .65725 .59429 .65764 Mtetra
.896 .803 .749 r
.59429 .65764 .5952 .65725 .59598 .6551 .59507 .65558 Mtetra
.9 .778 .717 r
.59507 .65558 .59598 .6551 .59674 .6524 .59584 .65301 Mtetra
.905 .763 .694 r
.59584 .65301 .59674 .6524 .5975 .64918 .5966 .64994 Mtetra
.911 .757 .678 r
.5966 .64994 .5975 .64918 .59824 .64551 .59734 .64644 Mtetra
.92 .76 .667 r
.59734 .64644 .59824 .64551 .59897 .64152 .59808 .64265 Mtetra
.933 .774 .661 r
.59808 .64265 .59897 .64152 .5997 .63747 .59882 .6388 Mtetra
.954 .804 .657 r
.59882 .6388 .5997 .63747 .60044 .63368 .59956 .6352 Mtetra
.98 .865 .65 r
.59956 .6352 .60044 .63368 .60119 .63053 .60031 .63219 Mtetra
.919 .928 .554 r
.60031 .63219 .60119 .63053 .60196 .62837 .60109 .63012 Mtetra
0 0 .075 r
.60109 .63012 .60196 .62837 .60276 .62742 .60189 .62919 Mtetra
.488 .2 .402 r
.60189 .62919 .60276 .62742 .6036 .62775 .60273 .62947 Mtetra
.635 .357 .479 r
.60273 .62947 .6036 .62775 .60446 .62923 .60359 .63084 Mtetra
.692 .418 .504 r
.60359 .63084 .60446 .62923 .60535 .63156 .60447 .633 Mtetra
.72 .446 .51 r
.60447 .633 .60535 .63156 .60625 .63439 .60537 .63563 Mtetra
.735 .457 .507 r
.60537 .63563 .60625 .63439 .60716 .63734 .60627 .63838 Mtetra
.741 .455 .497 r
.60627 .63838 .60716 .63734 .60806 .64011 .60716 .64097 Mtetra
.74 .442 .477 r
.60716 .64097 .60806 .64011 .60896 .64251 .60805 .6432 Mtetra
.731 .414 .444 r
.60805 .6432 .60896 .64251 .60984 .64442 .60893 .64496 Mtetra
.707 .36 .387 r
.60893 .64496 .60984 .64442 .61071 .6458 .6098 .64623 Mtetra
.649 .252 .278 r
.6098 .64623 .61071 .6458 .61157 .64664 .61066 .64698 Mtetra
.481 0 .029 r
.61066 .64698 .61157 .64664 .61242 .64696 .6115 .64726 Mtetra
0 0 0 r
.6115 .64726 .61242 .64696 .61325 .64679 .61234 .64706 Mtetra
.723 .975 .924 r
.61234 .64706 .61325 .64679 .61407 .64613 .61316 .64641 Mtetra
.862 .911 .863 r
.61316 .64641 .61407 .64613 .61488 .64498 .61397 .6453 Mtetra
.889 .845 .795 r
.61397 .6453 .61488 .64498 .61568 .64333 .61477 .64371 Mtetra
.897 .804 .749 r
.61477 .64371 .61568 .64333 .61646 .64115 .61555 .64162 Mtetra
.901 .779 .716 r
.61555 .64162 .61646 .64115 .61723 .63844 .61632 .63903 Mtetra
.906 .765 .693 r
.61632 .63903 .61723 .63844 .61798 .63519 .61708 .63594 Mtetra
.913 .759 .677 r
.61708 .63594 .61798 .63519 .61872 .63149 .61783 .63242 Mtetra
.922 .763 .666 r
.61783 .63242 .61872 .63149 .61945 .6275 .61856 .62862 Mtetra
.936 .777 .659 r
.61856 .62862 .61945 .6275 .62018 .62345 .6193 .62477 Mtetra
.957 .809 .655 r
.6193 .62477 .62018 .62345 .62091 .61968 .62004 .62119 Mtetra
.983 .872 .646 r
.62004 .62119 .62091 .61968 .62167 .61657 .6208 .61823 Mtetra
.894 .921 .529 r
.6208 .61823 .62167 .61657 .62245 .61447 .62158 .61621 Mtetra
.011 0 .113 r
.62158 .61621 .62245 .61447 .62327 .6136 .6224 .61536 Mtetra
.503 .214 .408 r
.6224 .61536 .62327 .6136 .62412 .61401 .62326 .61572 Mtetra
.641 .361 .479 r
.62326 .61572 .62412 .61401 .62501 .61556 .62414 .61715 Mtetra
.696 .42 .501 r
.62414 .61715 .62501 .61556 .62593 .61796 .62505 .61938 Mtetra
.723 .446 .507 r
.62505 .61938 .62593 .61796 .62686 .62083 .62598 .62206 Mtetra
.737 .456 .504 r
.62598 .62206 .62686 .62083 .62779 .62381 .62691 .62483 Mtetra
.743 .454 .492 r
.62691 .62483 .62779 .62381 .62873 .62661 .62783 .62744 Mtetra
.742 .44 .472 r
.62783 .62744 .62873 .62661 .62965 .62902 .62875 .62968 Mtetra
.732 .411 .437 r
.62875 .62968 .62965 .62902 .63056 .63093 .62965 .63145 Mtetra
.708 .356 .378 r
.62965 .63145 .63056 .63093 .63145 .6323 .63054 .63271 Mtetra
.648 .244 .264 r
.63054 .63271 .63145 .6323 .63233 .63314 .63142 .63347 Mtetra
.473 0 .004 r
.63142 .63347 .63233 .63314 .6332 .63346 .63228 .63374 Mtetra
0 0 0 r
.63228 .63374 .6332 .63346 .63404 .63328 .63313 .63354 Mtetra
.724 .973 .928 r
.63313 .63354 .63404 .63328 .63488 .63262 .63397 .63288 Mtetra
.861 .909 .864 r
.63397 .63288 .63488 .63262 .6357 .63146 .63479 .63176 Mtetra
.888 .845 .796 r
.63479 .63176 .6357 .63146 .6365 .62979 .6356 .63015 Mtetra
.897 .805 .749 r
.6356 .63015 .6365 .62979 .63729 .6276 .63639 .62805 Mtetra
.903 .78 .716 r
.63639 .62805 .63729 .6276 .63806 .62486 .63716 .62544 Mtetra
.908 .766 .693 r
.63716 .62544 .63806 .62486 .63882 .62159 .63792 .62233 Mtetra
.915 .762 .676 r
.63792 .62233 .63882 .62159 .63955 .61787 .63867 .6188 Mtetra
.925 .766 .665 r
.63867 .6188 .63955 .61787 .64028 .61386 .6394 .61499 Mtetra
.94 .781 .658 r
.6394 .61499 .64028 .61386 .64101 .60982 .64014 .61114 Mtetra
.961 .815 .654 r
.64014 .61114 .64101 .60982 .64174 .60608 .64088 .60758 Mtetra
.985 .88 .642 r
.64088 .60758 .64174 .60608 .6425 .60302 .64164 .60467 Mtetra
.859 .907 .498 r
.64164 .60467 .6425 .60302 .64329 .60098 .64244 .60272 Mtetra
.072 0 .15 r
.64244 .60272 .64329 .60098 .64413 .60019 .64327 .60194 Mtetra
.518 .227 .412 r
.64327 .60194 .64413 .60019 .645 .60069 .64414 .60238 Mtetra
.646 .365 .478 r
.64414 .60238 .645 .60069 .64592 .60233 .64506 .60389 Mtetra
.699 .421 .499 r
.64506 .60389 .64592 .60233 .64686 .60479 .646 .60619 Mtetra
.726 .446 .504 r
.646 .60619 .64686 .60479 .64783 .60772 .64695 .60891 Mtetra
.739 .456 .5 r
.64695 .60891 .64783 .60772 .64879 .61073 .64791 .61173 Mtetra
.745 .453 .488 r
.64791 .61173 .64879 .61073 .64976 .61355 .64887 .61435 Mtetra
.744 .439 .466 r
.64887 .61435 .64976 .61355 .65071 .61597 .64981 .61661 Mtetra
.734 .409 .43 r
.64981 .61661 .65071 .61597 .65164 .61789 .65074 .61838 Mtetra
.709 .352 .368 r
.65074 .61838 .65164 .61789 .65256 .61927 .65166 .61965 Mtetra
.648 .237 .25 r
.65166 .61965 .65256 .61927 .65346 .62011 .65255 .62041 Mtetra
.467 0 0 r
.65255 .62041 .65346 .62011 .65434 .62043 .65343 .62068 Mtetra
0 0 0 r
.65343 .62068 .65434 .62043 .65521 .62025 .6543 .62048 Mtetra
.722 .97 .932 r
.6543 .62048 .65521 .62025 .65606 .61958 .65515 .61982 Mtetra
.859 .909 .866 r
.65515 .61982 .65606 .61958 .65689 .61841 .65598 .61869 Mtetra
.888 .846 .797 r
.65598 .61869 .65689 .61841 .6577 .61673 .6568 .61708 Mtetra
.898 .806 .749 r
.6568 .61708 .6577 .61673 .6585 .61452 .6576 .61497 Mtetra
.904 .782 .716 r
.6576 .61497 .6585 .61452 .65927 .61176 .65837 .61234 Mtetra
.91 .769 .692 r
.65837 .61234 .65927 .61176 .66003 .60848 .65914 .60921 Mtetra
.918 .764 .675 r
.65914 .60921 .66003 .60848 .66076 .60475 .65988 .60567 Mtetra
.928 .769 .663 r
.65988 .60567 .66076 .60475 .66149 .60073 .66061 .60185 Mtetra
.943 .785 .656 r
.66061 .60185 .66149 .60073 .66221 .5967 .66135 .59802 Mtetra
.965 .821 .651 r
.66135 .59802 .66221 .5967 .66295 .59298 .66209 .59449 Mtetra
.986 .888 .636 r
.66209 .59449 .66295 .59298 .66371 .58997 .66286 .59162 Mtetra
.815 .886 .46 r
.66286 .59162 .66371 .58997 .66451 .58801 .66367 .58974 Mtetra
.129 0 .183 r
.66367 .58974 .66451 .58801 .66536 .58731 .66452 .58905 Mtetra
.532 .24 .417 r
.66452 .58905 .66536 .58731 .66626 .5879 .66541 .58958 Mtetra
.652 .369 .477 r
.66541 .58958 .66626 .5879 .66721 .58962 .66635 .59117 Mtetra
.703 .422 .497 r
.66635 .59117 .66721 .58962 .66819 .59216 .66732 .59353 Mtetra
.728 .447 .501 r
.66732 .59353 .66819 .59216 .66918 .59514 .66831 .59631 Mtetra
.741 .455 .496 r
.66831 .59631 .66918 .59514 .67018 .59819 .6693 .59917 Mtetra
.747 .452 .483 r
.6693 .59917 .67018 .59819 .67118 .60104 .67029 .60182 Mtetra
.746 .437 .461 r
.67029 .60182 .67118 .60104 .67216 .60348 .67126 .60409 Mtetra
.736 .406 .424 r
.67126 .60409 .67216 .60348 .67312 .60541 .67222 .60588 Mtetra
.711 .348 .36 r
.67222 .60588 .67312 .60541 .67406 .60679 .67316 .60716 Mtetra
.648 .231 .238 r
.67316 .60716 .67406 .60679 .67498 .60764 .67408 .60793 Mtetra
.464 0 0 r
.67408 .60793 .67498 .60764 .67589 .60796 .67498 .6082 Mtetra
0 0 0 r
.67498 .6082 .67589 .60796 .67677 .60779 .67586 .60801 Mtetra
.716 .968 .935 r
.67586 .60801 .67677 .60779 .67763 .60712 .67672 .60735 Mtetra
.857 .91 .868 r
.67672 .60735 .67763 .60712 .67848 .60595 .67757 .60622 Mtetra
.888 .848 .798 r
.67757 .60622 .67848 .60595 .6793 .60426 .67839 .6046 Mtetra
.9 .809 .749 r
.67839 .6046 .6793 .60426 .6801 .60204 .6792 .60247 Mtetra
.906 .785 .715 r
.6792 .60247 .6801 .60204 .68088 .59926 .67998 .59983 Mtetra
.913 .772 .691 r
.67998 .59983 .68088 .59926 .68163 .59596 .68075 .59669 Mtetra
.921 .767 .674 r
.68075 .59669 .68163 .59596 .68237 .59222 .68149 .59314 Mtetra
.932 .773 .662 r
.68149 .59314 .68237 .59222 .6831 .5882 .68223 .58932 Mtetra
.947 .79 .654 r
.68223 .58932 .6831 .5882 .68382 .58417 .68296 .5855 Mtetra
.969 .828 .649 r
.68296 .5855 .68382 .58417 .68456 .58049 .6837 .582 Mtetra
.986 .896 .629 r
.6837 .582 .68456 .58049 .68532 .57754 .68448 .57919 Mtetra
.757 .854 .413 r
.68448 .57919 .68532 .57754 .68614 .57566 .6853 .57738 Mtetra
.183 0 .215 r
.6853 .57738 .68614 .57566 .68701 .57504 .68617 .57678 Mtetra
.545 .252 .421 r
.68617 .57678 .68701 .57504 .68793 .57573 .68709 .5774 Mtetra
.658 .373 .476 r
.68709 .5774 .68793 .57573 .6889 .57754 .68806 .57908 Mtetra
.706 .424 .494 r
.68806 .57908 .6889 .57754 .68992 .58016 .68906 .58152 Mtetra
.731 .447 .498 r
.68906 .58152 .68992 .58016 .69095 .5832 .69008 .58436 Mtetra
.744 .455 .492 r
.69008 .58436 .69095 .5832 .69198 .5863 .69111 .58725 Mtetra
.749 .451 .479 r
.69111 .58725 .69198 .5863 .69301 .58917 .69213 .58994 Mtetra
.748 .436 .456 r
.69213 .58994 .69301 .58917 .69402 .59164 .69313 .59223 Mtetra
.738 .404 .417 r
.69313 .59223 .69402 .59164 .69501 .59358 .69412 .59404 Mtetra
.712 .345 .351 r
.69412 .59404 .69501 .59358 .69598 .59498 .69508 .59533 Mtetra
.649 .226 .227 r
.69508 .59533 .69598 .59498 .69693 .59584 .69602 .59611 Mtetra
.463 0 0 r
.69602 .59611 .69693 .59584 .69785 .59617 .69694 .59639 Mtetra
0 0 0 r
.69694 .59639 .69785 .59617 .69875 .596 .69784 .5962 Mtetra
.708 .966 .937 r
.69784 .5962 .69875 .596 .69963 .59533 .69872 .59555 Mtetra
.855 .913 .871 r
.69872 .59555 .69963 .59533 .70048 .59416 .69958 .59442 Mtetra
.889 .852 .8 r
.69958 .59442 .70048 .59416 .70132 .59247 .70041 .5928 Mtetra
.901 .812 .75 r
.70041 .5928 .70132 .59247 .70212 .59023 .70123 .59066 Mtetra
.909 .788 .715 r
.70123 .59066 .70212 .59023 .70291 .58744 .70202 .58801 Mtetra
.916 .775 .69 r
.70202 .58801 .70291 .58744 .70366 .58413 .70278 .58486 Mtetra
.924 .771 .673 r
.70278 .58486 .70366 .58413 .7044 .58037 .70353 .5813 Mtetra
.936 .777 .66 r
.70353 .5813 .7044 .58037 .70512 .57635 .70426 .57748 Mtetra
.951 .796 .652 r
.70426 .57748 .70512 .57635 .70585 .57234 .70499 .57367 Mtetra
.973 .835 .645 r
.70499 .57367 .70585 .57234 .70659 .5687 .70574 .57021 Mtetra
.985 .905 .619 r
.70574 .57021 .70659 .5687 .70736 .56581 .70653 .56746 Mtetra
.684 .809 .356 r
.70653 .56746 .70736 .56581 .70819 .564 .70736 .56573 Mtetra
.233 0 .243 r
.70736 .56573 .70819 .564 .70908 .56349 .70825 .56522 Mtetra
.558 .264 .425 r
.70825 .56522 .70908 .56349 .71003 .56427 .70919 .56593 Mtetra
.663 .376 .476 r
.70919 .56593 .71003 .56427 .71103 .56617 .71019 .5677 Mtetra
.709 .425 .492 r
.71019 .5677 .71103 .56617 .71208 .56887 .71123 .57022 Mtetra
.733 .447 .495 r
.71123 .57022 .71208 .56887 .71315 .57197 .71229 .57312 Mtetra
.746 .454 .489 r
.71229 .57312 .71315 .57197 .71422 .57513 .71335 .57607 Mtetra
.751 .45 .474 r
.71335 .57607 .71422 .57513 .71529 .57804 .71441 .57879 Mtetra
.749 .434 .45 r
.71441 .57879 .71529 .57804 .71633 .58053 .71544 .58111 Mtetra
.739 .402 .411 r
.71544 .58111 .71633 .58053 .71735 .58249 .71645 .58293 Mtetra
.713 .342 .344 r
.71645 .58293 .71735 .58249 .71835 .58391 .71744 .58424 Mtetra
.649 .222 .218 r
.71744 .58424 .71835 .58391 .71931 .58477 .71841 .58503 Mtetra
.464 0 0 r
.71841 .58503 .71931 .58477 .72026 .58512 .71935 .58533 Mtetra
0 0 0 r
.71935 .58533 .72026 .58512 .72118 .58495 .72027 .58515 Mtetra
.697 .965 .938 r
.72027 .58515 .72118 .58495 .72207 .58429 .72116 .5845 Mtetra
.853 .917 .875 r
.72116 .5845 .72207 .58429 .72294 .58312 .72204 .58337 Mtetra
.89 .856 .802 r
.72204 .58337 .72294 .58312 .72378 .58142 .72288 .58175 Mtetra
.904 .817 .751 r
.72288 .58175 .72378 .58142 .7246 .57918 .7237 .57961 Mtetra
.912 .792 .715 r
.7237 .57961 .7246 .57918 .72539 .57638 .7245 .57695 Mtetra
.92 .779 .69 r
.7245 .57695 .72539 .57638 .72615 .57305 .72527 .57379 Mtetra
.928 .776 .671 r
.72527 .57379 .72615 .57305 .72688 .56929 .72601 .57022 Mtetra
.94 .782 .658 r
.72601 .57022 .72688 .56929 .72761 .56527 .72675 .5664 Mtetra
.956 .802 .65 r
.72675 .5664 .72761 .56527 .72833 .56127 .72748 .56261 Mtetra
.978 .844 .641 r
.72748 .56261 .72833 .56127 .72907 .55766 .72824 .55919 Mtetra
.98 .912 .606 r
.72824 .55919 .72907 .55766 .72985 .55483 .72903 .5565 Mtetra
0 0 0 r
.72903 .5565 .72985 .55483 .73069 .55311 .72987 .55485 Mtetra
.278 0 .269 r
.72987 .55485 .73069 .55311 .7316 .55269 .73078 .55443 Mtetra
.569 .275 .429 r
.73078 .55443 .7316 .55269 .73258 .55358 .73176 .55525 Mtetra
.668 .38 .475 r
.73176 .55525 .73258 .55358 .73363 .55558 .73279 .55711 Mtetra
.712 .426 .49 r
.73279 .55711 .73363 .55558 .73471 .55836 .73387 .55971 Mtetra
.735 .447 .492 r
.73387 .55971 .73471 .55836 .73582 .56153 .73496 .56267 Mtetra
.748 .454 .485 r
.73496 .56267 .73582 .56153 .73693 .56474 .73606 .56567 Mtetra
.753 .449 .47 r
.73606 .56567 .73693 .56474 .73803 .56769 .73715 .56843 Mtetra
.751 .433 .445 r
.73715 .56843 .73803 .56769 .73911 .5702 .73822 .57077 Mtetra
.74 .4 .405 r
.73822 .57077 .73911 .5702 .74016 .57219 .73927 .57263 Mtetra
.714 .339 .337 r
.73927 .57263 .74016 .57219 .74118 .57362 .74028 .57395 Mtetra
.65 .219 .211 r
.74028 .57395 .74118 .57362 .74218 .5745 .74127 .57476 Mtetra
.467 0 0 r
.74127 .57476 .74218 .5745 .74314 .57486 .74224 .57507 Mtetra
0 0 0 r
.74224 .57507 .74314 .57486 .74408 .5747 .74317 .5749 Mtetra
.684 .964 .937 r
.74317 .5749 .74408 .5747 .74499 .57405 .74409 .57426 Mtetra
.851 .923 .878 r
.74409 .57426 .74499 .57405 .74588 .57288 .74497 .57314 Mtetra
.892 .863 .804 r
.74497 .57314 .74588 .57288 .74673 .57118 .74583 .57151 Mtetra
.907 .822 .752 r
.74583 .57151 .74673 .57118 .74755 .56893 .74666 .56937 Mtetra
.916 .798 .715 r
.74666 .56937 .74755 .56893 .74835 .56611 .74746 .56669 Mtetra
.924 .784 .688 r
.74746 .56669 .74835 .56611 .74911 .56277 .74823 .56352 Mtetra
.933 .781 .669 r
.74823 .56352 .74911 .56277 .74984 .559 .74898 .55994 Mtetra
.945 .788 .656 r
.74898 .55994 .74984 .559 .75057 .55497 .74972 .55613 Mtetra
.961 .809 .646 r
.74972 .55613 .75057 .55497 .75129 .551 .75045 .55236 Mtetra
.982 .853 .636 r
.75045 .55236 .75129 .551 .75204 .54743 .75121 .54897 Mtetra
.972 .917 .588 r
.75121 .54897 .75204 .54743 .75283 .54466 .75201 .54634 Mtetra
0 0 0 r
.75201 .54634 .75283 .54466 .75369 .54302 .75287 .54477 Mtetra
.318 .02 .292 r
.75287 .54477 .75369 .54302 .75462 .5427 .75381 .54445 Mtetra
.58 .285 .433 r
.75381 .54445 .75462 .5427 .75563 .5437 .75481 .54537 Mtetra
.672 .383 .474 r
.75481 .54537 .75563 .5437 .75671 .54579 .75588 .54732 Mtetra
.715 .427 .488 r
.75588 .54732 .75671 .54579 .75783 .54866 .757 .55 Mtetra
.737 .447 .489 r
.757 .55 .75783 .54866 .75898 .5519 .75813 .55304 Mtetra
.749 .453 .481 r
.75813 .55304 .75898 .5519 .76013 .55516 .75927 .55608 Mtetra
.754 .448 .466 r
.75927 .55608 .76013 .55516 .76127 .55815 .7604 .55888 Mtetra
.752 .431 .44 r
.7604 .55888 .76127 .55815 .76239 .56069 .7615 .56126 Mtetra
.741 .397 .399 r
.7615 .56126 .76239 .56069 .76347 .5627 .76258 .56313 Mtetra
.714 .336 .331 r
.76258 .56313 .76347 .5627 .76452 .56415 .76362 .56448 Mtetra
.65 .216 .204 r
.76362 .56448 .76452 .56415 .76554 .56505 .76464 .5653 Mtetra
.469 0 0 r
.76464 .5653 .76554 .56505 .76653 .56542 .76563 .56563 Mtetra
0 0 0 r
.76563 .56563 .76653 .56542 .76749 .56527 .76658 .56547 Mtetra
.669 .963 .933 r
.76658 .56547 .76749 .56527 .76842 .56462 .76752 .56484 Mtetra
.85 .93 .881 r
.76752 .56484 .76842 .56462 .76932 .56345 .76842 .56371 Mtetra
.895 .87 .806 r
.76842 .56371 .76932 .56345 .77019 .56174 .76929 .56209 Mtetra
.911 .829 .752 r
.76929 .56209 .77019 .56174 .77102 .55948 .77013 .55993 Mtetra
.92 .804 .714 r
.77013 .55993 .77102 .55948 .77181 .55665 .77093 .55725 Mtetra
.928 .79 .687 r
.77093 .55725 .77181 .55665 .77258 .5533 .77171 .55406 Mtetra
.938 .787 .667 r
.77171 .55406 .77258 .5533 .77332 .54951 .77246 .55047 Mtetra
.95 .794 .653 r
.77246 .55047 .77332 .54951 .77404 .54548 .7732 .54666 Mtetra
.967 .817 .642 r
.7732 .54666 .77404 .54548 .77476 .54152 .77393 .5429 Mtetra
.986 .862 .629 r
.77393 .5429 .77476 .54152 .77551 .53799 .7747 .53955 Mtetra
.957 .919 .565 r
.7747 .53955 .77551 .53799 .77631 .53528 .77551 .53698 Mtetra
0 0 0 r
.77551 .53698 .77631 .53528 .77719 .53373 .77639 .5355 Mtetra
.352 .054 .312 r
.77639 .5355 .77719 .53373 .77815 .53351 .77735 .53528 Mtetra
.589 .294 .436 r
.77735 .53528 .77815 .53351 .77919 .53461 .77839 .53629 Mtetra
.676 .386 .473 r
.77839 .53629 .77919 .53461 .78031 .5368 .77949 .53834 Mtetra
.717 .427 .485 r
.77949 .53834 .78031 .5368 .78148 .53976 .78065 .5411 Mtetra
.739 .446 .485 r
.78065 .5411 .78148 .53976 .78267 .54307 .78183 .54421 Mtetra
.751 .452 .477 r
.78183 .54421 .78267 .54307 .78386 .54637 .78301 .54731 Mtetra
.755 .446 .462 r
.78301 .54731 .78386 .54637 .78504 .5494 .78417 .55014 Mtetra
.752 .428 .436 r
.78417 .55014 .78504 .5494 .78619 .55198 .78531 .55255 Mtetra
.741 .394 .394 r
.78531 .55255 .78619 .55198 .78731 .55401 .78642 .55445 Mtetra
.714 .332 .325 r
.78642 .55445 .78731 .55401 .78839 .55548 .7875 .55581 Mtetra
.649 .213 .199 r
.7875 .55581 .78839 .55548 .78944 .55639 .78854 .55665 Mtetra
.472 0 0 r
.78854 .55665 .78944 .55639 .79045 .55677 .78955 .55699 Mtetra
0 0 0 r
.78955 .55699 .79045 .55677 .79144 .55663 .79053 .55684 Mtetra
.652 .962 .926 r
.79053 .55684 .79144 .55663 .79238 .55598 .79148 .55621 Mtetra
.848 .939 .883 r
.79148 .55621 .79238 .55598 .7933 .55481 .7924 .55509 Mtetra
.898 .879 .808 r
.7924 .55509 .7933 .55481 .79418 .5531 .79328 .55345 Mtetra
.915 .836 .753 r
.79328 .55345 .79418 .5531 .79502 .55082 .79413 .55129 Mtetra
.925 .81 .713 r
.79413 .55129 .79502 .55082 .79582 .54798 .79494 .54859 Mtetra
.934 .796 .685 r
.79494 .54859 .79582 .54798 .79659 .5446 .79572 .54539 Mtetra
.943 .793 .664 r
.79572 .54539 .79659 .5446 .79732 .54079 .79647 .54178 Mtetra
.956 .801 .649 r
.79647 .54178 .79732 .54079 .79804 .53676 .79721 .53797 Mtetra
.972 .825 .637 r
.79721 .53797 .79804 .53676 .79877 .53281 .79795 .53422 Mtetra
.989 .871 .62 r
.79795 .53422 .79877 .53281 .79953 .52932 .79872 .53091 Mtetra
.935 .916 .536 r
.79872 .53091 .79953 .52932 .80034 .52667 .79955 .5284 Mtetra
0 0 0 r
.79955 .5284 .80034 .52667 .80123 .5252 .80044 .527 Mtetra
.382 .084 .329 r
.80044 .527 .80123 .5252 .80222 .52508 .80143 .52687 Mtetra
.597 .302 .438 r
.80143 .52687 .80222 .52508 .8033 .52628 .80251 .52798 Mtetra
.68 .388 .472 r
.80251 .52798 .8033 .52628 .80446 .52858 .80365 .53013 Mtetra
.719 .428 .483 r
.80365 .53013 .80446 .52858 .80567 .53161 .80485 .53297 Mtetra
.74 .446 .482 r
.80485 .53297 .80567 .53161 .80691 .53499 .80607 .53614 Mtetra
.751 .45 .474 r
.80607 .53614 .80691 .53499 .80814 .53835 .80729 .53929 Mtetra
.755 .444 .457 r
.80729 .53929 .80814 .53835 .80936 .54142 .8085 .54217 Mtetra
.753 .426 .431 r
.8085 .54217 .80936 .54142 .81055 .54403 .80968 .5446 Mtetra
.741 .391 .388 r
.80968 .5446 .81055 .54403 .81171 .54608 .81082 .54652 Mtetra
.713 .328 .319 r
.81082 .54652 .81171 .54608 .81282 .54756 .81193 .5479 Mtetra
.647 .209 .195 r
.81193 .5479 .81282 .54756 .8139 .54849 .813 .54876 Mtetra
.473 0 0 r
.813 .54876 .8139 .54849 .81494 .54887 .81404 .5491 Mtetra
0 0 0 r
.81404 .5491 .81494 .54887 .81594 .54874 .81504 .54896 Mtetra
.635 .959 .917 r
.81504 .54896 .81594 .54874 .81691 .54809 .81601 .54833 Mtetra
.847 .948 .884 r
.81601 .54833 .81691 .54809 .81784 .54691 .81694 .5472 Mtetra
.901 .888 .809 r
.81694 .5472 .81784 .54691 .81873 .54519 .81784 .54556 Mtetra
.92 .844 .752 r
.81784 .54556 .81873 .54519 .81958 .54289 .8187 .54338 Mtetra
.931 .817 .712 r
.8187 .54338 .81958 .54289 .82039 .54002 .81952 .54066 Mtetra
.939 .803 .683 r
.81952 .54066 .82039 .54002 .82116 .53662 .8203 .53744 Mtetra
.949 .8 .661 r
.8203 .53744 .82116 .53662 .82189 .5328 .82105 .53382 Mtetra
.962 .809 .645 r
.82105 .53382 .82189 .5328 .82262 .52876 .82179 .53 Mtetra
.978 .833 .631 r
.82179 .53 .82262 .52876 .82334 .52482 .82254 .52626 Mtetra
.991 .88 .608 r
.82254 .52626 .82334 .52482 .8241 .52135 .82331 .52298 Mtetra
.904 .905 .499 r
.82331 .52298 .8241 .52135 .82493 .51877 .82415 .52053 Mtetra
0 0 0 r
.82415 .52053 .82493 .51877 .82585 .51738 .82507 .5192 Mtetra
.408 .11 .344 r
.82507 .5192 .82585 .51738 .82686 .51736 .82609 .51917 Mtetra
.605 .309 .44 r
.82609 .51917 .82686 .51736 .82798 .51866 .8272 .52038 Mtetra
.683 .39 .471 r
.8272 .52038 .82798 .51866 .82918 .52105 .82839 .52262 Mtetra
.721 .427 .48 r
.82839 .52262 .82918 .52105 .83044 .52417 .82963 .52554 Mtetra
.741 .445 .479 r
.82963 .52554 .83044 .52417 .83172 .52761 .8309 .52877 Mtetra
.752 .449 .47 r
.8309 .52877 .83172 .52761 .83301 .53103 .83216 .53197 Mtetra
.756 .442 .453 r
.83216 .53197 .83301 .53103 .83427 .53413 .83341 .53488 Mtetra
.753 .423 .426 r
.83341 .53488 .83427 .53413 .8355 .53676 .83463 .53735 Mtetra
.74 .387 .383 r
.83463 .53735 .8355 .53676 .83669 .53883 .83581 .53928 Mtetra
.711 .324 .313 r
.83581 .53928 .83669 .53883 .83784 .54033 .83695 .54068 Mtetra
.645 .205 .19 r
.83695 .54068 .83784 .54033 .83894 .54126 .83805 .54154 Mtetra
.472 0 0 r
.83805 .54154 .83894 .54126 .84001 .54166 .83911 .5419 Mtetra
.001 0 0 r
.83911 .5419 .84001 .54166 .84104 .54152 .84014 .54176 Mtetra
.618 .956 .904 r
.84014 .54176 .84104 .54152 .84202 .54087 .84112 .54113 Mtetra
.846 .957 .883 r
.84112 .54113 .84202 .54087 .84297 .53968 .84208 .53999 Mtetra
.905 .897 .809 r
.84208 .53999 .84297 .53968 .84387 .53794 .84299 .53833 Mtetra
.926 .853 .751 r
.84299 .53833 .84387 .53794 .84473 .53562 .84385 .53614 Mtetra
.936 .825 .71 r
.84385 .53614 .84473 .53562 .84554 .53273 .84468 .53339 Mtetra
.945 .81 .679 r
.84468 .53339 .84554 .53273 .84632 .52929 .84547 .53014 Mtetra
.955 .807 .657 r
.84547 .53014 .84632 .52929 .84705 .52544 .84622 .5265 Mtetra
.968 .816 .64 r
.84622 .5265 .84705 .52544 .84777 .52139 .84696 .52266 Mtetra
.983 .841 .624 r
.84696 .52266 .84777 .52139 .8485 .51745 .84771 .51893 Mtetra
.991 .887 .594 r
.84771 .51893 .8485 .51745 .84927 .51402 .84849 .51568 Mtetra
.863 .885 .454 r
.84849 .51568 .84927 .51402 .85011 .51149 .84934 .51328 Mtetra
0 0 .051 r
.84934 .51328 .85011 .51149 .85105 .51018 .85029 .51204 Mtetra
.43 .132 .356 r
.85029 .51204 .85105 .51018 .8521 .51025 .85133 .51209 Mtetra
.611 .314 .442 r
.85133 .51209 .8521 .51025 .85326 .51166 .85248 .5134 Mtetra
.685 .391 .47 r
.85248 .5134 .85326 .51166 .8545 .51414 .85372 .51572 Mtetra
.722 .427 .478 r
.85372 .51572 .8545 .51414 .85581 .51734 .85501 .51873 Mtetra
.742 .443 .476 r
.85501 .51873 .85581 .51734 .85714 .52085 .85632 .52202 Mtetra
.752 .446 .466 r
.85632 .52202 .85714 .52085 .85847 .52431 .85764 .52527 Mtetra
.756 .439 .448 r
.85764 .52527 .85847 .52431 .85978 .52745 .85893 .52821 Mtetra
.752 .419 .421 r
.85893 .52821 .85978 .52745 .86105 .5301 .86019 .5307 Mtetra
.739 .383 .377 r
.86019 .5307 .86105 .5301 .86228 .53219 .8614 .53265 Mtetra
.709 .319 .308 r
.8614 .53265 .86228 .53219 .86346 .5337 .86258 .53406 Mtetra
.641 .199 .185 r
.86258 .53406 .86346 .5337 .8646 .53464 .86371 .53493 Mtetra
.47 0 0 r
.86371 .53493 .8646 .53464 .86569 .53503 .8648 .53529 Mtetra
.014 0 0 r
.8648 .53529 .86569 .53503 .86674 .53489 .86585 .53514 Mtetra
.602 .951 .89 r
.86585 .53514 .86674 .53489 .86775 .53423 .86685 .53451 Mtetra
.845 .966 .88 r
.86685 .53451 .86775 .53423 .86871 .53303 .86782 .53336 Mtetra
.909 .907 .808 r
.86782 .53336 .86871 .53303 .86963 .53126 .86875 .53168 Mtetra
.931 .861 .749 r
.86875 .53168 .86963 .53126 .8705 .52892 .86963 .52946 Mtetra
.942 .832 .707 r
.86963 .52946 .8705 .52892 .87132 .52599 .87046 .52669 Mtetra
.951 .817 .675 r
.87046 .52669 .87132 .52599 .87209 .52252 .87125 .5234 Mtetra
.961 .814 .652 r
.87125 .5234 .87209 .52252 .87283 .51864 .872 .51973 Mtetra
.973 .823 .634 r
.872 .51973 .87283 .51864 .87355 .51457 .87275 .51588 Mtetra
.988 .849 .615 r
.87275 .51588 .87355 .51457 .87428 .51063 .8735 .51216 Mtetra
.988 .893 .577 r
.8735 .51216 .87428 .51063 .87505 .50723 .87429 .50893 Mtetra
.811 .856 .403 r
.87429 .50893 .87505 .50723 .87591 .50475 .87515 .50658 Mtetra
0 0 .101 r
.87515 .50658 .87591 .50475 .87687 .50352 .87612 .50541 Mtetra
.448 .151 .367 r
.87612 .50541 .87687 .50352 .87795 .50368 .8772 .50555 Mtetra
.616 .319 .443 r
.8772 .50555 .87795 .50368 .87915 .50518 .87839 .50695 Mtetra
.687 .392 .468 r
.87839 .50695 .87915 .50518 .88044 .50776 .87967 .50937 Mtetra
.723 .426 .475 r
.87967 .50937 .88044 .50776 .8818 .51104 .88101 .51244 Mtetra
.743 .441 .472 r
.88101 .51244 .8818 .51104 .88319 .51461 .88238 .5158 Mtetra
.753 .444 .462 r
.88238 .5158 .88319 .51461 .88457 .51811 .88374 .51909 Mtetra
.755 .436 .444 r
.88374 .51909 .88457 .51811 .88592 .52128 .88508 .52206 Mtetra
.751 .415 .415 r
.88508 .52206 .88592 .52128 .88724 .52396 .88638 .52457 Mtetra
.737 .378 .372 r
.88638 .52457 .88724 .52396 .8885 .52606 .88763 .52654 Mtetra
.706 .313 .301 r
.88763 .52654 .8885 .52606 .88972 .52757 .88884 .52795 Mtetra
.637 .193 .18 r
.88884 .52795 .88972 .52757 .89089 .52851 .89 .52882 Mtetra
.466 0 0 r
.89 .52882 .89089 .52851 .89201 .5289 .89112 .52918 Mtetra
.023 0 0 r
.89112 .52918 .89201 .5289 .89308 .52876 .89219 .52903 Mtetra
.587 .947 .873 r
.89219 .52903 .89308 .52876 .89411 .52808 .89322 .52838 Mtetra
.844 .974 .876 r
.89322 .52838 .89411 .52808 .89509 .52686 .89421 .52722 Mtetra
.914 .916 .805 r
.89421 .52722 .89509 .52686 .89602 .52507 .89515 .52552 Mtetra
.937 .87 .746 r
.89515 .52552 .89602 .52507 .8969 .52269 .89604 .52326 Mtetra
.948 .84 .703 r
.89604 .52326 .8969 .52269 .89772 .51973 .89687 .52045 Mtetra
.957 .824 .671 r
.89687 .52045 .89772 .51973 .8985 .51622 .89767 .51714 Mtetra
.967 .821 .646 r
.89767 .51714 .8985 .51622 .89924 .51231 .89842 .51343 Mtetra
.979 .83 .626 r
.89842 .51343 .89924 .51231 .89996 .50821 .89917 .50956 Mtetra
.991 .857 .604 r
.89917 .50956 .89996 .50821 .90069 .50427 .89992 .50583 Mtetra
.981 .896 .556 r
.89992 .50583 .90069 .50427 .90147 .50088 .90072 .50263 Mtetra
.75 .817 .347 r
.90072 .50263 .90147 .50088 .90234 .49846 .9016 .50033 Mtetra
.023 0 .144 r
.9016 .50033 .90234 .49846 .90333 .4973 .9026 .49923 Mtetra
.464 .167 .375 r
.9026 .49923 .90333 .4973 .90445 .49756 .90371 .49945 Mtetra
.621 .323 .443 r
.90371 .49945 .90445 .49756 .90569 .49915 .90495 .50094 Mtetra
.689 .392 .466 r
.90495 .50094 .90569 .49915 .90703 .50182 .90627 .50345 Mtetra
.724 .425 .472 r
.90627 .50345 .90703 .50182 .90844 .50517 .90766 .5066 Mtetra
.743 .439 .468 r
.90766 .5066 .90844 .50517 .90988 .5088 .90908 .51001 Mtetra
.753 .441 .457 r
.90908 .51001 .90988 .5088 .91132 .51235 .91049 .51334 Mtetra
.755 .433 .439 r
.91049 .51334 .91132 .51235 .91272 .51555 .91188 .51634 Mtetra
.75 .411 .41 r
.91188 .51634 .91272 .51555 .91408 .51824 .91322 .51886 Mtetra
.735 .373 .365 r
.91322 .51886 .91408 .51824 .91538 .52035 .91452 .52084 Mtetra
.703 .307 .295 r
.91452 .52084 .91538 .52035 .91664 .52187 .91576 .52226 Mtetra
.631 .185 .173 r
.91576 .52226 .91664 .52187 .91784 .52281 .91695 .52313 Mtetra
.46 0 0 r
.91695 .52313 .91784 .52281 .91899 .52319 .9181 .52349 Mtetra
.028 0 0 r
.9181 .52349 .91899 .52319 .92009 .52304 .9192 .52333 Mtetra
.574 .941 .856 r
.9192 .52333 .92009 .52304 .92114 .52234 .92025 .52266 Mtetra
.843 .98 .871 r
.92025 .52266 .92114 .52234 .92213 .5211 .92126 .52148 Mtetra
.918 .925 .802 r
.92126 .52148 .92213 .5211 .92308 .51928 .92221 .51975 Mtetra
.942 .878 .742 r
.92221 .51975 .92308 .51928 .92396 .51686 .92311 .51746 Mtetra
.954 .847 .698 r
.92311 .51746 .92396 .51686 .92479 .51385 .92395 .51461 Mtetra
.963 .831 .665 r
.92395 .51461 .92479 .51385 .92557 .5103 .92475 .51125 Mtetra
.973 .827 .64 r
.92475 .51125 .92557 .5103 .9263 .50634 .92551 .50751 Mtetra
.984 .837 .618 r
.92551 .50751 .9263 .50634 .92702 .50222 .92625 .50361 Mtetra
.994 .863 .592 r
.92625 .50361 .92702 .50222 .92776 .49827 .927 .49988 Mtetra
.971 .896 .532 r
.927 .49988 .92776 .49827 .92855 .4949 .92782 .49669 Mtetra
.681 .77 .287 r
.92782 .49669 .92855 .4949 .92944 .49253 .92872 .49444 Mtetra
.078 0 .18 r
.92872 .49444 .92944 .49253 .93045 .49144 .92974 .4934 Mtetra
.478 .18 .382 r
.92974 .4934 .93045 .49144 .93161 .49179 .93089 .49372 Mtetra
.625 .326 .444 r
.93089 .49372 .93161 .49179 .9329 .49348 .93217 .4953 Mtetra
.691 .392 .464 r
.93217 .4953 .9329 .49348 .93429 .49623 .93355 .49788 Mtetra
.725 .424 .469 r
.93355 .49788 .93429 .49623 .93576 .49966 .93499 .5011 Mtetra
.743 .437 .464 r
.93499 .5011 .93576 .49966 .93725 .50334 .93646 .50457 Mtetra
.752 .439 .453 r
.93646 .50457 .93725 .50334 .93874 .50693 .93793 .50793 Mtetra
.754 .429 .434 r
.93793 .50793 .93874 .50693 .94019 .51015 .93936 .51096 Mtetra
.749 .407 .404 r
.93936 .51096 .94019 .51015 .9416 .51286 .94075 .5135 Mtetra
.733 .367 .359 r
.94075 .5135 .9416 .51286 .94295 .51498 .94208 .51549 Mtetra
.699 .299 .287 r
.94208 .51549 .94295 .51498 .94424 .5165 .94336 .51691 Mtetra
.625 .177 .166 r
.94336 .51691 .94424 .5165 .94547 .51743 .94459 .51778 Mtetra
.452 0 0 r
.94459 .51778 .94547 .51743 .94665 .51781 .94577 .51812 Mtetra
.03 0 0 r
.94577 .51812 .94665 .51781 .94777 .51764 .94689 .51795 Mtetra
.564 .936 .839 r
.94689 .51795 .94777 .51764 .94885 .51692 .94797 .51726 Mtetra
.842 .986 .863 r
.94797 .51726 .94885 .51692 .94986 .51565 .94899 .51605 Mtetra
.921 .933 .797 r
.94899 .51605 .94986 .51565 .95082 .51379 .94995 .51429 Mtetra
.948 .886 .738 r
.94995 .51429 .95082 .51379 .95171 .51133 .95086 .51196 Mtetra
.96 .854 .693 r
.95086 .51196 .95171 .51133 .95254 .50827 .95171 .50907 Mtetra
.969 .838 .659 r
.95171 .50907 .95254 .50827 .95332 .50467 .95251 .50566 Mtetra
.978 .834 .632 r
.95251 .50566 .95332 .50467 .95406 .50067 .95327 .50188 Mtetra
.988 .844 .608 r
.95327 .50188 .95406 .50067 .95477 .49652 .95401 .49795 Mtetra
.995 .869 .578 r
.95401 .49795 .95477 .49652 .95551 .49256 .95477 .49421 Mtetra
.955 .892 .504 r
.95477 .49421 .95551 .49256 .95631 .48921 .95559 .49104 Mtetra
0 0 0 r
.95559 .49104 .95631 .48921 .95722 .48688 .95651 .48883 Mtetra
.126 0 .21 r
.95651 .48883 .95722 .48688 .95826 .48587 .95756 .48786 Mtetra
.489 .192 .388 r
.95756 .48786 .95826 .48587 .95946 .4863 .95875 .48826 Mtetra
.628 .329 .443 r
.95875 .48826 .95946 .4863 .96079 .48808 .96008 .48993 Mtetra
.692 .391 .462 r
.96008 .48993 .96079 .48808 .96224 .49092 .96151 .49259 Mtetra
.725 .422 .465 r
.96151 .49259 .96224 .49092 .96377 .49441 .96301 .49588 Mtetra
.743 .435 .46 r
.96301 .49588 .96377 .49441 .96532 .49815 .96454 .4994 Mtetra
.752 .436 .448 r
.96454 .4994 .96532 .49815 .96686 .50178 .96606 .5028 Mtetra
.754 .425 .428 r
.96606 .5028 .96686 .50178 .96837 .50502 .96754 .50585 Mtetra
.747 .402 .398 r
.96754 .50585 .96837 .50502 .96982 .50774 .96898 .5084 Mtetra
.73 .361 .352 r
.96898 .5084 .96982 .50774 .97121 .50987 .97036 .51039 Mtetra
.694 .292 .28 r
.97036 .51039 .97121 .50987 .97254 .51138 .97167 .51181 Mtetra
.619 .168 .158 r
.97167 .51181 .97254 .51138 .97381 .51231 .97293 .51267 Mtetra
.443 0 0 r
.97293 .51267 .97381 .51231 .97502 .51267 .97414 .513 Mtetra
.027 0 0 r
.97414 .513 .97502 .51267 .97617 .51248 .97529 .51282 Mtetra
.555 .931 .821 r
.97529 .51282 .97617 .51248 .97726 .51175 .97639 .51211 Mtetra
.841 .991 .854 r
.97639 .51211 .97726 .51175 .97829 .51044 .97743 .51087 Mtetra
.925 .94 .791 r
.97743 .51087 .97829 .51044 .97926 .50854 .97841 .50907 Mtetra
.953 .893 .732 r
.97841 .50907 .97926 .50854 .98017 .50604 .97933 .50669 Mtetra
.965 .861 .686 r
.97933 .50669 .98017 .50604 .981 .50292 .98018 .50375 Mtetra
.974 .844 .652 r
.98018 .50375 .981 .50292 .98178 .49927 .98098 .5003 Mtetra
.983 .84 .623 r
.98098 .5003 .98178 .49927 .98251 .49522 .98174 .49647 Mtetra
.992 .85 .597 r
.98174 .49647 .98251 .49522 .98323 .49103 .98248 .49251 Mtetra
.994 .873 .562 r
.98248 .49251 .98323 .49103 .98397 .48706 .98325 .48875 Mtetra
.935 .884 .472 r
.98325 .48875 .98397 .48706 .98478 .48373 .98408 .4856 Mtetra
0 0 0 r
.98408 .4856 .98478 .48373 .98571 .48144 .98502 .48343 Mtetra
.167 0 .236 r
.98502 .48343 .98571 .48144 .98678 .4805 .9861 .48253 Mtetra
.331 0 .029 r
.52218 .68749 .52309 .68686 .52386 .68687 .52295 .68748 Mtetra
.685 .346 .395 r
.52295 .68748 .52386 .68687 .52463 .68797 .52372 .68853 Mtetra
.748 .442 .464 r
.52372 .68853 .52463 .68797 .52542 .68993 .52451 .69042 Mtetra
.771 .475 .485 r
.52451 .69042 .52542 .68993 .52621 .69242 .52529 .69281 Mtetra
.782 .487 .488 r
.52529 .69281 .52621 .69242 .527 .69508 .52609 .69538 Mtetra
.787 .486 .478 r
.52609 .69538 .527 .69508 .52779 .69763 .52688 .69783 Mtetra
.787 .472 .456 r
.52688 .69783 .52779 .69763 .52859 .69986 .52767 .69998 Mtetra
.781 .443 .415 r
.52767 .69998 .52859 .69986 .52938 .70165 .52846 .7017 Mtetra
.761 .383 .338 r
.52846 .7017 .52938 .70165 .53016 .70295 .52924 .70294 Mtetra
.701 .247 .171 r
.52924 .70294 .53016 .70295 .53095 .70375 .53003 .7037 Mtetra
.439 0 0 r
.53003 .7037 .53095 .70375 .53173 .70408 .53081 .704 Mtetra
.361 .8 .96 r
.53081 .704 .53173 .70408 .53251 .70393 .53158 .70384 Mtetra
.723 .852 .943 r
.53158 .70384 .53251 .70393 .53328 .70334 .53236 .70325 Mtetra
.799 .796 .849 r
.53236 .70325 .53328 .70334 .53405 .7023 .53313 .70222 Mtetra
.824 .757 .788 r
.53313 .70222 .53405 .7023 .53481 .7008 .53389 .70074 Mtetra
.836 .732 .749 r
.53389 .70074 .53481 .7008 .53558 .69881 .53466 .69879 Mtetra
.844 .715 .722 r
.53466 .69879 .53558 .69881 .53633 .69632 .53541 .69636 Mtetra
.849 .705 .702 r
.53541 .69636 .53633 .69632 .53708 .69334 .53617 .69345 Mtetra
.854 .699 .689 r
.53617 .69345 .53708 .69334 .53783 .68992 .53691 .69011 Mtetra
.859 .698 .681 r
.53691 .69011 .53783 .68992 .53857 .68618 .53766 .68647 Mtetra
.865 .703 .679 r
.53766 .68647 .53857 .68618 .53931 .68235 .5384 .68273 Mtetra
.873 .715 .682 r
.5384 .68273 .53931 .68235 .54006 .67871 .53915 .67918 Mtetra
.886 .742 .697 r
.53915 .67918 .54006 .67871 .54081 .6756 .5399 .67615 Mtetra
.906 .805 .736 r
.5399 .67615 .54081 .6756 .54156 .67337 .54065 .67397 Mtetra
.886 .976 .829 r
.54065 .67397 .54156 .67337 .54233 .67225 .54142 .67287 Mtetra
.375 0 .061 r
.54142 .67287 .54233 .67225 .54312 .67233 .54221 .67292 Mtetra
.692 .351 .395 r
.54221 .67292 .54312 .67233 .54391 .67349 .543 .67403 Mtetra
.752 .443 .461 r
.543 .67403 .54391 .67349 .54472 .6755 .54381 .67596 Mtetra
.774 .475 .481 r
.54381 .67596 .54472 .6755 .54553 .67802 .54462 .67839 Mtetra
.785 .486 .483 r
.54462 .67839 .54553 .67802 .54635 .6807 .54544 .68097 Mtetra
.789 .484 .472 r
.54544 .68097 .54635 .6807 .54717 .68325 .54625 .68343 Mtetra
.789 .47 .449 r
.54625 .68343 .54717 .68325 .54799 .68548 .54707 .68557 Mtetra
.782 .439 .405 r
.54707 .68557 .54799 .68548 .5488 .68726 .54788 .68728 Mtetra
.762 .375 .322 r
.54788 .68728 .5488 .68726 .5496 .68854 .54868 .68851 Mtetra
.695 .229 .141 r
.54868 .68851 .5496 .68854 .55041 .68933 .54948 .68926 Mtetra
.403 0 0 r
.54948 .68926 .55041 .68933 .5512 .68963 .55028 .68953 Mtetra
.395 .81 .976 r
.55028 .68953 .5512 .68963 .55199 .68948 .55107 .68936 Mtetra
.724 .844 .938 r
.55107 .68936 .55199 .68948 .55278 .68886 .55186 .68875 Mtetra
.798 .792 .846 r
.55186 .68875 .55278 .68886 .55356 .6878 .55264 .6877 Mtetra
.824 .755 .787 r
.55264 .6877 .55356 .6878 .55433 .68627 .55341 .6862 Mtetra
.836 .731 .748 r
.55341 .6862 .55433 .68627 .5551 .68425 .55418 .68422 Mtetra
.844 .715 .721 r
.55418 .68422 .5551 .68425 .55586 .68173 .55494 .68176 Mtetra
.85 .705 .702 r
.55494 .68176 .55586 .68173 .55661 .67872 .55569 .67882 Mtetra
.855 .7 .688 r
.55569 .67882 .55661 .67872 .55736 .67527 .55644 .67545 Mtetra
.861 .699 .681 r
.55644 .67545 .55736 .67527 .5581 .67152 .55718 .67179 Mtetra
.867 .704 .678 r
.55718 .67179 .5581 .67152 .55884 .66767 .55793 .66805 Mtetra
.875 .717 .682 r
.55793 .66805 .55884 .66767 .55958 .66404 .55867 .6645 Mtetra
.887 .745 .698 r
.55867 .6645 .55958 .66404 .56033 .66097 .55942 .6615 Mtetra
.908 .811 .74 r
.55942 .6615 .56033 .66097 .56109 .65879 .56019 .65937 Mtetra
.87 .986 .834 r
.56019 .65937 .56109 .65879 .56187 .65773 .56097 .65832 Mtetra
.415 0 .089 r
.56097 .65832 .56187 .65773 .56267 .65787 .56176 .65844 Mtetra
.699 .357 .394 r
.56176 .65844 .56267 .65787 .56349 .65909 .56258 .65961 Mtetra
.755 .444 .458 r
.56258 .65961 .56349 .65909 .56432 .66115 .56341 .66159 Mtetra
.777 .475 .476 r
.56341 .66159 .56432 .66115 .56516 .6637 .56425 .66405 Mtetra
.787 .485 .477 r
.56425 .66405 .56516 .6637 .56601 .6664 .56509 .66665 Mtetra
.792 .483 .466 r
.56509 .66665 .56601 .6664 .56685 .66896 .56593 .66912 Mtetra
.791 .467 .441 r
.56593 .66912 .56685 .66896 .56769 .67119 .56677 .67126 Mtetra
.784 .435 .394 r
.56677 .67126 .56769 .67119 .56852 .67296 .5676 .67296 Mtetra
.762 .367 .306 r
.5676 .67296 .56852 .67296 .56935 .67423 .56843 .67418 Mtetra
.689 .211 .11 r
.56843 .67418 .56935 .67423 .57017 .67501 .56925 .67491 Mtetra
.366 0 0 r
.56925 .67491 .57017 .67501 .57098 .6753 .57006 .67517 Mtetra
.421 .814 .986 r
.57006 .67517 .57098 .6753 .57178 .67512 .57086 .67499 Mtetra
.724 .837 .934 r
.57086 .67499 .57178 .67512 .57258 .6745 .57166 .67436 Mtetra
.796 .788 .845 r
.57166 .67436 .57258 .6745 .57337 .67341 .57245 .67329 Mtetra
.823 .753 .786 r
.57245 .67329 .57337 .67341 .57415 .67186 .57323 .67177 Mtetra
.836 .73 .747 r
.57323 .67177 .57415 .67186 .57493 .66982 .574 .66977 Mtetra
.844 .715 .72 r
.574 .66977 .57493 .66982 .57569 .66727 .57477 .66728 Mtetra
.851 .705 .701 r
.57477 .66728 .57569 .66727 .57644 .66423 .57553 .66431 Mtetra
.856 .7 .688 r
.57553 .66431 .57644 .66423 .57719 .66076 .57627 .66092 Mtetra
.862 .7 .68 r
.57627 .66092 .57719 .66076 .57793 .65698 .57702 .65724 Mtetra
.868 .705 .678 r
.57702 .65724 .57793 .65698 .57867 .65313 .57776 .65349 Mtetra
.876 .719 .683 r
.57776 .65349 .57867 .65313 .57941 .64951 .5785 .64996 Mtetra
.889 .748 .7 r
.5785 .64996 .57941 .64951 .58016 .64647 .57925 .64699 Mtetra
.909 .818 .745 r
.57925 .64699 .58016 .64647 .58093 .64434 .58002 .6449 Mtetra
.846 .995 .838 r
.58002 .6449 .58093 .64434 .58172 .64335 .58082 .64392 Mtetra
.451 .014 .115 r
.58082 .64392 .58172 .64335 .58254 .64355 .58163 .64411 Mtetra
.705 .362 .394 r
.58163 .64411 .58254 .64355 .58338 .64485 .58247 .64534 Mtetra
.759 .445 .454 r
.58247 .64534 .58338 .64485 .58423 .64696 .58332 .64737 Mtetra
.78 .475 .472 r
.58332 .64737 .58423 .64696 .5851 .64955 .58419 .64987 Mtetra
.79 .485 .472 r
.58419 .64987 .5851 .64955 .58597 .65227 .58506 .65249 Mtetra
.794 .481 .459 r
.58506 .65249 .58597 .65227 .58684 .65484 .58593 .65497 Mtetra
.794 .465 .432 r
.58593 .65497 .58684 .65484 .58771 .65707 .58679 .65711 Mtetra
.786 .431 .383 r
.58679 .65711 .58771 .65707 .58856 .65883 .58764 .65881 Mtetra
.763 .36 .288 r
.58764 .65881 .58856 .65883 .58941 .6601 .58849 .66002 Mtetra
.683 .193 .078 r
.58849 .66002 .58941 .6601 .59025 .66086 .58933 .66074 Mtetra
.33 0 0 r
.58933 .66074 .59025 .66086 .59108 .66114 .59015 .661 Mtetra
.44 .815 .992 r
.59015 .661 .59108 .66114 .59189 .66096 .59097 .6608 Mtetra
.724 .831 .931 r
.59097 .6608 .59189 .66096 .5927 .66032 .59178 .66016 Mtetra
.795 .784 .843 r
.59178 .66016 .5927 .66032 .5935 .65922 .59258 .65907 Mtetra
.822 .751 .786 r
.59258 .65907 .5935 .65922 .59429 .65764 .59337 .65753 Mtetra
.836 .729 .747 r
.59337 .65753 .59429 .65764 .59507 .65558 .59415 .65551 Mtetra
.845 .715 .72 r
.59415 .65551 .59507 .65558 .59584 .65301 .59492 .65299 Mtetra
.851 .705 .7 r
.59492 .65299 .59584 .65301 .5966 .64994 .59568 .65 Mtetra
.857 .701 .687 r
.59568 .65 .5966 .64994 .59734 .64644 .59643 .64659 Mtetra
.863 .701 .68 r
.59643 .64659 .59734 .64644 .59808 .64265 .59717 .6429 Mtetra
.869 .706 .677 r
.59717 .6429 .59808 .64265 .59882 .6388 .59791 .63914 Mtetra
.878 .721 .683 r
.59791 .63914 .59882 .6388 .59956 .6352 .59865 .63563 Mtetra
.891 .752 .701 r
.59865 .63563 .59956 .6352 .60031 .63219 .59941 .6327 Mtetra
.911 .826 .75 r
.59941 .6327 .60031 .63219 .60109 .63012 .60019 .63066 Mtetra
.814 .999 .838 r
.60019 .63066 .60109 .63012 .60189 .62919 .60099 .62975 Mtetra
.485 .051 .139 r
.60099 .62975 .60189 .62919 .60273 .62947 .60182 .63 Mtetra
.712 .368 .393 r
.60182 .63 .60273 .62947 .60359 .63084 .60268 .63131 Mtetra
.763 .446 .45 r
.60268 .63131 .60359 .63084 .60447 .633 .60356 .63339 Mtetra
.783 .475 .467 r
.60356 .63339 .60447 .633 .60537 .63563 .60446 .63593 Mtetra
.793 .484 .466 r
.60446 .63593 .60537 .63563 .60627 .63838 .60535 .63858 Mtetra
.797 .48 .453 r
.60535 .63858 .60627 .63838 .60716 .64097 .60625 .64107 Mtetra
.796 .463 .424 r
.60625 .64107 .60716 .64097 .60805 .6432 .60714 .64322 Mtetra
.788 .427 .372 r
.60714 .64322 .60805 .6432 .60893 .64496 .60801 .64491 Mtetra
.763 .352 .271 r
.60801 .64491 .60893 .64496 .6098 .64623 .60888 .64612 Mtetra
.676 .175 .046 r
.60888 .64612 .6098 .64623 .61066 .64698 .60974 .64684 Mtetra
.297 0 0 r
.60974 .64684 .61066 .64698 .6115 .64726 .61058 .64709 Mtetra
.453 .812 .996 r
.61058 .64709 .6115 .64726 .61234 .64706 .61141 .64688 Mtetra
.722 .825 .929 r
.61141 .64688 .61234 .64706 .61316 .64641 .61224 .64623 Mtetra
.793 .781 .843 r
.61224 .64623 .61316 .64641 .61397 .6453 .61305 .64513 Mtetra
.821 .75 .785 r
.61305 .64513 .61397 .6453 .61477 .64371 .61385 .64357 Mtetra
.835 .729 .747 r
.61385 .64357 .61477 .64371 .61555 .64162 .61463 .64153 Mtetra
.845 .715 .719 r
.61463 .64153 .61555 .64162 .61632 .63903 .6154 .639 Mtetra
.852 .706 .7 r
.6154 .639 .61632 .63903 .61708 .63594 .61616 .63598 Mtetra
.858 .702 .687 r
.61616 .63598 .61708 .63594 .61783 .63242 .61691 .63255 Mtetra
.864 .702 .679 r
.61691 .63255 .61783 .63242 .61856 .62862 .61765 .62885 Mtetra
.871 .708 .677 r
.61765 .62885 .61856 .62862 .6193 .62477 .61839 .6251 Mtetra
.88 .723 .683 r
.61839 .6251 .6193 .62477 .62004 .62119 .61914 .6216 Mtetra
.893 .756 .703 r
.61914 .6216 .62004 .62119 .6208 .61823 .6199 .61871 Mtetra
.912 .835 .756 r
.6199 .61871 .6208 .61823 .62158 .61621 .62068 .61674 Mtetra
.77 .997 .832 r
.62068 .61674 .62158 .61621 .6224 .61536 .6215 .61589 Mtetra
.516 .086 .161 r
.6215 .61589 .6224 .61536 .62326 .61572 .62235 .61623 Mtetra
.719 .373 .392 r
.62235 .61623 .62326 .61572 .62414 .61715 .62324 .6176 Mtetra
.767 .448 .446 r
.62324 .6176 .62414 .61715 .62505 .61938 .62415 .61975 Mtetra
.786 .475 .462 r
.62415 .61975 .62505 .61938 .62598 .62206 .62507 .62233 Mtetra
.796 .483 .461 r
.62507 .62233 .62598 .62206 .62691 .62483 .62599 .62501 Mtetra
.8 .479 .446 r
.62599 .62501 .62691 .62483 .62783 .62744 .62692 .62751 Mtetra
.799 .461 .415 r
.62692 .62751 .62783 .62744 .62875 .62968 .62783 .62967 Mtetra
.791 .423 .36 r
.62783 .62967 .62875 .62968 .62965 .63145 .62873 .63137 Mtetra
.764 .345 .254 r
.62873 .63137 .62965 .63145 .63054 .63271 .62962 .63258 Mtetra
.67 .159 .016 r
.62962 .63258 .63054 .63271 .63142 .63347 .6305 .6333 Mtetra
.269 0 0 r
.6305 .6333 .63142 .63347 .63228 .63374 .63136 .63354 Mtetra
.46 .808 .998 r
.63136 .63354 .63228 .63374 .63313 .63354 .63221 .63333 Mtetra
.719 .82 .928 r
.63221 .63333 .63313 .63354 .63397 .63288 .63304 .63268 Mtetra
.79 .779 .843 r
.63304 .63268 .63397 .63288 .63479 .63176 .63386 .63157 Mtetra
.82 .749 .786 r
.63386 .63157 .63479 .63176 .6356 .63015 .63467 .63 Mtetra
.835 .729 .747 r
.63467 .63 .6356 .63015 .63639 .62805 .63546 .62794 Mtetra
.845 .715 .719 r
.63546 .62794 .63639 .62805 .63716 .62544 .63624 .62539 Mtetra
.853 .706 .7 r
.63624 .62539 .63716 .62544 .63792 .62233 .637 .62236 Mtetra
.859 .702 .686 r
.637 .62236 .63792 .62233 .63867 .6188 .63775 .61891 Mtetra
.866 .703 .679 r
.63775 .61891 .63867 .6188 .6394 .61499 .63849 .6152 Mtetra
.873 .71 .677 r
.63849 .6152 .6394 .61499 .64014 .61114 .63923 .61145 Mtetra
.882 .726 .684 r
.63923 .61145 .64014 .61114 .64088 .60758 .63998 .60798 Mtetra
.895 .76 .705 r
.63998 .60798 .64088 .60758 .64164 .60467 .64074 .60514 Mtetra
.913 .845 .763 r
.64074 .60514 .64164 .60467 .64244 .60272 .64154 .60323 Mtetra
.708 .984 .817 r
.64154 .60323 .64244 .60272 .64327 .60194 .64237 .60246 Mtetra
.545 .118 .181 r
.64237 .60246 .64327 .60194 .64414 .60238 .64324 .60287 Mtetra
.726 .379 .391 r
.64324 .60287 .64414 .60238 .64506 .60389 .64415 .60432 Mtetra
.771 .449 .443 r
.64415 .60432 .64506 .60389 .646 .60619 .64509 .60653 Mtetra
.789 .475 .457 r
.64509 .60653 .646 .60619 .64695 .60891 .64604 .60916 Mtetra
.798 .483 .455 r
.64604 .60916 .64695 .60891 .64791 .61173 .647 .61187 Mtetra
.802 .477 .439 r
.647 .61187 .64791 .61173 .64887 .61435 .64795 .61441 Mtetra
.801 .458 .407 r
.64795 .61441 .64887 .61435 .64981 .61661 .64889 .61658 Mtetra
.793 .419 .349 r
.64889 .61658 .64981 .61661 .65074 .61838 .64982 .61828 Mtetra
.765 .338 .237 r
.64982 .61828 .65074 .61838 .65166 .61965 .65073 .6195 Mtetra
.665 .144 0 r
.65073 .6195 .65166 .61965 .65255 .62041 .65163 .62022 Mtetra
.247 0 0 r
.65163 .62022 .65255 .62041 .65343 .62068 .65251 .62047 Mtetra
.462 .802 .999 r
.65251 .62047 .65343 .62068 .6543 .62048 .65337 .62026 Mtetra
.715 .815 .928 r
.65337 .62026 .6543 .62048 .65515 .61982 .65422 .6196 Mtetra
.788 .778 .843 r
.65422 .6196 .65515 .61982 .65598 .61869 .65505 .61849 Mtetra
.819 .749 .786 r
.65505 .61849 .65598 .61869 .6568 .61708 .65587 .61691 Mtetra
.835 .729 .747 r
.65587 .61691 .6568 .61708 .6576 .61497 .65667 .61484 Mtetra
.846 .716 .719 r
.65667 .61484 .6576 .61497 .65837 .61234 .65745 .61228 Mtetra
.854 .707 .7 r
.65745 .61228 .65837 .61234 .65914 .60921 .65822 .60923 Mtetra
.861 .704 .686 r
.65822 .60923 .65914 .60921 .65988 .60567 .65897 .60577 Mtetra
.867 .705 .678 r
.65897 .60577 .65988 .60567 .66061 .60185 .65971 .60205 Mtetra
.874 .712 .677 r
.65971 .60205 .66061 .60185 .66135 .59802 .66044 .59832 Mtetra
.884 .729 .685 r
.66044 .59832 .66135 .59802 .66209 .59449 .66119 .59487 Mtetra
.897 .766 .708 r
.66119 .59487 .66209 .59449 .66286 .59162 .66196 .59208 Mtetra
.914 .856 .77 r
.66196 .59208 .66286 .59162 .66367 .58974 .66277 .59024 Mtetra
.625 .954 .786 r
.66277 .59024 .66367 .58974 .66452 .58905 .66362 .58955 Mtetra
.571 .148 .2 r
.66362 .58955 .66452 .58905 .66541 .58958 .66452 .59005 Mtetra
.732 .384 .391 r
.66452 .59005 .66541 .58958 .66635 .59117 .66545 .59158 Mtetra
.774 .451 .439 r
.66545 .59158 .66635 .59117 .66732 .59353 .66642 .59386 Mtetra
.792 .475 .452 r
.66642 .59386 .66732 .59353 .66831 .59631 .6674 .59654 Mtetra
.801 .482 .449 r
.6674 .59654 .66831 .59631 .6693 .59917 .66839 .59929 Mtetra
.805 .476 .432 r
.66839 .59929 .6693 .59917 .67029 .60182 .66937 .60185 Mtetra
.804 .456 .398 r
.66937 .60185 .67029 .60182 .67126 .60409 .67034 .60404 Mtetra
.795 .415 .338 r
.67034 .60404 .67126 .60409 .67222 .60588 .6713 .60576 Mtetra
.765 .331 .221 r
.6713 .60576 .67222 .60588 .67316 .60716 .67223 .60698 Mtetra
.66 .132 0 r
.67223 .60698 .67316 .60716 .67408 .60793 .67315 .60771 Mtetra
.232 0 0 r
.67315 .60771 .67408 .60793 .67498 .6082 .67405 .60797 Mtetra
.458 .796 .999 r
.67405 .60797 .67498 .6082 .67586 .60801 .67493 .60776 Mtetra
.71 .812 .929 r
.67493 .60776 .67586 .60801 .67672 .60735 .67579 .60711 Mtetra
.786 .777 .845 r
.67579 .60711 .67672 .60735 .67757 .60622 .67664 .60599 Mtetra
.818 .749 .788 r
.67664 .60599 .67757 .60622 .67839 .6046 .67747 .60441 Mtetra
.835 .73 .748 r
.67747 .60441 .67839 .6046 .6792 .60247 .67827 .60233 Mtetra
.847 .717 .72 r
.67827 .60233 .6792 .60247 .67998 .59983 .67906 .59976 Mtetra
.855 .709 .699 r
.67906 .59976 .67998 .59983 .68075 .59669 .67983 .59669 Mtetra
.862 .705 .686 r
.67983 .59669 .68075 .59669 .68149 .59314 .68058 .59323 Mtetra
.869 .707 .678 r
.68058 .59323 .68149 .59314 .68223 .58932 .68132 .58951 Mtetra
.876 .714 .677 r
.68132 .58951 .68223 .58932 .68296 .5855 .68205 .58579 Mtetra
.886 .732 .686 r
.68205 .58579 .68296 .5855 .6837 .582 .68281 .58238 Mtetra
.9 .772 .711 r
.68281 .58238 .6837 .582 .68448 .57919 .68358 .57964 Mtetra
.915 .869 .779 r
.68358 .57964 .68448 .57919 .6853 .57738 .6844 .57787 Mtetra
.516 .899 .733 r
.6844 .57787 .6853 .57738 .68617 .57678 .68527 .57727 Mtetra
.595 .177 .218 r
.68527 .57727 .68617 .57678 .68709 .5774 .68619 .57786 Mtetra
.738 .39 .39 r
.68619 .57786 .68709 .5774 .68806 .57908 .68716 .57947 Mtetra
.778 .452 .436 r
.68716 .57947 .68806 .57908 .68906 .58152 .68816 .58182 Mtetra
.795 .475 .448 r
.68816 .58182 .68906 .58152 .69008 .58436 .68917 .58456 Mtetra
.804 .481 .443 r
.68917 .58456 .69008 .58436 .69111 .58725 .6902 .58736 Mtetra
.807 .475 .425 r
.6902 .58736 .69111 .58725 .69213 .58994 .69121 .58995 Mtetra
.806 .454 .39 r
.69121 .58995 .69213 .58994 .69313 .59223 .69221 .59216 Mtetra
.797 .412 .327 r
.69221 .59216 .69313 .59223 .69412 .59404 .69319 .5939 Mtetra
.766 .326 .206 r
.69319 .5939 .69412 .59404 .69508 .59533 .69415 .59514 Mtetra
.656 .123 0 r
.69415 .59514 .69508 .59533 .69602 .59611 .69509 .59588 Mtetra
.226 0 0 r
.69509 .59588 .69602 .59611 .69694 .59639 .69601 .59614 Mtetra
.451 .789 .998 r
.69601 .59614 .69694 .59639 .69784 .5962 .69691 .59594 Mtetra
.705 .811 .931 r
.69691 .59594 .69784 .5962 .69872 .59555 .69779 .59529 Mtetra
.784 .778 .847 r
.69779 .59529 .69872 .59555 .69958 .59442 .69865 .59418 Mtetra
.817 .75 .789 r
.69865 .59418 .69958 .59442 .70041 .5928 .69949 .5926 Mtetra
.836 .731 .749 r
.69949 .5926 .70041 .5928 .70123 .59066 .7003 .59051 Mtetra
.848 .718 .72 r
.7003 .59051 .70123 .59066 .70202 .58801 .70109 .58793 Mtetra
.857 .711 .7 r
.70109 .58793 .70202 .58801 .70278 .58486 .70186 .58485 Mtetra
.864 .707 .686 r
.70186 .58485 .70278 .58486 .70353 .5813 .70261 .58138 Mtetra
.871 .709 .678 r
.70261 .58138 .70353 .5813 .70426 .57748 .70335 .57767 Mtetra
.879 .717 .678 r
.70335 .57767 .70426 .57748 .70499 .57367 .70409 .57396 Mtetra
.889 .737 .687 r
.70409 .57396 .70499 .57367 .70574 .57021 .70485 .57058 Mtetra
.903 .779 .714 r
.70485 .57058 .70574 .57021 .70653 .56746 .70563 .5679 Mtetra
.915 .884 .788 r
.70563 .5679 .70653 .56746 .70736 .56573 .70646 .56621 Mtetra
.382 .816 .655 r
.70646 .56621 .70736 .56573 .70825 .56522 .70735 .5657 Mtetra
.616 .202 .235 r
.70735 .5657 .70825 .56522 .70919 .56593 .7083 .56638 Mtetra
.744 .395 .39 r
.7083 .56638 .70919 .56593 .71019 .5677 .7093 .56808 Mtetra
.781 .453 .432 r
.7093 .56808 .71019 .5677 .71123 .57022 .71033 .57051 Mtetra
.798 .475 .443 r
.71033 .57051 .71123 .57022 .71229 .57312 .71138 .57331 Mtetra
.806 .48 .438 r
.71138 .57331 .71229 .57312 .71335 .57607 .71244 .57616 Mtetra
.81 .473 .419 r
.71244 .57616 .71335 .57607 .71441 .57879 .71349 .57878 Mtetra
.808 .452 .382 r
.71349 .57878 .71441 .57879 .71544 .58111 .71452 .58102 Mtetra
.798 .409 .317 r
.71452 .58102 .71544 .58111 .71645 .58293 .71553 .58278 Mtetra
.766 .32 .194 r
.71553 .58278 .71645 .58293 .71744 .58424 .71651 .58404 Mtetra
.653 .115 0 r
.71651 .58404 .71744 .58424 .71841 .58503 .71748 .58479 Mtetra
.226 0 0 r
.71748 .58479 .71841 .58503 .71935 .58533 .71842 .58507 Mtetra
.439 .783 .998 r
.71842 .58507 .71935 .58533 .72027 .58515 .71933 .58488 Mtetra
.699 .811 .934 r
.71933 .58488 .72027 .58515 .72116 .5845 .72023 .58424 Mtetra
.782 .78 .851 r
.72023 .58424 .72116 .5845 .72204 .58337 .7211 .58313 Mtetra
.817 .753 .792 r
.7211 .58313 .72204 .58337 .72288 .58175 .72195 .58154 Mtetra
.837 .734 .75 r
.72195 .58154 .72288 .58175 .7237 .57961 .72278 .57946 Mtetra
.85 .721 .721 r
.72278 .57946 .7237 .57961 .7245 .57695 .72358 .57686 Mtetra
.859 .713 .7 r
.72358 .57686 .7245 .57695 .72527 .57379 .72435 .57378 Mtetra
.867 .71 .686 r
.72435 .57378 .72527 .57379 .72601 .57022 .7251 .5703 Mtetra
.874 .712 .678 r
.7251 .5703 .72601 .57022 .72675 .5664 .72584 .56659 Mtetra
.882 .721 .678 r
.72584 .56659 .72675 .5664 .72748 .56261 .72658 .5629 Mtetra
.892 .742 .688 r
.72658 .5629 .72748 .56261 .72824 .55919 .72734 .55956 Mtetra
.907 .787 .718 r
.72734 .55956 .72824 .55919 .72903 .5565 .72814 .55694 Mtetra
.914 .902 .799 r
.72814 .55694 .72903 .5565 .72987 .55485 .72898 .55533 Mtetra
0 0 0 r
.72898 .55533 .72987 .55485 .73078 .55443 .72989 .55491 Mtetra
.634 .225 .251 r
.72989 .55491 .73078 .55443 .73176 .55525 .73087 .55569 Mtetra
.749 .399 .39 r
.73087 .55569 .73176 .55525 .73279 .55711 .7319 .55748 Mtetra
.784 .454 .429 r
.7319 .55748 .73279 .55711 .73387 .55971 .73297 .55999 Mtetra
.8 .475 .439 r
.73297 .55999 .73387 .55971 .73496 .56267 .73406 .56286 Mtetra
.808 .479 .432 r
.73406 .56286 .73496 .56267 .73606 .56567 .73515 .56575 Mtetra
.811 .471 .412 r
.73515 .56575 .73606 .56567 .73715 .56843 .73623 .56841 Mtetra
.81 .449 .375 r
.73623 .56841 .73715 .56843 .73822 .57077 .7373 .57068 Mtetra
.799 .405 .308 r
.7373 .57068 .73822 .57077 .73927 .57263 .73834 .57246 Mtetra
.765 .315 .182 r
.73834 .57246 .73927 .57263 .74028 .57395 .73935 .57374 Mtetra
.651 .11 0 r
.73935 .57374 .74028 .57395 .74127 .57476 .74034 .57451 Mtetra
.231 0 0 r
.74034 .57451 .74127 .57476 .74224 .57507 .7413 .5748 Mtetra
.425 .777 .996 r
.7413 .5748 .74224 .57507 .74317 .5749 .74224 .57463 Mtetra
.693 .813 .939 r
.74224 .57463 .74317 .5749 .74409 .57426 .74315 .57399 Mtetra
.781 .783 .854 r
.74315 .57399 .74409 .57426 .74497 .57314 .74404 .57289 Mtetra
.818 .756 .794 r
.74404 .57289 .74497 .57314 .74583 .57151 .7449 .5713 Mtetra
.839 .737 .752 r
.7449 .5713 .74583 .57151 .74666 .56937 .74573 .56921 Mtetra
.852 .724 .721 r
.74573 .56921 .74666 .56937 .74746 .56669 .74654 .5666 Mtetra
.861 .716 .7 r
.74654 .5666 .74746 .56669 .74823 .56352 .74732 .56351 Mtetra
.869 .713 .686 r
.74732 .56351 .74823 .56352 .74898 .55994 .74807 .56003 Mtetra
.877 .715 .678 r
.74807 .56003 .74898 .55994 .74972 .55613 .74881 .55632 Mtetra
.885 .725 .678 r
.74881 .55632 .74972 .55613 .75045 .55236 .74955 .55264 Mtetra
.896 .748 .689 r
.74955 .55264 .75045 .55236 .75121 .54897 .75032 .54935 Mtetra
.911 .797 .722 r
.75032 .54935 .75121 .54897 .75201 .54634 .75112 .54678 Mtetra
.912 .922 .809 r
.75112 .54678 .75201 .54634 .75287 .54477 .75199 .54525 Mtetra
0 0 0 r
.75199 .54525 .75287 .54477 .75381 .54445 .75292 .54493 Mtetra
.65 .246 .265 r
.75292 .54493 .75381 .54445 .75481 .54537 .75393 .5458 Mtetra
.753 .403 .389 r
.75393 .5458 .75481 .54537 .75588 .54732 .75499 .54769 Mtetra
.787 .455 .426 r
.75499 .54769 .75588 .54732 .757 .55 .7561 .55028 Mtetra
.802 .474 .434 r
.7561 .55028 .757 .55 .75813 .55304 .75723 .55322 Mtetra
.81 .478 .427 r
.75723 .55322 .75813 .55304 .75927 .55608 .75836 .55616 Mtetra
.813 .469 .406 r
.75836 .55616 .75927 .55608 .7604 .55888 .75948 .55887 Mtetra
.811 .447 .367 r
.75948 .55887 .7604 .55888 .7615 .56126 .76058 .56116 Mtetra
.799 .401 .299 r
.76058 .56116 .7615 .56126 .76258 .56313 .76165 .56297 Mtetra
.764 .311 .172 r
.76165 .56297 .76258 .56313 .76362 .56448 .76269 .56426 Mtetra
.649 .106 0 r
.76269 .56426 .76362 .56448 .76464 .5653 .76371 .56505 Mtetra
.239 0 0 r
.76371 .56505 .76464 .5653 .76563 .56563 .76469 .56536 Mtetra
.409 .773 .995 r
.76469 .56536 .76563 .56563 .76658 .56547 .76565 .56519 Mtetra
.688 .816 .944 r
.76565 .56519 .76658 .56547 .76752 .56484 .76658 .56457 Mtetra
.78 .787 .859 r
.76658 .56457 .76752 .56484 .76842 .56371 .76748 .56347 Mtetra
.82 .761 .797 r
.76748 .56347 .76842 .56371 .76929 .56209 .76836 .56188 Mtetra
.841 .741 .753 r
.76836 .56188 .76929 .56209 .77013 .55993 .7692 .55978 Mtetra
.855 .728 .722 r
.7692 .55978 .77013 .55993 .77093 .55725 .77001 .55716 Mtetra
.865 .72 .7 r
.77001 .55716 .77093 .55725 .77171 .55406 .77079 .55406 Mtetra
.873 .717 .685 r
.77079 .55406 .77171 .55406 .77246 .55047 .77155 .55057 Mtetra
.881 .719 .678 r
.77155 .55057 .77246 .55047 .7732 .54666 .77229 .54686 Mtetra
.889 .73 .678 r
.77229 .54686 .7732 .54666 .77393 .5429 .77304 .5432 Mtetra
.9 .754 .69 r
.77304 .5432 .77393 .5429 .7747 .53955 .77381 .53994 Mtetra
.916 .808 .726 r
.77381 .53994 .7747 .53955 .77551 .53698 .77462 .53744 Mtetra
.907 .943 .818 r
.77462 .53744 .77551 .53698 .77639 .5355 .77551 .53599 Mtetra
.053 0 0 r
.77551 .53599 .77639 .5355 .77735 .53528 .77646 .53576 Mtetra
.663 .263 .277 r
.77646 .53576 .77735 .53528 .77839 .53629 .7775 .53673 Mtetra
.757 .406 .389 r
.7775 .53673 .77839 .53629 .77949 .53834 .7786 .53871 Mtetra
.789 .455 .423 r
.7786 .53871 .77949 .53834 .78065 .5411 .77975 .54139 Mtetra
.804 .473 .43 r
.77975 .54139 .78065 .5411 .78183 .54421 .78092 .54439 Mtetra
.811 .476 .422 r
.78092 .54439 .78183 .54421 .78301 .54731 .7821 .54738 Mtetra
.814 .467 .4 r
.7821 .54738 .78301 .54731 .78417 .55014 .78325 .55013 Mtetra
.811 .443 .36 r
.78325 .55013 .78417 .55014 .78531 .55255 .78439 .55245 Mtetra
.799 .397 .291 r
.78439 .55245 .78531 .55255 .78642 .55445 .78549 .55428 Mtetra
.763 .305 .163 r
.78549 .55428 .78642 .55445 .7875 .55581 .78656 .5556 Mtetra
.646 .102 0 r
.78656 .5556 .7875 .55581 .78854 .55665 .7876 .5564 Mtetra
.247 0 0 r
.7876 .5564 .78854 .55665 .78955 .55699 .78861 .55672 Mtetra
.393 .769 .992 r
.78861 .55672 .78955 .55699 .79053 .55684 .78959 .55657 Mtetra
.683 .821 .949 r
.78959 .55657 .79053 .55684 .79148 .55621 .79054 .55595 Mtetra
.78 .793 .863 r
.79054 .55595 .79148 .55621 .7924 .55509 .79146 .55485 Mtetra
.822 .766 .8 r
.79146 .55485 .7924 .55509 .79328 .55345 .79235 .55325 Mtetra
.844 .746 .755 r
.79235 .55325 .79328 .55345 .79413 .55129 .7932 .55114 Mtetra
.858 .732 .723 r
.7932 .55114 .79413 .55129 .79494 .54859 .79402 .54851 Mtetra
.868 .724 .7 r
.79402 .54851 .79494 .54859 .79572 .54539 .79481 .5454 Mtetra
.877 .721 .685 r
.79481 .5454 .79572 .54539 .79647 .54178 .79557 .54189 Mtetra
.885 .724 .677 r
.79557 .54189 .79647 .54178 .79721 .53797 .79631 .53818 Mtetra
.894 .735 .678 r
.79631 .53818 .79721 .53797 .79795 .53422 .79706 .53454 Mtetra
.905 .762 .692 r
.79706 .53454 .79795 .53422 .79872 .53091 .79783 .53131 Mtetra
.921 .821 .73 r
.79783 .53131 .79872 .53091 .79955 .5284 .79866 .52887 Mtetra
.897 .964 .825 r
.79866 .52887 .79955 .5284 .80044 .527 .79957 .5275 Mtetra
.167 0 0 r
.79957 .5275 .80044 .527 .80143 .52687 .80055 .52736 Mtetra
.673 .278 .288 r
.80055 .52736 .80143 .52687 .80251 .52798 .80162 .52843 Mtetra
.76 .409 .389 r
.80162 .52843 .80251 .52798 .80365 .53013 .80276 .53051 Mtetra
.79 .455 .419 r
.80276 .53051 .80365 .53013 .80485 .53297 .80395 .53326 Mtetra
.805 .472 .425 r
.80395 .53326 .80485 .53297 .80607 .53614 .80517 .53632 Mtetra
.812 .474 .417 r
.80517 .53632 .80607 .53614 .80729 .53929 .80638 .53937 Mtetra
.814 .464 .394 r
.80638 .53937 .80729 .53929 .8085 .54217 .80758 .54215 Mtetra
.811 .44 .353 r
.80758 .54215 .8085 .54217 .80968 .5446 .80875 .54451 Mtetra
.798 .392 .283 r
.80875 .54451 .80968 .5446 .81082 .54652 .80989 .54636 Mtetra
.76 .3 .155 r
.80989 .54636 .81082 .54652 .81193 .5479 .811 .54769 Mtetra
.643 .097 0 r
.811 .54769 .81193 .5479 .813 .54876 .81206 .54851 Mtetra
.255 0 0 r
.81206 .54851 .813 .54876 .81404 .5491 .8131 .54884 Mtetra
.379 .766 .989 r
.8131 .54884 .81404 .5491 .81504 .54896 .8141 .54869 Mtetra
.68 .827 .954 r
.8141 .54869 .81504 .54896 .81601 .54833 .81507 .54807 Mtetra
.782 .8 .868 r
.81507 .54807 .81601 .54833 .81694 .5472 .81601 .54697 Mtetra
.825 .772 .803 r
.81601 .54697 .81694 .5472 .81784 .54556 .81691 .54537 Mtetra
.848 .751 .756 r
.81691 .54537 .81784 .54556 .8187 .54338 .81777 .54325 Mtetra
.862 .737 .723 r
.81777 .54325 .8187 .54338 .81952 .54066 .8186 .5406 Mtetra
.872 .728 .7 r
.8186 .5406 .81952 .54066 .8203 .53744 .81939 .53747 Mtetra
.881 .725 .684 r
.81939 .53747 .8203 .53744 .82105 .53382 .82015 .53394 Mtetra
.889 .729 .677 r
.82015 .53394 .82105 .53382 .82179 .53 .82089 .53022 Mtetra
.899 .741 .678 r
.82089 .53022 .82179 .53 .82254 .52626 .82165 .52659 Mtetra
.911 .77 .693 r
.82165 .52659 .82254 .52626 .82331 .52298 .82243 .5234 Mtetra
.926 .834 .734 r
.82243 .5234 .82331 .52298 .82415 .52053 .82327 .52101 Mtetra
.88 .983 .827 r
.82327 .52101 .82415 .52053 .82507 .5192 .82419 .51972 Mtetra
.258 0 0 r
.82419 .51972 .82507 .5192 .82609 .51917 .82521 .51967 Mtetra
.682 .29 .297 r
.82521 .51967 .82609 .51917 .8272 .52038 .82632 .52084 Mtetra
.762 .41 .388 r
.82632 .52084 .8272 .52038 .82839 .52262 .8275 .52301 Mtetra
.792 .454 .416 r
.8275 .52301 .82839 .52262 .82963 .52554 .82874 .52584 Mtetra
.806 .47 .421 r
.82874 .52584 .82963 .52554 .8309 .52877 .82999 .52897 Mtetra
.813 .472 .411 r
.82999 .52897 .8309 .52877 .83216 .53197 .83125 .53206 Mtetra
.814 .461 .388 r
.83125 .53206 .83216 .53197 .83341 .53488 .83249 .53488 Mtetra
.811 .436 .346 r
.83249 .53488 .83341 .53488 .83463 .53735 .8337 .53726 Mtetra
.796 .387 .275 r
.8337 .53726 .83463 .53735 .83581 .53928 .83488 .53913 Mtetra
.757 .293 .146 r
.83488 .53913 .83581 .53928 .83695 .54068 .83601 .54048 Mtetra
.639 .092 0 r
.83601 .54048 .83695 .54068 .83805 .54154 .83711 .54131 Mtetra
.26 0 0 r
.83711 .54131 .83805 .54154 .83911 .5419 .83817 .54165 Mtetra
.366 .765 .985 r
.83817 .54165 .83911 .5419 .84014 .54176 .8392 .5415 Mtetra
.677 .834 .959 r
.8392 .5415 .84014 .54176 .84112 .54113 .84019 .54088 Mtetra
.784 .808 .872 r
.84019 .54088 .84112 .54113 .84208 .53999 .84114 .53977 Mtetra
.828 .779 .805 r
.84114 .53977 .84208 .53999 .84299 .53833 .84205 .53816 Mtetra
.852 .757 .758 r
.84205 .53816 .84299 .53833 .84385 .53614 .84293 .53602 Mtetra
.867 .742 .723 r
.84293 .53602 .84385 .53614 .84468 .53339 .84376 .53335 Mtetra
.877 .733 .699 r
.84376 .53335 .84468 .53339 .84547 .53014 .84455 .53019 Mtetra
.886 .73 .684 r
.84455 .53019 .84547 .53014 .84622 .5265 .84532 .52664 Mtetra
.894 .734 .676 r
.84532 .52664 .84622 .5265 .84696 .52266 .84607 .52291 Mtetra
.904 .748 .678 r
.84607 .52291 .84696 .52266 .84771 .51893 .84682 .51929 Mtetra
.917 .779 .693 r
.84682 .51929 .84771 .51893 .84849 .51568 .84761 .51612 Mtetra
.932 .849 .738 r
.84761 .51612 .84849 .51568 .84934 .51328 .84847 .51379 Mtetra
.852 .996 .822 r
.84847 .51379 .84934 .51328 .85029 .51204 .84942 .51257 Mtetra
.329 0 0 r
.84942 .51257 .85029 .51204 .85133 .51209 .85046 .51262 Mtetra
.689 .3 .304 r
.85046 .51262 .85133 .51209 .85248 .5134 .85161 .51388 Mtetra
.764 .411 .387 r
.85161 .51388 .85248 .5134 .85372 .51572 .85284 .51613 Mtetra
.793 .453 .412 r
.85284 .51613 .85372 .51572 .85501 .51873 .85412 .51903 Mtetra
.806 .468 .416 r
.85412 .51903 .85501 .51873 .85632 .52202 .85542 .52222 Mtetra
.813 .469 .405 r
.85542 .52222 .85632 .52202 .85764 .52527 .85673 .52537 Mtetra
.814 .458 .381 r
.85673 .52537 .85764 .52527 .85893 .52821 .85801 .52822 Mtetra
.81 .431 .339 r
.85801 .52822 .85893 .52821 .86019 .5307 .85926 .53062 Mtetra
.794 .381 .266 r
.85926 .53062 .86019 .5307 .8614 .53265 .86047 .53251 Mtetra
.753 .286 .137 r
.86047 .53251 .8614 .53265 .86258 .53406 .86164 .53387 Mtetra
.633 .084 0 r
.86164 .53387 .86258 .53406 .86371 .53493 .86277 .53471 Mtetra
.261 0 0 r
.86277 .53471 .86371 .53493 .8648 .53529 .86386 .53505 Mtetra
.356 .766 .981 r
.86386 .53505 .8648 .53529 .86585 .53514 .86491 .5349 Mtetra
.676 .841 .963 r
.86491 .5349 .86585 .53514 .86685 .53451 .86592 .53428 Mtetra
.786 .816 .876 r
.86592 .53428 .86685 .53451 .86782 .53336 .86689 .53316 Mtetra
.833 .786 .807 r
.86689 .53316 .86782 .53336 .86875 .53168 .86782 .53152 Mtetra
.857 .763 .758 r
.86782 .53152 .86875 .53168 .86963 .52946 .8687 .52936 Mtetra
.871 .748 .723 r
.8687 .52936 .86963 .52946 .87046 .52669 .86954 .52666 Mtetra
.882 .738 .699 r
.86954 .52666 .87046 .52669 .87125 .5234 .87034 .52347 Mtetra
.891 .736 .683 r
.87034 .52347 .87125 .5234 .872 .51973 .8711 .5199 Mtetra
.899 .74 .675 r
.8711 .5199 .872 .51973 .87275 .51588 .87185 .51615 Mtetra
.909 .755 .677 r
.87185 .51615 .87275 .51588 .8735 .51216 .87261 .51253 Mtetra
.923 .788 .694 r
.87261 .51253 .8735 .51216 .87429 .50893 .87341 .50939 Mtetra
.937 .864 .741 r
.87341 .50939 .87429 .50893 .87515 .50658 .87429 .50711 Mtetra
.811 1 .807 r
.87429 .50711 .87515 .50658 .87612 .50541 .87526 .50596 Mtetra
.384 0 0 r
.87526 .50596 .87612 .50541 .8772 .50555 .87634 .50609 Mtetra
.695 .308 .31 r
.87634 .50609 .8772 .50555 .87839 .50695 .87752 .50745 Mtetra
.766 .412 .385 r
.87752 .50745 .87839 .50695 .87967 .50937 .8788 .50978 Mtetra
.793 .451 .408 r
.8788 .50978 .87967 .50937 .88101 .51244 .88013 .51276 Mtetra
.807 .466 .411 r
.88013 .51276 .88101 .51244 .88238 .5158 .88148 .51601 Mtetra
.813 .466 .399 r
.88148 .51601 .88238 .5158 .88374 .51909 .88283 .5192 Mtetra
.814 .454 .374 r
.88283 .5192 .88374 .51909 .88508 .52206 .88416 .52208 Mtetra
.809 .426 .331 r
.88416 .52208 .88508 .52206 .88638 .52457 .88545 .5245 Mtetra
.792 .375 .257 r
.88545 .5245 .88638 .52457 .88763 .52654 .8867 .52641 Mtetra
.749 .277 .127 r
.8867 .52641 .88763 .52654 .88884 .52795 .88791 .52777 Mtetra
.626 .075 0 r
.88791 .52777 .88884 .52795 .89 .52882 .88907 .52861 Mtetra
.259 0 0 r
.88907 .52861 .89 .52882 .89112 .52918 .89018 .52895 Mtetra
.35 .768 .978 r
.89018 .52895 .89112 .52918 .89219 .52903 .89126 .5288 Mtetra
.675 .85 .966 r
.89126 .5288 .89219 .52903 .89322 .52838 .89229 .52817 Mtetra
.79 .824 .879 r
.89229 .52817 .89322 .52838 .89421 .52722 .89328 .52703 Mtetra
.837 .793 .809 r
.89328 .52703 .89421 .52722 .89515 .52552 .89422 .52538 Mtetra
.862 .77 .759 r
.89422 .52538 .89515 .52552 .89604 .52326 .89511 .52318 Mtetra
.877 .753 .723 r
.89511 .52318 .89604 .52326 .89687 .52045 .89596 .52045 Mtetra
.887 .744 .698 r
.89596 .52045 .89687 .52045 .89767 .51714 .89676 .51722 Mtetra
.896 .741 .681 r
.89676 .51722 .89767 .51714 .89842 .51343 .89753 .51362 Mtetra
.905 .746 .674 r
.89753 .51362 .89842 .51343 .89917 .50956 .89828 .50986 Mtetra
.915 .762 .676 r
.89828 .50986 .89917 .50956 .89992 .50583 .89904 .50623 Mtetra
.929 .798 .694 r
.89904 .50623 .89992 .50583 .90072 .50263 .89985 .50312 Mtetra
.942 .881 .744 r
.89985 .50312 .90072 .50263 .9016 .50033 .90074 .50088 Mtetra
.753 .989 .778 r
.90074 .50088 .9016 .50033 .9026 .49923 .90174 .4998 Mtetra
.427 0 .042 r
.90174 .4998 .9026 .49923 .90371 .49945 .90285 .50002 Mtetra
.7 .314 .314 r
.90285 .50002 .90371 .49945 .90495 .50094 .90408 .50146 Mtetra
.767 .412 .383 r
.90408 .50146 .90495 .50094 .90627 .50345 .9054 .50388 Mtetra
.794 .45 .404 r
.9054 .50388 .90627 .50345 .90766 .5066 .90678 .50693 Mtetra
.807 .463 .405 r
.90678 .50693 .90766 .5066 .90908 .51001 .90819 .51024 Mtetra
.813 .463 .393 r
.90819 .51024 .90908 .51001 .91049 .51334 .90959 .51346 Mtetra
.813 .449 .367 r
.90959 .51346 .91049 .51334 .91188 .51634 .91097 .51637 Mtetra
.807 .42 .322 r
.91097 .51637 .91188 .51634 .91322 .51886 .9123 .51881 Mtetra
.789 .367 .247 r
.9123 .51881 .91322 .51886 .91452 .52084 .91359 .52073 Mtetra
.743 .268 .116 r
.91359 .52073 .91452 .52084 .91576 .52226 .91483 .5221 Mtetra
.617 .064 0 r
.91483 .5221 .91576 .52226 .91695 .52313 .91602 .52294 Mtetra
.253 0 0 r
.91602 .52294 .91695 .52313 .9181 .52349 .91716 .52327 Mtetra
.346 .771 .974 r
.91716 .52327 .9181 .52349 .9192 .52333 .91826 .52311 Mtetra
.677 .858 .968 r
.91826 .52311 .9192 .52333 .92025 .52266 .91932 .52246 Mtetra
.794 .833 .881 r
.91932 .52246 .92025 .52266 .92126 .52148 .92032 .52131 Mtetra
.842 .801 .81 r
.92032 .52131 .92126 .52148 .92221 .51975 .92128 .51962 Mtetra
.867 .776 .759 r
.92128 .51962 .92221 .51975 .92311 .51746 .92219 .51739 Mtetra
.882 .759 .722 r
.92219 .51739 .92311 .51746 .92395 .51461 .92304 .51462 Mtetra
.893 .749 .696 r
.92304 .51462 .92395 .51461 .92475 .51125 .92384 .51136 Mtetra
.901 .746 .68 r
.92384 .51136 .92475 .51125 .92551 .50751 .92461 .50772 Mtetra
.911 .752 .672 r
.92461 .50772 .92551 .50751 .92625 .50361 .92537 .50393 Mtetra
.921 .769 .675 r
.92537 .50393 .92625 .50361 .927 .49988 .92613 .5003 Mtetra
.936 .808 .694 r
.92613 .5003 .927 .49988 .92782 .49669 .92695 .49721 Mtetra
.946 .897 .746 r
.92695 .49721 .92782 .49669 .92872 .49444 .92786 .49501 Mtetra
.678 .961 .734 r
.92786 .49501 .92872 .49444 .92974 .4934 .92888 .494 Mtetra
.461 .003 .078 r
.92888 .494 .92974 .4934 .93089 .49372 .93004 .4943 Mtetra
.704 .319 .317 r
.93004 .4943 .93089 .49372 .93217 .4953 .93131 .49583 Mtetra
.768 .411 .38 r
.93131 .49583 .93217 .4953 .93355 .49788 .93268 .49833 Mtetra
.795 .448 .399 r
.93268 .49833 .93355 .49788 .93499 .5011 .93411 .50145 Mtetra
.807 .46 .4 r
.93411 .50145 .93499 .5011 .93646 .50457 .93557 .50481 Mtetra
.813 .459 .386 r
.93557 .50481 .93646 .50457 .93793 .50793 .93703 .50807 Mtetra
.813 .444 .359 r
.93703 .50807 .93793 .50793 .93936 .51096 .93845 .511 Mtetra
.805 .414 .313 r
.93845 .511 .93936 .51096 .94075 .5135 .93983 .51346 Mtetra
.786 .359 .237 r
.93983 .51346 .94075 .5135 .94208 .51549 .94116 .51538 Mtetra
.737 .257 .104 r
.94116 .51538 .94208 .51549 .94336 .51691 .94243 .51675 Mtetra
.607 .051 0 r
.94243 .51675 .94336 .51691 .94459 .51778 .94366 .51759 Mtetra
.244 0 0 r
.94366 .51759 .94459 .51778 .94577 .51812 .94483 .51792 Mtetra
.346 .776 .971 r
.94483 .51792 .94577 .51812 .94689 .51795 .94596 .51775 Mtetra
.679 .866 .97 r
.94596 .51775 .94689 .51795 .94797 .51726 .94703 .51708 Mtetra
.799 .841 .883 r
.94703 .51708 .94797 .51726 .94899 .51605 .94806 .5159 Mtetra
.848 .808 .811 r
.94806 .5159 .94899 .51605 .94995 .51429 .94903 .51418 Mtetra
.873 .783 .759 r
.94903 .51418 .94995 .51429 .95086 .51196 .94994 .51192 Mtetra
.888 .765 .721 r
.94994 .51192 .95086 .51196 .95171 .50907 .9508 .5091 Mtetra
.898 .755 .694 r
.9508 .5091 .95171 .50907 .95251 .50566 .95161 .50579 Mtetra
.907 .752 .677 r
.95161 .50579 .95251 .50566 .95327 .50188 .95238 .50212 Mtetra
.916 .758 .67 r
.95238 .50212 .95327 .50188 .95401 .49795 .95314 .4983 Mtetra
.928 .776 .673 r
.95314 .4983 .95401 .49795 .95477 .49421 .95391 .49466 Mtetra
.942 .818 .693 r
.95391 .49466 .95477 .49421 .95559 .49104 .95474 .49158 Mtetra
.949 .913 .746 r
.95474 .49158 .95559 .49104 .95651 .48883 .95567 .48943 Mtetra
.588 .914 .675 r
.95567 .48943 .95651 .48883 .95756 .48786 .95672 .48849 Mtetra
.488 .038 .108 r
.95672 .48849 .95756 .48786 .95875 .48826 .95791 .48887 Mtetra
.708 .323 .318 r
.95791 .48887 .95875 .48826 .96008 .48993 .95923 .49048 Mtetra
.769 .411 .377 r
.95923 .49048 .96008 .48993 .96151 .49259 .96065 .49306 Mtetra
.795 .445 .394 r
.96065 .49306 .96151 .49259 .96301 .49588 .96214 .49624 Mtetra
.807 .457 .393 r
.96214 .49624 .96301 .49588 .96454 .4994 .96366 .49965 Mtetra
.813 .455 .379 r
.96366 .49965 .96454 .4994 .96606 .5028 .96516 .50295 Mtetra
.812 .439 .351 r
.96516 .50295 .96606 .5028 .96754 .50585 .96664 .5059 Mtetra
.804 .408 .304 r
.96664 .5059 .96754 .50585 .96898 .5084 .96806 .50837 Mtetra
.782 .351 .226 r
.96806 .50837 .96898 .5084 .97036 .51039 .96943 .5103 Mtetra
.731 .246 .09 r
.96943 .5103 .97036 .51039 .97167 .51181 .97075 .51167 Mtetra
.596 .036 0 r
.97075 .51167 .97167 .51181 .97293 .51267 .972 .5125 Mtetra
.232 0 0 r
.972 .5125 .97293 .51267 .97414 .513 .97321 .51282 Mtetra
.349 .781 .969 r
.97321 .51282 .97414 .513 .97529 .51282 .97436 .51263 Mtetra
.682 .874 .971 r
.97436 .51263 .97529 .51282 .97639 .51211 .97546 .51194 Mtetra
.804 .849 .884 r
.97546 .51194 .97639 .51211 .97743 .51087 .9765 .51073 Mtetra
.853 .815 .811 r
.9765 .51073 .97743 .51087 .97841 .50907 .97749 .50898 Mtetra
.878 .789 .758 r
.97749 .50898 .97841 .50907 .97933 .50669 .97841 .50667 Mtetra
.893 .771 .719 r
.97841 .50667 .97933 .50669 .98018 .50375 .97928 .50381 Mtetra
.904 .76 .692 r
.97928 .50381 .98018 .50375 .98098 .5003 .98009 .50045 Mtetra
.913 .757 .675 r
.98009 .50045 .98098 .5003 .98174 .49647 .98086 .49673 Mtetra
.922 .764 .667 r
.98086 .49673 .98174 .49647 .98248 .49251 .98162 .49288 Mtetra
.934 .784 .671 r
.98162 .49288 .98248 .49251 .98325 .48875 .98239 .48923 Mtetra
.948 .829 .692 r
.98239 .48923 .98325 .48875 .98408 .4856 .98323 .48616 Mtetra
.95 .929 .745 r
.98323 .48616 .98408 .4856 .98502 .48343 .98418 .48405 Mtetra
.488 .85 .605 r
.98418 .48405 .98502 .48343 .9861 .48253 .98526 .48318 Mtetra
.368 .648 .964 r
.52126 .68695 .52218 .68749 .52295 .68748 .52203 .68694 Mtetra
.798 .319 .08 r
.52203 .68694 .52295 .68748 .52372 .68853 .5228 .68799 Mtetra
.854 .485 .35 r
.5228 .68799 .52372 .68853 .52451 .69042 .52358 .68988 Mtetra
.857 .519 .412 r
.52358 .68988 .52451 .69042 .52529 .69281 .52437 .69227 Mtetra
.857 .527 .427 r
.52437 .69227 .52529 .69281 .52609 .69538 .52516 .69484 Mtetra
.857 .522 .417 r
.52516 .69484 .52609 .69538 .52688 .69783 .52595 .6973 Mtetra
.856 .504 .385 r
.52595 .6973 .52688 .69783 .52767 .69998 .52675 .69945 Mtetra
.85 .465 .319 r
.52675 .69945 .52767 .69998 .52846 .7017 .52753 .70117 Mtetra
.824 .379 .177 r
.52753 .70117 .52846 .7017 .52924 .70294 .52832 .70241 Mtetra
.687 .142 0 r
.52832 .70241 .52924 .70294 .53003 .7037 .5291 .70317 Mtetra
0 .417 .818 r
.5291 .70317 .53003 .7037 .53081 .704 .52988 .70347 Mtetra
.49 .69 .956 r
.52988 .70347 .53081 .704 .53158 .70384 .53066 .70331 Mtetra
.671 .707 .875 r
.53066 .70331 .53158 .70384 .53236 .70325 .53143 .70272 Mtetra
.737 .695 .811 r
.53143 .70272 .53236 .70325 .53313 .70222 .5322 .70169 Mtetra
.769 .682 .767 r
.5322 .70169 .53313 .70222 .53389 .70074 .53297 .70021 Mtetra
.787 .671 .737 r
.53297 .70021 .53389 .70074 .53466 .69879 .53373 .69826 Mtetra
.798 .663 .714 r
.53373 .69826 .53466 .69879 .53541 .69636 .53449 .69582 Mtetra
.805 .657 .698 r
.53449 .69582 .53541 .69636 .53617 .69345 .53524 .69291 Mtetra
.81 .652 .687 r
.53524 .69291 .53617 .69345 .53691 .69011 .53599 .68957 Mtetra
.812 .649 .681 r
.53599 .68957 .53691 .69011 .53766 .68647 .53673 .68592 Mtetra
.813 .648 .679 r
.53673 .68592 .53766 .68647 .5384 .68273 .53748 .68218 Mtetra
.811 .65 .682 r
.53748 .68218 .5384 .68273 .53915 .67918 .53822 .67863 Mtetra
.806 .654 .695 r
.53822 .67863 .53915 .67918 .5399 .67615 .53897 .67559 Mtetra
.791 .665 .724 r
.53897 .67559 .5399 .67615 .54065 .67397 .53973 .67341 Mtetra
.74 .687 .8 r
.53973 .67341 .54065 .67397 .54142 .67287 .5405 .6723 Mtetra
.306 .618 .958 r
.5405 .6723 .54142 .67287 .54221 .67292 .54128 .67236 Mtetra
.805 .329 .086 r
.54128 .67236 .54221 .67292 .543 .67403 .54208 .67347 Mtetra
.857 .485 .343 r
.54208 .67347 .543 .67403 .54381 .67596 .54288 .6754 Mtetra
.86 .518 .404 r
.54288 .6754 .54381 .67596 .54462 .67839 .5437 .67783 Mtetra
.86 .525 .418 r
.5437 .67783 .54462 .67839 .54544 .68097 .54451 .68041 Mtetra
.86 .52 .407 r
.54451 .68041 .54544 .68097 .54625 .68343 .54533 .68287 Mtetra
.858 .5 .373 r
.54533 .68287 .54625 .68343 .54707 .68557 .54614 .68502 Mtetra
.851 .459 .3 r
.54614 .68502 .54707 .68557 .54788 .68728 .54695 .68673 Mtetra
.821 .365 .146 r
.54695 .68673 .54788 .68728 .54868 .68851 .54776 .68796 Mtetra
.66 .106 0 r
.54776 .68796 .54868 .68851 .54948 .68926 .54856 .6887 Mtetra
0 .447 .85 r
.54856 .6887 .54948 .68926 .55028 .68953 .54935 .68898 Mtetra
.501 .686 .95 r
.54935 .68898 .55028 .68953 .55107 .68936 .55014 .68881 Mtetra
.671 .703 .871 r
.55014 .68881 .55107 .68936 .55186 .68875 .55093 .6882 Mtetra
.736 .692 .809 r
.55093 .6882 .55186 .68875 .55264 .6877 .55171 .68715 Mtetra
.768 .68 .766 r
.55171 .68715 .55264 .6877 .55341 .6862 .55248 .68564 Mtetra
.786 .67 .736 r
.55248 .68564 .55341 .6862 .55418 .68422 .55325 .68366 Mtetra
.798 .662 .714 r
.55325 .68366 .55418 .68422 .55494 .68176 .55401 .6812 Mtetra
.805 .656 .698 r
.55401 .6812 .55494 .68176 .55569 .67882 .55477 .67825 Mtetra
.81 .652 .687 r
.55477 .67825 .55569 .67882 .55644 .67545 .55551 .67489 Mtetra
.813 .649 .68 r
.55551 .67489 .55644 .67545 .55718 .67179 .55626 .67122 Mtetra
.813 .648 .678 r
.55626 .67122 .55718 .67179 .55793 .66805 .557 .66747 Mtetra
.811 .65 .682 r
.557 .66747 .55793 .66805 .55867 .6645 .55774 .66392 Mtetra
.805 .654 .696 r
.55774 .66392 .55867 .6645 .55942 .6615 .5585 .66092 Mtetra
.789 .665 .727 r
.5585 .66092 .55942 .6615 .56019 .65937 .55926 .65878 Mtetra
.732 .687 .807 r
.55926 .65878 .56019 .65937 .56097 .65832 .56004 .65773 Mtetra
.239 .582 .945 r
.56004 .65773 .56097 .65832 .56176 .65844 .56084 .65785 Mtetra
.811 .338 .09 r
.56084 .65785 .56176 .65844 .56258 .65961 .56165 .65902 Mtetra
.86 .485 .337 r
.56165 .65902 .56258 .65961 .56341 .66159 .56248 .66101 Mtetra
.863 .517 .396 r
.56248 .66101 .56341 .66159 .56425 .66405 .56332 .66346 Mtetra
.863 .524 .409 r
.56332 .66346 .56425 .66405 .56509 .66665 .56416 .66607 Mtetra
.862 .517 .397 r
.56416 .66607 .56509 .66665 .56593 .66912 .565 .66854 Mtetra
.861 .497 .359 r
.565 .66854 .56593 .66912 .56677 .67126 .56584 .67068 Mtetra
.853 .452 .281 r
.56584 .67068 .56677 .67126 .5676 .67296 .56667 .67238 Mtetra
.816 .35 .113 r
.56667 .67238 .5676 .67296 .56843 .67418 .5675 .6736 Mtetra
.629 .071 0 r
.5675 .6736 .56843 .67418 .56925 .67491 .56832 .67433 Mtetra
.017 .47 .874 r
.56832 .67433 .56925 .67491 .57006 .67517 .56913 .6746 Mtetra
.509 .682 .944 r
.56913 .6746 .57006 .67517 .57086 .67499 .56993 .67441 Mtetra
.671 .699 .867 r
.56993 .67441 .57086 .67499 .57166 .67436 .57073 .67378 Mtetra
.735 .689 .807 r
.57073 .67378 .57166 .67436 .57245 .67329 .57152 .67271 Mtetra
.767 .678 .765 r
.57152 .67271 .57245 .67329 .57323 .67177 .5723 .67119 Mtetra
.786 .669 .735 r
.5723 .67119 .57323 .67177 .574 .66977 .57307 .66918 Mtetra
.797 .662 .713 r
.57307 .66918 .574 .66977 .57477 .66728 .57384 .66669 Mtetra
.805 .656 .697 r
.57384 .66669 .57477 .66728 .57553 .66431 .5746 .66372 Mtetra
.81 .652 .686 r
.5746 .66372 .57553 .66431 .57627 .66092 .57534 .66033 Mtetra
.813 .649 .68 r
.57534 .66033 .57627 .66092 .57702 .65724 .57609 .65664 Mtetra
.813 .648 .678 r
.57609 .65664 .57702 .65724 .57776 .65349 .57683 .65289 Mtetra
.811 .65 .683 r
.57683 .65289 .57776 .65349 .5785 .64996 .57757 .64935 Mtetra
.804 .655 .697 r
.57757 .64935 .5785 .64996 .57925 .64699 .57833 .64638 Mtetra
.786 .665 .73 r
.57833 .64638 .57925 .64699 .58002 .6449 .5791 .64429 Mtetra
.722 .686 .814 r
.5791 .64429 .58002 .6449 .58082 .64392 .57989 .64331 Mtetra
.164 .54 .925 r
.57989 .64331 .58082 .64392 .58163 .64411 .5807 .64349 Mtetra
.817 .347 .095 r
.5807 .64349 .58163 .64411 .58247 .64534 .58154 .64473 Mtetra
.863 .485 .33 r
.58154 .64473 .58247 .64534 .58332 .64737 .58239 .64676 Mtetra
.866 .517 .388 r
.58239 .64676 .58332 .64737 .58419 .64987 .58326 .64926 Mtetra
.866 .523 .4 r
.58326 .64926 .58419 .64987 .58506 .65249 .58413 .65189 Mtetra
.865 .515 .386 r
.58413 .65189 .58506 .65249 .58593 .65497 .58499 .65436 Mtetra
.863 .493 .345 r
.58499 .65436 .58593 .65497 .58679 .65711 .58586 .65651 Mtetra
.854 .445 .261 r
.58586 .65651 .58679 .65711 .58764 .65881 .58671 .65821 Mtetra
.811 .335 .08 r
.58671 .65821 .58764 .65881 .58849 .66002 .58756 .65942 Mtetra
.597 .036 0 r
.58756 .65942 .58849 .66002 .58933 .66074 .58839 .66014 Mtetra
.057 .487 .89 r
.58839 .66014 .58933 .66074 .59015 .661 .58922 .6604 Mtetra
.514 .677 .939 r
.58922 .6604 .59015 .661 .59097 .6608 .59004 .6602 Mtetra
.67 .694 .864 r
.59004 .6602 .59097 .6608 .59178 .66016 .59085 .65956 Mtetra
.733 .687 .806 r
.59085 .65956 .59178 .66016 .59258 .65907 .59165 .65847 Mtetra
.766 .677 .764 r
.59165 .65847 .59258 .65907 .59337 .65753 .59244 .65692 Mtetra
.785 .668 .735 r
.59244 .65692 .59337 .65753 .59415 .65551 .59322 .6549 Mtetra
.797 .661 .713 r
.59322 .6549 .59415 .65551 .59492 .65299 .59399 .65238 Mtetra
.805 .655 .697 r
.59399 .65238 .59492 .65299 .59568 .65 .59474 .64939 Mtetra
.81 .651 .686 r
.59474 .64939 .59568 .65 .59643 .64659 .59549 .64597 Mtetra
.813 .649 .679 r
.59549 .64597 .59643 .64659 .59717 .6429 .59623 .64227 Mtetra
.813 .648 .678 r
.59623 .64227 .59717 .6429 .59791 .63914 .59697 .63852 Mtetra
.811 .65 .683 r
.59697 .63852 .59791 .63914 .59865 .63563 .59772 .635 Mtetra
.803 .655 .698 r
.59772 .635 .59865 .63563 .59941 .6327 .59848 .63206 Mtetra
.783 .665 .733 r
.59848 .63206 .59941 .6327 .60019 .63066 .59925 .63003 Mtetra
.711 .684 .822 r
.59925 .63003 .60019 .63066 .60099 .62975 .60006 .62911 Mtetra
.083 .49 .897 r
.60006 .62911 .60099 .62975 .60182 .63 .60089 .62937 Mtetra
.823 .355 .099 r
.60089 .62937 .60182 .63 .60268 .63131 .60175 .63067 Mtetra
.866 .486 .323 r
.60175 .63067 .60268 .63131 .60356 .63339 .60263 .63276 Mtetra
.869 .516 .38 r
.60263 .63276 .60356 .63339 .60446 .63593 .60352 .6353 Mtetra
.869 .521 .391 r
.60352 .6353 .60446 .63593 .60535 .63858 .60442 .63795 Mtetra
.868 .513 .375 r
.60442 .63795 .60535 .63858 .60625 .64107 .60531 .64044 Mtetra
.866 .489 .331 r
.60531 .64044 .60625 .64107 .60714 .64322 .6062 .64259 Mtetra
.854 .438 .24 r
.6062 .64259 .60714 .64322 .60801 .64491 .60708 .64429 Mtetra
.804 .319 .046 r
.60708 .64429 .60801 .64491 .60888 .64612 .60794 .64549 Mtetra
.565 .004 0 r
.60794 .64549 .60888 .64612 .60974 .64684 .6088 .64621 Mtetra
.089 .498 .9 r
.6088 .64621 .60974 .64684 .61058 .64709 .60964 .64646 Mtetra
.517 .672 .934 r
.60964 .64646 .61058 .64709 .61141 .64688 .61048 .64625 Mtetra
.668 .69 .862 r
.61048 .64625 .61141 .64688 .61224 .64623 .6113 .6456 Mtetra
.731 .684 .805 r
.6113 .6456 .61224 .64623 .61305 .64513 .61211 .6445 Mtetra
.765 .675 .764 r
.61211 .6445 .61305 .64513 .61385 .64357 .61291 .64294 Mtetra
.784 .667 .734 r
.61291 .64294 .61385 .64357 .61463 .64153 .61369 .6409 Mtetra
.797 .66 .712 r
.61369 .6409 .61463 .64153 .6154 .639 .61447 .63836 Mtetra
.805 .655 .696 r
.61447 .63836 .6154 .639 .61616 .63598 .61523 .63534 Mtetra
.81 .651 .685 r
.61523 .63534 .61616 .63598 .61691 .63255 .61598 .63191 Mtetra
.813 .649 .679 r
.61598 .63191 .61691 .63255 .61765 .62885 .61672 .6282 Mtetra
.813 .648 .678 r
.61672 .6282 .61765 .62885 .61839 .6251 .61746 .62445 Mtetra
.811 .65 .683 r
.61746 .62445 .61839 .6251 .61914 .6216 .6182 .62095 Mtetra
.802 .655 .7 r
.6182 .62095 .61914 .6216 .6199 .61871 .61896 .61805 Mtetra
.78 .665 .737 r
.61896 .61805 .6199 .61871 .62068 .61674 .61975 .61608 Mtetra
.698 .682 .831 r
.61975 .61608 .62068 .61674 .6215 .61589 .62057 .61523 Mtetra
0 .433 .86 r
.62057 .61523 .6215 .61589 .62235 .61623 .62142 .61556 Mtetra
.828 .363 .103 r
.62142 .61556 .62235 .61623 .62324 .6176 .6223 .61694 Mtetra
.869 .486 .316 r
.6223 .61694 .62324 .6176 .62415 .61975 .62321 .61909 Mtetra
.871 .515 .371 r
.62321 .61909 .62415 .61975 .62507 .62233 .62413 .62167 Mtetra
.872 .52 .381 r
.62413 .62167 .62507 .62233 .62599 .62501 .62506 .62435 Mtetra
.871 .51 .363 r
.62506 .62435 .62599 .62501 .62692 .62751 .62598 .62686 Mtetra
.868 .485 .316 r
.62598 .62686 .62692 .62751 .62783 .62967 .62689 .62902 Mtetra
.854 .431 .22 r
.62689 .62902 .62783 .62967 .62873 .63137 .62779 .63072 Mtetra
.796 .304 .014 r
.62779 .63072 .62873 .63137 .62962 .63258 .62868 .63193 Mtetra
.534 0 0 r
.62868 .63193 .62962 .63258 .6305 .6333 .62956 .63265 Mtetra
.112 .504 .906 r
.62956 .63265 .6305 .6333 .63136 .63354 .63042 .63289 Mtetra
.517 .667 .93 r
.63042 .63289 .63136 .63354 .63221 .63333 .63127 .63268 Mtetra
.665 .687 .86 r
.63127 .63268 .63221 .63333 .63304 .63268 .6321 .63202 Mtetra
.729 .682 .804 r
.6321 .63202 .63304 .63268 .63386 .63157 .63292 .63092 Mtetra
.763 .674 .764 r
.63292 .63092 .63386 .63157 .63467 .63 .63373 .62934 Mtetra
.783 .666 .734 r
.63373 .62934 .63467 .63 .63546 .62794 .63452 .62729 Mtetra
.797 .66 .712 r
.63452 .62729 .63546 .62794 .63624 .62539 .6353 .62473 Mtetra
.805 .655 .696 r
.6353 .62473 .63624 .62539 .637 .62236 .63606 .62169 Mtetra
.811 .651 .685 r
.63606 .62169 .637 .62236 .63775 .61891 .63681 .61824 Mtetra
.813 .649 .679 r
.63681 .61824 .63775 .61891 .63849 .6152 .63755 .61453 Mtetra
.814 .649 .678 r
.63755 .61453 .63849 .6152 .63923 .61145 .63829 .61078 Mtetra
.81 .65 .684 r
.63829 .61078 .63923 .61145 .63998 .60798 .63904 .6073 Mtetra
.801 .655 .701 r
.63904 .6073 .63998 .60798 .64074 .60514 .6398 .60445 Mtetra
.776 .666 .741 r
.6398 .60445 .64074 .60514 .64154 .60323 .6406 .60254 Mtetra
.682 .68 .841 r
.6406 .60254 .64154 .60323 .64237 .60246 .64143 .60178 Mtetra
0 .369 .813 r
.64143 .60178 .64237 .60246 .64324 .60287 .64231 .60219 Mtetra
.833 .372 .108 r
.64231 .60219 .64324 .60287 .64415 .60432 .64321 .60364 Mtetra
.871 .486 .31 r
.64321 .60364 .64415 .60432 .64509 .60653 .64415 .60585 Mtetra
.874 .514 .363 r
.64415 .60585 .64509 .60653 .64604 .60916 .6451 .60848 Mtetra
.874 .518 .371 r
.6451 .60848 .64604 .60916 .647 .61187 .64606 .6112 Mtetra
.873 .508 .352 r
.64606 .6112 .647 .61187 .64795 .61441 .64701 .61373 Mtetra
.87 .481 .302 r
.64701 .61373 .64795 .61441 .64889 .61658 .64795 .6159 Mtetra
.854 .424 .199 r
.64795 .6159 .64889 .61658 .64982 .61828 .64888 .61761 Mtetra
.788 .29 0 r
.64888 .61761 .64982 .61828 .65073 .6195 .64979 .61882 Mtetra
.506 0 0 r
.64979 .61882 .65073 .6195 .65163 .62022 .65068 .61955 Mtetra
.127 .506 .909 r
.65068 .61955 .65163 .62022 .65251 .62047 .65156 .61979 Mtetra
.515 .662 .927 r
.65156 .61979 .65251 .62047 .65337 .62026 .65243 .61958 Mtetra
.662 .683 .86 r
.65243 .61958 .65337 .62026 .65422 .6196 .65328 .61892 Mtetra
.727 .68 .804 r
.65328 .61892 .65422 .6196 .65505 .61849 .65411 .61781 Mtetra
.762 .673 .764 r
.65411 .61781 .65505 .61849 .65587 .61691 .65493 .61623 Mtetra
.783 .666 .734 r
.65493 .61623 .65587 .61691 .65667 .61484 .65573 .61416 Mtetra
.796 .66 .712 r
.65573 .61416 .65667 .61484 .65745 .61228 .65651 .61159 Mtetra
.805 .655 .696 r
.65651 .61159 .65745 .61228 .65822 .60923 .65727 .60854 Mtetra
.811 .651 .685 r
.65727 .60854 .65822 .60923 .65897 .60577 .65802 .60508 Mtetra
.814 .649 .679 r
.65802 .60508 .65897 .60577 .65971 .60205 .65876 .60136 Mtetra
.814 .649 .678 r
.65876 .60136 .65971 .60205 .66044 .59832 .6595 .59762 Mtetra
.81 .651 .685 r
.6595 .59762 .66044 .59832 .66119 .59487 .66025 .59417 Mtetra
.8 .656 .703 r
.66025 .59417 .66119 .59487 .66196 .59208 .66102 .59137 Mtetra
.772 .666 .746 r
.66102 .59137 .66196 .59208 .66277 .59024 .66183 .58953 Mtetra
.664 .677 .852 r
.66183 .58953 .66277 .59024 .66362 .58955 .66268 .58884 Mtetra
0 .301 .757 r
.66268 .58884 .66362 .58955 .66452 .59005 .66357 .58934 Mtetra
.838 .38 .114 r
.66357 .58934 .66452 .59005 .66545 .59158 .66451 .59087 Mtetra
.873 .487 .304 r
.66451 .59087 .66545 .59158 .66642 .59386 .66547 .59315 Mtetra
.877 .513 .355 r
.66547 .59315 .66642 .59386 .6674 .59654 .66646 .59584 Mtetra
.877 .516 .362 r
.66646 .59584 .6674 .59654 .66839 .59929 .66745 .59859 Mtetra
.876 .505 .341 r
.66745 .59859 .66839 .59929 .66937 .60185 .66843 .60115 Mtetra
.871 .477 .287 r
.66843 .60115 .66937 .60185 .67034 .60404 .6694 .60334 Mtetra
.853 .417 .18 r
.6694 .60334 .67034 .60404 .6713 .60576 .67035 .60506 Mtetra
.78 .276 0 r
.67035 .60506 .6713 .60576 .67223 .60698 .67128 .60629 Mtetra
.483 0 0 r
.67128 .60629 .67223 .60698 .67315 .60771 .6722 .60702 Mtetra
.135 .505 .91 r
.6722 .60702 .67315 .60771 .67405 .60797 .6731 .60727 Mtetra
.511 .657 .925 r
.6731 .60727 .67405 .60797 .67493 .60776 .67398 .60707 Mtetra
.658 .68 .86 r
.67398 .60707 .67493 .60776 .67579 .60711 .67484 .60641 Mtetra
.724 .679 .805 r
.67484 .60641 .67579 .60711 .67664 .60599 .67569 .6053 Mtetra
.76 .672 .765 r
.67569 .6053 .67664 .60599 .67747 .60441 .67652 .60371 Mtetra
.782 .665 .735 r
.67652 .60371 .67747 .60441 .67827 .60233 .67733 .60163 Mtetra
.796 .66 .712 r
.67733 .60163 .67827 .60233 .67906 .59976 .67811 .59905 Mtetra
.805 .655 .696 r
.67811 .59905 .67906 .59976 .67983 .59669 .67888 .59599 Mtetra
.811 .651 .685 r
.67888 .59599 .67983 .59669 .68058 .59323 .67963 .59252 Mtetra
.814 .65 .679 r
.67963 .59252 .68058 .59323 .68132 .58951 .68037 .5888 Mtetra
.814 .649 .678 r
.68037 .5888 .68132 .58951 .68205 .58579 .68111 .58507 Mtetra
.81 .651 .686 r
.68111 .58507 .68205 .58579 .68281 .58238 .68186 .58166 Mtetra
.799 .656 .706 r
.68186 .58166 .68281 .58238 .68358 .57964 .68264 .57891 Mtetra
.767 .667 .751 r
.68264 .57891 .68358 .57964 .6844 .57787 .68346 .57714 Mtetra
.643 .673 .864 r
.68346 .57714 .6844 .57787 .68527 .57727 .68432 .57654 Mtetra
0 .229 .692 r
.68432 .57654 .68527 .57727 .68619 .57786 .68524 .57713 Mtetra
.843 .387 .12 r
.68524 .57713 .68619 .57786 .68716 .57947 .68621 .57874 Mtetra
.875 .487 .298 r
.68621 .57874 .68716 .57947 .68816 .58182 .68721 .5811 Mtetra
.879 .512 .347 r
.68721 .5811 .68816 .58182 .68917 .58456 .68822 .58384 Mtetra
.879 .515 .353 r
.68822 .58384 .68917 .58456 .6902 .58736 .68925 .58664 Mtetra
.877 .503 .33 r
.68925 .58664 .6902 .58736 .69121 .58995 .69026 .58923 Mtetra
.872 .473 .274 r
.69026 .58923 .69121 .58995 .69221 .59216 .69126 .59144 Mtetra
.852 .41 .162 r
.69126 .59144 .69221 .59216 .69319 .5939 .69224 .59318 Mtetra
.773 .264 0 r
.69224 .59318 .69319 .5939 .69415 .59514 .6932 .59442 Mtetra
.466 0 0 r
.6932 .59442 .69415 .59514 .69509 .59588 .69414 .59516 Mtetra
.137 .502 .908 r
.69414 .59516 .69509 .59588 .69601 .59614 .69506 .59543 Mtetra
.506 .653 .924 r
.69506 .59543 .69601 .59614 .69691 .59594 .69596 .59523 Mtetra
.654 .678 .861 r
.69596 .59523 .69691 .59594 .69779 .59529 .69684 .59458 Mtetra
.722 .678 .807 r
.69684 .59458 .69779 .59529 .69865 .59418 .69769 .59347 Mtetra
.759 .672 .766 r
.69769 .59347 .69865 .59418 .69949 .5926 .69853 .59188 Mtetra
.782 .666 .735 r
.69853 .59188 .69949 .5926 .7003 .59051 .69935 .58979 Mtetra
.796 .66 .713 r
.69935 .58979 .7003 .59051 .70109 .58793 .70014 .5872 Mtetra
.806 .655 .696 r
.70014 .5872 .70109 .58793 .70186 .58485 .70091 .58413 Mtetra
.812 .652 .685 r
.70091 .58413 .70186 .58485 .70261 .58138 .70166 .58065 Mtetra
.815 .65 .679 r
.70166 .58065 .70261 .58138 .70335 .57767 .7024 .57693 Mtetra
.814 .65 .679 r
.7024 .57693 .70335 .57767 .70409 .57396 .70314 .57322 Mtetra
.81 .652 .687 r
.70314 .57322 .70409 .57396 .70485 .57058 .7039 .56985 Mtetra
.797 .658 .708 r
.7039 .56985 .70485 .57058 .70563 .5679 .70468 .56716 Mtetra
.763 .668 .758 r
.70468 .56716 .70563 .5679 .70646 .56621 .70551 .56547 Mtetra
.618 .668 .876 r
.70551 .56547 .70646 .56621 .70735 .5657 .7064 .56496 Mtetra
0 .157 .621 r
.7064 .56496 .70735 .5657 .7083 .56638 .70735 .56564 Mtetra
.847 .395 .127 r
.70735 .56564 .7083 .56638 .7093 .56808 .70834 .56734 Mtetra
.877 .487 .293 r
.70834 .56734 .7093 .56808 .71033 .57051 .70938 .56977 Mtetra
.88 .511 .34 r
.70938 .56977 .71033 .57051 .71138 .57331 .71043 .57258 Mtetra
.88 .513 .344 r
.71043 .57258 .71138 .57331 .71244 .57616 .71149 .57542 Mtetra
.879 .5 .319 r
.71149 .57542 .71244 .57616 .71349 .57878 .71253 .57805 Mtetra
.872 .469 .261 r
.71253 .57805 .71349 .57878 .71452 .58102 .71356 .58029 Mtetra
.85 .403 .145 r
.71356 .58029 .71452 .58102 .71553 .58278 .71457 .58205 Mtetra
.765 .254 0 r
.71457 .58205 .71553 .58278 .71651 .58404 .71556 .58331 Mtetra
.453 0 0 r
.71556 .58331 .71651 .58404 .71748 .58479 .71652 .58406 Mtetra
.134 .498 .906 r
.71652 .58406 .71748 .58479 .71842 .58507 .71746 .58434 Mtetra
.499 .649 .925 r
.71746 .58434 .71842 .58507 .71933 .58488 .71838 .58415 Mtetra
.65 .677 .863 r
.71838 .58415 .71933 .58488 .72023 .58424 .71927 .58351 Mtetra
.72 .678 .809 r
.71927 .58351 .72023 .58424 .7211 .58313 .72015 .5824 Mtetra
.758 .673 .767 r
.72015 .5824 .7211 .58313 .72195 .58154 .721 .58081 Mtetra
.782 .666 .736 r
.721 .58081 .72195 .58154 .72278 .57946 .72182 .57872 Mtetra
.797 .661 .713 r
.72182 .57872 .72278 .57946 .72358 .57686 .72262 .57613 Mtetra
.807 .656 .696 r
.72262 .57613 .72358 .57686 .72435 .57378 .72339 .57304 Mtetra
.813 .653 .685 r
.72339 .57304 .72435 .57378 .7251 .5703 .72415 .56956 Mtetra
.815 .651 .679 r
.72415 .56956 .7251 .5703 .72584 .56659 .72489 .56584 Mtetra
.72489 .56584 .72584 .56659 .72658 .5629 .72563 .56215 Mtetra
.81 .653 .688 r
.72563 .56215 .72658 .5629 .72734 .55956 .72639 .55881 Mtetra
.796 .659 .711 r
.72639 .55881 .72734 .55956 .72814 .55694 .72718 .55618 Mtetra
.757 .669 .765 r
.72718 .55618 .72814 .55694 .72898 .55533 .72803 .55457 Mtetra
.588 .663 .89 r
.72803 .55457 .72898 .55533 .72989 .55491 .72894 .55415 Mtetra
.447 0 0 r
.72894 .55415 .72989 .55491 .73087 .55569 .72991 .55493 Mtetra
.851 .401 .135 r
.72991 .55493 .73087 .55569 .7319 .55748 .73094 .55673 Mtetra
.878 .487 .289 r
.73094 .55673 .7319 .55748 .73297 .55999 .73201 .55924 Mtetra
.882 .509 .333 r
.73201 .55924 .73297 .55999 .73406 .56286 .7331 .56211 Mtetra
.881 .51 .335 r
.7331 .56211 .73406 .56286 .73515 .56575 .73419 .56501 Mtetra
.879 .496 .309 r
.73419 .56501 .73515 .56575 .73623 .56841 .73528 .56767 Mtetra
.872 .464 .249 r
.73528 .56767 .73623 .56841 .7373 .57068 .73634 .56994 Mtetra
.848 .396 .13 r
.73634 .56994 .7373 .57068 .73834 .57246 .73738 .57173 Mtetra
.758 .244 0 r
.73738 .57173 .73834 .57246 .73935 .57374 .73839 .573 Mtetra
.446 0 0 r
.73839 .573 .73935 .57374 .74034 .57451 .73938 .57377 Mtetra
.127 .493 .904 r
.73938 .57377 .74034 .57451 .7413 .5748 .74034 .57406 Mtetra
.491 .646 .926 r
.74034 .57406 .7413 .5748 .74224 .57463 .74128 .57389 Mtetra
.645 .677 .866 r
.74128 .57389 .74224 .57463 .74315 .57399 .74219 .57325 Mtetra
.718 .679 .811 r
.74219 .57325 .74315 .57399 .74404 .57289 .74308 .57215 Mtetra
.758 .674 .769 r
.74308 .57215 .74404 .57289 .7449 .5713 .74394 .57056 Mtetra
.782 .668 .737 r
.74394 .57056 .7449 .5713 .74573 .56921 .74477 .56847 Mtetra
.797 .662 .714 r
.74477 .56847 .74573 .56921 .74654 .5666 .74558 .56586 Mtetra
.808 .658 .696 r
.74558 .56586 .74654 .5666 .74732 .56351 .74636 .56277 Mtetra
.814 .654 .685 r
.74636 .56277 .74732 .56351 .74807 .56003 .74711 .55928 Mtetra
.817 .653 .679 r
.74711 .55928 .74807 .56003 .74881 .55632 .74785 .55556 Mtetra
.816 .653 .68 r
.74785 .55556 .74881 .55632 .74955 .55264 .7486 .55189 Mtetra
.811 .655 .69 r
.7486 .55189 .74955 .55264 .75032 .54935 .74936 .54859 Mtetra
.795 .661 .715 r
.74936 .54859 .75032 .54935 .75112 .54678 .75016 .54602 Mtetra
.752 .672 .772 r
.75016 .54602 .75112 .54678 .75199 .54525 .75103 .54449 Mtetra
.554 .657 .904 r
.75103 .54449 .75199 .54525 .75292 .54493 .75196 .54417 Mtetra
.517 0 0 r
.75196 .54417 .75292 .54493 .75393 .5458 .75297 .54504 Mtetra
.854 .407 .142 r
.75297 .54504 .75393 .5458 .75499 .54769 .75403 .54693 Mtetra
.879 .486 .285 r
.75403 .54693 .75499 .54769 .7561 .55028 .75514 .54953 Mtetra
.882 .507 .326 r
.75514 .54953 .7561 .55028 .75723 .55322 .75627 .55246 Mtetra
.882 .508 .327 r
.75627 .55246 .75723 .55322 .75836 .55616 .7574 .55541 Mtetra
.88 .493 .299 r
.7574 .55541 .75836 .55616 .75948 .55887 .75852 .55812 Mtetra
.872 .459 .237 r
.75852 .55812 .75948 .55887 .76058 .56116 .75962 .56042 Mtetra
.845 .389 .116 r
.75962 .56042 .76058 .56116 .76165 .56297 .76069 .56223 Mtetra
.752 .236 0 r
.76069 .56223 .76165 .56297 .76269 .56426 .76173 .56352 Mtetra
.441 0 0 r
.76173 .56352 .76269 .56426 .76371 .56505 .76274 .56431 Mtetra
.119 .488 .902 r
.76274 .56431 .76371 .56505 .76469 .56536 .76373 .56462 Mtetra
.484 .645 .929 r
.76373 .56462 .76469 .56536 .76565 .56519 .76468 .56445 Mtetra
.642 .678 .869 r
.76468 .56445 .76565 .56519 .76658 .56457 .76562 .56382 Mtetra
.717 .681 .814 r
.76562 .56382 .76658 .56457 .76748 .56347 .76652 .56272 Mtetra
.758 .676 .771 r
.76652 .56272 .76748 .56347 .76836 .56188 .76739 .56113 Mtetra
.783 .67 .739 r
.76739 .56113 .76836 .56188 .7692 .55978 .76824 .55903 Mtetra
.799 .664 .714 r
.76824 .55903 .7692 .55978 .77001 .55716 .76905 .55642 Mtetra
.809 .659 .697 r
.76905 .55642 .77001 .55716 .77079 .55406 .76983 .55331 Mtetra
.815 .656 .685 r
.76983 .55331 .77079 .55406 .77155 .55057 .77059 .54981 Mtetra
.818 .654 .679 r
.77059 .54981 .77155 .55057 .77229 .54686 .77133 .5461 Mtetra
.817 .654 .681 r
.77133 .5461 .77229 .54686 .77304 .5432 .77207 .54244 Mtetra
.811 .657 .691 r
.77207 .54244 .77304 .5432 .77381 .53994 .77284 .53918 Mtetra
.795 .664 .719 r
.77284 .53918 .77381 .53994 .77462 .53744 .77366 .53667 Mtetra
.746 .675 .781 r
.77366 .53667 .77462 .53744 .77551 .53599 .77454 .53522 Mtetra
.514 .648 .917 r
.77454 .53522 .77551 .53599 .77646 .53576 .7755 .535 Mtetra
.575 .033 0 r
.7755 .535 .77646 .53576 .7775 .53673 .77654 .53597 Mtetra
.856 .412 .149 r
.77654 .53597 .7775 .53673 .7786 .53871 .77764 .53795 Mtetra
.88 .485 .281 r
.77764 .53795 .7786 .53871 .77975 .54139 .77879 .54063 Mtetra
.883 .505 .319 r
.77879 .54063 .77975 .54139 .78092 .54439 .77996 .54363 Mtetra
.77996 .54363 .78092 .54439 .7821 .54738 .78113 .54663 Mtetra
.88 .489 .29 r
.78113 .54663 .7821 .54738 .78325 .55013 .78229 .54938 Mtetra
.87 .454 .226 r
.78229 .54938 .78325 .55013 .78439 .55245 .78342 .55171 Mtetra
.842 .382 .104 r
.78342 .55171 .78439 .55245 .78549 .55428 .78452 .55354 Mtetra
.746 .227 0 r
.78452 .55354 .78549 .55428 .78656 .5556 .7856 .55485 Mtetra
.438 0 0 r
.7856 .55485 .78656 .5556 .7876 .5564 .78664 .55566 Mtetra
.11 .485 .899 r
.78664 .55566 .7876 .5564 .78861 .55672 .78765 .55598 Mtetra
.477 .645 .931 r
.78765 .55598 .78861 .55672 .78959 .55657 .78863 .55583 Mtetra
.639 .68 .873 r
.78863 .55583 .78959 .55657 .79054 .55595 .78958 .5552 Mtetra
.716 .683 .817 r
.78958 .5552 .79054 .55595 .79146 .55485 .7905 .5541 Mtetra
.759 .678 .773 r
.7905 .5541 .79146 .55485 .79235 .55325 .79138 .55251 Mtetra
.784 .672 .74 r
.79138 .55251 .79235 .55325 .7932 .55114 .79224 .5504 Mtetra
.801 .666 .715 r
.79224 .5504 .7932 .55114 .79402 .54851 .79305 .54777 Mtetra
.811 .661 .697 r
.79305 .54777 .79402 .54851 .79481 .5454 .79384 .54465 Mtetra
.817 .658 .685 r
.79384 .54465 .79481 .5454 .79557 .54189 .7946 .54114 Mtetra
.82 .656 .68 r
.7946 .54114 .79557 .54189 .79631 .53818 .79534 .53742 Mtetra
.819 .657 .681 r
.79534 .53742 .79631 .53818 .79706 .53454 .79609 .53378 Mtetra
.813 .66 .693 r
.79609 .53378 .79706 .53454 .79783 .53131 .79687 .53055 Mtetra
.795 .667 .723 r
.79687 .53055 .79783 .53131 .79866 .52887 .7977 .5281 Mtetra
.74 .678 .79 r
.7977 .5281 .79866 .52887 .79957 .5275 .7986 .52673 Mtetra
.467 .637 .929 r
.7986 .52673 .79957 .5275 .80055 .52736 .79959 .5266 Mtetra
.622 .082 0 r
.79959 .5266 .80055 .52736 .80162 .52843 .80066 .52767 Mtetra
.857 .416 .154 r
.80066 .52767 .80162 .52843 .80276 .53051 .8018 .52975 Mtetra
.88 .484 .277 r
.8018 .52975 .80276 .53051 .80395 .53326 .80299 .5325 Mtetra
.883 .502 .313 r
.80299 .5325 .80395 .53326 .80517 .53632 .8042 .53557 Mtetra
.882 .501 .311 r
.8042 .53557 .80517 .53632 .80638 .53937 .80542 .53862 Mtetra
.879 .485 .281 r
.80542 .53862 .80638 .53937 .80758 .54215 .80661 .54141 Mtetra
.869 .448 .215 r
.80661 .54141 .80758 .54215 .80875 .54451 .80778 .54376 Mtetra
.838 .375 .091 r
.80778 .54376 .80875 .54451 .80989 .54636 .80892 .54562 Mtetra
.739 .219 0 r
.80892 .54562 .80989 .54636 .811 .54769 .81002 .54695 Mtetra
.434 0 0 r
.81002 .54695 .811 .54769 .81206 .54851 .81109 .54777 Mtetra
.102 .483 .898 r
.81109 .54777 .81206 .54851 .8131 .54884 .81213 .5481 Mtetra
.471 .647 .935 r
.81213 .5481 .8131 .54884 .8141 .54869 .81313 .54796 Mtetra
.637 .684 .877 r
.81313 .54796 .8141 .54869 .81507 .54807 .8141 .54734 Mtetra
.716 .687 .82 r
.8141 .54734 .81507 .54807 .81601 .54697 .81504 .54623 Mtetra
.76 .682 .776 r
.81504 .54623 .81601 .54697 .81691 .54537 .81594 .54463 Mtetra
.786 .675 .741 r
.81594 .54463 .81691 .54537 .81777 .54325 .8168 .54251 Mtetra
.803 .669 .716 r
.8168 .54251 .81777 .54325 .8186 .5406 .81762 .53986 Mtetra
.813 .664 .697 r
.81762 .53986 .8186 .5406 .81939 .53747 .81841 .53672 Mtetra
.82 .66 .685 r
.81841 .53672 .81939 .53747 .82015 .53394 .81918 .53319 Mtetra
.822 .659 .68 r
.81918 .53319 .82015 .53394 .82089 .53022 .81992 .52947 Mtetra
.821 .659 .682 r
.81992 .52947 .82089 .53022 .82165 .52659 .82067 .52584 Mtetra
.814 .663 .695 r
.82067 .52584 .82165 .52659 .82243 .5234 .82146 .52264 Mtetra
.794 .67 .727 r
.82146 .52264 .82243 .5234 .82327 .52101 .8223 .52025 Mtetra
.734 .682 .8 r
.8223 .52025 .82327 .52101 .82419 .51972 .82322 .51896 Mtetra
.414 .623 .938 r
.82322 .51896 .82419 .51972 .82521 .51967 .82424 .51892 Mtetra
.659 .122 0 r
.82424 .51892 .82521 .51967 .82632 .52084 .82535 .52008 Mtetra
.858 .418 .159 r
.82535 .52008 .82632 .52084 .8275 .52301 .82653 .52225 Mtetra
.879 .482 .273 r
.82653 .52225 .8275 .52301 .82874 .52584 .82776 .52509 Mtetra
.883 .499 .306 r
.82776 .52509 .82874 .52584 .82999 .52897 .82902 .52822 Mtetra
.882 .497 .303 r
.82902 .52822 .82999 .52897 .83125 .53206 .83028 .53132 Mtetra
.878 .48 .271 r
.83028 .53132 .83125 .53206 .83249 .53488 .83152 .53414 Mtetra
.867 .442 .204 r
.83152 .53414 .83249 .53488 .8337 .53726 .83273 .53652 Mtetra
.834 .367 .078 r
.83273 .53652 .8337 .53726 .83488 .53913 .8339 .5384 Mtetra
.732 .209 0 r
.8339 .5384 .83488 .53913 .83601 .54048 .83504 .53975 Mtetra
.429 0 0 r
.83504 .53975 .83601 .54048 .83711 .54131 .83614 .54058 Mtetra
.097 .484 .897 r
.83614 .54058 .83711 .54131 .83817 .54165 .8372 .54091 Mtetra
.466 .649 .938 r
.8372 .54091 .83817 .54165 .8392 .5415 .83822 .54077 Mtetra
.636 .688 .881 r
.83822 .54077 .8392 .5415 .84019 .54088 .83921 .54015 Mtetra
.717 .691 .824 r
.83921 .54015 .84019 .54088 .84114 .53977 .84017 .53904 Mtetra
.762 .685 .778 r
.84017 .53904 .84114 .53977 .84205 .53816 .84108 .53742 Mtetra
.789 .678 .742 r
.84108 .53742 .84205 .53816 .84293 .53602 .84195 .53528 Mtetra
.806 .672 .716 r
.84195 .53528 .84293 .53602 .84376 .53335 .84279 .53261 Mtetra
.816 .667 .697 r
.84279 .53261 .84376 .53335 .84455 .53019 .84358 .52945 Mtetra
.822 .663 .685 r
.84358 .52945 .84455 .53019 .84532 .52664 .84434 .5259 Mtetra
.825 .661 .68 r
.84434 .5259 .84532 .52664 .84607 .52291 .84509 .52217 Mtetra
.823 .662 .683 r
.84509 .52217 .84607 .52291 .84682 .51929 .84585 .51854 Mtetra
.816 .666 .697 r
.84585 .51854 .84682 .51929 .84761 .51612 .84664 .51537 Mtetra
.795 .674 .731 r
.84664 .51537 .84761 .51612 .84847 .51379 .8475 .51304 Mtetra
.727 .687 .811 r
.8475 .51304 .84847 .51379 .84942 .51257 .84844 .51182 Mtetra
.354 .604 .942 r
.84844 .51182 .84942 .51257 .85046 .51262 .84949 .51186 Mtetra
.688 .155 0 r
.84949 .51186 .85046 .51262 .85161 .51388 .85064 .51313 Mtetra
.859 .419 .161 r
.85064 .51313 .85161 .51388 .85284 .51613 .85186 .51538 Mtetra
.879 .48 .268 r
.85186 .51538 .85284 .51613 .85412 .51903 .85314 .51829 Mtetra
.882 .496 .299 r
.85314 .51829 .85412 .51903 .85542 .52222 .85445 .52148 Mtetra
.881 .493 .294 r
.85445 .52148 .85542 .52222 .85673 .52537 .85575 .52463 Mtetra
.877 .474 .261 r
.85575 .52463 .85673 .52537 .85801 .52822 .85704 .52748 Mtetra
.864 .435 .192 r
.85704 .52748 .85801 .52822 .85926 .53062 .85829 .52989 Mtetra
.829 .357 .065 r
.85829 .52989 .85926 .53062 .86047 .53251 .8595 .53178 Mtetra
.724 .197 0 r
.8595 .53178 .86047 .53251 .86164 .53387 .86067 .53314 Mtetra
0 .118 .567 r
.86067 .53314 .86164 .53387 .86277 .53471 .86179 .53398 Mtetra
.095 .486 .898 r
.86179 .53398 .86277 .53471 .86386 .53505 .86288 .53432 Mtetra
.464 .653 .942 r
.86288 .53432 .86386 .53505 .86491 .5349 .86393 .53418 Mtetra
.636 .692 .885 r
.86393 .53418 .86491 .5349 .86592 .53428 .86494 .53355 Mtetra
.719 .695 .827 r
.86494 .53355 .86592 .53428 .86689 .53316 .86591 .53243 Mtetra
.765 .69 .78 r
.86591 .53243 .86689 .53316 .86782 .53152 .86684 .5308 Mtetra
.792 .682 .743 r
.86684 .5308 .86782 .53152 .8687 .52936 .86772 .52863 Mtetra
.809 .675 .716 r
.86772 .52863 .8687 .52936 .86954 .52666 .86856 .52593 Mtetra
.819 .67 .697 r
.86856 .52593 .86954 .52666 .87034 .52347 .86936 .52274 Mtetra
.825 .666 .685 r
.86936 .52274 .87034 .52347 .8711 .5199 .87013 .51917 Mtetra
.828 .664 .68 r
.87013 .51917 .8711 .5199 .87185 .51615 .87088 .51542 Mtetra
.826 .665 .683 r
.87088 .51542 .87185 .51615 .87261 .51253 .87164 .51179 Mtetra
.818 .669 .699 r
.87164 .51179 .87261 .51253 .87341 .50939 .87244 .50865 Mtetra
.795 .679 .736 r
.87244 .50865 .87341 .50939 .87429 .50711 .87331 .50636 Mtetra
.72 .692 .823 r
.87331 .50636 .87429 .50711 .87526 .50596 .87428 .50522 Mtetra
.289 .58 .941 r
.87428 .50522 .87526 .50596 .87634 .50609 .87536 .50535 Mtetra
.71 .181 0 r
.87536 .50535 .87634 .50609 .87752 .50745 .87655 .5067 Mtetra
.859 .42 .162 r
.87655 .5067 .87752 .50745 .8788 .50978 .87782 .50905 Mtetra
.878 .477 .263 r
.87782 .50905 .8788 .50978 .88013 .51276 .87915 .51203 Mtetra
.882 .492 .291 r
.87915 .51203 .88013 .51276 .88148 .51601 .8805 .51528 Mtetra
.881 .488 .285 r
.8805 .51528 .88148 .51601 .88283 .5192 .88186 .51847 Mtetra
.875 .468 .25 r
.88186 .51847 .88283 .5192 .88416 .52208 .88318 .52135 Mtetra
.861 .427 .179 r
.88318 .52135 .88416 .52208 .88545 .5245 .88448 .52378 Mtetra
.823 .347 .05 r
.88448 .52378 .88545 .5245 .8867 .52641 .88572 .52569 Mtetra
.714 .184 0 r
.88572 .52569 .8867 .52641 .88791 .52777 .88693 .52705 Mtetra
0 .129 .576 r
.88693 .52705 .88791 .52777 .88907 .52861 .88808 .5279 Mtetra
.096 .491 .9 r
.88808 .5279 .88907 .52861 .89018 .52895 .8892 .52824 Mtetra
.463 .658 .945 r
.8892 .52824 .89018 .52895 .89126 .5288 .89027 .52809 Mtetra
.637 .697 .889 r
.89027 .52809 .89126 .5288 .89229 .52817 .89131 .52745 Mtetra
.722 .7 .829 r
.89131 .52745 .89229 .52817 .89328 .52703 .89229 .52631 Mtetra
.768 .694 .781 r
.89229 .52631 .89328 .52703 .89422 .52538 .89324 .52466 Mtetra
.795 .686 .744 r
.89324 .52466 .89422 .52538 .89511 .52318 .89413 .52246 Mtetra
.812 .679 .717 r
.89413 .52246 .89511 .52318 .89596 .52045 .89498 .51973 Mtetra
.823 .673 .697 r
.89498 .51973 .89596 .52045 .89676 .51722 .89578 .5165 Mtetra
.829 .669 .685 r
.89578 .5165 .89676 .51722 .89753 .51362 .89655 .5129 Mtetra
.831 .667 .68 r
.89655 .5129 .89753 .51362 .89828 .50986 .8973 .50913 Mtetra
.829 .668 .684 r
.8973 .50913 .89828 .50986 .89904 .50623 .89806 .5055 Mtetra
.82 .673 .701 r
.89806 .5055 .89904 .50623 .89985 .50312 .89887 .50238 Mtetra
.795 .684 .741 r
.89887 .50238 .89985 .50312 .90074 .50088 .89976 .50014 Mtetra
.712 .697 .834 r
.89976 .50014 .90074 .50088 .90174 .4998 .90076 .49907 Mtetra
.218 .551 .932 r
.90076 .49907 .90174 .4998 .90285 .50002 .90187 .49928 Mtetra
.726 .201 0 r
.90187 .49928 .90285 .50002 .90408 .50146 .9031 .50073 Mtetra
.859 .419 .162 r
.9031 .50073 .90408 .50146 .9054 .50388 .90442 .50315 Mtetra
.877 .473 .256 r
.90442 .50315 .9054 .50388 .90678 .50693 .9058 .50621 Mtetra
.881 .488 .282 r
.9058 .50621 .90678 .50693 .90819 .51024 .90721 .50951 Mtetra
.88 .483 .274 r
.90721 .50951 .90819 .51024 .90959 .51346 .90861 .51274 Mtetra
.873 .462 .238 r
.90861 .51274 .90959 .51346 .91097 .51637 .90999 .51565 Mtetra
.858 .419 .166 r
.90999 .51565 .91097 .51637 .9123 .51881 .91132 .5181 Mtetra
.817 .336 .034 r
.91132 .5181 .9123 .51881 .91359 .52073 .91261 .52001 Mtetra
.703 .17 0 r
.91261 .52001 .91359 .52073 .91483 .5221 .91385 .52139 Mtetra
0 .143 .587 r
.91385 .52139 .91483 .5221 .91602 .52294 .91504 .52223 Mtetra
.1 .498 .903 r
.91504 .52223 .91602 .52294 .91716 .52327 .91618 .52256 Mtetra
.464 .663 .948 r
.91618 .52256 .91716 .52327 .91826 .52311 .91728 .52241 Mtetra
.639 .703 .892 r
.91728 .52241 .91826 .52311 .91932 .52246 .91833 .52175 Mtetra
.725 .705 .832 r
.91833 .52175 .91932 .52246 .92032 .52131 .91934 .5206 Mtetra
.771 .698 .783 r
.91934 .5206 .92032 .52131 .92128 .51962 .9203 .51891 Mtetra
.798 .69 .745 r
.9203 .51891 .92128 .51962 .92219 .51739 .9212 .51668 Mtetra
.816 .682 .717 r
.9212 .51668 .92219 .51739 .92304 .51462 .92206 .51391 Mtetra
.826 .676 .697 r
.92206 .51391 .92304 .51462 .92384 .51136 .92286 .51064 Mtetra
.832 .672 .684 r
.92286 .51064 .92384 .51136 .92461 .50772 .92363 .50701 Mtetra
.834 .67 .679 r
.92363 .50701 .92461 .50772 .92537 .50393 .92438 .50321 Mtetra
.832 .671 .684 r
.92438 .50321 .92537 .50393 .92613 .5003 .92515 .49958 Mtetra
.822 .677 .703 r
.92515 .49958 .92613 .5003 .92695 .49721 .92597 .49648 Mtetra
.796 .689 .746 r
.92597 .49648 .92695 .49721 .92786 .49501 .92688 .49429 Mtetra
.703 .702 .847 r
.92688 .49429 .92786 .49501 .92888 .494 .9279 .49328 Mtetra
.145 .518 .915 r
.9279 .49328 .92888 .494 .93004 .4943 .92905 .49358 Mtetra
.739 .217 0 r
.92905 .49358 .93004 .4943 .93131 .49583 .93033 .49511 Mtetra
.858 .417 .16 r
.93033 .49511 .93131 .49583 .93268 .49833 .9317 .49761 Mtetra
.876 .469 .249 r
.9317 .49761 .93268 .49833 .93411 .50145 .93313 .50073 Mtetra
.88 .483 .273 r
.93313 .50073 .93411 .50145 .93557 .50481 .93459 .50409 Mtetra
.878 .477 .264 r
.93459 .50409 .93557 .50481 .93703 .50807 .93604 .50736 Mtetra
.871 .455 .226 r
.93604 .50736 .93703 .50807 .93845 .511 .93747 .5103 Mtetra
.854 .41 .151 r
.93747 .5103 .93845 .511 .93983 .51346 .93885 .51276 Mtetra
.81 .323 .016 r
.93885 .51276 .93983 .51346 .94116 .51538 .94017 .51468 Mtetra
.691 .154 0 r
.94017 .51468 .94116 .51538 .94243 .51675 .94145 .51605 Mtetra
0 .159 .601 r
.94145 .51605 .94243 .51675 .94366 .51759 .94267 .51689 Mtetra
.108 .507 .907 r
.94267 .51689 .94366 .51759 .94483 .51792 .94385 .51722 Mtetra
.467 .669 .951 r
.94385 .51722 .94483 .51792 .94596 .51775 .94497 .51705 Mtetra
.642 .709 .895 r
.94497 .51705 .94596 .51775 .94703 .51708 .94605 .51638 Mtetra
.728 .71 .834 r
.94605 .51638 .94703 .51708 .94806 .5159 .94707 .5152 Mtetra
.775 .703 .784 r
.94707 .5152 .94806 .5159 .94903 .51418 .94804 .51348 Mtetra
.802 .694 .745 r
.94804 .51348 .94903 .51418 .94994 .51192 .94896 .51121 Mtetra
.819 .686 .716 r
.94896 .51121 .94994 .51192 .9508 .5091 .94982 .5084 Mtetra
.83 .679 .696 r
.94982 .5084 .9508 .5091 .95161 .50579 .95063 .50509 Mtetra
.836 .675 .683 r
.95063 .50509 .95161 .50579 .95238 .50212 .9514 .50141 Mtetra
.837 .673 .679 r
.9514 .50141 .95238 .50212 .95314 .4983 .95215 .49759 Mtetra
.835 .675 .684 r
.95215 .49759 .95314 .4983 .95391 .49466 .95293 .49395 Mtetra
.825 .681 .704 r
.95293 .49395 .95391 .49466 .95474 .49158 .95376 .49086 Mtetra
.796 .694 .752 r
.95376 .49086 .95474 .49158 .95567 .48943 .95468 .48871 Mtetra
.693 .708 .859 r
.95468 .48871 .95567 .48943 .95672 .48849 .95573 .48777 Mtetra
.072 .481 .892 r
.95573 .48777 .95672 .48849 .95791 .48887 .95692 .48815 Mtetra
.748 .229 0 r
.95692 .48815 .95791 .48887 .95923 .49048 .95824 .48976 Mtetra
.857 .415 .156 r
.95824 .48976 .95923 .49048 .96065 .49306 .95967 .49235 Mtetra
.875 .465 .24 r
.95967 .49235 .96065 .49306 .96214 .49624 .96116 .49554 Mtetra
.879 .478 .262 r
.96116 .49554 .96214 .49624 .96366 .49965 .96267 .49895 Mtetra
.877 .471 .252 r
.96267 .49895 .96366 .49965 .96516 .50295 .96418 .50225 Mtetra
.869 .447 .212 r
.96418 .50225 .96516 .50295 .96664 .5059 .96565 .5052 Mtetra
.849 .4 .135 r
.96565 .5052 .96664 .5059 .96806 .50837 .96708 .50768 Mtetra
.802 .31 0 r
.96708 .50768 .96806 .50837 .96943 .5103 .96844 .5096 Mtetra
.676 .136 0 r
.96844 .5096 .96943 .5103 .97075 .51167 .96976 .51098 Mtetra
0 .177 .617 r
.96976 .51098 .97075 .51167 .972 .5125 .97102 .51181 Mtetra
.118 .517 .912 r
.97102 .51181 .972 .5125 .97321 .51282 .97222 .51213 Mtetra
.472 .676 .954 r
.97222 .51213 .97321 .51282 .97436 .51263 .97337 .51194 Mtetra
.646 .714 .898 r
.97337 .51194 .97436 .51263 .97546 .51194 .97447 .51125 Mtetra
.732 .716 .835 r
.97447 .51125 .97546 .51194 .9765 .51073 .97551 .51004 Mtetra
.779 .707 .785 r
.97551 .51004 .9765 .51073 .97749 .50898 .9765 .50829 Mtetra
.806 .698 .745 r
.9765 .50829 .97749 .50898 .97841 .50667 .97742 .50598 Mtetra
.823 .689 .716 r
.97742 .50598 .97841 .50667 .97928 .50381 .97829 .50311 Mtetra
.834 .682 .695 r
.97829 .50311 .97928 .50381 .98009 .50045 .9791 .49975 Mtetra
.839 .678 .683 r
.9791 .49975 .98009 .50045 .98086 .49673 .97987 .49603 Mtetra
.841 .676 .679 r
.97987 .49603 .98086 .49673 .98162 .49288 .98063 .49218 Mtetra
.838 .678 .685 r
.98063 .49218 .98162 .49288 .98239 .48923 .98141 .48852 Mtetra
.827 .685 .706 r
.98141 .48852 .98239 .48923 .98323 .48616 .98225 .48545 Mtetra
.796 .699 .757 r
.98225 .48545 .98323 .48616 .98418 .48405 .98319 .48334 Mtetra
.681 .712 .872 r
.98319 .48334 .98418 .48405 .98526 .48318 .98428 .48247 Mtetra
.443 .455 .777 r
.52033 .68524 .52126 .68695 .52203 .68694 .5211 .68524 Mtetra
0 0 .569 r
.5211 .68524 .52203 .68694 .5228 .68799 .52187 .68635 Mtetra
.885 .476 .049 r
.52187 .68635 .5228 .68799 .52358 .68988 .52266 .68832 Mtetra
.932 .556 .255 r
.52266 .68832 .52358 .68988 .52437 .69227 .52344 .69081 Mtetra
.929 .567 .312 r
.52344 .69081 .52437 .69227 .52516 .69484 .52423 .69347 Mtetra
.923 .558 .31 r
.52423 .69347 .52516 .69484 .52595 .6973 .52503 .69603 Mtetra
.916 .532 .265 r
.52503 .69603 .52595 .6973 .52675 .69945 .52582 .69827 Mtetra
.895 .475 .154 r
.52582 .69827 .52675 .69945 .52753 .70117 .5266 .70006 Mtetra
.803 .33 0 r
.5266 .70006 .52753 .70117 .52832 .70241 .52739 .70136 Mtetra
0 .029 .558 r
.52739 .70136 .52832 .70241 .5291 .70317 .52817 .70217 Mtetra
.171 .428 .863 r
.52817 .70217 .5291 .70317 .52988 .70347 .52895 .70249 Mtetra
.494 .574 .865 r
.52895 .70249 .52988 .70347 .53066 .70331 .52973 .70235 Mtetra
.627 .613 .817 r
.52973 .70235 .53066 .70331 .53143 .70272 .5305 .70175 Mtetra
.691 .624 .776 r
.5305 .70175 .53143 .70272 .5322 .70169 .53127 .70071 Mtetra
.726 .625 .745 r
.53127 .70071 .5322 .70169 .53297 .70021 .53204 .69919 Mtetra
.748 .624 .722 r
.53204 .69919 .53297 .70021 .53373 .69826 .5328 .6972 Mtetra
.761 .621 .704 r
.5328 .6972 .53373 .69826 .53449 .69582 .53356 .6947 Mtetra
.769 .617 .691 r
.53356 .6947 .53449 .69582 .53524 .69291 .53431 .69171 Mtetra
.774 .613 .681 r
.53431 .69171 .53524 .69291 .53599 .68957 .53506 .68828 Mtetra
.774 .609 .675 r
.53506 .68828 .53599 .68957 .53673 .68592 .5358 .68454 Mtetra
.771 .605 .673 r
.5358 .68454 .53673 .68592 .53748 .68218 .53655 .68069 Mtetra
.763 .6 .675 r
.53655 .68069 .53748 .68218 .53822 .67863 .53729 .67704 Mtetra
.747 .592 .683 r
.53729 .67704 .53822 .67863 .53897 .67559 .53804 .67393 Mtetra
.715 .578 .7 r
.53804 .67393 .53897 .67559 .53973 .67341 .5388 .67169 Mtetra
.643 .548 .732 r
.5388 .67169 .53973 .67341 .5405 .6723 .53957 .67057 Mtetra
.422 .443 .777 r
.53957 .67057 .5405 .6723 .54128 .67236 .54035 .67064 Mtetra
0 0 .553 r
.54035 .67064 .54128 .67236 .54208 .67347 .54114 .6718 Mtetra
.882 .472 .039 r
.54114 .6718 .54208 .67347 .54288 .6754 .54195 .67382 Mtetra
.931 .552 .241 r
.54195 .67382 .54288 .6754 .5437 .67783 .54276 .67634 Mtetra
.93 .563 .297 r
.54276 .67634 .5437 .67783 .54451 .68041 .54358 .67902 Mtetra
.924 .553 .293 r
.54358 .67902 .54451 .68041 .54533 .68287 .54439 .68158 Mtetra
.916 .525 .243 r
.54439 .68158 .54533 .68287 .54614 .68502 .54521 .68381 Mtetra
.889 .462 .122 r
.54521 .68381 .54614 .68502 .54695 .68673 .54602 .6856 Mtetra
.778 .302 0 r
.54602 .6856 .54695 .68673 .54776 .68796 .54682 .68688 Mtetra
0 .069 .603 r
.54682 .68688 .54776 .68796 .54856 .6887 .54762 .68767 Mtetra
.2 .439 .865 r
.54762 .68767 .54856 .6887 .54935 .68898 .54842 .68798 Mtetra
.5 .573 .86 r
.54842 .68798 .54935 .68898 .55014 .68881 .54921 .68782 Mtetra
.628 .611 .814 r
.54921 .68782 .55014 .68881 .55093 .6882 .54999 .6872 Mtetra
.691 .622 .775 r
.54999 .6872 .55093 .6882 .55171 .68715 .55077 .68613 Mtetra
.726 .624 .744 r
.55077 .68613 .55171 .68715 .55248 .68564 .55155 .6846 Mtetra
.747 .623 .721 r
.55155 .6846 .55248 .68564 .55325 .68366 .55231 .68257 Mtetra
.761 .62 .703 r
.55231 .68257 .55325 .68366 .55401 .6812 .55308 .68005 Mtetra
.769 .616 .69 r
.55308 .68005 .55401 .6812 .55477 .67825 .55383 .67703 Mtetra
.773 .613 .68 r
.55383 .67703 .55477 .67825 .55551 .67489 .55458 .67357 Mtetra
.774 .609 .675 r
.55458 .67357 .55551 .67489 .55626 .67122 .55532 .6698 Mtetra
.771 .604 .673 r
.55532 .6698 .55626 .67122 .557 .66747 .55606 .66595 Mtetra
.762 .599 .675 r
.55606 .66595 .557 .66747 .55774 .66392 .5568 .6623 Mtetra
.745 .591 .684 r
.5568 .6623 .55774 .66392 .5585 .66092 .55755 .65922 Mtetra
.712 .576 .701 r
.55755 .65922 .5585 .66092 .55926 .65878 .55832 .65703 Mtetra
.634 .543 .734 r
.55832 .65703 .55926 .65878 .56004 .65773 .5591 .65597 Mtetra
.4 .43 .776 r
.5591 .65597 .56004 .65773 .56084 .65785 .5599 .6561 Mtetra
0 0 .537 r
.5599 .6561 .56084 .65785 .56165 .65902 .56071 .65733 Mtetra
.878 .468 .029 r
.56071 .65733 .56165 .65902 .56248 .66101 .56154 .6594 Mtetra
.93 .548 .227 r
.56154 .6594 .56248 .66101 .56332 .66346 .56238 .66195 Mtetra
.93 .559 .281 r
.56238 .66195 .56332 .66346 .56416 .66607 .56322 .66466 Mtetra
.924 .548 .275 r
.56322 .66466 .56416 .66607 .565 .66854 .56406 .66722 Mtetra
.914 .518 .22 r
.56406 .66722 .565 .66854 .56584 .67068 .5649 .66945 Mtetra
.881 .448 .089 r
.5649 .66945 .56584 .67068 .56667 .67238 .56573 .67123 Mtetra
.75 .273 0 r
.56573 .67123 .56667 .67238 .5675 .6736 .56656 .6725 Mtetra
0 .105 .64 r
.56656 .6725 .5675 .6736 .56832 .67433 .56738 .67328 Mtetra
.225 .447 .866 r
.56738 .67328 .56832 .67433 .56913 .6746 .56819 .67357 Mtetra
.505 .571 .856 r
.56819 .67357 .56913 .6746 .56993 .67441 .56899 .67339 Mtetra
.628 .609 .812 r
.56899 .67339 .56993 .67441 .57073 .67378 .56979 .67276 Mtetra
.69 .62 .773 r
.56979 .67276 .57073 .67378 .57152 .67271 .57058 .67167 Mtetra
.725 .622 .743 r
.57058 .67167 .57152 .67271 .5723 .67119 .57136 .67012 Mtetra
.747 .621 .72 r
.57136 .67012 .5723 .67119 .57307 .66918 .57213 .66807 Mtetra
.76 .619 .703 r
.57213 .66807 .57307 .66918 .57384 .66669 .5729 .66551 Mtetra
.769 .616 .689 r
.5729 .66551 .57384 .66669 .5746 .66372 .57365 .66246 Mtetra
.773 .612 .68 r
.57365 .66246 .5746 .66372 .57534 .66033 .5744 .65898 Mtetra
.774 .608 .674 r
.5744 .65898 .57534 .66033 .57609 .65664 .57514 .65519 Mtetra
.77 .604 .672 r
.57514 .65519 .57609 .65664 .57683 .65289 .57588 .65133 Mtetra
.761 .598 .675 r
.57588 .65133 .57683 .65289 .57757 .64935 .57662 .6477 Mtetra
.743 .589 .684 r
.57662 .6477 .57757 .64935 .57833 .64638 .57738 .64465 Mtetra
.708 .574 .702 r
.57738 .64465 .57833 .64638 .5791 .64429 .57815 .64251 Mtetra
.625 .538 .736 r
.57815 .64251 .5791 .64429 .57989 .64331 .57894 .64151 Mtetra
.377 .417 .775 r
.57894 .64151 .57989 .64331 .5807 .64349 .57975 .64172 Mtetra
0 0 .52 r
.57975 .64172 .5807 .64349 .58154 .64473 .58059 .64301 Mtetra
.874 .464 .02 r
.58059 .64301 .58154 .64473 .58239 .64676 .58144 .64513 Mtetra
.928 .543 .212 r
.58144 .64513 .58239 .64676 .58326 .64926 .58231 .64772 Mtetra
.93 .554 .265 r
.58231 .64772 .58326 .64926 .58413 .65189 .58318 .65045 Mtetra
.924 .543 .257 r
.58318 .65045 .58413 .65189 .58499 .65436 .58405 .65303 Mtetra
.912 .509 .196 r
.58405 .65303 .58499 .65436 .58586 .65651 .58491 .65526 Mtetra
.872 .433 .055 r
.58491 .65526 .58586 .65651 .58671 .65821 .58577 .65703 Mtetra
.72 .244 0 r
.58577 .65703 .58671 .65821 .58756 .65942 .58661 .6583 Mtetra
0 .136 .67 r
.58661 .6583 .58756 .65942 .58839 .66014 .58745 .65906 Mtetra
.244 .453 .865 r
.58745 .65906 .58839 .66014 .58922 .6604 .58827 .65934 Mtetra
.508 .569 .853 r
.58827 .65934 .58922 .6604 .59004 .6602 .58909 .65915 Mtetra
.627 .606 .81 r
.58909 .65915 .59004 .6602 .59085 .65956 .5899 .65851 Mtetra
.688 .618 .772 r
.5899 .65851 .59085 .65956 .59165 .65847 .5907 .6574 Mtetra
.724 .621 .743 r
.5907 .6574 .59165 .65847 .59244 .65692 .59149 .65582 Mtetra
.746 .62 .72 r
.59149 .65582 .59244 .65692 .59322 .6549 .59227 .65375 Mtetra
.76 .618 .702 r
.59227 .65375 .59322 .6549 .59399 .65238 .59304 .65117 Mtetra
.768 .615 .689 r
.59304 .65117 .59399 .65238 .59474 .64939 .5938 .64809 Mtetra
.773 .611 .679 r
.5938 .64809 .59474 .64939 .59549 .64597 .59454 .64459 Mtetra
.773 .607 .674 r
.59454 .64459 .59549 .64597 .59623 .64227 .59528 .64079 Mtetra
.769 .603 .672 r
.59528 .64079 .59623 .64227 .59697 .63852 .59602 .63692 Mtetra
.76 .597 .675 r
.59602 .63692 .59697 .63852 .59772 .635 .59676 .63331 Mtetra
.741 .588 .685 r
.59676 .63331 .59772 .635 .59848 .63206 .59752 .6303 Mtetra
.703 .571 .704 r
.59752 .6303 .59848 .63206 .59925 .63003 .59829 .62821 Mtetra
.615 .533 .738 r
.59829 .62821 .59925 .63003 .60006 .62911 .5991 .62729 Mtetra
.351 .402 .774 r
.5991 .62729 .60006 .62911 .60089 .62937 .59993 .62756 Mtetra
0 0 .504 r
.59993 .62756 .60089 .62937 .60175 .63067 .60079 .62893 Mtetra
.87 .46 .011 r
.60079 .62893 .60175 .63067 .60263 .63276 .60167 .6311 Mtetra
.926 .539 .198 r
.60167 .6311 .60263 .63276 .60352 .6353 .60257 .63373 Mtetra
.929 .55 .248 r
.60257 .63373 .60352 .6353 .60442 .63795 .60346 .63649 Mtetra
.923 .537 .237 r
.60346 .63649 .60442 .63795 .60531 .64044 .60436 .63908 Mtetra
.908 .501 .172 r
.60436 .63908 .60531 .64044 .6062 .64259 .60525 .64131 Mtetra
.861 .417 .021 r
.60525 .64131 .6062 .64259 .60708 .64429 .60613 .64308 Mtetra
.689 .216 0 r
.60613 .64308 .60708 .64429 .60794 .64549 .60699 .64435 Mtetra
0 .161 .694 r
.60699 .64435 .60794 .64549 .6088 .64621 .60785 .64511 Mtetra
.259 .456 .863 r
.60785 .64511 .6088 .64621 .60964 .64646 .60869 .64538 Mtetra
.509 .567 .85 r
.60869 .64538 .60964 .64646 .61048 .64625 .60953 .64518 Mtetra
.626 .604 .808 r
.60953 .64518 .61048 .64625 .6113 .6456 .61035 .64453 Mtetra
.687 .616 .771 r
.61035 .64453 .6113 .6456 .61211 .6445 .61116 .64341 Mtetra
.723 .619 .742 r
.61116 .64341 .61211 .6445 .61291 .64294 .61196 .64181 Mtetra
.745 .619 .719 r
.61196 .64181 .61291 .64294 .61369 .6409 .61274 .63972 Mtetra
.759 .617 .701 r
.61274 .63972 .61369 .6409 .61447 .63836 .61351 .63712 Mtetra
.768 .614 .688 r
.61351 .63712 .61447 .63836 .61523 .63534 .61427 .63402 Mtetra
.772 .611 .679 r
.61427 .63402 .61523 .63534 .61598 .63191 .61502 .63049 Mtetra
.773 .607 .673 r
.61502 .63049 .61598 .63191 .61672 .6282 .61576 .62668 Mtetra
.769 .602 .672 r
.61576 .62668 .61672 .6282 .61746 .62445 .61649 .62282 Mtetra
.759 .596 .675 r
.61649 .62282 .61746 .62445 .6182 .62095 .61724 .61922 Mtetra
.739 .586 .685 r
.61724 .61922 .6182 .62095 .61896 .61805 .61799 .61625 Mtetra
.698 .569 .705 r
.61799 .61625 .61896 .61805 .61975 .61608 .61878 .61423 Mtetra
.604 .527 .741 r
.61878 .61423 .61975 .61608 .62057 .61523 .6196 .61338 Mtetra
.324 .385 .771 r
.6196 .61338 .62057 .61523 .62142 .61556 .62045 .61373 Mtetra
0 0 .487 r
.62045 .61373 .62142 .61556 .6223 .61694 .62134 .61517 Mtetra
.866 .457 .003 r
.62134 .61517 .6223 .61694 .62321 .61909 .62224 .6174 Mtetra
.924 .534 .183 r
.62224 .6174 .62321 .61909 .62413 .62167 .62317 .62008 Mtetra
.928 .545 .232 r
.62317 .62008 .62413 .62167 .62506 .62435 .62409 .62287 Mtetra
.922 .531 .218 r
.62409 .62287 .62506 .62435 .62598 .62686 .62502 .62548 Mtetra
.904 .492 .147 r
.62502 .62548 .62598 .62686 .62689 .62902 .62593 .62772 Mtetra
.848 .401 0 r
.62593 .62772 .62689 .62902 .62779 .63072 .62684 .62949 Mtetra
.658 .189 0 r
.62684 .62949 .62779 .63072 .62868 .63193 .62773 .63075 Mtetra
0 .181 .711 r
.62773 .63075 .62868 .63193 .62956 .63265 .6286 .63151 Mtetra
.269 .458 .861 r
.6286 .63151 .62956 .63265 .63042 .63289 .62946 .63178 Mtetra
.509 .564 .847 r
.62946 .63178 .63042 .63289 .63127 .63268 .63031 .63158 Mtetra
.624 .601 .807 r
.63031 .63158 .63127 .63268 .6321 .63202 .63115 .63092 Mtetra
.685 .614 .771 r
.63115 .63092 .6321 .63202 .63292 .63092 .63197 .62979 Mtetra
.721 .618 .742 r
.63197 .62979 .63292 .63092 .63373 .62934 .63277 .62819 Mtetra
.744 .618 .719 r
.63277 .62819 .63373 .62934 .63452 .62729 .63357 .62608 Mtetra
.758 .616 .701 r
.63357 .62608 .63452 .62729 .6353 .62473 .63434 .62345 Mtetra
.767 .613 .688 r
.63434 .62345 .6353 .62473 .63606 .62169 .6351 .62034 Mtetra
.772 .61 .678 r
.6351 .62034 .63606 .62169 .63681 .61824 .63585 .61679 Mtetra
.772 .606 .673 r
.63585 .61679 .63681 .61824 .63755 .61453 .63658 .61297 Mtetra
.768 .601 .672 r
.63658 .61297 .63755 .61453 .63829 .61078 .63732 .60912 Mtetra
.757 .594 .676 r
.63732 .60912 .63829 .61078 .63904 .6073 .63806 .60555 Mtetra
.736 .584 .686 r
.63806 .60555 .63904 .6073 .6398 .60445 .63883 .60262 Mtetra
.693 .566 .707 r
.63883 .60262 .6398 .60445 .6406 .60254 .63962 .60066 Mtetra
.592 .521 .743 r
.63962 .60066 .6406 .60254 .64143 .60178 .64045 .59989 Mtetra
.294 .367 .768 r
.64045 .59989 .64143 .60178 .64231 .60219 .64133 .60033 Mtetra
0 0 .47 r
.64133 .60033 .64231 .60219 .64321 .60364 .64224 .60184 Mtetra
.863 .454 0 r
.64224 .60184 .64321 .60364 .64415 .60585 .64318 .60414 Mtetra
.922 .529 .169 r
.64318 .60414 .64415 .60585 .6451 .60848 .64413 .60687 Mtetra
.926 .54 .216 r
.64413 .60687 .6451 .60848 .64606 .6112 .64509 .60969 Mtetra
.919 .525 .199 r
.64509 .60969 .64606 .6112 .64701 .61373 .64604 .61232 Mtetra
.899 .482 .123 r
.64604 .61232 .64701 .61373 .64795 .6159 .64698 .61458 Mtetra
.835 .385 0 r
.64698 .61458 .64795 .6159 .64888 .61761 .64791 .61636 Mtetra
.629 .165 0 r
.64791 .61636 .64888 .61761 .64979 .61882 .64883 .61763 Mtetra
0 .196 .724 r
.64883 .61763 .64979 .61882 .65068 .61955 .64972 .61839 Mtetra
.276 .458 .859 r
.64972 .61839 .65068 .61955 .65156 .61979 .6506 .61866 Mtetra
.508 .561 .845 r
.6506 .61866 .65156 .61979 .65243 .61958 .65147 .61846 Mtetra
.621 .598 .806 r
.65147 .61846 .65243 .61958 .65328 .61892 .65231 .61779 Mtetra
.683 .612 .77 r
.65231 .61779 .65328 .61892 .65411 .61781 .65315 .61666 Mtetra
.719 .616 .742 r
.65315 .61666 .65411 .61781 .65493 .61623 .65396 .61504 Mtetra
.743 .617 .719 r
.65396 .61504 .65493 .61623 .65573 .61416 .65476 .61292 Mtetra
.758 .615 .701 r
.65476 .61292 .65573 .61416 .65651 .61159 .65554 .61028 Mtetra
.767 .612 .687 r
.65554 .61028 .65651 .61159 .65727 .60854 .6563 .60715 Mtetra
.771 .609 .678 r
.6563 .60715 .65727 .60854 .65802 .60508 .65705 .60359 Mtetra
.771 .605 .673 r
.65705 .60359 .65802 .60508 .65876 .60136 .65779 .59977 Mtetra
.767 .6 .672 r
.65779 .59977 .65876 .60136 .6595 .59762 .65852 .59592 Mtetra
.756 .593 .676 r
.65852 .59592 .6595 .59762 .66025 .59417 .65926 .59238 Mtetra
.733 .583 .687 r
.65926 .59238 .66025 .59417 .66102 .59137 .66003 .58951 Mtetra
.687 .563 .709 r
.66003 .58951 .66102 .59137 .66183 .58953 .66084 .58762 Mtetra
.579 .514 .746 r
.66084 .58762 .66183 .58953 .66268 .58884 .66169 .58693 Mtetra
.261 .348 .764 r
.66169 .58693 .66268 .58884 .66357 .58934 .66259 .58746 Mtetra
0 0 .451 r
.66259 .58746 .66357 .58934 .66451 .59087 .66352 .58905 Mtetra
.86 .452 0 r
.66352 .58905 .66451 .59087 .66547 .59315 .66449 .59142 Mtetra
.919 .524 .156 r
.66449 .59142 .66547 .59315 .66646 .59584 .66548 .59421 Mtetra
.924 .534 .2 r
.66548 .59421 .66646 .59584 .66745 .59859 .66647 .59706 Mtetra
.917 .518 .181 r
.66647 .59706 .66745 .59859 .66843 .60115 .66745 .59972 Mtetra
.893 .473 .1 r
.66745 .59972 .66843 .60115 .6694 .60334 .66843 .602 Mtetra
.822 .37 0 r
.66843 .602 .6694 .60334 .67035 .60506 .66938 .60379 Mtetra
.603 .144 0 r
.66938 .60379 .67035 .60506 .67128 .60629 .67032 .60507 Mtetra
0 .207 .733 r
.67032 .60507 .67128 .60629 .6722 .60702 .67123 .60584 Mtetra
.279 .457 .857 r
.67123 .60584 .6722 .60702 .6731 .60727 .67213 .60611 Mtetra
.505 .558 .844 r
.67213 .60611 .6731 .60727 .67398 .60707 .67301 .60592 Mtetra
.618 .596 .806 r
.67301 .60592 .67398 .60707 .67484 .60641 .67388 .60525 Mtetra
.681 .61 .771 r
.67388 .60525 .67484 .60641 .67569 .6053 .67472 .60412 Mtetra
.718 .615 .742 r
.67472 .60412 .67569 .6053 .67652 .60371 .67555 .6025 Mtetra
.742 .616 .719 r
.67555 .6025 .67652 .60371 .67733 .60163 .67635 .60037 Mtetra
.757 .614 .701 r
.67635 .60037 .67733 .60163 .67811 .59905 .67714 .59772 Mtetra
.766 .612 .687 r
.67714 .59772 .67811 .59905 .67888 .59599 .6779 .59457 Mtetra
.771 .609 .678 r
.6779 .59457 .67888 .59599 .67963 .59252 .67865 .591 Mtetra
.771 .604 .673 r
.67865 .591 .67963 .59252 .68037 .5888 .67938 .58717 Mtetra
.766 .599 .672 r
.67938 .58717 .68037 .5888 .68111 .58507 .68012 .58334 Mtetra
.754 .592 .676 r
.68012 .58334 .68111 .58507 .68186 .58166 .68087 .57983 Mtetra
.73 .581 .688 r
.68087 .57983 .68186 .58166 .68264 .57891 .68164 .57701 Mtetra
.681 .559 .711 r
.68164 .57701 .68264 .57891 .68346 .57714 .68246 .5752 Mtetra
.564 .506 .748 r
.68246 .5752 .68346 .57714 .68432 .57654 .68333 .5746 Mtetra
.225 .327 .759 r
.68333 .5746 .68432 .57654 .68524 .57713 .68425 .57522 Mtetra
0 0 .431 r
.68425 .57522 .68524 .57713 .68621 .57874 .68521 .5769 Mtetra
.858 .45 0 r
.68521 .5769 .68621 .57874 .68721 .5811 .68622 .57934 Mtetra
.916 .52 .144 r
.68622 .57934 .68721 .5811 .68822 .58384 .68724 .58219 Mtetra
.922 .529 .186 r
.68724 .58219 .68822 .58384 .68925 .58664 .68826 .58509 Mtetra
.914 .511 .163 r
.68826 .58509 .68925 .58664 .69026 .58923 .68928 .58778 Mtetra
.887 .463 .079 r
.68928 .58778 .69026 .58923 .69126 .59144 .69028 .59008 Mtetra
.809 .356 0 r
.69028 .59008 .69126 .59144 .69224 .59318 .69126 .59189 Mtetra
.581 .127 0 r
.69126 .59189 .69224 .59318 .6932 .59442 .69222 .59318 Mtetra
0 .215 .738 r
.69222 .59318 .6932 .59442 .69414 .59516 .69316 .59396 Mtetra
.279 .455 .856 r
.69316 .59396 .69414 .59516 .69506 .59543 .69408 .59425 Mtetra
.501 .555 .843 r
.69408 .59425 .69506 .59543 .69596 .59523 .69498 .59406 Mtetra
.615 .594 .806 r
.69498 .59406 .69596 .59523 .69684 .59458 .69586 .5934 Mtetra
.678 .609 .771 r
.69586 .5934 .69684 .59458 .69769 .59347 .69672 .59227 Mtetra
.716 .614 .742 r
.69672 .59227 .69769 .59347 .69853 .59188 .69756 .59064 Mtetra
.741 .615 .719 r
.69756 .59064 .69853 .59188 .69935 .58979 .69837 .5885 Mtetra
.756 .614 .701 r
.69837 .5885 .69935 .58979 .70014 .5872 .69916 .58584 Mtetra
.766 .611 .687 r
.69916 .58584 .70014 .5872 .70091 .58413 .69993 .58268 Mtetra
.771 .608 .678 r
.69993 .58268 .70091 .58413 .70166 .58065 .70067 .57911 Mtetra
.77 .604 .673 r
.70067 .57911 .70166 .58065 .7024 .57693 .70141 .57528 Mtetra
.765 .599 .672 r
.70141 .57528 .7024 .57693 .70314 .57322 .70214 .57147 Mtetra
.752 .591 .677 r
.70214 .57147 .70314 .57322 .7039 .56985 .70289 .568 Mtetra
.727 .579 .69 r
.70289 .568 .7039 .56985 .70468 .56716 .70367 .56524 Mtetra
.674 .556 .714 r
.70367 .56524 .70468 .56716 .70551 .56547 .70451 .5635 Mtetra
.549 .498 .751 r
.70451 .5635 .70551 .56547 .7064 .56496 .70539 .56299 Mtetra
.186 .304 .752 r
.70539 .56299 .7064 .56496 .70735 .56564 .70634 .56371 Mtetra
0 0 .411 r
.70634 .56371 .70735 .56564 .70834 .56734 .70734 .56548 Mtetra
.857 .448 0 r
.70734 .56548 .70834 .56734 .70938 .56977 .70838 .568 Mtetra
.913 .515 .134 r
.70838 .568 .70938 .56977 .71043 .57258 .70943 .57091 Mtetra
.919 .524 .172 r
.70943 .57091 .71043 .57258 .71149 .57542 .71049 .57386 Mtetra
.91 .504 .147 r
.71049 .57386 .71149 .57542 .71253 .57805 .71154 .57659 Mtetra
.881 .454 .06 r
.71154 .57659 .71253 .57805 .71356 .58029 .71258 .57891 Mtetra
.797 .343 0 r
.71258 .57891 .71356 .58029 .71457 .58205 .71359 .58074 Mtetra
0 0 .428 r
.71359 .58074 .71457 .58205 .71556 .58331 .71458 .58205 Mtetra
0 .219 .742 r
.71458 .58205 .71556 .58331 .71652 .58406 .71554 .58285 Mtetra
.276 .452 .855 r
.71554 .58285 .71652 .58406 .71746 .58434 .71648 .58315 Mtetra
.497 .553 .844 r
.71648 .58315 .71746 .58434 .71838 .58415 .7174 .58297 Mtetra
.612 .593 .807 r
.7174 .58297 .71838 .58415 .71927 .58351 .71829 .58232 Mtetra
.676 .608 .772 r
.71829 .58232 .71927 .58351 .72015 .5824 .71917 .58118 Mtetra
.715 .614 .743 r
.71917 .58118 .72015 .5824 .721 .58081 .72001 .57956 Mtetra
.74 .615 .72 r
.72001 .57956 .721 .58081 .72182 .57872 .72084 .57741 Mtetra
.756 .614 .701 r
.72084 .57741 .72182 .57872 .72262 .57613 .72163 .57474 Mtetra
.766 .611 .687 r
.72163 .57474 .72262 .57613 .72339 .57304 .7224 .57157 Mtetra
.77 .608 .678 r
.7224 .57157 .72339 .57304 .72415 .56956 .72315 .56799 Mtetra
.77 .604 .673 r
.72315 .56799 .72415 .56956 .72489 .56584 .72388 .56417 Mtetra
.764 .598 .672 r
.72388 .56417 .72489 .56584 .72563 .56215 .72462 .56037 Mtetra
.751 .591 .678 r
.72462 .56037 .72563 .56215 .72639 .55881 .72537 .55694 Mtetra
.723 .578 .691 r
.72537 .55694 .72639 .55881 .72718 .55618 .72616 .55424 Mtetra
.667 .553 .716 r
.72616 .55424 .72718 .55618 .72803 .55457 .72701 .55259 Mtetra
.532 .49 .755 r
.72701 .55259 .72803 .55457 .72894 .55415 .72792 .55217 Mtetra
.146 .28 .745 r
.72792 .55217 .72894 .55415 .72991 .55493 .72889 .55298 Mtetra
0 0 .39 r
.72889 .55298 .72991 .55493 .73094 .55673 .72993 .55485 Mtetra
.856 .447 0 r
.72993 .55485 .73094 .55673 .73201 .55924 .731 .55745 Mtetra
.91 .511 .124 r
.731 .55745 .73201 .55924 .7331 .56211 .73209 .56043 Mtetra
.916 .518 .159 r
.73209 .56043 .7331 .56211 .73419 .56501 .73319 .56343 Mtetra
.906 .498 .132 r
.73319 .56343 .73419 .56501 .73528 .56767 .73428 .5662 Mtetra
.875 .445 .042 r
.73428 .5662 .73528 .56767 .73634 .56994 .73535 .56855 Mtetra
.786 .331 0 r
.73535 .56855 .73634 .56994 .73738 .57173 .73639 .57041 Mtetra
0 0 .442 r
.73639 .57041 .73738 .57173 .73839 .573 .7374 .57174 Mtetra
0 .222 .744 r
.7374 .57174 .73839 .573 .73938 .57377 .73839 .57255 Mtetra
.272 .45 .854 r
.73839 .57255 .73938 .57377 .74034 .57406 .73935 .57286 Mtetra
.492 .551 .845 r
.73935 .57286 .74034 .57406 .74128 .57389 .74029 .57269 Mtetra
.608 .592 .809 r
.74029 .57269 .74128 .57389 .74219 .57325 .7412 .57205 Mtetra
.674 .608 .774 r
.7412 .57205 .74219 .57325 .74308 .57215 .74209 .57092 Mtetra
.714 .614 .744 r
.74209 .57092 .74308 .57215 .74394 .57056 .74295 .56929 Mtetra
.739 .615 .72 r
.74295 .56929 .74394 .57056 .74477 .56847 .74378 .56714 Mtetra
.756 .614 .701 r
.74378 .56714 .74477 .56847 .74558 .56586 .74458 .56446 Mtetra
.766 .611 .687 r
.74458 .56446 .74558 .56586 .74636 .56277 .74535 .56128 Mtetra
.77 .608 .678 r
.74535 .56128 .74636 .56277 .74711 .55928 .7461 .55769 Mtetra
.77 .604 .673 r
.7461 .55769 .74711 .55928 .74785 .55556 .74684 .55387 Mtetra
.764 .598 .673 r
.74684 .55387 .74785 .55556 .7486 .55189 .74758 .55009 Mtetra
.749 .59 .679 r
.74758 .55009 .7486 .55189 .74936 .54859 .74834 .54669 Mtetra
.72 .577 .693 r
.74834 .54669 .74936 .54859 .75016 .54602 .74914 .54406 Mtetra
.66 .55 .719 r
.74914 .54406 .75016 .54602 .75103 .54449 .75 .54249 Mtetra
.514 .481 .758 r
.75 .54249 .75103 .54449 .75196 .54417 .75093 .54217 Mtetra
.103 .255 .735 r
.75093 .54217 .75196 .54417 .75297 .54504 .75194 .54308 Mtetra
0 0 .37 r
.75194 .54308 .75297 .54504 .75403 .54693 .75301 .54504 Mtetra
.856 .446 0 r
.75301 .54504 .75403 .54693 .75514 .54953 .75412 .54773 Mtetra
.908 .506 .115 r
.75412 .54773 .75514 .54953 .75627 .55246 .75525 .55077 Mtetra
.913 .512 .147 r
.75525 .55077 .75627 .55246 .7574 .55541 .75639 .55383 Mtetra
.902 .491 .117 r
.75639 .55383 .7574 .55541 .75852 .55812 .75751 .55663 Mtetra
.868 .436 .025 r
.75751 .55663 .75852 .55812 .75962 .56042 .75861 .55902 Mtetra
.775 .319 0 r
.75861 .55902 .75962 .56042 .76069 .56223 .75969 .5609 Mtetra
0 0 .454 r
.75969 .5609 .76069 .56223 .76173 .56352 .76073 .56225 Mtetra
0 .224 .745 r
.76073 .56225 .76173 .56352 .76274 .56431 .76175 .56308 Mtetra
.267 .448 .854 r
.76175 .56308 .76274 .56431 .76373 .56462 .76273 .5634 Mtetra
.487 .55 .846 r
.76273 .5634 .76373 .56462 .76468 .56445 .76369 .56324 Mtetra
.605 .591 .811 r
.76369 .56324 .76468 .56445 .76562 .56382 .76462 .56261 Mtetra
.672 .608 .775 r
.76462 .56261 .76562 .56382 .76652 .56272 .76552 .56148 Mtetra
.713 .615 .745 r
.76552 .56148 .76652 .56272 .76739 .56113 .7664 .55985 Mtetra
.739 .616 .721 r
.7664 .55985 .76739 .56113 .76824 .55903 .76723 .5577 Mtetra
.756 .615 .702 r
.76723 .5577 .76824 .55903 .76905 .55642 .76804 .555 Mtetra
.766 .612 .687 r
.76804 .555 .76905 .55642 .76983 .55331 .76882 .55181 Mtetra
.771 .608 .678 r
.76882 .55181 .76983 .55331 .77059 .54981 .76957 .54821 Mtetra
.77 .604 .673 r
.76957 .54821 .77059 .54981 .77133 .5461 .77031 .54439 Mtetra
.763 .598 .673 r
.77031 .54439 .77133 .5461 .77207 .54244 .77105 .54063 Mtetra
.748 .59 .68 r
.77105 .54063 .77207 .54244 .77284 .53918 .77181 .53727 Mtetra
.717 .575 .695 r
.77181 .53727 .77284 .53918 .77366 .53667 .77262 .53469 Mtetra
.652 .547 .723 r
.77262 .53469 .77366 .53667 .77454 .53522 .7735 .53321 Mtetra
.495 .472 .761 r
.7735 .53321 .77454 .53522 .7755 .535 .77446 .53298 Mtetra
.059 .229 .725 r
.77446 .53298 .7755 .535 .77654 .53597 .7755 .534 Mtetra
0 0 .35 r
.7755 .534 .77654 .53597 .77764 .53795 .7766 .53606 Mtetra
.855 .444 0 r
.7766 .53606 .77764 .53795 .77879 .54063 .77776 .53883 Mtetra
.905 .501 .106 r
.77776 .53883 .77879 .54063 .77996 .54363 .77893 .54194 Mtetra
.91 .506 .135 r
.77893 .54194 .77996 .54363 .78113 .54663 .78011 .54505 Mtetra
.898 .483 .104 r
.78011 .54505 .78113 .54663 .78229 .54938 .78127 .54789 Mtetra
.862 .427 .009 r
.78127 .54789 .78229 .54938 .78342 .55171 .78241 .55031 Mtetra
.765 .308 0 r
.78241 .55031 .78342 .55171 .78452 .55354 .78352 .55221 Mtetra
0 0 .464 r
.78352 .55221 .78452 .55354 .7856 .55485 .78459 .55358 Mtetra
0 .227 .747 r
.78459 .55358 .7856 .55485 .78664 .55566 .78564 .55442 Mtetra
.262 .448 .855 r
.78564 .55442 .78664 .55566 .78765 .55598 .78665 .55476 Mtetra
.483 .55 .848 r
.78665 .55476 .78765 .55598 .78863 .55583 .78763 .55461 Mtetra
.603 .592 .813 r
.78763 .55461 .78863 .55583 .78958 .5552 .78858 .55398 Mtetra
.671 .609 .777 r
.78858 .55398 .78958 .5552 .7905 .5541 .78949 .55286 Mtetra
.713 .616 .747 r
.78949 .55286 .7905 .5541 .79138 .55251 .79038 .55122 Mtetra
.74 .617 .722 r
.79038 .55122 .79138 .55251 .79224 .5504 .79123 .54905 Mtetra
.757 .615 .702 r
.79123 .54905 .79224 .5504 .79305 .54777 .79204 .54635 Mtetra
.767 .613 .687 r
.79204 .54635 .79305 .54777 .79384 .54465 .79282 .54314 Mtetra
.772 .609 .678 r
.79282 .54314 .79384 .54465 .7946 .54114 .79357 .53953 Mtetra
.771 .604 .673 r
.79357 .53953 .7946 .54114 .79534 .53742 .79431 .5357 Mtetra
.763 .598 .673 r
.79431 .5357 .79534 .53742 .79609 .53378 .79505 .53195 Mtetra
.747 .589 .681 r
.79505 .53195 .79609 .53378 .79687 .53055 .79582 .52863 Mtetra
.714 .575 .697 r
.79582 .52863 .79687 .53055 .7977 .5281 .79665 .52611 Mtetra
.644 .544 .726 r
.79665 .52611 .7977 .5281 .7986 .52673 .79755 .52471 Mtetra
.475 .463 .765 r
.79755 .52471 .7986 .52673 .79959 .5266 .79853 .52458 Mtetra
.016 .204 .714 r
.79853 .52458 .79959 .5266 .80066 .52767 .79961 .5257 Mtetra
0 0 .333 r
.79961 .5257 .80066 .52767 .8018 .52975 .80075 .52785 Mtetra
.854 .442 0 r
.80075 .52785 .8018 .52975 .80299 .5325 .80195 .5307 Mtetra
.902 .496 .097 r
.80195 .5307 .80299 .5325 .8042 .53557 .80317 .53388 Mtetra
.907 .5 .123 r
.80317 .53388 .8042 .53557 .80542 .53862 .80439 .53704 Mtetra
.893 .476 .09 r
.80439 .53704 .80542 .53862 .80661 .54141 .80559 .53992 Mtetra
.855 .417 0 r
.80559 .53992 .80661 .54141 .80778 .54376 .80677 .54237 Mtetra
.755 .296 0 r
.80677 .54237 .80778 .54376 .80892 .54562 .80791 .54429 Mtetra
0 0 .474 r
.80791 .54429 .80892 .54562 .81002 .54695 .80902 .54568 Mtetra
0 .23 .749 r
.80902 .54568 .81002 .54695 .81109 .54777 .81009 .54654 Mtetra
.259 .448 .857 r
.81009 .54654 .81109 .54777 .81213 .5481 .81112 .54689 Mtetra
.48 .551 .851 r
.81112 .54689 .81213 .5481 .81313 .54796 .81212 .54674 Mtetra
.601 .593 .816 r
.81212 .54674 .81313 .54796 .8141 .54734 .81309 .54611 Mtetra
.671 .611 .779 r
.81309 .54611 .8141 .54734 .81504 .54623 .81403 .54499 Mtetra
.713 .617 .748 r
.81403 .54499 .81504 .54623 .81594 .54463 .81492 .54334 Mtetra
.741 .618 .723 r
.81492 .54334 .81594 .54463 .8168 .54251 .81578 .54116 Mtetra
.758 .617 .702 r
.81578 .54116 .8168 .54251 .81762 .53986 .8166 .53843 Mtetra
.768 .614 .688 r
.8166 .53843 .81762 .53986 .81841 .53672 .81739 .5352 Mtetra
.772 .61 .678 r
.81739 .5352 .81841 .53672 .81918 .53319 .81814 .53157 Mtetra
.771 .605 .673 r
.81814 .53157 .81918 .53319 .81992 .52947 .81888 .52774 Mtetra
.763 .599 .674 r
.81888 .52774 .81992 .52947 .82067 .52584 .81963 .524 Mtetra
.746 .59 .682 r
.81963 .524 .82067 .52584 .82146 .52264 .8204 .52071 Mtetra
.711 .574 .699 r
.8204 .52071 .82146 .52264 .8223 .52025 .82124 .51825 Mtetra
.637 .541 .73 r
.82124 .51825 .8223 .52025 .82322 .51896 .82216 .51693 Mtetra
.454 .453 .768 r
.82216 .51693 .82322 .51896 .82424 .51892 .82318 .51689 Mtetra
0 .179 .702 r
.82318 .51689 .82424 .51892 .82535 .52008 .82429 .51811 Mtetra
.639 .249 0 r
.82429 .51811 .82535 .52008 .82653 .52225 .82547 .52035 Mtetra
.853 .439 0 r
.82547 .52035 .82653 .52225 .82776 .52509 .82671 .52329 Mtetra
.898 .49 .088 r
.82671 .52329 .82776 .52509 .82902 .52822 .82798 .52653 Mtetra
.903 .493 .111 r
.82798 .52653 .82902 .52822 .83028 .53132 .82925 .52974 Mtetra
.888 .467 .075 r
.82925 .52974 .83028 .53132 .83152 .53414 .83049 .53266 Mtetra
.848 .406 0 r
.83049 .53266 .83152 .53414 .83273 .53652 .83171 .53513 Mtetra
.744 .284 0 r
.83171 .53513 .83273 .53652 .8339 .5384 .83289 .53707 Mtetra
0 0 .486 r
.83289 .53707 .8339 .5384 .83504 .53975 .83402 .53847 Mtetra
0 .235 .753 r
.83402 .53847 .83504 .53975 .83614 .54058 .83512 .53934 Mtetra
.257 .45 .859 r
.83512 .53934 .83614 .54058 .8372 .54091 .83619 .5397 Mtetra
.478 .552 .854 r
.83619 .5397 .8372 .54091 .83822 .54077 .83721 .53956 Mtetra
.6 .595 .818 r
.83721 .53956 .83822 .54077 .83921 .54015 .8382 .53893 Mtetra
.671 .613 .781 r
.8382 .53893 .83921 .54015 .84017 .53904 .83915 .53779 Mtetra
.714 .619 .749 r
.83915 .53779 .84017 .53904 .84108 .53742 .84006 .53613 Mtetra
.742 .62 .723 r
.84006 .53613 .84108 .53742 .84195 .53528 .84093 .53393 Mtetra
.759 .618 .703 r
.84093 .53393 .84195 .53528 .84279 .53261 .84176 .53118 Mtetra
.769 .615 .688 r
.84176 .53118 .84279 .53261 .84358 .52945 .84254 .52792 Mtetra
.774 .611 .678 r
.84254 .52792 .84358 .52945 .84434 .5259 .8433 .52427 Mtetra
.772 .606 .673 r
.8433 .52427 .84434 .5259 .84509 .52217 .84404 .52043 Mtetra
.764 .599 .674 r
.84404 .52043 .84509 .52217 .84585 .51854 .84479 .51669 Mtetra
.745 .59 .683 r
.84479 .51669 .84585 .51854 .84664 .51537 .84557 .51343 Mtetra
.708 .573 .701 r
.84557 .51343 .84664 .51537 .8475 .51304 .84643 .51103 Mtetra
.629 .538 .733 r
.84643 .51103 .8475 .51304 .84844 .51182 .84737 .50978 Mtetra
.433 .444 .771 r
.84737 .50978 .84844 .51182 .84949 .51186 .84842 .50983 Mtetra
0 .156 .689 r
.84842 .50983 .84949 .51186 .85064 .51313 .84956 .51115 Mtetra
.652 .257 0 r
.84956 .51115 .85064 .51313 .85186 .51538 .8508 .51348 Mtetra
.851 .436 0 r
.8508 .51348 .85186 .51538 .85314 .51829 .85208 .51649 Mtetra
.894 .484 .078 r
.85208 .51649 .85314 .51829 .85445 .52148 .8534 .5198 Mtetra
.898 .485 .098 r
.8534 .5198 .85445 .52148 .85575 .52463 .85471 .52305 Mtetra
.883 .458 .06 r
.85471 .52305 .85575 .52463 .85704 .52748 .856 .52601 Mtetra
.839 .395 0 r
.856 .52601 .85704 .52748 .85829 .52989 .85726 .5285 Mtetra
.733 .27 0 r
.85726 .5285 .85829 .52989 .8595 .53178 .85847 .53046 Mtetra
0 0 .498 r
.85847 .53046 .8595 .53178 .86067 .53314 .85964 .53188 Mtetra
0 .242 .757 r
.85964 .53188 .86067 .53314 .86179 .53398 .86077 .53275 Mtetra
.257 .453 .861 r
.86077 .53275 .86179 .53398 .86288 .53432 .86186 .53311 Mtetra
.477 .555 .856 r
.86186 .53311 .86288 .53432 .86393 .53418 .86291 .53297 Mtetra
.601 .598 .821 r
.86291 .53297 .86393 .53418 .86494 .53355 .86392 .53233 Mtetra
.672 .615 .783 r
.86392 .53233 .86494 .53355 .86591 .53243 .86489 .53118 Mtetra
.716 .621 .751 r
.86489 .53118 .86591 .53243 .86684 .5308 .86581 .5295 Mtetra
.744 .622 .724 r
.86581 .5295 .86684 .5308 .86772 .52863 .86669 .52728 Mtetra
.761 .62 .703 r
.86669 .52728 .86772 .52863 .86856 .52593 .86753 .5245 Mtetra
.771 .616 .687 r
.86753 .5245 .86856 .52593 .86936 .52274 .86832 .52121 Mtetra
.775 .612 .677 r
.86832 .52121 .86936 .52274 .87013 .51917 .86907 .51753 Mtetra
.773 .607 .673 r
.86907 .51753 .87013 .51917 .87088 .51542 .86982 .51367 Mtetra
.764 .6 .674 r
.86982 .51367 .87088 .51542 .87164 .51179 .87057 .50993 Mtetra
.745 .59 .684 r
.87057 .50993 .87164 .51179 .87244 .50865 .87136 .5067 Mtetra
.705 .573 .703 r
.87136 .5067 .87244 .50865 .87331 .50636 .87223 .50435 Mtetra
.621 .536 .737 r
.87223 .50435 .87331 .50636 .87428 .50522 .87319 .50317 Mtetra
.412 .434 .773 r
.87319 .50317 .87428 .50522 .87536 .50535 .87427 .50332 Mtetra
0 .135 .676 r
.87427 .50332 .87536 .50535 .87655 .5067 .87546 .50472 Mtetra
.661 .263 0 r
.87546 .50472 .87655 .5067 .87782 .50905 .87674 .50715 Mtetra
.847 .431 0 r
.87674 .50715 .87782 .50905 .87915 .51203 .87808 .51023 Mtetra
.89 .477 .066 r
.87808 .51023 .87915 .51203 .8805 .51528 .87944 .5136 Mtetra
.893 .477 .084 r
.87944 .5136 .8805 .51528 .88186 .51847 .8808 .5169 Mtetra
.876 .448 .044 r
.8808 .5169 .88186 .51847 .88318 .52135 .88214 .51988 Mtetra
.83 .383 0 r
.88214 .51988 .88318 .52135 .88448 .52378 .88344 .5224 Mtetra
.719 .255 0 r
.88344 .5224 .88448 .52378 .88572 .52569 .88469 .52437 Mtetra
0 0 .512 r
.88469 .52437 .88572 .52569 .88693 .52705 .8859 .52579 Mtetra
0 .251 .763 r
.8859 .52579 .88693 .52705 .88808 .5279 .88706 .52667 Mtetra
.259 .457 .864 r
.88706 .52667 .88808 .5279 .8892 .52824 .88818 .52703 Mtetra
.478 .558 .859 r
.88818 .52703 .8892 .52824 .89027 .52809 .88925 .52688 Mtetra
.602 .601 .823 r
.88925 .52688 .89027 .52809 .89131 .52745 .89028 .52623 Mtetra
.673 .618 .785 r
.89028 .52623 .89131 .52745 .89229 .52631 .89127 .52507 Mtetra
.718 .624 .752 r
.89127 .52507 .89229 .52631 .89324 .52466 .8922 .52337 Mtetra
.745 .624 .724 r
.8922 .52337 .89324 .52466 .89413 .52246 .89309 .52111 Mtetra
.763 .621 .703 r
.89309 .52111 .89413 .52246 .89498 .51973 .89393 .51829 Mtetra
.773 .618 .687 r
.89393 .51829 .89498 .51973 .89578 .5165 .89473 .51497 Mtetra
.777 .613 .677 r
.89473 .51497 .89578 .5165 .89655 .5129 .89549 .51126 Mtetra
.774 .608 .673 r
.89549 .51126 .89655 .5129 .8973 .50913 .89623 .50737 Mtetra
.765 .601 .675 r
.89623 .50737 .8973 .50913 .89806 .5055 .89698 .50364 Mtetra
.744 .59 .685 r
.89698 .50364 .89806 .5055 .89887 .50238 .89778 .50043 Mtetra
.702 .572 .706 r
.89778 .50043 .89887 .50238 .89976 .50014 .89867 .49812 Mtetra
.612 .533 .741 r
.89867 .49812 .89976 .50014 .90076 .49907 .89966 .49702 Mtetra
.39 .424 .776 r
.89966 .49702 .90076 .49907 .90187 .49928 .90078 .49725 Mtetra
0 .115 .664 r
.90078 .49725 .90187 .49928 .9031 .50073 .90201 .49875 Mtetra
.667 .266 0 r
.90201 .49875 .9031 .50073 .90442 .50315 .90333 .50126 Mtetra
.843 .425 0 r
.90333 .50126 .90442 .50315 .9058 .50621 .90472 .50442 Mtetra
.885 .469 .053 r
.90472 .50442 .9058 .50621 .90721 .50951 .90614 .50784 Mtetra
.887 .468 .068 r
.90614 .50784 .90721 .50951 .90861 .51274 .90755 .51118 Mtetra
.869 .437 .026 r
.90755 .51118 .90861 .51274 .90999 .51565 .90893 .51419 Mtetra
.82 .369 0 r
.90893 .51419 .90999 .51565 .91132 .5181 .91028 .51672 Mtetra
.704 .239 0 r
.91028 .51672 .91132 .5181 .91261 .52001 .91157 .51871 Mtetra
0 0 .528 r
.91157 .51871 .91261 .52001 .91385 .52139 .91281 .52013 Mtetra
0 .261 .77 r
.91281 .52013 .91385 .52139 .91504 .52223 .91401 .52101 Mtetra
.263 .463 .867 r
.91401 .52101 .91504 .52223 .91618 .52256 .91515 .52136 Mtetra
.48 .562 .861 r
.91515 .52136 .91618 .52256 .91728 .52241 .91625 .52121 Mtetra
.603 .604 .825 r
.91625 .52121 .91728 .52241 .91833 .52175 .9173 .52054 Mtetra
.675 .621 .787 r
.9173 .52054 .91833 .52175 .91934 .5206 .91831 .51935 Mtetra
.72 .626 .753 r
.91831 .51935 .91934 .5206 .9203 .51891 .91926 .51762 Mtetra
.748 .626 .725 r
.91926 .51762 .9203 .51891 .9212 .51668 .92016 .51533 Mtetra
.765 .623 .703 r
.92016 .51533 .9212 .51668 .92206 .51391 .921 .51247 Mtetra
.775 .619 .687 r
.921 .51247 .92206 .51391 .92286 .51064 .9218 .50911 Mtetra
.778 .615 .677 r
.9218 .50911 .92286 .51064 .92363 .50701 .92256 .50536 Mtetra
.776 .609 .673 r
.92256 .50536 .92363 .50701 .92438 .50321 .9233 .50145 Mtetra
.765 .602 .675 r
.9233 .50145 .92438 .50321 .92515 .49958 .92406 .49771 Mtetra
.743 .591 .686 r
.92406 .49771 .92515 .49958 .92597 .49648 .92487 .49451 Mtetra
.699 .572 .708 r
.92487 .49451 .92597 .49648 .92688 .49429 .92577 .49226 Mtetra
.604 .53 .745 r
.92577 .49226 .92688 .49429 .9279 .49328 .92679 .49122 Mtetra
.369 .414 .778 r
.92679 .49122 .9279 .49328 .92905 .49358 .92794 .49154 Mtetra
0 .098 .653 r
.92794 .49154 .92905 .49358 .93033 .49511 .92922 .49312 Mtetra
.671 .267 0 r
.92922 .49312 .93033 .49511 .9317 .49761 .9306 .49572 Mtetra
.838 .418 0 r
.9306 .49572 .9317 .49761 .93313 .50073 .93204 .49895 Mtetra
.879 .46 .039 r
.93204 .49895 .93313 .50073 .93459 .50409 .93351 .50242 Mtetra
.881 .458 .051 r
.93351 .50242 .93459 .50409 .93604 .50736 .93498 .5058 Mtetra
.861 .426 .007 r
.93498 .5058 .93604 .50736 .93747 .5103 .93641 .50884 Mtetra
.808 .355 0 r
.93641 .50884 .93747 .5103 .93885 .51276 .93779 .51139 Mtetra
.688 .221 0 r
.93779 .51139 .93885 .51276 .94017 .51468 .93913 .51338 Mtetra
0 .004 .546 r
.93913 .51338 .94017 .51468 .94145 .51605 .94041 .5148 Mtetra
0 .273 .778 r
.94041 .5148 .94145 .51605 .94267 .51689 .94163 .51568 Mtetra
.269 .469 .87 r
.94163 .51568 .94267 .51689 .94385 .51722 .94281 .51602 Mtetra
.483 .566 .864 r
.94281 .51602 .94385 .51722 .94497 .51705 .94393 .51585 Mtetra
.606 .608 .827 r
.94393 .51585 .94497 .51705 .94605 .51638 .94501 .51517 Mtetra
.678 .624 .788 r
.94501 .51517 .94605 .51638 .94707 .5152 .94603 .51395 Mtetra
.722 .629 .753 r
.94603 .51395 .94707 .5152 .94804 .51348 .947 .51219 Mtetra
.75 .628 .725 r
.947 .51219 .94804 .51348 .94896 .51121 .94791 .50986 Mtetra
.767 .625 .703 r
.94791 .50986 .94896 .51121 .94982 .5084 .94876 .50696 Mtetra
.777 .621 .686 r
.94876 .50696 .94982 .5084 .95063 .50509 .94956 .50354 Mtetra
.78 .616 .676 r
.94956 .50354 .95063 .50509 .9514 .50141 .95032 .49975 Mtetra
.777 .61 .672 r
.95032 .49975 .9514 .50141 .95215 .49759 .95106 .49582 Mtetra
.766 .602 .675 r
.95106 .49582 .95215 .49759 .95293 .49395 .95182 .49206 Mtetra
.743 .591 .687 r
.95182 .49206 .95293 .49395 .95376 .49086 .95264 .48889 Mtetra
.696 .571 .711 r
.95264 .48889 .95376 .49086 .95468 .48871 .95356 .48667 Mtetra
.595 .527 .748 r
.95356 .48667 .95468 .48871 .95573 .48777 .95461 .48571 Mtetra
.347 .405 .779 r
.95461 .48571 .95573 .48777 .95692 .48815 .9558 .48611 Mtetra
0 .083 .642 r
.9558 .48611 .95692 .48815 .95824 .48976 .95713 .48778 Mtetra
.671 .266 0 r
.95713 .48778 .95824 .48976 .95967 .49235 .95856 .49045 Mtetra
.832 .41 0 r
.95856 .49045 .95967 .49235 .96116 .49554 .96006 .49375 Mtetra
.872 .45 .023 r
.96006 .49375 .96116 .49554 .96267 .49895 .96158 .49728 Mtetra
.874 .447 .033 r
.96158 .49728 .96267 .49895 .96418 .50225 .9631 .50069 Mtetra
.852 .413 0 r
.9631 .50069 .96418 .50225 .96565 .5052 .96458 .50375 Mtetra
.795 .338 0 r
.96458 .50375 .96565 .5052 .96708 .50768 .96602 .50631 Mtetra
.669 .201 0 r
.96602 .50631 .96708 .50768 .96844 .5096 .96739 .50831 Mtetra
0 .023 .565 r
.96739 .50831 .96844 .5096 .96976 .51098 .96871 .50973 Mtetra
0 .286 .787 r
.96871 .50973 .96976 .51098 .97102 .51181 .96997 .5106 Mtetra
.277 .476 .873 r
.96997 .5106 .97102 .51181 .97222 .51213 .97118 .51093 Mtetra
.487 .571 .866 r
.97118 .51093 .97222 .51213 .97337 .51194 .97233 .51075 Mtetra
.608 .611 .829 r
.97233 .51075 .97337 .51194 .97447 .51125 .97342 .51004 Mtetra
.68 .627 .789 r
.97342 .51004 .97447 .51125 .97551 .51004 .97446 .50879 Mtetra
.725 .631 .754 r
.97446 .50879 .97551 .51004 .9765 .50829 .97544 .50699 Mtetra
.753 .63 .725 r
.97544 .50699 .9765 .50829 .97742 .50598 .97636 .50461 Mtetra
.77 .627 .702 r
.97636 .50461 .97742 .50598 .97829 .50311 .97722 .50166 Mtetra
.779 .623 .686 r
.97722 .50166 .97829 .50311 .9791 .49975 .97802 .4982 Mtetra
.782 .617 .676 r
.97802 .4982 .9791 .49975 .97987 .49603 .97878 .49436 Mtetra
.779 .611 .672 r
.97878 .49436 .97987 .49603 .98063 .49218 .97952 .49039 Mtetra
.767 .603 .676 r
.97952 .49039 .98063 .49218 .98141 .48852 .98029 .48663 Mtetra
.742 .592 .688 r
.98029 .48663 .98141 .48852 .98225 .48545 .98112 .48347 Mtetra
.693 .571 .713 r
.98112 .48347 .98225 .48545 .98319 .48334 .98206 .4813 Mtetra
.586 .524 .752 r
.98206 .4813 .98319 .48334 .98428 .48247 .98314 .4804 Mtetra
.442 .389 .704 r
.51939 .68232 .52033 .68524 .5211 .68524 .52016 .68237 Mtetra
.058 .146 .642 r
.52016 .68237 .5211 .68524 .52187 .68635 .52094 .68358 Mtetra
0 0 .326 r
.52094 .68358 .52187 .68635 .52266 .68832 .52172 .6857 Mtetra
.856 .507 0 r
.52172 .6857 .52266 .68832 .52344 .69081 .52251 .68838 Mtetra
.922 .563 .126 r
.52251 .68838 .52344 .69081 .52423 .69347 .5233 .69125 Mtetra
.928 .561 .147 r
.5233 .69125 .52423 .69347 .52503 .69603 .52409 .694 Mtetra
.907 .525 .091 r
.52409 .694 .52503 .69603 .52582 .69827 .52488 .69642 Mtetra
.833 .433 0 r
.52488 .69642 .52582 .69827 .5266 .70006 .52567 .69836 Mtetra
0 0 .351 r
.52567 .69836 .5266 .70006 .52739 .70136 .52646 .69978 Mtetra
0 .122 .672 r
.52646 .69978 .52739 .70136 .52817 .70217 .52724 .70067 Mtetra
.256 .382 .8 r
.52724 .70067 .52817 .70217 .52895 .70249 .52802 .70104 Mtetra
.481 .501 .801 r
.52802 .70104 .52895 .70249 .52973 .70235 .5288 .70093 Mtetra
.595 .551 .775 r
.5288 .70093 .52973 .70235 .5305 .70175 .52957 .70033 Mtetra
.658 .573 .748 r
.52957 .70033 .5305 .70175 .53127 .70071 .53034 .69926 Mtetra
.695 .583 .726 r
.53034 .69926 .53127 .70071 .53204 .69919 .5311 .69769 Mtetra
.718 .587 .707 r
.5311 .69769 .53204 .69919 .5328 .6972 .53186 .6956 Mtetra
.733 .587 .693 r
.53186 .6956 .5328 .6972 .53356 .6947 .53262 .69298 Mtetra
.742 .586 .681 r
.53262 .69298 .53356 .6947 .53431 .69171 .53337 .68984 Mtetra
.746 .583 .673 r
.53337 .68984 .53431 .69171 .53506 .68828 .53412 .68623 Mtetra
.745 .578 .668 r
.53412 .68623 .53506 .68828 .5358 .68454 .53486 .68229 Mtetra
.74 .572 .666 r
.53486 .68229 .5358 .68454 .53655 .68069 .5356 .67823 Mtetra
.728 .562 .666 r
.5356 .67823 .53655 .68069 .53729 .67704 .53635 .67439 Mtetra
.707 .548 .671 r
.53635 .67439 .53729 .67704 .53804 .67393 .53709 .67112 Mtetra
.668 .525 .68 r
.53709 .67112 .53804 .67393 .5388 .67169 .53785 .66878 Mtetra
.593 .48 .694 r
.53785 .66878 .5388 .67169 .53957 .67057 .53862 .66762 Mtetra
.43 .381 .703 r
.53862 .66762 .53957 .67057 .54035 .67064 .5394 .66773 Mtetra
.041 .135 .637 r
.5394 .66773 .54035 .67064 .54114 .6718 .5402 .669 Mtetra
0 0 .33 r
.5402 .669 .54114 .6718 .54195 .67382 .541 .67118 Mtetra
.845 .496 0 r
.541 .67118 .54195 .67382 .54276 .67634 .54182 .67389 Mtetra
.913 .552 .103 r
.54182 .67389 .54276 .67634 .54358 .67902 .54263 .67678 Mtetra
.919 .55 .121 r
.54263 .67678 .54358 .67902 .54439 .68158 .54345 .67954 Mtetra
.894 .51 .059 r
.54345 .67954 .54439 .68158 .54521 .68381 .54427 .68194 Mtetra
.807 .408 0 r
.54427 .68194 .54521 .68381 .54602 .6856 .54508 .68387 Mtetra
0 0 .394 r
.54508 .68387 .54602 .6856 .54682 .68688 .54588 .68528 Mtetra
0 .149 .69 r
.54588 .68528 .54682 .68688 .54762 .68767 .54668 .68615 Mtetra
.274 .391 .8 r
.54668 .68615 .54762 .68767 .54842 .68798 .54748 .68651 Mtetra
.486 .502 .799 r
.54748 .68651 .54842 .68798 .54921 .68782 .54827 .68637 Mtetra
.596 .55 .773 r
.54827 .68637 .54921 .68782 .54999 .6872 .54905 .68576 Mtetra
.657 .572 .747 r
.54905 .68576 .54999 .6872 .55077 .68613 .54983 .68466 Mtetra
.694 .582 .725 r
.54983 .68466 .55077 .68613 .55155 .6846 .55061 .68306 Mtetra
.718 .586 .707 r
.55061 .68306 .55155 .6846 .55231 .68257 .55137 .68094 Mtetra
.732 .586 .692 r
.55137 .68094 .55231 .68257 .55308 .68005 .55213 .67829 Mtetra
.741 .585 .681 r
.55213 .67829 .55308 .68005 .55383 .67703 .55288 .67512 Mtetra
.745 .582 .673 r
.55288 .67512 .55383 .67703 .55458 .67357 .55363 .67148 Mtetra
.745 .577 .667 r
.55363 .67148 .55458 .67357 .55532 .6698 .55437 .66751 Mtetra
.739 .571 .665 r
.55437 .66751 .55532 .6698 .55606 .66595 .55511 .66345 Mtetra
.727 .561 .666 r
.55511 .66345 .55606 .66595 .5568 .6623 .55585 .65961 Mtetra
.704 .546 .671 r
.55585 .65961 .5568 .6623 .55755 .65922 .5566 .65637 Mtetra
.664 .522 .68 r
.5566 .65637 .55755 .65922 .55832 .65703 .55736 .65408 Mtetra
.586 .475 .694 r
.55736 .65408 .55832 .65703 .5591 .65597 .55814 .65299 Mtetra
.416 .373 .702 r
.55814 .65299 .5591 .65597 .5599 .6561 .55894 .65317 Mtetra
.025 .125 .632 r
.55894 .65317 .5599 .6561 .56071 .65733 .55975 .65451 Mtetra
0 0 .334 r
.55975 .65451 .56071 .65733 .56154 .6594 .56058 .65673 Mtetra
.833 .485 0 r
.56058 .65673 .56154 .6594 .56238 .66195 .56142 .65948 Mtetra
.903 .542 .08 r
.56142 .65948 .56238 .66195 .56322 .66466 .56227 .66239 Mtetra
.909 .538 .095 r
.56227 .66239 .56322 .66466 .56406 .66722 .56311 .66516 Mtetra
.879 .494 .026 r
.56311 .66516 .56406 .66722 .5649 .66945 .56395 .66756 Mtetra
.78 .383 0 r
.56395 .66756 .5649 .66945 .56573 .67123 .56478 .66948 Mtetra
0 0 .433 r
.56478 .66948 .56573 .67123 .56656 .6725 .56561 .67087 Mtetra
0 .173 .705 r
.56561 .67087 .56656 .6725 .56738 .67328 .56643 .67173 Mtetra
.289 .397 .799 r
.56643 .67173 .56738 .67328 .56819 .67357 .56724 .67207 Mtetra
.49 .502 .796 r
.56724 .67207 .56819 .67357 .56899 .67339 .56805 .67192 Mtetra
.597 .549 .771 r
.56805 .67192 .56899 .67339 .56979 .67276 .56884 .67129 Mtetra
.657 .57 .746 r
.56884 .67129 .56979 .67276 .57058 .67167 .56963 .67017 Mtetra
.694 .58 .724 r
.56963 .67017 .57058 .67167 .57136 .67012 .57041 .66854 Mtetra
.717 .584 .706 r
.57041 .66854 .57136 .67012 .57213 .66807 .57118 .6664 Mtetra
.732 .585 .691 r
.57118 .6664 .57213 .66807 .5729 .66551 .57195 .66372 Mtetra
.741 .584 .68 r
.57195 .66372 .5729 .66551 .57365 .66246 .5727 .66051 Mtetra
.745 .581 .672 r
.5727 .66051 .57365 .66246 .5744 .65898 .57344 .65684 Mtetra
.744 .576 .667 r
.57344 .65684 .5744 .65898 .57514 .65519 .57418 .65286 Mtetra
.738 .569 .665 r
.57418 .65286 .57514 .65519 .57588 .65133 .57492 .64879 Mtetra
.725 .559 .666 r
.57492 .64879 .57588 .65133 .57662 .6477 .57565 .64497 Mtetra
.702 .544 .671 r
.57565 .64497 .57662 .6477 .57738 .64465 .5764 .64176 Mtetra
.66 .519 .681 r
.5764 .64176 .57738 .64465 .57815 .64251 .57717 .63952 Mtetra
.578 .47 .695 r
.57717 .63952 .57815 .64251 .57894 .64151 .57796 .6385 Mtetra
.402 .364 .701 r
.57796 .6385 .57894 .64151 .57975 .64172 .57878 .63875 Mtetra
.008 .114 .626 r
.57878 .63875 .57975 .64172 .58059 .64301 .57962 .64016 Mtetra
0 0 .337 r
.57962 .64016 .58059 .64301 .58144 .64513 .58047 .64244 Mtetra
.821 .474 0 r
.58047 .64244 .58144 .64513 .58231 .64772 .58134 .64523 Mtetra
.893 .53 .057 r
.58134 .64523 .58231 .64772 .58318 .65045 .58221 .64816 Mtetra
.898 .525 .068 r
.58221 .64816 .58318 .65045 .58405 .65303 .58309 .65094 Mtetra
.862 .476 0 r
.58309 .65094 .58405 .65303 .58491 .65526 .58395 .65334 Mtetra
.75 .357 0 r
.58395 .65334 .58491 .65526 .58577 .65703 .58481 .65526 Mtetra
0 0 .468 r
.58481 .65526 .58577 .65703 .58661 .6583 .58566 .65664 Mtetra
0 .192 .716 r
.58566 .65664 .58661 .6583 .58745 .65906 .58649 .65749 Mtetra
.302 .402 .798 r
.58649 .65749 .58745 .65906 .58827 .65934 .58732 .65782 Mtetra
.493 .501 .794 r
.58732 .65782 .58827 .65934 .58909 .65915 .58814 .65765 Mtetra
.597 .547 .77 r
.58814 .65765 .58909 .65915 .5899 .65851 .58895 .657 Mtetra
.656 .569 .745 r
.58895 .657 .5899 .65851 .5907 .6574 .58975 .65586 Mtetra
.693 .579 .723 r
.58975 .65586 .5907 .6574 .59149 .65582 .59054 .65422 Mtetra
.716 .583 .705 r
.59054 .65422 .59149 .65582 .59227 .65375 .59131 .65205 Mtetra
.731 .584 .691 r
.59131 .65205 .59227 .65375 .59304 .65117 .59208 .64934 Mtetra
.74 .583 .679 r
.59208 .64934 .59304 .65117 .5938 .64809 .59283 .64611 Mtetra
.744 .58 .671 r
.59283 .64611 .5938 .64809 .59454 .64459 .59357 .64241 Mtetra
.743 .575 .666 r
.59357 .64241 .59454 .64459 .59528 .64079 .59431 .63841 Mtetra
.737 .568 .664 r
.59431 .63841 .59528 .64079 .59602 .63692 .59504 .63434 Mtetra
.723 .558 .666 r
.59504 .63434 .59602 .63692 .59676 .63331 .59578 .63053 Mtetra
.699 .542 .671 r
.59578 .63053 .59676 .63331 .59752 .6303 .59653 .62736 Mtetra
.655 .515 .681 r
.59653 .62736 .59752 .6303 .59829 .62821 .59731 .62519 Mtetra
.57 .465 .695 r
.59731 .62519 .59829 .62821 .5991 .62729 .59811 .62423 Mtetra
.388 .355 .7 r
.59811 .62423 .5991 .62729 .59993 .62756 .59894 .62456 Mtetra
0 .102 .621 r
.59894 .62456 .59993 .62756 .60079 .62893 .59981 .62604 Mtetra
0 0 .34 r
.59981 .62604 .60079 .62893 .60167 .6311 .60069 .62839 Mtetra
.809 .463 0 r
.60069 .62839 .60167 .6311 .60257 .63373 .60159 .63122 Mtetra
.881 .519 .035 r
.60159 .63122 .60257 .63373 .60346 .63649 .60249 .63418 Mtetra
.886 .512 .041 r
.60249 .63418 .60346 .63649 .60436 .63908 .60339 .63696 Mtetra
.844 .459 0 r
.60339 .63696 .60436 .63908 .60525 .64131 .60428 .63937 Mtetra
.72 .331 0 r
.60428 .63937 .60525 .64131 .60613 .64308 .60516 .64129 Mtetra
0 0 .498 r
.60516 .64129 .60613 .64308 .60699 .64435 .60603 .64266 Mtetra
0 .208 .724 r
.60603 .64266 .60699 .64435 .60785 .64511 .60689 .6435 Mtetra
.311 .405 .797 r
.60689 .6435 .60785 .64511 .60869 .64538 .60773 .64383 Mtetra
.495 .501 .792 r
.60773 .64383 .60869 .64538 .60953 .64518 .60857 .64365 Mtetra
.596 .545 .768 r
.60857 .64365 .60953 .64518 .61035 .64453 .60939 .64299 Mtetra
.655 .567 .744 r
.60939 .64299 .61035 .64453 .61116 .64341 .6102 .64183 Mtetra
.692 .577 .722 r
.6102 .64183 .61116 .64341 .61196 .64181 .61099 .64017 Mtetra
.715 .582 .704 r
.61099 .64017 .61196 .64181 .61274 .63972 .61178 .63798 Mtetra
.73 .583 .69 r
.61178 .63798 .61274 .63972 .61351 .63712 .61254 .63525 Mtetra
.739 .582 .679 r
.61254 .63525 .61351 .63712 .61427 .63402 .6133 .63199 Mtetra
.743 .579 .671 r
.6133 .63199 .61427 .63402 .61502 .63049 .61404 .62827 Mtetra
.742 .574 .666 r
.61404 .62827 .61502 .63049 .61576 .62668 .61477 .62426 Mtetra
.735 .567 .664 r
.61477 .62426 .61576 .62668 .61649 .62282 .6155 .62019 Mtetra
.721 .556 .666 r
.6155 .62019 .61649 .62282 .61724 .61922 .61624 .6164 Mtetra
.696 .54 .671 r
.61624 .6164 .61724 .61922 .61799 .61625 .617 .61328 Mtetra
.65 .512 .682 r
.617 .61328 .61799 .61625 .61878 .61423 .61778 .61116 Mtetra
.561 .459 .696 r
.61778 .61116 .61878 .61423 .6196 .61338 .6186 .61029 Mtetra
.372 .345 .699 r
.6186 .61029 .6196 .61338 .62045 .61373 .61945 .6107 Mtetra
0 .091 .615 r
.61945 .6107 .62045 .61373 .62134 .61517 .62034 .61226 Mtetra
0 0 .343 r
.62034 .61226 .62134 .61517 .62224 .6174 .62125 .61466 Mtetra
.797 .452 0 r
.62125 .61466 .62224 .6174 .62317 .62008 .62218 .61754 Mtetra
.87 .507 .013 r
.62218 .61754 .62317 .62008 .62409 .62287 .62311 .62053 Mtetra
.873 .498 .015 r
.62311 .62053 .62409 .62287 .62502 .62548 .62404 .62334 Mtetra
.826 .441 0 r
.62404 .62334 .62502 .62548 .62593 .62772 .62496 .62575 Mtetra
.69 .307 0 r
.62496 .62575 .62593 .62772 .62684 .62949 .62586 .62767 Mtetra
0 0 .523 r
.62586 .62767 .62684 .62949 .62773 .63075 .62675 .62905 Mtetra
.01 .221 .73 r
.62675 .62905 .62773 .63075 .6286 .63151 .62763 .62988 Mtetra
.318 .407 .796 r
.62763 .62988 .6286 .63151 .62946 .63178 .62849 .6302 Mtetra
.495 .499 .79 r
.62849 .6302 .62946 .63178 .63031 .63158 .62934 .63002 Mtetra
.595 .544 .767 r
.62934 .63002 .63031 .63158 .63115 .63092 .63018 .62935 Mtetra
.653 .565 .743 r
.63018 .62935 .63115 .63092 .63197 .62979 .631 .62819 Mtetra
.69 .576 .722 r
.631 .62819 .63197 .62979 .63277 .62819 .6318 .62651 Mtetra
.714 .581 .704 r
.6318 .62651 .63277 .62819 .63357 .62608 .63259 .6243 Mtetra
.729 .582 .69 r
.63259 .6243 .63357 .62608 .63434 .62345 .63336 .62155 Mtetra
.738 .581 .678 r
.63336 .62155 .63434 .62345 .6351 .62034 .63412 .61826 Mtetra
.742 .577 .67 r
.63412 .61826 .6351 .62034 .63585 .61679 .63486 .61453 Mtetra
.741 .573 .665 r
.63486 .61453 .63585 .61679 .63658 .61297 .63559 .6105 Mtetra
.734 .565 .664 r
.63559 .6105 .63658 .61297 .63732 .60912 .63632 .60644 Mtetra
.719 .554 .666 r
.63632 .60644 .63732 .60912 .63806 .60555 .63705 .60268 Mtetra
.692 .537 .672 r
.63705 .60268 .63806 .60555 .63883 .60262 .63781 .5996 Mtetra
.644 .508 .682 r
.63781 .5996 .63883 .60262 .63962 .60066 .6386 .59756 Mtetra
.551 .453 .696 r
.6386 .59756 .63962 .60066 .64045 .59989 .63944 .59676 Mtetra
.355 .334 .697 r
.63944 .59676 .64045 .59989 .64133 .60033 .64031 .59726 Mtetra
0 .078 .608 r
.64031 .59726 .64133 .60033 .64224 .60184 .64122 .5989 Mtetra
0 0 .344 r
.64122 .5989 .64224 .60184 .64318 .60414 .64217 .60137 Mtetra
.786 .442 0 r
.64217 .60137 .64318 .60414 .64413 .60687 .64313 .60431 Mtetra
.858 .495 0 r
.64313 .60431 .64413 .60687 .64509 .60969 .64409 .60733 Mtetra
.859 .485 0 r
.64409 .60733 .64509 .60969 .64604 .61232 .64505 .61016 Mtetra
.807 .423 0 r
.64505 .61016 .64604 .61232 .64698 .61458 .646 .61259 Mtetra
.662 .283 0 r
.646 .61259 .64698 .61458 .64791 .61636 .64693 .61451 Mtetra
0 0 .543 r
.64693 .61451 .64791 .61636 .64883 .61763 .64784 .61589 Mtetra
.028 .231 .735 r
.64784 .61589 .64883 .61763 .64972 .61839 .64874 .61673 Mtetra
.322 .408 .795 r
.64874 .61673 .64972 .61839 .6506 .61866 .64962 .61705 Mtetra
.495 .498 .789 r
.64962 .61705 .6506 .61866 .65147 .61846 .65049 .61687 Mtetra
.593 .542 .767 r
.65049 .61687 .65147 .61846 .65231 .61779 .65134 .61619 Mtetra
.652 .564 .743 r
.65134 .61619 .65231 .61779 .65315 .61666 .65217 .61502 Mtetra
.689 .575 .722 r
.65217 .61502 .65315 .61666 .65396 .61504 .65298 .61334 Mtetra
.713 .579 .704 r
.65298 .61334 .65396 .61504 .65476 .61292 .65378 .61111 Mtetra
.728 .581 .689 r
.65378 .61111 .65476 .61292 .65554 .61028 .65455 .60834 Mtetra
.738 .579 .678 r
.65455 .60834 .65554 .61028 .6563 .60715 .65531 .60504 Mtetra
.741 .576 .67 r
.65531 .60504 .6563 .60715 .65705 .60359 .65605 .60129 Mtetra
.74 .571 .665 r
.65605 .60129 .65705 .60359 .65779 .59977 .65678 .59726 Mtetra
.732 .564 .663 r
.65678 .59726 .65779 .59977 .65852 .59592 .6575 .5932 Mtetra
.717 .553 .666 r
.6575 .5932 .65852 .59592 .65926 .59238 .65824 .58947 Mtetra
.689 .535 .672 r
.65824 .58947 .65926 .59238 .66003 .58951 .659 .58645 Mtetra
.638 .504 .683 r
.659 .58645 .66003 .58951 .66084 .58762 .65981 .58447 Mtetra
.541 .446 .697 r
.65981 .58447 .66084 .58762 .66169 .58693 .66065 .58377 Mtetra
.337 .323 .695 r
.66065 .58377 .66169 .58693 .66259 .58746 .66155 .58436 Mtetra
0 .065 .601 r
.66155 .58436 .66259 .58746 .66352 .58905 .66249 .58608 Mtetra
0 0 .344 r
.66249 .58608 .66352 .58905 .66449 .59142 .66347 .58863 Mtetra
.776 .433 0 r
.66347 .58863 .66449 .59142 .66548 .59421 .66446 .59162 Mtetra
.846 .484 0 r
.66446 .59162 .66548 .59421 .66647 .59706 .66546 .59469 Mtetra
.846 .471 0 r
.66546 .59469 .66647 .59706 .66745 .59972 .66645 .59754 Mtetra
.788 .406 0 r
.66645 .59754 .66745 .59972 .66843 .602 .66743 .59999 Mtetra
.636 .262 0 r
.66743 .59999 .66843 .602 .66938 .60379 .66839 .60192 Mtetra
0 0 .559 r
.66839 .60192 .66938 .60379 .67032 .60507 .66933 .60331 Mtetra
.041 .238 .738 r
.66933 .60331 .67032 .60507 .67123 .60584 .67025 .60416 Mtetra
.324 .408 .794 r
.67025 .60416 .67123 .60584 .67213 .60611 .67115 .60448 Mtetra
.493 .496 .788 r
.67115 .60448 .67213 .60611 .67301 .60592 .67203 .6043 Mtetra
.59 .54 .766 r
.67203 .6043 .67301 .60592 .67388 .60525 .67289 .60363 Mtetra
.649 .562 .743 r
.67289 .60363 .67388 .60525 .67472 .60412 .67374 .60245 Mtetra
.687 .573 .722 r
.67374 .60245 .67472 .60412 .67555 .6025 .67456 .60076 Mtetra
.712 .578 .704 r
.67456 .60076 .67555 .6025 .67635 .60037 .67536 .59852 Mtetra
.727 .58 .689 r
.67536 .59852 .67635 .60037 .67714 .59772 .67614 .59573 Mtetra
.737 .578 .678 r
.67614 .59573 .67714 .59772 .6779 .59457 .6769 .59242 Mtetra
.74 .575 .669 r
.6769 .59242 .6779 .59457 .67865 .591 .67763 .58866 Mtetra
.739 .57 .665 r
.67763 .58866 .67865 .591 .67938 .58717 .67836 .58462 Mtetra
.731 .562 .663 r
.67836 .58462 .67938 .58717 .68012 .58334 .67909 .58058 Mtetra
.715 .551 .666 r
.67909 .58058 .68012 .58334 .68087 .57983 .67983 .57688 Mtetra
.685 .532 .672 r
.67983 .57688 .68087 .57983 .68164 .57701 .6806 .57391 Mtetra
.632 .5 .684 r
.6806 .57391 .68164 .57701 .68246 .5752 .68141 .57202 Mtetra
.529 .439 .697 r
.68141 .57202 .68246 .5752 .68333 .5746 .68228 .57141 Mtetra
.318 .311 .694 r
.68228 .57141 .68333 .5746 .68425 .57522 .6832 .57209 Mtetra
0 .052 .594 r
.6832 .57209 .68425 .57522 .68521 .5769 .68417 .57391 Mtetra
0 0 .344 r
.68417 .57391 .68521 .5769 .68622 .57934 .68518 .57653 Mtetra
.767 .425 0 r
.68518 .57653 .68622 .57934 .68724 .58219 .68621 .57958 Mtetra
.835 .473 0 r
.68621 .57958 .68724 .58219 .68826 .58509 .68724 .5827 Mtetra
.833 .459 0 r
.68724 .5827 .68826 .58509 .68928 .58778 .68826 .58558 Mtetra
.771 .39 0 r
.68826 .58558 .68928 .58778 .69028 .59008 .68927 .58805 Mtetra
0 0 .335 r
.68927 .58805 .69028 .59008 .69126 .59189 .69026 .59001 Mtetra
0 0 .572 r
.69026 .59001 .69126 .59189 .69222 .59318 .69123 .59141 Mtetra
.05 .243 .74 r
.69123 .59141 .69222 .59318 .69316 .59396 .69217 .59226 Mtetra
.325 .407 .793 r
.69217 .59226 .69316 .59396 .69408 .59425 .69309 .5926 Mtetra
.49 .494 .788 r
.69309 .5926 .69408 .59425 .69498 .59406 .69399 .59242 Mtetra
.588 .538 .766 r
.69399 .59242 .69498 .59406 .69586 .5934 .69487 .59175 Mtetra
.647 .561 .743 r
.69487 .59175 .69586 .5934 .69672 .59227 .69572 .59057 Mtetra
.685 .572 .722 r
.69572 .59057 .69672 .59227 .69756 .59064 .69656 .58887 Mtetra
.71 .577 .703 r
.69656 .58887 .69756 .59064 .69837 .5885 .69736 .58663 Mtetra
.727 .579 .689 r
.69736 .58663 .69837 .5885 .69916 .58584 .69815 .58383 Mtetra
.736 .578 .677 r
.69815 .58383 .69916 .58584 .69993 .58268 .69891 .5805 Mtetra
.74 .574 .669 r
.69891 .5805 .69993 .58268 .70067 .57911 .69964 .57673 Mtetra
.738 .569 .664 r
.69964 .57673 .70067 .57911 .70141 .57528 .70037 .57269 Mtetra
.729 .561 .663 r
.70037 .57269 .70141 .57528 .70214 .57147 .7011 .56866 Mtetra
.712 .549 .666 r
.7011 .56866 .70214 .57147 .70289 .568 .70184 .565 Mtetra
.681 .529 .673 r
.70184 .565 .70289 .568 .70367 .56524 .70261 .5621 Mtetra
.625 .496 .685 r
.70261 .5621 .70367 .56524 .70451 .5635 .70344 .56028 Mtetra
.518 .432 .698 r
.70344 .56028 .70451 .5635 .70539 .56299 .70433 .55977 Mtetra
.298 .298 .691 r
.70433 .55977 .70539 .56299 .70634 .56371 .70528 .56055 Mtetra
0 .038 .586 r
.70528 .56055 .70634 .56371 .70734 .56548 .70628 .56246 Mtetra
0 0 .342 r
.70628 .56246 .70734 .56548 .70838 .568 .70732 .56517 Mtetra
.76 .417 0 r
.70732 .56517 .70838 .568 .70943 .57091 .70839 .56829 Mtetra
.825 .462 0 r
.70839 .56829 .70943 .57091 .71049 .57386 .70946 .57145 Mtetra
.82 .446 0 r
.70946 .57145 .71049 .57386 .71154 .57659 .71052 .57437 Mtetra
.755 .375 0 r
.71052 .57437 .71154 .57659 .71258 .57891 .71156 .57687 Mtetra
0 0 .354 r
.71156 .57687 .71258 .57891 .71359 .58074 .71258 .57884 Mtetra
0 .006 .582 r
.71258 .57884 .71359 .58074 .71458 .58205 .71357 .58026 Mtetra
.056 .246 .742 r
.71357 .58026 .71458 .58205 .71554 .58285 .71454 .58113 Mtetra
.323 .406 .793 r
.71454 .58113 .71554 .58285 .71648 .58315 .71548 .58147 Mtetra
.487 .492 .788 r
.71548 .58147 .71648 .58315 .7174 .58297 .7164 .58131 Mtetra
.585 .536 .767 r
.7164 .58131 .7174 .58297 .71829 .58232 .71729 .58064 Mtetra
.645 .559 .743 r
.71729 .58064 .71829 .58232 .71917 .58118 .71816 .57947 Mtetra
.684 .571 .722 r
.71816 .57947 .71917 .58118 .72001 .57956 .719 .57776 Mtetra
.709 .576 .704 r
.719 .57776 .72001 .57956 .72084 .57741 .71982 .57551 Mtetra
.726 .578 .689 r
.71982 .57551 .72084 .57741 .72163 .57474 .72061 .5727 Mtetra
.735 .577 .677 r
.72061 .5727 .72163 .57474 .7224 .57157 .72137 .56936 Mtetra
.739 .574 .669 r
.72137 .56936 .7224 .57157 .72315 .56799 .72211 .56558 Mtetra
.737 .568 .664 r
.72211 .56558 .72315 .56799 .72388 .56417 .72283 .56154 Mtetra
.728 .56 .663 r
.72283 .56154 .72388 .56417 .72462 .56037 .72356 .55753 Mtetra
.71 .547 .666 r
.72356 .55753 .72462 .56037 .72537 .55694 .7243 .55391 Mtetra
.677 .527 .674 r
.7243 .55391 .72537 .55694 .72616 .55424 .72508 .55107 Mtetra
.618 .492 .686 r
.72508 .55107 .72616 .55424 .72701 .55259 .72592 .54934 Mtetra
.505 .425 .699 r
.72592 .54934 .72701 .55259 .72792 .55217 .72683 .54892 Mtetra
.277 .286 .689 r
.72683 .54892 .72792 .55217 .72889 .55298 .72781 .54981 Mtetra
0 .024 .577 r
.72781 .54981 .72889 .55298 .72993 .55485 .72885 .55182 Mtetra
0 0 .34 r
.72885 .55182 .72993 .55485 .731 .55745 .72993 .55461 Mtetra
.753 .411 0 r
.72993 .55461 .731 .55745 .73209 .56043 .73104 .55779 Mtetra
.816 .453 0 r
.73104 .55779 .73209 .56043 .73319 .56343 .73214 .56101 Mtetra
.809 .435 0 r
.73214 .56101 .73319 .56343 .73428 .5662 .73324 .56397 Mtetra
.74 .361 0 r
.73324 .56397 .73428 .5662 .73535 .56855 .73432 .56649 Mtetra
0 0 .371 r
.73432 .56649 .73535 .56855 .73639 .57041 .73536 .56849 Mtetra
0 .016 .59 r
.73536 .56849 .73639 .57041 .7374 .57174 .73639 .56993 Mtetra
.059 .249 .743 r
.73639 .56993 .7374 .57174 .73839 .57255 .73738 .57081 Mtetra
.321 .405 .793 r
.73738 .57081 .73839 .57255 .73935 .57286 .73834 .57117 Mtetra
.484 .491 .789 r
.73834 .57117 .73935 .57286 .74029 .57269 .73928 .57102 Mtetra
.582 .535 .768 r
.73928 .57102 .74029 .57269 .7412 .57205 .74019 .57036 Mtetra
.643 .559 .744 r
.74019 .57036 .7412 .57205 .74209 .57092 .74107 .56918 Mtetra
.683 .57 .722 r
.74107 .56918 .74209 .57092 .74295 .56929 .74193 .56748 Mtetra
.709 .576 .704 r
.74193 .56748 .74295 .56929 .74378 .56714 .74275 .56521 Mtetra
.725 .577 .689 r
.74275 .56521 .74378 .56714 .74458 .56446 .74355 .56239 Mtetra
.735 .576 .677 r
.74355 .56239 .74458 .56446 .74535 .56128 .74431 .55904 Mtetra
.738 .573 .669 r
.74431 .55904 .74535 .56128 .7461 .55769 .74505 .55524 Mtetra
.736 .567 .664 r
.74505 .55524 .7461 .55769 .74684 .55387 .74577 .55121 Mtetra
.727 .559 .663 r
.74577 .55121 .74684 .55387 .74758 .55009 .7465 .54721 Mtetra
.708 .545 .666 r
.7465 .54721 .74758 .55009 .74834 .54669 .74725 .54363 Mtetra
.673 .524 .674 r
.74725 .54363 .74834 .54669 .74914 .54406 .74804 .54085 Mtetra
.611 .487 .687 r
.74804 .54085 .74914 .54406 .75 .54249 .7489 .53921 Mtetra
.493 .417 .7 r
.7489 .53921 .75 .54249 .75093 .54217 .74983 .53889 Mtetra
.256 .273 .686 r
.74983 .53889 .75093 .54217 .75194 .54308 .75084 .53989 Mtetra
0 .01 .569 r
.75084 .53989 .75194 .54308 .75301 .54504 .75191 .54199 Mtetra
0 0 .338 r
.75191 .54199 .75301 .54504 .75412 .54773 .75303 .54487 Mtetra
.747 .404 0 r
.75303 .54487 .75412 .54773 .75525 .55077 .75418 .54813 Mtetra
.807 .443 0 r
.75418 .54813 .75525 .55077 .75639 .55383 .75533 .5514 Mtetra
.798 .423 0 r
.75533 .5514 .75639 .55383 .75751 .55663 .75646 .5544 Mtetra
.726 .348 0 r
.75646 .5544 .75751 .55663 .75861 .55902 .75757 .55696 Mtetra
0 0 .385 r
.75757 .55696 .75861 .55902 .75969 .5609 .75866 .55898 Mtetra
0 .025 .597 r
.75866 .55898 .75969 .5609 .76073 .56225 .7597 .56043 Mtetra
.061 .251 .744 r
.7597 .56043 .76073 .56225 .76175 .56308 .76072 .56134 Mtetra
.318 .405 .794 r
.76072 .56134 .76175 .56308 .76273 .5634 .76171 .5617 Mtetra
.481 .49 .79 r
.76171 .5617 .76273 .5634 .76369 .56324 .76267 .56156 Mtetra
.58 .535 .769 r
.76267 .56156 .76369 .56324 .76462 .56261 .7636 .5609 Mtetra
.642 .558 .745 r
.7636 .5609 .76462 .56261 .76552 .56148 .7645 .55973 Mtetra
.682 .57 .723 r
.7645 .55973 .76552 .56148 .7664 .55985 .76536 .55802 Mtetra
.708 .576 .704 r
.76536 .55802 .7664 .55985 .76723 .5577 .7662 .55575 Mtetra
.725 .577 .689 r
.7662 .55575 .76723 .5577 .76804 .555 .767 .55291 Mtetra
.735 .576 .677 r
.767 .55291 .76804 .555 .76882 .55181 .76776 .54954 Mtetra
.738 .572 .668 r
.76776 .54954 .76882 .55181 .76957 .54821 .7685 .54574 Mtetra
.735 .567 .664 r
.7685 .54574 .76957 .54821 .77031 .54439 .76922 .5417 Mtetra
.725 .558 .663 r
.76922 .5417 .77031 .54439 .77105 .54063 .76995 .53772 Mtetra
.705 .544 .667 r
.76995 .53772 .77105 .54063 .77181 .53727 .7707 .53418 Mtetra
.669 .522 .675 r
.7707 .53418 .77181 .53727 .77262 .53469 .77151 .53146 Mtetra
.604 .483 .688 r
.77151 .53146 .77262 .53469 .7735 .53321 .77238 .52991 Mtetra
.48 .41 .7 r
.77238 .52991 .7735 .53321 .77446 .53298 .77334 .52969 Mtetra
.234 .26 .684 r
.77334 .52969 .77446 .53298 .7755 .534 .77438 .53079 Mtetra
0 0 .561 r
.77438 .53079 .7755 .534 .7766 .53606 .7755 .533 Mtetra
0 0 .336 r
.7755 .533 .7766 .53606 .77776 .53883 .77666 .53596 Mtetra
.742 .398 0 r
.77666 .53596 .77776 .53883 .77893 .54194 .77785 .53929 Mtetra
.798 .434 0 r
.77785 .53929 .77893 .54194 .78011 .54505 .77904 .54261 Mtetra
.787 .412 0 r
.77904 .54261 .78011 .54505 .78127 .54789 .78021 .54565 Mtetra
.713 .335 0 r
.78021 .54565 .78127 .54789 .78241 .55031 .78136 .54824 Mtetra
0 0 .399 r
.78136 .54824 .78241 .55031 .78352 .55221 .78248 .55028 Mtetra
0 .033 .604 r
.78248 .55028 .78352 .55221 .78459 .55358 .78356 .55176 Mtetra
.063 .253 .746 r
.78356 .55176 .78459 .55358 .78564 .55442 .7846 .55268 Mtetra
.316 .405 .795 r
.7846 .55268 .78564 .55442 .78665 .55476 .78562 .55306 Mtetra
.478 .49 .791 r
.78562 .55306 .78665 .55476 .78763 .55461 .7866 .55292 Mtetra
.578 .535 .77 r
.7866 .55292 .78763 .55461 .78858 .55398 .78754 .55227 Mtetra
.641 .558 .746 r
.78754 .55227 .78858 .55398 .78949 .55286 .78846 .55109 Mtetra
.681 .57 .724 r
.78846 .55109 .78949 .55286 .79038 .55122 .78934 .54938 Mtetra
.708 .576 .704 r
.78934 .54938 .79038 .55122 .79123 .54905 .79018 .54709 Mtetra
.725 .577 .689 r
.79018 .54709 .79123 .54905 .79204 .54635 .79098 .54424 Mtetra
.735 .576 .677 r
.79098 .54424 .79204 .54635 .79282 .54314 .79175 .54085 Mtetra
.738 .572 .668 r
.79175 .54085 .79282 .54314 .79357 .53953 .79249 .53703 Mtetra
.735 .566 .664 r
.79249 .53703 .79357 .53953 .79431 .5357 .79321 .53298 Mtetra
.724 .557 .663 r
.79321 .53298 .79431 .5357 .79505 .53195 .79394 .52902 Mtetra
.703 .542 .667 r
.79394 .52902 .79505 .53195 .79582 .52863 .7947 .52551 Mtetra
.665 .519 .676 r
.7947 .52551 .79582 .52863 .79665 .52611 .79551 .52286 Mtetra
.597 .479 .689 r
.79551 .52286 .79665 .52611 .79755 .52471 .79641 .52139 Mtetra
.466 .402 .701 r
.79641 .52139 .79755 .52471 .79853 .52458 .79739 .52127 Mtetra
.212 .247 .681 r
.79739 .52127 .79853 .52458 .79961 .5257 .79847 .52247 Mtetra
0 0 .554 r
.79847 .52247 .79961 .5257 .80075 .52785 .79963 .52478 Mtetra
0 0 .335 r
.79963 .52478 .80075 .52785 .80195 .5307 .80083 .52783 Mtetra
.736 .391 0 r
.80083 .52783 .80195 .5307 .80317 .53388 .80207 .53122 Mtetra
.79 .424 0 r
.80207 .53122 .80317 .53388 .80439 .53704 .8033 .5346 Mtetra
.776 .4 0 r
.8033 .5346 .80439 .53704 .80559 .53992 .80452 .53768 Mtetra
.7 .322 0 r
.80452 .53768 .80559 .53992 .80677 .54237 .80571 .5403 Mtetra
0 0 .412 r
.80571 .5403 .80677 .54237 .80791 .54429 .80686 .54236 Mtetra
0 .042 .611 r
.80686 .54236 .80791 .54429 .80902 .54568 .80797 .54386 Mtetra
.065 .257 .749 r
.80797 .54386 .80902 .54568 .81009 .54654 .80904 .54479 Mtetra
.315 .406 .796 r
.80904 .54479 .81009 .54654 .81112 .54689 .81008 .54518 Mtetra
.476 .49 .793 r
.81008 .54518 .81112 .54689 .81212 .54674 .81108 .54504 Mtetra
.577 .535 .772 r
.81108 .54504 .81212 .54674 .81309 .54611 .81205 .54439 Mtetra
.64 .559 .747 r
.81205 .54439 .81309 .54611 .81403 .54499 .81298 .54321 Mtetra
.681 .571 .725 r
.81298 .54321 .81403 .54499 .81492 .54334 .81387 .54148 Mtetra
.708 .576 .705 r
.81387 .54148 .81492 .54334 .81578 .54116 .81472 .53918 Mtetra
.725 .578 .689 r
.81472 .53918 .81578 .54116 .8166 .53843 .81553 .5363 Mtetra
.735 .576 .676 r
.81553 .5363 .8166 .53843 .81739 .5352 .8163 .53289 Mtetra
.738 .572 .668 r
.8163 .53289 .81739 .5352 .81814 .53157 .81704 .52905 Mtetra
.735 .566 .664 r
.81704 .52905 .81814 .53157 .81888 .52774 .81777 .525 Mtetra
.723 .556 .663 r
.81777 .525 .81888 .52774 .81963 .524 .81849 .52104 Mtetra
.701 .541 .668 r
.81849 .52104 .81963 .524 .8204 .52071 .81926 .51757 Mtetra
.662 .517 .677 r
.81926 .51757 .8204 .52071 .82124 .51825 .82009 .51497 Mtetra
.59 .475 .691 r
.82009 .51497 .82124 .51825 .82216 .51693 .821 .51358 Mtetra
.453 .395 .702 r
.821 .51358 .82216 .51693 .82318 .51689 .82202 .51356 Mtetra
.191 .235 .678 r
.82202 .51356 .82318 .51689 .82429 .51811 .82313 .51487 Mtetra
0 0 .548 r
.82313 .51487 .82429 .51811 .82547 .52035 .82433 .51727 Mtetra
0 0 .335 r
.82433 .51727 .82547 .52035 .82671 .52329 .82558 .52041 Mtetra
.73 .383 0 r
.82558 .52041 .82671 .52329 .82798 .52653 .82687 .52387 Mtetra
.78 .414 0 r
.82687 .52387 .82798 .52653 .82925 .52974 .82815 .5273 Mtetra
.765 .388 0 r
.82815 .5273 .82925 .52974 .83049 .53266 .82941 .53042 Mtetra
.686 .308 0 r
.82941 .53042 .83049 .53266 .83171 .53513 .83063 .53306 Mtetra
0 0 .426 r
.83063 .53306 .83171 .53513 .83289 .53707 .83182 .53515 Mtetra
0 .052 .619 r
.83182 .53515 .83289 .53707 .83402 .53847 .83297 .53665 Mtetra
.069 .261 .752 r
.83297 .53665 .83402 .53847 .83512 .53934 .83407 .53759 Mtetra
.315 .408 .798 r
.83407 .53759 .83512 .53934 .83619 .5397 .83514 .53799 Mtetra
.475 .491 .795 r
.83514 .53799 .83619 .5397 .83721 .53956 .83616 .53786 Mtetra
.576 .536 .773 r
.83616 .53786 .83721 .53956 .8382 .53893 .83715 .5372 Mtetra
.64 .56 .749 r
.83715 .5372 .8382 .53893 .83915 .53779 .83809 .53601 Mtetra
.681 .572 .725 r
.83809 .53601 .83915 .53779 .84006 .53613 .839 .53426 Mtetra
.709 .577 .705 r
.839 .53426 .84006 .53613 .84093 .53393 .83986 .53194 Mtetra
.726 .578 .689 r
.83986 .53194 .84093 .53393 .84176 .53118 .84067 .52903 Mtetra
.735 .576 .676 r
.84067 .52903 .84176 .53118 .84254 .52792 .84145 .52559 Mtetra
.738 .572 .668 r
.84145 .52559 .84254 .52792 .8433 .52427 .84219 .52173 Mtetra
.734 .565 .663 r
.84219 .52173 .8433 .52427 .84404 .52043 .84291 .51766 Mtetra
.723 .555 .663 r
.84291 .51766 .84404 .52043 .84479 .51669 .84364 .51371 Mtetra
.699 .54 .668 r
.84364 .51371 .84479 .51669 .84557 .51343 .84441 .51026 Mtetra
.658 .515 .678 r
.84441 .51026 .84557 .51343 .84643 .51103 .84525 .50773 Mtetra
.582 .471 .692 r
.84525 .50773 .84643 .51103 .84737 .50978 .84619 .50642 Mtetra
.44 .387 .703 r
.84619 .50642 .84737 .50978 .84842 .50983 .84724 .50649 Mtetra
.172 .224 .676 r
.84724 .50649 .84842 .50983 .84956 .51115 .84839 .5079 Mtetra
0 0 .542 r
.84839 .5079 .84956 .51115 .8508 .51348 .84963 .5104 Mtetra
0 0 .337 r
.84963 .5104 .8508 .51348 .85208 .51649 .85094 .51361 Mtetra
.722 .374 0 r
.85094 .51361 .85208 .51649 .8534 .5198 .85227 .51714 Mtetra
.77 .402 0 r
.85227 .51714 .8534 .5198 .85471 .52305 .8536 .52062 Mtetra
.752 .375 0 r
.8536 .52062 .85471 .52305 .856 .52601 .8549 .52377 Mtetra
.671 .293 0 r
.8549 .52377 .856 .52601 .85726 .5285 .85617 .52644 Mtetra
0 0 .441 r
.85617 .52644 .85726 .5285 .85847 .53046 .8574 .52854 Mtetra
0 .063 .627 r
.8574 .52854 .85847 .53046 .85964 .53188 .85858 .53006 Mtetra
.074 .267 .755 r
.85858 .53006 .85964 .53188 .86077 .53275 .85971 .531 Mtetra
.316 .41 .8 r
.85971 .531 .86077 .53275 .86186 .53311 .8608 .5314 Mtetra
.476 .493 .797 r
.8608 .5314 .86186 .53311 .86291 .53297 .86185 .53127 Mtetra
.576 .538 .775 r
.86185 .53127 .86291 .53297 .86392 .53233 .86286 .5306 Mtetra
.64 .561 .75 r
.86286 .5306 .86392 .53233 .86489 .53118 .86382 .5294 Mtetra
.682 .573 .726 r
.86382 .5294 .86489 .53118 .86581 .5295 .86474 .52763 Mtetra
.71 .578 .705 r
.86474 .52763 .86581 .5295 .86669 .52728 .86561 .52528 Mtetra
.727 .579 .689 r
.86561 .52528 .86669 .52728 .86753 .5245 .86643 .52234 Mtetra
.736 .577 .676 r
.86643 .52234 .86753 .5245 .86832 .52121 .8672 .51886 Mtetra
.739 .572 .667 r
.8672 .51886 .86832 .52121 .86907 .51753 .86794 .51497 Mtetra
.734 .565 .663 r
.86794 .51497 .86907 .51753 .86982 .51367 .86867 .51088 Mtetra
.722 .555 .663 r
.86867 .51088 .86982 .51367 .87057 .50993 .8694 .50693 Mtetra
.697 .539 .668 r
.8694 .50693 .87057 .50993 .87136 .5067 .87018 .50351 Mtetra
.654 .513 .679 r
.87018 .50351 .87136 .5067 .87223 .50435 .87103 .50103 Mtetra
.575 .467 .693 r
.87103 .50103 .87223 .50435 .87319 .50317 .87199 .49979 Mtetra
.427 .38 .704 r
.87199 .49979 .87319 .50317 .87427 .50332 .87307 .49996 Mtetra
.153 .214 .673 r
.87307 .49996 .87427 .50332 .87546 .50472 .87427 .50147 Mtetra
0 0 .538 r
.87427 .50147 .87546 .50472 .87674 .50715 .87556 .50406 Mtetra
0 0 .341 r
.87556 .50406 .87674 .50715 .87808 .51023 .87692 .50735 Mtetra
.713 .364 0 r
.87692 .50735 .87808 .51023 .87944 .5136 .8783 .51094 Mtetra
.758 .39 0 r
.8783 .51094 .87944 .5136 .8808 .5169 .87968 .51446 Mtetra
.738 .361 0 r
.87968 .51446 .8808 .5169 .88214 .51988 .88103 .51765 Mtetra
.654 .277 0 r
.88103 .51765 .88214 .51988 .88344 .5224 .88234 .52034 Mtetra
0 0 .457 r
.88234 .52034 .88344 .5224 .88469 .52437 .88361 .52245 Mtetra
0 .075 .637 r
.88361 .52245 .88469 .52437 .8859 .52579 .88482 .52397 Mtetra
.081 .274 .76 r
.88482 .52397 .8859 .52579 .88706 .52667 .88599 .52492 Mtetra
.318 .414 .803 r
.88599 .52492 .88706 .52667 .88818 .52703 .88711 .52532 Mtetra
.477 .495 .798 r
.88711 .52532 .88818 .52703 .88925 .52688 .88818 .52518 Mtetra
.577 .54 .776 r
.88818 .52518 .88925 .52688 .89028 .52623 .88921 .5245 Mtetra
.641 .563 .751 r
.88921 .5245 .89028 .52623 .89127 .52507 .89019 .52328 Mtetra
.683 .574 .726 r
.89019 .52328 .89127 .52507 .8922 .52337 .89112 .52148 Mtetra
.711 .579 .705 r
.89112 .52148 .8922 .52337 .89309 .52111 .892 .5191 Mtetra
.728 .579 .688 r
.892 .5191 .89309 .52111 .89393 .51829 .89282 .51612 Mtetra
.737 .577 .676 r
.89282 .51612 .89393 .51829 .89473 .51497 .8936 .5126 Mtetra
.739 .572 .667 r
.8936 .5126 .89473 .51497 .89549 .51126 .89434 .50867 Mtetra
.735 .565 .663 r
.89434 .50867 .89549 .51126 .89623 .50737 .89506 .50456 Mtetra
.721 .554 .663 r
.89506 .50456 .89623 .50737 .89698 .50364 .8958 .50061 Mtetra
.696 .538 .669 r
.8958 .50061 .89698 .50364 .89778 .50043 .89658 .49721 Mtetra
.65 .511 .68 r
.89658 .49721 .89778 .50043 .89867 .49812 .89745 .49478 Mtetra
.568 .463 .695 r
.89745 .49478 .89867 .49812 .89966 .49702 .89844 .49362 Mtetra
.414 .374 .704 r
.89844 .49362 .89966 .49702 .90078 .49725 .89956 .49388 Mtetra
.136 .204 .671 r
.89956 .49388 .90078 .49725 .90201 .49875 .9008 .49548 Mtetra
0 0 .535 r
.9008 .49548 .90201 .49875 .90333 .50126 .90214 .49816 Mtetra
0 0 .346 r
.90214 .49816 .90333 .50126 .90472 .50442 .90354 .50153 Mtetra
.702 .353 0 r
.90354 .50153 .90472 .50442 .90614 .50784 .90498 .50518 Mtetra
.745 .376 0 r
.90498 .50518 .90614 .50784 .90755 .51118 .90641 .50874 Mtetra
.723 .345 0 r
.90641 .50874 .90755 .51118 .90893 .51419 .90781 .51196 Mtetra
.636 .26 0 r
.90781 .51196 .90893 .51419 .91028 .51672 .90917 .51466 Mtetra
0 0 .474 r
.90917 .51466 .91028 .51672 .91157 .51871 .91047 .51679 Mtetra
0 .089 .647 r
.91047 .51679 .91157 .51871 .91281 .52013 .91172 .51831 Mtetra
.09 .282 .764 r
.91172 .51831 .91281 .52013 .91401 .52101 .91292 .51926 Mtetra
.322 .418 .805 r
.91292 .51926 .91401 .52101 .91515 .52136 .91407 .51965 Mtetra
.478 .498 .8 r
.91407 .51965 .91515 .52136 .91625 .52121 .91517 .5195 Mtetra
.578 .542 .778 r
.91517 .5195 .91625 .52121 .9173 .52054 .91622 .51881 Mtetra
.643 .564 .751 r
.91622 .51881 .9173 .52054 .91831 .51935 .91722 .51756 Mtetra
.685 .576 .727 r
.91722 .51756 .91831 .51935 .91926 .51762 .91816 .51573 Mtetra
.712 .58 .705 r
.91816 .51573 .91926 .51762 .92016 .51533 .91905 .51331 Mtetra
.729 .58 .688 r
.91905 .51331 .92016 .51533 .921 .51247 .91988 .51029 Mtetra
.738 .578 .675 r
.91988 .51029 .921 .51247 .9218 .50911 .92066 .50672 Mtetra
.74 .573 .666 r
.92066 .50672 .9218 .50911 .92256 .50536 .92139 .50275 Mtetra
.735 .565 .662 r
.92139 .50275 .92256 .50536 .9233 .50145 .92212 .49862 Mtetra
.721 .554 .663 r
.92212 .49862 .9233 .50145 .92406 .49771 .92285 .49465 Mtetra
.694 .537 .669 r
.92285 .49465 .92406 .49771 .92487 .49451 .92365 .49127 Mtetra
.646 .509 .681 r
.92365 .49127 .92487 .49451 .92577 .49226 .92453 .48889 Mtetra
.561 .459 .696 r
.92453 .48889 .92577 .49226 .92679 .49122 .92555 .48781 Mtetra
.402 .367 .705 r
.92555 .48781 .92679 .49122 .92794 .49154 .9267 .48815 Mtetra
.12 .196 .669 r
.9267 .48815 .92794 .49154 .92922 .49312 .92799 .48985 Mtetra
0 0 .534 r
.92799 .48985 .92922 .49312 .9306 .49572 .92938 .49262 Mtetra
0 0 .354 r
.92938 .49262 .9306 .49572 .93204 .49895 .93085 .49606 Mtetra
.69 .341 0 r
.93085 .49606 .93204 .49895 .93351 .50242 .93234 .49977 Mtetra
.73 .362 0 r
.93234 .49977 .93351 .50242 .93498 .5058 .93382 .50337 Mtetra
.706 .328 0 r
.93382 .50337 .93498 .5058 .93641 .50884 .93527 .50661 Mtetra
0 0 .335 r
.93527 .50661 .93641 .50884 .93779 .51139 .93668 .50933 Mtetra
0 0 .492 r
.93668 .50933 .93779 .51139 .93913 .51338 .93802 .51146 Mtetra
0 .103 .658 r
.93802 .51146 .93913 .51338 .94041 .5148 .93931 .51299 Mtetra
.101 .291 .769 r
.93931 .51299 .94041 .5148 .94163 .51568 .94054 .51393 Mtetra
.327 .423 .807 r
.94054 .51393 .94163 .51568 .94281 .51602 .94172 .51431 Mtetra
.481 .501 .802 r
.94172 .51431 .94281 .51602 .94393 .51585 .94285 .51414 Mtetra
.58 .544 .779 r
.94285 .51414 .94393 .51585 .94501 .51517 .94392 .51343 Mtetra
.644 .566 .752 r
.94392 .51343 .94501 .51517 .94603 .51395 .94493 .51215 Mtetra
.686 .577 .727 r
.94493 .51215 .94603 .51395 .947 .51219 .94589 .51029 Mtetra
.714 .581 .705 r
.94589 .51029 .947 .51219 .94791 .50986 .94678 .50782 Mtetra
.731 .581 .688 r
.94678 .50782 .94791 .50986 .94876 .50696 .94762 .50475 Mtetra
.739 .578 .675 r
.94762 .50475 .94876 .50696 .94956 .50354 .9484 .50114 Mtetra
.741 .573 .666 r
.9484 .50114 .94956 .50354 .95032 .49975 .94913 .49712 Mtetra
.735 .565 .662 r
.94913 .49712 .95032 .49975 .95106 .49582 .94985 .49295 Mtetra
.72 .553 .663 r
.94985 .49295 .95106 .49582 .95182 .49206 .95059 .48898 Mtetra
.692 .535 .67 r
.95059 .48898 .95182 .49206 .95264 .48889 .9514 .48562 Mtetra
.643 .506 .682 r
.9514 .48562 .95264 .48889 .95356 .48667 .9523 .48328 Mtetra
.554 .456 .698 r
.9523 .48328 .95356 .48667 .95461 .48571 .95334 .48227 Mtetra
.39 .361 .705 r
.95334 .48227 .95461 .48571 .9558 .48611 .95454 .4827 Mtetra
.106 .188 .667 r
.95454 .4827 .9558 .48611 .95713 .48778 .95587 .48449 Mtetra
0 0 .534 r
.95587 .48449 .95713 .48778 .95856 .49045 .95732 .48735 Mtetra
0 0 .362 r
.95732 .48735 .95856 .49045 .96006 .49375 .95884 .49086 Mtetra
.676 .328 0 r
.95884 .49086 .96006 .49375 .96158 .49728 .96039 .49462 Mtetra
.714 .346 0 r
.96039 .49462 .96158 .49728 .9631 .50069 .96193 .49826 Mtetra
.687 .31 0 r
.96193 .49826 .9631 .50069 .96458 .50375 .96344 .50153 Mtetra
0 0 .357 r
.96344 .50153 .96458 .50375 .96602 .50631 .96489 .50426 Mtetra
0 0 .51 r
.96489 .50426 .96602 .50631 .96739 .50831 .96628 .50639 Mtetra
0 .119 .669 r
.96628 .50639 .96739 .50831 .96871 .50973 .9676 .50792 Mtetra
.113 .3 .774 r
.9676 .50792 .96871 .50973 .96997 .5106 .96887 .50885 Mtetra
.333 .428 .81 r
.96887 .50885 .96997 .5106 .97118 .51093 .97008 .50922 Mtetra
.484 .505 .803 r
.97008 .50922 .97118 .51093 .97233 .51075 .97123 .50903 Mtetra
.583 .546 .78 r
.97123 .50903 .97233 .51075 .97342 .51004 .97232 .50829 Mtetra
.646 .568 .753 r
.97232 .50829 .97342 .51004 .97446 .50879 .97336 .50698 Mtetra
.688 .579 .727 r
.97336 .50698 .97446 .50879 .97544 .50699 .97432 .50508 Mtetra
.715 .582 .705 r
.97432 .50508 .97544 .50699 .97636 .50461 .97523 .50257 Mtetra
.732 .582 .687 r
.97523 .50257 .97636 .50461 .97722 .50166 .97607 .49944 Mtetra
.741 .579 .674 r
.97607 .49944 .97722 .50166 .97802 .4982 .97685 .49578 Mtetra
.742 .573 .665 r
.97685 .49578 .97802 .4982 .97878 .49436 .97758 .49171 Mtetra
.735 .565 .662 r
.97758 .49171 .97878 .49436 .97952 .49039 .9783 .48751 Mtetra
.72 .553 .663 r
.9783 .48751 .97952 .49039 .98029 .48663 .97904 .48352 Mtetra
.69 .534 .67 r
.97904 .48352 .98029 .48663 .98112 .48347 .97985 .48017 Mtetra
.639 .504 .683 r
.97985 .48017 .98112 .48347 .98206 .4813 .98078 .47788 Mtetra
.546 .452 .699 r
.98078 .47788 .98206 .4813 .98314 .4804 .98185 .47694 Mtetra
.438 .357 .668 r
.51845 .67816 .51939 .68232 .52016 .68237 .51922 .67826 Mtetra
.176 .182 .627 r
.51922 .67826 .52016 .68237 .52094 .68358 .52 .67963 Mtetra
0 0 .469 r
.52 .67963 .52094 .68358 .52172 .6857 .52078 .68199 Mtetra
0 0 .226 r
.52078 .68199 .52172 .6857 .52251 .68838 .52157 .68496 Mtetra
.794 .491 0 r
.52157 .68496 .52251 .68838 .5233 .69125 .52236 .68814 Mtetra
.834 .511 0 r
.52236 .68814 .5233 .69125 .52409 .694 .52315 .69119 Mtetra
.802 .47 0 r
.52315 .69119 .52409 .694 .52488 .69642 .52394 .69387 Mtetra
.678 .353 0 r
.52394 .69387 .52488 .69642 .52567 .69836 .52473 .69604 Mtetra
0 0 .465 r
.52473 .69604 .52567 .69836 .52646 .69978 .52552 .69763 Mtetra
0 .144 .668 r
.52552 .69763 .52646 .69978 .52724 .70067 .5263 .69866 Mtetra
.283 .343 .749 r
.5263 .69866 .52724 .70067 .52802 .70104 .52708 .69912 Mtetra
.467 .451 .757 r
.52708 .69912 .52802 .70104 .5288 .70093 .52786 .69904 Mtetra
.571 .507 .744 r
.52786 .69904 .5288 .70093 .52957 .70033 .52863 .69845 Mtetra
.633 .535 .726 r
.52863 .69845 .52957 .70033 .53034 .69926 .5294 .69732 Mtetra
.672 .55 .709 r
.5294 .69732 .53034 .69926 .5311 .69769 .53016 .69566 Mtetra
.696 .558 .694 r
.53016 .69566 .5311 .69769 .53186 .6956 .53092 .69344 Mtetra
.712 .561 .682 r
.53092 .69344 .53186 .6956 .53262 .69298 .53168 .69064 Mtetra
.721 .561 .673 r
.53168 .69064 .53262 .69298 .53337 .68984 .53243 .68726 Mtetra
.725 .559 .665 r
.53243 .68726 .53337 .68984 .53412 .68623 .53317 .68338 Mtetra
.724 .554 .661 r
.53317 .68338 .53412 .68623 .53486 .68229 .53391 .67914 Mtetra
.717 .547 .658 r
.53391 .67914 .53486 .68229 .5356 .67823 .53465 .67477 Mtetra
.703 .535 .658 r
.53465 .67477 .5356 .67823 .53635 .67439 .53539 .67064 Mtetra
.679 .518 .66 r
.53539 .67064 .53635 .67439 .53709 .67112 .53614 .66713 Mtetra
.638 .49 .665 r
.53614 .66713 .53709 .67112 .53785 .66878 .53689 .66463 Mtetra
.565 .441 .67 r
.53689 .66463 .53785 .66878 .53862 .66762 .53766 .66342 Mtetra
.428 .351 .668 r
.53766 .66342 .53862 .66762 .5394 .66773 .53844 .66359 Mtetra
.165 .175 .624 r
.53844 .66359 .5394 .66773 .5402 .669 .53924 .66503 Mtetra
0 0 .47 r
.53924 .66503 .5402 .669 .541 .67118 .54004 .66744 Mtetra
0 0 .241 r
.54004 .66744 .541 .67118 .54182 .67389 .54086 .67045 Mtetra
.775 .474 0 r
.54086 .67045 .54182 .67389 .54263 .67678 .54168 .67365 Mtetra
.813 .493 0 r
.54168 .67365 .54263 .67678 .54345 .67954 .5425 .6767 Mtetra
.775 .447 0 r
.5425 .6767 .54345 .67954 .54427 .68194 .54332 .67937 Mtetra
0 0 .267 r
.54332 .67937 .54427 .68194 .54508 .68387 .54413 .68153 Mtetra
0 0 .494 r
.54413 .68153 .54508 .68387 .54588 .68528 .54494 .68311 Mtetra
.007 .164 .678 r
.54494 .68311 .54588 .68528 .54668 .68615 .54574 .68411 Mtetra
.297 .351 .749 r
.54574 .68411 .54668 .68615 .54748 .68651 .54653 .68456 Mtetra
.472 .453 .756 r
.54653 .68456 .54748 .68651 .54827 .68637 .54732 .68446 Mtetra
.573 .506 .742 r
.54732 .68446 .54827 .68637 .54905 .68576 .54811 .68384 Mtetra
.633 .534 .725 r
.54811 .68384 .54905 .68576 .54983 .68466 .54889 .68269 Mtetra
.671 .549 .708 r
.54889 .68269 .54983 .68466 .55061 .68306 .54966 .681 Mtetra
.696 .557 .693 r
.54966 .681 .55061 .68306 .55137 .68094 .55042 .67874 Mtetra
.711 .56 .681 r
.55042 .67874 .55137 .68094 .55213 .67829 .55118 .67591 Mtetra
.72 .56 .672 r
.55118 .67591 .55213 .67829 .55288 .67512 .55193 .6725 Mtetra
.724 .558 .665 r
.55193 .6725 .55288 .67512 .55363 .67148 .55267 .66858 Mtetra
.723 .553 .66 r
.55267 .66858 .55363 .67148 .55437 .66751 .55341 .66431 Mtetra
.716 .545 .658 r
.55341 .66431 .55437 .66751 .55511 .66345 .55414 .65993 Mtetra
.701 .534 .658 r
.55414 .65993 .55511 .66345 .55585 .65961 .55488 .65581 Mtetra
.676 .516 .66 r
.55488 .65581 .55585 .65961 .5566 .65637 .55562 .65233 Mtetra
.634 .487 .665 r
.55562 .65233 .5566 .65637 .55736 .65408 .55638 .64989 Mtetra
.558 .437 .67 r
.55638 .64989 .55736 .65408 .55814 .65299 .55716 .64874 Mtetra
.418 .344 .667 r
.55716 .64874 .55814 .65299 .55894 .65317 .55796 .64899 Mtetra
.154 .168 .622 r
.55796 .64899 .55894 .65317 .55975 .65451 .55878 .6505 Mtetra
0 0 .471 r
.55878 .6505 .55975 .65451 .56058 .65673 .55961 .65297 Mtetra
0 0 .254 r
.55961 .65297 .56058 .65673 .56142 .65948 .56045 .65602 Mtetra
.755 .458 0 r
.56045 .65602 .56142 .65948 .56227 .66239 .5613 .65924 Mtetra
.792 .474 0 r
.5613 .65924 .56227 .66239 .56311 .66516 .56215 .6623 Mtetra
.748 .424 0 r
.56215 .6623 .56311 .66516 .56395 .66756 .56299 .66497 Mtetra
0 0 .302 r
.56299 .66497 .56395 .66756 .56478 .66948 .56383 .66711 Mtetra
0 0 .519 r
.56383 .66711 .56478 .66948 .56561 .67087 .56465 .66868 Mtetra
.035 .181 .686 r
.56465 .66868 .56561 .67087 .56643 .67173 .56547 .66967 Mtetra
.309 .357 .75 r
.56547 .66967 .56643 .67173 .56724 .67207 .56629 .67009 Mtetra
.476 .454 .755 r
.56629 .67009 .56724 .67207 .56805 .67192 .56709 .66998 Mtetra
.574 .506 .741 r
.56709 .66998 .56805 .67192 .56884 .67129 .56789 .66934 Mtetra
.633 .534 .724 r
.56789 .66934 .56884 .67129 .56963 .67017 .56867 .66816 Mtetra
.671 .548 .707 r
.56867 .66816 .56963 .67017 .57041 .66854 .56945 .66645 Mtetra
.695 .556 .693 r
.56945 .66645 .57041 .66854 .57118 .6664 .57022 .66416 Mtetra
.711 .559 .681 r
.57022 .66416 .57118 .6664 .57195 .66372 .57098 .66129 Mtetra
.72 .559 .671 r
.57098 .66129 .57195 .66372 .5727 .66051 .57173 .65784 Mtetra
.723 .557 .664 r
.57173 .65784 .5727 .66051 .57344 .65684 .57247 .6539 Mtetra
.722 .552 .659 r
.57247 .6539 .57344 .65684 .57418 .65286 .5732 .6496 Mtetra
.714 .544 .657 r
.5732 .6496 .57418 .65286 .57492 .64879 .57393 .64522 Mtetra
.699 .532 .657 r
.57393 .64522 .57492 .64879 .57565 .64497 .57467 .64111 Mtetra
.673 .513 .66 r
.57467 .64111 .57565 .64497 .5764 .64176 .57541 .63767 Mtetra
.629 .483 .665 r
.57541 .63767 .5764 .64176 .57717 .63952 .57618 .63528 Mtetra
.552 .432 .67 r
.57618 .63528 .57717 .63952 .57796 .6385 .57697 .63421 Mtetra
.408 .337 .666 r
.57697 .63421 .57796 .6385 .57878 .63875 .57778 .63454 Mtetra
.142 .161 .619 r
.57778 .63454 .57878 .63875 .57962 .64016 .57862 .63612 Mtetra
0 0 .472 r
.57862 .63612 .57962 .64016 .58047 .64244 .57948 .63866 Mtetra
0 0 .268 r
.57948 .63866 .58047 .64244 .58134 .64523 .58036 .64175 Mtetra
.736 .441 0 r
.58036 .64175 .58134 .64523 .58221 .64816 .58123 .64499 Mtetra
.769 .454 0 r
.58123 .64499 .58221 .64816 .58309 .65094 .58211 .64806 Mtetra
.719 .4 0 r
.58211 .64806 .58309 .65094 .58395 .65334 .58298 .65073 Mtetra
0 0 .335 r
.58298 .65073 .58395 .65334 .58481 .65526 .58384 .65287 Mtetra
0 0 .541 r
.58384 .65287 .58481 .65526 .58566 .65664 .58469 .65442 Mtetra
.06 .196 .693 r
.58469 .65442 .58566 .65664 .58649 .65749 .58553 .6554 Mtetra
.319 .362 .75 r
.58553 .6554 .58649 .65749 .58732 .65782 .58636 .65581 Mtetra
.479 .455 .754 r
.58636 .65581 .58732 .65782 .58814 .65765 .58718 .65568 Mtetra
.574 .505 .74 r
.58718 .65568 .58814 .65765 .58895 .657 .58798 .65502 Mtetra
.633 .532 .723 r
.58798 .65502 .58895 .657 .58975 .65586 .58878 .65382 Mtetra
.67 .547 .706 r
.58878 .65382 .58975 .65586 .59054 .65422 .58957 .65208 Mtetra
.695 .555 .692 r
.58957 .65208 .59054 .65422 .59131 .65205 .59034 .64977 Mtetra
.71 .558 .68 r
.59034 .64977 .59131 .65205 .59208 .64934 .5911 .64687 Mtetra
.719 .558 .67 r
.5911 .64687 .59208 .64934 .59283 .64611 .59185 .64339 Mtetra
.723 .555 .663 r
.59185 .64339 .59283 .64611 .59357 .64241 .59259 .63941 Mtetra
.721 .55 .659 r
.59259 .63941 .59357 .64241 .59431 .63841 .59332 .6351 Mtetra
.713 .542 .657 r
.59332 .6351 .59431 .63841 .59504 .63434 .59404 .63072 Mtetra
.697 .53 .657 r
.59404 .63072 .59504 .63434 .59578 .63053 .59477 .62662 Mtetra
.67 .511 .66 r
.59477 .62662 .59578 .63053 .59653 .62736 .59552 .62322 Mtetra
.625 .48 .665 r
.59552 .62322 .59653 .62736 .59731 .62519 .59629 .6209 Mtetra
.544 .427 .67 r
.59629 .6209 .59731 .62519 .59811 .62423 .59709 .61991 Mtetra
.397 .33 .665 r
.59709 .61991 .59811 .62423 .59894 .62456 .59793 .62032 Mtetra
.13 .153 .617 r
.59793 .62032 .59894 .62456 .59981 .62604 .59879 .62198 Mtetra
0 0 .473 r
.59879 .62198 .59981 .62604 .60069 .62839 .59968 .62458 Mtetra
0 0 .28 r
.59968 .62458 .60069 .62839 .60159 .63122 .60058 .62771 Mtetra
.716 .424 0 r
.60058 .62771 .60159 .63122 .60249 .63418 .60149 .63098 Mtetra
.747 .435 0 r
.60149 .63098 .60249 .63418 .60339 .63696 .6024 .63407 Mtetra
.69 .376 0 r
.6024 .63407 .60339 .63696 .60428 .63937 .60329 .63674 Mtetra
0 0 .364 r
.60329 .63674 .60428 .63937 .60516 .64129 .60418 .63887 Mtetra
0 0 .559 r
.60418 .63887 .60516 .64129 .60603 .64266 .60505 .64042 Mtetra
.08 .209 .698 r
.60505 .64042 .60603 .64266 .60689 .6435 .60591 .64139 Mtetra
.327 .366 .749 r
.60591 .64139 .60689 .6435 .60773 .64383 .60676 .64179 Mtetra
.481 .455 .752 r
.60676 .64179 .60773 .64383 .60857 .64365 .60759 .64164 Mtetra
.574 .504 .739 r
.60759 .64164 .60857 .64365 .60939 .64299 .60841 .64097 Mtetra
.632 .531 .722 r
.60841 .64097 .60939 .64299 .6102 .64183 .60922 .63976 Mtetra
.669 .546 .706 r
.60922 .63976 .6102 .64183 .61099 .64017 .61001 .638 Mtetra
.694 .554 .691 r
.61001 .638 .61099 .64017 .61178 .63798 .61079 .63566 Mtetra
.709 .557 .679 r
.61079 .63566 .61178 .63798 .61254 .63525 .61156 .63273 Mtetra
.718 .557 .67 r
.61156 .63273 .61254 .63525 .6133 .63199 .6123 .62922 Mtetra
.722 .554 .663 r
.6123 .62922 .6133 .63199 .61404 .62827 .61304 .62522 Mtetra
.72 .549 .658 r
.61304 .62522 .61404 .62827 .61477 .62426 .61376 .6209 Mtetra
.711 .541 .656 r
.61376 .6209 .61477 .62426 .6155 .62019 .61449 .61651 Mtetra
.695 .528 .657 r
.61449 .61651 .6155 .62019 .61624 .6164 .61521 .61243 Mtetra
.667 .508 .66 r
.61521 .61243 .61624 .6164 .617 .61328 .61596 .60908 Mtetra
.62 .476 .665 r
.61596 .60908 .617 .61328 .61778 .61116 .61674 .60683 Mtetra
.537 .422 .67 r
.61674 .60683 .61778 .61116 .6186 .61029 .61756 .60592 Mtetra
.386 .323 .664 r
.61756 .60592 .6186 .61029 .61945 .6107 .61841 .60642 Mtetra
.118 .146 .614 r
.61841 .60642 .61945 .6107 .62034 .61226 .6193 .60816 Mtetra
0 0 .473 r
.6193 .60816 .62034 .61226 .62125 .61466 .62022 .61082 Mtetra
0 0 .292 r
.62022 .61082 .62125 .61466 .62218 .61754 .62116 .61401 Mtetra
.697 .408 0 r
.62116 .61401 .62218 .61754 .62311 .62053 .6221 .61731 Mtetra
.724 .416 0 r
.6221 .61731 .62311 .62053 .62404 .62334 .62303 .62042 Mtetra
0 0 .236 r
.62303 .62042 .62404 .62334 .62496 .62575 .62396 .6231 Mtetra
0 0 .39 r
.62396 .6231 .62496 .62575 .62586 .62767 .62487 .62523 Mtetra
0 .004 .575 r
.62487 .62523 .62586 .62767 .62675 .62905 .62577 .62678 Mtetra
.097 .219 .702 r
.62577 .62678 .62675 .62905 .62763 .62988 .62665 .62774 Mtetra
.333 .369 .749 r
.62665 .62774 .62763 .62988 .62849 .6302 .62751 .62813 Mtetra
.482 .455 .751 r
.62751 .62813 .62849 .6302 .62934 .63002 .62836 .62798 Mtetra
.573 .503 .738 r
.62836 .62798 .62934 .63002 .63018 .62935 .62919 .6273 Mtetra
.631 .53 .721 r
.62919 .6273 .63018 .62935 .631 .62819 .63001 .62608 Mtetra
.668 .545 .705 r
.63001 .62608 .631 .62819 .6318 .62651 .63081 .6243 Mtetra
.693 .552 .691 r
.63081 .6243 .6318 .62651 .63259 .6243 .6316 .62194 Mtetra
.708 .556 .679 r
.6316 .62194 .63259 .6243 .63336 .62155 .63236 .61898 Mtetra
.717 .556 .669 r
.63236 .61898 .63336 .62155 .63412 .61826 .63311 .61545 Mtetra
.721 .553 .662 r
.63311 .61545 .63412 .61826 .63486 .61453 .63384 .61143 Mtetra
.718 .548 .658 r
.63384 .61143 .63486 .61453 .63559 .6105 .63456 .60709 Mtetra
.71 .539 .656 r
.63456 .60709 .63559 .6105 .63632 .60644 .63528 .60271 Mtetra
.693 .526 .656 r
.63528 .60271 .63632 .60644 .63705 .60268 .63601 .59866 Mtetra
.664 .505 .66 r
.63601 .59866 .63705 .60268 .63781 .5996 .63676 .59535 Mtetra
.614 .472 .665 r
.63676 .59535 .63781 .5996 .6386 .59756 .63755 .59317 Mtetra
.528 .416 .67 r
.63755 .59317 .6386 .59756 .63944 .59676 .63838 .59235 Mtetra
.374 .315 .662 r
.63838 .59235 .63944 .59676 .64031 .59726 .63925 .59294 Mtetra
.105 .137 .611 r
.63925 .59294 .64031 .59726 .64122 .5989 .64017 .59477 Mtetra
0 0 .473 r
.64017 .59477 .64122 .5989 .64217 .60137 .64112 .59751 Mtetra
0 0 .302 r
.64112 .59751 .64217 .60137 .64313 .60431 .64209 .60075 Mtetra
.679 .393 0 r
.64209 .60075 .64313 .60431 .64409 .60733 .64306 .60409 Mtetra
.702 .398 0 r
.64306 .60409 .64409 .60733 .64505 .61016 .64403 .60722 Mtetra
0 0 .262 r
.64403 .60722 .64505 .61016 .646 .61259 .64499 .60991 Mtetra
0 0 .412 r
.64499 .60991 .646 .61259 .64693 .61451 .64592 .61205 Mtetra
0 .021 .587 r
.64592 .61205 .64693 .61451 .64784 .61589 .64685 .6136 Mtetra
.111 .227 .705 r
.64685 .6136 .64784 .61589 .64874 .61673 .64775 .61456 Mtetra
.337 .37 .749 r
.64775 .61456 .64874 .61673 .64962 .61705 .64863 .61495 Mtetra
.482 .454 .751 r
.64863 .61495 .64962 .61705 .65049 .61687 .6495 .6148 Mtetra
.572 .502 .737 r
.6495 .6148 .65049 .61687 .65134 .61619 .65034 .61411 Mtetra
.629 .528 .721 r
.65034 .61411 .65134 .61619 .65217 .61502 .65117 .61288 Mtetra
.667 .543 .705 r
.65117 .61288 .65217 .61502 .65298 .61334 .65198 .61108 Mtetra
.691 .551 .69 r
.65198 .61108 .65298 .61334 .65378 .61111 .65277 .6087 Mtetra
.707 .554 .678 r
.65277 .6087 .65378 .61111 .65455 .60834 .65354 .60573 Mtetra
.716 .554 .669 r
.65354 .60573 .65455 .60834 .65531 .60504 .65429 .60218 Mtetra
.72 .552 .662 r
.65429 .60218 .65531 .60504 .65605 .60129 .65501 .59814 Mtetra
.717 .546 .657 r
.65501 .59814 .65605 .60129 .65678 .59726 .65573 .59379 Mtetra
.708 .537 .655 r
.65573 .59379 .65678 .59726 .6575 .5932 .65645 .58941 Mtetra
.69 .524 .656 r
.65645 .58941 .6575 .5932 .65824 .58947 .65717 .58539 Mtetra
.66 .502 .66 r
.65717 .58539 .65824 .58947 .659 .58645 .65793 .58215 Mtetra
.609 .468 .665 r
.65793 .58215 .659 .58645 .65981 .58447 .65873 .58004 Mtetra
.52 .41 .669 r
.65873 .58004 .65981 .58447 .66065 .58377 .65957 .57931 Mtetra
.361 .307 .661 r
.65957 .57931 .66065 .58377 .66155 .58436 .66047 .58 Mtetra
.092 .129 .608 r
.66047 .58 .66155 .58436 .66249 .58608 .66142 .58192 Mtetra
0 0 .473 r
.66142 .58192 .66249 .58608 .66347 .58863 .6624 .58474 Mtetra
0 0 .311 r
.6624 .58474 .66347 .58863 .66446 .59162 .66341 .58804 Mtetra
0 0 .214 r
.66341 .58804 .66446 .59162 .66546 .59469 .66442 .59142 Mtetra
.682 .381 0 r
.66442 .59142 .66546 .59469 .66645 .59754 .66542 .59458 Mtetra
0 0 .285 r
.66542 .59458 .66645 .59754 .66743 .59999 .6664 .59729 Mtetra
0 0 .432 r
.6664 .59729 .66743 .59999 .66839 .60192 .66737 .59944 Mtetra
0 .036 .597 r
.66737 .59944 .66839 .60192 .66933 .60331 .66832 .601 Mtetra
.121 .233 .708 r
.66832 .601 .66933 .60331 .67025 .60416 .66924 .60196 Mtetra
.339 .371 .748 r
.66924 .60196 .67025 .60416 .67115 .60448 .67014 .60236 Mtetra
.481 .453 .75 r
.67014 .60236 .67115 .60448 .67203 .6043 .67102 .6022 Mtetra
.57 .5 .737 r
.67102 .6022 .67203 .6043 .67289 .60363 .67189 .60151 Mtetra
.627 .527 .721 r
.67189 .60151 .67289 .60363 .67374 .60245 .67273 .60027 Mtetra
.665 .542 .704 r
.67273 .60027 .67374 .60245 .67456 .60076 .67355 .59847 Mtetra
.69 .55 .69 r
.67355 .59847 .67456 .60076 .67536 .59852 .67434 .59607 Mtetra
.706 .553 .678 r
.67434 .59607 .67536 .59852 .67614 .59573 .67511 .59308 Mtetra
.715 .553 .668 r
.67511 .59308 .67614 .59573 .6769 .59242 .67586 .58951 Mtetra
.718 .55 .661 r
.67586 .58951 .6769 .59242 .67763 .58866 .67658 .58545 Mtetra
.716 .545 .657 r
.67658 .58545 .67763 .58866 .67836 .58462 .6773 .5811 Mtetra
.706 .535 .655 r
.6773 .5811 .67836 .58462 .67909 .58058 .67801 .57673 Mtetra
.688 .521 .656 r
.67801 .57673 .67909 .58058 .67983 .57688 .67874 .57275 Mtetra
.656 .499 .66 r
.67874 .57275 .67983 .57688 .6806 .57391 .6795 .56956 Mtetra
.603 .464 .665 r
.6795 .56956 .6806 .57391 .68141 .57202 .68031 .56754 Mtetra
.51 .404 .669 r
.68031 .56754 .68141 .57202 .68228 .57141 .68117 .56691 Mtetra
.348 .298 .66 r
.68117 .56691 .68228 .57141 .6832 .57209 .6821 .5677 Mtetra
.078 .12 .604 r
.6821 .5677 .6832 .57209 .68417 .57391 .68308 .56972 Mtetra
0 0 .472 r
.68308 .56972 .68417 .57391 .68518 .57653 .68409 .57262 Mtetra
0 0 .319 r
.68409 .57262 .68518 .57653 .68621 .57958 .68513 .57598 Mtetra
0 0 .23 r
.68513 .57598 .68621 .57958 .68724 .5827 .68618 .57941 Mtetra
0 0 .227 r
.68618 .57941 .68724 .5827 .68826 .58558 .68722 .5826 Mtetra
0 0 .305 r
.68722 .5826 .68826 .58558 .68927 .58805 .68823 .58533 Mtetra
0 0 .448 r
.68823 .58533 .68927 .58805 .69026 .59001 .68923 .5875 Mtetra
0 .048 .605 r
.68923 .5875 .69026 .59001 .69123 .59141 .6902 .58907 Mtetra
.128 .238 .71 r
.6902 .58907 .69123 .59141 .69217 .59226 .69115 .59004 Mtetra
.34 .372 .748 r
.69115 .59004 .69217 .59226 .69309 .5926 .69207 .59045 Mtetra
.479 .452 .75 r
.69207 .59045 .69309 .5926 .69399 .59242 .69297 .5903 Mtetra
.568 .499 .737 r
.69297 .5903 .69399 .59242 .69487 .59175 .69385 .5896 Mtetra
.626 .525 .72 r
.69385 .5896 .69487 .59175 .69572 .59057 .6947 .58836 Mtetra
.664 .54 .704 r
.6947 .58836 .69572 .59057 .69656 .58887 .69553 .58655 Mtetra
.689 .549 .69 r
.69553 .58655 .69656 .58887 .69736 .58663 .69633 .58414 Mtetra
.705 .552 .677 r
.69633 .58414 .69736 .58663 .69815 .58383 .69711 .58113 Mtetra
.714 .552 .668 r
.69711 .58113 .69815 .58383 .69891 .5805 .69785 .57754 Mtetra
.717 .549 .661 r
.69785 .57754 .69891 .5805 .69964 .57673 .69858 .57347 Mtetra
.714 .543 .656 r
.69858 .57347 .69964 .57673 .70037 .57269 .69929 .56912 Mtetra
.704 .534 .655 r
.69929 .56912 .70037 .57269 .7011 .56866 .7 .56477 Mtetra
.685 .519 .656 r
.7 .56477 .7011 .56866 .70184 .565 .70073 .56082 Mtetra
.652 .496 .66 r
.70073 .56082 .70184 .565 .70261 .5621 .70149 .5577 Mtetra
.597 .46 .665 r
.70149 .5577 .70261 .5621 .70344 .56028 .70231 .55576 Mtetra
.501 .398 .669 r
.70231 .55576 .70344 .56028 .70433 .55977 .7032 .55523 Mtetra
.334 .289 .658 r
.7032 .55523 .70433 .55977 .70528 .56055 .70415 .55613 Mtetra
.063 .111 .601 r
.70415 .55613 .70528 .56055 .70628 .56246 .70516 .55825 Mtetra
0 0 .471 r
.70516 .55825 .70628 .56246 .70732 .56517 .70622 .56123 Mtetra
0 0 .326 r
.70622 .56123 .70732 .56517 .70839 .56829 .7073 .56467 Mtetra
0 0 .243 r
.7073 .56467 .70839 .56829 .70946 .57145 .70838 .56815 Mtetra
0 0 .244 r
.70838 .56815 .70946 .57145 .71052 .57437 .70945 .57137 Mtetra
0 0 .323 r
.70945 .57137 .71052 .57437 .71156 .57687 .71051 .57413 Mtetra
0 0 .462 r
.71051 .57413 .71156 .57687 .71258 .57884 .71153 .57632 Mtetra
0 .058 .612 r
.71153 .57632 .71258 .57884 .71357 .58026 .71253 .5779 Mtetra
.133 .241 .711 r
.71253 .5779 .71357 .58026 .71454 .58113 .7135 .57889 Mtetra
.34 .372 .748 r
.7135 .57889 .71454 .58113 .71548 .58147 .71445 .5793 Mtetra
.477 .451 .75 r
.71445 .5793 .71548 .58147 .7164 .58131 .71537 .57916 Mtetra
.566 .497 .737 r
.71537 .57916 .7164 .58131 .71729 .58064 .71626 .57847 Mtetra
.624 .524 .721 r
.71626 .57847 .71729 .58064 .71816 .57947 .71713 .57723 Mtetra
.662 .539 .704 r
.71713 .57723 .71816 .57947 .719 .57776 .71796 .57541 Mtetra
.688 .547 .689 r
.71796 .57541 .719 .57776 .71982 .57551 .71877 .57299 Mtetra
.704 .551 .677 r
.71877 .57299 .71982 .57551 .72061 .5727 .71955 .56996 Mtetra
.713 .551 .667 r
.71955 .56996 .72061 .5727 .72137 .56936 .7203 .56636 Mtetra
.716 .548 .66 r
.7203 .56636 .72137 .56936 .72211 .56558 .72102 .56228 Mtetra
.713 .542 .656 r
.72102 .56228 .72211 .56558 .72283 .56154 .72173 .55792 Mtetra
.703 .532 .654 r
.72173 .55792 .72283 .56154 .72356 .55753 .72244 .55358 Mtetra
.682 .517 .656 r
.72244 .55358 .72356 .55753 .7243 .55391 .72317 .54968 Mtetra
.648 .493 .66 r
.72317 .54968 .7243 .55391 .72508 .55107 .72394 .54662 Mtetra
.59 .455 .666 r
.72394 .54662 .72508 .55107 .72592 .54934 .72477 .54477 Mtetra
.491 .391 .669 r
.72477 .54477 .72592 .54934 .72683 .54892 .72568 .54435 Mtetra
.32 .28 .657 r
.72568 .54435 .72683 .54892 .72781 .54981 .72666 .54536 Mtetra
.048 .102 .597 r
.72666 .54536 .72781 .54981 .72885 .55182 .72771 .54758 Mtetra
0 0 .47 r
.72771 .54758 .72885 .55182 .72993 .55461 .72881 .55065 Mtetra
0 0 .332 r
.72881 .55065 .72993 .55461 .73104 .55779 .72993 .55416 Mtetra
0 0 .256 r
.72993 .55416 .73104 .55779 .73214 .56101 .73105 .55769 Mtetra
0 0 .259 r
.73105 .55769 .73214 .56101 .73324 .56397 .73216 .56096 Mtetra
0 0 .338 r
.73216 .56096 .73324 .56397 .73432 .56649 .73325 .56374 Mtetra
0 0 .474 r
.73325 .56374 .73432 .56649 .73536 .56849 .73431 .56596 Mtetra
0 .067 .618 r
.73431 .56596 .73536 .56849 .73639 .56993 .73534 .56756 Mtetra
.137 .244 .713 r
.73534 .56756 .73639 .56993 .73738 .57081 .73633 .56856 Mtetra
.339 .372 .749 r
.73633 .56856 .73738 .57081 .73834 .57117 .7373 .56898 Mtetra
.475 .45 .75 r
.7373 .56898 .73834 .57117 .73928 .57102 .73824 .56885 Mtetra
.564 .496 .738 r
.73824 .56885 .73928 .57102 .74019 .57036 .73915 .56816 Mtetra
.622 .523 .721 r
.73915 .56816 .74019 .57036 .74107 .56918 .74003 .56692 Mtetra
.661 .539 .704 r
.74003 .56692 .74107 .56918 .74193 .56748 .74088 .56509 Mtetra
.687 .547 .689 r
.74088 .56509 .74193 .56748 .74275 .56521 .74169 .56266 Mtetra
.703 .55 .677 r
.74169 .56266 .74275 .56521 .74355 .56239 .74247 .55962 Mtetra
.713 .55 .667 r
.74247 .55962 .74355 .56239 .74431 .55904 .74322 .556 Mtetra
.715 .547 .66 r
.74322 .556 .74431 .55904 .74505 .55524 .74394 .5519 Mtetra
.712 .541 .655 r
.74394 .5519 .74505 .55524 .74577 .55121 .74465 .54754 Mtetra
.701 .53 .654 r
.74465 .54754 .74577 .55121 .7465 .54721 .74536 .54322 Mtetra
.68 .515 .656 r
.74536 .54322 .7465 .54721 .74725 .54363 .74609 .53935 Mtetra
.644 .49 .66 r
.74609 .53935 .74725 .54363 .74804 .54085 .74687 .53636 Mtetra
.584 .451 .666 r
.74687 .53636 .74804 .54085 .7489 .53921 .74772 .53461 Mtetra
.481 .385 .669 r
.74772 .53461 .7489 .53921 .74983 .53889 .74865 .53429 Mtetra
.305 .271 .655 r
.74865 .53429 .74983 .53889 .75084 .53989 .74967 .53541 Mtetra
.033 .093 .594 r
.74967 .53541 .75084 .53989 .75191 .54199 .75075 .53774 Mtetra
0 0 .469 r
.75075 .53774 .75191 .54199 .75303 .54487 .75189 .5409 Mtetra
0 0 .337 r
.75189 .5409 .75303 .54487 .75418 .54813 .75305 .54448 Mtetra
0 0 .267 r
.75305 .54448 .75418 .54813 .75533 .5514 .75422 .54807 Mtetra
0 0 .274 r
.75422 .54807 .75533 .5514 .75646 .5544 .75537 .55138 Mtetra
0 0 .353 r
.75537 .55138 .75646 .5544 .75757 .55696 .75649 .5542 Mtetra
0 0 .485 r
.75649 .5542 .75757 .55696 .75866 .55898 .75759 .55643 Mtetra
0 .074 .623 r
.75759 .55643 .75866 .55898 .7597 .56043 .75864 .55805 Mtetra
.139 .247 .714 r
.75864 .55805 .7597 .56043 .76072 .56134 .75967 .55907 Mtetra
.338 .372 .75 r
.75967 .55907 .76072 .56134 .76171 .5617 .76066 .5595 Mtetra
.473 .449 .751 r
.76066 .5595 .76171 .5617 .76267 .56156 .76162 .55937 Mtetra
.562 .496 .738 r
.76162 .55937 .76267 .56156 .7636 .5609 .76255 .55869 Mtetra
.621 .523 .721 r
.76255 .55869 .7636 .5609 .7645 .55973 .76344 .55745 Mtetra
.66 .538 .705 r
.76344 .55745 .7645 .55973 .76536 .55802 .7643 .55561 Mtetra
.686 .546 .689 r
.7643 .55561 .76536 .55802 .7662 .55575 .76512 .55317 Mtetra
.703 .549 .677 r
.76512 .55317 .7662 .55575 .767 .55291 .76591 .55011 Mtetra
.712 .549 .667 r
.76591 .55011 .767 .55291 .76776 .54954 .76665 .54647 Mtetra
.715 .546 .659 r
.76665 .54647 .76776 .54954 .7685 .54574 .76737 .54236 Mtetra
.711 .539 .655 r
.76737 .54236 .7685 .54574 .76922 .5417 .76808 .53799 Mtetra
.699 .529 .654 r
.76808 .53799 .76922 .5417 .76995 .53772 .76878 .53369 Mtetra
.677 .513 .656 r
.76878 .53369 .76995 .53772 .7707 .53418 .76952 .52986 Mtetra
.64 .487 .66 r
.76952 .52986 .7707 .53418 .77151 .53146 .77031 .52693 Mtetra
.577 .447 .666 r
.77031 .52693 .77151 .53146 .77238 .52991 .77118 .52527 Mtetra
.471 .378 .669 r
.77118 .52527 .77238 .52991 .77334 .52969 .77214 .52506 Mtetra
.291 .262 .654 r
.77214 .52506 .77334 .52969 .77438 .53079 .77318 .52629 Mtetra
.018 .084 .591 r
.77318 .52629 .77438 .53079 .7755 .533 .77431 .52872 Mtetra
0 0 .468 r
.77431 .52872 .7755 .533 .77666 .53596 .77549 .53198 Mtetra
0 0 .343 r
.77549 .53198 .77666 .53596 .77785 .53929 .7767 .53563 Mtetra
0 0 .278 r
.7767 .53563 .77785 .53929 .77904 .54261 .77791 .53928 Mtetra
0 0 .288 r
.77791 .53928 .77904 .54261 .78021 .54565 .7791 .54263 Mtetra
0 0 .367 r
.7791 .54263 .78021 .54565 .78136 .54824 .78026 .54547 Mtetra
0 0 .495 r
.78026 .54547 .78136 .54824 .78248 .55028 .78139 .54773 Mtetra
0 .082 .629 r
.78139 .54773 .78248 .55028 .78356 .55176 .78248 .54937 Mtetra
.142 .25 .716 r
.78248 .54937 .78356 .55176 .7846 .55268 .78354 .5504 Mtetra
.337 .372 .751 r
.78354 .5504 .7846 .55268 .78562 .55306 .78455 .55084 Mtetra
.472 .449 .752 r
.78455 .55084 .78562 .55306 .7866 .55292 .78553 .55072 Mtetra
.561 .495 .739 r
.78553 .55072 .7866 .55292 .78754 .55227 .78648 .55004 Mtetra
.62 .522 .722 r
.78648 .55004 .78754 .55227 .78846 .55109 .78739 .54879 Mtetra
.659 .538 .705 r
.78739 .54879 .78846 .55109 .78934 .54938 .78826 .54695 Mtetra
.686 .546 .689 r
.78826 .54695 .78934 .54938 .79018 .54709 .78909 .54449 Mtetra
.702 .549 .676 r
.78909 .54449 .79018 .54709 .79098 .54424 .78988 .5414 Mtetra
.712 .549 .666 r
.78988 .5414 .79098 .54424 .79175 .54085 .79063 .53774 Mtetra
.714 .545 .659 r
.79063 .53774 .79175 .54085 .79249 .53703 .79134 .53361 Mtetra
.71 .538 .655 r
.79134 .53361 .79249 .53703 .79321 .53298 .79204 .52923 Mtetra
.697 .527 .654 r
.79204 .52923 .79321 .53298 .79394 .52902 .79275 .52494 Mtetra
.675 .511 .656 r
.79275 .52494 .79394 .52902 .7947 .52551 .79349 .52115 Mtetra
.636 .485 .66 r
.79349 .52115 .7947 .52551 .79551 .52286 .79429 .51829 Mtetra
.57 .442 .667 r
.79429 .51829 .79551 .52286 .79641 .52139 .79518 .51671 Mtetra
.46 .372 .669 r
.79518 .51671 .79641 .52139 .79739 .52127 .79616 .51661 Mtetra
.277 .254 .653 r
.79616 .51661 .79739 .52127 .79847 .52247 .79725 .51795 Mtetra
.005 .077 .588 r
.79725 .51795 .79847 .52247 .79963 .52478 .79842 .52049 Mtetra
0 0 .467 r
.79842 .52049 .79963 .52478 .80083 .52783 .79964 .52384 Mtetra
0 0 .349 r
.79964 .52384 .80083 .52783 .80207 .53122 .8009 .52756 Mtetra
0 0 .29 r
.8009 .52756 .80207 .53122 .8033 .5346 .80215 .53127 Mtetra
0 0 .302 r
.80215 .53127 .8033 .5346 .80452 .53768 .80339 .53465 Mtetra
0 0 .38 r
.80339 .53465 .80452 .53768 .80571 .5403 .80459 .53753 Mtetra
0 0 .506 r
.80459 .53753 .80571 .5403 .80686 .54236 .80576 .53981 Mtetra
0 .09 .634 r
.80576 .53981 .80686 .54236 .80797 .54386 .80688 .54146 Mtetra
.145 .254 .719 r
.80688 .54146 .80797 .54386 .80904 .54479 .80796 .5425 Mtetra
.337 .374 .752 r
.80796 .5425 .80904 .54479 .81008 .54518 .80901 .54295 Mtetra
.471 .45 .753 r
.80901 .54295 .81008 .54518 .81108 .54504 .81001 .54284 Mtetra
.56 .495 .74 r
.81001 .54284 .81108 .54504 .81205 .54439 .81097 .54215 Mtetra
.619 .522 .723 r
.81097 .54215 .81205 .54439 .81298 .54321 .8119 .54089 Mtetra
.659 .538 .705 r
.8119 .54089 .81298 .54321 .81387 .54148 .81278 .53904 Mtetra
.686 .546 .689 r
.81278 .53904 .81387 .54148 .81472 .53918 .81362 .53655 Mtetra
.702 .549 .676 r
.81362 .53655 .81472 .53918 .81553 .5363 .81441 .53344 Mtetra
.712 .548 .666 r
.81441 .53344 .81553 .5363 .8163 .53289 .81516 .52975 Mtetra
.714 .544 .659 r
.81516 .52975 .8163 .53289 .81704 .52905 .81588 .52559 Mtetra
.709 .537 .654 r
.81588 .52559 .81704 .52905 .81777 .525 .81657 .52121 Mtetra
.696 .526 .653 r
.81657 .52121 .81777 .525 .81849 .52104 .81728 .51692 Mtetra
.672 .509 .656 r
.81728 .51692 .81849 .52104 .81926 .51757 .81802 .51316 Mtetra
.631 .482 .661 r
.81802 .51316 .81926 .51757 .82009 .51497 .81883 .51037 Mtetra
.564 .438 .667 r
.81883 .51037 .82009 .51497 .821 .51358 .81974 .50888 Mtetra
.45 .366 .669 r
.81974 .50888 .821 .51358 .82202 .51356 .82076 .50888 Mtetra
.263 .246 .651 r
.82076 .50888 .82202 .51356 .82313 .51487 .82188 .51033 Mtetra
0 .07 .585 r
.82188 .51033 .82313 .51487 .82433 .51727 .8231 .51297 Mtetra
0 0 .468 r
.8231 .51297 .82433 .51727 .82558 .52041 .82437 .51641 Mtetra
0 0 .356 r
.82437 .51641 .82558 .52041 .82687 .52387 .82568 .52021 Mtetra
0 0 .302 r
.82568 .52021 .82687 .52387 .82815 .5273 .82698 .52396 Mtetra
0 0 .316 r
.82698 .52396 .82815 .5273 .82941 .53042 .82826 .52739 Mtetra
0 0 .394 r
.82826 .52739 .82941 .53042 .83063 .53306 .82951 .53029 Mtetra
0 0 .516 r
.82951 .53029 .83063 .53306 .83182 .53515 .83071 .53259 Mtetra
0 .098 .64 r
.83071 .53259 .83182 .53515 .83297 .53665 .83187 .53425 Mtetra
.149 .258 .722 r
.83187 .53425 .83297 .53665 .83407 .53759 .83298 .5353 Mtetra
.338 .375 .753 r
.83298 .5353 .83407 .53759 .83514 .53799 .83405 .53576 Mtetra
.47 .451 .754 r
.83405 .53576 .83514 .53799 .83616 .53786 .83507 .53564 Mtetra
.559 .496 .741 r
.83507 .53564 .83616 .53786 .83715 .5372 .83606 .53495 Mtetra
.619 .523 .723 r
.83606 .53495 .83715 .5372 .83809 .53601 .837 .53368 Mtetra
.659 .538 .705 r
.837 .53368 .83809 .53601 .839 .53426 .83789 .5318 Mtetra
.686 .546 .689 r
.83789 .5318 .839 .53426 .83986 .53194 .83874 .52929 Mtetra
.703 .549 .676 r
.83874 .52929 .83986 .53194 .84067 .52903 .83953 .52615 Mtetra
.712 .548 .665 r
.83953 .52615 .84067 .52903 .84145 .52559 .84028 .52242 Mtetra
.714 .544 .658 r
.84028 .52242 .84145 .52559 .84219 .52173 .841 .51824 Mtetra
.708 .537 .654 r
.841 .51824 .84219 .52173 .84291 .51766 .84169 .51383 Mtetra
.695 .525 .653 r
.84169 .51383 .84291 .51766 .84364 .51371 .8424 .50955 Mtetra
.67 .507 .656 r
.8424 .50955 .84364 .51371 .84441 .51026 .84315 .50582 Mtetra
.627 .479 .661 r
.84315 .50582 .84441 .51026 .84525 .50773 .84397 .50308 Mtetra
.557 .434 .668 r
.84397 .50308 .84525 .50773 .84619 .50642 .8449 .50168 Mtetra
.44 .36 .669 r
.8449 .50168 .84619 .50642 .84724 .50649 .84595 .50179 Mtetra
.25 .239 .65 r
.84595 .50179 .84724 .50649 .84839 .5079 .84712 .50334 Mtetra
0 .065 .583 r
.84712 .50334 .84839 .5079 .84963 .5104 .84838 .50608 Mtetra
0 0 .47 r
.84838 .50608 .84963 .5104 .85094 .51361 .8497 .50961 Mtetra
0 0 .364 r
.8497 .50961 .85094 .51361 .85227 .51714 .85106 .51347 Mtetra
0 0 .315 r
.85106 .51347 .85227 .51714 .8536 .52062 .85241 .51728 Mtetra
0 0 .331 r
.85241 .51728 .8536 .52062 .8549 .52377 .85374 .52074 Mtetra
0 0 .409 r
.85374 .52074 .8549 .52377 .85617 .52644 .85503 .52367 Mtetra
0 0 .528 r
.85503 .52367 .85617 .52644 .8574 .52854 .85627 .52598 Mtetra
0 .108 .647 r
.85627 .52598 .8574 .52854 .85858 .53006 .85746 .52766 Mtetra
.154 .263 .725 r
.85746 .52766 .85858 .53006 .85971 .531 .85861 .52871 Mtetra
.34 .378 .755 r
.85861 .52871 .85971 .531 .8608 .5314 .8597 .52917 Mtetra
.471 .452 .755 r
.8597 .52917 .8608 .5314 .86185 .53127 .86075 .52904 Mtetra
.56 .497 .742 r
.86075 .52904 .86185 .53127 .86286 .5306 .86175 .52834 Mtetra
.619 .523 .724 r
.86175 .52834 .86286 .5306 .86382 .5294 .86271 .52705 Mtetra
.659 .538 .706 r
.86271 .52705 .86382 .5294 .86474 .52763 .86362 .52515 Mtetra
.686 .546 .689 r
.86362 .52515 .86474 .52763 .86561 .52528 .86447 .52261 Mtetra
.703 .549 .675 r
.86447 .52261 .86561 .52528 .86643 .52234 .86527 .51943 Mtetra
.712 .548 .665 r
.86527 .51943 .86643 .52234 .8672 .51886 .86602 .51566 Mtetra
.713 .543 .658 r
.86602 .51566 .8672 .51886 .86794 .51497 .86673 .51144 Mtetra
.708 .536 .654 r
.86673 .51144 .86794 .51497 .86867 .51088 .86743 .50701 Mtetra
.693 .524 .653 r
.86743 .50701 .86867 .51088 .8694 .50693 .86813 .50273 Mtetra
.667 .505 .656 r
.86813 .50273 .8694 .50693 .87018 .50351 .86888 .49903 Mtetra
.624 .476 .661 r
.86888 .49903 .87018 .50351 .87103 .50103 .86972 .49634 Mtetra
.551 .43 .668 r
.86972 .49634 .87103 .50103 .87199 .49979 .87068 .49502 Mtetra
.431 .354 .67 r
.87068 .49502 .87199 .49979 .87307 .49996 .87176 .49523 Mtetra
.238 .232 .649 r
.87176 .49523 .87307 .49996 .87427 .50147 .87297 .49689 Mtetra
0 .061 .582 r
.87297 .49689 .87427 .50147 .87556 .50406 .87428 .49973 Mtetra
0 0 .473 r
.87428 .49973 .87556 .50406 .87692 .50735 .87566 .50334 Mtetra
0 0 .373 r
.87566 .50334 .87692 .50735 .8783 .51094 .87707 .50727 Mtetra
0 0 .328 r
.87707 .50727 .8783 .51094 .87968 .51446 .87847 .51113 Mtetra
0 0 .347 r
.87847 .51113 .87968 .51446 .88103 .51765 .87985 .51462 Mtetra
0 0 .424 r
.87985 .51462 .88103 .51765 .88234 .52034 .88118 .51757 Mtetra
0 0 .539 r
.88118 .51757 .88234 .52034 .88361 .52245 .88247 .51989 Mtetra
0 .118 .653 r
.88247 .51989 .88361 .52245 .88482 .52397 .88369 .52158 Mtetra
.161 .269 .728 r
.88369 .52158 .88482 .52397 .88599 .52492 .88487 .52263 Mtetra
.343 .381 .757 r
.88487 .52263 .88599 .52492 .88711 .52532 .88599 .52308 Mtetra
.472 .454 .757 r
.88599 .52308 .88711 .52532 .88818 .52518 .88707 .52295 Mtetra
.56 .498 .743 r
.88707 .52295 .88818 .52518 .88921 .5245 .88809 .52223 Mtetra
.62 .524 .724 r
.88809 .52223 .88921 .5245 .89019 .52328 .88906 .52092 Mtetra
.66 .539 .706 r
.88906 .52092 .89019 .52328 .89112 .52148 .88998 .51898 Mtetra
.687 .546 .689 r
.88998 .51898 .89112 .52148 .892 .5191 .89084 .5164 Mtetra
.704 .549 .675 r
.89084 .5164 .892 .5191 .89282 .51612 .89164 .51318 Mtetra
.712 .548 .664 r
.89164 .51318 .89282 .51612 .8936 .5126 .89239 .50937 Mtetra
.714 .543 .657 r
.89239 .50937 .8936 .5126 .89434 .50867 .8931 .50511 Mtetra
.707 .535 .653 r
.8931 .50511 .89434 .50867 .89506 .50456 .89379 .50065 Mtetra
.692 .522 .653 r
.89379 .50065 .89506 .50456 .8958 .50061 .8945 .49637 Mtetra
.665 .503 .656 r
.8945 .49637 .8958 .50061 .89658 .49721 .89526 .49269 Mtetra
.62 .474 .662 r
.89526 .49269 .89658 .49721 .89745 .49478 .89611 .49006 Mtetra
.545 .426 .669 r
.89611 .49006 .89745 .49478 .89844 .49362 .89709 .48882 Mtetra
.422 .349 .67 r
.89709 .48882 .89844 .49362 .89956 .49388 .89821 .48912 Mtetra
.227 .226 .648 r
.89821 .48912 .89956 .49388 .9008 .49548 .89946 .49088 Mtetra
0 .058 .582 r
.89946 .49088 .9008 .49548 .90214 .49816 .90083 .49382 Mtetra
0 0 .477 r
.90083 .49382 .90214 .49816 .90354 .50153 .90226 .49751 Mtetra
0 0 .384 r
.90226 .49751 .90354 .50153 .90498 .50518 .90373 .50151 Mtetra
0 0 .343 r
.90373 .50151 .90498 .50518 .90641 .50874 .90519 .50541 Mtetra
0 0 .364 r
.90519 .50541 .90641 .50874 .90781 .51196 .90662 .50893 Mtetra
0 0 .44 r
.90662 .50893 .90781 .51196 .90917 .51466 .90799 .5119 Mtetra
0 0 .552 r
.90799 .5119 .90917 .51466 .91047 .51679 .90932 .51423 Mtetra
0 .129 .661 r
.90932 .51423 .91047 .51679 .91172 .51831 .91058 .51591 Mtetra
.169 .276 .732 r
.91058 .51591 .91172 .51831 .91292 .51926 .91179 .51697 Mtetra
.347 .385 .759 r
.91179 .51697 .91292 .51926 .91407 .51965 .91294 .51741 Mtetra
.474 .456 .758 r
.91294 .51741 .91407 .51965 .91517 .5195 .91404 .51726 Mtetra
.562 .5 .743 r
.91404 .51726 .91517 .5195 .91622 .51881 .91509 .51653 Mtetra
.621 .525 .725 r
.91509 .51653 .91622 .51881 .91722 .51756 .91608 .51519 Mtetra
.661 .54 .706 r
.91608 .51519 .91722 .51756 .91816 .51573 .91701 .51322 Mtetra
.688 .547 .689 r
.91701 .51322 .91816 .51573 .91905 .51331 .91787 .51059 Mtetra
.704 .549 .675 r
.91787 .51059 .91905 .51331 .91988 .51029 .91868 .50732 Mtetra
.713 .548 .664 r
.91868 .50732 .91988 .51029 .92066 .50672 .91943 .50346 Mtetra
.714 .543 .656 r
.91943 .50346 .92066 .50672 .92139 .50275 .92014 .49915 Mtetra
.707 .534 .653 r
.92014 .49915 .92139 .50275 .92212 .49862 .92082 .49466 Mtetra
.691 .521 .652 r
.92082 .49466 .92212 .49862 .92285 .49465 .92153 .49037 Mtetra
.663 .501 .656 r
.92153 .49037 .92285 .49465 .92365 .49127 .92229 .48671 Mtetra
.616 .471 .662 r
.92229 .48671 .92365 .49127 .92453 .48889 .92316 .48413 Mtetra
.538 .422 .669 r
.92316 .48413 .92453 .48889 .92555 .48781 .92417 .48297 Mtetra
.413 .343 .67 r
.92417 .48297 .92555 .48781 .9267 .48815 .92533 .48337 Mtetra
.217 .22 .648 r
.92533 .48337 .9267 .48815 .92799 .48985 .92663 .48523 Mtetra
0 .056 .582 r
.92663 .48523 .92799 .48985 .92938 .49262 .92805 .48826 Mtetra
0 0 .481 r
.92805 .48826 .92938 .49262 .93085 .49606 .92954 .49203 Mtetra
0 0 .395 r
.92954 .49203 .93085 .49606 .93234 .49977 .93106 .49609 Mtetra
0 0 .359 r
.93106 .49609 .93234 .49977 .93382 .50337 .93258 .50003 Mtetra
0 0 .382 r
.93258 .50003 .93382 .50337 .93527 .50661 .93406 .50358 Mtetra
0 0 .457 r
.93406 .50358 .93527 .50661 .93668 .50933 .93549 .50656 Mtetra
0 0 .565 r
.93549 .50656 .93668 .50933 .93802 .51146 .93685 .5089 Mtetra
0 .141 .668 r
.93685 .5089 .93802 .51146 .93931 .51299 .93816 .51059 Mtetra
.178 .283 .735 r
.93816 .51059 .93931 .51299 .94054 .51393 .9394 .51163 Mtetra
.351 .389 .761 r
.9394 .51163 .94054 .51393 .94172 .51431 .94058 .51206 Mtetra
.477 .459 .759 r
.94058 .51206 .94172 .51431 .94285 .51414 .9417 .5119 Mtetra
.563 .501 .744 r
.9417 .5119 .94285 .51414 .94392 .51343 .94277 .51114 Mtetra
.622 .527 .725 r
.94277 .51114 .94392 .51343 .94493 .51215 .94378 .50977 Mtetra
.662 .541 .706 r
.94378 .50977 .94493 .51215 .94589 .51029 .94472 .50775 Mtetra
.689 .547 .688 r
.94472 .50775 .94589 .51029 .94678 .50782 .94559 .50508 Mtetra
.705 .549 .674 r
.94559 .50508 .94678 .50782 .94762 .50475 .9464 .50176 Mtetra
.713 .547 .663 r
.9464 .50176 .94762 .50475 .9484 .50114 .94715 .49784 Mtetra
.714 .542 .656 r
.94715 .49784 .9484 .50114 .94913 .49712 .94785 .49348 Mtetra
.707 .534 .652 r
.94785 .49348 .94913 .49712 .94985 .49295 .94853 .48896 Mtetra
.69 .52 .652 r
.94853 .48896 .94985 .49295 .95059 .48898 .94924 .48465 Mtetra
.66 .5 .656 r
.94924 .48465 .95059 .48898 .9514 .48562 .95001 .48101 Mtetra
.612 .468 .662 r
.95001 .48101 .9514 .48562 .9523 .48328 .9509 .47848 Mtetra
.532 .418 .669 r
.9509 .47848 .9523 .48328 .95334 .48227 .95193 .4774 Mtetra
.404 .338 .67 r
.95193 .4774 .95334 .48227 .95454 .4827 .95313 .47789 Mtetra
.208 .216 .647 r
.95313 .47789 .95454 .4827 .95587 .48449 .95448 .47985 Mtetra
0 .055 .583 r
.95448 .47985 .95587 .48449 .95732 .48735 .95596 .48298 Mtetra
0 0 .487 r
.95596 .48298 .95732 .48735 .95884 .49086 .95751 .48682 Mtetra
0 0 .407 r
.95751 .48682 .95884 .49086 .96039 .49462 .9591 .49093 Mtetra
0 0 .375 r
.9591 .49093 .96039 .49462 .96193 .49826 .96067 .49492 Mtetra
0 0 .4 r
.96067 .49492 .96193 .49826 .96344 .50153 .9622 .49849 Mtetra
0 0 .474 r
.9622 .49849 .96344 .50153 .96489 .50426 .96368 .50149 Mtetra
0 .005 .578 r
.96368 .50149 .96489 .50426 .96628 .50639 .96509 .50383 Mtetra
0 .154 .676 r
.96509 .50383 .96628 .50639 .9676 .50792 .96643 .50551 Mtetra
.188 .291 .739 r
.96643 .50551 .9676 .50792 .96887 .50885 .96771 .50655 Mtetra
.357 .394 .762 r
.96771 .50655 .96887 .50885 .97008 .50922 .96892 .50696 Mtetra
.48 .461 .76 r
.96892 .50696 .97008 .50922 .97123 .50903 .97007 .50678 Mtetra
.565 .503 .745 r
.97007 .50678 .97123 .50903 .97232 .50829 .97116 .50599 Mtetra
.624 .528 .725 r
.97116 .50599 .97232 .50829 .97336 .50698 .97218 .50458 Mtetra
.664 .541 .705 r
.97218 .50458 .97336 .50698 .97432 .50508 .97314 .50253 Mtetra
.69 .548 .688 r
.97314 .50253 .97432 .50508 .97523 .50257 .97402 .4998 Mtetra
.706 .55 .673 r
.97402 .4998 .97523 .50257 .97607 .49944 .97483 .49642 Mtetra
.714 .547 .662 r
.97483 .49642 .97607 .49944 .97685 .49578 .97557 .49244 Mtetra
.714 .542 .655 r
.97557 .49244 .97685 .49578 .97758 .49171 .97627 .48803 Mtetra
.706 .533 .651 r
.97627 .48803 .97758 .49171 .9783 .48751 .97695 .48347 Mtetra
.689 .519 .652 r
.97695 .48347 .9783 .48751 .97904 .48352 .97765 .47914 Mtetra
.658 .498 .656 r
.97765 .47914 .97904 .48352 .97985 .48017 .97843 .47551 Mtetra
.608 .466 .663 r
.97843 .47551 .97985 .48017 .98078 .47788 .97934 .47303 Mtetra
.526 .415 .67 r
.97934 .47303 .98078 .47788 .98185 .47694 .98041 .47202 Mtetra
.433 .338 .648 r
.5175 .67271 .51845 .67816 .51922 .67826 .51827 .67288 Mtetra
.22 .191 .611 r
.51827 .67288 .51922 .67826 .52 .67963 .51905 .67446 Mtetra
0 0 .504 r
.51905 .67446 .52 .67963 .52078 .68199 .51983 .67715 Mtetra
0 0 .33 r
.51983 .67715 .52078 .68199 .52157 .68496 .52062 .68051 Mtetra
0 0 .188 r
.52062 .68051 .52157 .68496 .52236 .68814 .52141 .68411 Mtetra
.713 .449 0 r
.52141 .68411 .52236 .68814 .52315 .69119 .52221 .68756 Mtetra
0 0 .18 r
.52221 .68756 .52315 .69119 .52394 .69387 .523 .6906 Mtetra
0 0 .31 r
.523 .6906 .52394 .69387 .52473 .69604 .52379 .69307 Mtetra
0 0 .493 r
.52379 .69307 .52473 .69604 .52552 .69763 .52458 .69492 Mtetra
.029 .137 .643 r
.52458 .69492 .52552 .69763 .5263 .69866 .52536 .69611 Mtetra
.287 .311 .712 r
.52536 .69611 .5263 .69866 .52708 .69912 .52614 .69669 Mtetra
.453 .416 .727 r
.52614 .69669 .52708 .69912 .52786 .69904 .52692 .69667 Mtetra
.553 .474 .72 r
.52692 .69667 .52786 .69904 .52863 .69845 .52769 .69607 Mtetra
.616 .507 .708 r
.52769 .69607 .52863 .69845 .5294 .69732 .52846 .69489 Mtetra
.655 .526 .695 r
.52846 .69489 .5294 .69732 .53016 .69566 .52922 .69311 Mtetra
.681 .537 .683 r
.52922 .69311 .53016 .69566 .53092 .69344 .52998 .6907 Mtetra
.697 .542 .673 r
.52998 .6907 .53092 .69344 .53168 .69064 .53073 .68765 Mtetra
.706 .543 .665 r
.53073 .68765 .53168 .69064 .53243 .68726 .53148 .68396 Mtetra
.71 .541 .658 r
.53148 .68396 .53243 .68726 .53317 .68338 .53222 .67972 Mtetra
.708 .537 .654 r
.53222 .67972 .53317 .68338 .53391 .67914 .53296 .67506 Mtetra
.701 .529 .652 r
.53296 .67506 .53391 .67914 .53465 .67477 .53369 .67028 Mtetra
.686 .516 .651 r
.53369 .67028 .53465 .67477 .53539 .67064 .53443 .66575 Mtetra
.66 .497 .652 r
.53443 .66575 .53539 .67064 .53614 .66713 .53517 .66191 Mtetra
.618 .467 .654 r
.53517 .66191 .53614 .66713 .53689 .66463 .53592 .6592 Mtetra
.547 .417 .655 r
.53592 .6592 .53689 .66463 .53766 .66342 .53669 .65792 Mtetra
.425 .332 .647 r
.53669 .65792 .53766 .66342 .53844 .66359 .53747 .65817 Mtetra
.212 .185 .609 r
.53747 .65817 .53844 .66359 .53924 .66503 .53827 .65983 Mtetra
0 0 .505 r
.53827 .65983 .53924 .66503 .54004 .66744 .53908 .66258 Mtetra
0 0 .34 r
.53908 .66258 .54004 .66744 .54086 .67045 .53989 .66598 Mtetra
0 0 .208 r
.53989 .66598 .54086 .67045 .54168 .67365 .54072 .6696 Mtetra
0 0 .164 r
.54072 .6696 .54168 .67365 .5425 .6767 .54154 .67305 Mtetra
0 0 .21 r
.54154 .67305 .5425 .6767 .54332 .67937 .54236 .67609 Mtetra
0 0 .34 r
.54236 .67609 .54332 .67937 .54413 .68153 .54317 .67855 Mtetra
0 0 .514 r
.54317 .67855 .54413 .68153 .54494 .68311 .54398 .68037 Mtetra
.056 .155 .652 r
.54398 .68037 .54494 .68311 .54574 .68411 .54478 .68155 Mtetra
.3 .319 .713 r
.54478 .68155 .54574 .68411 .54653 .68456 .54558 .6821 Mtetra
.458 .418 .726 r
.54558 .6821 .54653 .68456 .54732 .68446 .54637 .68206 Mtetra
.555 .475 .719 r
.54637 .68206 .54732 .68446 .54811 .68384 .54716 .68143 Mtetra
.616 .507 .707 r
.54716 .68143 .54811 .68384 .54889 .68269 .54793 .68022 Mtetra
.655 .526 .694 r
.54793 .68022 .54889 .68269 .54966 .681 .5487 .6784 Mtetra
.68 .536 .682 r
.5487 .6784 .54966 .681 .55042 .67874 .54946 .67596 Mtetra
.697 .541 .672 r
.54946 .67596 .55042 .67874 .55118 .67591 .55022 .67287 Mtetra
.706 .542 .664 r
.55022 .67287 .55118 .67591 .55193 .6725 .55096 .66914 Mtetra
.709 .54 .658 r
.55096 .66914 .55193 .6725 .55267 .66858 .5517 .66485 Mtetra
.708 .535 .653 r
.5517 .66485 .55267 .66858 .55341 .66431 .55243 .66017 Mtetra
.7 .527 .651 r
.55243 .66017 .55341 .66431 .55414 .65993 .55316 .65538 Mtetra
.684 .514 .651 r
.55316 .65538 .55414 .65993 .55488 .65581 .55389 .65086 Mtetra
.658 .494 .652 r
.55389 .65086 .55488 .65581 .55562 .65233 .55463 .64706 Mtetra
.614 .463 .654 r
.55463 .64706 .55562 .65233 .55638 .64989 .55539 .64441 Mtetra
.542 .413 .654 r
.55539 .64441 .55638 .64989 .55716 .64874 .55616 .6432 Mtetra
.416 .326 .646 r
.55616 .6432 .55716 .64874 .55796 .64899 .55696 .64354 Mtetra
.203 .18 .608 r
.55696 .64354 .55796 .64899 .55878 .6505 .55778 .64528 Mtetra
0 0 .505 r
.55778 .64528 .55878 .6505 .55961 .65297 .55862 .64809 Mtetra
0 0 .35 r
.55862 .64809 .55961 .65297 .56045 .65602 .55947 .65153 Mtetra
0 0 .228 r
.55947 .65153 .56045 .65602 .5613 .65924 .56032 .65517 Mtetra
0 0 .19 r
.56032 .65517 .5613 .65924 .56215 .6623 .56117 .65864 Mtetra
0 0 .24 r
.56117 .65864 .56215 .6623 .56299 .66497 .56202 .66166 Mtetra
0 0 .368 r
.56202 .66166 .56299 .66497 .56383 .66711 .56286 .66411 Mtetra
0 0 .533 r
.56286 .66411 .56383 .66711 .56465 .66868 .56369 .66592 Mtetra
.079 .17 .659 r
.56369 .66592 .56465 .66868 .56547 .66967 .56451 .66708 Mtetra
.311 .325 .714 r
.56451 .66708 .56547 .66967 .56629 .67009 .56532 .66761 Mtetra
.462 .42 .725 r
.56532 .66761 .56629 .67009 .56709 .66998 .56613 .66755 Mtetra
.557 .475 .718 r
.56613 .66755 .56709 .66998 .56789 .66934 .56692 .66689 Mtetra
.616 .506 .706 r
.56692 .66689 .56789 .66934 .56867 .66816 .56771 .66566 Mtetra
.655 .525 .693 r
.56771 .66566 .56867 .66816 .56945 .66645 .56849 .66381 Mtetra
.68 .535 .681 r
.56849 .66381 .56945 .66645 .57022 .66416 .56925 .66133 Mtetra
.696 .54 .671 r
.56925 .66133 .57022 .66416 .57098 .66129 .57001 .6582 Mtetra
.705 .541 .663 r
.57001 .6582 .57098 .66129 .57173 .65784 .57075 .65444 Mtetra
.709 .539 .657 r
.57075 .65444 .57173 .65784 .57247 .6539 .57148 .65011 Mtetra
.706 .534 .653 r
.57148 .65011 .57247 .6539 .5732 .6496 .57221 .64541 Mtetra
.698 .526 .65 r
.57221 .64541 .5732 .6496 .57393 .64522 .57293 .6406 Mtetra
.682 .512 .65 r
.57293 .6406 .57393 .64522 .57467 .64111 .57366 .63609 Mtetra
.655 .492 .651 r
.57366 .63609 .57467 .64111 .57541 .63767 .5744 .63234 Mtetra
.61 .46 .653 r
.5744 .63234 .57541 .63767 .57618 .63528 .57516 .62975 Mtetra
.535 .408 .654 r
.57516 .62975 .57618 .63528 .57697 .63421 .57595 .62862 Mtetra
.408 .321 .645 r
.57595 .62862 .57697 .63421 .57778 .63454 .57676 .62905 Mtetra
.194 .174 .606 r
.57676 .62905 .57778 .63454 .57862 .63612 .57761 .63087 Mtetra
0 0 .506 r
.57761 .63087 .57862 .63612 .57948 .63866 .57847 .63374 Mtetra
0 0 .36 r
.57847 .63374 .57948 .63866 .58036 .64175 .57935 .63724 Mtetra
0 0 .246 r
.57935 .63724 .58036 .64175 .58123 .64499 .58023 .6409 Mtetra
0 0 .214 r
.58023 .6409 .58123 .64499 .58211 .64806 .58112 .64437 Mtetra
0 0 .267 r
.58112 .64437 .58211 .64806 .58298 .65073 .58199 .6474 Mtetra
0 0 .394 r
.58199 .6474 .58298 .65073 .58384 .65287 .58286 .64984 Mtetra
0 0 .549 r
.58286 .64984 .58384 .65287 .58469 .65442 .58371 .65163 Mtetra
.099 .183 .665 r
.58371 .65163 .58469 .65442 .58553 .6554 .58455 .65278 Mtetra
.32 .331 .715 r
.58455 .65278 .58553 .6554 .58636 .65581 .58538 .65329 Mtetra
.466 .422 .725 r
.58538 .65329 .58636 .65581 .58718 .65568 .5862 .65321 Mtetra
.557 .475 .717 r
.5862 .65321 .58718 .65568 .58798 .65502 .58701 .65254 Mtetra
.616 .506 .705 r
.58701 .65254 .58798 .65502 .58878 .65382 .58781 .65128 Mtetra
.654 .524 .692 r
.58781 .65128 .58878 .65382 .58957 .65208 .58859 .6494 Mtetra
.679 .534 .681 r
.58859 .6494 .58957 .65208 .59034 .64977 .58936 .64689 Mtetra
.695 .539 .67 r
.58936 .64689 .59034 .64977 .5911 .64687 .59011 .64373 Mtetra
.704 .54 .662 r
.59011 .64373 .5911 .64687 .59185 .64339 .59085 .63993 Mtetra
.708 .538 .656 r
.59085 .63993 .59185 .64339 .59259 .63941 .59158 .63557 Mtetra
.705 .533 .652 r
.59158 .63557 .59259 .63941 .59332 .6351 .5923 .63084 Mtetra
.697 .524 .65 r
.5923 .63084 .59332 .6351 .59404 .63072 .59302 .62603 Mtetra
.68 .51 .65 r
.59302 .62603 .59404 .63072 .59477 .62662 .59374 .62154 Mtetra
.652 .489 .651 r
.59374 .62154 .59477 .62662 .59552 .62322 .59448 .61783 Mtetra
.605 .457 .653 r
.59448 .61783 .59552 .62322 .59629 .6209 .59525 .61531 Mtetra
.529 .403 .654 r
.59525 .61531 .59629 .6209 .59709 .61991 .59605 .61427 Mtetra
.399 .314 .644 r
.59605 .61427 .59709 .61991 .59793 .62032 .59688 .61478 Mtetra
.185 .168 .605 r
.59688 .61478 .59793 .62032 .59879 .62198 .59775 .61669 Mtetra
0 0 .507 r
.59775 .61669 .59879 .62198 .59968 .62458 .59865 .61964 Mtetra
0 0 .368 r
.59865 .61964 .59968 .62458 .60058 .62771 .59956 .62318 Mtetra
0 0 .264 r
.59956 .62318 .60058 .62771 .60149 .63098 .60047 .62687 Mtetra
0 0 .238 r
.60047 .62687 .60149 .63098 .6024 .63407 .60139 .63036 Mtetra
0 0 .293 r
.60139 .63036 .6024 .63407 .60329 .63674 .60229 .63339 Mtetra
0 0 .416 r
.60229 .63339 .60329 .63674 .60418 .63887 .60318 .63582 Mtetra
0 .005 .563 r
.60318 .63582 .60418 .63887 .60505 .64042 .60406 .6376 Mtetra
.117 .195 .669 r
.60406 .6376 .60505 .64042 .60591 .64139 .60492 .63874 Mtetra
.328 .335 .715 r
.60492 .63874 .60591 .64139 .60676 .64179 .60577 .63924 Mtetra
.468 .422 .724 r
.60577 .63924 .60676 .64179 .60759 .64164 .60661 .63915 Mtetra
.558 .474 .717 r
.60661 .63915 .60759 .64164 .60841 .64097 .60743 .63846 Mtetra
.615 .505 .705 r
.60743 .63846 .60841 .64097 .60922 .63976 .60823 .63717 Mtetra
.653 .523 .692 r
.60823 .63717 .60922 .63976 .61001 .638 .60902 .63527 Mtetra
.678 .533 .68 r
.60902 .63527 .61001 .638 .61079 .63566 .6098 .63273 Mtetra
.694 .537 .67 r
.6098 .63273 .61079 .63566 .61156 .63273 .61055 .62954 Mtetra
.704 .538 .662 r
.61055 .62954 .61156 .63273 .6123 .62922 .61129 .6257 Mtetra
.707 .536 .655 r
.61129 .6257 .6123 .62922 .61304 .62522 .61202 .62132 Mtetra
.704 .531 .651 r
.61202 .62132 .61304 .62522 .61376 .6209 .61273 .61657 Mtetra
.695 .522 .649 r
.61273 .61657 .61376 .6209 .61449 .61651 .61344 .61176 Mtetra
.678 .508 .649 r
.61344 .61176 .61449 .61651 .61521 .61243 .61416 .60729 Mtetra
.648 .487 .651 r
.61416 .60729 .61521 .61243 .61596 .60908 .6149 .60363 Mtetra
.601 .453 .653 r
.6149 .60363 .61596 .60908 .61674 .60683 .61567 .60118 Mtetra
.522 .399 .653 r
.61567 .60118 .61674 .60683 .61756 .60592 .61648 .60023 Mtetra
.389 .308 .643 r
.61648 .60023 .61756 .60592 .61841 .60642 .61734 .60084 Mtetra
.175 .162 .603 r
.61734 .60084 .61841 .60642 .6193 .60816 .61824 .60284 Mtetra
0 0 .507 r
.61824 .60284 .6193 .60816 .62022 .61082 .61916 .60586 Mtetra
0 0 .377 r
.61916 .60586 .62022 .61082 .62116 .61401 .62011 .60945 Mtetra
0 0 .281 r
.62011 .60945 .62116 .61401 .6221 .61731 .62106 .61318 Mtetra
0 0 .259 r
.62106 .61318 .6221 .61731 .62303 .62042 .62201 .61669 Mtetra
0 0 .316 r
.62201 .61669 .62303 .62042 .62396 .6231 .62294 .61972 Mtetra
0 0 .437 r
.62294 .61972 .62396 .6231 .62487 .62523 .62386 .62216 Mtetra
0 .023 .575 r
.62386 .62216 .62487 .62523 .62577 .62678 .62476 .62394 Mtetra
.131 .204 .673 r
.62476 .62394 .62577 .62678 .62665 .62774 .62564 .62506 Mtetra
.333 .338 .716 r
.62564 .62506 .62665 .62774 .62751 .62813 .62651 .62556 Mtetra
.47 .423 .723 r
.62651 .62556 .62751 .62813 .62836 .62798 .62736 .62545 Mtetra
.557 .473 .716 r
.62736 .62545 .62836 .62798 .62919 .6273 .62819 .62475 Mtetra
.615 .504 .704 r
.62819 .62475 .62919 .6273 .63001 .62608 .62901 .62345 Mtetra
.652 .521 .691 r
.62901 .62345 .63001 .62608 .63081 .6243 .62981 .62153 Mtetra
.677 .531 .679 r
.62981 .62153 .63081 .6243 .6316 .62194 .63058 .61896 Mtetra
.694 .536 .669 r
.63058 .61896 .6316 .62194 .63236 .61898 .63134 .61574 Mtetra
.703 .537 .661 r
.63134 .61574 .63236 .61898 .63311 .61545 .63208 .61187 Mtetra
.706 .535 .655 r
.63208 .61187 .63311 .61545 .63384 .61143 .6328 .60746 Mtetra
.703 .53 .651 r
.6328 .60746 .63384 .61143 .63456 .60709 .63351 .60269 Mtetra
.693 .52 .649 r
.63351 .60269 .63456 .60709 .63528 .60271 .63421 .59789 Mtetra
.675 .506 .649 r
.63421 .59789 .63528 .60271 .63601 .59866 .63493 .59345 Mtetra
.645 .484 .65 r
.63493 .59345 .63601 .59866 .63676 .59535 .63567 .58984 Mtetra
.596 .449 .653 r
.63567 .58984 .63676 .59535 .63755 .59317 .63645 .58747 Mtetra
.514 .393 .653 r
.63645 .58747 .63755 .59317 .63838 .59235 .63728 .58662 Mtetra
.38 .302 .642 r
.63728 .58662 .63838 .59235 .63925 .59294 .63816 .58733 Mtetra
.165 .156 .601 r
.63816 .58733 .63925 .59294 .64017 .59477 .63908 .58942 Mtetra
0 0 .508 r
.63908 .58942 .64017 .59477 .64112 .59751 .64004 .59251 Mtetra
0 0 .384 r
.64004 .59251 .64112 .59751 .64209 .60075 .64102 .59617 Mtetra
0 0 .296 r
.64102 .59617 .64209 .60075 .64306 .60409 .64201 .59994 Mtetra
0 0 .279 r
.64201 .59994 .64306 .60409 .64403 .60722 .64299 .60347 Mtetra
0 0 .338 r
.64299 .60347 .64403 .60722 .64499 .60991 .64395 .60651 Mtetra
0 0 .454 r
.64395 .60651 .64499 .60991 .64592 .61205 .6449 .60895 Mtetra
0 .039 .585 r
.6449 .60895 .64592 .61205 .64685 .6136 .64583 .61073 Mtetra
.143 .212 .676 r
.64583 .61073 .64685 .6136 .64775 .61456 .64673 .61186 Mtetra
.338 .341 .716 r
.64673 .61186 .64775 .61456 .64863 .61495 .64762 .61235 Mtetra
.47 .423 .723 r
.64762 .61235 .64863 .61495 .6495 .6148 .64848 .61223 Mtetra
.557 .473 .715 r
.64848 .61223 .6495 .6148 .65034 .61411 .64933 .61152 Mtetra
.613 .502 .703 r
.64933 .61152 .65034 .61411 .65117 .61288 .65016 .61021 Mtetra
.651 .52 .691 r
.65016 .61021 .65117 .61288 .65198 .61108 .65096 .60827 Mtetra
.676 .53 .679 r
.65096 .60827 .65198 .61108 .65277 .6087 .65174 .60568 Mtetra
.693 .535 .668 r
.65174 .60568 .65277 .6087 .65354 .60573 .6525 .60243 Mtetra
.702 .536 .66 r
.6525 .60243 .65354 .60573 .65429 .60218 .65324 .59854 Mtetra
.705 .534 .654 r
.65324 .59854 .65429 .60218 .65501 .59814 .65395 .5941 Mtetra
.701 .528 .65 r
.65395 .5941 .65501 .59814 .65573 .59379 .65465 .58933 Mtetra
.691 .518 .648 r
.65465 .58933 .65573 .59379 .65645 .58941 .65535 .58453 Mtetra
.673 .504 .648 r
.65535 .58453 .65645 .58941 .65717 .58539 .65607 .58012 Mtetra
.641 .481 .65 r
.65607 .58012 .65717 .58539 .65793 .58215 .65681 .57657 Mtetra
.59 .445 .652 r
.65681 .57657 .65793 .58215 .65873 .58004 .6576 .57428 Mtetra
.507 .388 .652 r
.6576 .57428 .65873 .58004 .65957 .57931 .65844 .57353 Mtetra
.369 .295 .641 r
.65844 .57353 .65957 .57931 .66047 .58 .65935 .57435 Mtetra
.155 .149 .599 r
.65935 .57435 .66047 .58 .66142 .58192 .6603 .57653 Mtetra
0 0 .508 r
.6603 .57653 .66142 .58192 .6624 .58474 .6613 .57972 Mtetra
0 0 .391 r
.6613 .57972 .6624 .58474 .66341 .58804 .66232 .58343 Mtetra
0 0 .309 r
.66232 .58343 .66341 .58804 .66442 .59142 .66334 .58725 Mtetra
0 0 .297 r
.66334 .58725 .66442 .59142 .66542 .59458 .66435 .59081 Mtetra
0 0 .356 r
.66435 .59081 .66542 .59458 .6664 .59729 .66535 .59387 Mtetra
0 0 .47 r
.66535 .59387 .6664 .59729 .66737 .59944 .66633 .59632 Mtetra
0 .052 .593 r
.66633 .59632 .66737 .59944 .66832 .601 .66728 .5981 Mtetra
.153 .219 .679 r
.66728 .5981 .66832 .601 .66924 .60196 .66821 .59923 Mtetra
.341 .343 .716 r
.66821 .59923 .66924 .60196 .67014 .60236 .66912 .59972 Mtetra
.47 .422 .722 r
.66912 .59972 .67014 .60236 .67102 .6022 .67 .5996 Mtetra
.556 .471 .715 r
.67 .5996 .67102 .6022 .67189 .60151 .67086 .59889 Mtetra
.612 .501 .703 r
.67086 .59889 .67189 .60151 .67273 .60027 .6717 .59756 Mtetra
.65 .519 .69 r
.6717 .59756 .67273 .60027 .67355 .59847 .67251 .59561 Mtetra
.675 .529 .678 r
.67251 .59561 .67355 .59847 .67434 .59607 .6733 .593 Mtetra
.691 .534 .668 r
.6733 .593 .67434 .59607 .67511 .59308 .67406 .58973 Mtetra
.701 .534 .66 r
.67406 .58973 .67511 .59308 .67586 .58951 .67479 .58581 Mtetra
.703 .532 .653 r
.67479 .58581 .67586 .58951 .67658 .58545 .6755 .58136 Mtetra
.7 .526 .65 r
.6755 .58136 .67658 .58545 .6773 .5811 .6762 .57657 Mtetra
.69 .517 .648 r
.6762 .57657 .6773 .5811 .67801 .57673 .67689 .57178 Mtetra
.67 .501 .648 r
.67689 .57178 .67801 .57673 .67874 .57275 .6776 .56741 Mtetra
.638 .478 .65 r
.6776 .56741 .67874 .57275 .6795 .56956 .67835 .56392 Mtetra
.585 .441 .652 r
.67835 .56392 .6795 .56956 .68031 .56754 .67915 .56173 Mtetra
.499 .382 .652 r
.67915 .56173 .68031 .56754 .68117 .56691 .68001 .56108 Mtetra
.359 .288 .64 r
.68001 .56108 .68117 .56691 .6821 .5677 .68094 .56201 Mtetra
.144 .143 .597 r
.68094 .56201 .6821 .5677 .68308 .56972 .68193 .5643 Mtetra
0 0 .507 r
.68193 .5643 .68308 .56972 .68409 .57262 .68296 .56757 Mtetra
0 0 .397 r
.68296 .56757 .68409 .57262 .68513 .57598 .68402 .57136 Mtetra
0 0 .322 r
.68402 .57136 .68513 .57598 .68618 .57941 .68508 .57522 Mtetra
0 0 .313 r
.68508 .57522 .68618 .57941 .68722 .5826 .68613 .57881 Mtetra
0 0 .373 r
.68613 .57881 .68722 .5826 .68823 .58533 .68717 .5819 Mtetra
0 0 .483 r
.68717 .5819 .68823 .58533 .68923 .5875 .68817 .58436 Mtetra
0 .063 .6 r
.68817 .58436 .68923 .5875 .6902 .58907 .68915 .58615 Mtetra
.16 .224 .681 r
.68915 .58615 .6902 .58907 .69115 .59004 .69011 .58728 Mtetra
.343 .344 .716 r
.69011 .58728 .69115 .59004 .69207 .59045 .69103 .58778 Mtetra
.47 .422 .722 r
.69103 .58778 .69207 .59045 .69297 .5903 .69194 .58767 Mtetra
.554 .47 .715 r
.69194 .58767 .69297 .5903 .69385 .5896 .69281 .58695 Mtetra
.611 .5 .703 r
.69281 .58695 .69385 .5896 .6947 .58836 .69366 .58562 Mtetra
.649 .517 .69 r
.69366 .58562 .6947 .58836 .69553 .58655 .69448 .58365 Mtetra
.674 .527 .678 r
.69448 .58365 .69553 .58655 .69633 .58414 .69527 .58103 Mtetra
.69 .532 .667 r
.69527 .58103 .69633 .58414 .69711 .58113 .69603 .57773 Mtetra
.7 .533 .659 r
.69603 .57773 .69711 .58113 .69785 .57754 .69676 .57379 Mtetra
.702 .531 .653 r
.69676 .57379 .69785 .57754 .69858 .57347 .69747 .56932 Mtetra
.699 .525 .649 r
.69747 .56932 .69858 .57347 .69929 .56912 .69816 .56453 Mtetra
.688 .515 .647 r
.69816 .56453 .69929 .56912 .7 .56477 .69885 .55975 Mtetra
.667 .499 .648 r
.69885 .55975 .7 .56477 .70073 .56082 .69956 .55542 Mtetra
.634 .475 .65 r
.69956 .55542 .70073 .56082 .70149 .5577 .70031 .55199 Mtetra
.579 .437 .652 r
.70031 .55199 .70149 .5577 .70231 .55576 .70112 .54989 Mtetra
.49 .377 .651 r
.70112 .54989 .70231 .55576 .7032 .55523 .70201 .54936 Mtetra
.348 .281 .639 r
.70201 .54936 .7032 .55523 .70415 .55613 .70297 .5504 Mtetra
.133 .136 .595 r
.70297 .5504 .70415 .55613 .70516 .55825 .70399 .5528 Mtetra
0 0 .507 r
.70399 .5528 .70516 .55825 .70622 .56123 .70506 .55616 Mtetra
0 0 .402 r
.70506 .55616 .70622 .56123 .7073 .56467 .70616 .56002 Mtetra
0 0 .333 r
.70616 .56002 .7073 .56467 .70838 .56815 .70726 .56394 Mtetra
0 0 .328 r
.70726 .56394 .70838 .56815 .70945 .57137 .70835 .56757 Mtetra
0 0 .388 r
.70835 .56757 .70945 .57137 .71051 .57413 .70942 .57068 Mtetra
0 0 .494 r
.70942 .57068 .71051 .57413 .71153 .57632 .71046 .57316 Mtetra
0 .073 .606 r
.71046 .57316 .71153 .57632 .71253 .5779 .71147 .57497 Mtetra
.165 .228 .683 r
.71147 .57497 .71253 .5779 .7135 .57889 .71245 .57611 Mtetra
.343 .345 .717 r
.71245 .57611 .7135 .57889 .71445 .5793 .7134 .57661 Mtetra
.468 .421 .722 r
.7134 .57661 .71445 .5793 .71537 .57916 .71432 .5765 Mtetra
.553 .469 .715 r
.71432 .5765 .71537 .57916 .71626 .57847 .71521 .57578 Mtetra
.609 .499 .703 r
.71521 .57578 .71626 .57847 .71713 .57723 .71607 .57445 Mtetra
.647 .516 .69 r
.71607 .57445 .71713 .57723 .71796 .57541 .7169 .57247 Mtetra
.673 .526 .677 r
.7169 .57247 .71796 .57541 .71877 .57299 .71769 .56983 Mtetra
.689 .531 .667 r
.71769 .56983 .71877 .57299 .71955 .56996 .71846 .56652 Mtetra
.699 .532 .659 r
.71846 .56652 .71955 .56996 .7203 .56636 .71919 .56256 Mtetra
.701 .529 .652 r
.71919 .56256 .7203 .56636 .72102 .56228 .71989 .55807 Mtetra
.697 .523 .648 r
.71989 .55807 .72102 .56228 .72173 .55792 .72058 .55327 Mtetra
.686 .513 .647 r
.72058 .55327 .72173 .55792 .72244 .55358 .72126 .5485 Mtetra
.664 .496 .647 r
.72126 .5485 .72244 .55358 .72317 .54968 .72197 .54421 Mtetra
.629 .471 .649 r
.72197 .54421 .72317 .54968 .72394 .54662 .72273 .54086 Mtetra
.573 .433 .652 r
.72273 .54086 .72394 .54662 .72477 .54477 .72355 .53885 Mtetra
.482 .371 .651 r
.72355 .53885 .72477 .54477 .72568 .54435 .72446 .53843 Mtetra
.337 .273 .637 r
.72446 .53843 .72568 .54435 .72666 .54536 .72545 .53959 Mtetra
.122 .129 .593 r
.72545 .53959 .72666 .54536 .72771 .54758 .72651 .5421 Mtetra
0 0 .507 r
.72651 .5421 .72771 .54758 .72881 .55065 .72762 .54556 Mtetra
0 0 .407 r
.72762 .54556 .72881 .55065 .72993 .55416 .72876 .54949 Mtetra
0 0 .343 r
.72876 .54949 .72993 .55416 .73105 .55769 .72991 .55347 Mtetra
0 0 .341 r
.72991 .55347 .73105 .55769 .73216 .56096 .73104 .55714 Mtetra
0 0 .401 r
.73104 .55714 .73216 .56096 .73325 .56374 .73215 .56028 Mtetra
0 0 .504 r
.73215 .56028 .73325 .56374 .73431 .56596 .73322 .56278 Mtetra
0 .081 .611 r
.73322 .56278 .73431 .56596 .73534 .56756 .73426 .5646 Mtetra
.17 .231 .685 r
.73426 .5646 .73534 .56756 .73633 .56856 .73526 .56576 Mtetra
.344 .345 .717 r
.73526 .56576 .73633 .56856 .7373 .56898 .73623 .56627 Mtetra
.467 .421 .723 r
.73623 .56627 .7373 .56898 .73824 .56885 .73717 .56617 Mtetra
.551 .468 .715 r
.73717 .56617 .73824 .56885 .73915 .56816 .73808 .56545 Mtetra
.608 .498 .703 r
.73808 .56545 .73915 .56816 .74003 .56692 .73896 .56411 Mtetra
.646 .515 .69 r
.73896 .56411 .74003 .56692 .74088 .56509 .73979 .56212 Mtetra
.672 .525 .677 r
.73979 .56212 .74088 .56509 .74169 .56266 .7406 .55946 Mtetra
.689 .53 .667 r
.7406 .55946 .74169 .56266 .74247 .55962 .74136 .55613 Mtetra
.698 .531 .658 r
.74136 .55613 .74247 .55962 .74322 .556 .74209 .55214 Mtetra
.7 .528 .652 r
.74209 .55214 .74322 .556 .74394 .5519 .74279 .54764 Mtetra
.696 .522 .648 r
.74279 .54764 .74394 .5519 .74465 .54754 .74347 .54283 Mtetra
.684 .511 .646 r
.74347 .54283 .74465 .54754 .74536 .54322 .74415 .53808 Mtetra
.662 .494 .647 r
.74415 .53808 .74536 .54322 .74609 .53935 .74486 .53383 Mtetra
.625 .468 .649 r
.74486 .53383 .74609 .53935 .74687 .53636 .74562 .53055 Mtetra
.567 .428 .652 r
.74562 .53055 .74687 .53636 .74772 .53461 .74647 .52864 Mtetra
.473 .365 .651 r
.74647 .52864 .74772 .53461 .74865 .53429 .7474 .52833 Mtetra
.325 .266 .636 r
.7474 .52833 .74865 .53429 .74967 .53541 .74842 .52961 Mtetra
.111 .123 .591 r
.74842 .52961 .74967 .53541 .75075 .53774 .74952 .53224 Mtetra
0 0 .506 r
.74952 .53224 .75075 .53774 .75189 .5409 .75068 .53579 Mtetra
0 0 .411 r
.75068 .53579 .75189 .5409 .75305 .54448 .75186 .53981 Mtetra
0 0 .353 r
.75186 .53981 .75305 .54448 .75422 .54807 .75305 .54384 Mtetra
0 0 .354 r
.75305 .54384 .75422 .54807 .75537 .55138 .75423 .54755 Mtetra
0 0 .414 r
.75423 .54755 .75537 .55138 .75649 .5542 .75537 .55072 Mtetra
0 0 .513 r
.75537 .55072 .75649 .5542 .75759 .55643 .75648 .55324 Mtetra
0 .089 .616 r
.75648 .55324 .75759 .55643 .75864 .55805 .75755 .55508 Mtetra
.173 .235 .687 r
.75755 .55508 .75864 .55805 .75967 .55907 .75858 .55625 Mtetra
.344 .346 .718 r
.75858 .55625 .75967 .55907 .76066 .5595 .75958 .55677 Mtetra
.466 .421 .723 r
.75958 .55677 .76066 .5595 .76162 .55937 .76054 .55667 Mtetra
.55 .468 .715 r
.76054 .55667 .76162 .55937 .76255 .55869 .76146 .55596 Mtetra
.607 .497 .703 r
.76146 .55596 .76255 .55869 .76344 .55745 .76235 .55461 Mtetra
.645 .515 .689 r
.76235 .55461 .76344 .55745 .7643 .55561 .7632 .55261 Mtetra
.671 .525 .677 r
.7632 .55261 .7643 .55561 .76512 .55317 .76401 .54994 Mtetra
.688 .529 .666 r
.76401 .54994 .76512 .55317 .76591 .55011 .76477 .54657 Mtetra
.697 .53 .658 r
.76477 .54657 .76591 .55011 .76665 .54647 .7655 .54257 Mtetra
.699 .527 .651 r
.7655 .54257 .76665 .54647 .76737 .54236 .76619 .53804 Mtetra
.694 .52 .647 r
.76619 .53804 .76737 .54236 .76808 .53799 .76687 .53322 Mtetra
.682 .509 .646 r
.76687 .53322 .76808 .53799 .76878 .53369 .76755 .52848 Mtetra
.659 .492 .647 r
.76755 .52848 .76878 .53369 .76952 .52986 .76826 .52427 Mtetra
.621 .465 .649 r
.76826 .52427 .76952 .52986 .77031 .52693 .76903 .52106 Mtetra
.561 .424 .652 r
.76903 .52106 .77031 .52693 .77118 .52527 .76989 .51925 Mtetra
.465 .36 .65 r
.76989 .51925 .77118 .52527 .77214 .52506 .77085 .51906 Mtetra
.314 .259 .635 r
.77085 .51906 .77214 .52506 .77318 .52629 .77191 .52046 Mtetra
.1 .117 .589 r
.77191 .52046 .77318 .52629 .77431 .52872 .77305 .5232 Mtetra
0 0 .507 r
.77305 .5232 .77431 .52872 .77549 .53198 .77425 .52685 Mtetra
0 0 .416 r
.77425 .52685 .77549 .53198 .7767 .53563 .77549 .53094 Mtetra
0 0 .362 r
.77549 .53094 .7767 .53563 .77791 .53928 .77672 .53504 Mtetra
0 0 .366 r
.77672 .53504 .77791 .53928 .7791 .54263 .77794 .53879 Mtetra
0 0 .425 r
.77794 .53879 .7791 .54263 .78026 .54547 .77912 .54199 Mtetra
0 0 .522 r
.77912 .54199 .78026 .54547 .78139 .54773 .78027 .54454 Mtetra
0 .096 .621 r
.78027 .54454 .78139 .54773 .78248 .54937 .78137 .54639 Mtetra
.177 .238 .689 r
.78137 .54639 .78248 .54937 .78354 .5504 .78243 .54757 Mtetra
.344 .347 .719 r
.78243 .54757 .78354 .5504 .78455 .55084 .78345 .5481 Mtetra
.465 .421 .724 r
.78345 .5481 .78455 .55084 .78553 .55072 .78444 .54801 Mtetra
.549 .467 .716 r
.78444 .54801 .78553 .55072 .78648 .55004 .78538 .54729 Mtetra
.606 .497 .703 r
.78538 .54729 .78648 .55004 .78739 .54879 .78628 .54593 Mtetra
.645 .514 .689 r
.78628 .54593 .78739 .54879 .78826 .54695 .78714 .54392 Mtetra
.671 .524 .677 r
.78714 .54392 .78826 .54695 .78909 .54449 .78795 .54122 Mtetra
.687 .529 .666 r
.78795 .54122 .78909 .54449 .78988 .5414 .78872 .53783 Mtetra
.696 .529 .657 r
.78872 .53783 .78988 .5414 .79063 .53774 .78945 .53379 Mtetra
.698 .526 .651 r
.78945 .53379 .79063 .53774 .79134 .53361 .79014 .52924 Mtetra
.693 .519 .647 r
.79014 .52924 .79134 .53361 .79204 .52923 .79081 .52441 Mtetra
.68 .507 .646 r
.79081 .52441 .79204 .52923 .79275 .52494 .79148 .51968 Mtetra
.656 .489 .646 r
.79148 .51968 .79275 .52494 .79349 .52115 .7922 .51551 Mtetra
.617 .462 .649 r
.7922 .51551 .79349 .52115 .79429 .51829 .79298 .51236 Mtetra
.555 .42 .652 r
.79298 .51236 .79429 .51829 .79518 .51671 .79385 .51065 Mtetra
.456 .354 .65 r
.79385 .51065 .79518 .51671 .79616 .51661 .79484 .51057 Mtetra
.303 .253 .634 r
.79484 .51057 .79616 .51661 .79725 .51795 .79594 .51209 Mtetra
.091 .111 .588 r
.79594 .51209 .79725 .51795 .79842 .52049 .79712 .51495 Mtetra
0 0 .507 r
.79712 .51495 .79842 .52049 .79964 .52384 .79838 .5187 Mtetra
0 0 .422 r
.79838 .5187 .79964 .52384 .8009 .52756 .79966 .52287 Mtetra
0 0 .372 r
.79966 .52287 .8009 .52756 .80215 .53127 .80094 .52702 Mtetra
0 0 .378 r
.80094 .52702 .80215 .53127 .80339 .53465 .80221 .53081 Mtetra
0 0 .437 r
.80221 .53081 .80339 .53465 .80459 .53753 .80343 .53404 Mtetra
0 0 .531 r
.80343 .53404 .80459 .53753 .80576 .53981 .80462 .53661 Mtetra
0 .104 .626 r
.80462 .53661 .80576 .53981 .80688 .54146 .80575 .53848 Mtetra
.181 .242 .691 r
.80575 .53848 .80688 .54146 .80796 .5425 .80684 .53967 Mtetra
.345 .349 .72 r
.80684 .53967 .80796 .5425 .80901 .54295 .80789 .5402 Mtetra
.465 .421 .724 r
.80789 .5402 .80901 .54295 .81001 .54284 .8089 .54011 Mtetra
.548 .468 .716 r
.8089 .54011 .81001 .54284 .81097 .54215 .80986 .53938 Mtetra
.605 .496 .703 r
.80986 .53938 .81097 .54215 .8119 .54089 .81077 .53801 Mtetra
.644 .514 .689 r
.81077 .53801 .8119 .54089 .81278 .53904 .81164 .53598 Mtetra
.671 .524 .676 r
.81164 .53598 .81278 .53904 .81362 .53655 .81246 .53325 Mtetra
.687 .528 .665 r
.81246 .53325 .81362 .53655 .81441 .53344 .81323 .52983 Mtetra
.696 .528 .656 r
.81323 .52983 .81441 .53344 .81516 .52975 .81396 .52576 Mtetra
.698 .525 .65 r
.81396 .52576 .81516 .52975 .81588 .52559 .81464 .52118 Mtetra
.692 .518 .646 r
.81464 .52118 .81588 .52559 .81657 .52121 .81531 .51633 Mtetra
.678 .506 .645 r
.81531 .51633 .81657 .52121 .81728 .51692 .81598 .51161 Mtetra
.653 .487 .646 r
.81598 .51161 .81728 .51692 .81802 .51316 .8167 .50747 Mtetra
.613 .459 .649 r
.8167 .50747 .81802 .51316 .81883 .51037 .81749 .50439 Mtetra
.549 .416 .652 r
.81749 .50439 .81883 .51037 .81974 .50888 .81838 .50277 Mtetra
.448 .349 .65 r
.81838 .50277 .81974 .50888 .82076 .50888 .8194 .50281 Mtetra
.293 .246 .633 r
.8194 .50281 .82076 .50888 .82188 .51033 .82054 .50445 Mtetra
.082 .107 .587 r
.82054 .50445 .82188 .51033 .8231 .51297 .82177 .50741 Mtetra
0 0 .508 r
.82177 .50741 .8231 .51297 .82437 .51641 .82308 .51126 Mtetra
0 0 .427 r
.82308 .51126 .82437 .51641 .82568 .52021 .82441 .5155 Mtetra
0 0 .382 r
.82441 .5155 .82568 .52021 .82698 .52396 .82575 .51971 Mtetra
0 0 .39 r
.82575 .51971 .82698 .52396 .82826 .52739 .82706 .52354 Mtetra
0 0 .449 r
.82706 .52354 .82826 .52739 .82951 .53029 .82833 .5268 Mtetra
0 0 .54 r
.82833 .5268 .82951 .53029 .83071 .53259 .82955 .52938 Mtetra
0 .112 .631 r
.82955 .52938 .83071 .53259 .83187 .53425 .83072 .53127 Mtetra
.185 .247 .694 r
.83072 .53127 .83187 .53425 .83298 .5353 .83184 .53246 Mtetra
.347 .351 .722 r
.83184 .53246 .83298 .5353 .83405 .53576 .83292 .533 Mtetra
.465 .422 .725 r
.83292 .533 .83405 .53576 .83507 .53564 .83394 .5329 Mtetra
.548 .468 .717 r
.83394 .5329 .83507 .53564 .83606 .53495 .83492 .53216 Mtetra
.605 .497 .704 r
.83492 .53216 .83606 .53495 .837 .53368 .83585 .53078 Mtetra
.644 .514 .689 r
.83585 .53078 .837 .53368 .83789 .5318 .83673 .52872 Mtetra
.671 .523 .676 r
.83673 .52872 .83789 .5318 .83874 .52929 .83756 .52596 Mtetra
.687 .528 .665 r
.83756 .52596 .83874 .52929 .83953 .52615 .83833 .5225 Mtetra
.696 .528 .656 r
.83833 .5225 .83953 .52615 .84028 .52242 .83905 .51839 Mtetra
.697 .524 .65 r
.83905 .51839 .84028 .52242 .841 .51824 .83973 .51377 Mtetra
.691 .516 .646 r
.83973 .51377 .841 .51824 .84169 .51383 .84039 .5089 Mtetra
.677 .504 .645 r
.84039 .5089 .84169 .51383 .8424 .50955 .84107 .50418 Mtetra
.651 .485 .646 r
.84107 .50418 .8424 .50955 .84315 .50582 .84178 .50007 Mtetra
.609 .456 .649 r
.84178 .50007 .84315 .50582 .84397 .50308 .84259 .49706 Mtetra
.543 .412 .652 r
.84259 .49706 .84397 .50308 .8449 .50168 .8435 .49553 Mtetra
.439 .343 .65 r
.8435 .49553 .8449 .50168 .84595 .50179 .84455 .49567 Mtetra
.283 .241 .633 r
.84455 .49567 .84595 .50179 .84712 .50334 .84573 .49743 Mtetra
.074 .103 .586 r
.84573 .49743 .84712 .50334 .84838 .50608 .84702 .5005 Mtetra
0 0 .51 r
.84702 .5005 .84838 .50608 .8497 .50961 .84838 .50444 Mtetra
0 0 .434 r
.84838 .50444 .8497 .50961 .85106 .51347 .84977 .50876 Mtetra
0 0 .393 r
.84977 .50876 .85106 .51347 .85241 .51728 .85115 .51302 Mtetra
0 0 .403 r
.85115 .51302 .85241 .51728 .85374 .52074 .85251 .51689 Mtetra
0 0 .461 r
.85251 .51689 .85374 .52074 .85503 .52367 .85383 .52018 Mtetra
0 0 .55 r
.85383 .52018 .85503 .52367 .85627 .52598 .85509 .52277 Mtetra
0 .121 .637 r
.85509 .52277 .85627 .52598 .85746 .52766 .8563 .52466 Mtetra
.191 .252 .697 r
.8563 .52466 .85746 .52766 .85861 .52871 .85745 .52586 Mtetra
.349 .353 .723 r
.85745 .52586 .85861 .52871 .8597 .52917 .85856 .5264 Mtetra
.466 .423 .726 r
.85856 .5264 .8597 .52917 .86075 .52904 .85961 .52629 Mtetra
.548 .469 .718 r
.85961 .52629 .86075 .52904 .86175 .52834 .86061 .52554 Mtetra
.605 .497 .704 r
.86061 .52554 .86175 .52834 .86271 .52705 .86155 .52413 Mtetra
.645 .514 .689 r
.86155 .52413 .86271 .52705 .86362 .52515 .86244 .52204 Mtetra
.671 .523 .676 r
.86244 .52204 .86362 .52515 .86447 .52261 .86327 .51924 Mtetra
.687 .527 .664 r
.86327 .51924 .86447 .52261 .86527 .51943 .86405 .51574 Mtetra
.696 .527 .655 r
.86405 .51574 .86527 .51943 .86602 .51566 .86476 .51158 Mtetra
.697 .523 .649 r
.86476 .51158 .86602 .51566 .86673 .51144 .86544 .50692 Mtetra
.69 .515 .645 r
.86544 .50692 .86673 .51144 .86743 .50701 .86609 .50203 Mtetra
.675 .502 .644 r
.86609 .50203 .86743 .50701 .86813 .50273 .86676 .4973 Mtetra
.648 .483 .646 r
.86676 .4973 .86813 .50273 .86888 .49903 .86748 .49322 Mtetra
.605 .453 .649 r
.86748 .49322 .86888 .49903 .86972 .49634 .8683 .49027 Mtetra
.537 .408 .652 r
.8683 .49027 .86972 .49634 .87068 .49502 .86924 .48883 Mtetra
.431 .338 .65 r
.86924 .48883 .87068 .49502 .87176 .49523 .87033 .48908 Mtetra
.274 .235 .632 r
.87033 .48908 .87176 .49523 .87297 .49689 .87155 .49095 Mtetra
.067 .1 .586 r
.87155 .49095 .87297 .49689 .87428 .49973 .87289 .49413 Mtetra
0 0 .513 r
.87289 .49413 .87428 .49973 .87566 .50334 .8743 .49816 Mtetra
0 0 .441 r
.8743 .49816 .87566 .50334 .87707 .50727 .87575 .50255 Mtetra
0 0 .404 r
.87575 .50255 .87707 .50727 .87847 .51113 .87719 .50686 Mtetra
0 0 .416 r
.87719 .50686 .87847 .51113 .87985 .51462 .8786 .51077 Mtetra
0 0 .474 r
.8786 .51077 .87985 .51462 .88118 .51757 .87996 .51407 Mtetra
0 0 .559 r
.87996 .51407 .88118 .51757 .88247 .51989 .88127 .51668 Mtetra
.011 .13 .643 r
.88127 .51668 .88247 .51989 .88369 .52158 .88251 .51858 Mtetra
.197 .257 .7 r
.88251 .51858 .88369 .52158 .88487 .52263 .8837 .51978 Mtetra
.352 .357 .725 r
.8837 .51978 .88487 .52263 .88599 .52308 .88483 .5203 Mtetra
.468 .425 .727 r
.88483 .5203 .88599 .52308 .88707 .52295 .88591 .52018 Mtetra
.549 .47 .718 r
.88591 .52018 .88707 .52295 .88809 .52223 .88692 .51941 Mtetra
.606 .498 .704 r
.88692 .51941 .88809 .52223 .88906 .52092 .88788 .51798 Mtetra
.645 .514 .689 r
.88788 .51798 .88906 .52092 .88998 .51898 .88879 .51585 Mtetra
.671 .523 .675 r
.88879 .51585 .88998 .51898 .89084 .5164 .88962 .51301 Mtetra
.688 .527 .664 r
.88962 .51301 .89084 .5164 .89164 .51318 .8904 .50945 Mtetra
.696 .527 .655 r
.8904 .50945 .89164 .51318 .89239 .50937 .89111 .50524 Mtetra
.696 .522 .648 r
.89111 .50524 .89239 .50937 .8931 .50511 .89178 .50054 Mtetra
.69 .514 .645 r
.89178 .50054 .8931 .50511 .89379 .50065 .89243 .49561 Mtetra
.674 .501 .644 r
.89243 .49561 .89379 .50065 .8945 .49637 .89309 .49088 Mtetra
.646 .481 .646 r
.89309 .49088 .8945 .49637 .89526 .49269 .89382 .48682 Mtetra
.601 .45 .649 r
.89382 .48682 .89526 .49269 .89611 .49006 .89465 .48392 Mtetra
.531 .404 .652 r
.89465 .48392 .89611 .49006 .89709 .48882 .89561 .48257 Mtetra
.424 .334 .65 r
.89561 .48257 .89709 .48882 .89821 .48912 .89674 .48293 Mtetra
.266 .231 .632 r
.89674 .48293 .89821 .48912 .89946 .49088 .89801 .48492 Mtetra
.062 .098 .586 r
.89801 .48492 .89946 .49088 .90083 .49382 .8994 .4882 Mtetra
0 0 .516 r
.8994 .4882 .90083 .49382 .90226 .49751 .90087 .49232 Mtetra
0 0 .449 r
.90087 .49232 .90226 .49751 .90373 .50151 .90238 .49678 Mtetra
0 0 .416 r
.90238 .49678 .90373 .50151 .90519 .50541 .90388 .50114 Mtetra
0 0 .43 r
.90388 .50114 .90519 .50541 .90662 .50893 .90534 .50508 Mtetra
0 0 .487 r
.90534 .50508 .90662 .50893 .90799 .5119 .90675 .5084 Mtetra
0 .009 .569 r
.90675 .5084 .90799 .5119 .90932 .51423 .9081 .51101 Mtetra
.023 .14 .649 r
.9081 .51101 .90932 .51423 .91058 .51591 .90939 .51291 Mtetra
.205 .264 .703 r
.90939 .51291 .91058 .51591 .91179 .51697 .91061 .5141 Mtetra
.356 .36 .726 r
.91061 .5141 .91179 .51697 .91294 .51741 .91177 .51462 Mtetra
.47 .427 .728 r
.91177 .51462 .91294 .51741 .91404 .51726 .91286 .51448 Mtetra
.551 .471 .718 r
.91286 .51448 .91404 .51726 .91509 .51653 .9139 .51369 Mtetra
.607 .498 .704 r
.9139 .51369 .91509 .51653 .91608 .51519 .91488 .51222 Mtetra
.646 .515 .689 r
.91488 .51222 .91608 .51519 .91701 .51322 .91579 .51006 Mtetra
.672 .524 .675 r
.91579 .51006 .91701 .51322 .91787 .51059 .91663 .50716 Mtetra
.688 .527 .663 r
.91663 .50716 .91787 .51059 .91868 .50732 .91741 .50355 Mtetra
.696 .526 .654 r
.91741 .50355 .91868 .50732 .91943 .50346 .91812 .49928 Mtetra
.696 .522 .647 r
.91812 .49928 .91943 .50346 .92014 .49915 .91878 .49452 Mtetra
.689 .513 .644 r
.91878 .49452 .92014 .49915 .92082 .49466 .91942 .48956 Mtetra
.672 .499 .643 r
.91942 .48956 .92082 .49466 .92153 .49037 .92008 .48482 Mtetra
.643 .479 .645 r
.92008 .48482 .92153 .49037 .92229 .48671 .92081 .48078 Mtetra
.597 .448 .649 r
.92081 .48078 .92229 .48671 .92316 .48413 .92165 .47794 Mtetra
.526 .4 .652 r
.92165 .47794 .92316 .48413 .92417 .48297 .92265 .47667 Mtetra
.416 .329 .649 r
.92265 .47667 .92417 .48297 .92533 .48337 .92381 .47714 Mtetra
.258 .227 .631 r
.92381 .47714 .92533 .48337 .92663 .48523 .92513 .47923 Mtetra
.058 .097 .587 r
.92513 .47923 .92663 .48523 .92805 .48826 .92658 .48262 Mtetra
0 0 .52 r
.92658 .48262 .92805 .48826 .92954 .49203 .92812 .48683 Mtetra
0 0 .458 r
.92812 .48683 .92954 .49203 .93106 .49609 .92969 .49135 Mtetra
0 0 .429 r
.92969 .49135 .93106 .49609 .93258 .50003 .93124 .49576 Mtetra
0 0 .444 r
.93124 .49576 .93258 .50003 .93406 .50358 .93276 .49972 Mtetra
0 0 .5 r
.93276 .49972 .93406 .50358 .93549 .50656 .93422 .50306 Mtetra
0 .024 .579 r
.93422 .50306 .93549 .50656 .93685 .5089 .93562 .50568 Mtetra
.037 .151 .655 r
.93562 .50568 .93685 .5089 .93816 .51059 .93694 .50758 Mtetra
.213 .27 .706 r
.93694 .50758 .93816 .51059 .9394 .51163 .93819 .50876 Mtetra
.361 .364 .728 r
.93819 .50876 .9394 .51163 .94058 .51206 .93938 .50926 Mtetra
.472 .429 .729 r
.93938 .50926 .94058 .51206 .9417 .5119 .94051 .5091 Mtetra
.552 .472 .719 r
.94051 .5091 .9417 .5119 .94277 .51114 .94157 .50828 Mtetra
.608 .499 .704 r
.94157 .50828 .94277 .51114 .94378 .50977 .94256 .50678 Mtetra
.647 .515 .689 r
.94256 .50678 .94378 .50977 .94472 .50775 .94348 .50457 Mtetra
.673 .524 .674 r
.94348 .50457 .94472 .50775 .94559 .50508 .94433 .50162 Mtetra
.688 .527 .662 r
.94433 .50162 .94559 .50508 .9464 .50176 .9451 .49795 Mtetra
.696 .526 .653 r
.9451 .49795 .9464 .50176 .94715 .49784 .9458 .49361 Mtetra
.696 .521 .647 r
.9458 .49361 .94715 .49784 .94785 .49348 .94646 .4888 Mtetra
.688 .512 .643 r
.94646 .4888 .94785 .49348 .94853 .48896 .9471 .4838 Mtetra
.671 .498 .643 r
.9471 .4838 .94853 .48896 .94924 .48465 .94775 .47904 Mtetra
.641 .477 .645 r
.94775 .47904 .94924 .48465 .95001 .48101 .94849 .47501 Mtetra
.593 .445 .649 r
.94849 .47501 .95001 .48101 .9509 .47848 .94935 .47223 Mtetra
.52 .397 .652 r
.94935 .47223 .9509 .47848 .95193 .4774 .95037 .47105 Mtetra
.409 .325 .649 r
.95037 .47105 .95193 .4774 .95313 .47789 .95157 .47162 Mtetra
.252 .223 .631 r
.95157 .47162 .95313 .47789 .95448 .47985 .95295 .47382 Mtetra
.056 .096 .588 r
.95295 .47382 .95448 .47985 .95596 .48298 .95446 .47731 Mtetra
0 0 .524 r
.95446 .47731 .95596 .48298 .95751 .48682 .95606 .4816 Mtetra
0 0 .467 r
.95606 .4816 .95751 .48682 .9591 .49093 .95769 .48619 Mtetra
0 0 .442 r
.95769 .48619 .9591 .49093 .96067 .49492 .95931 .49064 Mtetra
0 0 .459 r
.95931 .49064 .96067 .49492 .9622 .49849 .96088 .49463 Mtetra
0 0 .514 r
.96088 .49463 .9622 .49849 .96368 .50149 .9624 .49798 Mtetra
0 .038 .59 r
.9624 .49798 .96368 .50149 .96509 .50383 .96384 .5006 Mtetra
.051 .162 .661 r
.96384 .5006 .96509 .50383 .96643 .50551 .9652 .50249 Mtetra
.222 .277 .709 r
.9652 .50249 .96643 .50551 .96771 .50655 .96649 .50367 Mtetra
.366 .368 .729 r
.96649 .50367 .96771 .50655 .96892 .50696 .96771 .50415 Mtetra
.475 .432 .729 r
.96771 .50415 .96892 .50696 .97007 .50678 .96886 .50397 Mtetra
.554 .474 .719 r
.96886 .50397 .97007 .50678 .97116 .50599 .96994 .50311 Mtetra
.61 .5 .704 r
.96994 .50311 .97116 .50599 .97218 .50458 .97095 .50157 Mtetra
.648 .516 .688 r
.97095 .50157 .97218 .50458 .97314 .50253 .97188 .4993 Mtetra
.673 .524 .674 r
.97188 .4993 .97314 .50253 .97402 .4998 .97273 .4963 Mtetra
.689 .527 .662 r
.97273 .4963 .97402 .4998 .97483 .49642 .9735 .49256 Mtetra
.696 .525 .652 r
.9735 .49256 .97483 .49642 .97557 .49244 .9742 .48816 Mtetra
.696 .52 .646 r
.9742 .48816 .97557 .49244 .97627 .48803 .97485 .48328 Mtetra
.687 .511 .643 r
.97485 .48328 .97627 .48803 .97695 .48347 .97547 .47824 Mtetra
.669 .496 .642 r
.97547 .47824 .97695 .48347 .97765 .47914 .97613 .47346 Mtetra
.638 .474 .645 r
.97613 .47346 .97765 .47914 .97843 .47551 .97687 .46945 Mtetra
.59 .442 .649 r
.97687 .46945 .97843 .47551 .97934 .47303 .97774 .46672 Mtetra
.515 .393 .652 r
.97774 .46672 .97934 .47303 .98041 .47202 .9788 .46562 Mtetra
.428 .324 .635 r
.51655 .66599 .5175 .67271 .51827 .67288 .51732 .66625 Mtetra
.236 .188 .599 r
.51732 .66625 .51827 .67288 .51905 .67446 .51809 .66811 Mtetra
0 0 .508 r
.51809 .66811 .51905 .67446 .51983 .67715 .51888 .6712 Mtetra
0 0 .363 r
.51888 .6712 .51983 .67715 .52062 .68051 .51967 .67506 Mtetra
0 0 .236 r
.51967 .67506 .52062 .68051 .52141 .68411 .52046 .67917 Mtetra
0 0 .183 r
.52046 .67917 .52141 .68411 .52221 .68756 .52126 .68313 Mtetra
0 0 .216 r
.52126 .68313 .52221 .68756 .523 .6906 .52205 .68663 Mtetra
0 0 .328 r
.52205 .68663 .523 .6906 .52379 .69307 .52284 .68948 Mtetra
0 0 .485 r
.52284 .68948 .52379 .69307 .52458 .69492 .52363 .69163 Mtetra
.041 .117 .618 r
.52363 .69163 .52458 .69492 .52536 .69611 .52442 .69305 Mtetra
.28 .283 .685 r
.52442 .69305 .52536 .69611 .52614 .69669 .5252 .69378 Mtetra
.44 .389 .704 r
.5252 .69378 .52614 .69669 .52692 .69667 .52597 .69383 Mtetra
.54 .451 .703 r
.52597 .69383 .52692 .69667 .52769 .69607 .52675 .69322 Mtetra
.603 .488 .694 r
.52675 .69322 .52769 .69607 .52846 .69489 .52751 .69196 Mtetra
.644 .509 .684 r
.52751 .69196 .52846 .69489 .52922 .69311 .52827 .69003 Mtetra
.671 .522 .674 r
.52827 .69003 .52922 .69311 .52998 .6907 .52903 .68739 Mtetra
.688 .528 .665 r
.52903 .68739 .52998 .6907 .53073 .68765 .52978 .68403 Mtetra
.697 .53 .658 r
.52978 .68403 .53073 .68765 .53148 .68396 .53052 .67995 Mtetra
.701 .529 .652 r
.53052 .67995 .53148 .68396 .53222 .67972 .53126 .67524 Mtetra
.699 .525 .648 r
.53126 .67524 .53222 .67972 .53296 .67506 .53199 .67008 Mtetra
.691 .517 .646 r
.53199 .67008 .53296 .67506 .53369 .67028 .53272 .66477 Mtetra
.675 .503 .645 r
.53272 .66477 .53369 .67028 .53443 .66575 .53345 .65974 Mtetra
.649 .483 .645 r
.53345 .65974 .53443 .66575 .53517 .66191 .53419 .6555 Mtetra
.606 .452 .646 r
.53419 .6555 .53517 .66191 .53592 .6592 .53494 .65252 Mtetra
.537 .402 .644 r
.53494 .65252 .53592 .6592 .53669 .65792 .5357 .65115 Mtetra
.42 .319 .634 r
.5357 .65115 .53669 .65792 .53747 .65817 .53649 .65151 Mtetra
.228 .183 .597 r
.53649 .65151 .53747 .65817 .53827 .65983 .53728 .65345 Mtetra
0 0 .508 r
.53728 .65345 .53827 .65983 .53908 .66258 .5381 .65661 Mtetra
0 0 .372 r
.5381 .65661 .53908 .66258 .53989 .66598 .53892 .66051 Mtetra
0 0 .253 r
.53892 .66051 .53989 .66598 .54072 .6696 .53974 .66465 Mtetra
0 0 .207 r
.53974 .66465 .54072 .6696 .54154 .67305 .54057 .66861 Mtetra
0 0 .244 r
.54057 .66861 .54154 .67305 .54236 .67609 .54139 .6721 Mtetra
0 0 .355 r
.54139 .6721 .54236 .67609 .54317 .67855 .54221 .67494 Mtetra
0 0 .504 r
.54221 .67494 .54317 .67855 .54398 .68037 .54302 .67706 Mtetra
.065 .134 .626 r
.54302 .67706 .54398 .68037 .54478 .68155 .54383 .67846 Mtetra
.292 .291 .687 r
.54383 .67846 .54478 .68155 .54558 .6821 .54462 .67916 Mtetra
.445 .392 .704 r
.54462 .67916 .54558 .6821 .54637 .68206 .54541 .67918 Mtetra
.542 .452 .702 r
.54541 .67918 .54637 .68206 .54716 .68143 .5462 .67855 Mtetra
.604 .487 .693 r
.5462 .67855 .54716 .68143 .54793 .68022 .54697 .67725 Mtetra
.644 .509 .683 r
.54697 .67725 .54793 .68022 .5487 .6784 .54774 .67528 Mtetra
.67 .521 .673 r
.54774 .67528 .5487 .6784 .54946 .67596 .5485 .6726 Mtetra
.687 .527 .664 r
.5485 .6726 .54946 .67596 .55022 .67287 .54925 .66919 Mtetra
.697 .529 .657 r
.54925 .66919 .55022 .67287 .55096 .66914 .54999 .66507 Mtetra
.7 .528 .652 r
.54999 .66507 .55096 .66914 .5517 .66485 .55072 .66031 Mtetra
.698 .523 .648 r
.55072 .66031 .5517 .66485 .55243 .66017 .55144 .65512 Mtetra
.69 .515 .645 r
.55144 .65512 .55243 .66017 .55316 .65538 .55217 .64979 Mtetra
.674 .502 .645 r
.55217 .64979 .55316 .65538 .55389 .65086 .55289 .64478 Mtetra
.646 .481 .645 r
.55289 .64478 .55389 .65086 .55463 .64706 .55363 .64058 Mtetra
.603 .449 .646 r
.55363 .64058 .55463 .64706 .55539 .64441 .55438 .63767 Mtetra
.531 .397 .644 r
.55438 .63767 .55539 .64441 .55616 .6432 .55515 .63639 Mtetra
.413 .314 .633 r
.55515 .63639 .55616 .6432 .55696 .64354 .55595 .63683 Mtetra
.22 .178 .596 r
.55595 .63683 .55696 .64354 .55778 .64528 .55677 .63886 Mtetra
0 0 .509 r
.55677 .63886 .55778 .64528 .55862 .64809 .55761 .64209 Mtetra
0 0 .38 r
.55761 .64209 .55862 .64809 .55947 .65153 .55847 .64604 Mtetra
0 0 .27 r
.55847 .64604 .55947 .65153 .56032 .65517 .55933 .6502 Mtetra
0 0 .23 r
.55933 .6502 .56032 .65517 .56117 .65864 .56018 .65417 Mtetra
0 0 .27 r
.56018 .65417 .56117 .65864 .56202 .66166 .56104 .65765 Mtetra
0 0 .379 r
.56104 .65765 .56202 .66166 .56286 .66411 .56188 .66048 Mtetra
0 0 .521 r
.56188 .66048 .56286 .66411 .56369 .66592 .56271 .66258 Mtetra
.087 .149 .633 r
.56271 .66258 .56369 .66592 .56451 .66708 .56354 .66396 Mtetra
.303 .298 .688 r
.56354 .66396 .56451 .66708 .56532 .66761 .56435 .66463 Mtetra
.45 .394 .704 r
.56435 .66463 .56532 .66761 .56613 .66755 .56516 .66463 Mtetra
.544 .452 .701 r
.56516 .66463 .56613 .66755 .56692 .66689 .56595 .66397 Mtetra
.605 .487 .693 r
.56595 .66397 .56692 .66689 .56771 .66566 .56674 .66265 Mtetra
.644 .508 .682 r
.56674 .66265 .56771 .66566 .56849 .66381 .56751 .66064 Mtetra
.67 .52 .672 r
.56751 .66064 .56849 .66381 .56925 .66133 .56827 .65792 Mtetra
.687 .526 .663 r
.56827 .65792 .56925 .66133 .57001 .6582 .56902 .65447 Mtetra
.696 .528 .656 r
.56902 .65447 .57001 .6582 .57075 .65444 .56976 .6503 Mtetra
.699 .527 .651 r
.56976 .6503 .57075 .65444 .57148 .65011 .57048 .64551 Mtetra
.697 .522 .647 r
.57048 .64551 .57148 .65011 .57221 .64541 .5712 .64028 Mtetra
.688 .513 .645 r
.5712 .64028 .57221 .64541 .57293 .6406 .57191 .63494 Mtetra
.672 .5 .644 r
.57191 .63494 .57293 .6406 .57366 .63609 .57263 .62994 Mtetra
.644 .478 .645 r
.57263 .62994 .57366 .63609 .5744 .63234 .57336 .62579 Mtetra
.598 .445 .645 r
.57336 .62579 .5744 .63234 .57516 .62975 .57412 .62295 Mtetra
.525 .393 .643 r
.57412 .62295 .57516 .62975 .57595 .62862 .5749 .62176 Mtetra
.405 .308 .632 r
.5749 .62176 .57595 .62862 .57676 .62905 .57572 .6223 Mtetra
.213 .173 .595 r
.57572 .6223 .57676 .62905 .57761 .63087 .57657 .62442 Mtetra
0 0 .51 r
.57657 .62442 .57761 .63087 .57847 .63374 .57744 .62772 Mtetra
0 0 .388 r
.57744 .62772 .57847 .63374 .57935 .63724 .57833 .63172 Mtetra
0 0 .287 r
.57833 .63172 .57935 .63724 .58023 .6409 .57922 .63591 Mtetra
0 0 .253 r
.57922 .63591 .58023 .6409 .58112 .64437 .58011 .63989 Mtetra
0 0 .295 r
.58011 .63989 .58112 .64437 .58199 .6474 .58099 .64337 Mtetra
0 0 .402 r
.58099 .64337 .58199 .6474 .58286 .64984 .58186 .64618 Mtetra
0 0 .536 r
.58186 .64618 .58286 .64984 .58371 .65163 .58272 .64827 Mtetra
.106 .163 .639 r
.58272 .64827 .58371 .65163 .58455 .65278 .58357 .64963 Mtetra
.312 .304 .689 r
.58357 .64963 .58455 .65278 .58538 .65329 .5844 .65029 Mtetra
.454 .396 .704 r
.5844 .65029 .58538 .65329 .5862 .65321 .58522 .65026 Mtetra
.545 .453 .701 r
.58522 .65026 .5862 .65321 .58701 .65254 .58603 .64958 Mtetra
.605 .487 .692 r
.58603 .64958 .58701 .65254 .58781 .65128 .58682 .64822 Mtetra
.644 .507 .681 r
.58682 .64822 .58781 .65128 .58859 .6494 .5876 .64618 Mtetra
.67 .519 .671 r
.5876 .64618 .58859 .6494 .58936 .64689 .58836 .64343 Mtetra
.686 .525 .663 r
.58836 .64343 .58936 .64689 .59011 .64373 .58911 .63993 Mtetra
.695 .527 .655 r
.58911 .63993 .59011 .64373 .59085 .63993 .58984 .63573 Mtetra
.699 .526 .65 r
.58984 .63573 .59085 .63993 .59158 .63557 .59056 .63089 Mtetra
.696 .521 .646 r
.59056 .63089 .59158 .63557 .5923 .63084 .59127 .62564 Mtetra
.687 .512 .644 r
.59127 .62564 .5923 .63084 .59302 .62603 .59197 .6203 Mtetra
.669 .497 .644 r
.59197 .6203 .59302 .62603 .59374 .62154 .59269 .61532 Mtetra
.64 .476 .644 r
.59269 .61532 .59374 .62154 .59448 .61783 .59342 .61121 Mtetra
.594 .442 .645 r
.59342 .61121 .59448 .61783 .59525 .61531 .59418 .60845 Mtetra
.519 .389 .643 r
.59418 .60845 .59525 .61531 .59605 .61427 .59497 .60735 Mtetra
.397 .303 .631 r
.59497 .60735 .59605 .61427 .59688 .61478 .59581 .60799 Mtetra
.205 .169 .593 r
.59581 .60799 .59688 .61478 .59775 .61669 .59669 .6102 Mtetra
0 0 .511 r
.59669 .6102 .59775 .61669 .59865 .61964 .59759 .61359 Mtetra
0 0 .395 r
.59759 .61359 .59865 .61964 .59956 .62318 .59851 .61764 Mtetra
0 0 .302 r
.59851 .61764 .59956 .62318 .60047 .62687 .59944 .62187 Mtetra
0 0 .273 r
.59944 .62187 .60047 .62687 .60139 .63036 .60036 .62586 Mtetra
0 0 .318 r
.60036 .62586 .60139 .63036 .60229 .63339 .60127 .62934 Mtetra
0 0 .422 r
.60127 .62934 .60229 .63339 .60318 .63582 .60217 .63214 Mtetra
0 0 .548 r
.60217 .63214 .60318 .63582 .60406 .6376 .60306 .63422 Mtetra
.123 .174 .644 r
.60306 .63422 .60406 .6376 .60492 .63874 .60392 .63557 Mtetra
.32 .309 .69 r
.60392 .63557 .60492 .63874 .60577 .63924 .60478 .6362 Mtetra
.457 .398 .703 r
.60478 .6362 .60577 .63924 .60661 .63915 .60561 .63616 Mtetra
.546 .452 .7 r
.60561 .63616 .60661 .63915 .60743 .63846 .60643 .63546 Mtetra
.604 .486 .691 r
.60643 .63546 .60743 .63846 .60823 .63717 .60723 .63408 Mtetra
.643 .506 .681 r
.60723 .63408 .60823 .63717 .60902 .63527 .60802 .63201 Mtetra
.669 .518 .671 r
.60802 .63201 .60902 .63527 .6098 .63273 .60878 .62922 Mtetra
.685 .524 .662 r
.60878 .62922 .6098 .63273 .61055 .62954 .60953 .62569 Mtetra
.695 .526 .655 r
.60953 .62569 .61055 .62954 .61129 .6257 .61026 .62144 Mtetra
.698 .524 .649 r
.61026 .62144 .61129 .6257 .61202 .62132 .61097 .61657 Mtetra
.695 .519 .646 r
.61097 .61657 .61202 .62132 .61273 .61657 .61167 .61129 Mtetra
.685 .51 .644 r
.61167 .61129 .61273 .61657 .61344 .61176 .61237 .60595 Mtetra
.667 .495 .643 r
.61237 .60595 .61344 .61176 .61416 .60729 .61307 .60099 Mtetra
.637 .473 .644 r
.61307 .60099 .61416 .60729 .6149 .60363 .6138 .59694 Mtetra
.589 .438 .644 r
.6138 .59694 .6149 .60363 .61567 .60118 .61457 .59426 Mtetra
.513 .384 .642 r
.61457 .59426 .61567 .60118 .61648 .60023 .61538 .59326 Mtetra
.388 .297 .63 r
.61538 .59326 .61648 .60023 .61734 .60084 .61624 .59401 Mtetra
.197 .163 .592 r
.61624 .59401 .61734 .60084 .61824 .60284 .61714 .59632 Mtetra
0 0 .511 r
.61714 .59632 .61824 .60284 .61916 .60586 .61808 .59978 Mtetra
0 0 .402 r
.61808 .59978 .61916 .60586 .62011 .60945 .61903 .60389 Mtetra
0 0 .316 r
.61903 .60389 .62011 .60945 .62106 .61318 .62 .60815 Mtetra
0 0 .293 r
.62 .60815 .62106 .61318 .62201 .61669 .62096 .61217 Mtetra
0 0 .339 r
.62096 .61217 .62201 .61669 .62294 .61972 .6219 .61565 Mtetra
0 0 .44 r
.6219 .61565 .62294 .61972 .62386 .62216 .62283 .61845 Mtetra
0 .017 .559 r
.62283 .61845 .62386 .62216 .62476 .62394 .62374 .62052 Mtetra
.137 .184 .648 r
.62374 .62052 .62476 .62394 .62564 .62506 .62463 .62186 Mtetra
.327 .313 .691 r
.62463 .62186 .62564 .62506 .62651 .62556 .6255 .62249 Mtetra
.459 .399 .703 r
.6255 .62249 .62651 .62556 .62736 .62545 .62635 .62243 Mtetra
.546 .452 .7 r
.62635 .62243 .62736 .62545 .62819 .62475 .62718 .62171 Mtetra
.604 .485 .69 r
.62718 .62171 .62819 .62475 .62901 .62345 .62799 .62031 Mtetra
.642 .505 .68 r
.62799 .62031 .62901 .62345 .62981 .62153 .62878 .61821 Mtetra
.668 .517 .67 r
.62878 .61821 .62981 .62153 .63058 .61896 .62955 .61539 Mtetra
.684 .523 .661 r
.62955 .61539 .63058 .61896 .63134 .61574 .6303 .61182 Mtetra
.694 .525 .654 r
.6303 .61182 .63134 .61574 .63208 .61187 .63103 .60754 Mtetra
.697 .523 .649 r
.63103 .60754 .63208 .61187 .6328 .60746 .63173 .60264 Mtetra
.693 .517 .645 r
.63173 .60264 .6328 .60746 .63351 .60269 .63242 .59734 Mtetra
.683 .508 .643 r
.63242 .59734 .63351 .60269 .63421 .59789 .63311 .592 Mtetra
.665 .493 .643 r
.63311 .592 .63421 .59789 .63493 .59345 .63381 .58707 Mtetra
.634 .47 .643 r
.63381 .58707 .63493 .59345 .63567 .58984 .63454 .58308 Mtetra
.585 .435 .644 r
.63454 .58308 .63567 .58984 .63645 .58747 .63531 .58048 Mtetra
.506 .379 .642 r
.63531 .58048 .63645 .58747 .63728 .58662 .63614 .57959 Mtetra
.38 .291 .629 r
.63614 .57959 .63728 .58662 .63816 .58733 .63702 .58045 Mtetra
.188 .158 .591 r
.63702 .58045 .63816 .58733 .63908 .58942 .63795 .58286 Mtetra
0 0 .512 r
.63795 .58286 .63908 .58942 .64004 .59251 .63893 .58641 Mtetra
0 0 .408 r
.63893 .58641 .64004 .59251 .64102 .59617 .63992 .59058 Mtetra
0 0 .33 r
.63992 .59058 .64102 .59617 .64201 .59994 .64092 .59489 Mtetra
0 0 .311 r
.64092 .59489 .64201 .59994 .64299 .60347 .64192 .59892 Mtetra
0 0 .358 r
.64192 .59892 .64299 .60347 .64395 .60651 .6429 .60242 Mtetra
0 0 .456 r
.6429 .60242 .64395 .60651 .6449 .60895 .64385 .60523 Mtetra
0 .032 .569 r
.64385 .60523 .6449 .60895 .64583 .61073 .64479 .60729 Mtetra
.149 .192 .652 r
.64479 .60729 .64583 .61073 .64673 .61186 .6457 .60862 Mtetra
.332 .316 .692 r
.6457 .60862 .64673 .61186 .64762 .61235 .64659 .60924 Mtetra
.46 .399 .703 r
.64659 .60924 .64762 .61235 .64848 .61223 .64746 .60918 Mtetra
.546 .452 .699 r
.64746 .60918 .64848 .61223 .64933 .61152 .6483 .60844 Mtetra
.603 .484 .69 r
.6483 .60844 .64933 .61152 .65016 .61021 .64912 .60702 Mtetra
.642 .504 .679 r
.64912 .60702 .65016 .61021 .65096 .60827 .64992 .6049 Mtetra
.667 .515 .669 r
.64992 .6049 .65096 .60827 .65174 .60568 .65069 .60205 Mtetra
.684 .521 .66 r
.65069 .60205 .65174 .60568 .6525 .60243 .65144 .59846 Mtetra
.693 .523 .653 r
.65144 .59846 .6525 .60243 .65324 .59854 .65216 .59414 Mtetra
.695 .521 .648 r
.65216 .59414 .65324 .59854 .65395 .5941 .65286 .58921 Mtetra
.692 .516 .644 r
.65286 .58921 .65395 .5941 .65465 .58933 .65354 .5839 Mtetra
.681 .506 .642 r
.65354 .5839 .65465 .58933 .65535 .58453 .65422 .57856 Mtetra
.662 .491 .642 r
.65422 .57856 .65535 .58453 .65607 .58012 .65492 .57366 Mtetra
.63 .467 .643 r
.65492 .57366 .65607 .58012 .65681 .57657 .65565 .56973 Mtetra
.579 .431 .644 r
.65565 .56973 .65681 .57657 .6576 .57428 .65643 .56723 Mtetra
.499 .374 .641 r
.65643 .56723 .6576 .57428 .65844 .57353 .65727 .56644 Mtetra
.371 .285 .628 r
.65727 .56644 .65844 .57353 .65935 .57435 .65818 .56742 Mtetra
.18 .153 .589 r
.65818 .56742 .65935 .57435 .6603 .57653 .65914 .56994 Mtetra
0 0 .512 r
.65914 .56994 .6603 .57653 .6613 .57972 .66015 .57358 Mtetra
0 0 .414 r
.66015 .57358 .6613 .57972 .66232 .58343 .66119 .57783 Mtetra
0 0 .342 r
.66119 .57783 .66232 .58343 .66334 .58725 .66223 .58218 Mtetra
0 0 .327 r
.66223 .58218 .66334 .58725 .66435 .59081 .66326 .58624 Mtetra
0 0 .375 r
.66326 .58624 .66435 .59081 .66535 .59387 .66428 .58975 Mtetra
0 0 .47 r
.66428 .58975 .66535 .59387 .66633 .59632 .66526 .59257 Mtetra
0 .045 .577 r
.66526 .59257 .66633 .59632 .66728 .5981 .66623 .59464 Mtetra
.159 .199 .655 r
.66623 .59464 .66728 .5981 .66821 .59923 .66716 .59597 Mtetra
.335 .319 .692 r
.66716 .59597 .66821 .59923 .66912 .59972 .66807 .59658 Mtetra
.461 .4 .702 r
.66807 .59658 .66912 .59972 .67 .5996 .66896 .59651 Mtetra
.545 .451 .699 r
.66896 .59651 .67 .5996 .67086 .59889 .66982 .59577 Mtetra
.602 .483 .69 r
.66982 .59577 .67086 .59889 .6717 .59756 .67065 .59434 Mtetra
.64 .503 .679 r
.67065 .59434 .6717 .59756 .67251 .59561 .67145 .5922 Mtetra
.666 .514 .669 r
.67145 .5922 .67251 .59561 .6733 .593 .67223 .58932 Mtetra
.683 .52 .66 r
.67223 .58932 .6733 .593 .67406 .58973 .67297 .58569 Mtetra
.692 .522 .653 r
.67297 .58569 .67406 .58973 .67479 .58581 .67369 .58135 Mtetra
.694 .52 .647 r
.67369 .58135 .67479 .58581 .6755 .58136 .67438 .57639 Mtetra
.691 .514 .644 r
.67438 .57639 .6755 .58136 .6762 .57657 .67506 .57107 Mtetra
.68 .504 .642 r
.67506 .57107 .6762 .57657 .67689 .57178 .67573 .56574 Mtetra
.659 .488 .642 r
.67573 .56574 .67689 .57178 .6776 .56741 .67642 .56088 Mtetra
.627 .464 .642 r
.67642 .56088 .6776 .56741 .67835 .56392 .67715 .55701 Mtetra
.574 .427 .643 r
.67715 .55701 .67835 .56392 .67915 .56173 .67794 .55461 Mtetra
.491 .369 .64 r
.67794 .55461 .67915 .56173 .68001 .56108 .6788 .55394 Mtetra
.362 .279 .627 r
.6788 .55394 .68001 .56108 .68094 .56201 .67974 .55504 Mtetra
.171 .147 .588 r
.67974 .55504 .68094 .56201 .68193 .5643 .68074 .55767 Mtetra
0 0 .513 r
.68074 .55767 .68193 .5643 .68296 .56757 .68179 .56141 Mtetra
0 0 .42 r
.68179 .56141 .68296 .56757 .68402 .57136 .68286 .56572 Mtetra
0 0 .353 r
.68286 .56572 .68402 .57136 .68508 .57522 .68395 .57013 Mtetra
0 0 .342 r
.68395 .57013 .68508 .57522 .68613 .57881 .68502 .57423 Mtetra
0 0 .39 r
.68502 .57423 .68613 .57881 .68717 .5819 .68607 .57776 Mtetra
0 0 .483 r
.68607 .57776 .68717 .5819 .68817 .58436 .68709 .58059 Mtetra
0 .056 .584 r
.68709 .58059 .68817 .58436 .68915 .58615 .68808 .58266 Mtetra
.167 .205 .657 r
.68808 .58266 .68915 .58615 .69011 .58728 .68904 .584 Mtetra
.338 .321 .693 r
.68904 .584 .69011 .58728 .69103 .58778 .68997 .58461 Mtetra
.461 .4 .702 r
.68997 .58461 .69103 .58778 .69194 .58767 .69088 .58454 Mtetra
.544 .45 .698 r
.69088 .58454 .69194 .58767 .69281 .58695 .69175 .58379 Mtetra
.601 .482 .689 r
.69175 .58379 .69281 .58695 .69366 .58562 .69259 .58235 Mtetra
.639 .501 .679 r
.69259 .58235 .69366 .58562 .69448 .58365 .6934 .58019 Mtetra
.665 .513 .668 r
.6934 .58019 .69448 .58365 .69527 .58103 .69418 .57729 Mtetra
.682 .519 .659 r
.69418 .57729 .69527 .58103 .69603 .57773 .69493 .57364 Mtetra
.691 .521 .652 r
.69493 .57364 .69603 .57773 .69676 .57379 .69564 .56926 Mtetra
.693 .518 .646 r
.69564 .56926 .69676 .57379 .69747 .56932 .69632 .56429 Mtetra
.689 .512 .643 r
.69632 .56429 .69747 .56932 .69816 .56453 .69699 .55895 Mtetra
.678 .502 .641 r
.69699 .55895 .69816 .56453 .69885 .55975 .69766 .55363 Mtetra
.657 .486 .641 r
.69766 .55363 .69885 .55975 .69956 .55542 .69834 .54881 Mtetra
.623 .461 .642 r
.69834 .54881 .69956 .55542 .70031 .55199 .69908 .54502 Mtetra
.569 .423 .643 r
.69908 .54502 .70031 .55199 .70112 .54989 .69988 .54271 Mtetra
.484 .363 .64 r
.69988 .54271 .70112 .54989 .70201 .54936 .70076 .54216 Mtetra
.352 .273 .626 r
.70076 .54216 .70201 .54936 .70297 .5504 .70173 .54339 Mtetra
.161 .142 .586 r
.70173 .54339 .70297 .5504 .70399 .5528 .70276 .54614 Mtetra
0 0 .513 r
.70276 .54614 .70399 .5528 .70506 .55616 .70386 .54997 Mtetra
0 0 .425 r
.70386 .54997 .70506 .55616 .70616 .56002 .70498 .55437 Mtetra
0 0 .363 r
.70498 .55437 .70616 .56002 .70726 .56394 .7061 .55883 Mtetra
0 0 .355 r
.7061 .55883 .70726 .56394 .70835 .56757 .70721 .56297 Mtetra
0 0 .404 r
.70721 .56297 .70835 .56757 .70942 .57068 .7083 .56652 Mtetra
0 0 .493 r
.7083 .56652 .70942 .57068 .71046 .57316 .70936 .56937 Mtetra
0 .066 .59 r
.70936 .56937 .71046 .57316 .71147 .57497 .71038 .57146 Mtetra
.173 .21 .66 r
.71038 .57146 .71147 .57497 .71245 .57611 .71137 .5728 Mtetra
.34 .322 .694 r
.71137 .5728 .71245 .57611 .7134 .57661 .71232 .57342 Mtetra
.46 .399 .702 r
.71232 .57342 .7134 .57661 .71432 .5765 .71324 .57335 Mtetra
.543 .449 .698 r
.71324 .57335 .71432 .5765 .71521 .57578 .71413 .57259 Mtetra
.6 .481 .689 r
.71413 .57259 .71521 .57578 .71607 .57445 .71498 .57114 Mtetra
.638 .5 .678 r
.71498 .57114 .71607 .57445 .7169 .57247 .7158 .56897 Mtetra
.664 .512 .668 r
.7158 .56897 .7169 .57247 .71769 .56983 .71659 .56605 Mtetra
.681 .518 .659 r
.71659 .56605 .71769 .56983 .71846 .56652 .71733 .56237 Mtetra
.69 .519 .651 r
.71733 .56237 .71846 .56652 .71919 .56256 .71804 .55796 Mtetra
.692 .517 .646 r
.71804 .55796 .71919 .56256 .71989 .55807 .71871 .55296 Mtetra
.688 .511 .642 r
.71871 .55296 .71989 .55807 .72058 .55327 .71937 .54761 Mtetra
.676 .5 .641 r
.71937 .54761 .72058 .55327 .72126 .5485 .72003 .54231 Mtetra
.654 .483 .641 r
.72003 .54231 .72126 .5485 .72197 .54421 .72072 .53753 Mtetra
.619 .458 .642 r
.72072 .53753 .72197 .54421 .72273 .54086 .72145 .53381 Mtetra
.563 .418 .643 r
.72145 .53381 .72273 .54086 .72355 .53885 .72227 .53161 Mtetra
.476 .358 .639 r
.72227 .53161 .72355 .53885 .72446 .53843 .72317 .53118 Mtetra
.342 .266 .625 r
.72317 .53118 .72446 .53843 .72545 .53959 .72417 .53254 Mtetra
.152 .136 .585 r
.72417 .53254 .72545 .53959 .72651 .5421 .72525 .53541 Mtetra
0 0 .513 r
.72525 .53541 .72651 .5421 .72762 .54556 .72638 .53935 Mtetra
0 0 .429 r
.72638 .53935 .72762 .54556 .72876 .54949 .72755 .54382 Mtetra
0 0 .373 r
.72755 .54382 .72876 .54949 .72991 .55347 .72872 .54834 Mtetra
0 0 .367 r
.72872 .54834 .72991 .55347 .73104 .55714 .72988 .55252 Mtetra
0 0 .416 r
.72988 .55252 .73104 .55714 .73215 .56028 .731 .55611 Mtetra
0 0 .503 r
.731 .55611 .73215 .56028 .73322 .56278 .7321 .55897 Mtetra
0 .075 .595 r
.7321 .55897 .73322 .56278 .73426 .5646 .73315 .56107 Mtetra
.178 .214 .662 r
.73315 .56107 .73426 .5646 .73526 .56576 .73416 .56243 Mtetra
.341 .324 .694 r
.73416 .56243 .73526 .56576 .73623 .56627 .73514 .56305 Mtetra
.46 .399 .703 r
.73514 .56305 .73623 .56627 .73717 .56617 .73608 .56298 Mtetra
.542 .449 .698 r
.73608 .56298 .73717 .56617 .73808 .56545 .73699 .56222 Mtetra
.599 .48 .689 r
.73699 .56222 .73808 .56545 .73896 .56411 .73785 .56076 Mtetra
.637 .499 .678 r
.73785 .56076 .73896 .56411 .73979 .56212 .73868 .55858 Mtetra
.663 .511 .667 r
.73868 .55858 .73979 .56212 .7406 .55946 .73947 .55563 Mtetra
.68 .517 .658 r
.73947 .55563 .7406 .55946 .74136 .55613 .74021 .55192 Mtetra
.689 .518 .651 r
.74021 .55192 .74136 .55613 .74209 .55214 .74091 .54749 Mtetra
.691 .516 .645 r
.74091 .54749 .74209 .55214 .74279 .54764 .74158 .54246 Mtetra
.686 .509 .642 r
.74158 .54246 .74279 .54764 .74347 .54283 .74223 .53711 Mtetra
.674 .498 .64 r
.74223 .53711 .74347 .54283 .74415 .53808 .74289 .53181 Mtetra
.651 .481 .64 r
.74289 .53181 .74415 .53808 .74486 .53383 .74357 .52707 Mtetra
.615 .454 .641 r
.74357 .52707 .74486 .53383 .74562 .53055 .74431 .52343 Mtetra
.557 .414 .642 r
.74431 .52343 .74562 .53055 .74647 .52864 .74514 .52133 Mtetra
.468 .353 .639 r
.74514 .52133 .74647 .52864 .7474 .52833 .74607 .52103 Mtetra
.333 .26 .624 r
.74607 .52103 .7474 .52833 .74842 .52961 .7471 .52252 Mtetra
.143 .131 .584 r
.7471 .52252 .74842 .52961 .74952 .53224 .74822 .52551 Mtetra
0 0 .513 r
.74822 .52551 .74952 .53224 .75068 .53579 .7494 .52956 Mtetra
0 0 .434 r
.7494 .52956 .75068 .53579 .75186 .53981 .75062 .53412 Mtetra
0 0 .382 r
.75062 .53412 .75186 .53981 .75305 .54384 .75184 .5387 Mtetra
0 0 .379 r
.75184 .5387 .75305 .54384 .75423 .54755 .75304 .54292 Mtetra
0 0 .428 r
.75304 .54292 .75423 .54755 .75537 .55072 .75421 .54654 Mtetra
0 0 .512 r
.75421 .54654 .75537 .55072 .75648 .55324 .75534 .54942 Mtetra
0 .083 .6 r
.75534 .54942 .75648 .55324 .75755 .55508 .75642 .55154 Mtetra
.183 .218 .664 r
.75642 .55154 .75755 .55508 .75858 .55625 .75746 .5529 Mtetra
.342 .325 .695 r
.75746 .5529 .75858 .55625 .75958 .55677 .75847 .55354 Mtetra
.459 .399 .703 r
.75847 .55354 .75958 .55677 .76054 .55667 .75943 .55347 Mtetra
.541 .448 .699 r
.75943 .55347 .76054 .55667 .76146 .55596 .76035 .5527 Mtetra
.598 .479 .689 r
.76035 .5527 .76146 .55596 .76235 .55461 .76123 .55123 Mtetra
.637 .499 .678 r
.76123 .55123 .76235 .55461 .7632 .55261 .76206 .54903 Mtetra
.663 .51 .667 r
.76206 .54903 .7632 .55261 .76401 .54994 .76285 .54606 Mtetra
.679 .516 .658 r
.76285 .54606 .76401 .54994 .76477 .54657 .7636 .54232 Mtetra
.688 .517 .65 r
.7636 .54232 .76477 .54657 .7655 .54257 .7643 .53785 Mtetra
.69 .514 .644 r
.7643 .53785 .7655 .54257 .76619 .53804 .76496 .5328 Mtetra
.685 .508 .641 r
.76496 .5328 .76619 .53804 .76687 .53322 .7656 .52743 Mtetra
.672 .496 .64 r
.7656 .52743 .76687 .53322 .76755 .52848 .76625 .52214 Mtetra
.648 .478 .64 r
.76625 .52214 .76755 .52848 .76826 .52427 .76693 .51745 Mtetra
.611 .451 .641 r
.76693 .51745 .76826 .52427 .76903 .52106 .76768 .51388 Mtetra
.552 .41 .642 r
.76768 .51388 .76903 .52106 .76989 .51925 .76852 .51189 Mtetra
.46 .347 .638 r
.76852 .51189 .76989 .51925 .77085 .51906 .76948 .51171 Mtetra
.323 .254 .623 r
.76948 .51171 .77085 .51906 .77191 .52046 .77055 .51333 Mtetra
.134 .126 .582 r
.77055 .51333 .77191 .52046 .77305 .5232 .77171 .51645 Mtetra
0 0 .514 r
.77171 .51645 .77305 .5232 .77425 .52685 .77295 .5206 Mtetra
0 0 .438 r
.77295 .5206 .77425 .52685 .77549 .53094 .77421 .52524 Mtetra
0 0 .391 r
.77421 .52524 .77549 .53094 .77672 .53504 .77548 .52989 Mtetra
.77548 .52989 .77672 .53504 .77794 .53879 .77673 .53415 Mtetra
0 0 .439 r
.77673 .53415 .77794 .53879 .77912 .54199 .77794 .5378 Mtetra
0 0 .521 r
.77794 .5378 .77912 .54199 .78027 .54454 .7791 .54071 Mtetra
0 .091 .606 r
.7791 .54071 .78027 .54454 .78137 .54639 .78022 .54284 Mtetra
.188 .223 .666 r
.78022 .54284 .78137 .54639 .78243 .54757 .7813 .54421 Mtetra
.344 .327 .696 r
.7813 .54421 .78243 .54757 .78345 .5481 .78232 .54485 Mtetra
.459 .4 .704 r
.78232 .54485 .78345 .5481 .78444 .54801 .78331 .54478 Mtetra
.541 .448 .699 r
.78331 .54478 .78444 .54801 .78538 .54729 .78424 .54401 Mtetra
.597 .479 .689 r
.78424 .54401 .78538 .54729 .78628 .54593 .78514 .54252 Mtetra
.636 .498 .677 r
.78514 .54252 .78628 .54593 .78714 .54392 .78598 .5403 Mtetra
.662 .509 .667 r
.78598 .5403 .78714 .54392 .78795 .54122 .78678 .5373 Mtetra
.679 .515 .657 r
.78678 .5373 .78795 .54122 .78872 .53783 .78752 .53352 Mtetra
.687 .516 .649 r
.78752 .53352 .78872 .53783 .78945 .53379 .78821 .52902 Mtetra
.689 .513 .644 r
.78821 .52902 .78945 .53379 .79014 .52924 .78887 .52393 Mtetra
.683 .506 .64 r
.78887 .52393 .79014 .52924 .79081 .52441 .7895 .51855 Mtetra
.67 .494 .639 r
.7895 .51855 .79081 .52441 .79148 .51968 .79014 .51327 Mtetra
.646 .476 .639 r
.79014 .51327 .79148 .51968 .7922 .51551 .79082 .50861 Mtetra
.607 .448 .641 r
.79082 .50861 .7922 .51551 .79298 .51236 .79158 .50512 Mtetra
.546 .406 .642 r
.79158 .50512 .79298 .51236 .79385 .51065 .79244 .50323 Mtetra
.453 .342 .638 r
.79244 .50323 .79385 .51065 .79484 .51057 .79343 .50318 Mtetra
.314 .248 .622 r
.79343 .50318 .79484 .51057 .79594 .51209 .79454 .50493 Mtetra
.126 .122 .582 r
.79454 .50493 .79594 .51209 .79712 .51495 .79575 .50817 Mtetra
0 0 .515 r
.79575 .50817 .79712 .51495 .79838 .5187 .79703 .51243 Mtetra
0 0 .444 r
.79703 .51243 .79838 .5187 .79966 .52287 .79835 .51716 Mtetra
0 0 .4 r
.79835 .51716 .79966 .52287 .80094 .52702 .79967 .52186 Mtetra
0 0 .402 r
.79967 .52186 .80094 .52702 .80221 .53081 .80097 .52617 Mtetra
0 0 .45 r
.80097 .52617 .80221 .53081 .80343 .53404 .80223 .52985 Mtetra
0 0 .529 r
.80223 .52985 .80343 .53404 .80462 .53661 .80343 .53277 Mtetra
.01 .099 .611 r
.80343 .53277 .80462 .53661 .80575 .53848 .80459 .53491 Mtetra
.192 .227 .669 r
.80459 .53491 .80575 .53848 .80684 .53967 .80569 .53629 Mtetra
.345 .329 .697 r
.80569 .53629 .80684 .53967 .80789 .5402 .80674 .53693 Mtetra
.46 .4 .704 r
.80674 .53693 .80789 .5402 .8089 .54011 .80775 .53686 Mtetra
.541 .448 .699 r
.80775 .53686 .8089 .54011 .80986 .53938 .8087 .53608 Mtetra
.597 .479 .689 r
.8087 .53608 .80986 .53938 .81077 .53801 .80961 .53458 Mtetra
.636 .498 .677 r
.80961 .53458 .81077 .53801 .81164 .53598 .81046 .53232 Mtetra
.662 .509 .666 r
.81046 .53232 .81164 .53598 .81246 .53325 .81126 .52929 Mtetra
.678 .514 .656 r
.81126 .52929 .81246 .53325 .81323 .52983 .812 .52548 Mtetra
.687 .515 .649 r
.812 .52548 .81323 .52983 .81396 .52576 .81269 .52093 Mtetra
.688 .512 .643 r
.81269 .52093 .81396 .52576 .81464 .52118 .81334 .51581 Mtetra
.682 .505 .64 r
.81334 .51581 .81464 .52118 .81531 .51633 .81396 .5104 Mtetra
.668 .493 .639 r
.81396 .5104 .81531 .51633 .81598 .51161 .8146 .50512 Mtetra
.643 .474 .639 r
.8146 .50512 .81598 .51161 .8167 .50747 .81528 .5005 Mtetra
.603 .445 .641 r
.81528 .5005 .8167 .50747 .81749 .50439 .81604 .49708 Mtetra
.54 .402 .642 r
.81604 .49708 .81749 .50439 .81838 .50277 .81693 .49529 Mtetra
.445 .337 .638 r
.81693 .49529 .81838 .50277 .8194 .50281 .81794 .49537 Mtetra
.305 .243 .621 r
.81794 .49537 .8194 .50281 .82054 .50445 .8191 .49724 Mtetra
.119 .118 .581 r
.8191 .49724 .82054 .50445 .82177 .50741 .82036 .50061 Mtetra
0 0 .517 r
.82036 .50061 .82177 .50741 .82308 .51126 .8217 .50497 Mtetra
0 0 .449 r
.8217 .50497 .82308 .51126 .82441 .5155 .82307 .50978 Mtetra
0 0 .409 r
.82307 .50978 .82441 .5155 .82575 .51971 .82445 .51455 Mtetra
0 0 .413 r
.82445 .51455 .82575 .51971 .82706 .52354 .82579 .5189 Mtetra
0 0 .461 r
.82579 .5189 .82706 .52354 .82833 .5268 .8271 .5226 Mtetra
0 0 .538 r
.8271 .5226 .82833 .5268 .82955 .52938 .82834 .52554 Mtetra
.02 .108 .616 r
.82834 .52554 .82955 .52938 .83072 .53127 .82953 .52769 Mtetra
.198 .232 .671 r
.82953 .52769 .83072 .53127 .83184 .53246 .83067 .52907 Mtetra
.348 .331 .699 r
.83067 .52907 .83184 .53246 .83292 .533 .83175 .52971 Mtetra
.461 .402 .705 r
.83175 .52971 .83292 .533 .83394 .5329 .83278 .52963 Mtetra
.541 .449 .699 r
.83278 .52963 .83394 .5329 .83492 .53216 .83375 .52884 Mtetra
.597 .479 .689 r
.83375 .52884 .83492 .53216 .83585 .53078 .83467 .52731 Mtetra
.636 .498 .677 r
.83467 .52731 .83585 .53078 .83673 .52872 .83553 .52503 Mtetra
.662 .508 .666 r
.83553 .52503 .83673 .52872 .83756 .52596 .83633 .52196 Mtetra
.678 .514 .656 r
.83633 .52196 .83756 .52596 .83833 .5225 .83708 .51809 Mtetra
.687 .514 .648 r
.83708 .51809 .83833 .5225 .83905 .51839 .83776 .5135 Mtetra
.688 .511 .642 r
.83776 .5135 .83905 .51839 .83973 .51377 .8384 .50834 Mtetra
.681 .503 .639 r
.8384 .50834 .83973 .51377 .84039 .5089 .83901 .5029 Mtetra
.666 .491 .638 r
.83901 .5029 .84039 .5089 .84107 .50418 .83964 .49762 Mtetra
.64 .471 .639 r
.83964 .49762 .84107 .50418 .84178 .50007 .84032 .49303 Mtetra
.599 .442 .64 r
.84032 .49303 .84178 .50007 .84259 .49706 .84109 .48968 Mtetra
.535 .398 .641 r
.84109 .48968 .84259 .49706 .8435 .49553 .842 .48799 Mtetra
.438 .333 .637 r
.842 .48799 .8435 .49553 .84455 .49567 .84305 .48819 Mtetra
.297 .238 .62 r
.84305 .48819 .84455 .49567 .84573 .49743 .84425 .49019 Mtetra
.113 .115 .581 r
.84425 .49019 .84573 .49743 .84702 .5005 .84557 .49368 Mtetra
0 0 .519 r
.84557 .49368 .84702 .5005 .84838 .50444 .84696 .49814 Mtetra
0 0 .455 r
.84696 .49814 .84838 .50444 .84977 .50876 .84839 .50303 Mtetra
0 0 .419 r
.84839 .50303 .84977 .50876 .85115 .51302 .84982 .50785 Mtetra
0 0 .425 r
.84982 .50785 .85115 .51302 .85251 .51689 .85122 .51224 Mtetra
0 0 .473 r
.85122 .51224 .85251 .51689 .85383 .52018 .85257 .51597 Mtetra
0 0 .547 r
.85257 .51597 .85383 .52018 .85509 .52277 .85386 .51892 Mtetra
.03 .117 .621 r
.85386 .51892 .85509 .52277 .8563 .52466 .85509 .52108 Mtetra
.204 .237 .674 r
.85509 .52108 .8563 .52466 .85745 .52586 .85626 .52247 Mtetra
.351 .334 .7 r
.85626 .52247 .85745 .52586 .85856 .5264 .85737 .5231 Mtetra
.462 .403 .706 r
.85737 .5231 .85856 .5264 .85961 .52629 .85842 .52301 Mtetra
.541 .449 .7 r
.85842 .52301 .85961 .52629 .86061 .52554 .85941 .52219 Mtetra
.597 .479 .689 r
.85941 .52219 .86061 .52554 .86155 .52413 .86035 .52064 Mtetra
.636 .498 .677 r
.86035 .52064 .86155 .52413 .86244 .52204 .86122 .51832 Mtetra
.662 .508 .665 r
.86122 .51832 .86244 .52204 .86327 .51924 .86202 .5152 Mtetra
.678 .513 .655 r
.86202 .5152 .86327 .51924 .86405 .51574 .86276 .51129 Mtetra
.686 .514 .647 r
.86276 .51129 .86405 .51574 .86476 .51158 .86344 .50664 Mtetra
.687 .51 .642 r
.86344 .50664 .86476 .51158 .86544 .50692 .86407 .50142 Mtetra
.68 .502 .638 r
.86407 .50142 .86544 .50692 .86609 .50203 .86467 .49595 Mtetra
.665 .489 .637 r
.86467 .49595 .86609 .50203 .86676 .4973 .86529 .49067 Mtetra
.638 .469 .638 r
.86529 .49067 .86676 .4973 .86748 .49322 .86597 .4861 Mtetra
.595 .439 .64 r
.86597 .4861 .86748 .49322 .8683 .49027 .86676 .48282 Mtetra
.529 .394 .641 r
.86676 .48282 .8683 .49027 .86924 .48883 .86769 .48123 Mtetra
.431 .328 .637 r
.86769 .48123 .86924 .48883 .87033 .48908 .86878 .48154 Mtetra
.289 .234 .62 r
.86878 .48154 .87033 .48908 .87155 .49095 .87002 .48368 Mtetra
.108 .113 .581 r
.87002 .48368 .87155 .49095 .87289 .49413 .87139 .48728 Mtetra
0 0 .521 r
.87139 .48728 .87289 .49413 .8743 .49816 .87285 .49184 Mtetra
0 0 .462 r
.87285 .49184 .8743 .49816 .87575 .50255 .87434 .49681 Mtetra
0 0 .429 r
.87434 .49681 .87575 .50255 .87719 .50686 .87583 .50169 Mtetra
0 0 .437 r
.87583 .50169 .87719 .50686 .8786 .51077 .87728 .50611 Mtetra
0 0 .484 r
.87728 .50611 .8786 .51077 .87996 .51407 .87868 .50986 Mtetra
0 .005 .556 r
.87868 .50986 .87996 .51407 .88127 .51668 .88002 .51283 Mtetra
.042 .126 .627 r
.88002 .51283 .88127 .51668 .88251 .51858 .88128 .51499 Mtetra
.211 .243 .677 r
.88128 .51499 .88251 .51858 .8837 .51978 .88249 .51637 Mtetra
.355 .337 .702 r
.88249 .51637 .8837 .51978 .88483 .5203 .88362 .51699 Mtetra
.464 .405 .706 r
.88362 .51699 .88483 .5203 .88591 .52018 .8847 .51688 Mtetra
.542 .45 .7 r
.8847 .51688 .88591 .52018 .88692 .51941 .88571 .51604 Mtetra
.598 .479 .689 r
.88571 .51604 .88692 .51941 .88788 .51798 .88666 .51446 Mtetra
.636 .498 .676 r
.88666 .51446 .88788 .51798 .88879 .51585 .88754 .51209 Mtetra
.662 .508 .665 r
.88754 .51209 .88879 .51585 .88962 .51301 .88834 .50892 Mtetra
.678 .513 .654 r
.88834 .50892 .88962 .51301 .8904 .50945 .88908 .50495 Mtetra
.686 .513 .646 r
.88908 .50495 .8904 .50945 .89111 .50524 .88975 .50024 Mtetra
.687 .509 .641 r
.88975 .50024 .89111 .50524 .89178 .50054 .89037 .49497 Mtetra
.679 .501 .638 r
.89037 .49497 .89178 .50054 .89243 .49561 .89097 .48946 Mtetra
.663 .487 .637 r
.89097 .48946 .89243 .49561 .89309 .49088 .89158 .48416 Mtetra
.635 .467 .638 r
.89158 .48416 .89309 .49088 .89382 .48682 .89226 .47963 Mtetra
.591 .436 .64 r
.89226 .47963 .89382 .48682 .89465 .48392 .89306 .4764 Mtetra
.524 .391 .641 r
.89306 .4764 .89465 .48392 .89561 .48257 .89401 .47491 Mtetra
.424 .324 .637 r
.89401 .47491 .89561 .48257 .89674 .48293 .89514 .47534 Mtetra
.282 .23 .62 r
.89514 .47534 .89674 .48293 .89801 .48492 .89643 .4776 Mtetra
.104 .111 .581 r
.89643 .4776 .89801 .48492 .8994 .4882 .89786 .48132 Mtetra
0 0 .524 r
.89786 .48132 .8994 .4882 .90087 .49232 .89938 .48598 Mtetra
0 0 .469 r
.89938 .48598 .90087 .49232 .90238 .49678 .90094 .49102 Mtetra
0 0 .44 r
.90094 .49102 .90238 .49678 .90388 .50114 .90249 .49595 Mtetra
0 0 .45 r
.90249 .49595 .90388 .50114 .90534 .50508 .904 .50041 Mtetra
0 0 .496 r
.904 .50041 .90534 .50508 .90675 .5084 .90545 .50418 Mtetra
0 .018 .565 r
.90545 .50418 .90675 .5084 .9081 .51101 .90683 .50715 Mtetra
.054 .136 .633 r
.90683 .50715 .9081 .51101 .90939 .51291 .90813 .50931 Mtetra
.219 .25 .68 r
.90813 .50931 .90939 .51291 .91061 .5141 .90937 .51068 Mtetra
.359 .341 .703 r
.90937 .51068 .91061 .5141 .91177 .51462 .91054 .51129 Mtetra
.466 .407 .707 r
.91054 .51129 .91177 .51462 .91286 .51448 .91164 .51116 Mtetra
.544 .451 .7 r
.91164 .51116 .91286 .51448 .9139 .51369 .91267 .5103 Mtetra
.599 .48 .689 r
.91267 .5103 .9139 .51369 .91488 .51222 .91363 .50867 Mtetra
.637 .498 .676 r
.91363 .50867 .91488 .51222 .91579 .51006 .91452 .50626 Mtetra
.663 .508 .664 r
.91452 .50626 .91579 .51006 .91663 .50716 .91533 .50303 Mtetra
.679 .512 .654 r
.91533 .50303 .91663 .50716 .91741 .50355 .91606 .49899 Mtetra
.686 .512 .646 r
.91606 .49899 .91741 .50355 .91812 .49928 .91672 .49422 Mtetra
.686 .508 .64 r
.91672 .49422 .91812 .49928 .91878 .49452 .91733 .48889 Mtetra
.678 .5 .637 r
.91733 .48889 .91878 .49452 .91942 .48956 .91791 .48334 Mtetra
.661 .486 .636 r
.91791 .48334 .91942 .48956 .92008 .48482 .91852 .47802 Mtetra
.632 .465 .637 r
.91852 .47802 .92008 .48482 .92081 .48078 .9192 .47351 Mtetra
.587 .433 .64 r
.9192 .47351 .92081 .48078 .92165 .47794 .92001 .47035 Mtetra
.519 .387 .641 r
.92001 .47035 .92165 .47794 .92265 .47667 .92099 .46895 Mtetra
.417 .32 .637 r
.92099 .46895 .92265 .47667 .92381 .47714 .92216 .4695 Mtetra
.276 .226 .619 r
.92216 .4695 .92381 .47714 .92513 .47923 .92351 .47188 Mtetra
.101 .111 .582 r
.92351 .47188 .92513 .47923 .92658 .48262 .925 .47571 Mtetra
0 0 .528 r
.925 .47571 .92658 .48262 .92812 .48683 .92659 .48047 Mtetra
0 0 .477 r
.92659 .48047 .92812 .48683 .92969 .49135 .92821 .48558 Mtetra
0 0 .451 r
.92821 .48558 .92969 .49135 .93124 .49576 .92982 .49056 Mtetra
0 0 .462 r
.92982 .49056 .93124 .49576 .93276 .49972 .93139 .49505 Mtetra
0 0 .508 r
.93139 .49505 .93276 .49972 .93422 .50306 .93289 .49883 Mtetra
0 .032 .574 r
.93289 .49883 .93422 .50306 .93562 .50568 .93432 .50181 Mtetra
.067 .147 .638 r
.93432 .50181 .93562 .50568 .93694 .50758 .93567 .50397 Mtetra
.227 .256 .683 r
.93567 .50397 .93694 .50758 .93819 .50876 .93694 .50533 Mtetra
.364 .345 .704 r
.93694 .50533 .93819 .50876 .93938 .50926 .93813 .50592 Mtetra
.469 .409 .708 r
.93813 .50592 .93938 .50926 .94051 .5091 .93926 .50577 Mtetra
.546 .452 .7 r
.93926 .50577 .94051 .5091 .94157 .50828 .94031 .50486 Mtetra
.6 .481 .689 r
.94031 .50486 .94157 .50828 .94256 .50678 .94128 .5032 Mtetra
.638 .498 .676 r
.94128 .5032 .94256 .50678 .94348 .50457 .94218 .50073 Mtetra
.663 .508 .663 r
.94218 .50073 .94348 .50457 .94433 .50162 .94299 .49744 Mtetra
.679 .512 .653 r
.94299 .49744 .94433 .50162 .9451 .49795 .94372 .49333 Mtetra
.686 .512 .645 r
.94372 .49333 .9451 .49795 .9458 .49361 .94437 .48848 Mtetra
.686 .507 .639 r
.94437 .48848 .9458 .49361 .94646 .4888 .94497 .48309 Mtetra
.677 .498 .636 r
.94497 .48309 .94646 .4888 .9471 .4838 .94554 .47749 Mtetra
.66 .484 .636 r
.94554 .47749 .9471 .4838 .94775 .47904 .94614 .47216 Mtetra
.63 .462 .637 r
.94614 .47216 .94775 .47904 .94849 .47501 .94682 .46767 Mtetra
.583 .43 .639 r
.94682 .46767 .94849 .47501 .94935 .47223 .94765 .46456 Mtetra
.513 .383 .641 r
.94765 .46456 .94935 .47223 .95037 .47105 .94866 .46326 Mtetra
.411 .316 .637 r
.94866 .46326 .95037 .47105 .95157 .47162 .94987 .46392 Mtetra
.27 .223 .619 r
.94987 .46392 .95157 .47162 .95295 .47382 .95127 .46642 Mtetra
.099 .111 .583 r
.95127 .46642 .95295 .47382 .95446 .47731 .95283 .47037 Mtetra
0 0 .532 r
.95283 .47037 .95446 .47731 .95606 .4816 .95448 .47522 Mtetra
0 0 .485 r
.95448 .47522 .95606 .4816 .95769 .48619 .95617 .4804 Mtetra
0 0 .462 r
.95617 .4804 .95769 .48619 .95931 .49064 .95785 .48543 Mtetra
0 0 .475 r
.95785 .48543 .95931 .49064 .96088 .49463 .95948 .48995 Mtetra
0 0 .52 r
.95948 .48995 .96088 .49463 .9624 .49798 .96104 .49374 Mtetra
0 .046 .583 r
.96104 .49374 .9624 .49798 .96384 .5006 .96251 .49672 Mtetra
.081 .157 .644 r
.96251 .49672 .96384 .5006 .9652 .50249 .9639 .49887 Mtetra
.236 .263 .686 r
.9639 .49887 .9652 .50249 .96649 .50367 .96521 .50022 Mtetra
.369 .349 .706 r
.96521 .50022 .96649 .50367 .96771 .50415 .96644 .50079 Mtetra
.472 .411 .708 r
.96644 .50079 .96771 .50415 .96886 .50397 .96759 .50061 Mtetra
.547 .454 .7 r
.96759 .50061 .96886 .50397 .96994 .50311 .96866 .49967 Mtetra
.601 .481 .688 r
.96866 .49967 .96994 .50311 .97095 .50157 .96964 .49795 Mtetra
.639 .498 .675 r
.96964 .49795 .97095 .50157 .97188 .4993 .97055 .49543 Mtetra
.664 .508 .663 r
.97055 .49543 .97188 .4993 .97273 .4963 .97136 .49207 Mtetra
.679 .512 .652 r
.97136 .49207 .97273 .4963 .9735 .49256 .97208 .48789 Mtetra
.686 .511 .644 r
.97208 .48789 .9735 .49256 .9742 .48816 .97273 .48296 Mtetra
.685 .506 .638 r
.97273 .48296 .9742 .48816 .97485 .48328 .97331 .4775 Mtetra
.677 .497 .635 r
.97331 .4775 .97485 .48328 .97547 .47824 .97387 .47185 Mtetra
.658 .482 .635 r
.97387 .47185 .97547 .47824 .97613 .47346 .97446 .4665 Mtetra
.627 .46 .637 r
.97446 .4665 .97613 .47346 .97687 .46945 .97515 .46202 Mtetra
.58 .427 .639 r
.97515 .46202 .97687 .46945 .97774 .46672 .97599 .45897 Mtetra
.508 .38 .641 r
.97599 .45897 .97774 .46672 .9788 .46562 .97703 .45776 Mtetra
.422 .314 .626 r
.51559 .65815 .51655 .66599 .51732 .66625 .51636 .65853 Mtetra
.234 .179 .588 r
.51636 .65853 .51732 .66625 .51809 .66811 .51713 .6607 Mtetra
0 0 .498 r
.51713 .6607 .51809 .66811 .51888 .6712 .51792 .66427 Mtetra
0 0 .357 r
.51792 .66427 .51888 .6712 .51967 .67506 .51871 .66871 Mtetra
0 0 .232 r
.51871 .66871 .51967 .67506 .52046 .67917 .51951 .67344 Mtetra
0 0 .176 r
.51951 .67344 .52046 .67917 .52126 .68313 .5203 .67799 Mtetra
0 0 .203 r
.5203 .67799 .52126 .68313 .52205 .68663 .5211 .68202 Mtetra
0 0 .306 r
.5211 .68202 .52205 .68663 .52284 .68948 .52189 .68533 Mtetra
0 0 .458 r
.52189 .68533 .52284 .68948 .52363 .69163 .52268 .68784 Mtetra
.021 .086 .591 r
.52268 .68784 .52363 .69163 .52442 .69305 .52347 .68953 Mtetra
.263 .257 .664 r
.52347 .68953 .52442 .69305 .5252 .69378 .52425 .69042 Mtetra
.427 .368 .689 r
.52425 .69042 .5252 .69378 .52597 .69383 .52503 .69056 Mtetra
.531 .435 .691 r
.52503 .69056 .52597 .69383 .52675 .69322 .5258 .68995 Mtetra
.597 .475 .684 r
.5258 .68995 .52675 .69322 .52751 .69196 .52656 .6886 Mtetra
.639 .498 .675 r
.52656 .6886 .52751 .69196 .52827 .69003 .52732 .68648 Mtetra
.666 .512 .667 r
.52732 .68648 .52827 .69003 .52903 .68739 .52808 .68357 Mtetra
.683 .52 .659 r
.52808 .68357 .52903 .68739 .52978 .68403 .52882 .67984 Mtetra
.693 .523 .652 r
.52882 .67984 .52978 .68403 .53052 .67995 .52956 .67531 Mtetra
.697 .522 .647 r
.52956 .67531 .53052 .67995 .53126 .67524 .5303 .67005 Mtetra
.695 .518 .644 r
.5303 .67005 .53126 .67524 .53199 .67008 .53102 .66428 Mtetra
.687 .51 .642 r
.53102 .66428 .53199 .67008 .53272 .66477 .53175 .65835 Mtetra
.671 .497 .641 r
.53175 .65835 .53272 .66477 .53345 .65974 .53247 .65275 Mtetra
.644 .476 .641 r
.53247 .65275 .53345 .65974 .53419 .6555 .53321 .64803 Mtetra
.601 .444 .64 r
.53321 .64803 .53419 .6555 .53494 .65252 .53395 .64474 Mtetra
.531 .392 .637 r
.53395 .64474 .53494 .65252 .5357 .65115 .53471 .64326 Mtetra
.415 .309 .625 r
.53471 .64326 .5357 .65115 .53649 .65151 .53549 .64374 Mtetra
.227 .174 .587 r
.53549 .64374 .53649 .65151 .53728 .65345 .53629 .64601 Mtetra
0 0 .499 r
.53629 .64601 .53728 .65345 .5381 .65661 .53711 .64966 Mtetra
0 0 .365 r
.53711 .64966 .5381 .65661 .53892 .66051 .53793 .65414 Mtetra
0 0 .248 r
.53793 .65414 .53892 .66051 .53974 .66465 .53876 .6589 Mtetra
0 0 .199 r
.53876 .6589 .53974 .66465 .54057 .66861 .5396 .66345 Mtetra
0 0 .229 r
.5396 .66345 .54057 .66861 .54139 .6721 .54042 .66748 Mtetra
0 0 .333 r
.54042 .66748 .54139 .6721 .54221 .67494 .54124 .67077 Mtetra
0 0 .477 r
.54124 .67077 .54221 .67494 .54302 .67706 .54206 .67325 Mtetra
.046 .104 .601 r
.54206 .67325 .54302 .67706 .54383 .67846 .54286 .67491 Mtetra
.276 .266 .667 r
.54286 .67491 .54383 .67846 .54462 .67916 .54366 .67577 Mtetra
.433 .372 .689 r
.54366 .67577 .54462 .67916 .54541 .67918 .54445 .67587 Mtetra
.533 .436 .69 r
.54445 .67587 .54541 .67918 .5462 .67855 .54524 .67523 Mtetra
.597 .475 .683 r
.54524 .67523 .5462 .67855 .54697 .67725 .54601 .67384 Mtetra
.639 .498 .675 r
.54601 .67384 .54697 .67725 .54774 .67528 .54678 .67169 Mtetra
.666 .512 .666 r
.54678 .67169 .54774 .67528 .5485 .6726 .54753 .66873 Mtetra
.683 .519 .658 r
.54753 .66873 .5485 .6726 .54925 .66919 .54828 .66495 Mtetra
.693 .522 .652 r
.54828 .66495 .54925 .66919 .54999 .66507 .54901 .66035 Mtetra
.696 .521 .647 r
.54901 .66035 .54999 .66507 .55072 .66031 .54973 .65505 Mtetra
.694 .517 .643 r
.54973 .65505 .55072 .66031 .55144 .65512 .55045 .64925 Mtetra
.685 .508 .641 r
.55045 .64925 .55144 .65512 .55217 .64979 .55116 .6433 Mtetra
.669 .495 .64 r
.55116 .6433 .55217 .64979 .55289 .64478 .55188 .6377 Mtetra
.641 .473 .64 r
.55188 .6377 .55289 .64478 .55363 .64058 .55261 .63303 Mtetra
.597 .44 .64 r
.55261 .63303 .55363 .64058 .55438 .63767 .55335 .62982 Mtetra
.525 .388 .637 r
.55335 .62982 .55438 .63767 .55515 .63639 .55413 .62844 Mtetra
.408 .304 .624 r
.55413 .62844 .55515 .63639 .55595 .63683 .55492 .62902 Mtetra
.219 .169 .585 r
.55492 .62902 .55595 .63683 .55677 .63886 .55575 .63139 Mtetra
0 0 .499 r
.55575 .63139 .55677 .63886 .55761 .64209 .5566 .63511 Mtetra
0 0 .373 r
.5566 .63511 .55761 .64209 .55847 .64604 .55746 .63965 Mtetra
0 0 .265 r
.55746 .63965 .55847 .64604 .55933 .6502 .55832 .64444 Mtetra
0 0 .222 r
.55832 .64444 .55933 .6502 .56018 .65417 .55919 .649 Mtetra
0 0 .255 r
.55919 .649 .56018 .65417 .56104 .65765 .56005 .65301 Mtetra
0 0 .357 r
.56005 .65301 .56104 .65765 .56188 .66048 .56089 .65629 Mtetra
0 0 .494 r
.56089 .65629 .56188 .66048 .56271 .66258 .56173 .65875 Mtetra
.069 .12 .608 r
.56173 .65875 .56271 .66258 .56354 .66396 .56256 .66038 Mtetra
.287 .273 .669 r
.56256 .66038 .56354 .66396 .56435 .66463 .56338 .66122 Mtetra
.438 .375 .689 r
.56338 .66122 .56435 .66463 .56516 .66463 .56418 .66129 Mtetra
.535 .437 .689 r
.56418 .66129 .56516 .66463 .56595 .66397 .56498 .66062 Mtetra
.598 .474 .683 r
.56498 .66062 .56595 .66397 .56674 .66265 .56576 .65919 Mtetra
.639 .497 .674 r
.56576 .65919 .56674 .66265 .56751 .66064 .56653 .657 Mtetra
.666 .511 .665 r
.56653 .657 .56751 .66064 .56827 .65792 .56729 .65399 Mtetra
.683 .518 .657 r
.56729 .65399 .56827 .65792 .56902 .65447 .56803 .65016 Mtetra
.692 .521 .651 r
.56803 .65016 .56902 .65447 .56976 .6503 .56876 .64552 Mtetra
.696 .52 .646 r
.56876 .64552 .56976 .6503 .57048 .64551 .56947 .64016 Mtetra
.693 .515 .643 r
.56947 .64016 .57048 .64551 .5712 .64028 .57018 .63433 Mtetra
.684 .507 .641 r
.57018 .63433 .5712 .64028 .57191 .63494 .57088 .62837 Mtetra
.667 .493 .64 r
.57088 .62837 .57191 .63494 .57263 .62994 .57159 .62279 Mtetra
.639 .471 .64 r
.57159 .62279 .57263 .62994 .57336 .62579 .57231 .61816 Mtetra
.593 .437 .639 r
.57231 .61816 .57336 .62579 .57412 .62295 .57306 .61503 Mtetra
.519 .384 .636 r
.57306 .61503 .57412 .62295 .5749 .62176 .57384 .61375 Mtetra
.4 .298 .623 r
.57384 .61375 .5749 .62176 .57572 .6223 .57466 .61444 Mtetra
.212 .165 .584 r
.57466 .61444 .57572 .6223 .57657 .62442 .57551 .61691 Mtetra
0 0 .5 r
.57551 .61691 .57657 .62442 .57744 .62772 .57639 .62072 Mtetra
0 0 .381 r
.57639 .62072 .57744 .62772 .57833 .63172 .57729 .62531 Mtetra
0 0 .28 r
.57729 .62531 .57833 .63172 .57922 .63591 .57819 .63013 Mtetra
0 0 .243 r
.57819 .63013 .57922 .63591 .58011 .63989 .57909 .6347 Mtetra
0 0 .279 r
.57909 .6347 .58011 .63989 .58099 .64337 .57998 .63871 Mtetra
0 0 .38 r
.57998 .63871 .58099 .64337 .58186 .64618 .58086 .64197 Mtetra
0 0 .51 r
.58086 .64197 .58186 .64618 .58272 .64827 .58172 .64441 Mtetra
.089 .134 .615 r
.58172 .64441 .58272 .64827 .58357 .64963 .58257 .64602 Mtetra
.298 .28 .671 r
.58257 .64602 .58357 .64963 .5844 .65029 .58341 .64684 Mtetra
.443 .377 .689 r
.58341 .64684 .5844 .65029 .58522 .65026 .58423 .64689 Mtetra
.537 .437 .689 r
.58423 .64689 .58522 .65026 .58603 .64958 .58503 .64618 Mtetra
.598 .474 .682 r
.58503 .64618 .58603 .64958 .58682 .64822 .58582 .64473 Mtetra
.639 .497 .673 r
.58582 .64473 .58682 .64822 .5876 .64618 .5866 .64249 Mtetra
.665 .51 .664 r
.5866 .64249 .5876 .64618 .58836 .64343 .58736 .63944 Mtetra
.682 .517 .656 r
.58736 .63944 .58836 .64343 .58911 .63993 .5881 .63556 Mtetra
.692 .52 .65 r
.5881 .63556 .58911 .63993 .58984 .63573 .58882 .63087 Mtetra
.695 .519 .645 r
.58882 .63087 .58984 .63573 .59056 .63089 .58953 .62547 Mtetra
.692 .514 .642 r
.58953 .62547 .59056 .63089 .59127 .62564 .59022 .6196 Mtetra
.683 .505 .64 r
.59022 .6196 .59127 .62564 .59197 .6203 .59091 .61364 Mtetra
.665 .491 .639 r
.59091 .61364 .59197 .6203 .59269 .61532 .59161 .60808 Mtetra
.636 .468 .639 r
.59161 .60808 .59269 .61532 .59342 .61121 .59233 .60351 Mtetra
.589 .434 .639 r
.59233 .60351 .59342 .61121 .59418 .60845 .59308 .60046 Mtetra
.513 .379 .636 r
.59308 .60046 .59418 .60845 .59497 .60735 .59388 .59929 Mtetra
.392 .293 .622 r
.59388 .59929 .59497 .60735 .59581 .60799 .59472 .60009 Mtetra
.205 .16 .583 r
.59472 .60009 .59581 .60799 .59669 .6102 .5956 .60266 Mtetra
0 0 .501 r
.5956 .60266 .59669 .6102 .59759 .61359 .59651 .60655 Mtetra
0 0 .388 r
.59651 .60655 .59759 .61359 .59851 .61764 .59744 .61121 Mtetra
0 0 .295 r
.59744 .61121 .59851 .61764 .59944 .62187 .59838 .61606 Mtetra
0 0 .264 r
.59838 .61606 .59944 .62187 .60036 .62586 .59932 .62065 Mtetra
0 0 .302 r
.59932 .62065 .60036 .62586 .60127 .62934 .60024 .62466 Mtetra
0 0 .4 r
.60024 .62466 .60127 .62934 .60217 .63214 .60115 .62791 Mtetra
0 0 .523 r
.60115 .62791 .60217 .63214 .60306 .63422 .60204 .63033 Mtetra
.106 .147 .621 r
.60204 .63033 .60306 .63422 .60392 .63557 .60291 .63193 Mtetra
.306 .286 .672 r
.60291 .63193 .60392 .63557 .60478 .6362 .60377 .63272 Mtetra
.446 .379 .689 r
.60377 .63272 .60478 .6362 .60561 .63616 .6046 .63275 Mtetra
.538 .438 .688 r
.6046 .63275 .60561 .63616 .60643 .63546 .60542 .63202 Mtetra
.598 .474 .681 r
.60542 .63202 .60643 .63546 .60723 .63408 .60622 .63053 Mtetra
.638 .496 .672 r
.60622 .63053 .60723 .63408 .60802 .63201 .607 .62826 Mtetra
.665 .509 .663 r
.607 .62826 .60802 .63201 .60878 .62922 .60776 .62517 Mtetra
.681 .516 .656 r
.60776 .62517 .60878 .62922 .60953 .62569 .6085 .62124 Mtetra
.691 .519 .649 r
.6085 .62124 .60953 .62569 .61026 .62144 .60921 .61651 Mtetra
.694 .517 .644 r
.60921 .61651 .61026 .62144 .61097 .61657 .60991 .61107 Mtetra
.691 .513 .641 r
.60991 .61107 .61097 .61657 .61167 .61129 .61059 .60517 Mtetra
.681 .503 .639 r
.61059 .60517 .61167 .61129 .61237 .60595 .61127 .5992 Mtetra
.663 .488 .639 r
.61127 .5992 .61237 .60595 .61307 .60099 .61196 .59367 Mtetra
.632 .465 .639 r
.61196 .59367 .61307 .60099 .6138 .59694 .61268 .58916 Mtetra
.584 .43 .639 r
.61268 .58916 .6138 .59694 .61457 .59426 .61344 .5862 Mtetra
.507 .375 .635 r
.61344 .5862 .61457 .59426 .61538 .59326 .61424 .58514 Mtetra
.384 .288 .621 r
.61424 .58514 .61538 .59326 .61624 .59401 .61511 .58606 Mtetra
.197 .155 .582 r
.61511 .58606 .61624 .59401 .61714 .59632 .61602 .58873 Mtetra
0 0 .502 r
.61602 .58873 .61714 .59632 .61808 .59978 .61697 .59272 Mtetra
0 0 .395 r
.61697 .59272 .61808 .59978 .61903 .60389 .61794 .59744 Mtetra
0 0 .31 r
.61794 .59744 .61903 .60389 .62 .60815 .61892 .60233 Mtetra
0 0 .283 r
.61892 .60233 .62 .60815 .62096 .61217 .61989 .60694 Mtetra
0 0 .323 r
.61989 .60694 .62096 .61217 .6219 .61565 .62085 .61095 Mtetra
0 0 .419 r
.62085 .61095 .6219 .61565 .62283 .61845 .62179 .61419 Mtetra
0 0 .535 r
.62179 .61419 .62283 .61845 .62374 .62052 .62271 .61661 Mtetra
.122 .158 .626 r
.62271 .61661 .62374 .62052 .62463 .62186 .6236 .61819 Mtetra
.314 .291 .673 r
.6236 .61819 .62463 .62186 .6255 .62249 .62447 .61897 Mtetra
.449 .381 .689 r
.62447 .61897 .6255 .62249 .62635 .62243 .62533 .61898 Mtetra
.539 .438 .688 r
.62533 .61898 .62635 .62243 .62718 .62171 .62616 .61823 Mtetra
.598 .473 .681 r
.62616 .61823 .62718 .62171 .62799 .62031 .62696 .61671 Mtetra
.638 .495 .672 r
.62696 .61671 .62799 .62031 .62878 .61821 .62775 .61441 Mtetra
.664 .508 .663 r
.62775 .61441 .62878 .61821 .62955 .61539 .62851 .61128 Mtetra
.681 .515 .655 r
.62851 .61128 .62955 .61539 .6303 .61182 .62924 .60731 Mtetra
.69 .517 .648 r
.62924 .60731 .6303 .61182 .63103 .60754 .62995 .60253 Mtetra
.693 .516 .644 r
.62995 .60253 .63103 .60754 .63173 .60264 .63064 .59706 Mtetra
.69 .511 .64 r
.63064 .59706 .63173 .60264 .63242 .59734 .63131 .59114 Mtetra
.679 .501 .638 r
.63131 .59114 .63242 .59734 .63311 .592 .63198 .58516 Mtetra
.66 .486 .638 r
.63198 .58516 .63311 .592 .63381 .58707 .63266 .57966 Mtetra
.629 .463 .638 r
.63266 .57966 .63381 .58707 .63454 .58308 .63338 .57521 Mtetra
.579 .426 .638 r
.63338 .57521 .63454 .58308 .63531 .58048 .63414 .57235 Mtetra
.501 .37 .634 r
.63414 .57235 .63531 .58048 .63614 .57959 .63496 .5714 Mtetra
.376 .282 .62 r
.63496 .5714 .63614 .57959 .63702 .58045 .63585 .57245 Mtetra
.189 .15 .581 r
.63585 .57245 .63702 .58045 .63795 .58286 .63679 .57524 Mtetra
0 0 .503 r
.63679 .57524 .63795 .58286 .63893 .58641 .63778 .57932 Mtetra
0 0 .402 r
.63778 .57932 .63893 .58641 .63992 .59058 .63879 .58411 Mtetra
0 0 .323 r
.63879 .58411 .63992 .59058 .64092 .59489 .63981 .58904 Mtetra
0 0 .3 r
.63981 .58904 .64092 .59489 .64192 .59892 .64082 .59367 Mtetra
0 0 .342 r
.64082 .59367 .64192 .59892 .6429 .60242 .64182 .5977 Mtetra
0 0 .435 r
.64182 .5977 .6429 .60242 .64385 .60523 .64279 .60094 Mtetra
0 .007 .546 r
.64279 .60094 .64385 .60523 .64479 .60729 .64374 .60335 Mtetra
.135 .167 .631 r
.64374 .60335 .64479 .60729 .6457 .60862 .64466 .60492 Mtetra
.319 .295 .674 r
.64466 .60492 .6457 .60862 .64659 .60924 .64555 .60569 Mtetra
.451 .382 .689 r
.64555 .60569 .64659 .60924 .64746 .60918 .64642 .60568 Mtetra
.539 .437 .687 r
.64642 .60568 .64746 .60918 .6483 .60844 .64726 .60492 Mtetra
.598 .472 .68 r
.64726 .60492 .6483 .60844 .64912 .60702 .64808 .60338 Mtetra
.637 .494 .671 r
.64808 .60338 .64912 .60702 .64992 .6049 .64887 .60105 Mtetra
.663 .507 .662 r
.64887 .60105 .64992 .6049 .65069 .60205 .64963 .59789 Mtetra
.68 .514 .654 r
.64963 .59789 .65069 .60205 .65144 .59846 .65036 .59388 Mtetra
.689 .516 .648 r
.65036 .59388 .65144 .59846 .65216 .59414 .65106 .58906 Mtetra
.692 .515 .643 r
.65106 .58906 .65216 .59414 .65286 .58921 .65174 .58355 Mtetra
.688 .509 .64 r
.65174 .58355 .65286 .58921 .65354 .5839 .6524 .57761 Mtetra
.677 .499 .638 r
.6524 .57761 .65354 .5839 .65422 .57856 .65306 .57164 Mtetra
.658 .484 .637 r
.65306 .57164 .65422 .57856 .65492 .57366 .65373 .56617 Mtetra
.625 .46 .638 r
.65373 .56617 .65492 .57366 .65565 .56973 .65444 .56179 Mtetra
.574 .423 .638 r
.65444 .56179 .65565 .56973 .65643 .56723 .65521 .55902 Mtetra
.494 .365 .634 r
.65521 .55902 .65643 .56723 .65727 .56644 .65605 .5582 Mtetra
.368 .276 .619 r
.65605 .5582 .65727 .56644 .65818 .56742 .65697 .55937 Mtetra
.181 .146 .579 r
.65697 .55937 .65818 .56742 .65914 .56994 .65795 .56228 Mtetra
0 0 .504 r
.65795 .56228 .65914 .56994 .66015 .57358 .65897 .56646 Mtetra
0 0 .408 r
.65897 .56646 .66015 .57358 .66119 .57783 .66003 .57132 Mtetra
0 0 .335 r
.66003 .57132 .66119 .57783 .66223 .58218 .66109 .57631 Mtetra
0 0 .317 r
.66109 .57631 .66223 .58218 .66326 .58624 .66214 .58097 Mtetra
0 0 .36 r
.66214 .58097 .66326 .58624 .66428 .58975 .66318 .58501 Mtetra
0 0 .45 r
.66318 .58501 .66428 .58975 .66526 .59257 .66418 .58826 Mtetra
0 .021 .554 r
.66418 .58826 .66526 .59257 .66623 .59464 .66515 .59067 Mtetra
.146 .175 .634 r
.66515 .59067 .66623 .59464 .66716 .59597 .6661 .59224 Mtetra
.324 .298 .675 r
.6661 .59224 .66716 .59597 .66807 .59658 .66701 .593 Mtetra
.452 .383 .689 r
.66701 .593 .66807 .59658 .66896 .59651 .6679 .59298 Mtetra
.539 .437 .687 r
.6679 .59298 .66896 .59651 .66982 .59577 .66876 .5922 Mtetra
.597 .471 .68 r
.66876 .5922 .66982 .59577 .67065 .59434 .66958 .59064 Mtetra
.636 .493 .671 r
.66958 .59064 .67065 .59434 .67145 .5922 .67038 .58829 Mtetra
.662 .506 .661 r
.67038 .58829 .67145 .5922 .67223 .58932 .67114 .58509 Mtetra
.679 .513 .653 r
.67114 .58509 .67223 .58932 .67297 .58569 .67187 .58105 Mtetra
.688 .515 .647 r
.67187 .58105 .67297 .58569 .67369 .58135 .67256 .57619 Mtetra
.691 .513 .642 r
.67256 .57619 .67369 .58135 .67438 .57639 .67323 .57065 Mtetra
.687 .508 .639 r
.67323 .57065 .67438 .57639 .67506 .57107 .67388 .56469 Mtetra
.676 .497 .637 r
.67388 .56469 .67506 .57107 .67573 .56574 .67453 .55873 Mtetra
.655 .481 .637 r
.67453 .55873 .67573 .56574 .67642 .56088 .6752 .55329 Mtetra
.622 .456 .637 r
.6752 .55329 .67642 .56088 .67715 .55701 .67591 .54899 Mtetra
.569 .419 .637 r
.67591 .54899 .67715 .55701 .67794 .55461 .67669 .54633 Mtetra
.487 .36 .633 r
.67669 .54633 .67794 .55461 .6788 .55394 .67754 .54564 Mtetra
.359 .27 .618 r
.67754 .54564 .6788 .55394 .67974 .55504 .67849 .54694 Mtetra
.173 .141 .578 r
.67849 .54694 .67974 .55504 .68074 .55767 .6795 .54998 Mtetra
0 0 .504 r
.6795 .54998 .68074 .55767 .68179 .56141 .68057 .55426 Mtetra
0 0 .413 r
.68057 .55426 .68179 .56141 .68286 .56572 .68167 .5592 Mtetra
0 0 .346 r
.68167 .5592 .68286 .56572 .68395 .57013 .68278 .56424 Mtetra
0 0 .332 r
.68278 .56424 .68395 .57013 .68502 .57423 .68387 .56894 Mtetra
0 0 .375 r
.68387 .56894 .68502 .57423 .68607 .57776 .68494 .57299 Mtetra
0 0 .463 r
.68494 .57299 .68607 .57776 .68709 .58059 .68598 .57626 Mtetra
0 .033 .562 r
.68598 .57626 .68709 .58059 .68808 .58266 .68699 .57867 Mtetra
.155 .182 .637 r
.68699 .57867 .68808 .58266 .68904 .584 .68796 .58024 Mtetra
.328 .301 .676 r
.68796 .58024 .68904 .584 .68997 .58461 .6889 .581 Mtetra
.453 .383 .689 r
.6889 .581 .68997 .58461 .69088 .58454 .6898 .58097 Mtetra
.538 .437 .687 r
.6898 .58097 .69088 .58454 .69175 .58379 .69067 .58018 Mtetra
.596 .471 .679 r
.69067 .58018 .69175 .58379 .69259 .58235 .69151 .57861 Mtetra
.635 .492 .67 r
.69151 .57861 .69259 .58235 .6934 .58019 .69231 .57623 Mtetra
.662 .505 .661 r
.69231 .57623 .6934 .58019 .69418 .57729 .69307 .57301 Mtetra
.678 .511 .653 r
.69307 .57301 .69418 .57729 .69493 .57364 .6938 .56893 Mtetra
.687 .514 .646 r
.6938 .56893 .69493 .57364 .69564 .56926 .69449 .56404 Mtetra
.69 .512 .641 r
.69449 .56404 .69564 .56926 .69632 .56429 .69514 .55846 Mtetra
.685 .506 .638 r
.69514 .55846 .69632 .56429 .69699 .55895 .69578 .55249 Mtetra
.674 .495 .637 r
.69578 .55249 .69699 .55895 .69766 .55363 .69642 .54653 Mtetra
.652 .479 .636 r
.69642 .54653 .69766 .55363 .69834 .54881 .69708 .54114 Mtetra
.618 .453 .637 r
.69708 .54114 .69834 .54881 .69908 .54502 .69779 .53691 Mtetra
.564 .415 .637 r
.69779 .53691 .69908 .54502 .69988 .54271 .69858 .53436 Mtetra
.48 .355 .633 r
.69858 .53436 .69988 .54271 .70076 .54216 .69946 .5338 Mtetra
.35 .264 .617 r
.69946 .5338 .70076 .54216 .70173 .54339 .70043 .53524 Mtetra
.165 .136 .577 r
.70043 .53524 .70173 .54339 .70276 .54614 .70149 .53841 Mtetra
0 0 .505 r
.70149 .53841 .70276 .54614 .70386 .54997 .7026 .5428 Mtetra
0 0 .419 r
.7026 .5428 .70386 .54997 .70498 .55437 .70375 .54782 Mtetra
0 0 .357 r
.70375 .54782 .70498 .55437 .7061 .55883 .7049 .55292 Mtetra
0 0 .346 r
.7049 .55292 .7061 .55883 .70721 .56297 .70604 .55766 Mtetra
0 0 .39 r
.70604 .55766 .70721 .56297 .7083 .56652 .70715 .56174 Mtetra
0 0 .475 r
.70715 .56174 .7083 .56652 .70936 .56937 .70823 .56502 Mtetra
0 .044 .569 r
.70823 .56502 .70936 .56937 .71038 .57146 .70926 .56744 Mtetra
.163 .188 .64 r
.70926 .56744 .71038 .57146 .71137 .5728 .71026 .56901 Mtetra
.331 .303 .677 r
.71026 .56901 .71137 .5728 .71232 .57342 .71122 .56977 Mtetra
.453 .383 .689 r
.71122 .56977 .71232 .57342 .71324 .57335 .71214 .56975 Mtetra
.538 .436 .687 r
.71214 .56975 .71324 .57335 .71413 .57259 .71303 .56895 Mtetra
.595 .47 .679 r
.71303 .56895 .71413 .57259 .71498 .57114 .71388 .56736 Mtetra
.634 .491 .67 r
.71388 .56736 .71498 .57114 .7158 .56897 .71468 .56496 Mtetra
.661 .503 .66 r
.71468 .56496 .7158 .56897 .71659 .56605 .71545 .5617 Mtetra
.677 .51 .652 r
.71545 .5617 .71659 .56605 .71733 .56237 .71617 .55759 Mtetra
.686 .512 .645 r
.71617 .55759 .71733 .56237 .71804 .55796 .71685 .55266 Mtetra
.688 .51 .641 r
.71685 .55266 .71804 .55796 .71871 .55296 .7175 .54706 Mtetra
.684 .504 .637 r
.7175 .54706 .71871 .55296 .71937 .54761 .71813 .54107 Mtetra
.672 .493 .636 r
.71813 .54107 .71937 .54761 .72003 .54231 .71875 .53512 Mtetra
.65 .476 .636 r
.71875 .53512 .72003 .54231 .72072 .53753 .71941 .52977 Mtetra
.614 .45 .636 r
.71941 .52977 .72072 .53753 .72145 .53381 .72012 .52562 Mtetra
.559 .41 .636 r
.72012 .52562 .72145 .53381 .72227 .53161 .72092 .52319 Mtetra
.472 .35 .632 r
.72092 .52319 .72227 .53161 .72317 .53118 .72183 .52276 Mtetra
.341 .258 .616 r
.72183 .52276 .72317 .53118 .72417 .53254 .72283 .52434 Mtetra
.156 .131 .576 r
.72283 .52434 .72417 .53254 .72525 .53541 .72393 .52764 Mtetra
0 0 .505 r
.72393 .52764 .72525 .53541 .72638 .53935 .72509 .53215 Mtetra
0 0 .424 r
.72509 .53215 .72638 .53935 .72755 .54382 .72629 .53726 Mtetra
0 0 .367 r
.72629 .53726 .72755 .54382 .72872 .54834 .72749 .54242 Mtetra
0 0 .359 r
.72749 .54242 .72872 .54834 .72988 .55252 .72868 .5472 Mtetra
0 0 .403 r
.72868 .5472 .72988 .55252 .731 .55611 .72983 .55131 Mtetra
0 0 .485 r
.72983 .55131 .731 .55611 .7321 .55897 .73094 .5546 Mtetra
0 .054 .575 r
.73094 .5546 .7321 .55897 .73315 .56107 .73201 .55704 Mtetra
.169 .194 .643 r
.73201 .55704 .73315 .56107 .73416 .56243 .73304 .55862 Mtetra
.333 .305 .678 r
.73304 .55862 .73416 .56243 .73514 .56305 .73402 .55938 Mtetra
.453 .384 .689 r
.73402 .55938 .73514 .56305 .73608 .56298 .73496 .55935 Mtetra
.537 .436 .687 r
.73496 .55935 .73608 .56298 .73699 .56222 .73587 .55854 Mtetra
.595 .469 .679 r
.73587 .55854 .73699 .56222 .73785 .56076 .73672 .55694 Mtetra
.634 .49 .669 r
.73672 .55694 .73785 .56076 .73868 .55858 .73754 .55452 Mtetra
.66 .502 .66 r
.73754 .55452 .73868 .55858 .73947 .55563 .73831 .55123 Mtetra
.677 .509 .651 r
.73831 .55123 .73947 .55563 .74021 .55192 .73903 .54709 Mtetra
.685 .511 .645 r
.73903 .54709 .74021 .55192 .74091 .54749 .7397 .54212 Mtetra
.687 .509 .64 r
.7397 .54212 .74091 .54749 .74158 .54246 .74034 .53648 Mtetra
.682 .503 .637 r
.74034 .53648 .74158 .54246 .74223 .53711 .74095 .53048 Mtetra
.67 .491 .635 r
.74095 .53048 .74223 .53711 .74289 .53181 .74157 .52454 Mtetra
.647 .474 .635 r
.74157 .52454 .74289 .53181 .74357 .52707 .74222 .51923 Mtetra
.61 .447 .636 r
.74222 .51923 .74357 .52707 .74431 .52343 .74293 .51517 Mtetra
.553 .406 .636 r
.74293 .51517 .74431 .52343 .74514 .52133 .74375 .51284 Mtetra
.465 .345 .631 r
.74375 .51284 .74514 .52133 .74607 .52103 .74468 .51255 Mtetra
.332 .253 .615 r
.74468 .51255 .74607 .52103 .7471 .52252 .74572 .51428 Mtetra
.148 .126 .575 r
.74572 .51428 .7471 .52252 .74822 .52551 .74686 .51771 Mtetra
0 0 .506 r
.74686 .51771 .74822 .52551 .7494 .52956 .74808 .52233 Mtetra
0 0 .429 r
.74808 .52233 .7494 .52956 .75062 .53412 .74933 .52754 Mtetra
0 0 .376 r
.74933 .52754 .75062 .53412 .75184 .5387 .75058 .53277 Mtetra
0 0 .371 r
.75058 .53277 .75184 .5387 .75304 .54292 .75181 .53759 Mtetra
0 0 .415 r
.75181 .53759 .75304 .54292 .75421 .54654 .75301 .54173 Mtetra
0 0 .495 r
.75301 .54173 .75421 .54654 .75534 .54942 .75416 .54504 Mtetra
0 .064 .581 r
.75416 .54504 .75534 .54942 .75642 .55154 .75526 .54749 Mtetra
.175 .199 .646 r
.75526 .54749 .75642 .55154 .75746 .5529 .75632 .54907 Mtetra
.335 .307 .679 r
.75632 .54907 .75746 .5529 .75847 .55354 .75733 .54984 Mtetra
.454 .384 .689 r
.75733 .54984 .75847 .55354 .75943 .55347 .75829 .54981 Mtetra
.537 .435 .687 r
.75829 .54981 .75943 .55347 .76035 .5527 .75921 .54899 Mtetra
.594 .468 .679 r
.75921 .54899 .76035 .5527 .76123 .55123 .76008 .54737 Mtetra
.633 .489 .669 r
.76008 .54737 .76123 .55123 .76206 .54903 .7609 .54492 Mtetra
.659 .502 .659 r
.7609 .54492 .76206 .54903 .76285 .54606 .76167 .54161 Mtetra
.676 .508 .651 r
.76167 .54161 .76285 .54606 .7636 .54232 .76238 .53742 Mtetra
.685 .51 .644 r
.76238 .53742 .7636 .54232 .7643 .53785 .76305 .53241 Mtetra
.686 .508 .639 r
.76305 .53241 .7643 .53785 .76496 .5328 .76367 .52674 Mtetra
.681 .501 .636 r
.76367 .52674 .76496 .5328 .7656 .52743 .76428 .52071 Mtetra
.668 .489 .635 r
.76428 .52071 .7656 .52743 .76625 .52214 .76488 .51478 Mtetra
.644 .471 .635 r
.76488 .51478 .76625 .52214 .76693 .51745 .76553 .50952 Mtetra
.606 .444 .636 r
.76553 .50952 .76693 .51745 .76768 .51388 .76625 .50554 Mtetra
.547 .402 .636 r
.76625 .50554 .76768 .51388 .76852 .51189 .76708 .50333 Mtetra
.457 .339 .631 r
.76708 .50333 .76852 .51189 .76948 .51171 .76804 .50318 Mtetra
.323 .247 .614 r
.76804 .50318 .76948 .51171 .77055 .51333 .76912 .50505 Mtetra
.141 .122 .574 r
.76912 .50505 .77055 .51333 .77171 .51645 .77031 .50862 Mtetra
0 0 .507 r
.77031 .50862 .77171 .51645 .77295 .5206 .77158 .51335 Mtetra
0 0 .434 r
.77158 .51335 .77295 .5206 .77421 .52524 .77288 .51865 Mtetra
0 0 .386 r
.77288 .51865 .77421 .52524 .77548 .52989 .77419 .52394 Mtetra
0 0 .383 r
.77419 .52394 .77548 .52989 .77673 .53415 .77547 .52881 Mtetra
0 0 .427 r
.77547 .52881 .77673 .53415 .77794 .5378 .77671 .53298 Mtetra
0 0 .504 r
.77671 .53298 .77794 .5378 .7791 .54071 .77791 .53631 Mtetra
0 .073 .587 r
.77791 .53631 .7791 .54071 .78022 .54284 .77904 .53877 Mtetra
.181 .204 .648 r
.77904 .53877 .78022 .54284 .7813 .54421 .78013 .54036 Mtetra
.338 .31 .68 r
.78013 .54036 .7813 .54421 .78232 .54485 .78116 .54113 Mtetra
.454 .385 .69 r
.78116 .54113 .78232 .54485 .78331 .54478 .78215 .54109 Mtetra
.536 .435 .687 r
.78215 .54109 .78331 .54478 .78424 .54401 .78308 .54027 Mtetra
.594 .468 .679 r
.78308 .54027 .78424 .54401 .78514 .54252 .78396 .53863 Mtetra
.633 .489 .668 r
.78396 .53863 .78514 .54252 .78598 .5403 .78479 .53615 Mtetra
.659 .501 .659 r
.78479 .53615 .78598 .5403 .78678 .5373 .78556 .5328 Mtetra
.675 .507 .65 r
.78556 .5328 .78678 .5373 .78752 .53352 .78628 .52857 Mtetra
.684 .509 .643 r
.78628 .52857 .78752 .53352 .78821 .52902 .78693 .52351 Mtetra
.686 .506 .638 r
.78693 .52351 .78821 .52902 .78887 .52393 .78755 .5178 Mtetra
.68 .499 .635 r
.78755 .5178 .78887 .52393 .7895 .51855 .78814 .51175 Mtetra
.666 .488 .634 r
.78814 .51175 .7895 .51855 .79014 .51327 .78873 .50582 Mtetra
.641 .469 .634 r
.78873 .50582 .79014 .51327 .79082 .50861 .78937 .5006 Mtetra
.602 .441 .635 r
.78937 .5006 .79082 .50861 .79158 .50512 .7901 .4967 Mtetra
.542 .398 .635 r
.7901 .4967 .79158 .50512 .79244 .50323 .79095 .4946 Mtetra
.45 .335 .63 r
.79095 .4946 .79244 .50323 .79343 .50318 .79194 .49459 Mtetra
.315 .242 .613 r
.79194 .49459 .79343 .50318 .79454 .50493 .79306 .4966 Mtetra
.134 .118 .573 r
.79306 .4966 .79454 .50493 .79575 .50817 .7943 .50031 Mtetra
0 0 .509 r
.7943 .50031 .79575 .50817 .79703 .51243 .79563 .50516 Mtetra
0 0 .439 r
.79563 .50516 .79703 .51243 .79835 .51716 .79699 .51054 Mtetra
0 0 .395 r
.79699 .51054 .79835 .51716 .79967 .52186 .79835 .51591 Mtetra
0 0 .394 r
.79835 .51591 .79967 .52186 .80097 .52617 .79968 .52082 Mtetra
0 0 .439 r
.79968 .52082 .80097 .52617 .80223 .52985 .80097 .52502 Mtetra
0 0 .513 r
.80097 .52502 .80223 .52985 .80343 .53277 .80221 .52837 Mtetra
.007 .082 .592 r
.80221 .52837 .80343 .53277 .80459 .53491 .80338 .53083 Mtetra
.187 .209 .651 r
.80338 .53083 .80459 .53491 .80569 .53629 .8045 .53243 Mtetra
.34 .312 .681 r
.8045 .53243 .80569 .53629 .80674 .53693 .80556 .5332 Mtetra
.455 .386 .69 r
.80556 .5332 .80674 .53693 .80775 .53686 .80657 .53315 Mtetra
.537 .436 .687 r
.80657 .53315 .80775 .53686 .8087 .53608 .80752 .53231 Mtetra
.593 .468 .678 r
.80752 .53231 .8087 .53608 .80961 .53458 .80841 .53065 Mtetra
.632 .488 .668 r
.80841 .53065 .80961 .53458 .81046 .53232 .80925 .52814 Mtetra
.659 .5 .658 r
.80925 .52814 .81046 .53232 .81126 .52929 .81002 .52474 Mtetra
.675 .506 .649 r
.81002 .52474 .81126 .52929 .812 .52548 .81073 .52046 Mtetra
.684 .508 .643 r
.81073 .52046 .812 .52548 .81269 .52093 .81138 .51536 Mtetra
.685 .505 .638 r
.81138 .51536 .81269 .52093 .81334 .51581 .81198 .5096 Mtetra
.679 .498 .635 r
.81198 .5096 .81334 .51581 .81396 .5104 .81256 .50352 Mtetra
.664 .486 .633 r
.81256 .50352 .81396 .5104 .8146 .50512 .81314 .49759 Mtetra
.639 .467 .634 r
.81314 .49759 .8146 .50512 .81528 .5005 .81378 .49241 Mtetra
.598 .438 .635 r
.81378 .49241 .81528 .5005 .81604 .49708 .81451 .48858 Mtetra
.536 .394 .635 r
.81451 .48858 .81604 .49708 .81693 .49529 .81538 .4866 Mtetra
.443 .33 .63 r
.81538 .4866 .81693 .49529 .81794 .49537 .8164 .48672 Mtetra
.307 .237 .612 r
.8164 .48672 .81794 .49537 .8191 .49724 .81757 .48888 Mtetra
.127 .115 .573 r
.81757 .48888 .8191 .49724 .82036 .50061 .81887 .49272 Mtetra
0 0 .51 r
.81887 .49272 .82036 .50061 .8217 .50497 .82025 .49768 Mtetra
0 0 .445 r
.82025 .49768 .8217 .50497 .82307 .50978 .82167 .50316 Mtetra
0 0 .405 r
.82167 .50316 .82307 .50978 .82445 .51455 .82309 .50858 Mtetra
0 0 .406 r
.82309 .50858 .82445 .51455 .82579 .5189 .82448 .51354 Mtetra
0 0 .45 r
.82448 .51354 .82579 .5189 .8271 .5226 .82582 .51776 Mtetra
0 0 .522 r
.82582 .51776 .8271 .5226 .82834 .52554 .82709 .52113 Mtetra
.018 .091 .598 r
.82709 .52113 .82834 .52554 .82953 .52769 .82831 .5236 Mtetra
.194 .215 .654 r
.82831 .5236 .82953 .52769 .83067 .52907 .82946 .5252 Mtetra
.343 .315 .683 r
.82946 .5252 .83067 .52907 .83175 .52971 .83055 .52596 Mtetra
.456 .387 .691 r
.83055 .52596 .83175 .52971 .83278 .52963 .83158 .52591 Mtetra
.537 .436 .687 r
.83158 .52591 .83278 .52963 .83375 .52884 .83254 .52504 Mtetra
.594 .468 .678 r
.83254 .52504 .83375 .52884 .83467 .52731 .83345 .52335 Mtetra
.633 .488 .668 r
.83345 .52335 .83467 .52731 .83553 .52503 .83429 .5208 Mtetra
.659 .5 .658 r
.83429 .5208 .83553 .52503 .83633 .52196 .83506 .51736 Mtetra
.675 .506 .649 r
.83506 .51736 .83633 .52196 .83708 .51809 .83577 .51302 Mtetra
.683 .507 .642 r
.83577 .51302 .83708 .51809 .83776 .5135 .83641 .50786 Mtetra
.684 .504 .637 r
.83641 .50786 .83776 .5135 .8384 .50834 .837 .50205 Mtetra
.678 .497 .634 r
.837 .50205 .8384 .50834 .83901 .5029 .83756 .49594 Mtetra
.662 .484 .633 r
.83756 .49594 .83901 .5029 .83964 .49762 .83814 .49 Mtetra
.636 .464 .633 r
.83814 .49 .83964 .49762 .84032 .49303 .83877 .48485 Mtetra
.595 .435 .635 r
.83877 .48485 .84032 .49303 .84109 .48968 .83951 .4811 Mtetra
.531 .39 .635 r
.83951 .4811 .84109 .48968 .842 .48799 .8404 .47923 Mtetra
.436 .325 .629 r
.8404 .47923 .842 .48799 .84305 .48819 .84146 .47948 Mtetra
.299 .232 .612 r
.84146 .47948 .84305 .48819 .84425 .49019 .84268 .48178 Mtetra
.122 .112 .573 r
.84268 .48178 .84425 .49019 .84557 .49368 .84403 .48575 Mtetra
0 0 .513 r
.84403 .48575 .84557 .49368 .84696 .49814 .84547 .49083 Mtetra
0 0 .451 r
.84547 .49083 .84696 .49814 .84839 .50303 .84695 .49639 Mtetra
0 0 .415 r
.84695 .49639 .84839 .50303 .84982 .50785 .84843 .50188 Mtetra
0 0 .418 r
.84843 .50188 .84982 .50785 .85122 .51224 .84988 .50688 Mtetra
0 0 .462 r
.84988 .50688 .85122 .51224 .85257 .51597 .85127 .51113 Mtetra
0 0 .532 r
.85127 .51113 .85257 .51597 .85386 .51892 .85259 .5145 Mtetra
.03 .101 .604 r
.85259 .5145 .85386 .51892 .85509 .52108 .85384 .51698 Mtetra
.201 .221 .657 r
.85384 .51698 .85509 .52108 .85626 .52247 .85503 .51858 Mtetra
.347 .318 .684 r
.85503 .51858 .85626 .52247 .85737 .5231 .85614 .51933 Mtetra
.458 .389 .691 r
.85614 .51933 .85737 .5231 .85842 .52301 .85719 .51926 Mtetra
.538 .437 .687 r
.85719 .51926 .85842 .52301 .85941 .52219 .85818 .51837 Mtetra
.594 .468 .678 r
.85818 .51837 .85941 .52219 .86035 .52064 .8591 .51664 Mtetra
.633 .488 .667 r
.8591 .51664 .86035 .52064 .86122 .51832 .85995 .51405 Mtetra
.659 .5 .657 r
.85995 .51405 .86122 .51832 .86202 .5152 .86072 .51055 Mtetra
.675 .505 .648 r
.86072 .51055 .86202 .5152 .86276 .51129 .86142 .50615 Mtetra
.683 .506 .641 r
.86142 .50615 .86276 .51129 .86344 .50664 .86205 .50092 Mtetra
.684 .503 .636 r
.86205 .50092 .86344 .50664 .86407 .50142 .86262 .49506 Mtetra
.676 .495 .633 r
.86262 .49506 .86407 .50142 .86467 .49595 .86317 .48891 Mtetra
.661 .482 .632 r
.86317 .48891 .86467 .49595 .86529 .49067 .86374 .48296 Mtetra
.633 .462 .633 r
.86374 .48296 .86529 .49067 .86597 .4861 .86437 .47784 Mtetra
.591 .432 .634 r
.86437 .47784 .86597 .4861 .86676 .48282 .86512 .47415 Mtetra
.526 .387 .634 r
.86512 .47415 .86676 .48282 .86769 .48123 .86603 .47239 Mtetra
.429 .321 .629 r
.86603 .47239 .86769 .48123 .86878 .48154 .86713 .47278 Mtetra
.292 .228 .611 r
.86713 .47278 .86878 .48154 .87002 .48368 .86839 .47522 Mtetra
.117 .11 .573 r
.86839 .47522 .87002 .48368 .87139 .48728 .8698 .47932 Mtetra
0 0 .515 r
.8698 .47932 .87139 .48728 .87285 .49184 .87131 .48451 Mtetra
0 0 .458 r
.87131 .48451 .87285 .49184 .87434 .49681 .87286 .49016 Mtetra
0 0 .425 r
.87286 .49016 .87434 .49681 .87583 .50169 .8744 .4957 Mtetra
0 0 .431 r
.8744 .4957 .87583 .50169 .87728 .50611 .87591 .50074 Mtetra
0 0 .474 r
.87591 .50074 .87728 .50611 .87868 .50986 .87735 .50501 Mtetra
0 0 .541 r
.87735 .50501 .87868 .50986 .88002 .51283 .87872 .5084 Mtetra
.043 .111 .61 r
.87872 .5084 .88002 .51283 .88128 .51499 .88001 .51088 Mtetra
.209 .227 .66 r
.88001 .51088 .88128 .51499 .88249 .51637 .88123 .51247 Mtetra
.351 .322 .686 r
.88123 .51247 .88249 .51637 .88362 .51699 .88237 .5132 Mtetra
.46 .391 .692 r
.88237 .5132 .88362 .51699 .8847 .51688 .88345 .51311 Mtetra
.539 .438 .687 r
.88345 .51311 .8847 .51688 .88571 .51604 .88445 .51219 Mtetra
.595 .468 .678 r
.88445 .51219 .88571 .51604 .88666 .51446 .88538 .51043 Mtetra
.633 .488 .667 r
.88538 .51043 .88666 .51446 .88754 .51209 .88624 .50778 Mtetra
.659 .499 .656 r
.88624 .50778 .88754 .51209 .88834 .50892 .88701 .50422 Mtetra
.675 .505 .647 r
.88701 .50422 .88834 .50892 .88908 .50495 .8877 .49975 Mtetra
.683 .505 .64 r
.8877 .49975 .88908 .50495 .88975 .50024 .88832 .49446 Mtetra
.683 .502 .635 r
.88832 .49446 .88975 .50024 .89037 .49497 .88888 .48853 Mtetra
.675 .494 .632 r
.88888 .48853 .89037 .49497 .89097 .48946 .88942 .48233 Mtetra
.659 .48 .631 r
.88942 .48233 .89097 .48946 .89158 .48416 .88997 .47637 Mtetra
.631 .459 .632 r
.88997 .47637 .89158 .48416 .89226 .47963 .8906 .47127 Mtetra
.587 .429 .634 r
.8906 .47127 .89226 .47963 .89306 .4764 .89136 .46766 Mtetra
.521 .383 .634 r
.89136 .46766 .89306 .4764 .89401 .47491 .8923 .466 Mtetra
.423 .316 .629 r
.8923 .466 .89401 .47491 .89514 .47534 .89343 .46652 Mtetra
.286 .224 .611 r
.89343 .46652 .89514 .47534 .89643 .4776 .89475 .4691 Mtetra
.114 .109 .573 r
.89475 .4691 .89643 .4776 .89786 .48132 .89623 .47333 Mtetra
0 0 .519 r
.89623 .47333 .89786 .48132 .89938 .48598 .8978 .47863 Mtetra
0 0 .465 r
.8978 .47863 .89938 .48598 .90094 .49102 .89941 .48435 Mtetra
0 0 .436 r
.89941 .48435 .90094 .49102 .90249 .49595 .90102 .48996 Mtetra
0 0 .443 r
.90102 .48996 .90249 .49595 .904 .50041 .90259 .49503 Mtetra
0 0 .486 r
.90259 .49503 .904 .50041 .90545 .50418 .90408 .49932 Mtetra
0 .007 .55 r
.90408 .49932 .90545 .50418 .90683 .50715 .9055 .50271 Mtetra
.056 .122 .616 r
.9055 .50271 .90683 .50715 .90813 .50931 .90683 .50519 Mtetra
.217 .234 .663 r
.90683 .50519 .90813 .50931 .90937 .51068 .90809 .50677 Mtetra
.356 .326 .687 r
.90809 .50677 .90937 .51068 .91054 .51129 .90926 .50749 Mtetra
.463 .393 .693 r
.90926 .50749 .91054 .51129 .91164 .51116 .91036 .50737 Mtetra
.541 .439 .688 r
.91036 .50737 .91164 .51116 .91267 .5103 .91139 .50641 Mtetra
.596 .469 .678 r
.91139 .50641 .91267 .5103 .91363 .50867 .91233 .5046 Mtetra
.634 .488 .666 r
.91233 .5046 .91363 .50867 .91452 .50626 .91319 .5019 Mtetra
.66 .499 .656 r
.91319 .5019 .91452 .50626 .91533 .50303 .91396 .49828 Mtetra
.675 .504 .646 r
.91396 .49828 .91533 .50303 .91606 .49899 .91464 .49373 Mtetra
.683 .505 .639 r
.91464 .49373 .91606 .49899 .91672 .49422 .91525 .48836 Mtetra
.683 .501 .634 r
.91525 .48836 .91672 .49422 .91733 .48889 .91579 .48236 Mtetra
.674 .492 .631 r
.91579 .48236 .91733 .48889 .91791 .48334 .91631 .47611 Mtetra
.657 .478 .631 r
.91631 .47611 .91791 .48334 .91852 .47802 .91686 .47013 Mtetra
.628 .457 .632 r
.91686 .47013 .91852 .47802 .9192 .47351 .91748 .46506 Mtetra
.583 .426 .633 r
.91748 .46506 .9192 .47351 .92001 .47035 .91826 .46151 Mtetra
.515 .379 .634 r
.91826 .46151 .92001 .47035 .92099 .46895 .91922 .45996 Mtetra
.416 .312 .629 r
.91922 .45996 .92099 .46895 .92216 .4695 .9204 .46061 Mtetra
.28 .221 .611 r
.9204 .46061 .92216 .4695 .92351 .47188 .92177 .46332 Mtetra
.111 .109 .574 r
.92177 .46332 .92351 .47188 .925 .47571 .92331 .46768 Mtetra
0 0 .522 r
.92331 .46768 .925 .47571 .92659 .48047 .92496 .47308 Mtetra
0 0 .473 r
.92496 .47308 .92659 .48047 .92821 .48558 .92664 .47889 Mtetra
0 0 .447 r
.92664 .47889 .92821 .48558 .92982 .49056 .92832 .48455 Mtetra
0 0 .456 r
.92832 .48455 .92982 .49056 .93139 .49505 .92995 .48965 Mtetra
0 0 .498 r
.92995 .48965 .93139 .49505 .93289 .49883 .9315 .49396 Mtetra
0 .021 .56 r
.9315 .49396 .93289 .49883 .93432 .50181 .93296 .49736 Mtetra
.069 .132 .622 r
.93296 .49736 .93432 .50181 .93567 .50397 .93434 .49983 Mtetra
.226 .241 .666 r
.93434 .49983 .93567 .50397 .93694 .50533 .93563 .50139 Mtetra
.361 .33 .688 r
.93563 .50139 .93694 .50533 .93813 .50592 .93684 .50209 Mtetra
.466 .395 .693 r
.93684 .50209 .93813 .50592 .93926 .50577 .93796 .50194 Mtetra
.543 .44 .688 r
.93796 .50194 .93926 .50577 .94031 .50486 .939 .50095 Mtetra
.597 .47 .677 r
.939 .50095 .94031 .50486 .94128 .5032 .93996 .49909 Mtetra
.635 .488 .666 r
.93996 .49909 .94128 .5032 .94218 .50073 .94082 .49633 Mtetra
.66 .499 .655 r
.94082 .49633 .94218 .50073 .94299 .49744 .94159 .49263 Mtetra
.676 .504 .645 r
.94159 .49263 .94299 .49744 .94372 .49333 .94227 .488 Mtetra
.683 .504 .638 r
.94227 .488 .94372 .49333 .94437 .48848 .94286 .48255 Mtetra
.682 .5 .633 r
.94286 .48255 .94437 .48848 .94497 .48309 .94338 .47647 Mtetra
.673 .491 .631 r
.94338 .47647 .94497 .48309 .94554 .47749 .94389 .47017 Mtetra
.656 .477 .63 r
.94389 .47017 .94554 .47749 .94614 .47216 .94442 .46417 Mtetra
.626 .455 .631 r
.94442 .46417 .94614 .47216 .94682 .46767 .94504 .45912 Mtetra
.579 .423 .633 r
.94504 .45912 .94682 .46767 .94765 .46456 .94583 .45563 Mtetra
.51 .376 .634 r
.94583 .45563 .94765 .46456 .94866 .46326 .94682 .45419 Mtetra
.41 .309 .628 r
.94682 .45419 .94866 .46326 .94987 .46392 .94804 .45496 Mtetra
.274 .218 .611 r
.94804 .45496 .94987 .46392 .95127 .46642 .94948 .45781 Mtetra
.11 .109 .575 r
.94948 .45781 .95127 .46642 .95283 .47037 .95109 .4623 Mtetra
0 .001 .526 r
.95109 .4623 .95283 .47037 .95448 .47522 .9528 .46781 Mtetra
0 0 .481 r
.9528 .46781 .95448 .47522 .95617 .4804 .95457 .47369 Mtetra
0 0 .458 r
.95457 .47369 .95617 .4804 .95785 .48543 .95631 .4794 Mtetra
0 0 .468 r
.95631 .4794 .95785 .48543 .95948 .48995 .958 .48454 Mtetra
0 0 .509 r
.958 .48454 .95948 .48995 .96104 .49374 .95961 .48886 Mtetra
0 .035 .569 r
.95961 .48886 .96104 .49374 .96251 .49672 .96113 .49225 Mtetra
.083 .143 .627 r
.96113 .49225 .96251 .49672 .9639 .49887 .96255 .49472 Mtetra
.235 .248 .669 r
.96255 .49472 .9639 .49887 .96521 .50022 .96388 .49627 Mtetra
.367 .334 .69 r
.96388 .49627 .96521 .50022 .96644 .50079 .96511 .49694 Mtetra
.469 .397 .694 r
.96511 .49694 .96644 .50079 .96759 .50061 .96626 .49676 Mtetra
.544 .441 .688 r
.96626 .49676 .96759 .50061 .96866 .49967 .96732 .49572 Mtetra
.598 .47 .677 r
.96732 .49572 .96866 .49967 .96964 .49795 .96829 .4938 Mtetra
.636 .488 .665 r
.96829 .4938 .96964 .49795 .97055 .49543 .96916 .49097 Mtetra
.661 .499 .654 r
.96916 .49097 .97055 .49543 .97136 .49207 .96992 .4872 Mtetra
.676 .503 .644 r
.96992 .4872 .97136 .49207 .97208 .48789 .97059 .48249 Mtetra
.683 .503 .637 r
.97059 .48249 .97208 .48789 .97273 .48296 .97117 .47694 Mtetra
.682 .499 .632 r
.97117 .47694 .97273 .48296 .97331 .4775 .97168 .47079 Mtetra
.673 .49 .63 r
.97168 .47079 .97331 .4775 .97387 .47185 .97216 .46443 Mtetra
.654 .475 .629 r
.97216 .46443 .97387 .47185 .97446 .4665 .97268 .4584 Mtetra
.623 .452 .631 r
.97268 .4584 .97446 .4665 .97515 .46202 .9733 .45337 Mtetra
.576 .42 .633 r
.9733 .45337 .97515 .46202 .97599 .45897 .9741 .44995 Mtetra
.505 .372 .633 r
.9741 .44995 .97599 .45897 .97703 .45776 .97513 .44861 Mtetra
.416 .306 .62 r
.51463 .64952 .51559 .65815 .51636 .65853 .5154 .65002 Mtetra
.217 .162 .577 r
.5154 .65002 .51636 .65853 .51713 .6607 .51617 .65254 Mtetra
0 0 .475 r
.51617 .65254 .51713 .6607 .51792 .66427 .51696 .65665 Mtetra
0 0 .317 r
.51696 .65665 .51792 .66427 .51871 .66871 .51775 .66172 Mtetra
0 0 .18 r
.51775 .66172 .51871 .66871 .51951 .67344 .51855 .66713 Mtetra
0 0 .12 r
.51855 .66713 .51951 .67344 .5203 .67799 .51935 .67234 Mtetra
0 0 .143 r
.51935 .67234 .5203 .67799 .5211 .68202 .52015 .67697 Mtetra
0 0 .246 r
.52015 .67697 .5211 .68202 .52189 .68533 .52094 .68078 Mtetra
0 0 .407 r
.52094 .68078 .52189 .68533 .52268 .68784 .52173 .68368 Mtetra
0 .04 .561 r
.52173 .68368 .52268 .68784 .52347 .68953 .52252 .68567 Mtetra
.234 .229 .648 r
.52252 .68567 .52347 .68953 .52425 .69042 .5233 .68675 Mtetra
.414 .352 .679 r
.5233 .68675 .52425 .69042 .52503 .69056 .52408 .68698 Mtetra
.526 .425 .683 r
.52408 .68698 .52503 .69056 .5258 .68995 .52485 .68637 Mtetra
.595 .468 .678 r
.52485 .68637 .5258 .68995 .52656 .6886 .52561 .68492 Mtetra
.638 .494 .67 r
.52561 .68492 .52656 .6886 .52732 .68648 .52637 .6826 Mtetra
.667 .509 .662 r
.52637 .6826 .52732 .68648 .52808 .68357 .52712 .67939 Mtetra
.684 .517 .654 r
.52712 .67939 .52808 .68357 .52882 .67984 .52787 .67525 Mtetra
.694 .521 .648 r
.52787 .67525 .52882 .67984 .52956 .67531 .5286 .67021 Mtetra
.698 .521 .644 r
.5286 .67021 .52956 .67531 .5303 .67005 .52933 .66435 Mtetra
.696 .517 .641 r
.52933 .66435 .5303 .67005 .53102 .66428 .53005 .65791 Mtetra
.688 .509 .639 r
.53005 .65791 .53102 .66428 .53175 .65835 .53077 .6513 Mtetra
.672 .495 .638 r
.53077 .6513 .53175 .65835 .53247 .65275 .53149 .64505 Mtetra
.645 .474 .638 r
.53149 .64505 .53247 .65275 .53321 .64803 .53222 .6398 Mtetra
.601 .441 .637 r
.53222 .6398 .53321 .64803 .53395 .64474 .53296 .63616 Mtetra
.529 .388 .634 r
.53296 .63616 .53395 .64474 .53471 .64326 .53372 .63458 Mtetra
.408 .301 .619 r
.53372 .63458 .53471 .64326 .53549 .64374 .5345 .63519 Mtetra
.209 .157 .576 r
.5345 .63519 .53549 .64374 .53629 .64601 .5353 .63782 Mtetra
0 0 .476 r
.5353 .63782 .53629 .64601 .53711 .64966 .53612 .642 Mtetra
0 0 .326 r
.53612 .642 .53711 .64966 .53793 .65414 .53695 .64714 Mtetra
0 0 .198 r
.53695 .64714 .53793 .65414 .53876 .6589 .53778 .65258 Mtetra
0 0 .144 r
.53778 .65258 .53876 .6589 .5396 .66345 .53862 .65779 Mtetra
0 0 .17 r
.53862 .65779 .5396 .66345 .54042 .66748 .53945 .66241 Mtetra
0 0 .274 r
.53945 .66241 .54042 .66748 .54124 .67077 .54027 .6662 Mtetra
0 0 .43 r
.54027 .6662 .54124 .67077 .54206 .67325 .54109 .66907 Mtetra
0 .06 .572 r
.54109 .66907 .54206 .67325 .54286 .67491 .5419 .67102 Mtetra
.249 .239 .651 r
.5419 .67102 .54286 .67491 .54366 .67577 .5427 .67207 Mtetra
.421 .356 .679 r
.5427 .67207 .54366 .67577 .54445 .67587 .54349 .67226 Mtetra
.528 .427 .683 r
.54349 .67226 .54445 .67587 .54524 .67523 .54427 .67161 Mtetra
.596 .468 .677 r
.54427 .67161 .54524 .67523 .54601 .67384 .54504 .67012 Mtetra
.639 .494 .669 r
.54504 .67012 .54601 .67384 .54678 .67169 .54581 .66776 Mtetra
.667 .508 .661 r
.54581 .66776 .54678 .67169 .54753 .66873 .54656 .66449 Mtetra
.684 .517 .654 r
.54656 .66449 .54753 .66873 .54828 .66495 .5473 .66029 Mtetra
.694 .52 .648 r
.5473 .66029 .54828 .66495 .54901 .66035 .54802 .65518 Mtetra
.698 .52 .643 r
.54802 .65518 .54901 .66035 .54973 .65505 .54874 .64927 Mtetra
.695 .515 .64 r
.54874 .64927 .54973 .65505 .55045 .64925 .54945 .64279 Mtetra
.687 .507 .638 r
.54945 .64279 .55045 .64925 .55116 .6433 .55015 .63616 Mtetra
.67 .493 .637 r
.55015 .63616 .55116 .6433 .55188 .6377 .55086 .62992 Mtetra
.642 .472 .637 r
.55086 .62992 .55188 .6377 .55261 .63303 .55158 .62472 Mtetra
.597 .438 .637 r
.55158 .62472 .55261 .63303 .55335 .62982 .55232 .62117 Mtetra
.523 .384 .633 r
.55232 .62117 .55335 .62982 .55413 .62844 .55309 .61969 Mtetra
.401 .295 .618 r
.55309 .61969 .55413 .62844 .55492 .62902 .55389 .62042 Mtetra
.201 .152 .575 r
.55389 .62042 .55492 .62902 .55575 .63139 .55472 .62316 Mtetra
0 0 .477 r
.55472 .62316 .55575 .63139 .5566 .63511 .55557 .62744 Mtetra
0 0 .335 r
.55557 .62744 .5566 .63511 .55746 .63965 .55644 .63263 Mtetra
0 0 .216 r
.55644 .63263 .55746 .63965 .55832 .64444 .55731 .6381 Mtetra
0 0 .167 r
.55731 .6381 .55832 .64444 .55919 .649 .55818 .64332 Mtetra
0 0 .198 r
.55818 .64332 .55919 .649 .56005 .65301 .55905 .64793 Mtetra
0 0 .301 r
.55905 .64793 .56005 .65301 .56089 .65629 .5599 .6517 Mtetra
0 0 .45 r
.5599 .6517 .56089 .65629 .56173 .65875 .56075 .65455 Mtetra
.022 .078 .582 r
.56075 .65455 .56173 .65875 .56256 .66038 .56158 .65647 Mtetra
.262 .248 .654 r
.56158 .65647 .56256 .66038 .56338 .66122 .5624 .65749 Mtetra
.427 .36 .68 r
.5624 .65749 .56338 .66122 .56418 .66129 .5632 .65764 Mtetra
.531 .428 .682 r
.5632 .65764 .56418 .66129 .56498 .66062 .564 .65696 Mtetra
.597 .468 .676 r
.564 .65696 .56498 .66062 .56576 .65919 .56478 .65542 Mtetra
.639 .493 .668 r
.56478 .65542 .56576 .65919 .56653 .657 .56554 .65301 Mtetra
.666 .508 .66 r
.56554 .65301 .56653 .657 .56729 .65399 .56629 .64969 Mtetra
.684 .516 .653 r
.56629 .64969 .56729 .65399 .56803 .65016 .56703 .64544 Mtetra
.694 .519 .647 r
.56703 .64544 .56803 .65016 .56876 .64552 .56775 .64027 Mtetra
.697 .518 .642 r
.56775 .64027 .56876 .64552 .56947 .64016 .56845 .6343 Mtetra
.695 .514 .639 r
.56845 .6343 .56947 .64016 .57018 .63433 .56915 .62779 Mtetra
.685 .506 .637 r
.56915 .62779 .57018 .63433 .57088 .62837 .56984 .62114 Mtetra
.668 .491 .637 r
.56984 .62114 .57088 .62837 .57159 .62279 .57053 .61492 Mtetra
.639 .469 .637 r
.57053 .61492 .57159 .62279 .57231 .61816 .57125 .60978 Mtetra
.593 .435 .636 r
.57125 .60978 .57231 .61816 .57306 .61503 .57199 .60631 Mtetra
.518 .38 .632 r
.57199 .60631 .57306 .61503 .57384 .61375 .57277 .60495 Mtetra
.393 .29 .617 r
.57277 .60495 .57384 .61375 .57466 .61444 .57359 .6058 Mtetra
.194 .147 .573 r
.57359 .6058 .57466 .61444 .57551 .61691 .57445 .60865 Mtetra
0 0 .478 r
.57445 .60865 .57551 .61691 .57639 .62072 .57533 .61302 Mtetra
0 0 .344 r
.57533 .61302 .57639 .62072 .57729 .62531 .57624 .61827 Mtetra
0 0 .233 r
.57624 .61827 .57729 .62531 .57819 .63013 .57715 .62378 Mtetra
0 0 .19 r
.57715 .62378 .57819 .63013 .57909 .6347 .57806 .62901 Mtetra
0 0 .224 r
.57806 .62901 .57909 .6347 .57998 .63871 .57896 .63361 Mtetra
0 0 .327 r
.57896 .63361 .57998 .63871 .58086 .64197 .57985 .63736 Mtetra
0 0 .469 r
.57985 .63736 .58086 .64197 .58172 .64441 .58072 .64019 Mtetra
.045 .095 .591 r
.58072 .64019 .58172 .64441 .58257 .64602 .58157 .64208 Mtetra
.274 .256 .657 r
.58157 .64208 .58257 .64602 .58341 .64684 .58241 .64307 Mtetra
.432 .363 .68 r
.58241 .64307 .58341 .64684 .58423 .64689 .58323 .6432 Mtetra
.533 .429 .682 r
.58323 .6432 .58423 .64689 .58503 .64618 .58404 .64248 Mtetra
.597 .468 .676 r
.58404 .64248 .58503 .64618 .58582 .64473 .58482 .6409 Mtetra
.639 .493 .668 r
.58482 .6409 .58582 .64473 .5866 .64249 .58559 .63845 Mtetra
.666 .507 .659 r
.58559 .63845 .5866 .64249 .58736 .63944 .58635 .63508 Mtetra
.683 .515 .652 r
.58635 .63508 .58736 .63944 .5881 .63556 .58708 .63077 Mtetra
.693 .518 .646 r
.58708 .63077 .5881 .63556 .58882 .63087 .58779 .62555 Mtetra
.696 .517 .642 r
.58779 .62555 .58882 .63087 .58953 .62547 .58848 .61953 Mtetra
.693 .513 .638 r
.58848 .61953 .58953 .62547 .59022 .6196 .58916 .61298 Mtetra
.684 .504 .637 r
.58916 .61298 .59022 .6196 .59091 .61364 .58984 .60632 Mtetra
.666 .489 .636 r
.58984 .60632 .59091 .61364 .59161 .60808 .59052 .60012 Mtetra
.636 .467 .636 r
.59052 .60012 .59161 .60808 .59233 .60351 .59123 .59504 Mtetra
.589 .431 .636 r
.59123 .59504 .59233 .60351 .59308 .60046 .59197 .59167 Mtetra
.511 .375 .632 r
.59197 .59167 .59308 .60046 .59388 .59929 .59276 .59042 Mtetra
.385 .284 .616 r
.59276 .59042 .59388 .59929 .59472 .60009 .5936 .5914 Mtetra
.186 .142 .572 r
.5936 .5914 .59472 .60009 .5956 .60266 .59449 .59436 Mtetra
0 0 .479 r
.59449 .59436 .5956 .60266 .59651 .60655 .59542 .59882 Mtetra
0 0 .352 r
.59542 .59882 .59651 .60655 .59744 .61121 .59636 .60414 Mtetra
0 0 .249 r
.59636 .60414 .59744 .61121 .59838 .61606 .59731 .60969 Mtetra
0 0 .212 r
.59731 .60969 .59838 .61606 .59932 .62065 .59826 .61494 Mtetra
0 0 .248 r
.59826 .61494 .59932 .62065 .60024 .62466 .5992 .61953 Mtetra
0 0 .35 r
.5992 .61953 .60024 .62466 .60115 .62791 .60012 .62327 Mtetra
0 0 .485 r
.60012 .62327 .60115 .62791 .60204 .63033 .60102 .62608 Mtetra
.066 .11 .598 r
.60102 .62608 .60204 .63033 .60291 .63193 .6019 .62795 Mtetra
.284 .263 .659 r
.6019 .62795 .60291 .63193 .60377 .63272 .60275 .62892 Mtetra
.436 .366 .68 r
.60275 .62892 .60377 .63272 .6046 .63275 .60359 .62902 Mtetra
.534 .429 .681 r
.60359 .62902 .6046 .63275 .60542 .63202 .60441 .62827 Mtetra
.597 .468 .675 r
.60441 .62827 .60542 .63202 .60622 .63053 .6052 .62666 Mtetra
.639 .492 .667 r
.6052 .62666 .60622 .63053 .607 .62826 .60598 .62416 Mtetra
.666 .506 .658 r
.60598 .62416 .607 .62826 .60776 .62517 .60673 .62075 Mtetra
.683 .514 .651 r
.60673 .62075 .60776 .62517 .6085 .62124 .60745 .61638 Mtetra
.692 .517 .645 r
.60745 .61638 .6085 .62124 .60921 .61651 .60815 .61111 Mtetra
.695 .516 .641 r
.60815 .61111 .60921 .61651 .60991 .61107 .60883 .60504 Mtetra
.692 .511 .638 r
.60883 .60504 .60991 .61107 .61059 .60517 .6095 .59846 Mtetra
.682 .502 .636 r
.6095 .59846 .61059 .60517 .61127 .5992 .61016 .59179 Mtetra
.664 .487 .635 r
.61016 .59179 .61127 .5992 .61196 .59367 .61083 .58562 Mtetra
.633 .464 .636 r
.61083 .58562 .61196 .59367 .61268 .58916 .61154 .5806 Mtetra
.584 .428 .635 r
.61154 .5806 .61268 .58916 .61344 .5862 .61228 .57733 Mtetra
.505 .37 .631 r
.61228 .57733 .61344 .5862 .61424 .58514 .61309 .57621 Mtetra
.377 .279 .615 r
.61309 .57621 .61424 .58514 .61511 .58606 .61395 .57731 Mtetra
.179 .137 .571 r
.61395 .57731 .61511 .58606 .61602 .58873 .61487 .5804 Mtetra
0 0 .48 r
.61487 .5804 .61602 .58873 .61697 .59272 .61584 .58496 Mtetra
0 0 .36 r
.61584 .58496 .61697 .59272 .61794 .59744 .61682 .59035 Mtetra
0 0 .265 r
.61682 .59035 .61794 .59744 .61892 .60233 .61782 .59594 Mtetra
0 0 .233 r
.61782 .59594 .61892 .60233 .61989 .60694 .61881 .60121 Mtetra
0 0 .271 r
.61881 .60121 .61989 .60694 .62085 .61095 .61978 .6058 Mtetra
0 0 .371 r
.61978 .6058 .62085 .61095 .62179 .61419 .62073 .60954 Mtetra
0 0 .5 r
.62073 .60954 .62179 .61419 .62271 .61661 .62166 .61233 Mtetra
.084 .123 .605 r
.62166 .61233 .62271 .61661 .6236 .61819 .62256 .61418 Mtetra
.293 .269 .661 r
.62256 .61418 .6236 .61819 .62447 .61897 .62344 .61513 Mtetra
.439 .368 .68 r
.62344 .61513 .62447 .61897 .62533 .61898 .62429 .61521 Mtetra
.535 .43 .681 r
.62429 .61521 .62533 .61898 .62616 .61823 .62512 .61443 Mtetra
.597 .468 .675 r
.62512 .61443 .62616 .61823 .62696 .61671 .62593 .61279 Mtetra
.638 .491 .666 r
.62593 .61279 .62696 .61671 .62775 .61441 .6267 .61026 Mtetra
.665 .505 .658 r
.6267 .61026 .62775 .61441 .62851 .61128 .62745 .60679 Mtetra
.682 .513 .65 r
.62745 .60679 .62851 .61128 .62924 .60731 .62818 .60238 Mtetra
.692 .516 .644 r
.62818 .60238 .62924 .60731 .62995 .60253 .62887 .59705 Mtetra
.695 .515 .64 r
.62887 .59705 .62995 .60253 .63064 .59706 .62954 .59094 Mtetra
.691 .51 .637 r
.62954 .59094 .63064 .59706 .63131 .59114 .63019 .58433 Mtetra
.681 .5 .635 r
.63019 .58433 .63131 .59114 .63198 .58516 .63083 .57766 Mtetra
.662 .485 .635 r
.63083 .57766 .63198 .58516 .63266 .57966 .6315 .57152 Mtetra
.63 .461 .635 r
.6315 .57152 .63266 .57966 .63338 .57521 .63219 .56657 Mtetra
.579 .424 .635 r
.63219 .56657 .63338 .57521 .63414 .57235 .63294 .56341 Mtetra
.499 .366 .63 r
.63294 .56341 .63414 .57235 .63496 .5714 .63376 .56241 Mtetra
.369 .273 .614 r
.63376 .56241 .63496 .5714 .63585 .57245 .63466 .56365 Mtetra
.171 .133 .57 r
.63466 .56365 .63585 .57245 .63679 .57524 .63561 .56687 Mtetra
0 0 .482 r
.63561 .56687 .63679 .57524 .63778 .57932 .63661 .57153 Mtetra
0 0 .368 r
.63661 .57153 .63778 .57932 .63879 .58411 .63765 .57699 Mtetra
0 0 .279 r
.63765 .57699 .63879 .58411 .63981 .58904 .63869 .58263 Mtetra
0 0 .252 r
.63869 .58263 .63981 .58904 .64082 .59367 .63972 .58792 Mtetra
0 0 .293 r
.63972 .58792 .64082 .59367 .64182 .5977 .64073 .59253 Mtetra
0 0 .39 r
.64073 .59253 .64182 .5977 .64279 .60094 .64171 .59626 Mtetra
0 0 .512 r
.64171 .59626 .64279 .60094 .64374 .60335 .64267 .59904 Mtetra
.099 .134 .61 r
.64267 .59904 .64374 .60335 .64466 .60492 .6436 .60089 Mtetra
.3 .274 .662 r
.6436 .60089 .64466 .60492 .64555 .60569 .6445 .60182 Mtetra
.442 .37 .68 r
.6445 .60182 .64555 .60569 .64642 .60568 .64537 .60188 Mtetra
.536 .43 .68 r
.64537 .60188 .64642 .60568 .64726 .60492 .64621 .60108 Mtetra
.597 .467 .674 r
.64621 .60108 .64726 .60492 .64808 .60338 .64702 .59941 Mtetra
.638 .49 .665 r
.64702 .59941 .64808 .60338 .64887 .60105 .6478 .59684 Mtetra
.665 .504 .657 r
.6478 .59684 .64887 .60105 .64963 .59789 .64855 .59333 Mtetra
.682 .512 .65 r
.64855 .59333 .64963 .59789 .65036 .59388 .64927 .58888 Mtetra
.691 .514 .644 r
.64927 .58888 .65036 .59388 .65106 .58906 .64995 .5835 Mtetra
.694 .513 .639 r
.64995 .5835 .65106 .58906 .65174 .58355 .6506 .57735 Mtetra
.69 .508 .636 r
.6506 .57735 .65174 .58355 .6524 .57761 .65124 .57071 Mtetra
.679 .498 .635 r
.65124 .57071 .6524 .57761 .65306 .57164 .65187 .56403 Mtetra
.659 .483 .634 r
.65187 .56403 .65306 .57164 .65373 .56617 .65252 .55793 Mtetra
.627 .458 .635 r
.65252 .55793 .65373 .56617 .65444 .56179 .65322 .55306 Mtetra
.575 .42 .634 r
.65322 .55306 .65444 .56179 .65521 .55902 .65398 .55001 Mtetra
.492 .361 .63 r
.65398 .55001 .65521 .55902 .65605 .5582 .65481 .54914 Mtetra
.36 .267 .613 r
.65481 .54914 .65605 .5582 .65697 .55937 .65573 .55053 Mtetra
.163 .128 .568 r
.65573 .55053 .65697 .55937 .65795 .56228 .65672 .55387 Mtetra
0 0 .483 r
.65672 .55387 .65795 .56228 .65897 .56646 .65777 .55864 Mtetra
0 0 .375 r
.65777 .55864 .65897 .56646 .66003 .57132 .65885 .56419 Mtetra
0 0 .293 r
.65885 .56419 .66003 .57132 .66109 .57631 .65993 .56988 Mtetra
0 0 .27 r
.65993 .56988 .66109 .57631 .66214 .58097 .66101 .5752 Mtetra
0 0 .312 r
.66101 .5752 .66214 .58097 .66318 .58501 .66206 .57982 Mtetra
0 0 .407 r
.66206 .57982 .66318 .58501 .66418 .58826 .66308 .58355 Mtetra
0 0 .523 r
.66308 .58355 .66418 .58826 .66515 .59067 .66407 .58633 Mtetra
.112 .144 .615 r
.66407 .58633 .66515 .59067 .6661 .59224 .66502 .58817 Mtetra
.306 .279 .664 r
.66502 .58817 .6661 .59224 .66701 .593 .66594 .58909 Mtetra
.444 .371 .68 r
.66594 .58909 .66701 .593 .6679 .59298 .66683 .58914 Mtetra
.536 .43 .68 r
.66683 .58914 .6679 .59298 .66876 .5922 .66768 .58832 Mtetra
.597 .466 .673 r
.66768 .58832 .66876 .5922 .66958 .59064 .6685 .58662 Mtetra
.637 .489 .665 r
.6685 .58662 .66958 .59064 .67038 .58829 .66929 .58402 Mtetra
.664 .503 .656 r
.66929 .58402 .67038 .58829 .67114 .58509 .67004 .58048 Mtetra
.681 .51 .649 r
.67004 .58048 .67114 .58509 .67187 .58105 .67075 .57597 Mtetra
.69 .513 .643 r
.67075 .57597 .67187 .58105 .67256 .57619 .67142 .57055 Mtetra
.693 .512 .638 r
.67142 .57055 .67256 .57619 .67323 .57065 .67206 .56436 Mtetra
.689 .506 .635 r
.67206 .56436 .67323 .57065 .67388 .56469 .67268 .5577 Mtetra
.677 .496 .634 r
.67268 .5577 .67388 .56469 .67453 .55873 .6733 .55103 Mtetra
.657 .48 .634 r
.6733 .55103 .67453 .55873 .6752 .55329 .67394 .54497 Mtetra
.623 .455 .634 r
.67394 .54497 .6752 .55329 .67591 .54899 .67463 .54017 Mtetra
.569 .416 .634 r
.67463 .54017 .67591 .54899 .67669 .54633 .6754 .53724 Mtetra
.485 .355 .629 r
.6754 .53724 .67669 .54633 .67754 .54564 .67626 .53651 Mtetra
.351 .261 .612 r
.67626 .53651 .67754 .54564 .67849 .54694 .67721 .53804 Mtetra
.155 .123 .567 r
.67721 .53804 .67849 .54694 .6795 .54998 .67824 .54152 Mtetra
0 0 .484 r
.67824 .54152 .6795 .54998 .68057 .55426 .67933 .54641 Mtetra
0 0 .381 r
.67933 .54641 .68057 .55426 .68167 .5592 .68046 .55204 Mtetra
0 0 .306 r
.68046 .55204 .68167 .5592 .68278 .56424 .68159 .55779 Mtetra
0 0 .287 r
.68159 .55779 .68278 .56424 .68387 .56894 .68271 .56315 Mtetra
0 0 .33 r
.68271 .56315 .68387 .56894 .68494 .57299 .6838 .56778 Mtetra
0 0 .423 r
.6838 .56778 .68494 .57299 .68598 .57626 .68486 .57153 Mtetra
0 0 .533 r
.68486 .57153 .68598 .57626 .68699 .57867 .68588 .57431 Mtetra
.124 .153 .619 r
.68588 .57431 .68699 .57867 .68796 .58024 .68686 .57614 Mtetra
.311 .282 .665 r
.68686 .57614 .68796 .58024 .6889 .581 .6878 .57706 Mtetra
.445 .372 .68 r
.6878 .57706 .6889 .581 .6898 .58097 .68871 .57709 Mtetra
.536 .429 .68 r
.68871 .57709 .6898 .58097 .69067 .58018 .68958 .57625 Mtetra
.596 .466 .673 r
.68958 .57625 .69067 .58018 .69151 .57861 .69041 .57454 Mtetra
.637 .488 .664 r
.69041 .57454 .69151 .57861 .69231 .57623 .6912 .57191 Mtetra
.663 .502 .656 r
.6912 .57191 .69231 .57623 .69307 .57301 .69194 .56833 Mtetra
.68 .509 .648 r
.69194 .56833 .69307 .57301 .6938 .56893 .69265 .56378 Mtetra
.689 .512 .642 r
.69265 .56378 .6938 .56893 .69449 .56404 .69331 .55831 Mtetra
.692 .51 .637 r
.69331 .55831 .69449 .56404 .69514 .55846 .69394 .55208 Mtetra
.687 .505 .635 r
.69394 .55208 .69514 .55846 .69578 .55249 .69454 .5454 Mtetra
.675 .494 .633 r
.69454 .5454 .69578 .55249 .69642 .54653 .69515 .53874 Mtetra
.654 .478 .633 r
.69515 .53874 .69642 .54653 .69708 .54114 .69578 .53272 Mtetra
.619 .452 .634 r
.69578 .53272 .69708 .54114 .69779 .53691 .69647 .52801 Mtetra
.564 .412 .633 r
.69647 .52801 .69779 .53691 .69858 .53436 .69725 .52519 Mtetra
.477 .35 .628 r
.69725 .52519 .69858 .53436 .69946 .5338 .69812 .52461 Mtetra
.342 .255 .611 r
.69812 .52461 .69946 .5338 .70043 .53524 .69911 .52629 Mtetra
.146 .118 .566 r
.69911 .52629 .70043 .53524 .70149 .53841 .70018 .52991 Mtetra
0 0 .485 r
.70018 .52991 .70149 .53841 .7026 .5428 .70132 .53492 Mtetra
0 0 .388 r
.70132 .53492 .7026 .5428 .70375 .54782 .7025 .54064 Mtetra
0 0 .318 r
.7025 .54064 .70375 .54782 .7049 .55292 .70368 .54645 Mtetra
0 0 .303 r
.70368 .54645 .7049 .55292 .70604 .55766 .70485 .55185 Mtetra
0 0 .347 r
.70485 .55185 .70604 .55766 .70715 .56174 .70599 .55651 Mtetra
0 0 .437 r
.70599 .55651 .70715 .56174 .70823 .56502 .70708 .56027 Mtetra
0 .004 .541 r
.70708 .56027 .70823 .56502 .70926 .56744 .70813 .56306 Mtetra
.134 .16 .623 r
.70813 .56306 .70926 .56744 .71026 .56901 .70914 .56489 Mtetra
.315 .285 .666 r
.70914 .56489 .71026 .56901 .71122 .56977 .71011 .5658 Mtetra
.447 .373 .68 r
.71011 .5658 .71122 .56977 .71214 .56975 .71103 .56583 Mtetra
.536 .429 .68 r
.71103 .56583 .71214 .56975 .71303 .56895 .71191 .56498 Mtetra
.596 .465 .673 r
.71191 .56498 .71303 .56895 .71388 .56736 .71275 .56324 Mtetra
.636 .487 .664 r
.71275 .56324 .71388 .56736 .71468 .56496 .71355 .56058 Mtetra
.663 .501 .655 r
.71355 .56058 .71468 .56496 .71545 .5617 .7143 .55696 Mtetra
.679 .508 .647 r
.7143 .55696 .71545 .5617 .71617 .55759 .715 .55237 Mtetra
.688 .511 .641 r
.715 .55237 .71617 .55759 .71685 .55266 .71565 .54686 Mtetra
.691 .509 .637 r
.71565 .54686 .71685 .55266 .7175 .54706 .71626 .54059 Mtetra
.686 .503 .634 r
.71626 .54059 .7175 .54706 .71813 .54107 .71685 .53389 Mtetra
.674 .492 .633 r
.71685 .53389 .71813 .54107 .71875 .53512 .71744 .52723 Mtetra
.651 .475 .632 r
.71744 .52723 .71875 .53512 .71941 .52977 .71806 .52126 Mtetra
.615 .449 .633 r
.71806 .52126 .71941 .52977 .72012 .52562 .71875 .51663 Mtetra
.559 .408 .633 r
.71875 .51663 .72012 .52562 .72092 .52319 .71954 .51394 Mtetra
.47 .345 .628 r
.71954 .51394 .72092 .52319 .72183 .52276 .72044 .51351 Mtetra
.333 .249 .609 r
.72044 .51351 .72183 .52276 .72283 .52434 .72146 .51534 Mtetra
.138 .113 .565 r
.72146 .51534 .72283 .52434 .72393 .52764 .72258 .51911 Mtetra
0 0 .486 r
.72258 .51911 .72393 .52764 .72509 .53215 .72377 .52424 Mtetra
0 0 .394 r
.72377 .52424 .72509 .53215 .72629 .53726 .725 .53006 Mtetra
0 0 .33 r
.725 .53006 .72629 .53726 .72749 .54242 .72624 .53594 Mtetra
0 0 .318 r
.72624 .53594 .72749 .54242 .72868 .5472 .72746 .54138 Mtetra
0 0 .362 r
.72746 .54138 .72868 .5472 .72983 .55131 .72864 .54607 Mtetra
0 0 .449 r
.72864 .54607 .72983 .55131 .73094 .5546 .72977 .54984 Mtetra
0 .017 .549 r
.72977 .54984 .73094 .5546 .73201 .55704 .73086 .55263 Mtetra
.142 .167 .626 r
.73086 .55263 .73201 .55704 .73304 .55862 .7319 .55447 Mtetra
.319 .288 .667 r
.7319 .55447 .73304 .55862 .73402 .55938 .73289 .55538 Mtetra
.447 .373 .681 r
.73289 .55538 .73402 .55938 .73496 .55935 .73383 .5554 Mtetra
.536 .429 .68 r
.73383 .5554 .73496 .55935 .73587 .55854 .73473 .55454 Mtetra
.595 .464 .672 r
.73473 .55454 .73587 .55854 .73672 .55694 .73558 .55278 Mtetra
.635 .487 .663 r
.73558 .55278 .73672 .55694 .73754 .55452 .73638 .55009 Mtetra
.662 .5 .654 r
.73638 .55009 .73754 .55452 .73831 .55123 .73712 .54643 Mtetra
.679 .507 .647 r
.73712 .54643 .73831 .55123 .73903 .54709 .73782 .5418 Mtetra
.688 .509 .64 r
.73782 .5418 .73903 .54709 .7397 .54212 .73846 .53624 Mtetra
.69 .508 .636 r
.73846 .53624 .7397 .54212 .74034 .53648 .73906 .52993 Mtetra
.685 .502 .633 r
.73906 .52993 .74034 .53648 .74095 .53048 .73963 .5232 Mtetra
.672 .49 .632 r
.73963 .5232 .74095 .53048 .74157 .52454 .74021 .51655 Mtetra
.649 .473 .632 r
.74021 .51655 .74157 .52454 .74222 .51923 .74082 .51062 Mtetra
.612 .445 .633 r
.74082 .51062 .74222 .51923 .74293 .51517 .74151 .50609 Mtetra
.553 .404 .632 r
.74151 .50609 .74293 .51517 .74375 .51284 .74231 .50352 Mtetra
.463 .34 .627 r
.74231 .50352 .74375 .51284 .74468 .51255 .74324 .50324 Mtetra
.324 .243 .608 r
.74324 .50324 .74468 .51255 .74572 .51428 .7443 .50523 Mtetra
.131 .109 .563 r
.7443 .50523 .74572 .51428 .74686 .51771 .74546 .50915 Mtetra
0 0 .487 r
.74546 .50915 .74686 .51771 .74808 .52233 .74671 .5144 Mtetra
0 0 .4 r
.74671 .5144 .74808 .52233 .74933 .52754 .748 .52032 Mtetra
0 0 .341 r
.748 .52032 .74933 .52754 .75058 .53277 .74929 .52626 Mtetra
0 0 .332 r
.74929 .52626 .75058 .53277 .75181 .53759 .75056 .53175 Mtetra
0 0 .376 r
.75056 .53175 .75181 .53759 .75301 .54173 .75179 .53647 Mtetra
0 0 .461 r
.75179 .53647 .75301 .54173 .75416 .54504 .75296 .54026 Mtetra
0 .028 .556 r
.75296 .54026 .75416 .54504 .75526 .54749 .75409 .54307 Mtetra
.15 .173 .63 r
.75409 .54307 .75526 .54749 .75632 .54907 .75515 .54491 Mtetra
.322 .291 .668 r
.75515 .54491 .75632 .54907 .75733 .54984 .75617 .54582 Mtetra
.448 .374 .681 r
.75617 .54582 .75733 .54984 .75829 .54981 .75713 .54583 Mtetra
.536 .429 .68 r
.75713 .54583 .75829 .54981 .75921 .54899 .75805 .54495 Mtetra
.595 .464 .672 r
.75805 .54495 .75921 .54899 .76008 .54737 .75891 .54317 Mtetra
.635 .486 .663 r
.75891 .54317 .76008 .54737 .7609 .54492 .75971 .54045 Mtetra
.662 .499 .654 r
.75971 .54045 .7609 .54492 .76167 .54161 .76046 .53675 Mtetra
.678 .506 .646 r
.76046 .53675 .76167 .54161 .76238 .53742 .76114 .53207 Mtetra
.687 .508 .64 r
.76114 .53207 .76238 .53742 .76305 .53241 .76177 .52646 Mtetra
.689 .506 .635 r
.76177 .52646 .76305 .53241 .76367 .52674 .76236 .52011 Mtetra
.683 .5 .632 r
.76236 .52011 .76367 .52674 .76428 .52071 .76292 .51335 Mtetra
.67 .488 .631 r
.76292 .51335 .76428 .52071 .76488 .51478 .76348 .50671 Mtetra
.646 .47 .631 r
.76348 .50671 .76488 .51478 .76553 .50952 .76408 .50082 Mtetra
.608 .442 .632 r
.76408 .50082 .76553 .50952 .76625 .50554 .76478 .49637 Mtetra
.548 .4 .632 r
.76478 .49637 .76625 .50554 .76708 .50333 .76559 .49393 Mtetra
.455 .335 .626 r
.76559 .49393 .76708 .50333 .76804 .50318 .76655 .4938 Mtetra
.316 .238 .607 r
.76655 .4938 .76804 .50318 .76912 .50505 .76765 .49595 Mtetra
.123 .104 .563 r
.76765 .49595 .76912 .50505 .77031 .50862 .76887 .50002 Mtetra
0 0 .488 r
.76887 .50002 .77031 .50862 .77158 .51335 .77017 .5054 Mtetra
0 0 .406 r
.77017 .5054 .77158 .51335 .77288 .51865 .77151 .51141 Mtetra
0 0 .352 r
.77151 .51141 .77288 .51865 .77419 .52394 .77286 .51743 Mtetra
0 0 .346 r
.77286 .51743 .77419 .52394 .77547 .52881 .77419 .52296 Mtetra
0 0 .39 r
.77419 .52296 .77547 .52881 .77671 .53298 .77546 .52771 Mtetra
0 0 .472 r
.77546 .52771 .77671 .53298 .77791 .53631 .77668 .53152 Mtetra
0 .039 .563 r
.77668 .53152 .77791 .53631 .77904 .53877 .77784 .53433 Mtetra
.158 .18 .633 r
.77784 .53433 .77904 .53877 .78013 .54036 .77894 .53618 Mtetra
.325 .294 .67 r
.77894 .53618 .78013 .54036 .78116 .54113 .77998 .53708 Mtetra
.449 .375 .681 r
.77998 .53708 .78116 .54113 .78215 .54109 .78097 .53709 Mtetra
.536 .429 .68 r
.78097 .53709 .78215 .54109 .78308 .54027 .7819 .53619 Mtetra
.595 .464 .672 r
.7819 .53619 .78308 .54027 .78396 .53863 .78277 .53438 Mtetra
.635 .485 .662 r
.78277 .53438 .78396 .53863 .78479 .53615 .78358 .53163 Mtetra
.661 .498 .653 r
.78358 .53163 .78479 .53615 .78556 .5328 .78432 .52788 Mtetra
.678 .505 .645 r
.78432 .52788 .78556 .5328 .78628 .52857 .785 .52315 Mtetra
.686 .507 .639 r
.785 .52315 .78628 .52857 .78693 .52351 .78562 .51749 Mtetra
.688 .505 .634 r
.78562 .51749 .78693 .52351 .78755 .5178 .78619 .51108 Mtetra
.682 .498 .632 r
.78619 .51108 .78755 .5178 .78814 .51175 .78673 .5043 Mtetra
.668 .487 .63 r
.78673 .5043 .78814 .51175 .78873 .50582 .78728 .49765 Mtetra
.643 .468 .631 r
.78728 .49765 .78873 .50582 .78937 .5006 .78788 .49181 Mtetra
.604 .439 .632 r
.78788 .49181 .78937 .5006 .7901 .4967 .78857 .48745 Mtetra
.542 .396 .631 r
.78857 .48745 .7901 .4967 .79095 .4946 .78941 .48513 Mtetra
.448 .33 .626 r
.78941 .48513 .79095 .4946 .79194 .49459 .79039 .48515 Mtetra
.307 .232 .606 r
.79039 .48515 .79194 .49459 .79306 .4966 .79154 .48746 Mtetra
.116 .101 .562 r
.79154 .48746 .79306 .4966 .7943 .50031 .79281 .49167 Mtetra
0 0 .49 r
.79281 .49167 .7943 .50031 .79563 .50516 .79417 .49718 Mtetra
0 0 .413 r
.79417 .49718 .79563 .50516 .79699 .51054 .79558 .50329 Mtetra
0 0 .362 r
.79558 .50329 .79699 .51054 .79835 .51591 .79699 .50938 Mtetra
0 0 .359 r
.79699 .50938 .79835 .51591 .79968 .52082 .79837 .51496 Mtetra
0 0 .404 r
.79837 .51496 .79968 .52082 .80097 .52502 .79969 .51974 Mtetra
0 0 .483 r
.79969 .51974 .80097 .52502 .80221 .52837 .80096 .52356 Mtetra
0 .05 .57 r
.80096 .52356 .80221 .52837 .80338 .53083 .80216 .52638 Mtetra
.166 .186 .636 r
.80216 .52638 .80338 .53083 .8045 .53243 .80329 .52823 Mtetra
.329 .297 .671 r
.80329 .52823 .8045 .53243 .80556 .5332 .80436 .52913 Mtetra
.451 .376 .682 r
.80436 .52913 .80556 .5332 .80657 .53315 .80537 .52912 Mtetra
.536 .429 .68 r
.80537 .52912 .80657 .53315 .80752 .53231 .80631 .5282 Mtetra
.595 .463 .672 r
.80631 .5282 .80752 .53231 .80841 .53065 .80719 .52637 Mtetra
.635 .485 .662 r
.80719 .52637 .80841 .53065 .80925 .52814 .80801 .52357 Mtetra
.661 .498 .653 r
.80801 .52357 .80925 .52814 .81002 .52474 .80875 .51977 Mtetra
.678 .505 .644 r
.80875 .51977 .81002 .52474 .81073 .52046 .80942 .51498 Mtetra
.686 .506 .638 r
.80942 .51498 .81073 .52046 .81138 .51536 .81003 .50925 Mtetra
.687 .504 .633 r
.81003 .50925 .81138 .51536 .81198 .5096 .81058 .5028 Mtetra
.681 .497 .631 r
.81058 .5028 .81198 .5096 .81256 .50352 .8111 .49598 Mtetra
.666 .485 .63 r
.8111 .49598 .81256 .50352 .81314 .49759 .81164 .48933 Mtetra
.641 .465 .63 r
.81164 .48933 .81314 .49759 .81378 .49241 .81223 .48352 Mtetra
.6 .436 .631 r
.81223 .48352 .81378 .49241 .81451 .48858 .81293 .47924 Mtetra
.537 .392 .631 r
.81293 .47924 .81451 .48858 .81538 .4866 .81378 .47704 Mtetra
.441 .325 .625 r
.81378 .47704 .81538 .4866 .8164 .48672 .8148 .47722 Mtetra
.299 .227 .606 r
.8148 .47722 .8164 .48672 .81757 .48888 .81599 .47968 Mtetra
.11 .098 .562 r
.81599 .47968 .81757 .48888 .81887 .49272 .81732 .48405 Mtetra
0 0 .492 r
.81732 .48405 .81887 .49272 .82025 .49768 .81875 .48968 Mtetra
0 0 .419 r
.81875 .48968 .82025 .49768 .82167 .50316 .82022 .49589 Mtetra
0 0 .374 r
.82022 .49589 .82167 .50316 .82309 .50858 .82169 .50204 Mtetra
0 0 .372 r
.82169 .50204 .82309 .50858 .82448 .51354 .82313 .50767 Mtetra
0 0 .417 r
.82313 .50767 .82448 .51354 .82582 .51776 .82451 .51248 Mtetra
0 0 .494 r
.82451 .51248 .82582 .51776 .82709 .52113 .82582 .51631 Mtetra
0 .06 .577 r
.82582 .51631 .82709 .52113 .82831 .5236 .82706 .51914 Mtetra
.174 .193 .64 r
.82706 .51914 .82831 .5236 .82946 .5252 .82822 .52098 Mtetra
.333 .301 .672 r
.82822 .52098 .82946 .5252 .83055 .52596 .82932 .52187 Mtetra
.453 .378 .682 r
.82932 .52187 .83055 .52596 .83158 .52591 .83035 .52185 Mtetra
.537 .43 .68 r
.83035 .52185 .83158 .52591 .83254 .52504 .83131 .52091 Mtetra
.595 .464 .671 r
.83131 .52091 .83254 .52504 .83345 .52335 .8322 .51903 Mtetra
.635 .485 .662 r
.8322 .51903 .83345 .52335 .83429 .5208 .83302 .51619 Mtetra
.661 .497 .652 r
.83302 .51619 .83429 .5208 .83506 .51736 .83376 .51233 Mtetra
.678 .504 .644 r
.83376 .51233 .83506 .51736 .83577 .51302 .83443 .50747 Mtetra
.686 .506 .637 r
.83443 .50747 .83577 .51302 .83641 .50786 .83502 .50168 Mtetra
.687 .503 .633 r
.83502 .50168 .83641 .50786 .837 .50205 .83555 .49516 Mtetra
.68 .495 .63 r
.83555 .49516 .837 .50205 .83756 .49594 .83606 .4883 Mtetra
.665 .483 .629 r
.83606 .4883 .83756 .49594 .83814 .49 .83658 .48164 Mtetra
.638 .463 .63 r
.83658 .48164 .83814 .49 .83877 .48485 .83716 .47587 Mtetra
.596 .433 .631 r
.83716 .47587 .83877 .48485 .83951 .4811 .83787 .47167 Mtetra
.531 .388 .631 r
.83787 .47167 .83951 .4811 .8404 .47923 .83874 .4696 Mtetra
.434 .32 .625 r
.83874 .4696 .8404 .47923 .84146 .47948 .8398 .46991 Mtetra
.291 .223 .605 r
.8398 .46991 .84146 .47948 .84268 .48178 .84104 .47254 Mtetra
.105 .096 .562 r
.84104 .47254 .84268 .48178 .84403 .48575 .84243 .47705 Mtetra
0 0 .495 r
.84243 .47705 .84403 .48575 .84547 .49083 .84392 .48281 Mtetra
0 0 .427 r
.84392 .48281 .84547 .49083 .84695 .49639 .84546 .48911 Mtetra
0 0 .385 r
.84546 .48911 .84695 .49639 .84843 .50188 .847 .49533 Mtetra
0 0 .386 r
.847 .49533 .84843 .50188 .84988 .50688 .84849 .501 Mtetra
0 0 .431 r
.84849 .501 .84988 .50688 .85127 .51113 .84993 .50583 Mtetra
0 0 .505 r
.84993 .50583 .85127 .51113 .85259 .5145 .85128 .50968 Mtetra
0 .072 .584 r
.85128 .50968 .85259 .5145 .85384 .51698 .85256 .51251 Mtetra
.182 .2 .643 r
.85256 .51251 .85384 .51698 .85503 .51858 .85376 .51434 Mtetra
.338 .304 .674 r
.85376 .51434 .85503 .51858 .85614 .51933 .85489 .51522 Mtetra
.455 .38 .683 r
.85489 .51522 .85614 .51933 .85719 .51926 .85594 .51517 Mtetra
.538 .431 .68 r
.85594 .51517 .85719 .51926 .85818 .51837 .85692 .5142 Mtetra
.596 .464 .671 r
.85692 .5142 .85818 .51837 .8591 .51664 .85782 .51229 Mtetra
.635 .485 .661 r
.85782 .51229 .8591 .51664 .85995 .51405 .85865 .50939 Mtetra
.661 .497 .651 r
.85865 .50939 .85995 .51405 .86072 .51055 .85939 .50547 Mtetra
.678 .503 .643 r
.85939 .50547 .86072 .51055 .86142 .50615 .86004 .50054 Mtetra
.686 .505 .636 r
.86004 .50054 .86142 .50615 .86205 .50092 .86062 .49467 Mtetra
.686 .502 .632 r
.86062 .49467 .86205 .50092 .86262 .49506 .86113 .48808 Mtetra
.679 .494 .629 r
.86113 .48808 .86262 .49506 .86317 .48891 .86162 .48117 Mtetra
.663 .481 .628 r
.86162 .48117 .86317 .48891 .86374 .48296 .86212 .4745 Mtetra
.635 .461 .629 r
.86212 .4745 .86374 .48296 .86437 .47784 .8627 .46876 Mtetra
.592 .43 .63 r
.8627 .46876 .86437 .47784 .86512 .47415 .86341 .46464 Mtetra
.526 .384 .63 r
.86341 .46464 .86512 .47415 .86603 .47239 .86431 .46268 Mtetra
.427 .316 .624 r
.86431 .46268 .86603 .47239 .86713 .47278 .86541 .46315 Mtetra
.284 .218 .605 r
.86541 .46315 .86713 .47278 .86839 .47522 .8667 .46593 Mtetra
.101 .094 .562 r
.8667 .46593 .86839 .47522 .8698 .47932 .86815 .47058 Mtetra
0 0 .498 r
.86815 .47058 .8698 .47932 .87131 .48451 .86971 .47646 Mtetra
0 0 .434 r
.86971 .47646 .87131 .48451 .87286 .49016 .87132 .48286 Mtetra
0 0 .397 r
.87132 .48286 .87286 .49016 .8744 .4957 .87293 .48914 Mtetra
0 0 .4 r
.87293 .48914 .8744 .4957 .87591 .50074 .87449 .49485 Mtetra
0 0 .444 r
.87449 .49485 .87591 .50074 .87735 .50501 .87598 .4997 Mtetra
0 0 .516 r
.87598 .4997 .87735 .50501 .87872 .5084 .87738 .50356 Mtetra
.015 .083 .591 r
.87738 .50356 .87872 .5084 .88001 .51088 .8787 .50639 Mtetra
.191 .207 .647 r
.8787 .50639 .88001 .51088 .88123 .51247 .87994 .50821 Mtetra
.343 .308 .675 r
.87994 .50821 .88123 .51247 .88237 .5132 .8811 .50908 Mtetra
.458 .382 .684 r
.8811 .50908 .88237 .5132 .88345 .51311 .88217 .509 Mtetra
.54 .432 .68 r
.88217 .509 .88345 .51311 .88445 .51219 .88317 .50799 Mtetra
.597 .464 .671 r
.88317 .50799 .88445 .51219 .88538 .51043 .88408 .50603 Mtetra
.636 .485 .66 r
.88408 .50603 .88538 .51043 .88624 .50778 .88491 .50307 Mtetra
.662 .497 .65 r
.88491 .50307 .88624 .50778 .88701 .50422 .88564 .49908 Mtetra
.678 .503 .642 r
.88564 .49908 .88701 .50422 .8877 .49975 .88629 .49407 Mtetra
.685 .504 .635 r
.88629 .49407 .8877 .49975 .88832 .49446 .88685 .48812 Mtetra
.686 .501 .631 r
.88685 .48812 .88832 .49446 .88888 .48853 .88734 .48146 Mtetra
.678 .493 .628 r
.88734 .48146 .88888 .48853 .88942 .48233 .88781 .47449 Mtetra
.661 .479 .628 r
.88781 .47449 .88942 .48233 .88997 .47637 .8883 .46781 Mtetra
.633 .458 .629 r
.8883 .46781 .88997 .47637 .8906 .47127 .88887 .46209 Mtetra
.588 .427 .63 r
.88887 .46209 .8906 .47127 .89136 .46766 .88959 .45804 Mtetra
.521 .38 .63 r
.88959 .45804 .89136 .46766 .8923 .466 .89051 .45621 Mtetra
.42 .311 .624 r
.89051 .45621 .8923 .466 .89343 .46652 .89165 .45682 Mtetra
.278 .215 .604 r
.89165 .45682 .89343 .46652 .89475 .4691 .893 .45975 Mtetra
.098 .093 .563 r
.893 .45975 .89475 .4691 .89623 .47333 .89452 .46455 Mtetra
0 0 .502 r
.89452 .46455 .89623 .47333 .8978 .47863 .89615 .47055 Mtetra
0 0 .442 r
.89615 .47055 .8978 .47863 .89941 .48435 .89783 .47703 Mtetra
0 0 .409 r
.89783 .47703 .89941 .48435 .90102 .48996 .89951 .48338 Mtetra
0 0 .414 r
.89951 .48338 .90102 .48996 .90259 .49503 .90113 .48913 Mtetra
0 0 .458 r
.90113 .48913 .90259 .49503 .90408 .49932 .90268 .494 Mtetra
0 0 .526 r
.90268 .494 .90408 .49932 .9055 .50271 .90414 .49786 Mtetra
.029 .095 .598 r
.90414 .49786 .9055 .50271 .90683 .50519 .9055 .50068 Mtetra
.201 .214 .65 r
.9055 .50068 .90683 .50519 .90809 .50677 .90677 .5025 Mtetra
.348 .313 .677 r
.90677 .5025 .90809 .50677 .90926 .50749 .90796 .50334 Mtetra
.461 .384 .684 r
.90796 .50334 .90926 .50749 .91036 .50737 .90906 .50323 Mtetra
.541 .433 .68 r
.90906 .50323 .91036 .50737 .91139 .50641 .91007 .50218 Mtetra
.598 .465 .671 r
.91007 .50218 .91139 .50641 .91233 .5046 .911 .50016 Mtetra
.637 .485 .66 r
.911 .50016 .91233 .5046 .91319 .5019 .91182 .49714 Mtetra
.662 .497 .65 r
.91182 .49714 .91319 .5019 .91396 .49828 .91255 .49307 Mtetra
.678 .502 .641 r
.91255 .49307 .91396 .49828 .91464 .49373 .91319 .48797 Mtetra
.685 .503 .634 r
.91319 .48797 .91464 .49373 .91525 .48836 .91373 .48193 Mtetra
.685 .499 .63 r
.91373 .48193 .91525 .48836 .91579 .48236 .9142 .4752 Mtetra
.677 .491 .627 r
.9142 .4752 .91579 .48236 .91631 .47611 .91465 .46817 Mtetra
.659 .477 .627 r
.91465 .46817 .91631 .47611 .91686 .47013 .91512 .46146 Mtetra
.63 .456 .628 r
.91512 .46146 .91686 .47013 .91748 .46506 .91569 .45577 Mtetra
.585 .424 .63 r
.91569 .45577 .91748 .46506 .91826 .46151 .91642 .4518 Mtetra
.516 .376 .63 r
.91642 .4518 .91826 .46151 .91922 .45996 .91736 .45008 Mtetra
.414 .307 .624 r
.91736 .45008 .91922 .45996 .9204 .46061 .91855 .45083 Mtetra
.272 .211 .604 r
.91855 .45083 .9204 .46061 .92177 .46332 .91996 .45392 Mtetra
.095 .093 .564 r
.91996 .45392 .92177 .46332 .92331 .46768 .92155 .45886 Mtetra
0 0 .506 r
.92155 .45886 .92331 .46768 .92496 .47308 .92326 .46497 Mtetra
0 0 .451 r
.92326 .46497 .92496 .47308 .92664 .47889 .92502 .47155 Mtetra
0 0 .421 r
.92502 .47155 .92664 .47889 .92832 .48455 .92676 .47796 Mtetra
0 0 .428 r
.92676 .47796 .92832 .48455 .92995 .48965 .92845 .48374 Mtetra
0 0 .471 r
.92845 .48374 .92995 .48965 .9315 .49396 .93006 .48863 Mtetra
0 0 .537 r
.93006 .48863 .9315 .49396 .93296 .49736 .93157 .49249 Mtetra
.045 .107 .604 r
.93157 .49249 .93296 .49736 .93434 .49983 .93298 .49531 Mtetra
.211 .222 .653 r
.93298 .49531 .93434 .49983 .93563 .50139 .93429 .4971 Mtetra
.354 .317 .678 r
.93429 .4971 .93563 .50139 .93684 .50209 .93551 .49792 Mtetra
.464 .387 .685 r
.93551 .49792 .93684 .50209 .93796 .50194 .93663 .49778 Mtetra
.543 .434 .68 r
.93663 .49778 .93796 .50194 .939 .50095 .93766 .49668 Mtetra
.599 .465 .67 r
.93766 .49668 .939 .50095 .93996 .49909 .93859 .49461 Mtetra
.637 .485 .659 r
.93859 .49461 .93996 .49909 .94082 .49633 .93942 .49151 Mtetra
.663 .496 .649 r
.93942 .49151 .94082 .49633 .94159 .49263 .94015 .48736 Mtetra
.678 .502 .64 r
.94015 .48736 .94159 .49263 .94227 .488 .94076 .48217 Mtetra
.685 .502 .633 r
.94076 .48217 .94227 .488 .94286 .48255 .94129 .47603 Mtetra
.685 .498 .629 r
.94129 .47603 .94286 .48255 .94338 .47647 .94174 .46921 Mtetra
.676 .49 .626 r
.94174 .46921 .94338 .47647 .94389 .47017 .94216 .46213 Mtetra
.658 .475 .626 r
.94216 .46213 .94389 .47017 .94442 .46417 .94262 .45539 Mtetra
.628 .453 .627 r
.94262 .45539 .94442 .46417 .94504 .45912 .94318 .44972 Mtetra
.581 .421 .629 r
.94318 .44972 .94504 .45912 .94583 .45563 .94392 .44582 Mtetra
.51 .373 .629 r
.94392 .44582 .94583 .45563 .94682 .45419 .94489 .44422 Mtetra
.408 .303 .623 r
.94489 .44422 .94682 .45419 .94804 .45496 .94612 .44511 Mtetra
.266 .208 .604 r
.94612 .44511 .94804 .45496 .94948 .45781 .9476 .44835 Mtetra
.094 .093 .565 r
.9476 .44835 .94948 .45781 .95109 .4623 .94926 .45343 Mtetra
0 0 .51 r
.94926 .45343 .95109 .4623 .9528 .46781 .95105 .45966 Mtetra
0 0 .46 r
.95105 .45966 .9528 .46781 .95457 .47369 .95289 .46633 Mtetra
0 0 .433 r
.95289 .46633 .95457 .47369 .95631 .4794 .95471 .47279 Mtetra
0 0 .442 r
.95471 .47279 .95631 .4794 .958 .48454 .95647 .47861 Mtetra
0 0 .484 r
.95647 .47861 .958 .48454 .95961 .48886 .95814 .48351 Mtetra
0 .005 .547 r
.95814 .48351 .95961 .48886 .96113 .49225 .9597 .48737 Mtetra
.06 .119 .611 r
.9597 .48737 .96113 .49225 .96255 .49472 .96116 .49018 Mtetra
.221 .23 .657 r
.96116 .49018 .96255 .49472 .96388 .49627 .96251 .49195 Mtetra
.36 .322 .68 r
.96251 .49195 .96388 .49627 .96511 .49694 .96376 .49274 Mtetra
.467 .389 .685 r
.96376 .49274 .96511 .49694 .96626 .49676 .9649 .49256 Mtetra
.545 .435 .68 r
.9649 .49256 .96626 .49676 .96732 .49572 .96595 .49141 Mtetra
.6 .466 .67 r
.96595 .49141 .96732 .49572 .96829 .4938 .96689 .48927 Mtetra
.638 .485 .658 r
.96689 .48927 .96829 .4938 .96916 .49097 .96772 .4861 Mtetra
.664 .496 .648 r
.96772 .4861 .96916 .49097 .96992 .4872 .96844 .48186 Mtetra
.679 .501 .639 r
.96844 .48186 .96992 .4872 .97059 .48249 .96904 .47657 Mtetra
.685 .501 .632 r
.96904 .47657 .97059 .48249 .97117 .47694 .96955 .47034 Mtetra
.684 .497 .628 r
.96955 .47034 .97117 .47694 .97168 .47079 .96997 .46342 Mtetra
.675 .488 .625 r
.96997 .46342 .97168 .47079 .97216 .46443 .97037 .45627 Mtetra
.656 .473 .625 r
.97037 .45627 .97216 .46443 .97268 .4584 .97081 .44951 Mtetra
.625 .451 .627 r
.97081 .44951 .97268 .4584 .9733 .45337 .97137 .44386 Mtetra
.577 .418 .629 r
.97137 .44386 .9733 .45337 .9741 .44995 .97212 .44003 Mtetra
.505 .369 .629 r
.97212 .44003 .9741 .44995 .97513 .44861 .97312 .43854 Mtetra
.408 .299 .618 r
.51367 .64065 .51463 .64952 .5154 .65002 .51444 .64127 Mtetra
.178 .132 .564 r
.51444 .64127 .5154 .65002 .51617 .65254 .51521 .64415 Mtetra
0 0 .429 r
.51521 .64415 .51617 .65254 .51696 .65665 .516 .6488 Mtetra
0 0 .229 r
.516 .6488 .51696 .65665 .51775 .66172 .51679 .65453 Mtetra
.724 .513 0 r
.51679 .65453 .51775 .66172 .51855 .66713 .51759 .66065 Mtetra
.794 .557 0 r
.51759 .66065 .51855 .66713 .51935 .67234 .5184 .66653 Mtetra
.784 .541 0 r
.5184 .66653 .51935 .67234 .52015 .67697 .5192 .67177 Mtetra
0 0 .132 r
.5192 .67177 .52015 .67697 .52094 .68078 .51999 .6761 Mtetra
0 0 .317 r
.51999 .6761 .52094 .68078 .52173 .68368 .52078 .67942 Mtetra
0 0 .515 r
.52078 .67942 .52173 .68368 .52252 .68567 .52157 .6817 Mtetra
.186 .194 .634 r
.52157 .6817 .52252 .68567 .5233 .68675 .52235 .68298 Mtetra
.399 .34 .675 r
.52235 .68298 .5233 .68675 .52408 .68698 .52313 .6833 Mtetra
.524 .422 .681 r
.52313 .6833 .52408 .68698 .52485 .68637 .5239 .68269 Mtetra
.599 .469 .675 r
.5239 .68269 .52485 .68637 .52561 .68492 .52466 .68114 Mtetra
.644 .496 .667 r
.52466 .68114 .52561 .68492 .52637 .6826 .52542 .67862 Mtetra
.673 .512 .659 r
.52542 .67862 .52637 .6826 .52712 .67939 .52617 .67509 Mtetra
.691 .521 .652 r
.52617 .67509 .52712 .67939 .52787 .67525 .52691 .67054 Mtetra
.701 .525 .646 r
.52691 .67054 .52787 .67525 .5286 .67021 .52764 .66496 Mtetra
.705 .525 .642 r
.52764 .66496 .5286 .67021 .52933 .66435 .52836 .65848 Mtetra
.703 .521 .639 r
.52836 .65848 .52933 .66435 .53005 .65791 .52908 .65136 Mtetra
.695 .513 .637 r
.52908 .65136 .53005 .65791 .53077 .6513 .52979 .64404 Mtetra
.679 .5 .636 r
.52979 .64404 .53077 .6513 .53149 .64505 .5305 .63713 Mtetra
.652 .479 .637 r
.5305 .63713 .53149 .64505 .53222 .6398 .53123 .63134 Mtetra
.607 .445 .636 r
.53123 .63134 .53222 .6398 .53296 .63616 .53196 .62735 Mtetra
.532 .389 .633 r
.53196 .62735 .53296 .63616 .53372 .63458 .53272 .62565 Mtetra
.4 .293 .617 r
.53272 .62565 .53372 .63458 .5345 .63519 .5335 .62639 Mtetra
.169 .126 .563 r
.5335 .62639 .5345 .63519 .5353 .63782 .5343 .62939 Mtetra
0 0 .431 r
.5343 .62939 .5353 .63782 .53612 .642 .53512 .63414 Mtetra
0 0 .24 r
.53512 .63414 .53612 .642 .53695 .64714 .53596 .63993 Mtetra
.705 .497 0 r
.53596 .63993 .53695 .64714 .53778 .65258 .5368 .64608 Mtetra
.773 .539 0 r
.5368 .64608 .53778 .65258 .53862 .65779 .53764 .65197 Mtetra
.758 .519 0 r
.53764 .65197 .53862 .65779 .53945 .66241 .53847 .65719 Mtetra
0 0 .165 r
.53847 .65719 .53945 .66241 .54027 .6662 .5393 .6615 Mtetra
0 0 .346 r
.5393 .6615 .54027 .6662 .54109 .66907 .54012 .66478 Mtetra
0 0 .531 r
.54012 .66478 .54109 .66907 .5419 .67102 .54093 .66703 Mtetra
.205 .207 .639 r
.54093 .66703 .5419 .67102 .5427 .67207 .54173 .66827 Mtetra
.407 .345 .676 r
.54173 .66827 .5427 .67207 .54349 .67226 .54253 .66855 Mtetra
.527 .424 .681 r
.54253 .66855 .54349 .67226 .54427 .67161 .54331 .66789 Mtetra
.6 .469 .675 r
.54331 .66789 .54427 .67161 .54504 .67012 .54408 .66629 Mtetra
.645 .496 .666 r
.54408 .66629 .54504 .67012 .54581 .66776 .54484 .66372 Mtetra
.673 .511 .658 r
.54484 .66372 .54581 .66776 .54656 .66449 .54558 .66013 Mtetra
.691 .52 .651 r
.54558 .66013 .54656 .66449 .5473 .66029 .54632 .65551 Mtetra
.701 .524 .645 r
.54632 .65551 .5473 .66029 .54802 .65518 .54704 .64986 Mtetra
.705 .523 .641 r
.54704 .64986 .54802 .65518 .54874 .64927 .54775 .64332 Mtetra
.702 .52 .638 r
.54775 .64332 .54874 .64927 .54945 .64279 .54845 .63616 Mtetra
.694 .511 .636 r
.54845 .63616 .54945 .64279 .55015 .63616 .54914 .62881 Mtetra
.677 .498 .636 r
.54914 .62881 .55015 .63616 .55086 .62992 .54984 .62192 Mtetra
.649 .476 .636 r
.54984 .62192 .55086 .62992 .55158 .62472 .55056 .61619 Mtetra
.603 .442 .636 r
.55056 .61619 .55158 .62472 .55232 .62117 .55129 .61229 Mtetra
.526 .385 .632 r
.55129 .61229 .55232 .62117 .55309 .61969 .55206 .61071 Mtetra
.391 .287 .615 r
.55206 .61071 .55309 .61969 .55389 .62042 .55286 .61158 Mtetra
.16 .121 .561 r
.55286 .61158 .55389 .62042 .55472 .62316 .55369 .61471 Mtetra
0 0 .432 r
.55369 .61471 .55472 .62316 .55557 .62744 .55455 .61955 Mtetra
0 0 .251 r
.55455 .61955 .55557 .62744 .55644 .63263 .55542 .62541 Mtetra
0 0 .112 r
.55542 .62541 .55644 .63263 .55731 .6381 .5563 .63159 Mtetra
.751 .521 0 r
.5563 .63159 .55731 .6381 .55818 .64332 .55718 .63749 Mtetra
.731 .497 0 r
.55718 .63749 .55818 .64332 .55905 .64793 .55805 .6427 Mtetra
0 0 .197 r
.55805 .6427 .55905 .64793 .5599 .6517 .55891 .64698 Mtetra
0 0 .373 r
.55891 .64698 .5599 .6517 .56075 .65455 .55976 .65023 Mtetra
0 .014 .545 r
.55976 .65023 .56075 .65455 .56158 .65647 .5606 .65245 Mtetra
.222 .218 .643 r
.5606 .65245 .56158 .65647 .5624 .65749 .56142 .65366 Mtetra
.414 .349 .676 r
.56142 .65366 .5624 .65749 .5632 .65764 .56222 .6539 Mtetra
.53 .426 .68 r
.56222 .6539 .5632 .65764 .564 .65696 .56301 .6532 Mtetra
.601 .47 .674 r
.56301 .6532 .564 .65696 .56478 .65542 .56379 .65155 Mtetra
.645 .496 .666 r
.56379 .65155 .56478 .65542 .56554 .65301 .56456 .64892 Mtetra
.673 .511 .657 r
.56456 .64892 .56554 .65301 .56629 .64969 .5653 .64528 Mtetra
.691 .519 .65 r
.5653 .64528 .56629 .64969 .56703 .64544 .56603 .64059 Mtetra
.7 .523 .644 r
.56603 .64059 .56703 .64544 .56775 .64027 .56674 .63488 Mtetra
.704 .522 .64 r
.56674 .63488 .56775 .64027 .56845 .6343 .56743 .62828 Mtetra
.702 .518 .637 r
.56743 .62828 .56845 .6343 .56915 .62779 .56812 .62106 Mtetra
.693 .51 .636 r
.56812 .62106 .56915 .62779 .56984 .62114 .5688 .6137 Mtetra
.676 .496 .635 r
.5688 .6137 .56984 .62114 .57053 .61492 .56948 .60683 Mtetra
.647 .474 .635 r
.56948 .60683 .57053 .61492 .57125 .60978 .57018 .60115 Mtetra
.599 .438 .635 r
.57018 .60115 .57125 .60978 .57199 .60631 .57092 .59736 Mtetra
.52 .38 .631 r
.57092 .59736 .57199 .60631 .57277 .60495 .5717 .5959 Mtetra
.383 .281 .614 r
.5717 .5959 .57277 .60495 .57359 .6058 .57252 .59691 Mtetra
.152 .115 .559 r
.57252 .59691 .57359 .6058 .57445 .60865 .57338 .60016 Mtetra
0 0 .434 r
.57338 .60016 .57445 .60865 .57533 .61302 .57427 .6051 Mtetra
0 0 .262 r
.57427 .6051 .57533 .61302 .57624 .61827 .57519 .61103 Mtetra
0 0 .132 r
.57519 .61103 .57624 .61827 .57715 .62378 .57611 .61724 Mtetra
.728 .501 0 r
.57611 .61724 .57715 .62378 .57806 .62901 .57703 .62316 Mtetra
.704 .474 0 r
.57703 .62316 .57806 .62901 .57896 .63361 .57794 .62836 Mtetra
0 0 .227 r
.57794 .62836 .57896 .63361 .57985 .63736 .57884 .63262 Mtetra
0 0 .398 r
.57884 .63262 .57985 .63736 .58072 .64019 .57971 .63585 Mtetra
0 .035 .558 r
.57971 .63585 .58072 .64019 .58157 .64208 .58057 .63803 Mtetra
.236 .228 .647 r
.58057 .63803 .58157 .64208 .58241 .64307 .58141 .63921 Mtetra
.42 .353 .677 r
.58141 .63921 .58241 .64307 .58323 .6432 .58223 .63941 Mtetra
.532 .427 .68 r
.58223 .63941 .58323 .6432 .58404 .64248 .58304 .63867 Mtetra
.602 .47 .673 r
.58304 .63867 .58404 .64248 .58482 .6409 .58382 .63698 Mtetra
.645 .495 .665 r
.58382 .63698 .58482 .6409 .58559 .63845 .58459 .6343 Mtetra
.673 .51 .656 r
.58459 .6343 .58559 .63845 .58635 .63508 .58533 .6306 Mtetra
.69 .518 .649 r
.58533 .6306 .58635 .63508 .58708 .63077 .58605 .62585 Mtetra
.7 .522 .643 r
.58605 .62585 .58708 .63077 .58779 .62555 .58675 .62008 Mtetra
.703 .521 .639 r
.58675 .62008 .58779 .62555 .58848 .61953 .58743 .61342 Mtetra
.701 .517 .636 r
.58743 .61342 .58848 .61953 .58916 .61298 .5881 .60616 Mtetra
.691 .508 .635 r
.5881 .60616 .58916 .61298 .58984 .60632 .58876 .59879 Mtetra
.674 .494 .634 r
.58876 .59879 .58984 .60632 .59052 .60012 .58943 .59194 Mtetra
.644 .471 .635 r
.58943 .59194 .59052 .60012 .59123 .59504 .59012 .58633 Mtetra
.595 .435 .635 r
.59012 .58633 .59123 .59504 .59197 .59167 .59086 .58264 Mtetra
.513 .375 .631 r
.59086 .58264 .59197 .59167 .59276 .59042 .59165 .58131 Mtetra
.374 .275 .613 r
.59165 .58131 .59276 .59042 .5936 .5914 .59249 .58246 Mtetra
.143 .11 .558 r
.59249 .58246 .5936 .5914 .59449 .59436 .59339 .58583 Mtetra
0 0 .435 r
.59339 .58583 .59449 .59436 .59542 .59882 .59432 .59088 Mtetra
0 0 .273 r
.59432 .59088 .59542 .59882 .59636 .60414 .59528 .59688 Mtetra
0 0 .151 r
.59528 .59688 .59636 .60414 .59731 .60969 .59625 .60314 Mtetra
.705 .482 0 r
.59625 .60314 .59731 .60969 .59826 .61494 .59721 .60907 Mtetra
0 0 .144 r
.59721 .60907 .59826 .61494 .5992 .61953 .59816 .61427 Mtetra
0 0 .255 r
.59816 .61427 .5992 .61953 .60012 .62327 .59909 .61851 Mtetra
0 0 .42 r
.59909 .61851 .60012 .62327 .60102 .62608 .59999 .62171 Mtetra
0 .053 .568 r
.59999 .62171 .60102 .62608 .6019 .62795 .60088 .62387 Mtetra
.249 .237 .65 r
.60088 .62387 .6019 .62795 .60275 .62892 .60174 .62502 Mtetra
.425 .357 .677 r
.60174 .62502 .60275 .62892 .60359 .62902 .60257 .6252 Mtetra
.534 .428 .679 r
.60257 .6252 .60359 .62902 .60441 .62827 .60339 .62442 Mtetra
.602 .469 .673 r
.60339 .62442 .60441 .62827 .6052 .62666 .60418 .62268 Mtetra
.645 .494 .664 r
.60418 .62268 .6052 .62666 .60598 .62416 .60495 .61996 Mtetra
.673 .509 .656 r
.60495 .61996 .60598 .62416 .60673 .62075 .60569 .6162 Mtetra
.69 .517 .648 r
.60569 .6162 .60673 .62075 .60745 .61638 .60641 .61139 Mtetra
.7 .521 .643 r
.60641 .61139 .60745 .61638 .60815 .61111 .60709 .60556 Mtetra
.703 .52 .638 r
.60709 .60556 .60815 .61111 .60883 .60504 .60776 .59884 Mtetra
.7 .516 .635 r
.60776 .59884 .60883 .60504 .6095 .59846 .6084 .59155 Mtetra
.69 .507 .634 r
.6084 .59155 .6095 .59846 .61016 .59179 .60905 .58417 Mtetra
.672 .492 .634 r
.60905 .58417 .61016 .59179 .61083 .58562 .6097 .57734 Mtetra
.641 .468 .634 r
.6097 .57734 .61083 .58562 .61154 .5806 .61039 .57181 Mtetra
.59 .431 .634 r
.61039 .57181 .61154 .5806 .61228 .57733 .61113 .56822 Mtetra
.506 .37 .63 r
.61113 .56822 .61228 .57733 .61309 .57621 .61193 .56703 Mtetra
.365 .269 .612 r
.61193 .56703 .61309 .57621 .61395 .57731 .6128 .56833 Mtetra
.135 .105 .556 r
.6128 .56833 .61395 .57731 .61487 .5804 .61373 .57183 Mtetra
0 0 .437 r
.61373 .57183 .61487 .5804 .61584 .58496 .6147 .57698 Mtetra
0 0 .283 r
.6147 .57698 .61584 .58496 .61682 .59035 .61571 .58306 Mtetra
0 0 .169 r
.61571 .58306 .61682 .59035 .61782 .59594 .61672 .58937 Mtetra
0 0 .131 r
.61672 .58937 .61782 .59594 .61881 .60121 .61773 .59531 Mtetra
0 0 .17 r
.61773 .59531 .61881 .60121 .61978 .6058 .61872 .60051 Mtetra
0 0 .282 r
.61872 .60051 .61978 .6058 .62073 .60954 .61968 .60475 Mtetra
0 0 .439 r
.61968 .60475 .62073 .60954 .62166 .61233 .62062 .60793 Mtetra
.011 .07 .578 r
.62062 .60793 .62166 .61233 .62256 .61418 .62152 .61007 Mtetra
.26 .245 .652 r
.62152 .61007 .62256 .61418 .62344 .61513 .62241 .6112 Mtetra
.43 .36 .677 r
.62241 .6112 .62344 .61513 .62429 .61521 .62326 .61134 Mtetra
.536 .428 .679 r
.62326 .61134 .62429 .61521 .62512 .61443 .62409 .61054 Mtetra
.602 .469 .672 r
.62409 .61054 .62512 .61443 .62593 .61279 .62489 .60876 Mtetra
.645 .494 .663 r
.62489 .60876 .62593 .61279 .6267 .61026 .62566 .60599 Mtetra
.672 .508 .655 r
.62566 .60599 .6267 .61026 .62745 .60679 .6264 .60218 Mtetra
.69 .516 .648 r
.6264 .60218 .62745 .60679 .62818 .60238 .6271 .59731 Mtetra
.699 .52 .642 r
.6271 .59731 .62818 .60238 .62887 .59705 .62778 .59142 Mtetra
.702 .519 .637 r
.62778 .59142 .62887 .59705 .62954 .59094 .62843 .58466 Mtetra
.699 .514 .635 r
.62843 .58466 .62954 .59094 .63019 .58433 .62906 .57733 Mtetra
.688 .505 .633 r
.62906 .57733 .63019 .58433 .63083 .57766 .62968 .56994 Mtetra
.669 .49 .633 r
.62968 .56994 .63083 .57766 .6315 .57152 .63032 .56315 Mtetra
.637 .466 .634 r
.63032 .56315 .6315 .57152 .63219 .56657 .631 .55769 Mtetra
.585 .427 .634 r
.631 .55769 .63219 .56657 .63294 .56341 .63175 .55422 Mtetra
.5 .365 .629 r
.63175 .55422 .63294 .56341 .63376 .56241 .63256 .55317 Mtetra
.356 .263 .61 r
.63256 .55317 .63376 .56241 .63466 .56365 .63346 .55461 Mtetra
.126 .099 .554 r
.63346 .55461 .63466 .56365 .63561 .56687 .63442 .55826 Mtetra
0 0 .439 r
.63442 .55826 .63561 .56687 .63661 .57153 .63544 .56352 Mtetra
0 0 .293 r
.63544 .56352 .63661 .57153 .63765 .57699 .6365 .56968 Mtetra
0 0 .187 r
.6365 .56968 .63765 .57699 .63869 .58263 .63756 .57604 Mtetra
0 0 .154 r
.63756 .57604 .63869 .58263 .63972 .58792 .63861 .58201 Mtetra
0 0 .196 r
.63861 .58201 .63972 .58792 .64073 .59253 .63964 .58722 Mtetra
0 0 .306 r
.63964 .58722 .64073 .59253 .64171 .59626 .64064 .59145 Mtetra
0 0 .457 r
.64064 .59145 .64171 .59626 .64267 .59904 .6416 .59462 Mtetra
.031 .085 .586 r
.6416 .59462 .64267 .59904 .6436 .60089 .64254 .59674 Mtetra
.27 .252 .654 r
.64254 .59674 .6436 .60089 .6445 .60182 .64344 .59785 Mtetra
.433 .362 .677 r
.64344 .59785 .6445 .60182 .64537 .60188 .64431 .59797 Mtetra
.537 .428 .678 r
.64431 .59797 .64537 .60188 .64621 .60108 .64515 .59713 Mtetra
.602 .469 .671 r
.64515 .59713 .64621 .60108 .64702 .59941 .64596 .59533 Mtetra
.645 .493 .663 r
.64596 .59533 .64702 .59941 .6478 .59684 .64673 .59252 Mtetra
.672 .507 .654 r
.64673 .59252 .6478 .59684 .64855 .59333 .64747 .58866 Mtetra
.689 .515 .647 r
.64747 .58866 .64855 .59333 .64927 .58888 .64817 .58373 Mtetra
.698 .518 .641 r
.64817 .58373 .64927 .58888 .64995 .5835 .64883 .57779 Mtetra
.701 .517 .637 r
.64883 .57779 .64995 .5835 .6506 .57735 .64946 .57097 Mtetra
.698 .513 .634 r
.64946 .57097 .6506 .57735 .65124 .57071 .65007 .56361 Mtetra
.687 .503 .633 r
.65007 .56361 .65124 .57071 .65187 .56403 .65068 .55622 Mtetra
.667 .487 .633 r
.65068 .55622 .65187 .56403 .65252 .55793 .65131 .54947 Mtetra
.634 .463 .633 r
.65131 .54947 .65252 .55793 .65322 .55306 .65198 .54409 Mtetra
.58 .423 .633 r
.65198 .54409 .65322 .55306 .65398 .55001 .65273 .54074 Mtetra
.492 .36 .629 r
.65273 .54074 .65398 .55001 .65481 .54914 .65356 .53984 Mtetra
.346 .256 .609 r
.65356 .53984 .65481 .54914 .65573 .55053 .65449 .54143 Mtetra
.117 .094 .553 r
.65449 .54143 .65573 .55053 .65672 .55387 .6555 .54522 Mtetra
0 0 .441 r
.6555 .54522 .65672 .55387 .65777 .55864 .65656 .55061 Mtetra
0 0 .302 r
.65656 .55061 .65777 .55864 .65885 .56419 .65766 .55686 Mtetra
0 0 .204 r
.65766 .55686 .65885 .56419 .65993 .56988 .65877 .56326 Mtetra
0 0 .175 r
.65877 .56326 .65993 .56988 .66101 .5752 .65987 .56927 Mtetra
0 0 .219 r
.65987 .56927 .66101 .5752 .66206 .57982 .66094 .57449 Mtetra
0 0 .328 r
.66094 .57449 .66206 .57982 .66308 .58355 .66198 .57872 Mtetra
0 0 .472 r
.66198 .57872 .66308 .58355 .66407 .58633 .66298 .58188 Mtetra
.048 .098 .592 r
.66298 .58188 .66407 .58633 .66502 .58817 .66394 .58399 Mtetra
.278 .258 .656 r
.66394 .58399 .66502 .58817 .66594 .58909 .66487 .58508 Mtetra
.436 .364 .677 r
.66487 .58508 .66594 .58909 .66683 .58914 .66576 .58519 Mtetra
.537 .429 .678 r
.66576 .58519 .66683 .58914 .66768 .58832 .66661 .58433 Mtetra
.602 .468 .671 r
.66661 .58433 .66768 .58832 .6685 .58662 .66742 .58249 Mtetra
.644 .492 .662 r
.66742 .58249 .6685 .58662 .66929 .58402 .6682 .57964 Mtetra
.671 .506 .653 r
.6682 .57964 .66929 .58402 .67004 .58048 .66893 .57574 Mtetra
.688 .514 .646 r
.66893 .57574 .67004 .58048 .67075 .57597 .66962 .57076 Mtetra
.698 .517 .64 r
.66962 .57076 .67075 .57597 .67142 .57055 .67027 .56476 Mtetra
.7 .516 .636 r
.67027 .56476 .67142 .57055 .67206 .56436 .67089 .5579 Mtetra
.696 .511 .633 r
.67089 .5579 .67206 .56436 .67268 .5577 .67148 .55051 Mtetra
.685 .501 .632 r
.67148 .55051 .67268 .5577 .6733 .55103 .67207 .54312 Mtetra
.665 .485 .632 r
.67207 .54312 .6733 .55103 .67394 .54497 .67268 .53641 Mtetra
.63 .459 .633 r
.67268 .53641 .67394 .54497 .67463 .54017 .67336 .53111 Mtetra
.575 .419 .633 r
.67336 .53111 .67463 .54017 .6754 .53724 .67411 .52789 Mtetra
.485 .355 .628 r
.67411 .52789 .6754 .53724 .67626 .53651 .67496 .52714 Mtetra
.337 .25 .608 r
.67496 .52714 .67626 .53651 .67721 .53804 .67592 .5289 Mtetra
.109 .089 .551 r
.67592 .5289 .67721 .53804 .67824 .54152 .67697 .53284 Mtetra
0 0 .442 r
.67697 .53284 .67824 .54152 .67933 .54641 .67808 .53834 Mtetra
0 0 .311 r
.67808 .53834 .67933 .54641 .68046 .55204 .67923 .54468 Mtetra
0 0 .22 r
.67923 .54468 .68046 .55204 .68159 .55779 .6804 .55116 Mtetra
0 0 .196 r
.6804 .55116 .68159 .55779 .68271 .56315 .68154 .5572 Mtetra
0 0 .241 r
.68154 .5572 .68271 .56315 .6838 .56778 .68266 .56243 Mtetra
0 0 .349 r
.68266 .56243 .6838 .56778 .68486 .57153 .68374 .56667 Mtetra
0 0 .486 r
.68374 .56667 .68486 .57153 .68588 .57431 .68477 .56983 Mtetra
.064 .109 .598 r
.68477 .56983 .68588 .57431 .68686 .57614 .68576 .57194 Mtetra
.285 .263 .658 r
.68576 .57194 .68686 .57614 .6878 .57706 .68671 .57301 Mtetra
.438 .365 .677 r
.68671 .57301 .6878 .57706 .68871 .57709 .68761 .57311 Mtetra
.538 .429 .678 r
.68761 .57311 .68871 .57709 .68958 .57625 .68848 .57222 Mtetra
.602 .468 .67 r
.68848 .57222 .68958 .57625 .69041 .57454 .6893 .57036 Mtetra
.644 .491 .661 r
.6893 .57036 .69041 .57454 .6912 .57191 .69008 .56747 Mtetra
.671 .505 .653 r
.69008 .56747 .6912 .57191 .69194 .56833 .69081 .56352 Mtetra
.688 .513 .645 r
.69081 .56352 .69194 .56833 .69265 .56378 .6915 .55849 Mtetra
.697 .516 .639 r
.6915 .55849 .69265 .56378 .69331 .55831 .69213 .55244 Mtetra
.699 .515 .635 r
.69213 .55244 .69331 .55831 .69394 .55208 .69273 .54553 Mtetra
.695 .509 .632 r
.69273 .54553 .69394 .55208 .69454 .5454 .6933 .53811 Mtetra
.683 .499 .631 r
.6933 .53811 .69454 .5454 .69515 .53874 .69387 .53073 Mtetra
.662 .482 .631 r
.69387 .53073 .69515 .53874 .69578 .53272 .69448 .52406 Mtetra
.627 .456 .632 r
.69448 .52406 .69578 .53272 .69647 .52801 .69514 .51886 Mtetra
.57 .415 .632 r
.69514 .51886 .69647 .52801 .69725 .52519 .6959 .51577 Mtetra
.477 .349 .627 r
.6959 .51577 .69725 .52519 .69812 .52461 .69678 .51517 Mtetra
.327 .243 .606 r
.69678 .51517 .69812 .52461 .69911 .52629 .69777 .5171 Mtetra
.1 .083 .55 r
.69777 .5171 .69911 .52629 .70018 .52991 .69886 .52119 Mtetra
0 0 .444 r
.69886 .52119 .70018 .52991 .70132 .53492 .70003 .52683 Mtetra
0 0 .32 r
.70003 .52683 .70132 .53492 .7025 .54064 .70124 .53326 Mtetra
0 0 .235 r
.70124 .53326 .7025 .54064 .70368 .54645 .70245 .5398 Mtetra
0 0 .215 r
.70245 .5398 .70368 .54645 .70485 .55185 .70365 .54588 Mtetra
0 0 .262 r
.70365 .54588 .70485 .55185 .70599 .55651 .70481 .55114 Mtetra
0 0 .367 r
.70481 .55114 .70599 .55651 .70708 .56027 .70593 .55539 Mtetra
0 0 .498 r
.70593 .55539 .70708 .56027 .70813 .56306 .707 .55856 Mtetra
.077 .119 .604 r
.707 .55856 .70813 .56306 .70914 .56489 .70802 .56066 Mtetra
.29 .267 .659 r
.70802 .56066 .70914 .56489 .71011 .5658 .70899 .56173 Mtetra
.44 .366 .678 r
.70899 .56173 .71011 .5658 .71103 .56583 .70992 .56181 Mtetra
.538 .429 .677 r
.70992 .56181 .71103 .56583 .71191 .56498 .7108 .56091 Mtetra
.602 .467 .67 r
.7108 .56091 .71191 .56498 .71275 .56324 .71163 .55901 Mtetra
.643 .491 .661 r
.71163 .55901 .71275 .56324 .71355 .56058 .71241 .55609 Mtetra
.67 .505 .652 r
.71241 .55609 .71355 .56058 .7143 .55696 .71314 .55209 Mtetra
.687 .512 .644 r
.71314 .55209 .7143 .55696 .715 .55237 .71381 .54701 Mtetra
.696 .515 .638 r
.71381 .54701 .715 .55237 .71565 .54686 .71444 .5409 Mtetra
.698 .513 .634 r
.71444 .5409 .71565 .54686 .71626 .54059 .71501 .53395 Mtetra
.694 .508 .631 r
.71501 .53395 .71626 .54059 .71685 .53389 .71557 .52651 Mtetra
.682 .497 .63 r
.71557 .52651 .71685 .53389 .71744 .52723 .71612 .51913 Mtetra
.659 .48 .631 r
.71612 .51913 .71744 .52723 .71806 .52126 .71671 .51251 Mtetra
.623 .453 .632 r
.71671 .51251 .71806 .52126 .71875 .51663 .71738 .5074 Mtetra
.564 .411 .632 r
.71738 .5074 .71875 .51663 .71954 .51394 .71815 .50444 Mtetra
.469 .344 .626 r
.71815 .50444 .71954 .51394 .72044 .51351 .71905 .504 Mtetra
.317 .237 .605 r
.71905 .504 .72044 .51351 .72146 .51534 .72008 .5061 Mtetra
.091 .078 .548 r
.72008 .5061 .72146 .51534 .72258 .51911 .72122 .51035 Mtetra
0 0 .445 r
.72122 .51035 .72258 .51911 .72377 .52424 .72244 .51612 Mtetra
0 0 .328 r
.72244 .51612 .72377 .52424 .725 .53006 .7237 .52266 Mtetra
0 0 .249 r
.7237 .52266 .725 .53006 .72624 .53594 .72498 .52927 Mtetra
0 0 .233 r
.72498 .52927 .72624 .53594 .72746 .54138 .72623 .5354 Mtetra
0 0 .281 r
.72623 .5354 .72746 .54138 .72864 .54607 .72744 .54068 Mtetra
0 0 .384 r
.72744 .54068 .72864 .54607 .72977 .54984 .7286 .54494 Mtetra
0 0 .509 r
.7286 .54494 .72977 .54984 .73086 .55263 .7297 .54811 Mtetra
.088 .128 .608 r
.7297 .54811 .73086 .55263 .7319 .55447 .73075 .55021 Mtetra
.295 .271 .661 r
.73075 .55021 .7319 .55447 .73289 .55538 .73175 .55128 Mtetra
.441 .367 .678 r
.73175 .55128 .73289 .55538 .73383 .5554 .73269 .55135 Mtetra
.538 .429 .677 r
.73269 .55135 .73383 .5554 .73473 .55454 .73359 .55043 Mtetra
.601 .466 .67 r
.73359 .55043 .73473 .55454 .73558 .55278 .73443 .54851 Mtetra
.643 .49 .66 r
.73443 .54851 .73558 .55278 .73638 .55009 .73521 .54554 Mtetra
.67 .504 .651 r
.73521 .54554 .73638 .55009 .73712 .54643 .73594 .5415 Mtetra
.687 .511 .644 r
.73594 .5415 .73712 .54643 .73782 .5418 .7366 .53637 Mtetra
.696 .514 .637 r
.7366 .53637 .73782 .5418 .73846 .53624 .73721 .5302 Mtetra
.698 .512 .633 r
.73721 .5302 .73846 .53624 .73906 .52993 .73777 .5232 Mtetra
.693 .506 .631 r
.73777 .5232 .73906 .52993 .73963 .5232 .73831 .51573 Mtetra
.68 .495 .63 r
.73831 .51573 .73963 .5232 .74021 .51655 .73884 .50835 Mtetra
.657 .478 .63 r
.73884 .50835 .74021 .51655 .74082 .51062 .73942 .50178 Mtetra
.619 .45 .631 r
.73942 .50178 .74082 .51062 .74151 .50609 .74008 .49676 Mtetra
.559 .407 .631 r
.74008 .49676 .74151 .50609 .74231 .50352 .74087 .49394 Mtetra
.461 .338 .626 r
.74087 .49394 .74231 .50352 .74324 .50324 .74179 .49367 Mtetra
.307 .23 .604 r
.74179 .49367 .74324 .50324 .7443 .50523 .74286 .49594 Mtetra
.083 .074 .547 r
.74286 .49594 .7443 .50523 .74546 .50915 .74406 .50035 Mtetra
0 0 .447 r
.74406 .50035 .74546 .50915 .74671 .5144 .74534 .50626 Mtetra
0 0 .336 r
.74534 .50626 .74671 .5144 .748 .52032 .74666 .5129 Mtetra
0 0 .263 r
.74666 .5129 .748 .52032 .74929 .52626 .74799 .51958 Mtetra
0 0 .25 r
.74799 .51958 .74929 .52626 .75056 .53175 .7493 .52576 Mtetra
0 0 .299 r
.7493 .52576 .75056 .53175 .75179 .53647 .75056 .53107 Mtetra
0 0 .399 r
.75056 .53107 .75179 .53647 .75296 .54026 .75176 .53535 Mtetra
0 0 .519 r
.75176 .53535 .75296 .54026 .75409 .54307 .7529 .53853 Mtetra
.099 .137 .613 r
.7529 .53853 .75409 .54307 .75515 .54491 .75398 .54063 Mtetra
.3 .275 .662 r
.75398 .54063 .75515 .54491 .75617 .54582 .75501 .54169 Mtetra
.443 .369 .678 r
.75501 .54169 .75617 .54582 .75713 .54583 .75597 .54174 Mtetra
.538 .429 .677 r
.75597 .54174 .75713 .54583 .75805 .54495 .75688 .5408 Mtetra
.601 .466 .669 r
.75688 .5408 .75805 .54495 .75891 .54317 .75773 .53885 Mtetra
.643 .489 .66 r
.75773 .53885 .75891 .54317 .75971 .54045 .75852 .53585 Mtetra
.67 .503 .651 r
.75852 .53585 .75971 .54045 .76046 .53675 .75924 .53176 Mtetra
.686 .51 .643 r
.75924 .53176 .76046 .53675 .76114 .53207 .7599 .52657 Mtetra
.695 .513 .637 r
.7599 .52657 .76114 .53207 .76177 .52646 .76049 .52034 Mtetra
.697 .511 .632 r
.76049 .52034 .76177 .52646 .76236 .52011 .76103 .51329 Mtetra
.692 .505 .63 r
.76103 .51329 .76236 .52011 .76292 .51335 .76154 .50579 Mtetra
.678 .493 .629 r
.76154 .50579 .76292 .51335 .76348 .50671 .76206 .49841 Mtetra
.654 .475 .629 r
.76206 .49841 .76348 .50671 .76408 .50082 .76263 .49188 Mtetra
.615 .447 .631 r
.76263 .49188 .76408 .50082 .76478 .49637 .76329 .48696 Mtetra
.553 .402 .631 r
.76329 .48696 .76478 .49637 .76559 .49393 .76409 .48427 Mtetra
.454 .333 .625 r
.76409 .48427 .76559 .49393 .76655 .4938 .76505 .48417 Mtetra
.298 .224 .602 r
.76505 .48417 .76655 .4938 .76765 .49595 .76616 .48661 Mtetra
.075 .069 .546 r
.76616 .48661 .76765 .49595 .76887 .50002 .76741 .49118 Mtetra
0 0 .449 r
.76741 .49118 .76887 .50002 .77017 .5054 .76875 .49723 Mtetra
0 0 .345 r
.76875 .49723 .77017 .5054 .77151 .51141 .77014 .50398 Mtetra
0 0 .277 r
.77014 .50398 .77151 .51141 .77286 .51743 .77153 .51073 Mtetra
0 0 .267 r
.77153 .51073 .77286 .51743 .77419 .52296 .77289 .51696 Mtetra
0 0 .317 r
.77289 .51696 .77419 .52296 .77546 .52771 .7742 .5223 Mtetra
0 0 .414 r
.7742 .5223 .77546 .52771 .77668 .53152 .77545 .52659 Mtetra
0 0 .528 r
.77545 .52659 .77668 .53152 .77784 .53433 .77663 .52978 Mtetra
.11 .145 .617 r
.77663 .52978 .77784 .53433 .77894 .53618 .77775 .53188 Mtetra
.305 .278 .664 r
.77775 .53188 .77894 .53618 .77998 .53708 .7788 .53293 Mtetra
.445 .37 .679 r
.7788 .53293 .77998 .53708 .78097 .53709 .77979 .53297 Mtetra
.539 .429 .677 r
.77979 .53297 .78097 .53709 .7819 .53619 .78071 .53201 Mtetra
.601 .466 .669 r
.78071 .53201 .7819 .53619 .78277 .53438 .78157 .53003 Mtetra
.643 .489 .659 r
.78157 .53003 .78277 .53438 .78358 .53163 .78236 .52698 Mtetra
.67 .502 .65 r
.78236 .52698 .78358 .53163 .78432 .52788 .78308 .52284 Mtetra
.686 .51 .642 r
.78308 .52284 .78432 .52788 .785 .52315 .78372 .51758 Mtetra
.695 .512 .636 r
.78372 .51758 .785 .52315 .78562 .51749 .7843 .51129 Mtetra
.696 .51 .631 r
.7843 .51129 .78562 .51749 .78619 .51108 .78482 .50418 Mtetra
.691 .503 .629 r
.78482 .50418 .78619 .51108 .78673 .5043 .78531 .49664 Mtetra
.677 .492 .628 r
.78531 .49664 .78673 .5043 .78728 .49765 .78581 .48926 Mtetra
.652 .473 .629 r
.78581 .48926 .78728 .49765 .78788 .49181 .78637 .48277 Mtetra
.611 .444 .63 r
.78637 .48277 .78788 .49181 .78857 .48745 .78703 .47794 Mtetra
.547 .398 .63 r
.78703 .47794 .78857 .48745 .78941 .48513 .78785 .47539 Mtetra
.446 .327 .624 r
.78785 .47539 .78941 .48513 .79039 .48515 .78884 .47545 Mtetra
.288 .218 .601 r
.78884 .47545 .79039 .48515 .79154 .48746 .79 .47806 Mtetra
.068 .066 .545 r
.79 .47806 .79154 .48746 .79281 .49167 .7913 .4828 Mtetra
0 0 .452 r
.7913 .4828 .79281 .49167 .79417 .49718 .79271 .48898 Mtetra
0 0 .353 r
.79271 .48898 .79417 .49718 .79558 .50329 .79416 .49584 Mtetra
0 0 .291 r
.79416 .49584 .79558 .50329 .79699 .50938 .79562 .50267 Mtetra
0 0 .284 r
.79562 .50267 .79699 .50938 .79837 .51496 .79704 .50895 Mtetra
0 0 .334 r
.79704 .50895 .79837 .51496 .79969 .51974 .79841 .51432 Mtetra
0 0 .429 r
.79841 .51432 .79969 .51974 .80096 .52356 .7997 .51862 Mtetra
0 0 .538 r
.7997 .51862 .80096 .52356 .80216 .52638 .80092 .52182 Mtetra
.12 .153 .622 r
.80092 .52182 .80216 .52638 .80329 .52823 .80207 .52391 Mtetra
.31 .282 .666 r
.80207 .52391 .80329 .52823 .80436 .52913 .80315 .52496 Mtetra
.447 .372 .679 r
.80315 .52496 .80436 .52913 .80537 .52912 .80416 .52498 Mtetra
.54 .43 .677 r
.80416 .52498 .80537 .52912 .80631 .5282 .8051 .52399 Mtetra
.602 .466 .669 r
.8051 .52399 .80631 .5282 .80719 .52637 .80597 .52197 Mtetra
.643 .489 .659 r
.80597 .52197 .80719 .52637 .80801 .52357 .80676 .51888 Mtetra
.67 .502 .649 r
.80676 .51888 .80801 .52357 .80875 .51977 .80747 .51467 Mtetra
.686 .509 .641 r
.80747 .51467 .80875 .51977 .80942 .51498 .80811 .50934 Mtetra
.695 .511 .635 r
.80811 .50934 .80942 .51498 .81003 .50925 .80867 .50298 Mtetra
.696 .509 .63 r
.80867 .50298 .81003 .50925 .81058 .5028 .80917 .49581 Mtetra
.69 .502 .628 r
.80917 .49581 .81058 .5028 .8111 .49598 .80964 .48822 Mtetra
.675 .49 .627 r
.80964 .48822 .8111 .49598 .81164 .48933 .81012 .48084 Mtetra
.649 .47 .628 r
.81012 .48084 .81164 .48933 .81223 .48352 .81066 .47439 Mtetra
.608 .44 .63 r
.81066 .47439 .81223 .48352 .81293 .47924 .81133 .46965 Mtetra
.542 .394 .63 r
.81133 .46965 .81293 .47924 .81378 .47704 .81216 .46723 Mtetra
.438 .322 .624 r
.81216 .46723 .81378 .47704 .8148 .47722 .81319 .46746 Mtetra
.28 .213 .6 r
.81319 .46746 .8148 .47722 .81599 .47968 .8144 .47024 Mtetra
.062 .062 .545 r
.8144 .47024 .81599 .47968 .81732 .48405 .81576 .47514 Mtetra
0 0 .455 r
.81576 .47514 .81732 .48405 .81875 .48968 .81723 .48146 Mtetra
0 0 .362 r
.81723 .48146 .81875 .48968 .82022 .49589 .81876 .48842 Mtetra
0 0 .305 r
.81876 .48842 .82022 .49589 .82169 .50204 .82028 .49533 Mtetra
0 0 .301 r
.82028 .49533 .82169 .50204 .82313 .50767 .82177 .50165 Mtetra
0 0 .351 r
.82177 .50165 .82313 .50767 .82451 .51248 .82319 .50705 Mtetra
0 0 .443 r
.82319 .50705 .82451 .51248 .82582 .51631 .82453 .51136 Mtetra
0 .008 .547 r
.82453 .51136 .82582 .51631 .82706 .51914 .82579 .51456 Mtetra
.131 .162 .626 r
.82579 .51456 .82706 .51914 .82822 .52098 .82698 .51665 Mtetra
.315 .287 .667 r
.82698 .51665 .82822 .52098 .82932 .52187 .82808 .51768 Mtetra
.449 .374 .68 r
.82808 .51768 .82932 .52187 .83035 .52185 .82912 .51768 Mtetra
.541 .43 .677 r
.82912 .51768 .83035 .52185 .83131 .52091 .83007 .51666 Mtetra
.602 .466 .668 r
.83007 .51666 .83131 .52091 .8322 .51903 .83095 .5146 Mtetra
.643 .488 .658 r
.83095 .5146 .8322 .51903 .83302 .51619 .83174 .51145 Mtetra
.67 .501 .648 r
.83174 .51145 .83302 .51619 .83376 .51233 .83245 .50717 Mtetra
.686 .508 .64 r
.83245 .50717 .83376 .51233 .83443 .50747 .83307 .50177 Mtetra
.694 .51 .634 r
.83307 .50177 .83443 .50747 .83502 .50168 .83362 .49533 Mtetra
.695 .507 .629 r
.83362 .49533 .83502 .50168 .83555 .49516 .83409 .48808 Mtetra
.689 .5 .627 r
.83409 .48808 .83555 .49516 .83606 .4883 .83454 .48045 Mtetra
.673 .488 .627 r
.83454 .48045 .83606 .4883 .83658 .48164 .835 .47305 Mtetra
.647 .468 .628 r
.835 .47305 .83658 .48164 .83716 .47587 .83554 .46664 Mtetra
.604 .437 .629 r
.83554 .46664 .83716 .47587 .83787 .47167 .83621 .46199 Mtetra
.536 .39 .63 r
.83621 .46199 .83787 .47167 .83874 .4696 .83706 .4597 Mtetra
.43 .317 .623 r
.83706 .4597 .83874 .4696 .8398 .46991 .83812 .46009 Mtetra
.271 .207 .6 r
.83812 .46009 .8398 .46991 .84104 .47254 .83938 .46305 Mtetra
.056 .06 .545 r
.83938 .46305 .84104 .47254 .84243 .47705 .84082 .46811 Mtetra
0 0 .459 r
.84082 .46811 .84243 .47705 .84392 .48281 .84236 .47456 Mtetra
0 0 .371 r
.84236 .47456 .84392 .48281 .84546 .48911 .84395 .48163 Mtetra
0 0 .319 r
.84395 .48163 .84546 .48911 .847 .49533 .84555 .4886 Mtetra
0 0 .318 r
.84555 .4886 .847 .49533 .84849 .501 .8471 .49497 Mtetra
0 0 .368 r
.8471 .49497 .84849 .501 .84993 .50583 .84857 .50039 Mtetra
0 0 .457 r
.84857 .50039 .84993 .50583 .85128 .50968 .84997 .50472 Mtetra
0 .022 .556 r
.84997 .50472 .85128 .50968 .85256 .51251 .85128 .50791 Mtetra
.142 .17 .631 r
.85128 .50791 .85256 .51251 .85376 .51434 .8525 .50999 Mtetra
.321 .291 .669 r
.8525 .50999 .85376 .51434 .85489 .51522 .85363 .51101 Mtetra
.452 .376 .68 r
.85363 .51101 .85489 .51522 .85594 .51517 .85468 .51098 Mtetra
.542 .431 .677 r
.85468 .51098 .85594 .51517 .85692 .5142 .85566 .50992 Mtetra
.603 .467 .668 r
.85566 .50992 .85692 .5142 .85782 .51229 .85654 .50781 Mtetra
.644 .488 .657 r
.85654 .50781 .85782 .51229 .85865 .50939 .85734 .5046 Mtetra
.67 .501 .648 r
.85734 .5046 .85865 .50939 .85939 .50547 .85804 .50025 Mtetra
.687 .508 .639 r
.85804 .50025 .85939 .50547 .86004 .50054 .85865 .49476 Mtetra
.694 .509 .633 r
.85865 .49476 .86004 .50054 .86062 .49467 .85917 .48824 Mtetra
.695 .506 .628 r
.85917 .48824 .86062 .49467 .86113 .48808 .85963 .48091 Mtetra
.688 .499 .626 r
.85963 .48091 .86113 .48808 .86162 .48117 .86005 .47322 Mtetra
.672 .486 .626 r
.86005 .47322 .86162 .48117 .86212 .4745 .86049 .46581 Mtetra
.644 .466 .627 r
.86049 .46581 .86212 .4745 .8627 .46876 .86101 .45943 Mtetra
.6 .434 .629 r
.86101 .45943 .8627 .46876 .86341 .46464 .86169 .45486 Mtetra
.531 .386 .629 r
.86169 .45486 .86341 .46464 .86431 .46268 .86256 .45271 Mtetra
.423 .312 .623 r
.86256 .45271 .86431 .46268 .86541 .46315 .86367 .45325 Mtetra
.263 .203 .599 r
.86367 .45325 .86541 .46315 .8667 .46593 .86499 .45638 Mtetra
.052 .059 .545 r
.86499 .45638 .8667 .46593 .86815 .47058 .86648 .4616 Mtetra
0 0 .463 r
.86648 .4616 .86815 .47058 .86971 .47646 .8681 .46819 Mtetra
0 0 .381 r
.8681 .46819 .86971 .47646 .87132 .48286 .86977 .47535 Mtetra
0 0 .334 r
.86977 .47535 .87132 .48286 .87293 .48914 .87144 .4824 Mtetra
0 0 .335 r
.87144 .4824 .87293 .48914 .87449 .49485 .87305 .48881 Mtetra
0 0 .385 r
.87305 .48881 .87449 .49485 .87598 .4997 .87459 .49425 Mtetra
0 0 .471 r
.87459 .49425 .87598 .4997 .87738 .50356 .87604 .49859 Mtetra
0 .036 .565 r
.87604 .49859 .87738 .50356 .8787 .50639 .87739 .50178 Mtetra
.153 .179 .635 r
.87739 .50178 .8787 .50639 .87994 .50821 .87865 .50385 Mtetra
.327 .296 .671 r
.87865 .50385 .87994 .50821 .8811 .50908 .87981 .50484 Mtetra
.455 .378 .681 r
.87981 .50484 .8811 .50908 .88217 .509 .88089 .50478 Mtetra
.544 .433 .677 r
.88089 .50478 .88217 .509 .88317 .50799 .88187 .50368 Mtetra
.604 .467 .668 r
.88187 .50368 .88317 .50799 .88408 .50603 .88277 .50151 Mtetra
.644 .488 .657 r
.88277 .50151 .88408 .50603 .88491 .50307 .88357 .49823 Mtetra
.671 .501 .647 r
.88357 .49823 .88491 .50307 .88564 .49908 .88426 .4938 Mtetra
.687 .507 .638 r
.88426 .4938 .88564 .49908 .88629 .49407 .88486 .48822 Mtetra
.694 .508 .632 r
.88486 .48822 .88629 .49407 .88685 .48812 .88536 .4816 Mtetra
.695 .505 .627 r
.88536 .4816 .88685 .48812 .88734 .48146 .88578 .47419 Mtetra
.687 .498 .625 r
.88578 .47419 .88734 .48146 .88781 .47449 .88618 .46645 Mtetra
.67 .484 .625 r
.88618 .46645 .88781 .47449 .8883 .46781 .8866 .45901 Mtetra
.642 .463 .626 r
.8866 .45901 .8883 .46781 .88887 .46209 .88712 .45266 Mtetra
.596 .431 .629 r
.88712 .45266 .88887 .46209 .88959 .45804 .8878 .44817 Mtetra
.525 .382 .629 r
.8878 .44817 .88959 .45804 .89051 .45621 .8887 .44615 Mtetra
.416 .307 .622 r
.8887 .44615 .89051 .45621 .89165 .45682 .88984 .44685 Mtetra
.256 .199 .598 r
.88984 .44685 .89165 .45682 .893 .45975 .89122 .45015 Mtetra
.049 .058 .546 r
.89122 .45015 .893 .45975 .89452 .46455 .89279 .45553 Mtetra
0 0 .468 r
.89279 .45553 .89452 .46455 .89615 .47055 .89449 .46224 Mtetra
0 0 .392 r
.89449 .46224 .89615 .47055 .89783 .47703 .89624 .46951 Mtetra
0 0 .348 r
.89624 .46951 .89783 .47703 .89951 .48338 .89798 .47663 Mtetra
0 0 .352 r
.89798 .47663 .89951 .48338 .90113 .48913 .89966 .48307 Mtetra
0 0 .402 r
.89966 .48307 .90113 .48913 .90268 .494 .90126 .48854 Mtetra
0 0 .485 r
.90126 .48854 .90268 .494 .90414 .49786 .90276 .49288 Mtetra
0 .05 .573 r
.90276 .49288 .90414 .49786 .9055 .50068 .90416 .49606 Mtetra
.165 .189 .639 r
.90416 .49606 .9055 .50068 .90677 .5025 .90545 .49811 Mtetra
.334 .301 .673 r
.90545 .49811 .90677 .5025 .90796 .50334 .90665 .49908 Mtetra
.459 .381 .682 r
.90665 .49908 .90796 .50334 .90906 .50323 .90775 .49898 Mtetra
.546 .434 .677 r
.90775 .49898 .90906 .50323 .91007 .50218 .90875 .49783 Mtetra
.605 .468 .667 r
.90875 .49783 .91007 .50218 .911 .50016 .90965 .4956 Mtetra
.645 .488 .656 r
.90965 .4956 .911 .50016 .91182 .49714 .91045 .49225 Mtetra
.671 .501 .646 r
.91045 .49225 .91182 .49714 .91255 .49307 .91114 .48773 Mtetra
.687 .507 .637 r
.91114 .48773 .91255 .49307 .91319 .48797 .91171 .48206 Mtetra
.694 .508 .631 r
.91171 .48206 .91319 .48797 .91373 .48193 .91219 .47533 Mtetra
.694 .504 .626 r
.91219 .47533 .91373 .48193 .9142 .4752 .91259 .46783 Mtetra
.686 .496 .624 r
.91259 .46783 .9142 .4752 .91465 .46817 .91296 .46002 Mtetra
.669 .482 .624 r
.91296 .46002 .91465 .46817 .91512 .46146 .91336 .45255 Mtetra
.639 .461 .626 r
.91336 .45255 .91512 .46146 .91569 .45577 .91387 .44623 Mtetra
.592 .428 .628 r
.91387 .44623 .91569 .45577 .91642 .4518 .91456 .44182 Mtetra
.52 .378 .629 r
.91456 .44182 .91642 .4518 .91736 .45008 .91548 .43993 Mtetra
.409 .303 .622 r
.91548 .43993 .91736 .45008 .91855 .45083 .91667 .4408 Mtetra
.25 .195 .598 r
.91667 .4408 .91855 .45083 .91996 .45392 .91812 .44426 Mtetra
.047 .058 .547 r
.91812 .44426 .91996 .45392 .92155 .45886 .91976 .44979 Mtetra
0 0 .473 r
.91976 .44979 .92155 .45886 .92326 .46497 .92154 .45664 Mtetra
0 0 .402 r
.92154 .45664 .92326 .46497 .92502 .47155 .92337 .46401 Mtetra
0 0 .364 r
.92337 .46401 .92502 .47155 .92676 .47796 .92519 .47119 Mtetra
0 0 .369 r
.92519 .47119 .92676 .47796 .92845 .48374 .92695 .47767 Mtetra
0 0 .419 r
.92695 .47767 .92845 .48374 .93006 .48863 .92861 .48315 Mtetra
0 0 .498 r
.92861 .48315 .93006 .48863 .93157 .49249 .93016 .48749 Mtetra
0 .064 .582 r
.93016 .48749 .93157 .49249 .93298 .49531 .9316 .49067 Mtetra
.177 .198 .644 r
.9316 .49067 .93298 .49531 .93429 .4971 .93294 .4927 Mtetra
.34 .306 .674 r
.93294 .4927 .93429 .4971 .93551 .49792 .93416 .49363 Mtetra
.463 .384 .682 r
.93416 .49363 .93551 .49792 .93663 .49778 .93529 .4935 Mtetra
.548 .435 .677 r
.93529 .4935 .93663 .49778 .93766 .49668 .93631 .4923 Mtetra
.607 .468 .667 r
.93631 .4923 .93766 .49668 .93859 .49461 .93722 .49 Mtetra
.646 .489 .655 r
.93722 .49 .93859 .49461 .93942 .49151 .93801 .48656 Mtetra
.672 .5 .645 r
.93801 .48656 .93942 .49151 .94015 .48736 .93869 .48195 Mtetra
.688 .506 .636 r
.93869 .48195 .94015 .48736 .94076 .48217 .93925 .47617 Mtetra
.695 .507 .629 r
.93925 .47617 .94076 .48217 .94129 .47603 .9397 .46934 Mtetra
.694 .503 .625 r
.9397 .46934 .94129 .47603 .94174 .46921 .94007 .46175 Mtetra
.685 .495 .623 r
.94007 .46175 .94174 .46921 .94216 .46213 .94042 .45386 Mtetra
.667 .481 .623 r
.94042 .45386 .94216 .46213 .94262 .45539 .94079 .44637 Mtetra
.636 .458 .625 r
.94079 .44637 .94262 .45539 .94318 .44972 .94129 .44007 Mtetra
.588 .425 .628 r
.94129 .44007 .94318 .44972 .94392 .44582 .94199 .43574 Mtetra
.514 .374 .628 r
.94199 .43574 .94392 .44582 .94489 .44422 .94294 .43397 Mtetra
.402 .299 .622 r
.94294 .43397 .94489 .44422 .94612 .44511 .94418 .435 Mtetra
.244 .192 .598 r
.94418 .435 .94612 .44511 .9476 .44835 .94569 .43863 Mtetra
.046 .059 .548 r
.94569 .43863 .9476 .44835 .94926 .45343 .94742 .44432 Mtetra
0 0 .478 r
.94742 .44432 .94926 .45343 .95105 .45966 .94928 .4513 Mtetra
0 0 .413 r
.94928 .4513 .95105 .45966 .95289 .46633 .9512 .45876 Mtetra
0 0 .379 r
.9512 .45876 .95289 .46633 .95471 .47279 .9531 .466 Mtetra
0 0 .387 r
.9531 .466 .95471 .47279 .95647 .47861 .95493 .47252 Mtetra
0 0 .435 r
.95493 .47252 .95647 .47861 .95814 .48351 .95665 .47802 Mtetra
0 0 .512 r
.95665 .47802 .95814 .48351 .9597 .48737 .95826 .48236 Mtetra
.003 .079 .59 r
.95826 .48236 .9597 .48737 .96116 .49018 .95975 .48552 Mtetra
.189 .207 .648 r
.95975 .48552 .96116 .49018 .96251 .49195 .96113 .48752 Mtetra
.348 .312 .676 r
.96113 .48752 .96251 .49195 .96376 .49274 .96239 .48842 Mtetra
.467 .387 .682 r
.96239 .48842 .96376 .49274 .9649 .49256 .96353 .48824 Mtetra
.551 .437 .677 r
.96353 .48824 .9649 .49256 .96595 .49141 .96457 .48699 Mtetra
.608 .469 .666 r
.96457 .48699 .96595 .49141 .96689 .48927 .96548 .48462 Mtetra
.647 .489 .654 r
.96548 .48462 .96689 .48927 .96772 .4861 .96628 .4811 Mtetra
.673 .5 .644 r
.96628 .4811 .96772 .4861 .96844 .48186 .96694 .47638 Mtetra
.688 .506 .635 r
.96694 .47638 .96844 .48186 .96904 .47657 .96748 .47049 Mtetra
.695 .506 .628 r
.96748 .47049 .96904 .47657 .96955 .47034 .96791 .46355 Mtetra
.694 .502 .624 r
.96791 .46355 .96955 .47034 .96997 .46342 .96825 .45585 Mtetra
.684 .493 .622 r
.96825 .45585 .96997 .46342 .97037 .45627 .96856 .44789 Mtetra
.665 .479 .623 r
.96856 .44789 .97037 .45627 .97081 .44951 .96892 .44037 Mtetra
.634 .456 .625 r
.96892 .44037 .97081 .44951 .97137 .44386 .9694 .43409 Mtetra
.584 .422 .627 r
.9694 .43409 .97137 .44386 .97212 .44003 .97011 .42984 Mtetra
.509 .37 .628 r
.97011 .42984 .97212 .44003 .97312 .43854 .9711 .42821 Mtetra
.396 .292 .618 r
.51272 .63229 .51367 .64065 .51444 .64127 .51348 .63303 Mtetra
.097 .076 .542 r
.51348 .63303 .51444 .64127 .51521 .64415 .51426 .63625 Mtetra
0 0 .327 r
.51426 .63625 .51521 .64415 .516 .6488 .51504 .64141 Mtetra
.737 .525 0 r
.51504 .64141 .516 .6488 .51679 .65453 .51584 .64775 Mtetra
.88 .625 .103 r
.51584 .64775 .51679 .65453 .51759 .66065 .51664 .65452 Mtetra
.919 .648 .158 r
.51664 .65452 .51759 .66065 .5184 .66653 .51745 .66105 Mtetra
.913 .635 .141 r
.51745 .66105 .5184 .66653 .5192 .67177 .51825 .66686 Mtetra
.857 .581 .047 r
.51825 .66686 .5192 .67177 .51999 .6761 .51904 .67167 Mtetra
0 0 .15 r
.51904 .67167 .51999 .6761 .52078 .67942 .51984 .67537 Mtetra
0 0 .426 r
.51984 .67537 .52078 .67942 .52157 .6817 .52063 .67794 Mtetra
.1 .141 .617 r
.52063 .67794 .52157 .6817 .52235 .68298 .52141 .67941 Mtetra
.378 .331 .678 r
.52141 .67941 .52235 .68298 .52313 .6833 .52218 .67982 Mtetra
.528 .428 .685 r
.52218 .67982 .52313 .6833 .5239 .68269 .52295 .6792 Mtetra
.61 .479 .678 r
.52295 .6792 .5239 .68269 .52466 .68114 .52372 .67755 Mtetra
.657 .507 .668 r
.52372 .67755 .52466 .68114 .52542 .67862 .52447 .67484 Mtetra
.687 .522 .658 r
.52447 .67484 .52542 .67862 .52617 .67509 .52522 .67102 Mtetra
.704 .531 .651 r
.52522 .67102 .52617 .67509 .52691 .67054 .52595 .66607 Mtetra
.714 .534 .645 r
.52595 .66607 .52691 .67054 .52764 .66496 .52668 .66 Mtetra
.718 .534 .64 r
.52668 .66 .52764 .66496 .52836 .65848 .5274 .65294 Mtetra
.716 .531 .638 r
.5274 .65294 .52836 .65848 .52908 .65136 .52811 .64518 Mtetra
.709 .523 .636 r
.52811 .64518 .52908 .65136 .52979 .64404 .52882 .6372 Mtetra
.693 .511 .636 r
.52882 .6372 .52979 .64404 .5305 .63713 .52953 .62967 Mtetra
.667 .49 .637 r
.52953 .62967 .5305 .63713 .53123 .63134 .53024 .62337 Mtetra
.621 .457 .638 r
.53024 .62337 .53123 .63134 .53196 .62735 .53098 .61905 Mtetra
.54 .397 .635 r
.53098 .61905 .53196 .62735 .53272 .62565 .53173 .61723 Mtetra
.386 .285 .617 r
.53173 .61723 .53272 .62565 .5335 .62639 .53251 .61811 Mtetra
.086 .069 .539 r
.53251 .61811 .5335 .62639 .5343 .62939 .53332 .62146 Mtetra
0 0 .33 r
.53332 .62146 .5343 .62939 .53512 .63414 .53414 .62672 Mtetra
.724 .513 0 r
.53414 .62672 .53512 .63414 .53596 .63993 .53498 .63314 Mtetra
.867 .613 .082 r
.53498 .63314 .53596 .63993 .5368 .64608 .53582 .63994 Mtetra
.907 .636 .135 r
.53582 .63994 .5368 .64608 .53764 .65197 .53667 .64647 Mtetra
.897 .62 .113 r
.53667 .64647 .53764 .65197 .53847 .65719 .5375 .65226 Mtetra
.833 .56 .013 r
.5375 .65226 .53847 .65719 .5393 .6615 .53834 .65705 Mtetra
0 0 .188 r
.53834 .65705 .5393 .6615 .54012 .66478 .53916 .66071 Mtetra
0 0 .452 r
.53916 .66071 .54012 .66478 .54093 .66703 .53997 .66324 Mtetra
.126 .159 .625 r
.53997 .66324 .54093 .66703 .54173 .66827 .54077 .66467 Mtetra
.388 .337 .679 r
.54077 .66467 .54173 .66827 .54253 .66855 .54156 .66503 Mtetra
.532 .43 .685 r
.54156 .66503 .54253 .66855 .54331 .66789 .54234 .66437 Mtetra
.611 .479 .677 r
.54234 .66437 .54331 .66789 .54408 .66629 .54311 .66266 Mtetra
.658 .506 .667 r
.54311 .66266 .54408 .66629 .54484 .66372 .54387 .65989 Mtetra
.687 .522 .658 r
.54387 .65989 .54484 .66372 .54558 .66013 .54461 .656 Mtetra
.704 .53 .65 r
.54461 .656 .54558 .66013 .54632 .65551 .54534 .65098 Mtetra
.714 .534 .644 r
.54534 .65098 .54632 .65551 .54704 .64986 .54606 .64484 Mtetra
.718 .533 .64 r
.54606 .64484 .54704 .64986 .54775 .64332 .54676 .63771 Mtetra
.716 .53 .637 r
.54676 .63771 .54775 .64332 .54845 .63616 .54745 .62989 Mtetra
.708 .522 .635 r
.54745 .62989 .54845 .63616 .54914 .62881 .54814 .62189 Mtetra
.692 .509 .635 r
.54814 .62189 .54914 .62881 .54984 .62192 .54883 .61437 Mtetra
.664 .488 .636 r
.54883 .61437 .54984 .62192 .55056 .61619 .54954 .60814 Mtetra
.617 .453 .637 r
.54954 .60814 .55056 .61619 .55129 .61229 .55027 .60392 Mtetra
.534 .392 .635 r
.55027 .60392 .55129 .61229 .55206 .61071 .55103 .60224 Mtetra
.376 .278 .615 r
.55103 .60224 .55206 .61071 .55286 .61158 .55183 .60326 Mtetra
.075 .061 .536 r
.55183 .60326 .55286 .61158 .55369 .61471 .55267 .60674 Mtetra
0 0 .333 r
.55267 .60674 .55369 .61471 .55455 .61955 .55353 .6121 Mtetra
.711 .502 0 r
.55353 .6121 .55455 .61955 .55542 .62541 .55441 .61859 Mtetra
.853 .6 .062 r
.55441 .61859 .55542 .62541 .5563 .63159 .5553 .62543 Mtetra
.893 .623 .111 r
.5553 .62543 .5563 .63159 .55718 .63749 .55618 .63197 Mtetra
.88 .605 .085 r
.55618 .63197 .55718 .63749 .55805 .6427 .55706 .63775 Mtetra
.806 .538 0 r
.55706 .63775 .55805 .6427 .55891 .64698 .55793 .64251 Mtetra
0 0 .225 r
.55793 .64251 .55891 .64698 .55976 .65023 .55878 .64614 Mtetra
0 0 .476 r
.55878 .64614 .55976 .65023 .5606 .65245 .55962 .64863 Mtetra
.149 .175 .632 r
.55962 .64863 .5606 .65245 .56142 .65366 .56044 .65002 Mtetra
.398 .343 .68 r
.56044 .65002 .56142 .65366 .56222 .6539 .56125 .65034 Mtetra
.535 .432 .684 r
.56125 .65034 .56222 .6539 .56301 .6532 .56204 .64963 Mtetra
.612 .479 .676 r
.56204 .64963 .56301 .6532 .56379 .65155 .56281 .64787 Mtetra
.658 .506 .666 r
.56281 .64787 .56379 .65155 .56456 .64892 .56357 .64504 Mtetra
.687 .521 .657 r
.56357 .64504 .56456 .64892 .5653 .64528 .56431 .64109 Mtetra
.704 .529 .649 r
.56431 .64109 .5653 .64528 .56603 .64059 .56503 .63599 Mtetra
.714 .533 .643 r
.56503 .63599 .56603 .64059 .56674 .63488 .56574 .62977 Mtetra
.717 .532 .639 r
.56574 .62977 .56674 .63488 .56743 .62828 .56642 .62258 Mtetra
.715 .529 .636 r
.56642 .62258 .56743 .62828 .56812 .62106 .56709 .61471 Mtetra
.707 .521 .635 r
.56709 .61471 .56812 .62106 .5688 .6137 .56776 .60669 Mtetra
.69 .507 .635 r
.56776 .60669 .5688 .6137 .56948 .60683 .56844 .5992 Mtetra
.662 .486 .636 r
.56844 .5992 .56948 .60683 .57018 .60115 .56913 .59303 Mtetra
.613 .45 .637 r
.56913 .59303 .57018 .60115 .57092 .59736 .56986 .58892 Mtetra
.527 .387 .634 r
.56986 .58892 .57092 .59736 .5717 .5959 .57063 .58737 Mtetra
.365 .271 .614 r
.57063 .58737 .5717 .5959 .57252 .59691 .57145 .58854 Mtetra
.064 .055 .534 r
.57145 .58854 .57252 .59691 .57338 .60016 .57232 .59215 Mtetra
0 0 .336 r
.57232 .59215 .57338 .60016 .57427 .6051 .57322 .59763 Mtetra
0 0 .101 r
.57322 .59763 .57427 .6051 .57519 .61103 .57415 .60419 Mtetra
.838 .587 .04 r
.57415 .60419 .57519 .61103 .57611 .61724 .57508 .61107 Mtetra
.877 .609 .086 r
.57508 .61107 .57611 .61724 .57703 .62316 .57601 .61762 Mtetra
.861 .588 .056 r
.57601 .61762 .57703 .62316 .57794 .62836 .57693 .62339 Mtetra
.778 .514 0 r
.57693 .62339 .57794 .62836 .57884 .63262 .57783 .62813 Mtetra
0 0 .259 r
.57783 .62813 .57884 .63262 .57971 .63585 .57871 .63173 Mtetra
0 0 .497 r
.57871 .63173 .57971 .63585 .58057 .63803 .57958 .63419 Mtetra
.17 .189 .638 r
.57958 .63419 .58057 .63803 .58141 .63921 .58042 .63554 Mtetra
.405 .348 .681 r
.58042 .63554 .58141 .63921 .58223 .63941 .58124 .63582 Mtetra
.538 .433 .683 r
.58124 .63582 .58223 .63941 .58304 .63867 .58204 .63506 Mtetra
.613 .48 .675 r
.58204 .63506 .58304 .63867 .58382 .63698 .58283 .63325 Mtetra
.659 .506 .665 r
.58283 .63325 .58382 .63698 .58459 .6343 .58359 .63037 Mtetra
.687 .52 .656 r
.58359 .63037 .58459 .6343 .58533 .6306 .58432 .62635 Mtetra
.704 .528 .648 r
.58432 .62635 .58533 .6306 .58605 .62585 .58504 .62119 Mtetra
.714 .532 .642 r
.58504 .62119 .58605 .62585 .58675 .62008 .58573 .6149 Mtetra
.717 .531 .638 r
.58573 .6149 .58675 .62008 .58743 .61342 .58639 .60764 Mtetra
.714 .527 .635 r
.58639 .60764 .58743 .61342 .5881 .60616 .58705 .59973 Mtetra
.706 .519 .634 r
.58705 .59973 .5881 .60616 .58876 .59879 .58769 .59169 Mtetra
.688 .505 .634 r
.58769 .59169 .58876 .59879 .58943 .59194 .58835 .58422 Mtetra
.659 .483 .635 r
.58835 .58422 .58943 .59194 .59012 .58633 .58903 .57812 Mtetra
.608 .446 .636 r
.58903 .57812 .59012 .58633 .59086 .58264 .58976 .57413 Mtetra
.52 .382 .633 r
.58976 .57413 .59086 .58264 .59165 .58131 .59055 .57272 Mtetra
.355 .263 .612 r
.59055 .57272 .59165 .58131 .59249 .58246 .59139 .57404 Mtetra
.053 .048 .531 r
.59139 .57404 .59249 .58246 .59339 .58583 .59229 .57779 Mtetra
0 0 .339 r
.59229 .57779 .59339 .58583 .59432 .59088 .59324 .58338 Mtetra
0 0 .115 r
.59324 .58338 .59432 .59088 .59528 .59688 .59421 .59002 Mtetra
.823 .573 .019 r
.59421 .59002 .59528 .59688 .59625 .60314 .59519 .59695 Mtetra
.861 .594 .061 r
.59519 .59695 .59625 .60314 .59721 .60907 .59616 .60351 Mtetra
.841 .57 .027 r
.59616 .60351 .59721 .60907 .59816 .61427 .59712 .60928 Mtetra
.748 .49 0 r
.59712 .60928 .59816 .61427 .59909 .61851 .59806 .614 Mtetra
0 0 .292 r
.59806 .614 .59909 .61851 .59999 .62171 .59897 .61757 Mtetra
0 0 .515 r
.59897 .61757 .59999 .62171 .60088 .62387 .59986 .62 Mtetra
.188 .202 .642 r
.59986 .62 .60088 .62387 .60174 .62502 .60072 .62131 Mtetra
.412 .353 .681 r
.60072 .62131 .60174 .62502 .60257 .6252 .60156 .62156 Mtetra
.54 .434 .683 r
.60156 .62156 .60257 .6252 .60339 .62442 .60238 .62076 Mtetra
.614 .479 .674 r
.60238 .62076 .60339 .62442 .60418 .62268 .60317 .61891 Mtetra
.659 .505 .664 r
.60317 .61891 .60418 .62268 .60495 .61996 .60393 .61597 Mtetra
.687 .52 .655 r
.60393 .61597 .60495 .61996 .60569 .6162 .60466 .61189 Mtetra
.704 .528 .647 r
.60466 .61189 .60569 .6162 .60641 .61139 .60537 .60666 Mtetra
.713 .531 .641 r
.60537 .60666 .60641 .61139 .60709 .60556 .60604 .6003 Mtetra
.716 .53 .637 r
.60604 .6003 .60709 .60556 .60776 .59884 .60669 .59298 Mtetra
.714 .526 .634 r
.60669 .59298 .60776 .59884 .6084 .59155 .60732 .58503 Mtetra
.704 .518 .633 r
.60732 .58503 .6084 .59155 .60905 .58417 .60795 .57698 Mtetra
.686 .503 .633 r
.60795 .57698 .60905 .58417 .6097 .57734 .60859 .56954 Mtetra
.656 .48 .635 r
.60859 .56954 .6097 .57734 .61039 .57181 .60926 .56352 Mtetra
.604 .442 .636 r
.60926 .56352 .61039 .57181 .61113 .56822 .60999 .55964 Mtetra
.512 .376 .632 r
.60999 .55964 .61113 .56822 .61193 .56703 .61079 .55838 Mtetra
.344 .256 .61 r
.61079 .55838 .61193 .56703 .6128 .56833 .61166 .55985 Mtetra
.043 .041 .529 r
.61166 .55985 .6128 .56833 .61373 .57183 .6126 .56376 Mtetra
0 0 .342 r
.6126 .56376 .61373 .57183 .6147 .57698 .61359 .56946 Mtetra
0 0 .13 r
.61359 .56946 .6147 .57698 .61571 .58306 .61461 .57618 Mtetra
.807 .559 0 r
.61461 .57618 .61571 .58306 .61672 .58937 .61563 .58316 Mtetra
.844 .579 .036 r
.61563 .58316 .61672 .58937 .61773 .59531 .61665 .58974 Mtetra
.819 .552 0 r
.61665 .58974 .61773 .59531 .61872 .60051 .61766 .59551 Mtetra
.718 .465 0 r
.61766 .59551 .61872 .60051 .61968 .60475 .61863 .60021 Mtetra
0 0 .321 r
.61863 .60021 .61968 .60475 .62062 .60793 .61958 .60377 Mtetra
0 0 .53 r
.61958 .60377 .62062 .60793 .62152 .61007 .62049 .60617 Mtetra
.204 .213 .647 r
.62049 .60617 .62152 .61007 .62241 .6112 .62138 .60745 Mtetra
.418 .356 .681 r
.62138 .60745 .62241 .6112 .62326 .61134 .62223 .60767 Mtetra
.542 .435 .682 r
.62223 .60767 .62326 .61134 .62409 .61054 .62306 .60683 Mtetra
.614 .479 .674 r
.62306 .60683 .62409 .61054 .62489 .60876 .62385 .60494 Mtetra
.659 .504 .663 r
.62385 .60494 .62489 .60876 .62566 .60599 .62462 .60195 Mtetra
.686 .519 .654 r
.62462 .60195 .62566 .60599 .6264 .60218 .62535 .59781 Mtetra
.703 .527 .646 r
.62535 .59781 .6264 .60218 .6271 .59731 .62604 .59251 Mtetra
.713 .53 .64 r
.62604 .59251 .6271 .59731 .62778 .59142 .6267 .58609 Mtetra
.716 .529 .636 r
.6267 .58609 .62778 .59142 .62843 .58466 .62733 .57871 Mtetra
.713 .525 .633 r
.62733 .57871 .62843 .58466 .62906 .57733 .62794 .57072 Mtetra
.703 .516 .632 r
.62794 .57072 .62906 .57733 .62968 .56994 .62855 .56266 Mtetra
.684 .501 .633 r
.62855 .56266 .62968 .56994 .63032 .56315 .62917 .55526 Mtetra
.653 .477 .634 r
.62917 .55526 .63032 .56315 .631 .55769 .62983 .54932 Mtetra
.599 .438 .635 r
.62983 .54932 .631 .55769 .63175 .55422 .63057 .54556 Mtetra
.505 .371 .632 r
.63057 .54556 .63175 .55422 .63256 .55317 .63138 .54446 Mtetra
.333 .248 .609 r
.63138 .54446 .63256 .55317 .63346 .55461 .63228 .54609 Mtetra
.032 .035 .526 r
.63228 .54609 .63346 .55461 .63442 .55826 .63326 .55014 Mtetra
0 0 .345 r
.63326 .55014 .63442 .55826 .63544 .56352 .63429 .55597 Mtetra
0 0 .144 r
.63429 .55597 .63544 .56352 .6365 .56968 .63536 .56278 Mtetra
.79 .544 0 r
.63536 .56278 .6365 .56968 .63756 .57604 .63644 .56981 Mtetra
.826 .563 .012 r
.63644 .56981 .63756 .57604 .63861 .58201 .63751 .57642 Mtetra
.797 .533 0 r
.63751 .57642 .63861 .58201 .63964 .58722 .63855 .58219 Mtetra
0 0 .152 r
.63855 .58219 .63964 .58722 .64064 .59145 .63957 .58688 Mtetra
0 0 .348 r
.63957 .58688 .64064 .59145 .6416 .59462 .64055 .59042 Mtetra
0 .001 .543 r
.64055 .59042 .6416 .59462 .64254 .59674 .64149 .5928 Mtetra
.218 .222 .65 r
.64149 .5928 .64254 .59674 .64344 .59785 .64239 .59407 Mtetra
.423 .359 .681 r
.64239 .59407 .64344 .59785 .64431 .59797 .64327 .59426 Mtetra
.543 .436 .682 r
.64327 .59426 .64431 .59797 .64515 .59713 .6441 .59339 Mtetra
.615 .479 .673 r
.6441 .59339 .64515 .59713 .64596 .59533 .64491 .59145 Mtetra
.659 .504 .663 r
.64491 .59145 .64596 .59533 .64673 .59252 .64567 .58841 Mtetra
.686 .518 .653 r
.64567 .58841 .64673 .59252 .64747 .58866 .6464 .58422 Mtetra
.703 .526 .645 r
.6464 .58422 .64747 .58866 .64817 .58373 .64708 .57886 Mtetra
.712 .529 .639 r
.64708 .57886 .64817 .58373 .64883 .57779 .64773 .57238 Mtetra
.715 .528 .635 r
.64773 .57238 .64883 .57779 .64946 .57097 .64834 .56494 Mtetra
.712 .523 .632 r
.64834 .56494 .64946 .57097 .65007 .56361 .64892 .55691 Mtetra
.702 .514 .632 r
.64892 .55691 .65007 .56361 .65068 .55622 .64951 .54885 Mtetra
.682 .499 .632 r
.64951 .54885 .65068 .55622 .65131 .54947 .65011 .54148 Mtetra
.649 .474 .634 r
.65011 .54148 .65131 .54947 .65198 .54409 .65077 .53563 Mtetra
.594 .434 .635 r
.65077 .53563 .65198 .54409 .65273 .54074 .65151 .53201 Mtetra
.496 .365 .631 r
.65151 .53201 .65273 .54074 .65356 .53984 .65234 .53106 Mtetra
.321 .241 .607 r
.65234 .53106 .65356 .53984 .65449 .54143 .65327 .53286 Mtetra
.022 .029 .524 r
.65327 .53286 .65449 .54143 .6555 .54522 .65429 .53707 Mtetra
0 0 .348 r
.65429 .53707 .6555 .54522 .65656 .55061 .65537 .54302 Mtetra
0 0 .157 r
.65537 .54302 .65656 .55061 .65766 .55686 .65649 .54993 Mtetra
.774 .53 0 r
.65649 .54993 .65766 .55686 .65877 .56326 .65763 .55701 Mtetra
.807 .547 0 r
.65763 .55701 .65877 .56326 .65987 .56927 .65874 .56365 Mtetra
.775 .513 0 r
.65874 .56365 .65987 .56927 .66094 .57449 .65983 .56944 Mtetra
0 0 .181 r
.65983 .56944 .66094 .57449 .66198 .57872 .66089 .57413 Mtetra
0 0 .372 r
.66089 .57413 .66198 .57872 .66298 .58188 .6619 .57766 Mtetra
0 .02 .555 r
.6619 .57766 .66298 .58188 .66394 .58399 .66287 .58003 Mtetra
.229 .23 .653 r
.66287 .58003 .66394 .58399 .66487 .58508 .6638 .58127 Mtetra
.427 .362 .682 r
.6638 .58127 .66487 .58508 .66576 .58519 .66469 .58144 Mtetra
.544 .436 .681 r
.66469 .58144 .66576 .58519 .66661 .58433 .66554 .58054 Mtetra
.615 .478 .672 r
.66554 .58054 .66661 .58433 .66742 .58249 .66635 .57857 Mtetra
.658 .503 .662 r
.66635 .57857 .66742 .58249 .6682 .57964 .66712 .57548 Mtetra
.686 .517 .652 r
.66712 .57548 .6682 .57964 .66893 .57574 .66784 .57124 Mtetra
.703 .525 .645 r
.66784 .57124 .66893 .57574 .66962 .57076 .66851 .56582 Mtetra
.712 .528 .638 r
.66851 .56582 .66962 .57076 .67027 .56476 .66914 .55927 Mtetra
.714 .527 .634 r
.66914 .55927 .67027 .56476 .67089 .5579 .66973 .55178 Mtetra
.711 .522 .632 r
.66973 .55178 .67089 .5579 .67148 .55051 .6703 .54372 Mtetra
.7 .512 .631 r
.6703 .54372 .67148 .55051 .67207 .54312 .67086 .53565 Mtetra
.68 .497 .631 r
.67086 .53565 .67207 .54312 .67268 .53641 .67145 .52833 Mtetra
.646 .471 .633 r
.67145 .52833 .67268 .53641 .67336 .53111 .6721 .52257 Mtetra
.588 .43 .634 r
.6721 .52257 .67336 .53111 .67411 .52789 .67284 .51908 Mtetra
.488 .359 .63 r
.67284 .51908 .67411 .52789 .67496 .52714 .67369 .5183 Mtetra
.31 .233 .605 r
.67369 .5183 .67496 .52714 .67592 .5289 .67465 .52028 Mtetra
.011 .022 .521 r
.67465 .52028 .67592 .5289 .67697 .53284 .67572 .52464 Mtetra
0 0 .352 r
.67572 .52464 .67697 .53284 .67808 .53834 .67685 .53073 Mtetra
0 0 .17 r
.67685 .53073 .67808 .53834 .67923 .54468 .67803 .53774 Mtetra
.757 .515 0 r
.67803 .53774 .67923 .54468 .6804 .55116 .67922 .54488 Mtetra
.789 .53 0 r
.67922 .54488 .6804 .55116 .68154 .5572 .68039 .55156 Mtetra
.752 .494 0 r
.68039 .55156 .68154 .5572 .68266 .56243 .68153 .55736 Mtetra
0 0 .208 r
.68153 .55736 .68266 .56243 .68374 .56667 .68262 .56206 Mtetra
0 0 .393 r
.68262 .56206 .68374 .56667 .68477 .56983 .68367 .56558 Mtetra
0 .036 .565 r
.68367 .56558 .68477 .56983 .68576 .57194 .68467 .56794 Mtetra
.239 .237 .655 r
.68467 .56794 .68576 .57194 .68671 .57301 .68562 .56917 Mtetra
.43 .364 .682 r
.68562 .56917 .68671 .57301 .68761 .57311 .68653 .56932 Mtetra
.545 .436 .681 r
.68653 .56932 .68761 .57311 .68848 .57222 .68739 .56839 Mtetra
.614 .478 .672 r
.68739 .56839 .68848 .57222 .6893 .57036 .68821 .56638 Mtetra
.658 .502 .661 r
.68821 .56638 .6893 .57036 .69008 .56747 .68898 .56326 Mtetra
.685 .516 .652 r
.68898 .56326 .69008 .56747 .69081 .56352 .68969 .55896 Mtetra
.702 .524 .644 r
.68969 .55896 .69081 .56352 .6915 .55849 .69036 .55348 Mtetra
.711 .527 .638 r
.69036 .55348 .6915 .55849 .69213 .55244 .69097 .54687 Mtetra
.714 .525 .633 r
.69097 .54687 .69213 .55244 .69273 .54553 .69154 .53933 Mtetra
.71 .52 .631 r
.69154 .53933 .69273 .54553 .6933 .53811 .69208 .53123 Mtetra
.699 .511 .63 r
.69208 .53123 .6933 .53811 .69387 .53073 .69262 .52317 Mtetra
.678 .494 .631 r
.69262 .52317 .69387 .53073 .69448 .52406 .6932 .5159 Mtetra
.642 .468 .633 r
.6932 .5159 .69448 .52406 .69514 .51886 .69384 .51023 Mtetra
.583 .425 .634 r
.69384 .51023 .69514 .51886 .6959 .51577 .69459 .50688 Mtetra
.479 .352 .629 r
.69459 .50688 .6959 .51577 .69678 .51517 .69546 .50627 Mtetra
.298 .225 .603 r
.69546 .50627 .69678 .51517 .69777 .5171 .69646 .50843 Mtetra
.001 .016 .519 r
.69646 .50843 .69777 .5171 .69886 .52119 .69757 .51296 Mtetra
0 0 .355 r
.69757 .51296 .69886 .52119 .70003 .52683 .69876 .51918 Mtetra
0 0 .182 r
.69876 .51918 .70003 .52683 .70124 .53326 .7 .52629 Mtetra
.741 .501 0 r
.7 .52629 .70124 .53326 .70245 .5398 .70124 .53351 Mtetra
.77 .514 0 r
.70124 .53351 .70245 .5398 .70365 .54588 .70247 .54023 Mtetra
.729 .474 0 r
.70247 .54023 .70365 .54588 .70481 .55114 .70366 .54605 Mtetra
0 0 .233 r
.70366 .54605 .70481 .55114 .70593 .55539 .70479 .55076 Mtetra
0 0 .412 r
.70479 .55076 .70593 .55539 .707 .55856 .70588 .55428 Mtetra
0 .051 .573 r
.70588 .55428 .707 .55856 .70802 .56066 .70691 .55663 Mtetra
.247 .243 .658 r
.70691 .55663 .70802 .56066 .70899 .56173 .70788 .55785 Mtetra
.433 .366 .682 r
.70788 .55785 .70899 .56173 .70992 .56181 .70881 .55798 Mtetra
.545 .436 .681 r
.70881 .55798 .70992 .56181 .7108 .56091 .70969 .55703 Mtetra
.614 .477 .671 r
.70969 .55703 .7108 .56091 .71163 .55901 .71051 .55499 Mtetra
.658 .501 .661 r
.71051 .55499 .71163 .55901 .71241 .55609 .71128 .55182 Mtetra
.685 .515 .651 r
.71128 .55182 .71241 .55609 .71314 .55209 .71199 .54747 Mtetra
.702 .523 .643 r
.71199 .54747 .71314 .55209 .71381 .54701 .71264 .54193 Mtetra
.711 .526 .637 r
.71264 .54193 .71381 .54701 .71444 .5409 .71324 .53526 Mtetra
.713 .524 .632 r
.71324 .53526 .71444 .5409 .71501 .53395 .71379 .52767 Mtetra
.709 .519 .63 r
.71379 .52767 .71501 .53395 .71557 .52651 .71431 .51954 Mtetra
.697 .509 .629 r
.71431 .51954 .71557 .52651 .71612 .51913 .71483 .51148 Mtetra
.675 .492 .63 r
.71483 .51148 .71612 .51913 .71671 .51251 .71539 .50425 Mtetra
.638 .465 .632 r
.71539 .50425 .71671 .51251 .71738 .5074 .71603 .49868 Mtetra
.577 .421 .634 r
.71603 .49868 .71738 .5074 .71815 .50444 .71679 .49548 Mtetra
.471 .346 .629 r
.71679 .49548 .71815 .50444 .71905 .504 .71768 .49504 Mtetra
.286 .217 .601 r
.71768 .49504 .71905 .504 .72008 .5061 .71872 .49738 Mtetra
0 .01 .517 r
.71872 .49738 .72008 .5061 .72122 .51035 .71988 .50208 Mtetra
0 0 .358 r
.71988 .50208 .72122 .51035 .72244 .51612 .72113 .50845 Mtetra
0 0 .194 r
.72113 .50845 .72244 .51612 .7237 .52266 .72243 .51567 Mtetra
.725 .486 0 r
.72243 .51567 .7237 .52266 .72498 .52927 .72373 .52296 Mtetra
.752 .498 0 r
.72373 .52296 .72498 .52927 .72623 .5354 .72501 .52973 Mtetra
.707 .455 0 r
.72501 .52973 .72623 .5354 .72744 .54068 .72625 .53558 Mtetra
0 0 .257 r
.72625 .53558 .72744 .54068 .7286 .54494 .72743 .54029 Mtetra
0 0 .43 r
.72743 .54029 .7286 .54494 .7297 .54811 .72855 .54382 Mtetra
0 .064 .581 r
.72855 .54382 .7297 .54811 .73075 .55021 .72962 .54617 Mtetra
.255 .249 .66 r
.72962 .54617 .73075 .55021 .73175 .55128 .73062 .54738 Mtetra
.435 .367 .682 r
.73062 .54738 .73175 .55128 .73269 .55135 .73157 .54749 Mtetra
.546 .437 .681 r
.73157 .54749 .73269 .55135 .73359 .55043 .73246 .54652 Mtetra
.614 .477 .671 r
.73246 .54652 .73359 .55043 .73443 .54851 .73329 .54444 Mtetra
.658 .501 .66 r
.73329 .54444 .73443 .54851 .73521 .54554 .73406 .54123 Mtetra
.685 .515 .65 r
.73406 .54123 .73521 .54554 .73594 .5415 .73477 .53682 Mtetra
.702 .522 .642 r
.73477 .53682 .73594 .5415 .7366 .53637 .73541 .53122 Mtetra
.711 .525 .636 r
.73541 .53122 .7366 .53637 .73721 .5302 .73598 .52449 Mtetra
.713 .523 .631 r
.73598 .52449 .73721 .5302 .73777 .5232 .73651 .51684 Mtetra
.708 .517 .629 r
.73651 .51684 .73777 .5232 .73831 .51573 .737 .50867 Mtetra
.696 .507 .628 r
.737 .50867 .73831 .51573 .73884 .50835 .7375 .50061 Mtetra
.673 .49 .63 r
.7375 .50061 .73884 .50835 .73942 .50178 .73805 .49343 Mtetra
.635 .462 .632 r
.73805 .49343 .73942 .50178 .74008 .49676 .73868 .48797 Mtetra
.571 .417 .633 r
.73868 .48797 .74008 .49676 .74087 .49394 .73945 .48491 Mtetra
.462 .34 .628 r
.73945 .48491 .74087 .49394 .74179 .49367 .74038 .48465 Mtetra
.274 .209 .6 r
.74038 .48465 .74179 .49367 .74286 .49594 .74146 .48717 Mtetra
0 .004 .515 r
.74146 .48717 .74286 .49594 .74406 .50035 .74268 .49205 Mtetra
0 0 .361 r
.74268 .49205 .74406 .50035 .74534 .50626 .74399 .49856 Mtetra
0 0 .206 r
.74399 .49856 .74534 .50626 .74666 .5129 .74535 .50589 Mtetra
.709 .472 0 r
.74535 .50589 .74666 .5129 .74799 .51958 .74672 .51326 Mtetra
.733 .481 0 r
.74672 .51326 .74799 .51958 .7493 .52576 .74806 .52008 Mtetra
0 0 .156 r
.74806 .52008 .7493 .52576 .75056 .53107 .74934 .52595 Mtetra
0 0 .279 r
.74934 .52595 .75056 .53107 .75176 .53535 .75057 .53069 Mtetra
0 0 .445 r
.75057 .53069 .75176 .53535 .7529 .53853 .75173 .53422 Mtetra
.001 .076 .588 r
.75173 .53422 .7529 .53853 .75398 .54063 .75283 .53656 Mtetra
.262 .254 .662 r
.75283 .53656 .75398 .54063 .75501 .54169 .75386 .53776 Mtetra
.437 .369 .683 r
.75386 .53776 .75501 .54169 .75597 .54174 .75483 .53786 Mtetra
.547 .437 .68 r
.75483 .53786 .75597 .54174 .75688 .5408 .75573 .53686 Mtetra
.614 .477 .671 r
.75573 .53686 .75688 .5408 .75773 .53885 .75657 .53475 Mtetra
.658 .5 .66 r
.75657 .53475 .75773 .53885 .75852 .53585 .75734 .53149 Mtetra
.685 .514 .649 r
.75734 .53149 .75852 .53585 .75924 .53176 .75804 .52703 Mtetra
.702 .521 .641 r
.75804 .52703 .75924 .53176 .7599 .52657 .75867 .52136 Mtetra
.71 .524 .635 r
.75867 .52136 .7599 .52657 .76049 .52034 .75923 .51456 Mtetra
.712 .522 .63 r
.75923 .51456 .76049 .52034 .76103 .51329 .75973 .50684 Mtetra
.707 .516 .628 r
.75973 .50684 .76103 .51329 .76154 .50579 .7602 .49864 Mtetra
.694 .505 .628 r
.7602 .49864 .76154 .50579 .76206 .49841 .76068 .49058 Mtetra
.671 .487 .629 r
.76068 .49058 .76206 .49841 .76263 .49188 .76121 .48345 Mtetra
.631 .459 .631 r
.76121 .48345 .76263 .49188 .76329 .48696 .76184 .47808 Mtetra
.565 .412 .633 r
.76184 .47808 .76329 .48696 .76409 .48427 .76263 .47517 Mtetra
.453 .334 .627 r
.76263 .47517 .76409 .48427 .76505 .48417 .76358 .47509 Mtetra
.262 .201 .598 r
.76358 .47509 .76505 .48417 .76616 .48661 .76471 .47779 Mtetra
0 0 .513 r
.76471 .47779 .76616 .48661 .76741 .49118 .76598 .48285 Mtetra
0 0 .364 r
.76598 .48285 .76741 .49118 .76875 .49723 .76736 .48951 Mtetra
0 0 .218 r
.76736 .48951 .76875 .49723 .77014 .50398 .76879 .49695 Mtetra
0 0 .134 r
.76879 .49695 .77014 .50398 .77153 .51073 .77022 .5044 Mtetra
.714 .465 0 r
.77022 .5044 .77153 .51073 .77289 .51696 .77162 .51127 Mtetra
0 0 .179 r
.77162 .51127 .77289 .51696 .7742 .5223 .77296 .51717 Mtetra
0 0 .3 r
.77296 .51717 .7742 .5223 .77545 .52659 .77424 .52192 Mtetra
0 0 .46 r
.77424 .52192 .77545 .52659 .77663 .52978 .77544 .52545 Mtetra
.016 .088 .595 r
.77544 .52545 .77663 .52978 .77775 .53188 .77657 .52779 Mtetra
.269 .26 .664 r
.77657 .52779 .77775 .53188 .7788 .53293 .77763 .52898 Mtetra
.44 .371 .683 r
.77763 .52898 .7788 .53293 .77979 .53297 .77862 .52906 Mtetra
.547 .437 .68 r
.77862 .52906 .77979 .53297 .78071 .53201 .77953 .52804 Mtetra
.615 .477 .67 r
.77953 .52804 .78071 .53201 .78157 .53003 .78038 .52589 Mtetra
.658 .5 .659 r
.78038 .52589 .78157 .53003 .78236 .52698 .78115 .52257 Mtetra
.685 .514 .649 r
.78115 .52257 .78236 .52698 .78308 .52284 .78185 .51805 Mtetra
.702 .521 .64 r
.78185 .51805 .78308 .52284 .78372 .51758 .78246 .51231 Mtetra
.71 .523 .634 r
.78246 .51231 .78372 .51758 .7843 .51129 .783 .50543 Mtetra
.712 .521 .629 r
.783 .50543 .7843 .51129 .78482 .50418 .78348 .49765 Mtetra
.706 .515 .627 r
.78348 .49765 .78482 .50418 .78531 .49664 .78393 .48941 Mtetra
.693 .503 .627 r
.78393 .48941 .78531 .49664 .78581 .48926 .78438 .48134 Mtetra
.668 .485 .628 r
.78438 .48134 .78581 .48926 .78637 .48277 .7849 .47425 Mtetra
.627 .456 .631 r
.7849 .47425 .78637 .48277 .78703 .47794 .78553 .46898 Mtetra
.559 .408 .632 r
.78553 .46898 .78703 .47794 .78785 .47539 .78633 .46622 Mtetra
.444 .328 .627 r
.78633 .46622 .78785 .47539 .78884 .47545 .78732 .46631 Mtetra
.251 .194 .596 r
.78732 .46631 .78884 .47545 .79 .47806 .78849 .46921 Mtetra
0 0 .512 r
.78849 .46921 .79 .47806 .7913 .4828 .78983 .47443 Mtetra
0 0 .369 r
.78983 .47443 .7913 .4828 .79271 .48898 .79127 .48125 Mtetra
0 0 .23 r
.79127 .48125 .79271 .48898 .79416 .49584 .79277 .4888 Mtetra
0 0 .152 r
.79277 .4888 .79416 .49584 .79562 .50267 .79427 .49633 Mtetra
.695 .447 0 r
.79427 .49633 .79562 .50267 .79704 .50895 .79574 .50325 Mtetra
0 0 .201 r
.79574 .50325 .79704 .50895 .79841 .51432 .79714 .50918 Mtetra
0 0 .321 r
.79714 .50918 .79841 .51432 .7997 .51862 .79846 .51394 Mtetra
0 0 .475 r
.79846 .51394 .7997 .51862 .80092 .52182 .79971 .51748 Mtetra
.031 .1 .602 r
.79971 .51748 .80092 .52182 .80207 .52391 .80087 .51981 Mtetra
.276 .265 .666 r
.80087 .51981 .80207 .52391 .80315 .52496 .80195 .52099 Mtetra
.443 .373 .684 r
.80195 .52099 .80315 .52496 .80416 .52498 .80296 .52104 Mtetra
.549 .438 .68 r
.80296 .52104 .80416 .52498 .8051 .52399 .8039 .51999 Mtetra
.615 .477 .67 r
.8039 .51999 .8051 .52399 .80597 .52197 .80475 .51779 Mtetra
.658 .5 .658 r
.80475 .51779 .80597 .52197 .80676 .51888 .80553 .51442 Mtetra
.685 .513 .648 r
.80553 .51442 .80676 .51888 .80747 .51467 .80621 .50983 Mtetra
.702 .52 .639 r
.80621 .50983 .80747 .51467 .80811 .50934 .80681 .50401 Mtetra
.71 .522 .633 r
.80681 .50401 .80811 .50934 .80867 .50298 .80733 .49705 Mtetra
.711 .52 .628 r
.80733 .49705 .80867 .50298 .80917 .49581 .80778 .4892 Mtetra
.706 .513 .626 r
.80778 .4892 .80917 .49581 .80964 .48822 .8082 .4809 Mtetra
.691 .502 .626 r
.8082 .4809 .80964 .48822 .81012 .48084 .80863 .47282 Mtetra
.666 .483 .628 r
.80863 .47282 .81012 .48084 .81066 .47439 .80914 .46578 Mtetra
.623 .452 .63 r
.80914 .46578 .81066 .47439 .81133 .46965 .80977 .46061 Mtetra
.553 .403 .632 r
.80977 .46061 .81133 .46965 .81216 .46723 .81059 .45798 Mtetra
.435 .322 .626 r
.81059 .45798 .81216 .46723 .81319 .46746 .81161 .45826 Mtetra
.24 .187 .595 r
.81161 .45826 .81319 .46746 .8144 .47024 .81284 .46134 Mtetra
0 0 .511 r
.81284 .46134 .8144 .47024 .81576 .47514 .81424 .46674 Mtetra
0 0 .373 r
.81424 .46674 .81576 .47514 .81723 .48146 .81576 .4737 Mtetra
0 0 .243 r
.81576 .4737 .81723 .48146 .81876 .48842 .81733 .48137 Mtetra
0 0 .17 r
.81733 .48137 .81876 .48842 .82028 .49533 .8189 .48898 Mtetra
0 0 .165 r
.8189 .48898 .82028 .49533 .82177 .50165 .82043 .49594 Mtetra
0 0 .224 r
.82043 .49594 .82177 .50165 .82319 .50705 .82189 .5019 Mtetra
0 0 .341 r
.82189 .5019 .82319 .50705 .82453 .51136 .82327 .50667 Mtetra
0 0 .489 r
.82327 .50667 .82453 .51136 .82579 .51456 .82455 .51021 Mtetra
.046 .111 .608 r
.82455 .51021 .82579 .51456 .82698 .51665 .82575 .51253 Mtetra
.283 .271 .669 r
.82575 .51253 .82698 .51665 .82808 .51768 .82687 .51369 Mtetra
.446 .376 .685 r
.82687 .51369 .82808 .51768 .82912 .51768 .8279 .51372 Mtetra
.55 .439 .68 r
.8279 .51372 .82912 .51768 .83007 .51666 .82885 .51263 Mtetra
.616 .477 .67 r
.82885 .51263 .83007 .51666 .83095 .5146 .82971 .51038 Mtetra
.659 .5 .658 r
.82971 .51038 .83095 .5146 .83174 .51145 .83048 .50695 Mtetra
.686 .513 .647 r
.83048 .50695 .83174 .51145 .83245 .50717 .83116 .50228 Mtetra
.702 .52 .638 r
.83116 .50228 .83245 .50717 .83307 .50177 .83175 .49637 Mtetra
.71 .521 .632 r
.83175 .49637 .83307 .50177 .83362 .49533 .83224 .48932 Mtetra
.711 .519 .627 r
.83224 .48932 .83362 .49533 .83409 .48808 .83267 .48139 Mtetra
.705 .512 .625 r
.83267 .48139 .83409 .48808 .83454 .48045 .83306 .47304 Mtetra
.69 .5 .625 r
.83306 .47304 .83454 .48045 .835 .47305 .83347 .46495 Mtetra
.663 .48 .627 r
.83347 .46495 .835 .47305 .83554 .46664 .83396 .45794 Mtetra
.619 .449 .63 r
.83396 .45794 .83554 .46664 .83621 .46199 .83459 .45286 Mtetra
.547 .399 .632 r
.83459 .45286 .83621 .46199 .83706 .4597 .83543 .45038 Mtetra
.426 .316 .625 r
.83543 .45038 .83706 .4597 .83812 .46009 .83649 .45083 Mtetra
.229 .181 .594 r
.83649 .45083 .83812 .46009 .83938 .46305 .83778 .4541 Mtetra
0 0 .511 r
.83778 .4541 .83938 .46305 .84082 .46811 .83924 .45967 Mtetra
0 0 .379 r
.83924 .45967 .84082 .46811 .84236 .47456 .84084 .46678 Mtetra
0 0 .256 r
.84084 .46678 .84236 .47456 .84395 .48163 .84248 .47456 Mtetra
0 0 .189 r
.84248 .47456 .84395 .48163 .84555 .4886 .84413 .48224 Mtetra
0 0 .186 r
.84413 .48224 .84555 .4886 .8471 .49497 .84573 .48925 Mtetra
0 0 .246 r
.84573 .48925 .8471 .49497 .84857 .50039 .84725 .49524 Mtetra
0 0 .362 r
.84725 .49524 .84857 .50039 .84997 .50472 .84868 .50002 Mtetra
0 0 .503 r
.84868 .50002 .84997 .50472 .85128 .50791 .85001 .50355 Mtetra
.062 .123 .615 r
.85001 .50355 .85128 .50791 .8525 .50999 .85124 .50586 Mtetra
.291 .277 .671 r
.85124 .50586 .8525 .50999 .85363 .51101 .85239 .507 Mtetra
.449 .378 .685 r
.85239 .507 .85363 .51101 .85468 .51098 .85344 .507 Mtetra
.552 .441 .68 r
.85344 .507 .85468 .51098 .85566 .50992 .85441 .50586 Mtetra
.618 .478 .669 r
.85441 .50586 .85566 .50992 .85654 .50781 .85528 .50356 Mtetra
.66 .5 .657 r
.85528 .50356 .85654 .50781 .85734 .5046 .85605 .50006 Mtetra
.687 .513 .646 r
.85605 .50006 .85734 .5046 .85804 .50025 .85672 .4953 Mtetra
.703 .519 .637 r
.85672 .4953 .85804 .50025 .85865 .49476 .85729 .4893 Mtetra
.711 .521 .631 r
.85729 .4893 .85865 .49476 .85917 .48824 .85776 .48215 Mtetra
.711 .518 .626 r
.85776 .48215 .85917 .48824 .85963 .48091 .85815 .47414 Mtetra
.704 .511 .624 r
.85815 .47414 .85963 .48091 .86005 .47322 .85852 .46572 Mtetra
.689 .498 .624 r
.85852 .46572 .86005 .47322 .86049 .46581 .8589 .45761 Mtetra
.661 .478 .626 r
.8589 .45761 .86049 .46581 .86101 .45943 .85938 .45063 Mtetra
.615 .446 .63 r
.85938 .45063 .86101 .45943 .86169 .45486 .86001 .44565 Mtetra
.541 .394 .631 r
.86001 .44565 .86169 .45486 .86256 .45271 .86087 .44331 Mtetra
.417 .31 .625 r
.86087 .44331 .86256 .45271 .86367 .45325 .86198 .44393 Mtetra
.22 .175 .592 r
.86198 .44393 .86367 .45325 .86499 .45638 .86332 .44738 Mtetra
0 0 .511 r
.86332 .44738 .86499 .45638 .86648 .4616 .86486 .45313 Mtetra
0 0 .385 r
.86486 .45313 .86648 .4616 .8681 .46819 .86653 .46038 Mtetra
0 0 .27 r
.86653 .46038 .8681 .46819 .86977 .47535 .86826 .46827 Mtetra
0 0 .208 r
.86826 .46827 .86977 .47535 .87144 .4824 .86998 .47603 Mtetra
0 0 .209 r
.86998 .47603 .87144 .4824 .87305 .48881 .87165 .48309 Mtetra
0 0 .269 r
.87165 .48309 .87305 .48881 .87459 .49425 .87323 .48909 Mtetra
0 0 .382 r
.87323 .48909 .87459 .49425 .87604 .49859 .87472 .49388 Mtetra
0 0 .516 r
.87472 .49388 .87604 .49859 .87739 .50178 .87609 .4974 Mtetra
.078 .135 .621 r
.87609 .4974 .87739 .50178 .87865 .50385 .87737 .4997 Mtetra
.299 .283 .673 r
.87737 .4997 .87865 .50385 .87981 .50484 .87854 .50081 Mtetra
.453 .381 .686 r
.87854 .50081 .87981 .50484 .88089 .50478 .87962 .50077 Mtetra
.554 .442 .68 r
.87962 .50077 .88089 .50478 .88187 .50368 .8806 .49959 Mtetra
.619 .478 .669 r
.8806 .49959 .88187 .50368 .88277 .50151 .88148 .49722 Mtetra
.661 .5 .656 r
.88148 .49722 .88277 .50151 .88357 .49823 .88225 .49364 Mtetra
.687 .513 .645 r
.88225 .49364 .88357 .49823 .88426 .4938 .88291 .4888 Mtetra
.703 .519 .636 r
.88291 .4888 .88426 .4938 .88486 .48822 .88345 .48269 Mtetra
.711 .52 .629 r
.88345 .48269 .88486 .48822 .88536 .4816 .8839 .47544 Mtetra
.711 .517 .625 r
.8839 .47544 .88536 .4816 .88578 .47419 .88427 .46733 Mtetra
.704 .51 .623 r
.88427 .46733 .88578 .47419 .88618 .46645 .8846 .45885 Mtetra
.687 .497 .624 r
.8846 .45885 .88618 .46645 .8866 .45901 .88496 .45071 Mtetra
.659 .476 .626 r
.88496 .45071 .8866 .45901 .88712 .45266 .88542 .44376 Mtetra
.612 .443 .629 r
.88542 .44376 .88712 .45266 .8878 .44817 .88606 .43886 Mtetra
.535 .39 .631 r
.88606 .43886 .8878 .44817 .8887 .44615 .88694 .43667 Mtetra
.409 .305 .624 r
.88694 .43667 .8887 .44615 .88984 .44685 .88809 .43746 Mtetra
.211 .17 .592 r
.88809 .43746 .88984 .44685 .89122 .45015 .8895 .4411 Mtetra
0 0 .512 r
.8895 .4411 .89122 .45015 .89279 .45553 .89112 .44702 Mtetra
0 0 .392 r
.89112 .44702 .89279 .45553 .89449 .46224 .89287 .45441 Mtetra
0 0 .285 r
.89287 .45441 .89449 .46224 .89624 .46951 .89468 .46241 Mtetra
0 0 .228 r
.89468 .46241 .89624 .46951 .89798 .47663 .89648 .47024 Mtetra
0 0 .231 r
.89648 .47024 .89798 .47663 .89966 .48307 .89823 .47734 Mtetra
0 0 .292 r
.89823 .47734 .89966 .48307 .90126 .48854 .89987 .48337 Mtetra
0 0 .402 r
.89987 .48337 .90126 .48854 .90276 .49288 .90141 .48815 Mtetra
0 0 .529 r
.90141 .48815 .90276 .49288 .90416 .49606 .90284 .49167 Mtetra
.094 .147 .628 r
.90284 .49167 .90416 .49606 .90545 .49811 .90415 .49395 Mtetra
.307 .289 .675 r
.90415 .49395 .90545 .49811 .90665 .49908 .90536 .49503 Mtetra
.458 .384 .686 r
.90536 .49503 .90665 .49908 .90775 .49898 .90645 .49495 Mtetra
.556 .443 .68 r
.90645 .49495 .90775 .49898 .90875 .49783 .90745 .49371 Mtetra
.62 .479 .668 r
.90745 .49371 .90875 .49783 .90965 .4956 .90833 .49128 Mtetra
.662 .5 .655 r
.90833 .49128 .90965 .4956 .91045 .49225 .9091 .48761 Mtetra
.688 .513 .644 r
.9091 .48761 .91045 .49225 .91114 .48773 .90975 .48267 Mtetra
.704 .518 .635 r
.90975 .48267 .91114 .48773 .91171 .48206 .91027 .47645 Mtetra
.711 .519 .628 r
.91027 .47645 .91171 .48206 .91219 .47533 .91069 .46909 Mtetra
.711 .516 .624 r
.91069 .46909 .91219 .47533 .91259 .46783 .91103 .46088 Mtetra
.703 .508 .622 r
.91103 .46088 .91259 .46783 .91296 .46002 .91132 .45232 Mtetra
.686 .495 .623 r
.91132 .45232 .91296 .46002 .91336 .45255 .91166 .44415 Mtetra
.656 .473 .625 r
.91166 .44415 .91336 .45255 .91387 .44623 .91211 .43724 Mtetra
.608 .44 .629 r
.91211 .43724 .91387 .44623 .91456 .44182 .91275 .43243 Mtetra
.529 .386 .631 r
.91275 .43243 .91456 .44182 .91548 .43993 .91366 .43037 Mtetra
.401 .299 .624 r
.91366 .43037 .91548 .43993 .91667 .4408 .91486 .43134 Mtetra
.203 .166 .591 r
.91486 .43134 .91667 .4408 .91812 .44426 .91634 .43516 Mtetra
0 0 .513 r
.91634 .43516 .91812 .44426 .91976 .44979 .91803 .44124 Mtetra
0 0 .4 r
.91803 .44124 .91976 .44979 .92154 .45664 .91987 .44878 Mtetra
0 0 .3 r
.91987 .44878 .92154 .45664 .92337 .46401 .92177 .45688 Mtetra
0 0 .248 r
.92177 .45688 .92337 .46401 .92519 .47119 .92366 .46478 Mtetra
0 0 .254 r
.92366 .46478 .92519 .47119 .92695 .47767 .92547 .47192 Mtetra
0 0 .315 r
.92547 .47192 .92695 .47767 .92861 .48315 .92719 .47797 Mtetra
0 0 .421 r
.92719 .47797 .92861 .48315 .93016 .48749 .92878 .48276 Mtetra
0 0 .542 r
.92878 .48276 .93016 .48749 .9316 .49067 .93026 .48626 Mtetra
.11 .159 .634 r
.93026 .48626 .9316 .49067 .93294 .4927 .93161 .48851 Mtetra
.316 .296 .677 r
.93161 .48851 .93294 .4927 .93416 .49363 .93285 .48956 Mtetra
.462 .388 .687 r
.93285 .48956 .93416 .49363 .93529 .4935 .93397 .48943 Mtetra
.559 .445 .68 r
.93397 .48943 .93529 .4935 .93631 .4923 .93498 .48813 Mtetra
.622 .48 .667 r
.93498 .48813 .93631 .4923 .93722 .49 .93586 .48563 Mtetra
.663 .501 .654 r
.93586 .48563 .93722 .49 .93801 .48656 .93663 .48187 Mtetra
.689 .512 .643 r
.93663 .48187 .93801 .48656 .93869 .48195 .93726 .47682 Mtetra
.704 .518 .634 r
.93726 .47682 .93869 .48195 .93925 .47617 .93777 .47049 Mtetra
.711 .519 .627 r
.93777 .47049 .93925 .47617 .9397 .46934 .93815 .46302 Mtetra
.711 .515 .623 r
.93815 .46302 .9397 .46934 .94007 .46175 .93845 .4547 Mtetra
.702 .507 .621 r
.93845 .4547 .94007 .46175 .94042 .45386 .93872 .44606 Mtetra
.684 .493 .622 r
.93872 .44606 .94042 .45386 .94079 .44637 .93903 .43786 Mtetra
.654 .471 .625 r
.93903 .43786 .94079 .44637 .94129 .44007 .93946 .43097 Mtetra
.604 .436 .628 r
.93946 .43097 .94129 .44007 .94199 .43574 .94012 .42625 Mtetra
.523 .382 .631 r
.94012 .42625 .94199 .43574 .94294 .43397 .94105 .42433 Mtetra
.393 .294 .623 r
.94105 .42433 .94294 .43397 .94418 .435 .9423 .42547 Mtetra
.196 .162 .59 r
.9423 .42547 .94418 .435 .94569 .43863 .94385 .42947 Mtetra
0 0 .515 r
.94385 .42947 .94569 .43863 .94742 .44432 .94563 .43573 Mtetra
0 0 .408 r
.94563 .43573 .94742 .44432 .94928 .4513 .94756 .4434 Mtetra
0 0 .315 r
.94756 .4434 .94928 .4513 .9512 .45876 .94955 .45161 Mtetra
0 0 .268 r
.94955 .45161 .9512 .45876 .9531 .466 .95152 .45958 Mtetra
0 0 .276 r
.95152 .45958 .9531 .466 .95493 .47252 .95342 .46676 Mtetra
0 0 .338 r
.95342 .46676 .95493 .47252 .95665 .47802 .9552 .47282 Mtetra
0 0 .441 r
.9552 .47282 .95665 .47802 .95826 .48236 .95685 .4776 Mtetra
0 .008 .555 r
.95685 .4776 .95826 .48236 .95975 .48552 .95838 .48109 Mtetra
.126 .171 .639 r
.95838 .48109 .95975 .48552 .96113 .48752 .95977 .48332 Mtetra
.325 .302 .679 r
.95977 .48332 .96113 .48752 .96239 .48842 .96104 .48433 Mtetra
.467 .391 .687 r
.96104 .48433 .96239 .48842 .96353 .48824 .96218 .48415 Mtetra
.562 .447 .68 r
.96218 .48415 .96353 .48824 .96457 .48699 .96321 .48279 Mtetra
.624 .481 .667 r
.96321 .48279 .96457 .48699 .96548 .48462 .9641 .4802 Mtetra
.664 .501 .653 r
.9641 .4802 .96548 .48462 .96628 .4811 .96486 .47635 Mtetra
.69 .512 .642 r
.96486 .47635 .96628 .4811 .96694 .47638 .96548 .47119 Mtetra
.705 .518 .632 r
.96548 .47119 .96694 .47638 .96748 .47049 .96596 .46474 Mtetra
.712 .518 .626 r
.96596 .46474 .96748 .47049 .96791 .46355 .96631 .45714 Mtetra
.711 .514 .621 r
.96631 .45714 .96791 .46355 .96825 .45585 .96658 .44871 Mtetra
.702 .506 .62 r
.96658 .44871 .96825 .45585 .96856 .44789 .96681 .43999 Mtetra
.683 .491 .621 r
.96681 .43999 .96856 .44789 .96892 .44037 .96708 .43175 Mtetra
.651 .469 .624 r
.96708 .43175 .96892 .44037 .9694 .43409 .96751 .42488 Mtetra
.599 .433 .628 r
.96751 .42488 .9694 .43409 .97011 .42984 .96817 .42025 Mtetra
.517 .377 .63 r
.96817 .42025 .97011 .42984 .9711 .42821 .96914 .41847 Mtetra
.374 .284 .624 r
.51178 .62533 .51272 .63229 .51348 .63303 .51254 .62617 Mtetra
0 0 .481 r
.51254 .62617 .51348 .63303 .51426 .63625 .51331 .62966 Mtetra
.72 .504 0 r
.51331 .62966 .51426 .63625 .51504 .64141 .5141 .63523 Mtetra
.94 .666 .2 r
.5141 .63523 .51504 .64141 .51584 .64775 .5149 .64209 Mtetra
.977 .692 .305 r
.5149 .64209 .51584 .64775 .51664 .65452 .5157 .64939 Mtetra
.981 .69 .335 r
.5157 .64939 .51664 .65452 .51745 .66105 .5165 .65644 Mtetra
.978 .681 .321 r
.5165 .65644 .51745 .66105 .51825 .66686 .5173 .66272 Mtetra
.966 .66 .259 r
.5173 .66272 .51825 .66686 .51904 .67167 .5181 .66793 Mtetra
.908 .596 .108 r
.5181 .66793 .51904 .67167 .51984 .67537 .5189 .67195 Mtetra
0 0 .212 r
.5189 .67195 .51984 .67537 .52063 .67794 .51968 .67475 Mtetra
0 .035 .576 r
.51968 .67475 .52063 .67794 .52141 .67941 .52047 .67637 Mtetra
.344 .325 .694 r
.52047 .67637 .52141 .67941 .52218 .67982 .52124 .67686 Mtetra
.539 .447 .699 r
.52124 .67686 .52218 .67982 .52295 .6792 .52201 .67623 Mtetra
.631 .501 .685 r
.52201 .67623 .52295 .6792 .52372 .67755 .52277 .6745 Mtetra
.68 .527 .671 r
.52277 .6745 .52372 .67755 .52447 .67484 .52353 .67163 Mtetra
.709 .541 .66 r
.52353 .67163 .52447 .67484 .52522 .67102 .52427 .66758 Mtetra
.725 .549 .651 r
.52427 .66758 .52522 .67102 .52595 .66607 .525 .6623 Mtetra
.735 .551 .645 r
.525 .6623 .52595 .66607 .52668 .66 .52573 .65583 Mtetra
.738 .551 .64 r
.52573 .65583 .52668 .66 .5274 .65294 .52644 .64829 Mtetra
.737 .548 .637 r
.52644 .64829 .5274 .65294 .52811 .64518 .52715 .64 Mtetra
.73 .541 .636 r
.52715 .64 .52811 .64518 .52882 .6372 .52786 .63147 Mtetra
.717 .53 .637 r
.52786 .63147 .52882 .6372 .52953 .62967 .52856 .62344 Mtetra
.692 .511 .639 r
.52856 .62344 .52953 .62967 .53024 .62337 .52927 .61672 Mtetra
.647 .479 .642 r
.52927 .61672 .53024 .62337 .53098 .61905 .53001 .61213 Mtetra
.558 .415 .643 r
.53001 .61213 .53098 .61905 .53173 .61723 .53076 .61022 Mtetra
.36 .274 .622 r
.53076 .61022 .53173 .61723 .53251 .61811 .53154 .61121 Mtetra
0 0 .475 r
.53154 .61121 .53251 .61811 .53332 .62146 .53234 .61484 Mtetra
.716 .499 0 r
.53234 .61484 .53332 .62146 .53414 .62672 .53317 .62052 Mtetra
.934 .659 .185 r
.53317 .62052 .53414 .62672 .53498 .63314 .53401 .62745 Mtetra
.974 .686 .29 r
.53401 .62745 .53498 .63314 .53582 .63994 .53485 .6348 Mtetra
.979 .686 .318 r
.53485 .6348 .53582 .63994 .53667 .64647 .5357 .64185 Mtetra
.975 .676 .301 r
.5357 .64185 .53667 .64647 .5375 .65226 .53654 .64811 Mtetra
.959 .651 .233 r
.53654 .64811 .5375 .65226 .53834 .65705 .53738 .65329 Mtetra
.887 .577 .071 r
.53738 .65329 .53834 .65705 .53916 .66071 .5382 .65727 Mtetra
0 0 .258 r
.5382 .65727 .53916 .66071 .53997 .66324 .53902 .66003 Mtetra
0 .066 .594 r
.53902 .66003 .53997 .66324 .54077 .66467 .53982 .6616 Mtetra
.359 .334 .695 r
.53982 .6616 .54077 .66467 .54156 .66503 .54061 .66204 Mtetra
.544 .449 .698 r
.54061 .66204 .54156 .66503 .54234 .66437 .54139 .66136 Mtetra
.633 .501 .684 r
.54139 .66136 .54234 .66437 .54311 .66266 .54216 .65957 Mtetra
.681 .527 .67 r
.54216 .65957 .54311 .66266 .54387 .65989 .54291 .65664 Mtetra
.709 .541 .659 r
.54291 .65664 .54387 .65989 .54461 .656 .54365 .65251 Mtetra
.726 .548 .65 r
.54365 .65251 .54461 .656 .54534 .65098 .54438 .64715 Mtetra
.735 .551 .644 r
.54438 .64715 .54534 .65098 .54606 .64484 .54509 .6406 Mtetra
.738 .55 .639 r
.54509 .6406 .54606 .64484 .54676 .63771 .54579 .63299 Mtetra
.737 .547 .636 r
.54579 .63299 .54676 .63771 .54745 .62989 .54647 .62464 Mtetra
.73 .54 .635 r
.54647 .62464 .54745 .62989 .54814 .62189 .54715 .61609 Mtetra
.715 .529 .636 r
.54715 .61609 .54814 .62189 .54883 .61437 .54784 .60807 Mtetra
.689 .509 .638 r
.54784 .60807 .54883 .61437 .54954 .60814 .54854 .60142 Mtetra
.642 .475 .641 r
.54854 .60142 .54954 .60814 .55027 .60392 .54927 .59694 Mtetra
.551 .41 .642 r
.54927 .59694 .55027 .60392 .55103 .60224 .55003 .59518 Mtetra
.346 .264 .62 r
.55003 .59518 .55103 .60224 .55183 .60326 .55083 .59631 Mtetra
0 0 .47 r
.55083 .59631 .55183 .60326 .55267 .60674 .55167 .60009 Mtetra
.711 .494 0 r
.55167 .60009 .55267 .60674 .55353 .6121 .55253 .60588 Mtetra
.927 .651 .17 r
.55253 .60588 .55353 .6121 .55441 .61859 .55342 .61289 Mtetra
.97 .681 .273 r
.55342 .61289 .55441 .61859 .5553 .62543 .55431 .62027 Mtetra
.976 .681 .301 r
.55431 .62027 .5553 .62543 .55618 .63197 .5552 .62733 Mtetra
.971 .67 .281 r
.5552 .62733 .55618 .63197 .55706 .63775 .55608 .63358 Mtetra
.95 .641 .206 r
.55608 .63358 .55706 .63775 .55793 .64251 .55695 .63873 Mtetra
.863 .555 .032 r
.55695 .63873 .55793 .64251 .55878 .64614 .55781 .64268 Mtetra
0 0 .301 r
.55781 .64268 .55878 .64614 .55962 .64863 .55865 .64539 Mtetra
0 .093 .608 r
.55865 .64539 .55962 .64863 .56044 .65002 .55947 .64692 Mtetra
.372 .342 .696 r
.55947 .64692 .56044 .65002 .56125 .65034 .56028 .64731 Mtetra
.548 .451 .697 r
.56028 .64731 .56125 .65034 .56204 .64963 .56107 .64659 Mtetra
.634 .501 .683 r
.56107 .64659 .56204 .64963 .56281 .64787 .56184 .64474 Mtetra
.681 .527 .67 r
.56184 .64474 .56281 .64787 .56357 .64504 .5626 .64174 Mtetra
.709 .54 .658 r
.5626 .64174 .56357 .64504 .56431 .64109 .56334 .63754 Mtetra
.726 .547 .649 r
.56334 .63754 .56431 .64109 .56503 .63599 .56405 .63211 Mtetra
.735 .55 .643 r
.56405 .63211 .56503 .63599 .56574 .62977 .56475 .62547 Mtetra
.738 .55 .638 r
.56475 .62547 .56574 .62977 .56642 .62258 .56543 .61779 Mtetra
.736 .546 .635 r
.56543 .61779 .56642 .62258 .56709 .61471 .56609 .60939 Mtetra
.729 .539 .634 r
.56609 .60939 .56709 .61471 .56776 .60669 .56675 .60082 Mtetra
.714 .527 .635 r
.56675 .60082 .56776 .60669 .56844 .5992 .56742 .59282 Mtetra
.687 .507 .638 r
.56742 .59282 .56844 .5992 .56913 .59303 .5681 .58625 Mtetra
.638 .472 .641 r
.5681 .58625 .56913 .59303 .56986 .58892 .56883 .58188 Mtetra
.543 .404 .642 r
.56883 .58188 .56986 .58892 .57063 .58737 .5696 .58026 Mtetra
.332 .254 .617 r
.5696 .58026 .57063 .58737 .57145 .58854 .57042 .58155 Mtetra
0 0 .464 r
.57042 .58155 .57145 .58854 .57232 .59215 .57129 .58547 Mtetra
.706 .488 0 r
.57129 .58547 .57232 .59215 .57322 .59763 .5722 .59138 Mtetra
.92 .643 .155 r
.5722 .59138 .57322 .59763 .57415 .60419 .57313 .59847 Mtetra
.965 .675 .256 r
.57313 .59847 .57415 .60419 .57508 .61107 .57407 .60589 Mtetra
.972 .675 .282 r
.57407 .60589 .57508 .61107 .57601 .61762 .57501 .61297 Mtetra
.966 .663 .259 r
.57501 .61297 .57601 .61762 .57693 .62339 .57593 .6192 Mtetra
.939 .629 .177 r
.57593 .6192 .57693 .62339 .57783 .62813 .57684 .62433 Mtetra
.837 .532 0 r
.57684 .62433 .57783 .62813 .57871 .63173 .57773 .62824 Mtetra
0 0 .34 r
.57773 .62824 .57871 .63173 .57958 .63419 .57859 .63092 Mtetra
.032 .116 .62 r
.57859 .63092 .57958 .63419 .58042 .63554 .57943 .63241 Mtetra
.383 .349 .696 r
.57943 .63241 .58042 .63554 .58124 .63582 .58026 .63276 Mtetra
.551 .453 .696 r
.58026 .63276 .58124 .63582 .58204 .63506 .58106 .63198 Mtetra
.635 .501 .682 r
.58106 .63198 .58204 .63506 .58283 .63325 .58184 .63008 Mtetra
.682 .526 .669 r
.58184 .63008 .58283 .63325 .58359 .63037 .5826 .62702 Mtetra
.709 .54 .657 r
.5826 .62702 .58359 .63037 .58432 .62635 .58333 .62275 Mtetra
.726 .547 .648 r
.58333 .62275 .58432 .62635 .58504 .62119 .58404 .61724 Mtetra
.735 .549 .642 r
.58404 .61724 .58504 .62119 .58573 .6149 .58472 .61053 Mtetra
.738 .549 .637 r
.58472 .61053 .58573 .6149 .58639 .60764 .58538 .60278 Mtetra
.736 .545 .634 r
.58538 .60278 .58639 .60764 .58705 .59973 .58602 .59433 Mtetra
.728 .538 .634 r
.58602 .59433 .58705 .59973 .58769 .59169 .58665 .58574 Mtetra
.712 .525 .635 r
.58665 .58574 .58769 .59169 .58835 .58422 .5873 .57777 Mtetra
.684 .504 .637 r
.5873 .57777 .58835 .58422 .58903 .57812 .58797 .57127 Mtetra
.634 .468 .641 r
.58797 .57127 .58903 .57812 .58976 .57413 .5887 .56702 Mtetra
.534 .398 .641 r
.5887 .56702 .58976 .57413 .59055 .57272 .58948 .56556 Mtetra
.317 .244 .615 r
.58948 .56556 .59055 .57272 .59139 .57404 .59033 .56701 Mtetra
0 0 .459 r
.59033 .56701 .59139 .57404 .59229 .57779 .59123 .57108 Mtetra
.701 .482 0 r
.59123 .57108 .59229 .57779 .59324 .58338 .59218 .57711 Mtetra
.912 .635 .139 r
.59218 .57711 .59324 .58338 .59421 .59002 .59316 .58428 Mtetra
.959 .668 .239 r
.59316 .58428 .59421 .59002 .59519 .59695 .59415 .59175 Mtetra
.967 .669 .263 r
.59415 .59175 .59519 .59695 .59616 .60351 .59514 .59884 Mtetra
.96 .655 .236 r
.59514 .59884 .59616 .60351 .59712 .60928 .59611 .60507 Mtetra
.927 .616 .148 r
.59611 .60507 .59712 .60928 .59806 .614 .59705 .61017 Mtetra
.807 .507 0 r
.59705 .61017 .59806 .614 .59897 .61757 .59797 .61405 Mtetra
0 0 .375 r
.59797 .61405 .59897 .61757 .59986 .62 .59886 .6167 Mtetra
.063 .137 .63 r
.59886 .6167 .59986 .62 .60072 .62131 .59973 .61815 Mtetra
.393 .355 .697 r
.59973 .61815 .60072 .62131 .60156 .62156 .60057 .61846 Mtetra
.554 .454 .695 r
.60057 .61846 .60156 .62156 .60238 .62076 .60138 .61764 Mtetra
.636 .501 .681 r
.60138 .61764 .60238 .62076 .60317 .61891 .60217 .61569 Mtetra
.682 .526 .668 r
.60217 .61569 .60317 .61891 .60393 .61597 .60292 .61257 Mtetra
.709 .539 .656 r
.60292 .61257 .60393 .61597 .60466 .61189 .60365 .60824 Mtetra
.726 .546 .647 r
.60365 .60824 .60466 .61189 .60537 .60666 .60435 .60265 Mtetra
.735 .548 .641 r
.60435 .60265 .60537 .60666 .60604 .6003 .60501 .59587 Mtetra
.738 .548 .636 r
.60501 .59587 .60604 .6003 .60669 .59298 .60565 .58805 Mtetra
.735 .544 .634 r
.60565 .58805 .60669 .59298 .60732 .58503 .60627 .57955 Mtetra
.727 .536 .633 r
.60627 .57955 .60732 .58503 .60795 .57698 .60688 .57095 Mtetra
.711 .523 .634 r
.60688 .57095 .60795 .57698 .60859 .56954 .60751 .56301 Mtetra
.681 .502 .637 r
.60751 .56301 .60859 .56954 .60926 .56352 .60817 .55659 Mtetra
.629 .464 .64 r
.60817 .55659 .60926 .56352 .60999 .55964 .60889 .55247 Mtetra
.526 .391 .641 r
.60889 .55247 .60999 .55964 .61079 .55838 .60969 .55116 Mtetra
.302 .234 .612 r
.60969 .55116 .61079 .55838 .61166 .55985 .61056 .55278 Mtetra
0 0 .454 r
.61056 .55278 .61166 .55985 .6126 .56376 .61151 .557 Mtetra
0 0 .115 r
.61151 .557 .6126 .56376 .61359 .56946 .6125 .56316 Mtetra
.903 .626 .123 r
.6125 .56316 .61359 .56946 .61461 .57618 .61353 .57041 Mtetra
.953 .661 .221 r
.61353 .57041 .61461 .57618 .61563 .58316 .61458 .57793 Mtetra
.962 .662 .243 r
.61458 .57793 .61563 .58316 .61665 .58974 .61561 .58504 Mtetra
.952 .646 .213 r
.61561 .58504 .61665 .58974 .61766 .59551 .61662 .59127 Mtetra
.912 .602 .118 r
.61662 .59127 .61766 .59551 .61863 .60021 .6176 .59636 Mtetra
.776 .481 0 r
.6176 .59636 .61863 .60021 .61958 .60377 .61856 .60022 Mtetra
0 0 .407 r
.61856 .60022 .61958 .60377 .62049 .60617 .61948 .60284 Mtetra
.089 .155 .638 r
.61948 .60284 .62049 .60617 .62138 .60745 .62036 .60426 Mtetra
.401 .36 .697 r
.62036 .60426 .62138 .60745 .62223 .60767 .62122 .60453 Mtetra
.556 .455 .695 r
.62122 .60453 .62223 .60767 .62306 .60683 .62204 .60367 Mtetra
.637 .501 .681 r
.62204 .60367 .62306 .60683 .62385 .60494 .62284 .60167 Mtetra
.682 .525 .667 r
.62284 .60167 .62385 .60494 .62462 .60195 .6236 .5985 Mtetra
.709 .538 .655 r
.6236 .5985 .62462 .60195 .62535 .59781 .62432 .5941 Mtetra
.726 .545 .646 r
.62432 .5941 .62535 .59781 .62604 .59251 .625 .58845 Mtetra
.734 .548 .64 r
.625 .58845 .62604 .59251 .6267 .58609 .62565 .58159 Mtetra
.737 .547 .635 r
.62565 .58159 .6267 .58609 .62733 .57871 .62627 .57371 Mtetra
.735 .543 .633 r
.62627 .57371 .62733 .57871 .62794 .57072 .62686 .56517 Mtetra
.726 .535 .632 r
.62686 .56517 .62794 .57072 .62855 .56266 .62745 .55656 Mtetra
.709 .521 .633 r
.62745 .55656 .62855 .56266 .62917 .55526 .62806 .54865 Mtetra
.679 .499 .636 r
.62806 .54865 .62917 .55526 .62983 .54932 .62871 .54232 Mtetra
.623 .46 .64 r
.62871 .54232 .62983 .54932 .63057 .54556 .62943 .53833 Mtetra
.516 .385 .64 r
.62943 .53833 .63057 .54556 .63138 .54446 .63024 .53718 Mtetra
.286 .223 .609 r
.63024 .53718 .63138 .54446 .63228 .54609 .63115 .53897 Mtetra
0 0 .449 r
.63115 .53897 .63228 .54609 .63326 .55014 .63213 .54335 Mtetra
0 0 .122 r
.63213 .54335 .63326 .55014 .63429 .55597 .63318 .54964 Mtetra
.894 .617 .107 r
.63318 .54964 .63429 .55597 .63536 .56278 .63426 .55699 Mtetra
.946 .653 .202 r
.63426 .55699 .63536 .56278 .63644 .56981 .63536 .56456 Mtetra
.955 .654 .223 r
.63536 .56456 .63644 .56981 .63751 .57642 .63644 .5717 Mtetra
.943 .636 .189 r
.63644 .5717 .63751 .57642 .63855 .58219 .6375 .57793 Mtetra
.896 .586 .088 r
.6375 .57793 .63855 .58219 .63957 .58688 .63852 .58301 Mtetra
.744 .454 0 r
.63852 .58301 .63957 .58688 .64055 .59042 .63951 .58685 Mtetra
0 0 .434 r
.63951 .58685 .64055 .59042 .64149 .5928 .64046 .58945 Mtetra
.112 .171 .645 r
.64046 .58945 .64149 .5928 .64239 .59407 .64137 .59084 Mtetra
.408 .364 .697 r
.64137 .59084 .64239 .59407 .64327 .59426 .64224 .59108 Mtetra
.558 .455 .694 r
.64224 .59108 .64327 .59426 .6441 .59339 .64308 .59019 Mtetra
.637 .501 .68 r
.64308 .59019 .6441 .59339 .64491 .59145 .64387 .58814 Mtetra
.682 .525 .666 r
.64387 .58814 .64491 .59145 .64567 .58841 .64463 .58491 Mtetra
.709 .538 .654 r
.64463 .58491 .64567 .58841 .6464 .58422 .64535 .58045 Mtetra
.725 .544 .645 r
.64535 .58045 .6464 .58422 .64708 .57886 .64602 .57473 Mtetra
.734 .547 .639 r
.64602 .57473 .64708 .57886 .64773 .57238 .64665 .56781 Mtetra
.737 .546 .634 r
.64665 .56781 .64773 .57238 .64834 .56494 .64724 .55986 Mtetra
.734 .541 .632 r
.64724 .55986 .64834 .56494 .64892 .55691 .64781 .55128 Mtetra
.725 .533 .631 r
.64781 .55128 .64892 .55691 .64951 .54885 .64838 .54266 Mtetra
.707 .519 .633 r
.64838 .54266 .64951 .54885 .65011 .54148 .64897 .5348 Mtetra
.675 .496 .636 r
.64897 .5348 .65011 .54148 .65077 .53563 .64961 .52856 Mtetra
.618 .456 .64 r
.64961 .52856 .65077 .53563 .65151 .53201 .65034 .52471 Mtetra
.507 .378 .639 r
.65034 .52471 .65151 .53201 .65234 .53106 .65117 .52373 Mtetra
.269 .212 .606 r
.65117 .52373 .65234 .53106 .65327 .53286 .6521 .5257 Mtetra
0 0 .444 r
.6521 .5257 .65327 .53286 .65429 .53707 .65313 .53024 Mtetra
0 0 .129 r
.65313 .53024 .65429 .53707 .65537 .54302 .65423 .53667 Mtetra
.885 .608 .091 r
.65423 .53667 .65537 .54302 .65649 .54993 .65537 .54411 Mtetra
.939 .644 .184 r
.65537 .54411 .65649 .54993 .65763 .55701 .65652 .55175 Mtetra
.948 .645 .202 r
.65652 .55175 .65763 .55701 .65874 .56365 .65765 .55891 Mtetra
.934 .625 .165 r
.65765 .55891 .65874 .56365 .65983 .56944 .65876 .56516 Mtetra
.879 .57 .058 r
.65876 .56516 .65983 .56944 .66089 .57413 .65982 .57024 Mtetra
.712 .427 0 r
.65982 .57024 .66089 .57413 .6619 .57766 .66084 .57406 Mtetra
0 0 .458 r
.66084 .57406 .6619 .57766 .66287 .58003 .66182 .57664 Mtetra
.131 .184 .651 r
.66182 .57664 .66287 .58003 .6638 .58127 .66276 .57801 Mtetra
.414 .367 .697 r
.66276 .57801 .6638 .58127 .66469 .58144 .66365 .57822 Mtetra
.559 .456 .693 r
.66365 .57822 .66469 .58144 .66554 .58054 .66449 .5773 Mtetra
.637 .5 .679 r
.66449 .5773 .66554 .58054 .66635 .57857 .6653 .57521 Mtetra
.682 .524 .665 r
.6653 .57521 .66635 .57857 .66712 .57548 .66606 .57193 Mtetra
.709 .537 .654 r
.66606 .57193 .66712 .57548 .66784 .57124 .66677 .56741 Mtetra
.725 .543 .644 r
.66677 .56741 .66784 .57124 .66851 .56582 .66743 .56162 Mtetra
.734 .546 .638 r
.66743 .56162 .66851 .56582 .66914 .55927 .66804 .55463 Mtetra
.737 .545 .633 r
.66804 .55463 .66914 .55927 .66973 .55178 .66861 .54663 Mtetra
.734 .54 .631 r
.66861 .54663 .66973 .55178 .6703 .54372 .66916 .53801 Mtetra
.724 .532 .63 r
.66916 .53801 .6703 .54372 .67086 .53565 .6697 .52939 Mtetra
.705 .517 .632 r
.6697 .52939 .67086 .53565 .67145 .52833 .67027 .52157 Mtetra
.672 .493 .635 r
.67027 .52157 .67145 .52833 .6721 .52257 .6709 .51543 Mtetra
.612 .451 .64 r
.6709 .51543 .6721 .52257 .67284 .51908 .67163 .51172 Mtetra
.496 .37 .638 r
.67163 .51172 .67284 .51908 .67369 .5183 .67248 .51092 Mtetra
.253 .201 .603 r
.67248 .51092 .67369 .5183 .67465 .52028 .67345 .51307 Mtetra
0 0 .439 r
.67345 .51307 .67465 .52028 .67572 .52464 .67453 .51778 Mtetra
0 0 .136 r
.67453 .51778 .67572 .52464 .67685 .53073 .67568 .52435 Mtetra
.876 .598 .076 r
.67568 .52435 .67685 .53073 .67803 .53774 .67688 .5319 Mtetra
.931 .635 .165 r
.67688 .5319 .67803 .53774 .67922 .54488 .67808 .5396 Mtetra
.94 .636 .182 r
.67808 .5396 .67922 .54488 .68039 .55156 .67927 .5468 Mtetra
.923 .614 .141 r
.67927 .5468 .68039 .55156 .68153 .55736 .68043 .55306 Mtetra
.861 .553 .028 r
.68043 .55306 .68153 .55736 .68262 .56206 .68154 .55814 Mtetra
0 0 .19 r
.68154 .55814 .68262 .56206 .68367 .56558 .68259 .56196 Mtetra
0 0 .479 r
.68259 .56196 .68367 .56558 .68467 .56794 .6836 .56452 Mtetra
.148 .195 .655 r
.6836 .56452 .68467 .56794 .68562 .56917 .68456 .56588 Mtetra
.419 .37 .698 r
.68456 .56588 .68562 .56917 .68653 .56932 .68547 .56607 Mtetra
.56 .456 .693 r
.68547 .56607 .68653 .56932 .68739 .56839 .68633 .56511 Mtetra
.637 .5 .678 r
.68633 .56511 .68739 .56839 .68821 .56638 .68714 .56299 Mtetra
.682 .523 .664 r
.68714 .56299 .68821 .56638 .68898 .56326 .6879 .55966 Mtetra
.709 .536 .653 r
.6879 .55966 .68898 .56326 .68969 .55896 .6886 .55508 Mtetra
.725 .543 .643 r
.6886 .55508 .68969 .55896 .69036 .55348 .68925 .54923 Mtetra
.734 .545 .637 r
.68925 .54923 .69036 .55348 .69097 .54687 .68984 .54216 Mtetra
.736 .544 .632 r
.68984 .54216 .69097 .54687 .69154 .53933 .69039 .5341 Mtetra
.733 .539 .63 r
.69039 .5341 .69154 .53933 .69208 .53123 .69091 .52545 Mtetra
.723 .53 .629 r
.69091 .52545 .69208 .53123 .69262 .52317 .69143 .51683 Mtetra
.703 .515 .631 r
.69143 .51683 .69262 .52317 .6932 .5159 .69198 .50906 Mtetra
.669 .49 .635 r
.69198 .50906 .6932 .5159 .69384 .51023 .69261 .50301 Mtetra
.606 .447 .639 r
.69261 .50301 .69384 .51023 .69459 .50688 .69334 .49945 Mtetra
.486 .363 .638 r
.69334 .49945 .69459 .50688 .69546 .50627 .69422 .49883 Mtetra
.235 .189 .6 r
.69422 .49883 .69546 .50627 .69646 .50843 .69522 .50117 Mtetra
0 0 .434 r
.69522 .50117 .69646 .50843 .69757 .51296 .69635 .50606 Mtetra
0 0 .143 r
.69635 .50606 .69757 .51296 .69876 .51918 .69756 .51277 Mtetra
.867 .589 .06 r
.69756 .51277 .69876 .51918 .7 .52629 .69881 .52043 Mtetra
.922 .626 .147 r
.69881 .52043 .7 .52629 .70124 .53351 .70008 .52821 Mtetra
.931 .627 .161 r
.70008 .52821 .70124 .53351 .70247 .54023 .70133 .53546 Mtetra
.911 .602 .116 r
.70133 .53546 .70247 .54023 .70366 .54605 .70253 .54174 Mtetra
.842 .535 0 r
.70253 .54174 .70366 .54605 .70479 .55076 .70369 .54682 Mtetra
0 0 .22 r
.70369 .54682 .70479 .55076 .70588 .55428 .70478 .55064 Mtetra
0 0 .497 r
.70478 .55064 .70588 .55428 .70691 .55663 .70582 .55319 Mtetra
.162 .205 .659 r
.70582 .55319 .70691 .55663 .70788 .55785 .7068 .55453 Mtetra
.423 .373 .698 r
.7068 .55453 .70788 .55785 .70881 .55798 .70773 .5547 Mtetra
.561 .456 .692 r
.70773 .5547 .70881 .55798 .70969 .55703 .70861 .55372 Mtetra
.637 .499 .678 r
.70861 .55372 .70969 .55703 .71051 .55499 .70943 .55156 Mtetra
.682 .523 .664 r
.70943 .55156 .71051 .55499 .71128 .55182 .71018 .54818 Mtetra
.709 .535 .652 r
.71018 .54818 .71128 .55182 .71199 .54747 .71088 .54354 Mtetra
.725 .542 .643 r
.71088 .54354 .71199 .54747 .71264 .54193 .71152 .53762 Mtetra
.734 .544 .636 r
.71152 .53762 .71264 .54193 .71324 .53526 .71209 .53049 Mtetra
.736 .543 .631 r
.71209 .53049 .71324 .53526 .71379 .52767 .71261 .52237 Mtetra
.733 .538 .629 r
.71261 .52237 .71379 .52767 .71431 .51954 .7131 .51367 Mtetra
.722 .529 .629 r
.7131 .51367 .71431 .51954 .71483 .51148 .7136 .50506 Mtetra
.701 .513 .631 r
.7136 .50506 .71483 .51148 .71539 .50425 .71413 .49734 Mtetra
.665 .487 .635 r
.71413 .49734 .71539 .50425 .71603 .49868 .71475 .4914 Mtetra
.6 .442 .639 r
.71475 .4914 .71603 .49868 .71679 .49548 .7155 .48799 Mtetra
.475 .355 .637 r
.7155 .48799 .71679 .49548 .71768 .49504 .7164 .48755 Mtetra
.218 .178 .597 r
.7164 .48755 .71768 .49504 .71872 .49738 .71744 .49008 Mtetra
0 0 .43 r
.71744 .49008 .71872 .49738 .71988 .50208 .71862 .49516 Mtetra
0 0 .15 r
.71862 .49516 .71988 .50208 .72113 .50845 .71989 .50202 Mtetra
.857 .579 .045 r
.71989 .50202 .72113 .50845 .72243 .51567 .72121 .50979 Mtetra
.914 .617 .129 r
.72121 .50979 .72243 .51567 .72373 .52296 .72254 .51765 Mtetra
.922 .616 .14 r
.72254 .51765 .72373 .52296 .72501 .52973 .72385 .52494 Mtetra
.899 .589 .093 r
.72385 .52494 .72501 .52973 .72625 .53558 .72511 .53124 Mtetra
.822 .518 0 r
.72511 .53124 .72625 .53558 .72743 .54029 .72631 .53634 Mtetra
0 0 .248 r
.72631 .53634 .72743 .54029 .72855 .54382 .72744 .54016 Mtetra
0 0 .512 r
.72744 .54016 .72855 .54382 .72962 .54617 .72851 .54271 Mtetra
.174 .214 .663 r
.72851 .54271 .72962 .54617 .73062 .54738 .72952 .54403 Mtetra
.426 .375 .698 r
.72952 .54403 .73062 .54738 .73157 .54749 .73047 .54418 Mtetra
.562 .457 .692 r
.73047 .54418 .73157 .54749 .73246 .54652 .73136 .54317 Mtetra
.638 .499 .677 r
.73136 .54317 .73246 .54652 .73329 .54444 .73218 .54097 Mtetra
.682 .522 .663 r
.73218 .54097 .73329 .54444 .73406 .54123 .73294 .53754 Mtetra
.709 .535 .651 r
.73294 .53754 .73406 .54123 .73477 .53682 .73363 .53284 Mtetra
.725 .541 .642 r
.73363 .53284 .73477 .53682 .73541 .53122 .73425 .52686 Mtetra
.734 .543 .635 r
.73425 .52686 .73541 .53122 .73598 .52449 .7348 .51965 Mtetra
.736 .542 .63 r
.7348 .51965 .73598 .52449 .73651 .51684 .7353 .51147 Mtetra
.732 .537 .628 r
.7353 .51147 .73651 .51684 .737 .50867 .73577 .50274 Mtetra
.721 .527 .628 r
.73577 .50274 .737 .50867 .7375 .50061 .73623 .49412 Mtetra
.699 .511 .63 r
.73623 .49412 .7375 .50061 .73805 .49343 .73675 .48645 Mtetra
.662 .484 .634 r
.73675 .48645 .73805 .49343 .73868 .48797 .73737 .48061 Mtetra
.594 .437 .639 r
.73737 .48061 .73868 .48797 .73945 .48491 .73813 .47736 Mtetra
.464 .348 .636 r
.73813 .47736 .73945 .48491 .74038 .48465 .73905 .47711 Mtetra
.201 .166 .593 r
.73905 .47711 .74038 .48465 .74146 .48717 .74014 .47984 Mtetra
0 0 .426 r
.74014 .47984 .74146 .48717 .74268 .49205 .74138 .48509 Mtetra
0 0 .156 r
.74138 .48509 .74268 .49205 .74399 .49856 .74271 .49211 Mtetra
.848 .569 .03 r
.74271 .49211 .74399 .49856 .74535 .50589 .7441 .5 Mtetra
.904 .606 .11 r
.7441 .5 .74535 .50589 .74672 .51326 .7455 .50793 Mtetra
.912 .606 .119 r
.7455 .50793 .74672 .51326 .74806 .52008 .74687 .51528 Mtetra
.886 .576 .069 r
.74687 .51528 .74806 .52008 .74934 .52595 .74818 .52161 Mtetra
.802 .499 0 r
.74818 .52161 .74934 .52595 .75057 .53069 .74943 .52672 Mtetra
0 0 .275 r
.74943 .52672 .75057 .53069 .75173 .53422 .7506 .53054 Mtetra
0 0 .527 r
.7506 .53054 .75173 .53422 .75283 .53656 .75171 .53308 Mtetra
.186 .222 .666 r
.75171 .53308 .75283 .53656 .75386 .53776 .75274 .5344 Mtetra
.43 .378 .699 r
.75274 .5344 .75386 .53776 .75483 .53786 .75371 .53453 Mtetra
.563 .457 .692 r
.75371 .53453 .75483 .53786 .75573 .53686 .75461 .53348 Mtetra
.638 .499 .677 r
.75461 .53348 .75573 .53686 .75657 .53475 .75544 .53124 Mtetra
.682 .522 .662 r
.75544 .53124 .75657 .53475 .75734 .53149 .7562 .52777 Mtetra
.709 .535 .65 r
.7562 .52777 .75734 .53149 .75804 .52703 .75688 .523 Mtetra
.726 .541 .641 r
.75688 .523 .75804 .52703 .75867 .52136 .75749 .51694 Mtetra
.734 .543 .634 r
.75749 .51694 .75867 .52136 .75923 .51456 .75802 .50966 Mtetra
.736 .541 .629 r
.75802 .50966 .75923 .51456 .75973 .50684 .75849 .50141 Mtetra
.732 .536 .627 r
.75849 .50141 .75973 .50684 .7602 .49864 .75893 .49263 Mtetra
.72 .526 .627 r
.75893 .49263 .7602 .49864 .76068 .49058 .75937 .48401 Mtetra
.697 .509 .629 r
.75937 .48401 .76068 .49058 .76121 .48345 .75987 .47639 Mtetra
.658 .481 .634 r
.75987 .47639 .76121 .48345 .76184 .47808 .76048 .47066 Mtetra
.587 .433 .639 r
.76048 .47066 .76184 .47808 .76263 .47517 .76126 .46756 Mtetra
.452 .34 .635 r
.76126 .46756 .76263 .47517 .76358 .47509 .76221 .46749 Mtetra
.183 .155 .59 r
.76221 .46749 .76358 .47509 .76471 .47779 .76335 .47042 Mtetra
0 0 .422 r
.76335 .47042 .76471 .47779 .76598 .48285 .76464 .47586 Mtetra
0 0 .164 r
.76464 .47586 .76598 .48285 .76736 .48951 .76605 .48304 Mtetra
.838 .559 .015 r
.76605 .48304 .76736 .48951 .76879 .49695 .76751 .49104 Mtetra
.894 .596 .091 r
.76751 .49104 .76879 .49695 .77022 .5044 .76897 .49906 Mtetra
.901 .594 .098 r
.76897 .49906 .77022 .5044 .77162 .51127 .7704 .50646 Mtetra
.872 .562 .045 r
.7704 .50646 .77162 .51127 .77296 .51717 .77177 .51282 Mtetra
.781 .48 0 r
.77177 .51282 .77296 .51717 .77424 .52192 .77307 .51794 Mtetra
0 0 .3 r
.77307 .51794 .77424 .52192 .77544 .52545 .77429 .52176 Mtetra
0 0 .54 r
.77429 .52176 .77544 .52545 .77657 .52779 .77543 .5243 Mtetra
.197 .23 .67 r
.77543 .5243 .77657 .52779 .77763 .52898 .77649 .5256 Mtetra
.433 .38 .699 r
.77649 .5256 .77763 .52898 .77862 .52906 .77748 .52571 Mtetra
.564 .458 .692 r
.77748 .52571 .77862 .52906 .77953 .52804 .7784 .52463 Mtetra
.639 .499 .677 r
.7784 .52463 .77953 .52804 .78038 .52589 .77924 .52235 Mtetra
.683 .522 .662 r
.77924 .52235 .78038 .52589 .78115 .52257 .77999 .51881 Mtetra
.71 .534 .649 r
.77999 .51881 .78115 .52257 .78185 .51805 .78067 .51398 Mtetra
.726 .54 .64 r
.78067 .51398 .78185 .51805 .78246 .51231 .78126 .50784 Mtetra
.734 .542 .632 r
.78126 .50784 .78246 .51231 .783 .50543 .78176 .50048 Mtetra
.736 .54 .628 r
.78176 .50048 .783 .50543 .78348 .49765 .78221 .49215 Mtetra
.731 .535 .626 r
.78221 .49215 .78348 .49765 .78393 .48941 .78262 .48333 Mtetra
.719 .524 .626 r
.78262 .48333 .78393 .48941 .78438 .48134 .78303 .47469 Mtetra
.695 .507 .629 r
.78303 .47469 .78438 .48134 .7849 .47425 .78352 .46712 Mtetra
.654 .478 .634 r
.78352 .46712 .7849 .47425 .78553 .46898 .78413 .46149 Mtetra
.581 .428 .639 r
.78413 .46149 .78553 .46898 .78633 .46622 .78491 .45855 Mtetra
.441 .332 .635 r
.78491 .45855 .78633 .46622 .78732 .46631 .7859 .45867 Mtetra
.167 .145 .587 r
.7859 .45867 .78732 .46631 .78849 .46921 .78709 .4618 Mtetra
0 0 .42 r
.78709 .4618 .78849 .46921 .78983 .47443 .78845 .46743 Mtetra
0 0 .171 r
.78845 .46743 .78983 .47443 .79127 .48125 .78993 .47475 Mtetra
.827 .548 0 r
.78993 .47475 .79127 .48125 .79277 .4888 .79146 .48288 Mtetra
.884 .585 .072 r
.79146 .48288 .79277 .4888 .79427 .49633 .793 .49099 Mtetra
.89 .582 .077 r
.793 .49099 .79427 .49633 .79574 .50325 .79449 .49843 Mtetra
.857 .547 .02 r
.79449 .49843 .79574 .50325 .79714 .50918 .79592 .50482 Mtetra
.76 .461 0 r
.79592 .50482 .79714 .50918 .79846 .51394 .79727 .50996 Mtetra
0 0 .324 r
.79727 .50996 .79846 .51394 .79971 .51748 .79853 .51378 Mtetra
0 0 .553 r
.79853 .51378 .79971 .51748 .80087 .51981 .79971 .51631 Mtetra
.208 .238 .673 r
.79971 .51631 .80087 .51981 .80195 .52099 .8008 .51759 Mtetra
.437 .383 .7 r
.8008 .51759 .80195 .52099 .80296 .52104 .80181 .51767 Mtetra
.566 .459 .692 r
.80181 .51767 .80296 .52104 .8039 .51999 .80274 .51656 Mtetra
.64 .5 .676 r
.80274 .51656 .8039 .51999 .80475 .51779 .80359 .51423 Mtetra
.684 .522 .661 r
.80359 .51423 .80475 .51779 .80553 .51442 .80434 .51063 Mtetra
.711 .534 .648 r
.80434 .51063 .80553 .51442 .80621 .50983 .80501 .50572 Mtetra
.727 .54 .638 r
.80501 .50572 .80621 .50983 .80681 .50401 .80558 .49949 Mtetra
.735 .542 .631 r
.80558 .49949 .80681 .50401 .80733 .49705 .80606 .49204 Mtetra
.736 .539 .627 r
.80606 .49204 .80733 .49705 .80778 .4892 .80648 .48363 Mtetra
.731 .534 .625 r
.80648 .48363 .80778 .4892 .8082 .4809 .80686 .47475 Mtetra
.718 .523 .625 r
.80686 .47475 .8082 .4809 .80863 .47282 .80725 .46611 Mtetra
.693 .505 .628 r
.80725 .46611 .80863 .47282 .80914 .46578 .80771 .45857 Mtetra
.651 .475 .633 r
.80771 .45857 .80914 .46578 .80977 .46061 .80832 .45305 Mtetra
.574 .423 .638 r
.80832 .45305 .80977 .46061 .81059 .45798 .80913 .45026 Mtetra
.429 .325 .634 r
.80913 .45026 .81059 .45798 .81161 .45826 .81015 .45057 Mtetra
.151 .135 .584 r
.81015 .45057 .81161 .45826 .81284 .46134 .8114 .45389 Mtetra
0 0 .418 r
.8114 .45389 .81284 .46134 .81424 .46674 .81282 .45971 Mtetra
0 0 .18 r
.81282 .45971 .81424 .46674 .81576 .4737 .81437 .46719 Mtetra
.816 .536 0 r
.81437 .46719 .81576 .4737 .81733 .48137 .81598 .47544 Mtetra
.872 .573 .053 r
.81598 .47544 .81733 .48137 .8189 .48898 .8176 .48362 Mtetra
.877 .569 .055 r
.8176 .48362 .8189 .48898 .82043 .49594 .81916 .49112 Mtetra
.841 .531 0 r
.81916 .49112 .82043 .49594 .82189 .5019 .82065 .49754 Mtetra
.736 .44 0 r
.82065 .49754 .82189 .5019 .82327 .50667 .82205 .50268 Mtetra
0 0 .348 r
.82205 .50268 .82327 .50667 .82455 .51021 .82336 .5065 Mtetra
0 .012 .565 r
.82336 .5065 .82455 .51021 .82575 .51253 .82457 .50902 Mtetra
.219 .247 .677 r
.82457 .50902 .82575 .51253 .82687 .51369 .82569 .51028 Mtetra
.442 .387 .701 r
.82569 .51028 .82687 .51369 .8279 .51372 .82673 .51033 Mtetra
.568 .461 .692 r
.82673 .51033 .8279 .51372 .82885 .51263 .82767 .50918 Mtetra
.641 .5 .676 r
.82767 .50918 .82885 .51263 .82971 .51038 .82852 .50679 Mtetra
.685 .522 .66 r
.82852 .50679 .82971 .51038 .83048 .50695 .82928 .50312 Mtetra
.712 .534 .647 r
.82928 .50312 .83048 .50695 .83116 .50228 .82993 .49812 Mtetra
.727 .54 .637 r
.82993 .49812 .83116 .50228 .83175 .49637 .83048 .4918 Mtetra
.735 .541 .63 r
.83048 .4918 .83175 .49637 .83224 .48932 .83094 .48425 Mtetra
.736 .539 .626 r
.83094 .48425 .83224 .48932 .83267 .48139 .83132 .47576 Mtetra
.731 .533 .624 r
.83132 .47576 .83267 .48139 .83306 .47304 .83167 .46682 Mtetra
.717 .521 .624 r
.83167 .46682 .83306 .47304 .83347 .46495 .83204 .45815 Mtetra
.691 .503 .628 r
.83204 .45815 .83347 .46495 .83396 .45794 .83249 .45066 Mtetra
.647 .472 .633 r
.83249 .45066 .83396 .45794 .83459 .45286 .8331 .44523 Mtetra
.567 .418 .638 r
.8331 .44523 .83459 .45286 .83543 .45038 .83392 .44259 Mtetra
.418 .317 .633 r
.83392 .44259 .83543 .45038 .83649 .45083 .83498 .44309 Mtetra
.136 .126 .581 r
.83498 .44309 .83649 .45083 .83778 .4541 .83629 .44661 Mtetra
0 0 .417 r
.83629 .44661 .83778 .4541 .83924 .45967 .83778 .45261 Mtetra
0 0 .19 r
.83778 .45261 .83924 .45967 .84084 .46678 .83941 .46025 Mtetra
.803 .524 0 r
.83941 .46025 .84084 .46678 .84248 .47456 .8411 .46861 Mtetra
.859 .56 .032 r
.8411 .46861 .84248 .47456 .84413 .48224 .84279 .47688 Mtetra
.863 .555 .031 r
.84279 .47688 .84413 .48224 .84573 .48925 .84443 .48443 Mtetra
.823 .515 0 r
.84443 .48443 .84573 .48925 .84725 .49524 .84598 .49087 Mtetra
.712 .419 0 r
.84598 .49087 .84725 .49524 .84868 .50002 .84744 .49602 Mtetra
0 0 .372 r
.84744 .49602 .84868 .50002 .85001 .50355 .84879 .49983 Mtetra
0 .03 .577 r
.84879 .49983 .85001 .50355 .85124 .50586 .85004 .50234 Mtetra
.231 .255 .68 r
.85004 .50234 .85124 .50586 .85239 .507 .85119 .50358 Mtetra
.447 .39 .701 r
.85119 .50358 .85239 .507 .85344 .507 .85225 .50359 Mtetra
.57 .462 .692 r
.85225 .50359 .85344 .507 .85441 .50586 .85321 .50239 Mtetra
.642 .501 .675 r
.85321 .50239 .85441 .50586 .85528 .50356 .85406 .49994 Mtetra
.686 .523 .659 r
.85406 .49994 .85528 .50356 .85605 .50006 .85482 .49619 Mtetra
.713 .534 .646 r
.85482 .49619 .85605 .50006 .85672 .4953 .85546 .4911 Mtetra
.728 .54 .636 r
.85546 .4911 .85672 .4953 .85729 .4893 .85599 .48468 Mtetra
.736 .541 .629 r
.85599 .48468 .85729 .4893 .85776 .48215 .85642 .47702 Mtetra
.737 .538 .624 r
.85642 .47702 .85776 .48215 .85815 .47414 .85677 .46844 Mtetra
.73 .532 .623 r
.85677 .46844 .85815 .47414 .85852 .46572 .85709 .45943 Mtetra
.716 .52 .623 r
.85709 .45943 .85852 .46572 .8589 .45761 .85742 .45074 Mtetra
.689 .501 .627 r
.85742 .45074 .8589 .45761 .85938 .45063 .85786 .44328 Mtetra
.643 .469 .633 r
.85786 .44328 .85938 .45063 .86001 .44565 .85847 .43795 Mtetra
.561 .413 .638 r
.85847 .43795 .86001 .44565 .86087 .44331 .85931 .43546 Mtetra
.407 .31 .632 r
.85931 .43546 .86087 .44331 .86198 .44393 .86042 .43614 Mtetra
.122 .117 .579 r
.86042 .43614 .86198 .44393 .86332 .44738 .86178 .43986 Mtetra
0 0 .417 r
.86178 .43986 .86332 .44738 .86486 .45313 .86336 .44604 Mtetra
0 0 .201 r
.86336 .44604 .86486 .45313 .86653 .46038 .86507 .45383 Mtetra
.79 .511 0 r
.86507 .45383 .86653 .46038 .86826 .46827 .86685 .46231 Mtetra
.846 .546 .01 r
.86685 .46231 .86826 .46827 .86998 .47603 .86862 .47066 Mtetra
.848 .54 .007 r
.86862 .47066 .86998 .47603 .87165 .48309 .87033 .47825 Mtetra
.804 .496 0 r
.87033 .47825 .87165 .48309 .87323 .48909 .87195 .48472 Mtetra
.686 .396 0 r
.87195 .48472 .87323 .48909 .87472 .49388 .87346 .48987 Mtetra
0 0 .396 r
.87346 .48987 .87472 .49388 .87609 .4974 .87486 .49368 Mtetra
0 .049 .589 r
.87486 .49368 .87609 .4974 .87737 .4997 .87615 .49616 Mtetra
.243 .264 .684 r
.87615 .49616 .87737 .4997 .87854 .50081 .87733 .49737 Mtetra
.452 .394 .702 r
.87733 .49737 .87854 .50081 .87962 .50077 .87841 .49735 Mtetra
.573 .464 .691 r
.87841 .49735 .87962 .50077 .8806 .49959 .87938 .49609 Mtetra
.644 .502 .675 r
.87938 .49609 .8806 .49959 .88148 .49722 .88024 .49357 Mtetra
.687 .523 .658 r
.88024 .49357 .88148 .49722 .88225 .49364 .88099 .48974 Mtetra
.714 .534 .645 r
.88099 .48974 .88225 .49364 .88291 .4888 .88162 .48455 Mtetra
.729 .539 .635 r
.88162 .48455 .88291 .4888 .88345 .48269 .88213 .47802 Mtetra
.737 .54 .627 r
.88213 .47802 .88345 .48269 .8839 .47544 .88253 .47025 Mtetra
.737 .537 .623 r
.88253 .47025 .8839 .47544 .88427 .46733 .88285 .46156 Mtetra
.73 .531 .621 r
.88285 .46156 .88427 .46733 .8846 .45885 .88312 .45248 Mtetra
.715 .519 .623 r
.88312 .45248 .8846 .45885 .88496 .45071 .88343 .44376 Mtetra
.687 .499 .626 r
.88343 .44376 .88496 .45071 .88542 .44376 .88385 .43633 Mtetra
.639 .466 .633 r
.88385 .43633 .88542 .44376 .88606 .43886 .88446 .4311 Mtetra
.554 .408 .638 r
.88446 .4311 .88606 .43886 .88694 .43667 .88533 .42876 Mtetra
.396 .303 .632 r
.88533 .42876 .88694 .43667 .88809 .43746 .88649 .42963 Mtetra
.109 .11 .577 r
.88649 .42963 .88809 .43746 .8895 .4411 .88792 .43354 Mtetra
0 0 .419 r
.88792 .43354 .8895 .4411 .89112 .44702 .88957 .4399 Mtetra
0 0 .213 r
.88957 .4399 .89112 .44702 .89287 .45441 .89137 .44785 Mtetra
.775 .497 0 r
.89137 .44785 .89287 .45441 .89468 .46241 .89323 .45644 Mtetra
.83 .532 0 r
.89323 .45644 .89468 .46241 .89648 .47024 .89508 .46486 Mtetra
.831 .524 0 r
.89508 .46486 .89648 .47024 .89823 .47734 .89687 .4725 Mtetra
.782 .477 0 r
.89687 .4725 .89823 .47734 .89987 .48337 .89856 .47898 Mtetra
0 0 .222 r
.89856 .47898 .89987 .48337 .90141 .48815 .90013 .48414 Mtetra
0 0 .419 r
.90013 .48414 .90141 .48815 .90284 .49167 .90158 .48794 Mtetra
0 .067 .6 r
.90158 .48794 .90284 .49167 .90415 .49395 .9029 .4904 Mtetra
.255 .273 .687 r
.9029 .4904 .90415 .49395 .90536 .49503 .90412 .49157 Mtetra
.457 .398 .703 r
.90412 .49157 .90536 .49503 .90645 .49495 .90522 .4915 Mtetra
.576 .466 .691 r
.90522 .4915 .90645 .49495 .90745 .49371 .9062 .49018 Mtetra
.646 .503 .674 r
.9062 .49018 .90745 .49371 .90833 .49128 .90707 .48759 Mtetra
.689 .523 .657 r
.90707 .48759 .90833 .49128 .9091 .48761 .90781 .48367 Mtetra
.715 .534 .644 r
.90781 .48367 .9091 .48761 .90975 .48267 .90843 .47838 Mtetra
.73 .539 .633 r
.90843 .47838 .90975 .48267 .91027 .47645 .90892 .47172 Mtetra
.737 .54 .626 r
.90892 .47172 .91027 .47645 .91069 .46909 .90928 .46384 Mtetra
.737 .537 .622 r
.90928 .46384 .91069 .46909 .91103 .46088 .90956 .45504 Mtetra
.73 .53 .62 r
.90956 .45504 .91103 .46088 .91132 .45232 .90981 .44587 Mtetra
.714 .517 .622 r
.90981 .44587 .91132 .45232 .91166 .44415 .91008 .43713 Mtetra
.685 .497 .626 r
.91008 .43713 .91166 .44415 .91211 .43724 .91049 .42972 Mtetra
.635 .463 .632 r
.91049 .42972 .91211 .43724 .91275 .43243 .9111 .42458 Mtetra
.547 .404 .638 r
.9111 .42458 .91275 .43243 .91366 .43037 .912 .42239 Mtetra
.385 .296 .631 r
.912 .42239 .91366 .43037 .91486 .43134 .9132 .42345 Mtetra
.098 .103 .575 r
.9132 .42345 .91486 .43134 .91634 .43516 .9147 .42755 Mtetra
0 0 .421 r
.9147 .42755 .91634 .43516 .91803 .44124 .91644 .4341 Mtetra
0 0 .226 r
.91644 .4341 .91803 .44124 .91987 .44878 .91833 .44219 Mtetra
.759 .482 0 r
.91833 .44219 .91987 .44878 .92177 .45688 .92028 .4509 Mtetra
.813 .516 0 r
.92028 .4509 .92177 .45688 .92366 .46478 .92222 .45939 Mtetra
.812 .506 0 r
.92222 .45939 .92366 .46478 .92547 .47192 .92409 .46707 Mtetra
.759 .456 0 r
.92409 .46707 .92547 .47192 .92719 .47797 .92584 .47358 Mtetra
0 0 .251 r
.92584 .47358 .92719 .47797 .92878 .48276 .92747 .47873 Mtetra
0 0 .442 r
.92747 .47873 .92878 .48276 .93026 .48626 .92897 .48251 Mtetra
0 .085 .611 r
.92897 .48251 .93026 .48626 .93161 .48851 .93034 .48495 Mtetra
.268 .282 .69 r
.93034 .48495 .93161 .48851 .93285 .48956 .93159 .48609 Mtetra
.463 .402 .703 r
.93159 .48609 .93285 .48956 .93397 .48943 .93271 .48597 Mtetra
.579 .468 .691 r
.93271 .48597 .93397 .48943 .93498 .48813 .93371 .48458 Mtetra
.648 .504 .673 r
.93371 .48458 .93498 .48813 .93586 .48563 .93458 .48191 Mtetra
.69 .524 .656 r
.93458 .48191 .93586 .48563 .93663 .48187 .93532 .47789 Mtetra
.716 .534 .643 r
.93532 .47789 .93663 .48187 .93726 .47682 .93591 .47248 Mtetra
.731 .539 .632 r
.93591 .47248 .93726 .47682 .93777 .47049 .93637 .4657 Mtetra
.738 .539 .625 r
.93637 .4657 .93777 .47049 .93815 .46302 .93671 .45769 Mtetra
.738 .536 .62 r
.93671 .45769 .93815 .46302 .93845 .4547 .93695 .44878 Mtetra
.73 .528 .619 r
.93695 .44878 .93845 .4547 .93872 .44606 .93715 .43953 Mtetra
.713 .516 .621 r
.93715 .43953 .93872 .44606 .93903 .43786 .9374 .43075 Mtetra
.683 .494 .625 r
.9374 .43075 .93903 .43786 .93946 .43097 .93779 .42337 Mtetra
.631 .459 .632 r
.93779 .42337 .93946 .43097 .94012 .42625 .93841 .41832 Mtetra
.54 .399 .638 r
.93841 .41832 .94012 .42625 .94105 .42433 .93933 .41628 Mtetra
.374 .289 .63 r
.93933 .41628 .94105 .42433 .9423 .42547 .94059 .41752 Mtetra
.087 .097 .573 r
.94059 .41752 .9423 .42547 .94385 .42947 .94216 .42182 Mtetra
0 0 .425 r
.94216 .42182 .94385 .42947 .94563 .43573 .94399 .42855 Mtetra
0 0 .24 r
.94399 .42855 .94563 .43573 .94756 .4434 .94597 .43679 Mtetra
.742 .466 0 r
.94597 .43679 .94756 .4434 .94955 .45161 .94802 .44561 Mtetra
.795 .499 0 r
.94802 .44561 .94955 .45161 .95152 .45958 .95005 .45418 Mtetra
.792 .488 0 r
.95005 .45418 .95152 .45958 .95342 .46676 .952 .4619 Mtetra
.734 .434 0 r
.952 .4619 .95342 .46676 .9552 .47282 .95383 .46842 Mtetra
0 0 .28 r
.95383 .46842 .9552 .47282 .95685 .4776 .95552 .47357 Mtetra
0 0 .464 r
.95552 .47357 .95685 .4776 .95838 .48109 .95707 .47733 Mtetra
0 .103 .621 r
.95707 .47733 .95838 .48109 .95977 .48332 .95848 .47974 Mtetra
.28 .291 .693 r
.95848 .47974 .95977 .48332 .96104 .48433 .95976 .48083 Mtetra
.469 .406 .704 r
.95976 .48083 .96104 .48433 .96218 .48415 .9609 .48066 Mtetra
.582 .47 .69 r
.9609 .48066 .96218 .48415 .96321 .48279 .96191 .47921 Mtetra
.65 .505 .672 r
.96191 .47921 .96321 .48279 .9641 .4802 .96279 .47645 Mtetra
.692 .524 .655 r
.96279 .47645 .9641 .4802 .96486 .47635 .96352 .47233 Mtetra
.718 .534 .641 r
.96352 .47233 .96486 .47635 .96548 .47119 .9641 .4668 Mtetra
.732 .539 .631 r
.9641 .4668 .96548 .47119 .96596 .46474 .96453 .45989 Mtetra
.739 .539 .623 r
.96453 .45989 .96596 .46474 .96631 .45714 .96483 .45174 Mtetra
.738 .535 .619 r
.96483 .45174 .96631 .45714 .96658 .44871 .96503 .44271 Mtetra
.73 .527 .618 r
.96503 .44271 .96658 .44871 .96681 .43999 .96519 .43337 Mtetra
.712 .514 .62 r
.96519 .43337 .96681 .43999 .96708 .43175 .96541 .42455 Mtetra
.681 .492 .624 r
.96541 .42455 .96708 .43175 .96751 .42488 .96578 .4172 Mtetra
.627 .456 .632 r
.96578 .4172 .96751 .42488 .96817 .42025 .9664 .41224 Mtetra
.533 .394 .638 r
.9664 .41224 .96817 .42025 .96914 .41847 .96736 .41035 Mtetra
.32 .268 .642 r
.51084 .62061 .51178 .62533 .51254 .62617 .5116 .6215 Mtetra
0 0 .199 r
.5116 .6215 .51254 .62617 .51331 .62966 .51238 .62518 Mtetra
.974 .675 .295 r
.51238 .62518 .51331 .62966 .5141 .63523 .51317 .63102 Mtetra
.972 .682 .417 r
.51317 .63102 .5141 .63523 .5149 .64209 .51396 .63821 Mtetra
.958 .673 .454 r
.51396 .63821 .5149 .64209 .5157 .64939 .51476 .64586 Mtetra
.951 .666 .461 r
.51476 .64586 .5157 .64939 .5165 .65644 .51557 .65325 Mtetra
.951 .66 .451 r
.51557 .65325 .5165 .65644 .5173 .66272 .51637 .65984 Mtetra
.956 .653 .419 r
.51637 .65984 .5173 .66272 .5181 .66793 .51717 .66531 Mtetra
.962 .638 .346 r
.51717 .66531 .5181 .66793 .5189 .67195 .51796 .66954 Mtetra
.932 .574 .155 r
.51796 .66954 .5189 .67195 .51968 .67475 .51875 .67249 Mtetra
0 0 .374 r
.51875 .67249 .51968 .67475 .52047 .67637 .51953 .67421 Mtetra
.265 .321 .734 r
.51953 .67421 .52047 .67637 .52124 .67686 .5203 .67474 Mtetra
.565 .491 .731 r
.5203 .67474 .52124 .67686 .52201 .67623 .52107 .67412 Mtetra
.669 .543 .701 r
.52107 .67412 .52201 .67623 .52277 .6745 .52183 .67233 Mtetra
.717 .563 .679 r
.52183 .67233 .52277 .6745 .52353 .67163 .52259 .66936 Mtetra
.742 .572 .664 r
.52259 .66936 .52353 .67163 .52427 .66758 .52333 .66514 Mtetra
.756 .576 .653 r
.52333 .66514 .52427 .66758 .525 .6623 .52407 .65966 Mtetra
.764 .577 .645 r
.52407 .65966 .525 .6623 .52573 .65583 .52479 .65291 Mtetra
.767 .577 .64 r
.52479 .65291 .52573 .65583 .52644 .64829 .5255 .64506 Mtetra
.767 .574 .637 r
.5255 .64506 .52644 .64829 .52715 .64 .52621 .63643 Mtetra
.762 .569 .636 r
.52621 .63643 .52715 .64 .52786 .63147 .52691 .62755 Mtetra
.751 .56 .637 r
.52691 .62755 .52786 .63147 .52856 .62344 .52761 .61918 Mtetra
.731 .546 .642 r
.52761 .61918 .52856 .62344 .52927 .61672 .52833 .6122 Mtetra
.69 .518 .649 r
.52833 .6122 .52927 .61672 .53001 .61213 .52905 .60742 Mtetra
.596 .455 .66 r
.52905 .60742 .53001 .61213 .53076 .61022 .52981 .60546 Mtetra
.294 .251 .638 r
.52981 .60546 .53076 .61022 .53154 .61121 .53059 .60651 Mtetra
0 0 .185 r
.53059 .60651 .53154 .61121 .53234 .61484 .53139 .61033 Mtetra
.972 .672 .287 r
.53139 .61033 .53234 .61484 .53317 .62052 .53222 .61629 Mtetra
.973 .68 .408 r
.53222 .61629 .53317 .62052 .53401 .62745 .53306 .62355 Mtetra
.96 .673 .445 r
.53306 .62355 .53401 .62745 .53485 .6348 .5339 .63125 Mtetra
.954 .666 .452 r
.5339 .63125 .53485 .6348 .5357 .64185 .53475 .63864 Mtetra
.954 .659 .44 r
.53475 .63864 .5357 .64185 .53654 .64811 .5356 .64521 Mtetra
.958 .652 .405 r
.5356 .64521 .53654 .64811 .53738 .65329 .53643 .65065 Mtetra
.963 .633 .325 r
.53643 .65065 .53738 .65329 .5382 .65727 .53726 .65483 Mtetra
.917 .557 .113 r
.53726 .65483 .5382 .65727 .53902 .66003 .53807 .65774 Mtetra
0 0 .428 r
.53807 .65774 .53902 .66003 .53982 .6616 .53887 .65941 Mtetra
.292 .336 .736 r
.53887 .65941 .53982 .6616 .54061 .66204 .53966 .65989 Mtetra
.571 .493 .729 r
.53966 .65989 .54061 .66204 .54139 .66136 .54044 .65921 Mtetra
.671 .543 .7 r
.54044 .65921 .54139 .66136 .54216 .65957 .54121 .65737 Mtetra
.717 .563 .678 r
.54121 .65737 .54216 .65957 .54291 .65664 .54196 .65432 Mtetra
.742 .572 .663 r
.54196 .65432 .54291 .65664 .54365 .65251 .5427 .65003 Mtetra
.757 .576 .652 r
.5427 .65003 .54365 .65251 .54438 .64715 .54343 .64446 Mtetra
.765 .577 .644 r
.54343 .64446 .54438 .64715 .54509 .6406 .54414 .63764 Mtetra
.768 .576 .639 r
.54414 .63764 .54509 .6406 .54579 .63299 .54483 .62971 Mtetra
.767 .573 .636 r
.54483 .62971 .54579 .63299 .54647 .62464 .54551 .62102 Mtetra
.762 .568 .635 r
.54551 .62102 .54647 .62464 .54715 .61609 .54619 .61211 Mtetra
.75 .559 .637 r
.54619 .61211 .54715 .61609 .54784 .60807 .54687 .60376 Mtetra
.729 .544 .641 r
.54687 .60376 .54784 .60807 .54854 .60142 .54757 .59684 Mtetra
.686 .515 .649 r
.54757 .59684 .54854 .60142 .54927 .59694 .5483 .59219 Mtetra
.587 .449 .66 r
.5483 .59219 .54927 .59694 .55003 .59518 .54906 .59037 Mtetra
.268 .233 .633 r
.54906 .59037 .55003 .59518 .55083 .59631 .54986 .59158 Mtetra
0 0 .173 r
.54986 .59158 .55083 .59631 .55167 .60009 .55069 .59555 Mtetra
.971 .669 .279 r
.55069 .59555 .55167 .60009 .55253 .60588 .55156 .60163 Mtetra
.974 .679 .399 r
.55156 .60163 .55253 .60588 .55342 .61289 .55245 .60897 Mtetra
.962 .672 .436 r
.55245 .60897 .55342 .61289 .55431 .62027 .55334 .6167 Mtetra
.956 .665 .442 r
.55334 .6167 .55431 .62027 .5552 .62733 .55424 .6241 Mtetra
.956 .658 .429 r
.55424 .6241 .5552 .62733 .55608 .63358 .55512 .63066 Mtetra
.961 .65 .39 r
.55512 .63066 .55608 .63358 .55695 .63873 .55599 .63607 Mtetra
.962 .628 .301 r
.55599 .63607 .55695 .63873 .55781 .64268 .55685 .64021 Mtetra
.898 .536 .069 r
.55685 .64021 .55781 .64268 .55865 .64539 .55769 .64308 Mtetra
0 0 .476 r
.55769 .64308 .55865 .64539 .55947 .64692 .55851 .6447 Mtetra
.316 .35 .738 r
.55851 .6447 .55947 .64692 .56028 .64731 .55932 .64514 Mtetra
.575 .495 .727 r
.55932 .64514 .56028 .64731 .56107 .64659 .56011 .6444 Mtetra
.672 .543 .698 r
.56011 .6444 .56107 .64659 .56184 .64474 .56089 .6425 Mtetra
.718 .562 .677 r
.56089 .6425 .56184 .64474 .5626 .64174 .56164 .63939 Mtetra
.743 .571 .662 r
.56164 .63939 .5626 .64174 .56334 .63754 .56238 .63502 Mtetra
.757 .575 .651 r
.56238 .63502 .56334 .63754 .56405 .63211 .56309 .62937 Mtetra
.765 .576 .643 r
.56309 .62937 .56405 .63211 .56475 .62547 .56378 .62246 Mtetra
.768 .575 .638 r
.56378 .62246 .56475 .62547 .56543 .61779 .56446 .61446 Mtetra
.767 .572 .635 r
.56446 .61446 .56543 .61779 .56609 .60939 .56511 .60571 Mtetra
.761 .567 .634 r
.56511 .60571 .56609 .60939 .56675 .60082 .56577 .59678 Mtetra
.75 .558 .636 r
.56577 .59678 .56675 .60082 .56742 .59282 .56643 .58846 Mtetra
.727 .542 .641 r
.56643 .58846 .56742 .59282 .5681 .58625 .56711 .58161 Mtetra
.682 .512 .649 r
.56711 .58161 .5681 .58625 .56883 .58188 .56783 .57708 Mtetra
.577 .442 .66 r
.56783 .57708 .56883 .58188 .5696 .58026 .5686 .57541 Mtetra
.241 .214 .627 r
.5686 .57541 .5696 .58026 .57042 .58155 .56943 .57678 Mtetra
0 0 .163 r
.56943 .57678 .57042 .58155 .57129 .58547 .5703 .5809 Mtetra
.969 .665 .27 r
.5703 .5809 .57129 .58547 .5722 .59138 .57121 .5871 Mtetra
.974 .677 .389 r
.57121 .5871 .5722 .59138 .57313 .59847 .57214 .59452 Mtetra
.964 .671 .426 r
.57214 .59452 .57313 .59847 .57407 .60589 .57309 .6023 Mtetra
.959 .664 .432 r
.57309 .6023 .57407 .60589 .57501 .61297 .57403 .60972 Mtetra
.959 .657 .416 r
.57403 .60972 .57501 .61297 .57593 .6192 .57496 .61626 Mtetra
.963 .647 .374 r
.57496 .61626 .57593 .6192 .57684 .62433 .57587 .62164 Mtetra
.96 .621 .277 r
.57587 .62164 .57684 .62433 .57773 .62824 .57676 .62575 Mtetra
.875 .513 .023 r
.57676 .62575 .57773 .62824 .57859 .63092 .57762 .62858 Mtetra
0 0 .516 r
.57762 .62858 .57859 .63092 .57943 .63241 .57847 .63016 Mtetra
.336 .361 .738 r
.57847 .63016 .57943 .63241 .58026 .63276 .57929 .63055 Mtetra
.58 .496 .725 r
.57929 .63055 .58026 .63276 .58106 .63198 .58009 .62976 Mtetra
.673 .542 .697 r
.58009 .62976 .58106 .63198 .58184 .63008 .58087 .6278 Mtetra
.719 .562 .676 r
.58087 .6278 .58184 .63008 .5826 .62702 .58163 .62463 Mtetra
.743 .571 .66 r
.58163 .62463 .5826 .62702 .58333 .62275 .58236 .62019 Mtetra
.757 .575 .649 r
.58236 .62019 .58333 .62275 .58404 .61724 .58306 .61446 Mtetra
.765 .576 .642 r
.58306 .61446 .58404 .61724 .58472 .61053 .58374 .60747 Mtetra
.768 .575 .637 r
.58374 .60747 .58472 .61053 .58538 .60278 .58439 .59939 Mtetra
.767 .572 .634 r
.58439 .59939 .58538 .60278 .58602 .59433 .58502 .59059 Mtetra
.761 .566 .633 r
.58502 .59059 .58602 .59433 .58665 .58574 .58565 .58165 Mtetra
.749 .557 .635 r
.58565 .58165 .58665 .58574 .5873 .57777 .58629 .57335 Mtetra
.725 .54 .64 r
.58629 .57335 .5873 .57777 .58797 .57127 .58696 .56658 Mtetra
.678 .509 .649 r
.58696 .56658 .58797 .57127 .5887 .56702 .58768 .56217 Mtetra
.567 .435 .66 r
.58768 .56217 .5887 .56702 .58948 .56556 .58846 .56067 Mtetra
.212 .195 .621 r
.58846 .56067 .58948 .56556 .59033 .56701 .58931 .5622 Mtetra
0 0 .153 r
.58931 .5622 .59033 .56701 .59123 .57108 .59022 .56648 Mtetra
.966 .661 .261 r
.59022 .56648 .59123 .57108 .59218 .57711 .59117 .5728 Mtetra
.975 .675 .379 r
.59117 .5728 .59218 .57711 .59316 .58428 .59216 .58031 Mtetra
.966 .669 .415 r
.59216 .58031 .59316 .58428 .59415 .59175 .59316 .58814 Mtetra
.961 .663 .421 r
.59316 .58814 .59415 .59175 .59514 .59884 .59415 .59556 Mtetra
.961 .656 .403 r
.59415 .59556 .59514 .59884 .59611 .60507 .59512 .6021 Mtetra
.964 .644 .357 r
.59512 .6021 .59611 .60507 .59705 .61017 .59607 .60746 Mtetra
.956 .613 .251 r
.59607 .60746 .59705 .61017 .59797 .61405 .59699 .61154 Mtetra
.848 .487 0 r
.59699 .61154 .59797 .61405 .59886 .6167 .59788 .61433 Mtetra
0 0 .55 r
.59788 .61433 .59886 .6167 .59973 .61815 .59875 .61587 Mtetra
.353 .37 .739 r
.59875 .61587 .59973 .61815 .60057 .61846 .59959 .61622 Mtetra
.583 .497 .723 r
.59959 .61622 .60057 .61846 .60138 .61764 .6004 .61539 Mtetra
.674 .542 .696 r
.6004 .61539 .60138 .61764 .60217 .61569 .60119 .61337 Mtetra
.719 .561 .675 r
.60119 .61337 .60217 .61569 .60292 .61257 .60194 .61014 Mtetra
.743 .57 .659 r
.60194 .61014 .60292 .61257 .60365 .60824 .60267 .60563 Mtetra
.758 .574 .648 r
.60267 .60563 .60365 .60824 .60435 .60265 .60336 .59982 Mtetra
.765 .575 .641 r
.60336 .59982 .60435 .60265 .60501 .59587 .60402 .59275 Mtetra
.768 .574 .636 r
.60402 .59275 .60501 .59587 .60565 .58805 .60465 .58461 Mtetra
.767 .571 .633 r
.60465 .58461 .60565 .58805 .60627 .57955 .60526 .57576 Mtetra
.761 .565 .632 r
.60526 .57576 .60627 .57955 .60688 .57095 .60586 .5668 Mtetra
.748 .555 .635 r
.60586 .5668 .60688 .57095 .60751 .56301 .60648 .55853 Mtetra
.723 .538 .64 r
.60648 .55853 .60751 .56301 .60817 .55659 .60714 .55185 Mtetra
.673 .505 .649 r
.60714 .55185 .60817 .55659 .60889 .55247 .60786 .54757 Mtetra
.556 .427 .66 r
.60786 .54757 .60889 .55247 .60969 .55116 .60865 .54623 Mtetra
.183 .175 .614 r
.60865 .54623 .60969 .55116 .61056 .55278 .60952 .54794 Mtetra
.695 .446 0 r
.60952 .54794 .61056 .55278 .61151 .557 .61047 .55237 Mtetra
.964 .657 .252 r
.61047 .55237 .61151 .557 .6125 .56316 .61148 .55882 Mtetra
.975 .672 .368 r
.61148 .55882 .6125 .56316 .61353 .57041 .61251 .56642 Mtetra
.967 .668 .404 r
.61251 .56642 .61353 .57041 .61458 .57793 .61356 .5743 Mtetra
.963 .661 .409 r
.61356 .5743 .61458 .57793 .61561 .58504 .6146 .58175 Mtetra
.963 .654 .39 r
.6146 .58175 .61561 .58504 .61662 .59127 .61562 .58828 Mtetra
.964 .641 .339 r
.61562 .58828 .61662 .59127 .6176 .59636 .61661 .59363 Mtetra
.951 .604 .223 r
.61661 .59363 .6176 .59636 .61856 .60022 .61757 .59768 Mtetra
.818 .46 0 r
.61757 .59768 .61856 .60022 .61948 .60284 .61849 .60044 Mtetra
0 .007 .578 r
.61849 .60044 .61948 .60284 .62036 .60426 .61938 .60195 Mtetra
.368 .377 .738 r
.61938 .60195 .62036 .60426 .62122 .60453 .62023 .60226 Mtetra
.586 .498 .722 r
.62023 .60226 .62122 .60453 .62204 .60367 .62106 .60138 Mtetra
.675 .542 .695 r
.62106 .60138 .62204 .60367 .62284 .60167 .62185 .59932 Mtetra
.719 .561 .674 r
.62185 .59932 .62284 .60167 .6236 .5985 .6226 .59602 Mtetra
.744 .57 .658 r
.6226 .59602 .6236 .5985 .62432 .5941 .62332 .59144 Mtetra
.758 .574 .647 r
.62332 .59144 .62432 .5941 .625 .58845 .624 .58556 Mtetra
.766 .575 .639 r
.624 .58556 .625 .58845 .62565 .58159 .62464 .57842 Mtetra
.769 .573 .634 r
.62464 .57842 .62565 .58159 .62627 .57371 .62524 .57021 Mtetra
.767 .57 .632 r
.62524 .57021 .62627 .57371 .62686 .56517 .62583 .56131 Mtetra
.76 .564 .631 r
.62583 .56131 .62686 .56517 .62745 .55656 .62641 .55234 Mtetra
.747 .554 .634 r
.62641 .55234 .62745 .55656 .62806 .54865 .62701 .54411 Mtetra
.721 .536 .64 r
.62701 .54411 .62806 .54865 .62871 .54232 .62765 .53752 Mtetra
.668 .501 .649 r
.62765 .53752 .62871 .54232 .62943 .53833 .62837 .53338 Mtetra
.544 .419 .66 r
.62837 .53338 .62943 .53833 .63024 .53718 .62918 .5322 Mtetra
.152 .155 .607 r
.62918 .5322 .63024 .53718 .63115 .53897 .63009 .53409 Mtetra
.705 .452 0 r
.63009 .53409 .63115 .53897 .63213 .54335 .63107 .53869 Mtetra
.961 .653 .242 r
.63107 .53869 .63213 .54335 .63318 .54964 .63213 .54528 Mtetra
.975 .67 .357 r
.63213 .54528 .63318 .54964 .63426 .55699 .63322 .55297 Mtetra
.969 .666 .393 r
.63322 .55297 .63426 .55699 .63536 .56456 .63432 .56091 Mtetra
.965 .66 .397 r
.63432 .56091 .63536 .56456 .63644 .5717 .63542 .56838 Mtetra
.964 .651 .376 r
.63542 .56838 .63644 .5717 .6375 .57793 .63648 .57492 Mtetra
.964 .636 .321 r
.63648 .57492 .6375 .57793 .63852 .58301 .63751 .58025 Mtetra
.944 .594 .195 r
.63751 .58025 .63852 .58301 .63951 .58685 .6385 .58428 Mtetra
.786 .431 0 r
.6385 .58428 .63951 .58685 .64046 .58945 .63945 .58702 Mtetra
0 .039 .6 r
.63945 .58702 .64046 .58945 .64137 .59084 .64037 .5885 Mtetra
.379 .383 .738 r
.64037 .5885 .64137 .59084 .64224 .59108 .64124 .58877 Mtetra
.588 .498 .721 r
.64124 .58877 .64224 .59108 .64308 .59019 .64208 .58786 Mtetra
.675 .541 .694 r
.64208 .58786 .64308 .59019 .64387 .58814 .64287 .58575 Mtetra
.719 .56 .673 r
.64287 .58575 .64387 .58814 .64463 .58491 .64363 .58239 Mtetra
.744 .569 .657 r
.64363 .58239 .64463 .58491 .64535 .58045 .64434 .57775 Mtetra
.758 .573 .646 r
.64434 .57775 .64535 .58045 .64602 .57473 .645 .5718 Mtetra
.766 .574 .638 r
.645 .5718 .64602 .57473 .64665 .56781 .64562 .56458 Mtetra
.769 .573 .633 r
.64562 .56458 .64665 .56781 .64724 .55986 .64621 .55631 Mtetra
.767 .569 .631 r
.64621 .55631 .64724 .55986 .64781 .55128 .64676 .54736 Mtetra
.76 .563 .631 r
.64676 .54736 .64781 .55128 .64838 .54266 .64732 .53839 Mtetra
.746 .552 .633 r
.64732 .53839 .64838 .54266 .64897 .5348 .6479 .5302 Mtetra
.718 .534 .639 r
.6479 .5302 .64897 .5348 .64961 .52856 .64853 .5237 Mtetra
.663 .497 .65 r
.64853 .5237 .64961 .52856 .65034 .52471 .64925 .5197 Mtetra
.531 .41 .66 r
.64925 .5197 .65034 .52471 .65117 .52373 .65008 .51871 Mtetra
.12 .133 .599 r
.65008 .51871 .65117 .52373 .6521 .5257 .65102 .52078 Mtetra
.714 .457 0 r
.65102 .52078 .6521 .5257 .65313 .53024 .65205 .52555 Mtetra
.959 .649 .233 r
.65205 .52555 .65313 .53024 .65423 .53667 .65316 .53228 Mtetra
.974 .667 .346 r
.65316 .53228 .65423 .53667 .65537 .54411 .65431 .54007 Mtetra
.969 .664 .382 r
.65431 .54007 .65537 .54411 .65652 .55175 .65547 .54807 Mtetra
.966 .658 .384 r
.65547 .54807 .65652 .55175 .65765 .55891 .65661 .55558 Mtetra
.965 .649 .361 r
.65661 .55558 .65765 .55891 .65876 .56516 .65773 .56212 Mtetra
.963 .631 .302 r
.65773 .56212 .65876 .56516 .65982 .57024 .6588 .56745 Mtetra
.936 .583 .166 r
.6588 .56745 .65982 .57024 .66084 .57406 .65983 .57147 Mtetra
.751 .401 0 r
.65983 .57147 .66084 .57406 .66182 .57664 .66081 .57418 Mtetra
0 .067 .618 r
.66081 .57418 .66182 .57664 .66276 .57801 .66174 .57564 Mtetra
.389 .389 .738 r
.66174 .57564 .66276 .57801 .66365 .57822 .66264 .57588 Mtetra
.59 .499 .72 r
.66264 .57588 .66365 .57822 .66449 .5773 .66348 .57493 Mtetra
.676 .541 .693 r
.66348 .57493 .66449 .5773 .6653 .57521 .66429 .57278 Mtetra
.719 .559 .672 r
.66429 .57278 .6653 .57521 .66606 .57193 .66504 .56937 Mtetra
.744 .568 .656 r
.66504 .56937 .66606 .57193 .66677 .56741 .66574 .56467 Mtetra
.759 .572 .645 r
.66574 .56467 .66677 .56741 .66743 .56162 .66639 .55864 Mtetra
.766 .573 .637 r
.66639 .55864 .66743 .56162 .66804 .55463 .667 .55136 Mtetra
.769 .572 .632 r
.667 .55136 .66804 .55463 .66861 .54663 .66755 .54301 Mtetra
.767 .568 .63 r
.66755 .54301 .66861 .54663 .66916 .53801 .66808 .53403 Mtetra
.76 .562 .63 r
.66808 .53403 .66916 .53801 .6697 .52939 .66861 .52505 Mtetra
.744 .551 .633 r
.66861 .52505 .6697 .52939 .67027 .52157 .66917 .51691 Mtetra
.715 .531 .639 r
.66917 .51691 .67027 .52157 .6709 .51543 .6698 .51052 Mtetra
.657 .493 .65 r
.6698 .51052 .6709 .51543 .67163 .51172 .67052 .50666 Mtetra
.517 .401 .66 r
.67052 .50666 .67163 .51172 .67248 .51092 .67137 .50585 Mtetra
.086 .111 .59 r
.67137 .50585 .67248 .51092 .67345 .51307 .67234 .50811 Mtetra
.723 .461 0 r
.67234 .50811 .67345 .51307 .67453 .51778 .67342 .51306 Mtetra
.956 .644 .223 r
.67342 .51306 .67453 .51778 .67568 .52435 .67459 .51993 Mtetra
.974 .664 .334 r
.67459 .51993 .67568 .52435 .67688 .5319 .67579 .52783 Mtetra
.97 .661 .37 r
.67579 .52783 .67688 .5319 .67808 .5396 .67701 .5359 Mtetra
.967 .655 .371 r
.67701 .5359 .67808 .5396 .67927 .5468 .67822 .54345 Mtetra
.966 .645 .346 r
.67822 .54345 .67927 .5468 .68043 .55306 .67938 .55001 Mtetra
.961 .626 .282 r
.67938 .55001 .68043 .55306 .68154 .55814 .6805 .55533 Mtetra
.926 .571 .137 r
.6805 .55533 .68154 .55814 .68259 .56196 .68156 .55934 Mtetra
.717 .372 0 r
.68156 .55934 .68259 .56196 .6836 .56452 .68258 .56204 Mtetra
0 .09 .632 r
.68258 .56204 .6836 .56452 .68456 .56588 .68354 .56348 Mtetra
.397 .393 .738 r
.68354 .56348 .68456 .56588 .68547 .56607 .68445 .5637 Mtetra
.591 .499 .719 r
.68445 .5637 .68547 .56607 .68633 .56511 .68531 .56272 Mtetra
.676 .54 .692 r
.68531 .56272 .68633 .56511 .68714 .56299 .68611 .56052 Mtetra
.72 .559 .671 r
.68611 .56052 .68714 .56299 .6879 .55966 .68687 .55706 Mtetra
.744 .568 .655 r
.68687 .55706 .6879 .55966 .6886 .55508 .68756 .5523 Mtetra
.759 .572 .644 r
.68756 .5523 .6886 .55508 .68925 .54923 .6882 .5462 Mtetra
.767 .573 .636 r
.6882 .5462 .68925 .54923 .68984 .54216 .68878 .53884 Mtetra
.769 .571 .631 r
.68878 .53884 .68984 .54216 .69039 .5341 .68931 .53044 Mtetra
.767 .568 .629 r
.68931 .53044 .69039 .5341 .69091 .52545 .68982 .52142 Mtetra
.759 .561 .629 r
.68982 .52142 .69091 .52545 .69143 .51683 .69032 .51243 Mtetra
.743 .549 .632 r
.69032 .51243 .69143 .51683 .69198 .50906 .69086 .50434 Mtetra
.713 .529 .639 r
.69086 .50434 .69198 .50906 .69261 .50301 .69147 .49805 Mtetra
.651 .488 .65 r
.69147 .49805 .69261 .50301 .69334 .49945 .69221 .49435 Mtetra
.502 .391 .66 r
.69221 .49435 .69334 .49945 .69422 .49883 .69308 .49372 Mtetra
.052 .089 .58 r
.69308 .49372 .69422 .49883 .69522 .50117 .69409 .49618 Mtetra
.731 .465 0 r
.69409 .49618 .69522 .50117 .69635 .50606 .69522 .50131 Mtetra
.953 .639 .214 r
.69522 .50131 .69635 .50606 .69756 .51277 .69644 .50834 Mtetra
.973 .66 .323 r
.69644 .50834 .69756 .51277 .69881 .52043 .69771 .51635 Mtetra
.97 .658 .358 r
.69771 .51635 .69881 .52043 .70008 .52821 .699 .5245 Mtetra
.967 .652 .358 r
.699 .5245 .70008 .52821 .70133 .53546 .70026 .53208 Mtetra
.965 .641 .331 r
.70026 .53208 .70133 .53546 .70253 .54174 .70147 .53866 Mtetra
.959 .619 .262 r
.70147 .53866 .70253 .54174 .70369 .54682 .70264 .544 Mtetra
.915 .558 .109 r
.70264 .544 .70369 .54682 .70478 .55064 .70374 .548 Mtetra
.683 .344 0 r
.70374 .548 .70478 .55064 .70582 .55319 .70478 .55069 Mtetra
0 .11 .644 r
.70478 .55069 .70582 .55319 .7068 .55453 .70577 .55211 Mtetra
.404 .397 .738 r
.70577 .55211 .7068 .55453 .70773 .5547 .7067 .55231 Mtetra
.592 .499 .718 r
.7067 .55231 .70773 .5547 .70861 .55372 .70757 .5513 Mtetra
.676 .54 .691 r
.70757 .5513 .70861 .55372 .70943 .55156 .70838 .54906 Mtetra
.72 .559 .67 r
.70838 .54906 .70943 .55156 .71018 .54818 .70914 .54555 Mtetra
.745 .568 .654 r
.70914 .54555 .71018 .54818 .71088 .54354 .70983 .54072 Mtetra
.759 .572 .643 r
.70983 .54072 .71088 .54354 .71152 .53762 .71045 .53455 Mtetra
.767 .572 .635 r
.71045 .53455 .71152 .53762 .71209 .53049 .71101 .52712 Mtetra
.77 .571 .63 r
.71101 .52712 .71209 .53049 .71261 .52237 .71151 .51865 Mtetra
.767 .567 .627 r
.71151 .51865 .71261 .52237 .7131 .51367 .71199 .50959 Mtetra
.759 .56 .628 r
.71199 .50959 .7131 .51367 .7136 .50506 .71246 .50061 Mtetra
.742 .548 .631 r
.71246 .50061 .7136 .50506 .71413 .49734 .71298 .49257 Mtetra
.71 .526 .639 r
.71298 .49257 .71413 .49734 .71475 .4914 .71359 .48638 Mtetra
.645 .484 .651 r
.71359 .48638 .71475 .4914 .7155 .48799 .71433 .48284 Mtetra
.487 .381 .659 r
.71433 .48284 .7155 .48799 .7164 .48755 .71523 .4824 Mtetra
.018 .066 .57 r
.71523 .4824 .7164 .48755 .71744 .49008 .71628 .48507 Mtetra
.738 .469 0 r
.71628 .48507 .71744 .49008 .71862 .49516 .71747 .49038 Mtetra
.95 .635 .204 r
.71747 .49038 .71862 .49516 .71989 .50202 .71875 .49756 Mtetra
.971 .656 .311 r
.71875 .49756 .71989 .50202 .72121 .50979 .72009 .50569 Mtetra
.97 .655 .345 r
.72009 .50569 .72121 .50979 .72254 .51765 .72144 .51392 Mtetra
.967 .649 .345 r
.72144 .51392 .72254 .51765 .72385 .52494 .72276 .52155 Mtetra
.965 .637 .315 r
.72276 .52155 .72385 .52494 .72511 .53124 .72403 .52816 Mtetra
.955 .612 .242 r
.72403 .52816 .72511 .53124 .72631 .53634 .72524 .5335 Mtetra
.903 .544 .08 r
.72524 .5335 .72631 .53634 .72744 .54016 .72638 .53751 Mtetra
0 0 .269 r
.72638 .53751 .72744 .54016 .72851 .54271 .72746 .54019 Mtetra
0 .128 .654 r
.72746 .54019 .72851 .54271 .72952 .54403 .72847 .54159 Mtetra
.41 .4 .738 r
.72847 .54159 .72952 .54403 .73047 .54418 .72942 .54177 Mtetra
.593 .5 .718 r
.72942 .54177 .73047 .54418 .73136 .54317 .73031 .54072 Mtetra
.677 .54 .691 r
.73031 .54072 .73136 .54317 .73218 .54097 .73113 .53844 Mtetra
.721 .558 .669 r
.73113 .53844 .73218 .54097 .73294 .53754 .73188 .53488 Mtetra
.746 .567 .653 r
.73188 .53488 .73294 .53754 .73363 .53284 .73256 .52999 Mtetra
.76 .571 .642 r
.73256 .52999 .73363 .53284 .73425 .52686 .73317 .52375 Mtetra
.768 .572 .634 r
.73317 .52375 .73425 .52686 .7348 .51965 .7337 .51624 Mtetra
.77 .57 .629 r
.7337 .51624 .7348 .51965 .7353 .51147 .73418 .50771 Mtetra
.767 .566 .626 r
.73418 .50771 .7353 .51147 .73577 .50274 .73463 .4986 Mtetra
.758 .559 .627 r
.73463 .4986 .73577 .50274 .73623 .49412 .73508 .48962 Mtetra
.741 .546 .631 r
.73508 .48962 .73623 .49412 .73675 .48645 .73558 .48162 Mtetra
.707 .524 .639 r
.73558 .48162 .73675 .48645 .73737 .48061 .73618 .47555 Mtetra
.638 .479 .651 r
.73618 .47555 .73737 .48061 .73813 .47736 .73693 .47217 Mtetra
.47 .37 .659 r
.73693 .47217 .73813 .47736 .73905 .47711 .73785 .47192 Mtetra
0 .043 .559 r
.73785 .47192 .73905 .47711 .74014 .47984 .73895 .47479 Mtetra
.745 .472 0 r
.73895 .47479 .74014 .47984 .74138 .48509 .7402 .48029 Mtetra
.947 .63 .195 r
.7402 .48029 .74138 .48509 .74271 .49211 .74155 .48763 Mtetra
.97 .652 .299 r
.74155 .48763 .74271 .49211 .7441 .5 .74296 .49589 Mtetra
.969 .652 .333 r
.74296 .49589 .7441 .5 .7455 .50793 .74437 .5042 Mtetra
.967 .645 .331 r
.74437 .5042 .7455 .50793 .74687 .51528 .74576 .51188 Mtetra
.963 .632 .299 r
.74576 .51188 .74687 .51528 .74818 .52161 .74708 .51852 Mtetra
.951 .605 .222 r
.74708 .51852 .74818 .52161 .74943 .52672 .74834 .52387 Mtetra
.89 .529 .052 r
.74834 .52387 .74943 .52672 .7506 .53054 .74953 .52788 Mtetra
0 0 .3 r
.74953 .52788 .7506 .53054 .75171 .53308 .75064 .53055 Mtetra
0 .144 .663 r
.75064 .53055 .75171 .53308 .75274 .5344 .75168 .53194 Mtetra
.415 .404 .738 r
.75168 .53194 .75274 .5344 .75371 .53453 .75265 .53209 Mtetra
.595 .501 .717 r
.75265 .53209 .75371 .53453 .75461 .53348 .75355 .53102 Mtetra
.678 .54 .69 r
.75355 .53102 .75461 .53348 .75544 .53124 .75437 .52869 Mtetra
.721 .559 .669 r
.75437 .52869 .75544 .53124 .7562 .52777 .75512 .52508 Mtetra
.746 .567 .652 r
.75512 .52508 .7562 .52777 .75688 .523 .7558 .52011 Mtetra
.761 .571 .641 r
.7558 .52011 .75688 .523 .75749 .51694 .75639 .51379 Mtetra
.768 .572 .632 r
.75639 .51379 .75749 .51694 .75802 .50966 .7569 .50621 Mtetra
.771 .57 .627 r
.7569 .50621 .75802 .50966 .75849 .50141 .75735 .4976 Mtetra
.768 .566 .625 r
.75735 .4976 .75849 .50141 .75893 .49263 .75777 .48845 Mtetra
.758 .558 .626 r
.75777 .48845 .75893 .49263 .75937 .48401 .75819 .47946 Mtetra
.74 .545 .63 r
.75819 .47946 .75937 .48401 .75987 .47639 .75867 .47152 Mtetra
.704 .521 .639 r
.75867 .47152 .75987 .47639 .76048 .47066 .75927 .46555 Mtetra
.631 .474 .652 r
.75927 .46555 .76048 .47066 .76126 .46756 .76003 .46233 Mtetra
.453 .359 .658 r
.76003 .46233 .76126 .46756 .76221 .46749 .76099 .46228 Mtetra
0 .021 .548 r
.76099 .46228 .76221 .46749 .76335 .47042 .76213 .46535 Mtetra
.75 .473 0 r
.76213 .46535 .76335 .47042 .76464 .47586 .76344 .47105 Mtetra
.943 .624 .185 r
.76344 .47105 .76464 .47586 .76605 .48304 .76486 .47855 Mtetra
.968 .648 .287 r
.76486 .47855 .76605 .48304 .76751 .49104 .76634 .48693 Mtetra
.969 .648 .32 r
.76634 .48693 .76751 .49104 .76897 .49906 .76783 .49532 Mtetra
.966 .641 .317 r
.76783 .49532 .76897 .49906 .7704 .50646 .76928 .50306 Mtetra
.962 .627 .282 r
.76928 .50306 .7704 .50646 .77177 .51282 .77066 .50972 Mtetra
.946 .596 .201 r
.77066 .50972 .77177 .51282 .77307 .51794 .77197 .51509 Mtetra
.876 .513 .024 r
.77197 .51509 .77307 .51794 .77429 .52176 .7732 .51909 Mtetra
0 0 .33 r
.7732 .51909 .77429 .52176 .77543 .5243 .77435 .52176 Mtetra
.014 .16 .672 r
.77435 .52176 .77543 .5243 .77649 .5256 .77542 .52314 Mtetra
.421 .408 .739 r
.77542 .52314 .77649 .5256 .77748 .52571 .77641 .52326 Mtetra
.597 .502 .717 r
.77641 .52326 .77748 .52571 .7784 .52463 .77732 .52215 Mtetra
.679 .541 .69 r
.77732 .52215 .7784 .52463 .77924 .52235 .77815 .51978 Mtetra
.723 .559 .668 r
.77815 .51978 .77924 .52235 .77999 .51881 .7789 .5161 Mtetra
.747 .567 .651 r
.7789 .5161 .77999 .51881 .78067 .51398 .77956 .51106 Mtetra
.762 .571 .639 r
.77956 .51106 .78067 .51398 .78126 .50784 .78013 .50466 Mtetra
.769 .572 .631 r
.78013 .50466 .78126 .50784 .78176 .50048 .78062 .49698 Mtetra
.771 .57 .626 r
.78062 .49698 .78176 .50048 .78221 .49215 .78104 .4883 Mtetra
.768 .565 .624 r
.78104 .4883 .78221 .49215 .78262 .48333 .78143 .4791 Mtetra
.758 .557 .625 r
.78143 .4791 .78262 .48333 .78303 .47469 .78182 .4701 Mtetra
.738 .543 .63 r
.78182 .4701 .78303 .47469 .78352 .46712 .78229 .4622 Mtetra
.701 .519 .639 r
.78229 .4622 .78352 .46712 .78413 .46149 .78288 .45634 Mtetra
.624 .469 .652 r
.78288 .45634 .78413 .46149 .78491 .45855 .78366 .45328 Mtetra
.436 .348 .658 r
.78366 .45328 .78491 .45855 .7859 .45867 .78465 .45343 Mtetra
0 0 .537 r
.78465 .45343 .7859 .45867 .78709 .4618 .78584 .4567 Mtetra
.754 .474 0 r
.78584 .4567 .78709 .4618 .78845 .46743 .78722 .46259 Mtetra
.94 .619 .175 r
.78722 .46259 .78845 .46743 .78993 .47475 .78871 .47026 Mtetra
.966 .643 .275 r
.78871 .47026 .78993 .47475 .79146 .48288 .79027 .47876 Mtetra
.967 .643 .307 r
.79027 .47876 .79146 .48288 .793 .49099 .79183 .48724 Mtetra
.965 .636 .302 r
.79183 .48724 .793 .49099 .79449 .49843 .79335 .49503 Mtetra
.959 .621 .265 r
.79335 .49503 .79449 .49843 .79592 .50482 .79479 .50172 Mtetra
.94 .587 .18 r
.79479 .50172 .79592 .50482 .79727 .50996 .79616 .5071 Mtetra
.86 .497 0 r
.79616 .5071 .79727 .50996 .79853 .51378 .79743 .5111 Mtetra
0 0 .359 r
.79743 .5111 .79853 .51378 .79971 .51631 .79861 .51376 Mtetra
.035 .175 .68 r
.79861 .51376 .79971 .51631 .8008 .51759 .79971 .51512 Mtetra
.427 .412 .74 r
.79971 .51512 .8008 .51759 .80181 .51767 .80072 .51521 Mtetra
.599 .504 .717 r
.80072 .51521 .80181 .51767 .80274 .51656 .80165 .51406 Mtetra
.681 .542 .689 r
.80165 .51406 .80274 .51656 .80359 .51423 .80249 .51164 Mtetra
.724 .559 .667 r
.80249 .51164 .80359 .51423 .80434 .51063 .80323 .50789 Mtetra
.749 .568 .65 r
.80323 .50789 .80434 .51063 .80501 .50572 .80388 .50277 Mtetra
.763 .571 .638 r
.80388 .50277 .80501 .50572 .80558 .49949 .80444 .49628 Mtetra
.77 .572 .63 r
.80444 .49628 .80558 .49949 .80606 .49204 .8049 .48851 Mtetra
.772 .569 .625 r
.8049 .48851 .80606 .49204 .80648 .48363 .80529 .47974 Mtetra
.768 .565 .623 r
.80529 .47974 .80648 .48363 .80686 .47475 .80564 .47048 Mtetra
.758 .556 .624 r
.80564 .47048 .80686 .47475 .80725 .46611 .80601 .46146 Mtetra
.737 .542 .629 r
.80601 .46146 .80725 .46611 .80771 .45857 .80645 .45361 Mtetra
.698 .516 .639 r
.80645 .45361 .80771 .45857 .80832 .45305 .80705 .44786 Mtetra
.617 .464 .653 r
.80705 .44786 .80832 .45305 .80913 .45026 .80784 .44496 Mtetra
.418 .336 .657 r
.80784 .44496 .80913 .45026 .81015 .45057 .80887 .44529 Mtetra
0 0 .526 r
.80887 .44529 .81015 .45057 .8114 .45389 .81012 .44878 Mtetra
.757 .473 0 r
.81012 .44878 .8114 .45389 .81282 .45971 .81156 .45486 Mtetra
.935 .613 .164 r
.81156 .45486 .81282 .45971 .81437 .46719 .81314 .46268 Mtetra
.963 .638 .262 r
.81314 .46268 .81437 .46719 .81598 .47544 .81477 .47131 Mtetra
.966 .638 .292 r
.81477 .47131 .81598 .47544 .8176 .48362 .81641 .47987 Mtetra
.963 .631 .287 r
.81641 .47987 .8176 .48362 .81916 .49112 .818 .48771 Mtetra
.956 .614 .247 r
.818 .48771 .81916 .49112 .82065 .49754 .81951 .49443 Mtetra
.933 .577 .157 r
.81951 .49443 .82065 .49754 .82205 .50268 .82092 .49982 Mtetra
.843 .479 0 r
.82092 .49982 .82205 .50268 .82336 .5065 .82224 .50382 Mtetra
0 0 .387 r
.82224 .50382 .82336 .5065 .82457 .50902 .82346 .50647 Mtetra
.057 .19 .688 r
.82346 .50647 .82457 .50902 .82569 .51028 .82459 .5078 Mtetra
.434 .417 .741 r
.82459 .5078 .82569 .51028 .82673 .51033 .82562 .50786 Mtetra
.602 .505 .717 r
.82562 .50786 .82673 .51033 .82767 .50918 .82656 .50667 Mtetra
.682 .543 .689 r
.82656 .50667 .82767 .50918 .82852 .50679 .82741 .50419 Mtetra
.726 .56 .666 r
.82741 .50419 .82852 .50679 .82928 .50312 .82815 .50036 Mtetra
.75 .568 .649 r
.82815 .50036 .82928 .50312 .82993 .49812 .82879 .49515 Mtetra
.765 .571 .637 r
.82879 .49515 .82993 .49812 .83048 .4918 .82932 .48856 Mtetra
.772 .572 .628 r
.82932 .48856 .83048 .4918 .83094 .48425 .82976 .48069 Mtetra
.773 .569 .623 r
.82976 .48069 .83094 .48425 .83132 .47576 .83011 .47183 Mtetra
.769 .564 .621 r
.83011 .47183 .83132 .47576 .83167 .46682 .83043 .4625 Mtetra
.758 .555 .623 r
.83043 .4625 .83167 .46682 .83204 .45815 .83077 .45347 Mtetra
.736 .541 .628 r
.83077 .45347 .83204 .45815 .83249 .45066 .83119 .44565 Mtetra
.695 .514 .639 r
.83119 .44565 .83249 .45066 .8331 .44523 .83179 .44 Mtetra
.609 .459 .653 r
.83179 .44 .8331 .44523 .83392 .44259 .8326 .43726 Mtetra
.399 .325 .656 r
.8326 .43726 .83392 .44259 .83498 .44309 .83367 .43779 Mtetra
0 0 .516 r
.83367 .43779 .83498 .44309 .83629 .44661 .83498 .44148 Mtetra
.758 .471 0 r
.83498 .44148 .83629 .44661 .83778 .45261 .8365 .44775 Mtetra
.931 .606 .152 r
.8365 .44775 .83778 .45261 .83941 .46025 .83815 .45574 Mtetra
.96 .632 .248 r
.83815 .45574 .83941 .46025 .8411 .46861 .83987 .46448 Mtetra
.963 .633 .278 r
.83987 .46448 .8411 .46861 .84279 .47688 .84158 .47313 Mtetra
.961 .625 .271 r
.84158 .47313 .84279 .47688 .84443 .48443 .84325 .48102 Mtetra
.952 .606 .229 r
.84325 .48102 .84443 .48443 .84598 .49087 .84482 .48776 Mtetra
.925 .566 .133 r
.84482 .48776 .84598 .49087 .84744 .49602 .84629 .49316 Mtetra
.824 .459 0 r
.84629 .49316 .84744 .49602 .84879 .49983 .84766 .49715 Mtetra
0 0 .415 r
.84766 .49715 .84879 .49983 .85004 .50234 .84892 .49978 Mtetra
.079 .206 .696 r
.84892 .49978 .85004 .50234 .85119 .50358 .85008 .50109 Mtetra
.441 .422 .742 r
.85008 .50109 .85119 .50358 .85225 .50359 .85113 .50111 Mtetra
.605 .508 .717 r
.85113 .50111 .85225 .50359 .85321 .50239 .85208 .49987 Mtetra
.685 .544 .688 r
.85208 .49987 .85321 .50239 .85406 .49994 .85293 .49732 Mtetra
.727 .561 .665 r
.85293 .49732 .85406 .49994 .85482 .49619 .85367 .49341 Mtetra
.752 .569 .648 r
.85367 .49341 .85482 .49619 .85546 .4911 .8543 .48811 Mtetra
.766 .572 .635 r
.8543 .48811 .85546 .4911 .85599 .48468 .85481 .48141 Mtetra
.773 .572 .627 r
.85481 .48141 .85599 .48468 .85642 .47702 .85521 .47342 Mtetra
.774 .569 .622 r
.85521 .47342 .85642 .47702 .85677 .46844 .85554 .46446 Mtetra
.77 .564 .62 r
.85554 .46446 .85677 .46844 .85709 .45943 .85582 .45507 Mtetra
.758 .555 .622 r
.85582 .45507 .85709 .45943 .85742 .45074 .85612 .44601 Mtetra
.735 .539 .628 r
.85612 .44601 .85742 .45074 .85786 .44328 .85653 .43823 Mtetra
.692 .511 .639 r
.85653 .43823 .85786 .44328 .85847 .43795 .85712 .43267 Mtetra
.601 .454 .654 r
.85712 .43267 .85847 .43795 .85931 .43546 .85796 .43009 Mtetra
.381 .313 .655 r
.85796 .43009 .85931 .43546 .86042 .43614 .85907 .43081 Mtetra
0 0 .507 r
.85907 .43081 .86042 .43614 .86178 .43986 .86045 .4347 Mtetra
.757 .468 0 r
.86045 .4347 .86178 .43986 .86336 .44604 .86204 .44116 Mtetra
.926 .599 .139 r
.86204 .44116 .86336 .44604 .86507 .45383 .86378 .44931 Mtetra
.957 .625 .233 r
.86378 .44931 .86507 .45383 .86685 .46231 .86559 .45818 Mtetra
.961 .627 .262 r
.86559 .45818 .86685 .46231 .86862 .47066 .86738 .4669 Mtetra
.958 .618 .253 r
.86738 .4669 .86862 .47066 .87033 .47825 .86912 .47485 Mtetra
.947 .598 .208 r
.86912 .47485 .87033 .47825 .87195 .48472 .87076 .48161 Mtetra
.915 .553 .108 r
.87076 .48161 .87195 .48472 .87346 .48987 .8723 .48701 Mtetra
.803 .438 0 r
.8723 .48701 .87346 .48987 .87486 .49368 .87371 .491 Mtetra
0 0 .443 r
.87371 .491 .87486 .49368 .87615 .49616 .87501 .4936 Mtetra
.101 .222 .703 r
.87501 .4936 .87615 .49616 .87733 .49737 .87619 .49488 Mtetra
.449 .427 .742 r
.87619 .49488 .87733 .49737 .87841 .49735 .87727 .49486 Mtetra
.609 .51 .717 r
.87727 .49486 .87841 .49735 .87938 .49609 .87824 .49356 Mtetra
.687 .545 .687 r
.87824 .49356 .87938 .49609 .88024 .49357 .87909 .49094 Mtetra
.729 .562 .664 r
.87909 .49094 .88024 .49357 .88099 .48974 .87983 .48694 Mtetra
.754 .569 .646 r
.87983 .48694 .88099 .48974 .88162 .48455 .88044 .48153 Mtetra
.768 .572 .634 r
.88044 .48153 .88162 .48455 .88213 .47802 .88093 .47471 Mtetra
.774 .572 .625 r
.88093 .47471 .88213 .47802 .88253 .47025 .8813 .46661 Mtetra
.775 .569 .62 r
.8813 .46661 .88253 .47025 .88285 .46156 .88158 .45755 Mtetra
.77 .563 .618 r
.88158 .45755 .88285 .46156 .88312 .45248 .88183 .44807 Mtetra
.758 .554 .621 r
.88183 .44807 .88312 .45248 .88343 .44376 .8821 .43898 Mtetra
.734 .538 .627 r
.8821 .43898 .88343 .44376 .88385 .43633 .88249 .43123 Mtetra
.688 .509 .639 r
.88249 .43123 .88385 .43633 .88446 .4311 .88308 .42578 Mtetra
.593 .449 .655 r
.88308 .42578 .88446 .4311 .88533 .42876 .88394 .42334 Mtetra
.362 .302 .654 r
.88394 .42334 .88533 .42876 .88649 .42963 .8851 .42426 Mtetra
0 0 .498 r
.8851 .42426 .88649 .42963 .88792 .43354 .88655 .42836 Mtetra
.754 .463 0 r
.88655 .42836 .88792 .43354 .88957 .4399 .88822 .43501 Mtetra
.92 .591 .125 r
.88822 .43501 .88957 .4399 .89137 .44785 .89005 .44331 Mtetra
.953 .619 .217 r
.89005 .44331 .89137 .44785 .89323 .45644 .89195 .4523 Mtetra
.957 .621 .245 r
.89195 .4523 .89323 .45644 .89508 .46486 .89383 .4611 Mtetra
.954 .611 .235 r
.89383 .4611 .89508 .46486 .89687 .4725 .89565 .46909 Mtetra
.942 .589 .187 r
.89565 .46909 .89687 .4725 .89856 .47898 .89736 .47588 Mtetra
.904 .539 .082 r
.89736 .47588 .89856 .47898 .90013 .48414 .89895 .48128 Mtetra
.779 .415 0 r
.89895 .48128 .90013 .48414 .90158 .48794 .90041 .48525 Mtetra
0 0 .471 r
.90041 .48525 .90158 .48794 .9029 .4904 .90175 .48783 Mtetra
.124 .237 .711 r
.90175 .48783 .9029 .4904 .90412 .49157 .90297 .48907 Mtetra
.457 .433 .743 r
.90297 .48907 .90412 .49157 .90522 .4915 .90407 .48901 Mtetra
.613 .512 .716 r
.90407 .48901 .90522 .4915 .9062 .49018 .90505 .48764 Mtetra
.69 .547 .686 r
.90505 .48764 .9062 .49018 .90707 .48759 .90591 .48494 Mtetra
.732 .562 .663 r
.90591 .48494 .90707 .48759 .90781 .48367 .90664 .48085 Mtetra
.756 .57 .645 r
.90664 .48085 .90781 .48367 .90843 .47838 .90723 .47533 Mtetra
.769 .572 .632 r
.90723 .47533 .90843 .47838 .90892 .47172 .90769 .46839 Mtetra
.776 .572 .623 r
.90769 .46839 .90892 .47172 .90928 .46384 .90803 .46016 Mtetra
.776 .569 .618 r
.90803 .46016 .90928 .46384 .90956 .45504 .90827 .45098 Mtetra
.771 .563 .617 r
.90827 .45098 .90956 .45504 .90981 .44587 .90848 .44142 Mtetra
.758 .553 .619 r
.90848 .44142 .90981 .44587 .91008 .43713 .90872 .43229 Mtetra
.733 .536 .626 r
.90872 .43229 .91008 .43713 .91049 .42972 .90909 .42458 Mtetra
.685 .506 .639 r
.90909 .42458 .91049 .42972 .9111 .42458 .90969 .41922 Mtetra
.585 .444 .655 r
.90969 .41922 .9111 .42458 .912 .42239 .91057 .41694 Mtetra
.344 .29 .653 r
.91057 .41694 .912 .42239 .9132 .42345 .91178 .41805 Mtetra
0 0 .491 r
.91178 .41805 .9132 .42345 .9147 .42755 .9133 .42235 Mtetra
.75 .457 0 r
.9133 .42235 .9147 .42755 .91644 .4341 .91506 .42919 Mtetra
.913 .582 .109 r
.91506 .42919 .91644 .4341 .91833 .44219 .91698 .43765 Mtetra
.948 .611 .2 r
.91698 .43765 .91833 .44219 .92028 .4509 .91897 .44675 Mtetra
.953 .613 .227 r
.91897 .44675 .92028 .4509 .92222 .45939 .92095 .45563 Mtetra
.95 .603 .215 r
.92095 .45563 .92222 .45939 .92409 .46707 .92284 .46366 Mtetra
.935 .579 .164 r
.92284 .46366 .92409 .46707 .92584 .47358 .92463 .47047 Mtetra
.891 .524 .053 r
.92463 .47047 .92584 .47358 .92747 .47873 .92628 .47587 Mtetra
.752 .391 0 r
.92628 .47587 .92747 .47873 .92897 .48251 .92779 .47982 Mtetra
0 0 .498 r
.92779 .47982 .92897 .48251 .93034 .48495 .92917 .48238 Mtetra
.146 .253 .718 r
.92917 .48238 .93034 .48495 .93159 .48609 .93042 .48358 Mtetra
.466 .438 .744 r
.93042 .48358 .93159 .48609 .93271 .48597 .93154 .48346 Mtetra
.617 .515 .716 r
.93154 .48346 .93271 .48597 .93371 .48458 .93254 .48203 Mtetra
.693 .548 .685 r
.93254 .48203 .93371 .48458 .93458 .48191 .9334 .47924 Mtetra
.734 .563 .661 r
.9334 .47924 .93458 .48191 .93532 .47789 .93412 .47505 Mtetra
.758 .57 .643 r
.93412 .47505 .93532 .47789 .93591 .47248 .93469 .46941 Mtetra
.771 .573 .63 r
.93469 .46941 .93591 .47248 .93637 .4657 .93513 .46233 Mtetra
.777 .572 .621 r
.93513 .46233 .93637 .4657 .93671 .45769 .93543 .45397 Mtetra
.778 .569 .617 r
.93543 .45397 .93671 .45769 .93695 .44878 .93563 .44467 Mtetra
.772 .562 .615 r
.93563 .44467 .93695 .44878 .93715 .43953 .93579 .43502 Mtetra
.758 .552 .618 r
.93579 .43502 .93715 .43953 .9374 .43075 .936 .42586 Mtetra
.732 .535 .626 r
.936 .42586 .9374 .43075 .93779 .42337 .93636 .41817 Mtetra
.681 .503 .639 r
.93636 .41817 .93779 .42337 .93841 .41832 .93696 .41291 Mtetra
.576 .438 .656 r
.93696 .41291 .93841 .41832 .93933 .41628 .93787 .41079 Mtetra
.326 .279 .652 r
.93787 .41079 .93933 .41628 .94059 .41752 .93913 .41209 Mtetra
0 0 .485 r
.93913 .41209 .94059 .41752 .94216 .42182 .94072 .41659 Mtetra
.744 .45 0 r
.94072 .41659 .94216 .42182 .94399 .42855 .94258 .42362 Mtetra
.905 .573 .093 r
.94258 .42362 .94399 .42855 .94597 .43679 .9446 .43224 Mtetra
.942 .603 .181 r
.9446 .43224 .94597 .43679 .94802 .44561 .94669 .44145 Mtetra
.949 .605 .208 r
.94669 .44145 .94802 .44561 .95005 .45418 .94875 .45041 Mtetra
.944 .594 .194 r
.94875 .45041 .95005 .45418 .952 .4619 .95073 .45848 Mtetra
.927 .567 .139 r
.95073 .45848 .952 .4619 .95383 .46842 .95259 .4653 Mtetra
.876 .508 .023 r
.95259 .4653 .95383 .46842 .95552 .47357 .95431 .4707 Mtetra
.723 .364 0 r
.95431 .4707 .95552 .47357 .95707 .47733 .95587 .47464 Mtetra
0 0 .524 r
.95587 .47464 .95707 .47733 .95848 .47974 .95729 .47716 Mtetra
.169 .268 .724 r
.95729 .47716 .95848 .47974 .95976 .48083 .95858 .47832 Mtetra
.475 .444 .744 r
.95858 .47832 .95976 .48083 .9609 .48066 .95972 .47814 Mtetra
.621 .517 .715 r
.95972 .47814 .9609 .48066 .96191 .47921 .96073 .47663 Mtetra
.695 .55 .684 r
.96073 .47663 .96191 .47921 .96279 .47645 .96159 .47376 Mtetra
.736 .564 .66 r
.96159 .47376 .96279 .47645 .96352 .47233 .9623 .46946 Mtetra
.76 .571 .641 r
.9623 .46946 .96352 .47233 .9641 .4668 .96286 .46369 Mtetra
.773 .573 .628 r
.96286 .46369 .9641 .4668 .96453 .45989 .96326 .45648 Mtetra
.779 .572 .62 r
.96326 .45648 .96453 .45989 .96483 .45174 .96352 .44798 Mtetra
.779 .568 .615 r
.96352 .44798 .96483 .45174 .96503 .44271 .96368 .43855 Mtetra
.773 .562 .614 r
.96368 .43855 .96503 .44271 .96519 .43337 .9638 .42881 Mtetra
.758 .551 .617 r
.9638 .42881 .96519 .43337 .96541 .42455 .96397 .41961 Mtetra
.73 .533 .625 r
.96397 .41961 .96541 .42455 .96578 .4172 .96431 .41195 Mtetra
.677 .5 .639 r
.96431 .41195 .96578 .4172 .9664 .41224 .96491 .40678 Mtetra
.567 .432 .657 r
.96491 .40678 .9664 .41224 .96736 .41035 .96586 .40481 Mtetra
0 .149 .679 r
.50993 .61872 .51084 .62061 .5116 .6215 .51068 .61964 Mtetra
.939 .613 .392 r
.51068 .61964 .5116 .6215 .51238 .62518 .51146 .62337 Mtetra
.904 .621 .496 r
.51146 .62337 .51238 .62518 .51317 .63102 .51224 .6293 Mtetra
.889 .618 .522 r
.51224 .6293 .51317 .63102 .51396 .63821 .51304 .63659 Mtetra
.882 .615 .529 r
.51304 .63659 .51396 .63821 .51476 .64586 .51384 .64436 Mtetra
.88 .612 .528 r
.51384 .64436 .51476 .64586 .51557 .65325 .51464 .65186 Mtetra
.881 .608 .521 r
.51464 .65186 .51557 .65325 .51637 .65984 .51544 .65855 Mtetra
.885 .602 .504 r
.51544 .65855 .51637 .65984 .51717 .66531 .51624 .66411 Mtetra
.892 .592 .472 r
.51624 .66411 .51717 .66531 .51796 .66954 .51703 .6684 Mtetra
.903 .568 .402 r
.51703 .6684 .51796 .66954 .51875 .67249 .51782 .6714 Mtetra
.892 .472 .174 r
.51782 .6714 .51875 .67249 .51953 .67421 .5186 .67315 Mtetra
0 .269 .775 r
.5186 .67315 .51953 .67421 .5203 .67474 .51938 .6737 Mtetra
.627 .602 .806 r
.51938 .6737 .5203 .67474 .52107 .67412 .52014 .67307 Mtetra
.737 .621 .729 r
.52014 .67307 .52107 .67412 .52183 .67233 .52091 .67127 Mtetra
.773 .621 .691 r
.52091 .67127 .52183 .67233 .52259 .66936 .52166 .66826 Mtetra
.79 .619 .668 r
.52166 .66826 .52259 .66936 .52333 .66514 .5224 .664 Mtetra
.799 .616 .654 r
.5224 .664 .52333 .66514 .52407 .65966 .52314 .65844 Mtetra
.804 .614 .645 r
.52314 .65844 .52407 .65966 .52479 .65291 .52386 .65161 Mtetra
.807 .612 .639 r
.52386 .65161 .52479 .65291 .5255 .64506 .52457 .64366 Mtetra
.807 .61 .635 r
.52457 .64366 .5255 .64506 .52621 .63643 .52528 .63491 Mtetra
.806 .608 .634 r
.52528 .63491 .52621 .63643 .52691 .62755 .52598 .62591 Mtetra
.801 .605 .637 r
.52598 .62591 .52691 .62755 .52761 .61918 .52669 .61744 Mtetra
.791 .6 .643 r
.52669 .61744 .52761 .61918 .52833 .6122 .5274 .61036 Mtetra
.767 .591 .659 r
.5274 .61036 .52833 .6122 .52905 .60742 .52813 .60553 Mtetra
.691 .559 .701 r
.52813 .60553 .52905 .60742 .52981 .60546 .52888 .60355 Mtetra
0 .074 .632 r
.52888 .60355 .52981 .60546 .53059 .60651 .52966 .60462 Mtetra
.939 .614 .391 r
.52966 .60462 .53059 .60651 .53139 .61033 .53046 .6085 Mtetra
.906 .621 .491 r
.53046 .6085 .53139 .61033 .53222 .61629 .53129 .61455 Mtetra
.892 .618 .517 r
.53129 .61455 .53222 .61629 .53306 .62355 .53213 .62192 Mtetra
.885 .616 .525 r
.53213 .62192 .53306 .62355 .5339 .63125 .53297 .62973 Mtetra
.883 .612 .523 r
.53297 .62973 .5339 .63125 .53475 .63864 .53382 .63723 Mtetra
.884 .608 .515 r
.53382 .63723 .53475 .63864 .5356 .64521 .53466 .6439 Mtetra
.888 .602 .497 r
.53466 .6439 .5356 .64521 .53643 .65065 .5355 .64943 Mtetra
.895 .591 .463 r
.5355 .64943 .53643 .65065 .53726 .65483 .53632 .65367 Mtetra
.906 .565 .385 r
.53632 .65367 .53726 .65483 .53807 .65774 .53714 .65663 Mtetra
.884 .452 .127 r
.53714 .65663 .53807 .65774 .53887 .65941 .53794 .65833 Mtetra
.005 .321 .808 r
.53794 .65833 .53887 .65941 .53966 .65989 .53873 .65883 Mtetra
.633 .602 .8 r
.53873 .65883 .53966 .65989 .54044 .65921 .53951 .65814 Mtetra
.738 .62 .727 r
.53951 .65814 .54044 .65921 .54121 .65737 .54028 .65628 Mtetra
.774 .62 .689 r
.54028 .65628 .54121 .65737 .54196 .65432 .54103 .6532 Mtetra
.791 .618 .667 r
.54103 .6532 .54196 .65432 .5427 .65003 .54177 .64886 Mtetra
.8 .616 .653 r
.54177 .64886 .5427 .65003 .54343 .64446 .54249 .64322 Mtetra
.805 .614 .643 r
.54249 .64322 .54343 .64446 .54414 .63764 .5432 .6363 Mtetra
.808 .612 .637 r
.5432 .6363 .54414 .63764 .54483 .62971 .5439 .62827 Mtetra
.808 .61 .634 r
.5439 .62827 .54483 .62971 .54551 .62102 .54458 .61946 Mtetra
.806 .607 .633 r
.54458 .61946 .54551 .62102 .54619 .61211 .54526 .61044 Mtetra
.801 .604 .636 r
.54526 .61044 .54619 .61211 .54687 .60376 .54594 .60198 Mtetra
.79 .6 .643 r
.54594 .60198 .54687 .60376 .54757 .59684 .54664 .59498 Mtetra
.765 .59 .66 r
.54664 .59498 .54757 .59684 .5483 .59219 .54736 .59026 Mtetra
.682 .554 .704 r
.54736 .59026 .5483 .59219 .54906 .59037 .54812 .58843 Mtetra
0 0 .574 r
.54812 .58843 .54906 .59037 .54986 .59158 .54892 .58966 Mtetra
.939 .614 .39 r
.54892 .58966 .54986 .59158 .55069 .59555 .54976 .59369 Mtetra
.908 .621 .487 r
.54976 .59369 .55069 .59555 .55156 .60163 .55062 .59986 Mtetra
.894 .619 .512 r
.55062 .59986 .55156 .60163 .55245 .60897 .55151 .60731 Mtetra
.888 .616 .519 r
.55151 .60731 .55245 .60897 .55334 .6167 .55241 .61516 Mtetra
.886 .612 .518 r
.55241 .61516 .55334 .6167 .55424 .6241 .5533 .62267 Mtetra
.887 .608 .509 r
.5533 .62267 .55424 .6241 .55512 .63066 .55418 .62933 Mtetra
.891 .602 .49 r
.55418 .62933 .55512 .63066 .55599 .63607 .55506 .63482 Mtetra
.899 .59 .452 r
.55506 .63482 .55599 .63607 .55685 .64021 .55591 .63903 Mtetra
.909 .56 .367 r
.55591 .63903 .55685 .64021 .55769 .64308 .55675 .64194 Mtetra
.871 .429 .075 r
.55675 .64194 .55769 .64308 .55851 .6447 .55758 .6436 Mtetra
.083 .361 .829 r
.55758 .6436 .55851 .6447 .55932 .64514 .55838 .64404 Mtetra
.639 .601 .795 r
.55838 .64404 .55932 .64514 .56011 .6444 .55917 .64331 Mtetra
.739 .619 .724 r
.55917 .64331 .56011 .6444 .56089 .6425 .55995 .64138 Mtetra
.775 .62 .687 r
.55995 .64138 .56089 .6425 .56164 .63939 .5607 .63824 Mtetra
.792 .618 .666 r
.5607 .63824 .56164 .63939 .56238 .63502 .56144 .63382 Mtetra
.801 .616 .652 r
.56144 .63382 .56238 .63502 .56309 .62937 .56215 .62809 Mtetra
.806 .614 .642 r
.56215 .62809 .56309 .62937 .56378 .62246 .56284 .62109 Mtetra
.809 .612 .636 r
.56284 .62109 .56378 .62246 .56446 .61446 .56351 .61299 Mtetra
.809 .61 .633 r
.56351 .61299 .56446 .61446 .56511 .60571 .56417 .60412 Mtetra
.807 .607 .632 r
.56417 .60412 .56511 .60571 .56577 .59678 .56483 .59508 Mtetra
.802 .604 .635 r
.56483 .59508 .56577 .59678 .56643 .58846 .56549 .58664 Mtetra
.79 .599 .642 r
.56549 .58664 .56643 .58846 .56711 .58161 .56617 .57971 Mtetra
.763 .588 .66 r
.56617 .57971 .56711 .58161 .56783 .57708 .56689 .57512 Mtetra
.67 .549 .708 r
.56689 .57512 .56783 .57708 .5686 .57541 .56766 .57344 Mtetra
0 0 .509 r
.56766 .57344 .5686 .57541 .56943 .57678 .56848 .57484 Mtetra
.94 .614 .388 r
.56848 .57484 .56943 .57678 .5703 .5809 .56935 .57902 Mtetra
.911 .621 .482 r
.56935 .57902 .5703 .5809 .57121 .5871 .57026 .58531 Mtetra
.897 .619 .507 r
.57026 .58531 .57121 .5871 .57214 .59452 .5712 .59284 Mtetra
.891 .616 .514 r
.5712 .59284 .57214 .59452 .57309 .6023 .57214 .60074 Mtetra
.889 .612 .512 r
.57214 .60074 .57309 .6023 .57403 .60972 .57308 .60826 Mtetra
.89 .608 .502 r
.57308 .60826 .57403 .60972 .57496 .61626 .57401 .6149 Mtetra
.895 .601 .482 r
.57401 .6149 .57496 .61626 .57587 .62164 .57492 .62037 Mtetra
.903 .588 .441 r
.57492 .62037 .57587 .62164 .57676 .62575 .57581 .62454 Mtetra
.912 .556 .347 r
.57581 .62454 .57676 .62575 .57762 .62858 .57668 .62742 Mtetra
.854 .402 .019 r
.57668 .62742 .57762 .62858 .57847 .63016 .57753 .62903 Mtetra
.148 .392 .841 r
.57753 .62903 .57847 .63016 .57929 .63055 .57835 .62943 Mtetra
.644 .6 .79 r
.57835 .62943 .57929 .63055 .58009 .62976 .57915 .62864 Mtetra
.74 .618 .722 r
.57915 .62864 .58009 .62976 .58087 .6278 .57993 .62666 Mtetra
.775 .619 .686 r
.57993 .62666 .58087 .6278 .58163 .62463 .58068 .62344 Mtetra
.792 .617 .664 r
.58068 .62344 .58163 .62463 .58236 .62019 .58141 .61895 Mtetra
.802 .616 .65 r
.58141 .61895 .58236 .62019 .58306 .61446 .58211 .61315 Mtetra
.807 .614 .641 r
.58211 .61315 .58306 .61446 .58374 .60747 .58279 .60607 Mtetra
.809 .612 .635 r
.58279 .60607 .58374 .60747 .58439 .59939 .58344 .59789 Mtetra
.81 .609 .632 r
.58344 .59789 .58439 .59939 .58502 .59059 .58407 .58897 Mtetra
.808 .607 .631 r
.58407 .58897 .58502 .59059 .58565 .58165 .5847 .5799 Mtetra
.802 .604 .634 r
.5847 .5799 .58565 .58165 .58629 .57335 .58534 .5715 Mtetra
.79 .598 .642 r
.58534 .5715 .58629 .57335 .58696 .56658 .58601 .56464 Mtetra
.761 .587 .661 r
.58601 .56464 .58696 .56658 .58768 .56217 .58673 .56018 Mtetra
.658 .542 .712 r
.58673 .56018 .58768 .56217 .58846 .56067 .58751 .55866 Mtetra
0 0 .439 r
.58751 .55866 .58846 .56067 .58931 .5622 .58836 .56023 Mtetra
.941 .614 .386 r
.58836 .56023 .58931 .5622 .59022 .56648 .58927 .56456 Mtetra
.913 .621 .477 r
.58927 .56456 .59022 .56648 .59117 .5728 .59022 .57098 Mtetra
.9 .619 .502 r
.59022 .57098 .59117 .5728 .59216 .58031 .59121 .5786 Mtetra
.894 .616 .509 r
.59121 .5786 .59216 .58031 .59316 .58814 .5922 .58654 Mtetra
.892 .612 .506 r
.5922 .58654 .59316 .58814 .59415 .59556 .59319 .59408 Mtetra
.894 .608 .495 r
.59319 .59408 .59415 .59556 .59512 .6021 .59417 .60072 Mtetra
.898 .6 .473 r
.59417 .60072 .59512 .6021 .59607 .60746 .59512 .60616 Mtetra
.906 .587 .429 r
.59512 .60616 .59607 .60746 .59699 .61154 .59604 .6103 Mtetra
.914 .55 .326 r
.59604 .6103 .59699 .61154 .59788 .61433 .59693 .61314 Mtetra
.832 .371 0 r
.59693 .61314 .59788 .61433 .59875 .61587 .5978 .61471 Mtetra
.2 .415 .847 r
.5978 .61471 .59875 .61587 .59959 .61622 .59864 .61507 Mtetra
.648 .599 .786 r
.59864 .61507 .59959 .61622 .6004 .61539 .59945 .61423 Mtetra
.741 .617 .72 r
.59945 .61423 .6004 .61539 .60119 .61337 .60024 .6122 Mtetra
.776 .618 .685 r
.60024 .6122 .60119 .61337 .60194 .61014 .60099 .60892 Mtetra
.793 .617 .663 r
.60099 .60892 .60194 .61014 .60267 .60563 .60171 .60436 Mtetra
.802 .615 .649 r
.60171 .60436 .60267 .60563 .60336 .59982 .6024 .59847 Mtetra
.808 .613 .639 r
.6024 .59847 .60336 .59982 .60402 .59275 .60306 .59132 Mtetra
.81 .611 .633 r
.60306 .59132 .60402 .59275 .60465 .58461 .60369 .58306 Mtetra
.811 .609 .63 r
.60369 .58306 .60465 .58461 .60526 .57576 .6043 .57409 Mtetra
.808 .607 .63 r
.6043 .57409 .60526 .57576 .60586 .5668 .6049 .56502 Mtetra
.802 .603 .633 r
.6049 .56502 .60586 .5668 .60648 .55853 .60552 .55664 Mtetra
.789 .598 .642 r
.60552 .55664 .60648 .55853 .60714 .55185 .60618 .54988 Mtetra
.758 .585 .662 r
.60618 .54988 .60714 .55185 .60786 .54757 .60689 .54554 Mtetra
.643 .535 .716 r
.60689 .54554 .60786 .54757 .60865 .54623 .60769 .54419 Mtetra
0 0 .369 r
.60769 .54419 .60865 .54623 .60952 .54794 .60856 .54593 Mtetra
.941 .613 .383 r
.60856 .54593 .60952 .54794 .61047 .55237 .60951 .55043 Mtetra
.915 .62 .471 r
.60951 .55043 .61047 .55237 .61148 .55882 .61051 .55698 Mtetra
.902 .619 .496 r
.61051 .55698 .61148 .55882 .61251 .56642 .61155 .56469 Mtetra
.897 .616 .503 r
.61155 .56469 .61251 .56642 .61356 .5743 .6126 .57268 Mtetra
.895 .612 .5 r
.6126 .57268 .61356 .5743 .6146 .58175 .61364 .58024 Mtetra
.897 .607 .488 r
.61364 .58024 .6146 .58175 .61562 .58828 .61466 .58687 Mtetra
.902 .6 .464 r
.61466 .58687 .61562 .58828 .61661 .59363 .61565 .5923 Mtetra
.91 .585 .417 r
.61565 .5923 .61661 .59363 .61757 .59768 .61661 .59642 Mtetra
.916 .544 .304 r
.61661 .59642 .61757 .59768 .61849 .60044 .61753 .59922 Mtetra
.804 .338 0 r
.61753 .59922 .61849 .60044 .61938 .60195 .61842 .60076 Mtetra
.241 .433 .85 r
.61842 .60076 .61938 .60195 .62023 .60226 .61928 .60108 Mtetra
.65 .598 .783 r
.61928 .60108 .62023 .60226 .62106 .60138 .6201 .6002 Mtetra
.741 .616 .719 r
.6201 .6002 .62106 .60138 .62185 .59932 .62089 .59811 Mtetra
.776 .618 .683 r
.62089 .59811 .62185 .59932 .6226 .59602 .62164 .59478 Mtetra
.793 .617 .662 r
.62164 .59478 .6226 .59602 .62332 .59144 .62236 .59014 Mtetra
.803 .615 .648 r
.62236 .59014 .62332 .59144 .624 .58556 .62304 .58418 Mtetra
.809 .613 .638 r
.62304 .58418 .624 .58556 .62464 .57842 .62368 .57695 Mtetra
.811 .611 .632 r
.62368 .57695 .62464 .57842 .62524 .57021 .62428 .56863 Mtetra
.811 .609 .629 r
.62428 .56863 .62524 .57021 .62583 .56131 .62486 .55961 Mtetra
.809 .607 .629 r
.62486 .55961 .62583 .56131 .62641 .55234 .62544 .55052 Mtetra
.802 .603 .632 r
.62544 .55052 .62641 .55234 .62701 .54411 .62604 .54218 Mtetra
.788 .597 .642 r
.62604 .54218 .62701 .54411 .62765 .53752 .62668 .53551 Mtetra
.754 .583 .664 r
.62668 .53551 .62765 .53752 .62837 .53338 .6274 .53132 Mtetra
.626 .526 .721 r
.6274 .53132 .62837 .53338 .62918 .5322 .62821 .53013 Mtetra
.64 .277 0 r
.62821 .53013 .62918 .5322 .63009 .53409 .62911 .53206 Mtetra
.942 .613 .38 r
.62911 .53206 .63009 .53409 .63107 .53869 .6301 .53672 Mtetra
.917 .62 .466 r
.6301 .53672 .63107 .53869 .63213 .54528 .63116 .54341 Mtetra
.905 .618 .49 r
.63116 .54341 .63213 .54528 .63322 .55297 .63225 .55122 Mtetra
.9 .616 .497 r
.63225 .55122 .63322 .55297 .63432 .56091 .63336 .55927 Mtetra
.898 .612 .493 r
.63336 .55927 .63432 .56091 .63542 .56838 .63445 .56685 Mtetra
.9 .607 .481 r
.63445 .56685 .63542 .56838 .63648 .57492 .63552 .57349 Mtetra
.905 .599 .455 r
.63552 .57349 .63648 .57492 .63751 .58025 .63655 .5789 Mtetra
.913 .582 .404 r
.63655 .5789 .63751 .58025 .6385 .58428 .63754 .583 Mtetra
.916 .537 .281 r
.63754 .583 .6385 .58428 .63945 .58702 .63849 .58578 Mtetra
.771 .303 0 r
.63849 .58578 .63945 .58702 .64037 .5885 .6394 .58729 Mtetra
.274 .446 .85 r
.6394 .58729 .64037 .5885 .64124 .58877 .64028 .58757 Mtetra
.653 .597 .78 r
.64028 .58757 .64124 .58877 .64208 .58786 .64111 .58665 Mtetra
.742 .615 .717 r
.64111 .58665 .64208 .58786 .64287 .58575 .64191 .58451 Mtetra
.776 .617 .682 r
.64191 .58451 .64287 .58575 .64363 .58239 .64266 .58112 Mtetra
.794 .616 .661 r
.64266 .58112 .64363 .58239 .64434 .57775 .64337 .57642 Mtetra
.804 .615 .646 r
.64337 .57642 .64434 .57775 .645 .5718 .64404 .57039 Mtetra
.809 .613 .637 r
.64404 .57039 .645 .5718 .64562 .56458 .64465 .56308 Mtetra
.812 .611 .631 r
.64465 .56308 .64562 .56458 .64621 .55631 .64523 .55469 Mtetra
.812 .609 .628 r
.64523 .55469 .64621 .55631 .64676 .54736 .64579 .54563 Mtetra
.809 .606 .628 r
.64579 .54563 .64676 .54736 .64732 .53839 .64634 .53653 Mtetra
.803 .603 .632 r
.64634 .53653 .64732 .53839 .6479 .5302 .64692 .52824 Mtetra
.788 .596 .642 r
.64692 .52824 .6479 .5302 .64853 .5237 .64755 .52166 Mtetra
.751 .581 .665 r
.64755 .52166 .64853 .5237 .64925 .5197 .64827 .51761 Mtetra
.607 .516 .726 r
.64827 .51761 .64925 .5197 .65008 .51871 .6491 .51661 Mtetra
.7 .327 0 r
.6491 .51661 .65008 .51871 .65102 .52078 .65003 .51872 Mtetra
.942 .612 .377 r
.65003 .51872 .65102 .52078 .65205 .52555 .65107 .52356 Mtetra
.919 .62 .46 r
.65107 .52356 .65205 .52555 .65316 .53228 .65218 .53038 Mtetra
.908 .618 .484 r
.65218 .53038 .65316 .53228 .65431 .54007 .65333 .53829 Mtetra
.902 .615 .49 r
.65333 .53829 .65431 .54007 .65547 .54807 .65449 .54641 Mtetra
.901 .612 .486 r
.65449 .54641 .65547 .54807 .65661 .55558 .65564 .55403 Mtetra
.903 .606 .473 r
.65564 .55403 .65661 .55558 .65773 .56212 .65675 .56067 Mtetra
.908 .598 .446 r
.65675 .56067 .65773 .56212 .6588 .56745 .65783 .56608 Mtetra
.916 .58 .391 r
.65783 .56608 .6588 .56745 .65983 .57147 .65886 .57016 Mtetra
.916 .53 .257 r
.65886 .57016 .65983 .57147 .66081 .57418 .65984 .57292 Mtetra
.736 .268 0 r
.65984 .57292 .66081 .57418 .66174 .57564 .66078 .5744 Mtetra
.3 .456 .849 r
.66078 .5744 .66174 .57564 .66264 .57588 .66167 .57466 Mtetra
.654 .596 .777 r
.66167 .57466 .66264 .57588 .66348 .57493 .66251 .5737 Mtetra
.742 .614 .716 r
.66251 .5737 .66348 .57493 .66429 .57278 .66332 .57152 Mtetra
.777 .617 .681 r
.66332 .57152 .66429 .57278 .66504 .56937 .66407 .56807 Mtetra
.795 .616 .659 r
.66407 .56807 .66504 .56937 .66574 .56467 .66477 .5633 Mtetra
.805 .615 .645 r
.66477 .5633 .66574 .56467 .66639 .55864 .66542 .5572 Mtetra
.811 .613 .635 r
.66542 .5572 .66639 .55864 .667 .55136 .66602 .54982 Mtetra
.813 .611 .629 r
.66602 .54982 .667 .55136 .66755 .54301 .66657 .54137 Mtetra
.813 .609 .626 r
.66657 .54137 .66755 .54301 .66808 .53403 .6671 .53227 Mtetra
.81 .606 .626 r
.6671 .53227 .66808 .53403 .66861 .52505 .66763 .52317 Mtetra
.803 .602 .631 r
.66763 .52317 .66861 .52505 .66917 .51691 .66818 .51492 Mtetra
.787 .595 .642 r
.66818 .51492 .66917 .51691 .6698 .51052 .6688 .50844 Mtetra
.747 .579 .667 r
.6688 .50844 .6698 .51052 .67052 .50666 .66953 .50454 Mtetra
.584 .504 .731 r
.66953 .50454 .67052 .50666 .67137 .50585 .67037 .50372 Mtetra
.75 .369 0 r
.67037 .50372 .67137 .50585 .67234 .50811 .67135 .50602 Mtetra
.943 .612 .374 r
.67135 .50602 .67234 .50811 .67342 .51306 .67243 .51104 Mtetra
.921 .619 .454 r
.67243 .51104 .67342 .51306 .67459 .51993 .6736 .51802 Mtetra
.91 .618 .478 r
.6736 .51802 .67459 .51993 .67579 .52783 .67481 .52603 Mtetra
.905 .615 .484 r
.67481 .52603 .67579 .52783 .67701 .5359 .67603 .53422 Mtetra
.904 .611 .479 r
.67603 .53422 .67701 .5359 .67822 .54345 .67723 .54188 Mtetra
.906 .606 .465 r
.67723 .54188 .67822 .54345 .67938 .55001 .6784 .54853 Mtetra
.911 .596 .436 r
.6784 .54853 .67938 .55001 .6805 .55533 .67952 .55394 Mtetra
.918 .577 .377 r
.67952 .55394 .6805 .55533 .68156 .55934 .68059 .55801 Mtetra
.915 .521 .233 r
.68059 .55801 .68156 .55934 .68258 .56204 .6816 .56076 Mtetra
.699 .233 0 r
.6816 .56076 .68258 .56204 .68354 .56348 .68256 .56222 Mtetra
.32 .464 .848 r
.68256 .56222 .68354 .56348 .68445 .5637 .68347 .56245 Mtetra
.656 .596 .775 r
.68347 .56245 .68445 .5637 .68531 .56272 .68433 .56146 Mtetra
.743 .614 .715 r
.68433 .56146 .68531 .56272 .68611 .56052 .68514 .55924 Mtetra
.778 .617 .68 r
.68514 .55924 .68611 .56052 .68687 .55706 .68589 .55573 Mtetra
.796 .616 .658 r
.68589 .55573 .68687 .55706 .68756 .5523 .68658 .55091 Mtetra
.806 .615 .644 r
.68658 .55091 .68756 .5523 .6882 .5462 .68722 .54473 Mtetra
.812 .613 .634 r
.68722 .54473 .6882 .5462 .68878 .53884 .68779 .53728 Mtetra
.814 .611 .628 r
.68779 .53728 .68878 .53884 .68931 .53044 .68832 .52876 Mtetra
.814 .609 .625 r
.68832 .52876 .68931 .53044 .68982 .52142 .68882 .51962 Mtetra
.811 .606 .625 r
.68882 .51962 .68982 .52142 .69032 .51243 .68932 .51052 Mtetra
.803 .602 .63 r
.68932 .51052 .69032 .51243 .69086 .50434 .68986 .50232 Mtetra
.786 .595 .642 r
.68986 .50232 .69086 .50434 .69147 .49805 .69047 .49595 Mtetra
.743 .577 .669 r
.69047 .49595 .69147 .49805 .69221 .49435 .6912 .49221 Mtetra
.558 .491 .736 r
.6912 .49221 .69221 .49435 .69308 .49372 .69207 .49157 Mtetra
.789 .404 0 r
.69207 .49157 .69308 .49372 .69409 .49618 .69308 .49407 Mtetra
.943 .611 .37 r
.69308 .49407 .69409 .49618 .69522 .50131 .69422 .49927 Mtetra
.923 .618 .448 r
.69422 .49927 .69522 .50131 .69644 .50834 .69544 .5064 Mtetra
.912 .617 .472 r
.69544 .5064 .69644 .50834 .69771 .51635 .69672 .51454 Mtetra
.908 .614 .477 r
.69672 .51454 .69771 .51635 .699 .5245 .698 .5228 Mtetra
.907 .61 .472 r
.698 .5228 .699 .5245 .70026 .53208 .69926 .5305 Mtetra
.909 .604 .457 r
.69926 .5305 .70026 .53208 .70147 .53866 .70049 .53717 Mtetra
.914 .594 .426 r
.70049 .53717 .70147 .53866 .70264 .544 .70165 .54259 Mtetra
.92 .573 .363 r
.70165 .54259 .70264 .544 .70374 .548 .70276 .54666 Mtetra
.912 .512 .209 r
.70276 .54666 .70374 .548 .70478 .55069 .7038 .54939 Mtetra
.662 .199 0 r
.7038 .54939 .70478 .55069 .70577 .55211 .70479 .55084 Mtetra
.336 .471 .847 r
.70479 .55084 .70577 .55211 .7067 .55231 .70572 .55104 Mtetra
.658 .596 .774 r
.70572 .55104 .7067 .55231 .70757 .5513 .70659 .55002 Mtetra
.743 .614 .714 r
.70659 .55002 .70757 .5513 .70838 .54906 .7074 .54775 Mtetra
.779 .617 .679 r
.7074 .54775 .70838 .54906 .70914 .54555 .70815 .5442 Mtetra
.797 .616 .657 r
.70815 .5442 .70914 .54555 .70983 .54072 .70884 .53931 Mtetra
.807 .615 .642 r
.70884 .53931 .70983 .54072 .71045 .53455 .70946 .53306 Mtetra
.813 .613 .632 r
.70946 .53306 .71045 .53455 .71101 .52712 .71001 .52553 Mtetra
.816 .611 .626 r
.71001 .52553 .71101 .52712 .71151 .51865 .71051 .51695 Mtetra
.815 .609 .623 r
.71051 .51695 .71151 .51865 .71199 .50959 .71098 .50777 Mtetra
.812 .606 .624 r
.71098 .50777 .71199 .50959 .71246 .50061 .71146 .49867 Mtetra
.803 .602 .629 r
.71146 .49867 .71246 .50061 .71298 .49257 .71197 .49052 Mtetra
.785 .594 .642 r
.71197 .49052 .71298 .49257 .71359 .48638 .71258 .48425 Mtetra
.738 .575 .671 r
.71258 .48425 .71359 .48638 .71433 .48284 .71332 .48067 Mtetra
.529 .476 .741 r
.71332 .48067 .71433 .48284 .71523 .4824 .71421 .48023 Mtetra
.821 .432 0 r
.71421 .48023 .71523 .4824 .71628 .48507 .71526 .48294 Mtetra
.943 .61 .367 r
.71526 .48294 .71628 .48507 .71747 .49038 .71645 .48833 Mtetra
.925 .617 .442 r
.71645 .48833 .71747 .49038 .71875 .49756 .71774 .49561 Mtetra
.915 .616 .465 r
.71774 .49561 .71875 .49756 .72009 .50569 .71908 .50387 Mtetra
.91 .613 .47 r
.71908 .50387 .72009 .50569 .72144 .51392 .72043 .51221 Mtetra
.909 .609 .465 r
.72043 .51221 .72144 .51392 .72276 .52155 .72176 .51996 Mtetra
.911 .603 .448 r
.72176 .51996 .72276 .52155 .72403 .52816 .72303 .52666 Mtetra
.916 .592 .415 r
.72303 .52666 .72403 .52816 .72524 .5335 .72425 .53208 Mtetra
.921 .569 .349 r
.72425 .53208 .72524 .5335 .72638 .53751 .72539 .53615 Mtetra
.909 .502 .185 r
.72539 .53615 .72638 .53751 .72746 .54019 .72647 .53887 Mtetra
.626 .167 0 r
.72647 .53887 .72746 .54019 .72847 .54159 .72748 .5403 Mtetra
.35 .477 .847 r
.72748 .5403 .72847 .54159 .72942 .54177 .72843 .54049 Mtetra
.659 .596 .773 r
.72843 .54049 .72942 .54177 .73031 .54072 .72932 .53943 Mtetra
.745 .614 .714 r
.72932 .53943 .73031 .54072 .73113 .53844 .73014 .53713 Mtetra
.78 .617 .678 r
.73014 .53713 .73113 .53844 .73188 .53488 .73089 .53352 Mtetra
.798 .617 .656 r
.73089 .53352 .73188 .53488 .73256 .52999 .73156 .52856 Mtetra
.809 .615 .641 r
.73156 .52856 .73256 .52999 .73317 .52375 .73217 .52224 Mtetra
.814 .614 .631 r
.73217 .52224 .73317 .52375 .7337 .51624 .7327 .51463 Mtetra
.817 .611 .625 r
.7327 .51463 .7337 .51624 .73418 .50771 .73317 .50598 Mtetra
.817 .609 .622 r
.73317 .50598 .73418 .50771 .73463 .4986 .73361 .49676 Mtetra
.813 .606 .623 r
.73361 .49676 .73463 .4986 .73508 .48962 .73406 .48765 Mtetra
.804 .602 .628 r
.73406 .48765 .73508 .48962 .73558 .48162 .73455 .47955 Mtetra
.784 .594 .642 r
.73455 .47955 .73558 .48162 .73618 .47555 .73515 .4734 Mtetra
.733 .572 .674 r
.73515 .4734 .73618 .47555 .73693 .47217 .7359 .46998 Mtetra
.494 .458 .746 r
.7359 .46998 .73693 .47217 .73785 .47192 .73683 .46974 Mtetra
.845 .455 0 r
.73683 .46974 .73785 .47192 .73895 .47479 .73792 .47265 Mtetra
.943 .608 .363 r
.73792 .47265 .73895 .47479 .7402 .48029 .73917 .47823 Mtetra
.926 .616 .436 r
.73917 .47823 .7402 .48029 .74155 .48763 .74053 .48568 Mtetra
.917 .615 .459 r
.74053 .48568 .74155 .48763 .74296 .49589 .74194 .49405 Mtetra
.912 .612 .463 r
.74194 .49405 .74296 .49589 .74437 .5042 .74336 .50248 Mtetra
.912 .608 .457 r
.74336 .50248 .74437 .5042 .74576 .51188 .74475 .51028 Mtetra
.914 .601 .44 r
.74475 .51028 .74576 .51188 .74708 .51852 .74608 .51701 Mtetra
.918 .59 .405 r
.74608 .51701 .74708 .51852 .74834 .52387 .74734 .52244 Mtetra
.922 .565 .335 r
.74734 .52244 .74834 .52387 .74953 .52788 .74853 .52651 Mtetra
.904 .492 .161 r
.74853 .52651 .74953 .52788 .75064 .53055 .74964 .52923 Mtetra
.591 .136 0 r
.74964 .52923 .75064 .53055 .75168 .53194 .75068 .53064 Mtetra
.363 .484 .848 r
.75068 .53064 .75168 .53194 .75265 .53209 .75165 .5308 Mtetra
.662 .598 .773 r
.75165 .5308 .75265 .53209 .75355 .53102 .75255 .52972 Mtetra
.746 .615 .713 r
.75255 .52972 .75355 .53102 .75437 .52869 .75338 .52737 Mtetra
.782 .618 .677 r
.75338 .52737 .75437 .52869 .75512 .52508 .75412 .5237 Mtetra
.8 .617 .654 r
.75412 .5237 .75512 .52508 .7558 .52011 .75479 .51867 Mtetra
.811 .616 .639 r
.75479 .51867 .7558 .52011 .75639 .51379 .75538 .51227 Mtetra
.816 .614 .629 r
.75538 .51227 .75639 .51379 .7569 .50621 .75589 .50458 Mtetra
.819 .612 .623 r
.75589 .50458 .7569 .50621 .75735 .4976 .75633 .49586 Mtetra
.818 .609 .62 r
.75633 .49586 .75735 .4976 .75777 .48845 .75674 .48659 Mtetra
.814 .606 .621 r
.75674 .48659 .75777 .48845 .75819 .47946 .75716 .47748 Mtetra
.805 .602 .628 r
.75716 .47748 .75819 .47946 .75867 .47152 .75763 .46943 Mtetra
.784 .593 .642 r
.75763 .46943 .75867 .47152 .75927 .46555 .75823 .46339 Mtetra
.728 .57 .677 r
.75823 .46339 .75927 .46555 .76003 .46233 .75899 .46013 Mtetra
.455 .438 .751 r
.75899 .46013 .76003 .46233 .76099 .46228 .75994 .46008 Mtetra
.864 .473 0 r
.75994 .46008 .76099 .46228 .76213 .46535 .76109 .4632 Mtetra
.943 .607 .36 r
.76109 .4632 .76213 .46535 .76344 .47105 .7624 .46898 Mtetra
.927 .615 .43 r
.7624 .46898 .76344 .47105 .76486 .47855 .76383 .47659 Mtetra
.918 .614 .452 r
.76383 .47659 .76486 .47855 .76634 .48693 .76531 .48509 Mtetra
.914 .611 .456 r
.76531 .48509 .76634 .48693 .76783 .49532 .76681 .4936 Mtetra
.914 .607 .449 r
.76681 .4936 .76783 .49532 .76928 .50306 .76826 .50145 Mtetra
.916 .599 .431 r
.76826 .50145 .76928 .50306 .77066 .50972 .76965 .50821 Mtetra
.92 .587 .394 r
.76965 .50821 .77066 .50972 .77197 .51509 .77096 .51366 Mtetra
.922 .56 .32 r
.77096 .51366 .77197 .51509 .7732 .51909 .7722 .51773 Mtetra
.898 .48 .137 r
.7722 .51773 .7732 .51909 .77435 .52176 .77334 .52043 Mtetra
0 0 .435 r
.77334 .52043 .77435 .52176 .77542 .52314 .77441 .52183 Mtetra
.375 .491 .849 r
.77441 .52183 .77542 .52314 .77641 .52326 .7754 .52197 Mtetra
.665 .6 .772 r
.7754 .52197 .77641 .52326 .77732 .52215 .77631 .52085 Mtetra
.748 .617 .712 r
.77631 .52085 .77732 .52215 .77815 .51978 .77715 .51844 Mtetra
.784 .619 .676 r
.77715 .51844 .77815 .51978 .7789 .5161 .77789 .51472 Mtetra
.802 .618 .653 r
.77789 .51472 .7789 .5161 .77956 .51106 .77855 .50961 Mtetra
.813 .617 .638 r
.77855 .50961 .77956 .51106 .78013 .50466 .77912 .50312 Mtetra
.818 .615 .627 r
.77912 .50312 .78013 .50466 .78062 .49698 .7796 .49535 Mtetra
.821 .612 .621 r
.7796 .49535 .78062 .49698 .78104 .4883 .78002 .48655 Mtetra
.82 .61 .619 r
.78002 .48655 .78104 .4883 .78143 .4791 .78039 .47722 Mtetra
.816 .607 .62 r
.78039 .47722 .78143 .4791 .78182 .4701 .78078 .4681 Mtetra
.805 .602 .627 r
.78078 .4681 .78182 .4701 .78229 .4622 .78124 .4601 Mtetra
.783 .593 .643 r
.78124 .4601 .78229 .4622 .78288 .45634 .78183 .45417 Mtetra
.722 .568 .68 r
.78183 .45417 .78288 .45634 .78366 .45328 .78261 .45107 Mtetra
.411 .415 .754 r
.78261 .45107 .78366 .45328 .78465 .45343 .78359 .45122 Mtetra
.878 .487 .025 r
.78359 .45122 .78465 .45343 .78584 .4567 .78479 .45455 Mtetra
.943 .605 .355 r
.78479 .45455 .78584 .4567 .78722 .46259 .78617 .46052 Mtetra
.928 .613 .423 r
.78617 .46052 .78722 .46259 .78871 .47026 .78767 .46829 Mtetra
.92 .612 .445 r
.78767 .46829 .78871 .47026 .79027 .47876 .78923 .47692 Mtetra
.916 .61 .449 r
.78923 .47692 .79027 .47876 .79183 .48724 .7908 .48552 Mtetra
.916 .605 .441 r
.7908 .48552 .79183 .48724 .79335 .49503 .79232 .49342 Mtetra
.917 .597 .422 r
.79232 .49342 .79335 .49503 .79479 .50172 .79377 .50021 Mtetra
.921 .583 .383 r
.79377 .50021 .79479 .50172 .79616 .5071 .79514 .50567 Mtetra
.922 .554 .305 r
.79514 .50567 .79616 .5071 .79743 .5111 .79642 .50974 Mtetra
.892 .467 .113 r
.79642 .50974 .79743 .5111 .79861 .51376 .7976 .51243 Mtetra
0 0 .47 r
.7976 .51243 .79861 .51376 .79971 .51512 .7987 .51381 Mtetra
.388 .499 .85 r
.7987 .51381 .79971 .51512 .80072 .51521 .79971 .51392 Mtetra
.668 .602 .772 r
.79971 .51392 .80072 .51521 .80165 .51406 .80064 .51276 Mtetra
.751 .618 .712 r
.80064 .51276 .80165 .51406 .80249 .51164 .80147 .5103 Mtetra
.786 .62 .675 r
.80147 .5103 .80249 .51164 .80323 .50789 .80222 .50651 Mtetra
.805 .619 .652 r
.80222 .50651 .80323 .50789 .80388 .50277 .80286 .50132 Mtetra
.815 .618 .636 r
.80286 .50132 .80388 .50277 .80444 .49628 .80341 .49474 Mtetra
.82 .615 .625 r
.80341 .49474 .80444 .49628 .8049 .48851 .80387 .48686 Mtetra
.823 .613 .619 r
.80387 .48686 .8049 .48851 .80529 .47974 .80425 .47798 Mtetra
.822 .61 .617 r
.80425 .47798 .80529 .47974 .80564 .47048 .8046 .46859 Mtetra
.817 .607 .619 r
.8046 .46859 .80564 .47048 .80601 .46146 .80496 .45946 Mtetra
.806 .602 .626 r
.80496 .45946 .80601 .46146 .80645 .45361 .80539 .4515 Mtetra
.783 .593 .643 r
.80539 .4515 .80645 .45361 .80705 .44786 .80598 .44567 Mtetra
.716 .566 .683 r
.80598 .44567 .80705 .44786 .80784 .44496 .80677 .44273 Mtetra
.361 .389 .755 r
.80677 .44273 .80784 .44496 .80887 .44529 .8078 .44308 Mtetra
.888 .497 .048 r
.8078 .44308 .80887 .44529 .81012 .44878 .80906 .44662 Mtetra
.943 .603 .351 r
.80906 .44662 .81012 .44878 .81156 .45486 .8105 .45278 Mtetra
.93 .611 .417 r
.8105 .45278 .81156 .45486 .81314 .46268 .81208 .46072 Mtetra
.922 .611 .438 r
.81208 .46072 .81314 .46268 .81477 .47131 .81373 .46947 Mtetra
.918 .608 .441 r
.81373 .46947 .81477 .47131 .81641 .47987 .81537 .47815 Mtetra
.917 .603 .433 r
.81537 .47815 .81641 .47987 .818 .48771 .81696 .48611 Mtetra
.919 .594 .412 r
.81696 .48611 .818 .48771 .81951 .49443 .81848 .49293 Mtetra
.922 .58 .372 r
.81848 .49293 .81951 .49443 .82092 .49982 .8199 .4984 Mtetra
.921 .548 .29 r
.8199 .4984 .82092 .49982 .82224 .50382 .82122 .50246 Mtetra
.884 .453 .087 r
.82122 .50246 .82224 .50382 .82346 .50647 .82244 .50514 Mtetra
0 0 .504 r
.82244 .50514 .82346 .50647 .82459 .5078 .82357 .5065 Mtetra
.402 .507 .851 r
.82357 .5065 .82459 .5078 .82562 .50786 .8246 .50657 Mtetra
.673 .605 .772 r
.8246 .50657 .82562 .50786 .82656 .50667 .82554 .50536 Mtetra
.754 .62 .711 r
.82554 .50536 .82656 .50667 .82741 .50419 .82639 .50285 Mtetra
.789 .622 .674 r
.82639 .50285 .82741 .50419 .82815 .50036 .82713 .49898 Mtetra
.807 .621 .65 r
.82713 .49898 .82815 .50036 .82879 .49515 .82776 .4937 Mtetra
.817 .619 .634 r
.82776 .4937 .82879 .49515 .82932 .48856 .82829 .48701 Mtetra
.823 .616 .623 r
.82829 .48701 .82932 .48856 .82976 .48069 .82872 .47904 Mtetra
.825 .614 .617 r
.82872 .47904 .82976 .48069 .83011 .47183 .82906 .47006 Mtetra
.824 .611 .615 r
.82906 .47006 .83011 .47183 .83043 .4625 .82937 .4606 Mtetra
.819 .608 .617 r
.82937 .4606 .83043 .4625 .83077 .45347 .8297 .45145 Mtetra
.807 .603 .625 r
.8297 .45145 .83077 .45347 .83119 .44565 .83012 .44353 Mtetra
.782 .593 .644 r
.83012 .44353 .83119 .44565 .83179 .44 .83071 .4378 Mtetra
.71 .564 .687 r
.83071 .4378 .83179 .44 .8326 .43726 .83152 .43503 Mtetra
.305 .359 .754 r
.83152 .43503 .8326 .43726 .83367 .43779 .83259 .43557 Mtetra
.896 .505 .066 r
.83259 .43557 .83367 .43779 .83498 .44148 .8339 .43931 Mtetra
.942 .6 .346 r
.8339 .43931 .83498 .44148 .8365 .44775 .83543 .44567 Mtetra
.931 .609 .409 r
.83543 .44567 .8365 .44775 .83815 .45574 .83709 .45378 Mtetra
.923 .609 .43 r
.83709 .45378 .83815 .45574 .83987 .46448 .83881 .46265 Mtetra
.92 .606 .433 r
.83881 .46265 .83987 .46448 .84158 .47313 .84054 .47142 Mtetra
.919 .6 .424 r
.84054 .47142 .84158 .47313 .84325 .48102 .8422 .47942 Mtetra
.92 .591 .402 r
.8422 .47942 .84325 .48102 .84482 .48776 .84379 .48626 Mtetra
.923 .575 .36 r
.84379 .48626 .84482 .48776 .84629 .49316 .84526 .49174 Mtetra
.92 .541 .273 r
.84526 .49174 .84629 .49316 .84766 .49715 .84663 .4958 Mtetra
.875 .438 .06 r
.84663 .4958 .84766 .49715 .84892 .49978 .84789 .49846 Mtetra
0 0 .539 r
.84789 .49846 .84892 .49978 .85008 .50109 .84905 .49979 Mtetra
.417 .517 .853 r
.84905 .49979 .85008 .50109 .85113 .50111 .85011 .49982 Mtetra
.678 .609 .771 r
.85011 .49982 .85113 .50111 .85208 .49987 .85106 .49856 Mtetra
.758 .622 .71 r
.85106 .49856 .85208 .49987 .85293 .49732 .85191 .49598 Mtetra
.792 .624 .672 r
.85191 .49598 .85293 .49732 .85367 .49341 .85264 .49203 Mtetra
.81 .622 .648 r
.85264 .49203 .85367 .49341 .8543 .48811 .85326 .48665 Mtetra
.82 .62 .632 r
.85326 .48665 .8543 .48811 .85481 .48141 .85377 .47986 Mtetra
.825 .617 .621 r
.85377 .47986 .85481 .48141 .85521 .47342 .85416 .47177 Mtetra
.827 .614 .615 r
.85416 .47177 .85521 .47342 .85554 .46446 .85448 .46269 Mtetra
.826 .612 .613 r
.85448 .46269 .85554 .46446 .85582 .45507 .85475 .45316 Mtetra
.821 .608 .615 r
.85475 .45316 .85582 .45507 .85612 .44601 .85505 .44398 Mtetra
.809 .603 .624 r
.85505 .44398 .85612 .44601 .85653 .43823 .85545 .4361 Mtetra
.782 .593 .644 r
.85545 .4361 .85653 .43823 .85712 .43267 .85604 .43047 Mtetra
.703 .561 .691 r
.85604 .43047 .85712 .43267 .85796 .43009 .85687 .42785 Mtetra
.244 .326 .749 r
.85687 .42785 .85796 .43009 .85907 .43081 .85798 .42859 Mtetra
.901 .51 .08 r
.85798 .42859 .85907 .43081 .86045 .4347 .85936 .43254 Mtetra
.942 .598 .34 r
.85936 .43254 .86045 .4347 .86204 .44116 .86096 .43909 Mtetra
.932 .607 .402 r
.86096 .43909 .86204 .44116 .86378 .44931 .86271 .44736 Mtetra
.925 .607 .422 r
.86271 .44736 .86378 .44931 .86559 .45818 .86452 .45635 Mtetra
.921 .604 .424 r
.86452 .45635 .86559 .45818 .86738 .4669 .86633 .4652 Mtetra
.921 .598 .415 r
.86633 .4652 .86738 .4669 .86912 .47485 .86807 .47326 Mtetra
.922 .588 .392 r
.86807 .47326 .86912 .47485 .87076 .48161 .86972 .48012 Mtetra
.923 .571 .347 r
.86972 .48012 .87076 .48161 .8723 .48701 .87126 .4856 Mtetra
.918 .533 .256 r
.87126 .4856 .8723 .48701 .87371 .491 .87268 .48964 Mtetra
.864 .421 .031 r
.87268 .48964 .87371 .491 .87501 .4936 .87398 .49229 Mtetra
0 .028 .575 r
.87398 .49229 .87501 .4936 .87619 .49488 .87516 .49359 Mtetra
.432 .526 .854 r
.87516 .49359 .87619 .49488 .87727 .49486 .87624 .49357 Mtetra
.683 .612 .771 r
.87624 .49357 .87727 .49486 .87824 .49356 .87721 .49226 Mtetra
.761 .625 .709 r
.87721 .49226 .87824 .49356 .87909 .49094 .87806 .4896 Mtetra
.795 .625 .671 r
.87806 .4896 .87909 .49094 .87983 .48694 .87879 .48556 Mtetra
.813 .623 .646 r
.87879 .48556 .87983 .48694 .88044 .48153 .87939 .48007 Mtetra
.823 .621 .63 r
.87939 .48007 .88044 .48153 .88093 .47471 .87987 .47316 Mtetra
.828 .618 .619 r
.87987 .47316 .88093 .47471 .8813 .46661 .88024 .46495 Mtetra
.83 .615 .613 r
.88024 .46495 .8813 .46661 .88158 .45755 .88051 .45576 Mtetra
.828 .612 .611 r
.88051 .45576 .88158 .45755 .88183 .44807 .88075 .44615 Mtetra
.822 .609 .614 r
.88075 .44615 .88183 .44807 .8821 .43898 .88101 .43694 Mtetra
.81 .603 .623 r
.88101 .43694 .8821 .43898 .88249 .43123 .8814 .42909 Mtetra
.781 .592 .645 r
.8814 .42909 .88249 .43123 .88308 .42578 .88198 .42356 Mtetra
.696 .558 .695 r
.88198 .42356 .88308 .42578 .88394 .42334 .88284 .4211 Mtetra
.179 .289 .741 r
.88284 .4211 .88394 .42334 .8851 .42426 .884 .42204 Mtetra
.904 .513 .09 r
.884 .42204 .8851 .42426 .88655 .42836 .88545 .42619 Mtetra
.942 .595 .333 r
.88545 .42619 .88655 .42836 .88822 .43501 .88713 .43294 Mtetra
.932 .605 .393 r
.88713 .43294 .88822 .43501 .89005 .44331 .88897 .44136 Mtetra
.926 .605 .413 r
.88897 .44136 .89005 .44331 .89195 .4523 .89087 .45047 Mtetra
.923 .601 .415 r
.89087 .45047 .89195 .4523 .89383 .4611 .89276 .4594 Mtetra
.922 .595 .405 r
.89276 .4594 .89383 .4611 .89565 .46909 .89459 .46751 Mtetra
.923 .585 .38 r
.89459 .46751 .89565 .46909 .89736 .47588 .89631 .47439 Mtetra
.923 .566 .333 r
.89631 .47439 .89736 .47588 .89895 .48128 .8979 .47987 Mtetra
.916 .524 .237 r
.8979 .47987 .89895 .48128 .90041 .48525 .89937 .4839 Mtetra
.851 .402 0 r
.89937 .4839 .90041 .48525 .90175 .48783 .90071 .48652 Mtetra
0 .065 .61 r
.90071 .48652 .90175 .48783 .90297 .48907 .90193 .48779 Mtetra
.448 .536 .854 r
.90193 .48779 .90297 .48907 .90407 .48901 .90303 .48772 Mtetra
.689 .616 .77 r
.90303 .48772 .90407 .48901 .90505 .48764 .90401 .48634 Mtetra
.765 .627 .707 r
.90401 .48634 .90505 .48764 .90591 .48494 .90487 .48361 Mtetra
.799 .627 .669 r
.90487 .48361 .90591 .48494 .90664 .48085 .90559 .47946 Mtetra
.816 .625 .644 r
.90559 .47946 .90664 .48085 .90723 .47533 .90618 .47387 Mtetra
.826 .622 .627 r
.90618 .47387 .90723 .47533 .90769 .46839 .90663 .46683 Mtetra
.831 .619 .617 r
.90663 .46683 .90769 .46839 .90803 .46016 .90696 .45849 Mtetra
.832 .616 .61 r
.90696 .45849 .90803 .46016 .90827 .45098 .90719 .44918 Mtetra
.83 .613 .609 r
.90719 .44918 .90827 .45098 .90848 .44142 .90739 .43949 Mtetra
.824 .609 .612 r
.90739 .43949 .90848 .44142 .90872 .43229 .90762 .43025 Mtetra
.811 .604 .622 r
.90762 .43025 .90872 .43229 .90909 .42458 .90798 .42243 Mtetra
.78 .592 .646 r
.90798 .42243 .90909 .42458 .90969 .41922 .90857 .417 Mtetra
.687 .555 .7 r
.90857 .417 .90969 .41922 .91057 .41694 .90946 .41469 Mtetra
.11 .25 .728 r
.90946 .41469 .91057 .41694 .91178 .41805 .91067 .41582 Mtetra
.907 .515 .097 r
.91067 .41582 .91178 .41805 .9133 .42235 .91218 .42018 Mtetra
.942 .592 .325 r
.91218 .42018 .9133 .42235 .91506 .42919 .91395 .42712 Mtetra
.933 .602 .384 r
.91395 .42712 .91506 .42919 .91698 .43765 .91589 .4357 Mtetra
.927 .602 .404 r
.91589 .4357 .91698 .43765 .91897 .44675 .91789 .44493 Mtetra
.924 .599 .406 r
.91789 .44493 .91897 .44675 .92095 .45563 .91987 .45394 Mtetra
.924 .592 .394 r
.91987 .45394 .92095 .45563 .92284 .46366 .92178 .46209 Mtetra
.924 .581 .368 r
.92178 .46209 .92284 .46366 .92463 .47047 .92357 .46899 Mtetra
.923 .56 .318 r
.92357 .46899 .92463 .47047 .92628 .47587 .92523 .47447 Mtetra
.913 .515 .216 r
.92523 .47447 .92628 .47587 .92779 .47982 .92674 .47848 Mtetra
.836 .381 0 r
.92674 .47848 .92779 .47982 .92917 .48238 .92813 .48108 Mtetra
0 .103 .645 r
.92813 .48108 .92917 .48238 .93042 .48358 .92938 .4823 Mtetra
.465 .546 .855 r
.92938 .4823 .93042 .48358 .93154 .48346 .9305 .48218 Mtetra
.695 .62 .768 r
.9305 .48218 .93154 .48346 .93254 .48203 .93149 .48073 Mtetra
.769 .63 .706 r
.93149 .48073 .93254 .48203 .9334 .47924 .93235 .47791 Mtetra
.802 .629 .667 r
.93235 .47791 .9334 .47924 .93412 .47505 .93306 .47366 Mtetra
.819 .626 .642 r
.93306 .47366 .93412 .47505 .93469 .46941 .93363 .46794 Mtetra
.829 .623 .625 r
.93363 .46794 .93469 .46941 .93513 .46233 .93406 .46077 Mtetra
.833 .62 .614 r
.93406 .46077 .93513 .46233 .93543 .45397 .93435 .4523 Mtetra
.835 .617 .608 r
.93435 .4523 .93543 .45397 .93563 .44467 .93454 .44287 Mtetra
.833 .614 .606 r
.93454 .44287 .93563 .44467 .93579 .43502 .93469 .43309 Mtetra
.826 .61 .61 r
.93469 .43309 .93579 .43502 .936 .42586 .93489 .4238 Mtetra
.812 .604 .621 r
.93489 .4238 .936 .42586 .93636 .41817 .93524 .41601 Mtetra
.779 .592 .647 r
.93524 .41601 .93636 .41817 .93696 .41291 .93583 .41068 Mtetra
.678 .552 .705 r
.93583 .41068 .93696 .41291 .93787 .41079 .93674 .40853 Mtetra
.039 .209 .712 r
.93674 .40853 .93787 .41079 .93913 .41209 .938 .40985 Mtetra
.907 .515 .101 r
.938 .40985 .93913 .41209 .94072 .41659 .9396 .41442 Mtetra
.941 .589 .317 r
.9396 .41442 .94072 .41659 .94258 .42362 .94146 .42155 Mtetra
.934 .599 .375 r
.94146 .42155 .94258 .42362 .9446 .43224 .94349 .43029 Mtetra
.929 .599 .394 r
.94349 .43029 .9446 .43224 .94669 .44145 .94559 .43963 Mtetra
.926 .596 .395 r
.94559 .43963 .94669 .44145 .94875 .45041 .94767 .44872 Mtetra
.925 .589 .383 r
.94767 .44872 .94875 .45041 .95073 .45848 .94966 .45691 Mtetra
.925 .577 .355 r
.94966 .45691 .95073 .45848 .95259 .4653 .95153 .46383 Mtetra
.923 .554 .302 r
.95153 .46383 .95259 .4653 .95431 .4707 .95325 .4693 Mtetra
.909 .505 .194 r
.95325 .4693 .95431 .4707 .95587 .47464 .95482 .4733 Mtetra
.819 .358 0 r
.95482 .4733 .95587 .47464 .95729 .47716 .95624 .47586 Mtetra
0 .142 .678 r
.95624 .47586 .95729 .47716 .95858 .47832 .95753 .47704 Mtetra
.481 .555 .854 r
.95753 .47704 .95858 .47832 .95972 .47814 .95867 .47686 Mtetra
.701 .623 .767 r
.95867 .47686 .95972 .47814 .96073 .47663 .95967 .47534 Mtetra
.773 .632 .704 r
.95967 .47534 .96073 .47663 .96159 .47376 .96053 .47242 Mtetra
.806 .631 .665 r
.96053 .47242 .96159 .47376 .9623 .46946 .96124 .46807 Mtetra
.822 .628 .639 r
.96124 .46807 .9623 .46946 .96286 .46369 .96179 .46222 Mtetra
.832 .624 .622 r
.96179 .46222 .96286 .46369 .96326 .45648 .96218 .45491 Mtetra
.836 .621 .611 r
.96218 .45491 .96326 .45648 .96352 .44798 .96243 .44629 Mtetra
.837 .618 .605 r
.96243 .44629 .96352 .44798 .96368 .43855 .96257 .43674 Mtetra
.835 .614 .604 r
.96257 .43674 .96368 .43855 .9638 .42881 .96268 .42686 Mtetra
.828 .61 .608 r
.96268 .42686 .9638 .42881 .96397 .41961 .96285 .41754 Mtetra
.813 .605 .62 r
.96285 .41754 .96397 .41961 .96431 .41195 .96317 .40977 Mtetra
.778 .592 .648 r
.96317 .40977 .96431 .41195 .96491 .40678 .96377 .40454 Mtetra
.668 .548 .71 r
.96377 .40454 .96491 .40678 .96586 .40481 .96471 .40255 Mtetra
.622 .315 .429 r
.50902 .61988 .50993 .61872 .51068 .61964 .50978 .62077 Mtetra
.763 .499 .536 r
.50978 .62077 .51068 .61964 .51146 .62337 .51055 .62443 Mtetra
.791 .538 .555 r
.51055 .62443 .51146 .62337 .51224 .6293 .51133 .63025 Mtetra
.802 .553 .561 r
.51133 .63025 .51224 .6293 .51304 .63659 .51213 .63741 Mtetra
.808 .559 .562 r
.51213 .63741 .51304 .63659 .51384 .64436 .51293 .64505 Mtetra
.811 .56 .559 r
.51293 .64505 .51384 .64436 .51464 .65186 .51373 .65241 Mtetra
.812 .557 .553 r
.51373 .65241 .51464 .65186 .51544 .65855 .51452 .65897 Mtetra
.811 .55 .543 r
.51452 .65897 .51544 .65855 .51624 .66411 .51532 .66443 Mtetra
.808 .535 .526 r
.51532 .66443 .51624 .66411 .51703 .6684 .51611 .66864 Mtetra
.8 .507 .493 r
.51611 .66864 .51703 .6684 .51782 .6714 .5169 .67158 Mtetra
.775 .439 .419 r
.5169 .67158 .51782 .6714 .5186 .67315 .51768 .67329 Mtetra
.619 .147 .11 r
.51768 .67329 .5186 .67315 .51938 .6737 .51845 .67382 Mtetra
.748 .926 .949 r
.51845 .67382 .51938 .6737 .52014 .67307 .51922 .67319 Mtetra
.855 .768 .765 r
.51922 .67319 .52014 .67307 .52091 .67127 .51998 .67141 Mtetra
.857 .711 .7 r
.51998 .67141 .52091 .67127 .52166 .66826 .52074 .66844 Mtetra
.856 .685 .67 r
.52074 .66844 .52166 .66826 .5224 .664 .52148 .66423 Mtetra
.855 .671 .652 r
.52148 .66423 .5224 .664 .52314 .65844 .52222 .65876 Mtetra
.856 .663 .641 r
.52222 .65876 .52314 .65844 .52386 .65161 .52294 .65203 Mtetra
.857 .659 .634 r
.52294 .65203 .52386 .65161 .52457 .64366 .52366 .6442 Mtetra
.859 .658 .63 r
.52366 .6442 .52457 .64366 .52528 .63491 .52437 .63558 Mtetra
.862 .66 .628 r
.52437 .63558 .52528 .63491 .52598 .62591 .52507 .62673 Mtetra
.868 .667 .629 r
.52507 .62673 .52598 .62591 .52669 .61744 .52578 .61838 Mtetra
.879 .683 .634 r
.52578 .61838 .52669 .61744 .5274 .61036 .52649 .61141 Mtetra
.903 .726 .652 r
.52649 .61141 .5274 .61036 .52813 .60553 .52723 .60665 Mtetra
.964 .917 .711 r
.52723 .60665 .52813 .60553 .52888 .60355 .52798 .60469 Mtetra
.641 .336 .439 r
.52798 .60469 .52888 .60355 .52966 .60462 .52876 .60573 Mtetra
.766 .502 .534 r
.52876 .60573 .52966 .60462 .53046 .6085 .52956 .60953 Mtetra
.793 .539 .553 r
.52956 .60953 .53046 .6085 .53129 .61455 .53038 .61548 Mtetra
.804 .553 .559 r
.53038 .61548 .53129 .61455 .53213 .62192 .53122 .62271 Mtetra
.81 .559 .559 r
.53122 .62271 .53213 .62192 .53297 .62973 .53206 .63038 Mtetra
.813 .56 .556 r
.53206 .63038 .53297 .62973 .53382 .63723 .53291 .63775 Mtetra
.814 .557 .55 r
.53291 .63775 .53382 .63723 .53466 .6439 .53375 .6443 Mtetra
.813 .549 .539 r
.53375 .6443 .53466 .6439 .5355 .64943 .53458 .64972 Mtetra
.81 .534 .52 r
.53458 .64972 .5355 .64943 .53632 .65367 .5354 .65389 Mtetra
.802 .504 .486 r
.5354 .65389 .53632 .65367 .53714 .65663 .53622 .65678 Mtetra
.774 .432 .406 r
.53622 .65678 .53714 .65663 .53794 .65833 .53702 .65845 Mtetra
.593 .1 .051 r
.53702 .65845 .53794 .65833 .53873 .65883 .53781 .65892 Mtetra
.765 .913 .939 r
.53781 .65892 .53873 .65883 .53951 .65814 .53859 .65824 Mtetra
.855 .764 .761 r
.53859 .65824 .53951 .65814 .54028 .65628 .53935 .6564 Mtetra
.857 .71 .698 r
.53935 .6564 .54028 .65628 .54103 .6532 .54011 .65336 Mtetra
.857 .685 .668 r
.54011 .65336 .54103 .6532 .54177 .64886 .54085 .64908 Mtetra
.857 .671 .651 r
.54085 .64908 .54177 .64886 .54249 .64322 .54158 .64352 Mtetra
.857 .663 .639 r
.54158 .64352 .54249 .64322 .5432 .6363 .54229 .63671 Mtetra
.859 .659 .632 r
.54229 .63671 .5432 .6363 .5439 .62827 .54298 .6288 Mtetra
.861 .659 .628 r
.54298 .6288 .5439 .62827 .54458 .61946 .54367 .62013 Mtetra
.864 .661 .626 r
.54367 .62013 .54458 .61946 .54526 .61044 .54435 .61124 Mtetra
.87 .669 .627 r
.54435 .61124 .54526 .61044 .54594 .60198 .54504 .60291 Mtetra
.881 .686 .633 r
.54504 .60291 .54594 .60198 .54664 .59498 .54574 .59601 Mtetra
.907 .731 .652 r
.54574 .59601 .54664 .59498 .54736 .59026 .54646 .59136 Mtetra
.959 .94 .71 r
.54646 .59136 .54736 .59026 .54812 .58843 .54722 .58955 Mtetra
.658 .354 .446 r
.54722 .58955 .54812 .58843 .54892 .58966 .54802 .59075 Mtetra
.77 .504 .533 r
.54802 .59075 .54892 .58966 .54976 .59369 .54886 .5947 Mtetra
.796 .54 .55 r
.54886 .5947 .54976 .59369 .55062 .59986 .54972 .60076 Mtetra
.807 .553 .556 r
.54972 .60076 .55062 .59986 .55151 .60731 .55061 .60808 Mtetra
.812 .559 .556 r
.55061 .60808 .55151 .60731 .55241 .61516 .5515 .61579 Mtetra
.815 .56 .553 r
.5515 .61579 .55241 .61516 .5533 .62267 .55239 .62317 Mtetra
.816 .556 .546 r
.55239 .62317 .5533 .62267 .55418 .62933 .55327 .6297 Mtetra
.815 .548 .534 r
.55327 .6297 .55418 .62933 .55506 .63482 .55414 .63509 Mtetra
.812 .532 .515 r
.55414 .63509 .55506 .63482 .55591 .63903 .55499 .63922 Mtetra
.803 .501 .478 r
.55499 .63922 .55591 .63903 .55675 .64194 .55583 .64207 Mtetra
.774 .423 .391 r
.55583 .64207 .55675 .64194 .55758 .6436 .55665 .64369 Mtetra
.562 .047 0 r
.55665 .64369 .55758 .6436 .55838 .64404 .55746 .64412 Mtetra
.777 .9 .929 r
.55746 .64412 .55838 .64404 .55917 .64331 .55825 .64338 Mtetra
.855 .76 .758 r
.55825 .64338 .55917 .64331 .55995 .64138 .55902 .64148 Mtetra
.857 .709 .696 r
.55902 .64148 .55995 .64138 .5607 .63824 .55978 .63837 Mtetra
.858 .685 .666 r
.55978 .63837 .5607 .63824 .56144 .63382 .56052 .63402 Mtetra
.858 .671 .649 r
.56052 .63402 .56144 .63382 .56215 .62809 .56123 .62838 Mtetra
.859 .664 .638 r
.56123 .62838 .56215 .62809 .56284 .62109 .56193 .62149 Mtetra
.86 .66 .63 r
.56193 .62149 .56284 .62109 .56351 .61299 .5626 .6135 Mtetra
.863 .659 .626 r
.5626 .6135 .56351 .61299 .56417 .60412 .56327 .60477 Mtetra
.866 .662 .624 r
.56327 .60477 .56417 .60412 .56483 .59508 .56392 .59587 Mtetra
.873 .67 .626 r
.56392 .59587 .56483 .59508 .56549 .58664 .56459 .58756 Mtetra
.884 .688 .632 r
.56459 .58756 .56549 .58664 .56617 .57971 .56528 .58073 Mtetra
.911 .736 .653 r
.56528 .58073 .56617 .57971 .56689 .57512 .566 .5762 Mtetra
.945 .961 .704 r
.566 .5762 .56689 .57512 .56766 .57344 .56677 .57454 Mtetra
.673 .37 .453 r
.56677 .57454 .56766 .57344 .56848 .57484 .56759 .57591 Mtetra
.774 .506 .531 r
.56759 .57591 .56848 .57484 .56935 .57902 .56846 .58001 Mtetra
.798 .54 .548 r
.56846 .58001 .56935 .57902 .57026 .58531 .56937 .58619 Mtetra
.809 .554 .553 r
.56937 .58619 .57026 .58531 .5712 .59284 .5703 .59359 Mtetra
.814 .559 .553 r
.5703 .59359 .5712 .59284 .57214 .60074 .57124 .60134 Mtetra
.817 .559 .549 r
.57124 .60134 .57214 .60074 .57308 .60826 .57217 .60873 Mtetra
.818 .556 .542 r
.57217 .60873 .57308 .60826 .57401 .6149 .5731 .61525 Mtetra
.817 .547 .53 r
.5731 .61525 .57401 .6149 .57492 .62037 .57401 .62061 Mtetra
.814 .531 .509 r
.57401 .62061 .57492 .62037 .57581 .62454 .57489 .62471 Mtetra
.805 .498 .47 r
.57489 .62471 .57581 .62454 .57668 .62742 .57576 .62752 Mtetra
.774 .415 .375 r
.57576 .62752 .57668 .62742 .57753 .62903 .5766 .62909 Mtetra
.525 0 0 r
.5766 .62909 .57753 .62903 .57835 .62943 .57743 .62948 Mtetra
.785 .888 .919 r
.57743 .62948 .57835 .62943 .57915 .62864 .57823 .62869 Mtetra
.854 .757 .754 r
.57823 .62869 .57915 .62864 .57993 .62666 .57901 .62673 Mtetra
.858 .708 .694 r
.57901 .62673 .57993 .62666 .58068 .62344 .57976 .62356 Mtetra
.859 .684 .665 r
.57976 .62356 .58068 .62344 .58141 .61895 .58049 .61913 Mtetra
.859 .671 .647 r
.58049 .61913 .58141 .61895 .58211 .61315 .5812 .61341 Mtetra
.86 .664 .636 r
.5812 .61341 .58211 .61315 .58279 .60607 .58188 .60644 Mtetra
.862 .66 .629 r
.58188 .60644 .58279 .60607 .58344 .59789 .58253 .59839 Mtetra
.865 .66 .624 r
.58253 .59839 .58344 .59789 .58407 .58897 .58317 .58961 Mtetra
.868 .663 .622 r
.58317 .58961 .58407 .58897 .5847 .5799 .5838 .58068 Mtetra
.875 .671 .624 r
.5838 .58068 .5847 .5799 .58534 .5715 .58445 .5724 Mtetra
.887 .69 .631 r
.58445 .5724 .58534 .5715 .58601 .56464 .58512 .56565 Mtetra
.915 .742 .654 r
.58512 .56565 .58601 .56464 .58673 .56018 .58584 .56125 Mtetra
.913 .974 .688 r
.58584 .56125 .58673 .56018 .58751 .55866 .58662 .55975 Mtetra
.686 .384 .458 r
.58662 .55975 .58751 .55866 .58836 .56023 .58747 .56128 Mtetra
.778 .509 .529 r
.58747 .56128 .58836 .56023 .58927 .56456 .58837 .56553 Mtetra
.801 .541 .545 r
.58837 .56553 .58927 .56456 .59022 .57098 .58933 .57184 Mtetra
.811 .554 .55 r
.58933 .57184 .59022 .57098 .59121 .5786 .59031 .57932 Mtetra
.816 .559 .549 r
.59031 .57932 .59121 .5786 .5922 .58654 .5913 .58712 Mtetra
.819 .559 .545 r
.5913 .58712 .5922 .58654 .59319 .59408 .59228 .59452 Mtetra
.82 .555 .538 r
.59228 .59452 .59319 .59408 .59417 .60072 .59325 .60104 Mtetra
.82 .546 .525 r
.59325 .60104 .59417 .60072 .59512 .60616 .5942 .60638 Mtetra
.816 .529 .503 r
.5942 .60638 .59512 .60616 .59604 .6103 .59512 .61044 Mtetra
.807 .495 .462 r
.59512 .61044 .59604 .6103 .59693 .61314 .59601 .61322 Mtetra
.774 .406 .358 r
.59601 .61322 .59693 .61314 .5978 .61471 .59688 .61476 Mtetra
.484 0 0 r
.59688 .61476 .5978 .61471 .59864 .61507 .59772 .6151 Mtetra
.79 .876 .91 r
.59772 .6151 .59864 .61507 .59945 .61423 .59853 .61426 Mtetra
.854 .754 .751 r
.59853 .61426 .59945 .61423 .60024 .6122 .59932 .61225 Mtetra
.859 .707 .693 r
.59932 .61225 .60024 .6122 .60099 .60892 .60007 .60902 Mtetra
.86 .684 .663 r
.60007 .60902 .60099 .60892 .60171 .60436 .6008 .60452 Mtetra
.861 .672 .645 r
.6008 .60452 .60171 .60436 .6024 .59847 .60149 .59873 Mtetra
.862 .664 .634 r
.60149 .59873 .6024 .59847 .60306 .59132 .60215 .59168 Mtetra
.864 .661 .627 r
.60215 .59168 .60306 .59132 .60369 .58306 .60278 .58355 Mtetra
.866 .661 .622 r
.60278 .58355 .60369 .58306 .6043 .57409 .6034 .57472 Mtetra
.87 .664 .621 r
.6034 .57472 .6043 .57409 .6049 .56502 .60401 .56578 Mtetra
.877 .673 .622 r
.60401 .56578 .6049 .56502 .60552 .55664 .60463 .55754 Mtetra
.89 .693 .63 r
.60463 .55754 .60552 .55664 .60618 .54988 .60529 .55087 Mtetra
.919 .749 .654 r
.60529 .55087 .60618 .54988 .60689 .54554 .60601 .5466 Mtetra
.85 .97 .653 r
.60601 .5466 .60689 .54554 .60769 .54419 .6068 .54526 Mtetra
.698 .397 .462 r
.6068 .54526 .60769 .54419 .60856 .54593 .60768 .54696 Mtetra
.781 .511 .527 r
.60768 .54696 .60856 .54593 .60951 .55043 .60862 .55138 Mtetra
.804 .542 .542 r
.60862 .55138 .60951 .55043 .61051 .55698 .60962 .55781 Mtetra
.813 .554 .546 r
.60962 .55781 .61051 .55698 .61155 .56469 .61065 .56538 Mtetra
.819 .559 .546 r
.61065 .56538 .61155 .56469 .6126 .57268 .6117 .57323 Mtetra
.821 .559 .542 r
.6117 .57323 .6126 .57268 .61364 .58024 .61273 .58066 Mtetra
.823 .555 .534 r
.61273 .58066 .61364 .58024 .61466 .58687 .61375 .58717 Mtetra
.822 .545 .52 r
.61375 .58717 .61466 .58687 .61565 .5923 .61474 .59249 Mtetra
.819 .528 .497 r
.61474 .59249 .61565 .5923 .61661 .59642 .61569 .59653 Mtetra
.809 .492 .453 r
.61569 .59653 .61661 .59642 .61753 .59922 .61661 .59928 Mtetra
.774 .396 .341 r
.61661 .59928 .61753 .59922 .61842 .60076 .6175 .60078 Mtetra
.437 0 0 r
.6175 .60078 .61842 .60076 .61928 .60108 .61835 .60108 Mtetra
.794 .867 .903 r
.61835 .60108 .61928 .60108 .6201 .6002 .61918 .60021 Mtetra
.854 .751 .749 r
.61918 .60021 .6201 .6002 .62089 .59811 .61997 .59814 Mtetra
.859 .706 .691 r
.61997 .59814 .62089 .59811 .62164 .59478 .62072 .59485 Mtetra
.861 .684 .661 r
.62072 .59485 .62164 .59478 .62236 .59014 .62144 .59029 Mtetra
.862 .672 .644 r
.62144 .59029 .62236 .59014 .62304 .58418 .62212 .58442 Mtetra
.864 .665 .632 r
.62212 .58442 .62304 .58418 .62368 .57695 .62277 .57729 Mtetra
.866 .662 .625 r
.62277 .57729 .62368 .57695 .62428 .56863 .62338 .5691 Mtetra
.868 .661 .62 r
.62338 .5691 .62428 .56863 .62486 .55961 .62397 .56023 Mtetra
.873 .665 .619 r
.62397 .56023 .62486 .55961 .62544 .55052 .62455 .55128 Mtetra
.88 .674 .621 r
.62455 .55128 .62544 .55052 .62604 .54218 .62515 .54307 Mtetra
.893 .696 .629 r
.62515 .54307 .62604 .54218 .62668 .53551 .6258 .53649 Mtetra
.924 .756 .656 r
.6258 .53649 .62668 .53551 .6274 .53132 .62652 .53236 Mtetra
.738 .93 .586 r
.62652 .53236 .6274 .53132 .62821 .53013 .62733 .53119 Mtetra
.709 .408 .465 r
.62733 .53119 .62821 .53013 .62911 .53206 .62823 .53307 Mtetra
.785 .513 .524 r
.62823 .53307 .62911 .53206 .6301 .53672 .62922 .53765 Mtetra
.806 .542 .539 r
.62922 .53765 .6301 .53672 .63116 .54341 .63027 .54421 Mtetra
.816 .554 .543 r
.63027 .54421 .63116 .54341 .63225 .55122 .63136 .55188 Mtetra
.821 .559 .542 r
.63136 .55188 .63225 .55122 .63336 .55927 .63246 .55979 Mtetra
.824 .558 .538 r
.63246 .55979 .63336 .55927 .63445 .56685 .63354 .56724 Mtetra
.825 .554 .529 r
.63354 .56724 .63445 .56685 .63552 .57349 .63461 .57375 Mtetra
.824 .544 .515 r
.63461 .57375 .63552 .57349 .63655 .5789 .63563 .57907 Mtetra
.821 .526 .49 r
.63563 .57907 .63655 .5789 .63754 .583 .63662 .58308 Mtetra
.811 .488 .444 r
.63662 .58308 .63754 .583 .63849 .58578 .63757 .58581 Mtetra
.773 .387 .323 r
.63757 .58581 .63849 .58578 .6394 .58729 .63848 .58728 Mtetra
.388 0 0 r
.63848 .58728 .6394 .58729 .64028 .58757 .63935 .58755 Mtetra
.796 .859 .896 r
.63935 .58755 .64028 .58757 .64111 .58665 .64019 .58664 Mtetra
.854 .749 .747 r
.64019 .58664 .64111 .58665 .64191 .58451 .64099 .58453 Mtetra
.86 .706 .689 r
.64099 .58453 .64191 .58451 .64266 .58112 .64174 .58118 Mtetra
.862 .684 .66 r
.64174 .58118 .64266 .58112 .64337 .57642 .64245 .57655 Mtetra
.864 .672 .642 r
.64245 .57655 .64337 .57642 .64404 .57039 .64312 .57061 Mtetra
.866 .666 .63 r
.64312 .57061 .64404 .57039 .64465 .56308 .64375 .56341 Mtetra
.868 .662 .623 r
.64375 .56341 .64465 .56308 .64523 .55469 .64433 .55515 Mtetra
.871 .662 .618 r
.64433 .55515 .64523 .55469 .64579 .54563 .64489 .54624 Mtetra
.875 .666 .617 r
.64489 .54624 .64579 .54563 .64634 .53653 .64545 .53728 Mtetra
.882 .676 .619 r
.64545 .53728 .64634 .53653 .64692 .52824 .64603 .52911 Mtetra
.896 .699 .628 r
.64603 .52911 .64692 .52824 .64755 .52166 .64667 .52263 Mtetra
.929 .765 .657 r
.64667 .52263 .64755 .52166 .64827 .51761 .6474 .51864 Mtetra
.565 .831 .475 r
.6474 .51864 .64827 .51761 .6491 .51661 .64822 .51764 Mtetra
.719 .418 .468 r
.64822 .51764 .6491 .51661 .65003 .51872 .64916 .51971 Mtetra
.789 .514 .522 r
.64916 .51971 .65003 .51872 .65107 .52356 .65019 .52446 Mtetra
.809 .543 .536 r
.65019 .52446 .65107 .52356 .65218 .53038 .65129 .53117 Mtetra
.818 .554 .539 r
.65129 .53117 .65218 .53038 .65333 .53829 .65244 .53894 Mtetra
.823 .558 .538 r
.65244 .53894 .65333 .53829 .65449 .54641 .65359 .54691 Mtetra
.826 .558 .534 r
.65359 .54691 .65449 .54641 .65564 .55403 .65473 .55439 Mtetra
.827 .553 .525 r
.65473 .55439 .65564 .55403 .65675 .56067 .65584 .56091 Mtetra
.827 .543 .51 r
.65584 .56091 .65675 .56067 .65783 .56608 .65691 .56622 Mtetra
.823 .524 .484 r
.65691 .56622 .65783 .56608 .65886 .57016 .65794 .57022 Mtetra
.813 .485 .434 r
.65794 .57022 .65886 .57016 .65984 .57292 .65892 .57293 Mtetra
.772 .377 .305 r
.65892 .57293 .65984 .57292 .66078 .5744 .65985 .57438 Mtetra
.339 0 0 r
.65985 .57438 .66078 .5744 .66167 .57466 .66074 .57462 Mtetra
.798 .852 .891 r
.66074 .57462 .66167 .57466 .66251 .5737 .66159 .57367 Mtetra
.855 .748 .745 r
.66159 .57367 .66251 .5737 .66332 .57152 .66239 .57152 Mtetra
.862 .706 .688 r
.66239 .57152 .66332 .57152 .66407 .56807 .66315 .56812 Mtetra
.864 .685 .658 r
.66315 .56812 .66407 .56807 .66477 .5633 .66385 .56342 Mtetra
.866 .673 .64 r
.66385 .56342 .66477 .5633 .66542 .5572 .66451 .55741 Mtetra
.868 .666 .628 r
.66451 .55741 .66542 .5572 .66602 .54982 .66511 .55014 Mtetra
.87 .663 .621 r
.66511 .55014 .66602 .54982 .66657 .54137 .66567 .54182 Mtetra
.873 .663 .616 r
.66567 .54182 .66657 .54137 .6671 .53227 .66621 .53286 Mtetra
.878 .668 .615 r
.66621 .53286 .6671 .53227 .66763 .52317 .66674 .52391 Mtetra
.885 .678 .617 r
.66674 .52391 .66763 .52317 .66818 .51492 .6673 .51579 Mtetra
.9 .702 .627 r
.6673 .51579 .66818 .51492 .6688 .50844 .66793 .50941 Mtetra
.935 .775 .659 r
.66793 .50941 .6688 .50844 .66953 .50454 .66866 .50556 Mtetra
0 0 0 r
.66866 .50556 .66953 .50454 .67037 .50372 .66951 .50475 Mtetra
.729 .428 .47 r
.66951 .50475 .67037 .50372 .67135 .50602 .67048 .507 Mtetra
.792 .516 .52 r
.67048 .507 .67135 .50602 .67243 .51104 .67155 .51193 Mtetra
.811 .543 .533 r
.67155 .51193 .67243 .51104 .6736 .51802 .67271 .51878 Mtetra
.821 .554 .536 r
.67271 .51878 .6736 .51802 .67481 .52603 .67392 .52666 Mtetra
.826 .558 .534 r
.67392 .52666 .67481 .52603 .67603 .53422 .67513 .5347 Mtetra
.828 .557 .529 r
.67513 .5347 .67603 .53422 .67723 .54188 .67633 .54222 Mtetra
.829 .553 .52 r
.67633 .54222 .67723 .54188 .6784 .54853 .67749 .54876 Mtetra
.829 .542 .504 r
.67749 .54876 .6784 .54853 .67952 .55394 .6786 .55407 Mtetra
.825 .522 .477 r
.6786 .55407 .67952 .55394 .68059 .55801 .67967 .55806 Mtetra
.814 .481 .425 r
.67967 .55806 .68059 .55801 .6816 .56076 .68068 .56075 Mtetra
.771 .367 .288 r
.68068 .56075 .6816 .56076 .68256 .56222 .68164 .56218 Mtetra
.292 0 0 r
.68164 .56218 .68256 .56222 .68347 .56245 .68255 .5624 Mtetra
.8 .848 .887 r
.68255 .5624 .68347 .56245 .68433 .56146 .6834 .56142 Mtetra
.856 .748 .744 r
.6834 .56142 .68433 .56146 .68514 .55924 .68421 .55922 Mtetra
.863 .707 .686 r
.68421 .55922 .68514 .55924 .68589 .55573 .68497 .55577 Mtetra
.866 .686 .656 r
.68497 .55577 .68589 .55573 .68658 .55091 .68567 .55102 Mtetra
.868 .674 .638 r
.68567 .55102 .68658 .55091 .68722 .54473 .68631 .54493 Mtetra
.87 .667 .626 r
.68631 .54493 .68722 .54473 .68779 .53728 .68689 .5376 Mtetra
.872 .664 .618 r
.68689 .5376 .68779 .53728 .68832 .52876 .68743 .52921 Mtetra
.876 .665 .614 r
.68743 .52921 .68832 .52876 .68882 .51962 .68793 .52022 Mtetra
.88 .669 .613 r
.68793 .52022 .68882 .51962 .68932 .51052 .68844 .51126 Mtetra
.888 .68 .615 r
.68844 .51126 .68932 .51052 .68986 .50232 .68898 .50318 Mtetra
.903 .706 .626 r
.68898 .50318 .68986 .50232 .69047 .49595 .6896 .49691 Mtetra
.941 .786 .66 r
.6896 .49691 .69047 .49595 .6912 .49221 .69034 .49322 Mtetra
0 0 0 r
.69034 .49322 .6912 .49221 .69207 .49157 .69121 .49259 Mtetra
.737 .436 .471 r
.69121 .49259 .69207 .49157 .69308 .49407 .69221 .49504 Mtetra
.795 .517 .517 r
.69221 .49504 .69308 .49407 .69422 .49927 .69334 .50015 Mtetra
.814 .543 .529 r
.69334 .50015 .69422 .49927 .69544 .5064 .69456 .50715 Mtetra
.823 .554 .532 r
.69456 .50715 .69544 .5064 .69672 .51454 .69583 .51515 Mtetra
.828 .558 .531 r
.69583 .51515 .69672 .51454 .698 .5228 .69711 .52326 Mtetra
.83 .557 .525 r
.69711 .52326 .698 .5228 .69926 .5305 .69836 .53083 Mtetra
.831 .552 .515 r
.69836 .53083 .69926 .5305 .70049 .53717 .69958 .53738 Mtetra
.831 .541 .499 r
.69958 .53738 .70049 .53717 .70165 .54259 .70073 .5427 Mtetra
.827 .52 .471 r
.70073 .5427 .70165 .54259 .70276 .54666 .70184 .54669 Mtetra
.815 .477 .416 r
.70184 .54669 .70276 .54666 .7038 .54939 .70288 .54937 Mtetra
.769 .357 .271 r
.70288 .54937 .7038 .54939 .70479 .55084 .70386 .55079 Mtetra
.25 0 0 r
.70386 .55079 .70479 .55084 .70572 .55104 .70479 .55098 Mtetra
.802 .847 .884 r
.70479 .55098 .70572 .55104 .70659 .55002 .70566 .54997 Mtetra
.857 .749 .743 r
.70566 .54997 .70659 .55002 .7074 .54775 .70648 .54773 Mtetra
.865 .708 .685 r
.70648 .54773 .7074 .54775 .70815 .5442 .70723 .54423 Mtetra
.868 .687 .655 r
.70723 .54423 .70815 .5442 .70884 .53931 .70792 .53941 Mtetra
.87 .675 .636 r
.70792 .53941 .70884 .53931 .70946 .53306 .70855 .53326 Mtetra
.872 .668 .624 r
.70855 .53326 .70946 .53306 .71001 .52553 .70911 .52585 Mtetra
.875 .665 .616 r
.70911 .52585 .71001 .52553 .71051 .51695 .70962 .51741 Mtetra
.878 .666 .612 r
.70962 .51741 .71051 .51695 .71098 .50777 .7101 .50837 Mtetra
.883 .671 .61 r
.7101 .50837 .71098 .50777 .71146 .49867 .71058 .49941 Mtetra
.892 .683 .613 r
.71058 .49941 .71146 .49867 .71197 .49052 .7111 .49139 Mtetra
.908 .711 .624 r
.7111 .49139 .71197 .49052 .71258 .48425 .71172 .48522 Mtetra
.948 .799 .662 r
.71172 .48522 .71258 .48425 .71332 .48067 .71246 .48169 Mtetra
.091 0 0 r
.71246 .48169 .71332 .48067 .71421 .48023 .71335 .48125 Mtetra
.744 .443 .473 r
.71335 .48125 .71421 .48023 .71526 .48294 .7144 .4839 Mtetra
.798 .519 .514 r
.7144 .4839 .71526 .48294 .71645 .48833 .71559 .4892 Mtetra
.816 .543 .526 r
.71559 .4892 .71645 .48833 .71774 .49561 .71687 .49636 Mtetra
.825 .554 .528 r
.71687 .49636 .71774 .49561 .71908 .50387 .7182 .50447 Mtetra
.83 .557 .526 r
.7182 .50447 .71908 .50387 .72043 .51221 .71954 .51266 Mtetra
.832 .556 .521 r
.71954 .51266 .72043 .51221 .72176 .51996 .72086 .52028 Mtetra
.833 .551 .51 r
.72086 .52028 .72176 .51996 .72303 .52666 .72213 .52686 Mtetra
.833 .539 .493 r
.72213 .52686 .72303 .52666 .72425 .53208 .72333 .53218 Mtetra
.829 .518 .464 r
.72333 .53218 .72425 .53208 .72539 .53615 .72447 .53618 Mtetra
.816 .473 .407 r
.72447 .53618 .72539 .53615 .72647 .53887 .72555 .53885 Mtetra
.766 .347 .255 r
.72555 .53885 .72647 .53887 .72748 .5403 .72656 .54025 Mtetra
.211 0 0 r
.72656 .54025 .72748 .5403 .72843 .54049 .72751 .54042 Mtetra
.804 .847 .882 r
.72751 .54042 .72843 .54049 .72932 .53943 .72839 .53938 Mtetra
.86 .751 .741 r
.72839 .53938 .72932 .53943 .73014 .53713 .72921 .5371 Mtetra
.868 .709 .683 r
.72921 .5371 .73014 .53713 .73089 .53352 .72997 .53355 Mtetra
.871 .688 .653 r
.72997 .53355 .73089 .53352 .73156 .52856 .73065 .52867 Mtetra
.873 .676 .634 r
.73065 .52867 .73156 .52856 .73217 .52224 .73126 .52244 Mtetra
.875 .67 .621 r
.73126 .52244 .73217 .52224 .7327 .51463 .7318 .51496 Mtetra
.878 .667 .613 r
.7318 .51496 .7327 .51463 .73317 .50598 .73228 .50645 Mtetra
.881 .668 .609 r
.73228 .50645 .73317 .50598 .73361 .49676 .73273 .49737 Mtetra
.887 .673 .608 r
.73273 .49737 .73361 .49676 .73406 .48765 .73319 .48841 Mtetra
.895 .686 .611 r
.73319 .48841 .73406 .48765 .73455 .47955 .73369 .48044 Mtetra
.913 .716 .623 r
.73369 .48044 .73455 .47955 .73515 .4734 .7343 .47438 Mtetra
.956 .814 .664 r
.7343 .47438 .73515 .4734 .7359 .46998 .73505 .47101 Mtetra
.244 0 .09 r
.73505 .47101 .7359 .46998 .73683 .46974 .73597 .47076 Mtetra
.75 .449 .473 r
.73597 .47076 .73683 .46974 .73792 .47265 .73707 .47361 Mtetra
.801 .52 .512 r
.73707 .47361 .73792 .47265 .73917 .47823 .73831 .4791 Mtetra
.818 .543 .522 r
.73831 .4791 .73917 .47823 .74053 .48568 .73966 .48642 Mtetra
.827 .553 .525 r
.73966 .48642 .74053 .48568 .74194 .49405 .74106 .49465 Mtetra
.832 .556 .522 r
.74106 .49465 .74194 .49405 .74336 .50248 .74247 .50293 Mtetra
.834 .555 .516 r
.74247 .50293 .74336 .50248 .74475 .51028 .74385 .51059 Mtetra
.835 .549 .505 r
.74385 .51059 .74475 .51028 .74608 .51701 .74517 .51721 Mtetra
.834 .537 .487 r
.74517 .51721 .74608 .51701 .74734 .52244 .74643 .52254 Mtetra
.83 .515 .457 r
.74643 .52254 .74734 .52244 .74853 .52651 .74761 .52654 Mtetra
.816 .468 .398 r
.74761 .52654 .74853 .52651 .74964 .52923 .74872 .5292 Mtetra
.762 .336 .239 r
.74872 .5292 .74964 .52923 .75068 .53064 .74976 .53059 Mtetra
.175 0 0 r
.74976 .53059 .75068 .53064 .75165 .5308 .75073 .53074 Mtetra
.808 .849 .88 r
.75073 .53074 .75165 .5308 .75255 .52972 .75162 .52966 Mtetra
.863 .753 .74 r
.75162 .52966 .75255 .52972 .75338 .52737 .75245 .52735 Mtetra
.871 .712 .682 r
.75245 .52735 .75338 .52737 .75412 .5237 .7532 .52374 Mtetra
.874 .69 .65 r
.7532 .52374 .75412 .5237 .75479 .51867 .75388 .51879 Mtetra
.876 .678 .631 r
.75388 .51879 .75479 .51867 .75538 .51227 .75447 .51248 Mtetra
.878 .671 .619 r
.75447 .51248 .75538 .51227 .75589 .50458 .75499 .50492 Mtetra
.881 .669 .611 r
.75499 .50492 .75589 .50458 .75633 .49586 .75544 .49634 Mtetra
.885 .67 .606 r
.75544 .49634 .75633 .49586 .75674 .48659 .75586 .48721 Mtetra
.89 .675 .605 r
.75586 .48721 .75674 .48659 .75716 .47748 .75629 .47825 Mtetra
.9 .689 .609 r
.75629 .47825 .75716 .47748 .75763 .46943 .75678 .47033 Mtetra
.918 .721 .621 r
.75678 .47033 .75763 .46943 .75823 .46339 .75738 .46438 Mtetra
.963 .832 .665 r
.75738 .46438 .75823 .46339 .75899 .46013 .75814 .46117 Mtetra
.355 0 .172 r
.75814 .46117 .75899 .46013 .75994 .46008 .7591 .46111 Mtetra
.756 .454 .474 r
.75